/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEImageElement.h"

#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "SVGFEImageElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEImageElementTableValues[] =
{
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementX), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementY), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementWidth), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHeight), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementResult), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEImageElementTable = { 32, 31, JSSVGFEImageElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEImageElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEImageElementConstructorTable = { 1, 0, JSSVGFEImageElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEImageElementConstructor::s_info = { "SVGFEImageElementConstructor", &Base::s_info, &JSSVGFEImageElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEImageElementConstructor) };

JSSVGFEImageElementConstructor::JSSVGFEImageElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEImageElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGFEImageElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGFEImageElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEImageElementConstructor, JSDOMWrapper>(exec, &JSSVGFEImageElementConstructorTable, jsCast<JSSVGFEImageElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEImageElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEImageElementConstructor, JSDOMWrapper>(exec, &JSSVGFEImageElementConstructorTable, jsCast<JSSVGFEImageElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEImageElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEImageElementPrototypeTable = { 1, 0, JSSVGFEImageElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEImageElementPrototype::s_info = { "SVGFEImageElementPrototype", &Base::s_info, &JSSVGFEImageElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEImageElementPrototype) };

JSObject* JSSVGFEImageElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEImageElement>(exec, globalObject);
}

const ClassInfo JSSVGFEImageElement::s_info = { "SVGFEImageElement", &Base::s_info, &JSSVGFEImageElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEImageElement) };

JSSVGFEImageElement::JSSVGFEImageElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEImageElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEImageElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEImageElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEImageElementPrototype::create(exec->vm(), globalObject, JSSVGFEImageElementPrototype::createStructure(exec->vm(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEImageElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEImageElement* thisObject = jsCast<JSSVGFEImageElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEImageElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEImageElement* thisObject = jsCast<JSSVGFEImageElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEImageElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGFEImageElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGFEImageElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* castedThis = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* impl = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGFEImageElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEImageElement* domObject = jsCast<JSSVGFEImageElement*>(asObject(slotBase));
    return JSSVGFEImageElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEImageElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEImageElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
