/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGColor.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSRGBColor.h"
#include "RGBColor.h"
#include "SVGColor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGColorTableValues[] =
{
    { "colorType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorColorType), (intptr_t)0, NoIntrinsic },
    { "rgbColor", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorRgbColor), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGColorTable = { 8, 7, JSSVGColorTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGColorConstructorTableValues[] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_RGBCOLOR), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_CURRENTCOLOR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGColorConstructorTable = { 8, 7, JSSVGColorConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGColor::SVG_COLORTYPE_UNKNOWN, SVGColorEnumSVG_COLORTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGColor::SVG_COLORTYPE_RGBCOLOR, SVGColorEnumSVG_COLORTYPE_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGColor::SVG_COLORTYPE_RGBCOLOR_ICCCOLOR, SVGColorEnumSVG_COLORTYPE_RGBCOLOR_ICCCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGColor::SVG_COLORTYPE_CURRENTCOLOR, SVGColorEnumSVG_COLORTYPE_CURRENTCOLORIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGColorConstructor::s_info = { "SVGColorConstructor", &Base::s_info, &JSSVGColorConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGColorConstructor) };

JSSVGColorConstructor::JSSVGColorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGColorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGColorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGColorConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGColorConstructor, JSDOMWrapper>(exec, &JSSVGColorConstructorTable, jsCast<JSSVGColorConstructor*>(cell), propertyName, slot);
}

bool JSSVGColorConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGColorConstructor, JSDOMWrapper>(exec, &JSSVGColorConstructorTable, jsCast<JSSVGColorConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGColorPrototypeTableValues[] =
{
    { "SVG_COLORTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_RGBCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_RGBCOLOR), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_RGBCOLOR_ICCCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR), (intptr_t)0, NoIntrinsic },
    { "SVG_COLORTYPE_CURRENTCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGColorSVG_COLORTYPE_CURRENTCOLOR), (intptr_t)0, NoIntrinsic },
    { "setRGBColor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetRGBColor), (intptr_t)1, NoIntrinsic },
    { "setRGBColorICCColor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetRGBColorICCColor), (intptr_t)2, NoIntrinsic },
    { "setColor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGColorPrototypeFunctionSetColor), (intptr_t)3, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGColorPrototypeTable = { 17, 15, JSSVGColorPrototypeTableValues, 0 };
const ClassInfo JSSVGColorPrototype::s_info = { "SVGColorPrototype", &Base::s_info, &JSSVGColorPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGColorPrototype) };

JSObject* JSSVGColorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGColor>(exec, globalObject);
}

bool JSSVGColorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGColorPrototype* thisObject = jsCast<JSSVGColorPrototype*>(cell);
    return getStaticPropertySlot<JSSVGColorPrototype, JSObject>(exec, &JSSVGColorPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGColorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGColorPrototype* thisObject = jsCast<JSSVGColorPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGColorPrototype, JSObject>(exec, &JSSVGColorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGColor::s_info = { "SVGColor", &Base::s_info, &JSSVGColorTable, 0 , CREATE_METHOD_TABLE(JSSVGColor) };

JSSVGColor::JSSVGColor(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGColor> impl)
    : JSCSSValue(structure, globalObject, impl)
{
}

void JSSVGColor::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGColor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGColorPrototype::create(exec->vm(), globalObject, JSSVGColorPrototype::createStructure(exec->vm(), globalObject, JSCSSValuePrototype::self(exec, globalObject)));
}

bool JSSVGColor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGColor* thisObject = jsCast<JSSVGColor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGColor, Base>(exec, &JSSVGColorTable, thisObject, propertyName, slot);
}

bool JSSVGColor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGColor* thisObject = jsCast<JSSVGColor*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGColor, Base>(exec, &JSSVGColorTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGColorColorType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGColor* castedThis = jsCast<JSSVGColor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGColor* impl = static_cast<SVGColor*>(castedThis->impl());
    JSValue result = jsNumber(impl->colorType());
    return result;
}


JSValue jsSVGColorRgbColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGColor* castedThis = jsCast<JSSVGColor*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGColor* impl = static_cast<SVGColor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rgbColor()));
    return result;
}


JSValue jsSVGColorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGColor* domObject = jsCast<JSSVGColor*>(asObject(slotBase));
    return JSSVGColor::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGColor::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGColorConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwVMTypeError(exec);
    JSSVGColor* castedThis = jsCast<JSSVGColor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGColor::s_info);
    SVGColor* impl = static_cast<SVGColor*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& rgbColor(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRGBColor(rgbColor, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetRGBColorICCColor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwVMTypeError(exec);
    JSSVGColor* castedThis = jsCast<JSSVGColor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGColor::s_info);
    SVGColor* impl = static_cast<SVGColor*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& rgbColor(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& iccColor(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRGBColorICCColor(rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGColorPrototypeFunctionSetColor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGColor::s_info))
        return throwVMTypeError(exec);
    JSSVGColor* castedThis = jsCast<JSSVGColor*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGColor::s_info);
    SVGColor* impl = static_cast<SVGColor*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned short colorType(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& rgbColor(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& iccColor(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setColor(colorType, rgbColor, iccColor, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsSVGColorSVG_COLORTYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGColorSVG_COLORTYPE_RGBCOLOR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGColorSVG_COLORTYPE_RGBCOLOR_ICCCOLOR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGColorSVG_COLORTYPE_CURRENTCOLOR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
