/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGClipPathElement.h"

#include "JSSVGAnimatedEnumeration.h"
#include "SVGClipPathElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGClipPathElementTableValues[] =
{
    { "clipPathUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementClipPathUnits), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementTable = { 10, 7, JSSVGClipPathElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGClipPathElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementConstructorTable = { 1, 0, JSSVGClipPathElementConstructorTableValues, 0 };
const ClassInfo JSSVGClipPathElementConstructor::s_info = { "SVGClipPathElementConstructor", &Base::s_info, &JSSVGClipPathElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGClipPathElementConstructor) };

JSSVGClipPathElementConstructor::JSSVGClipPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGClipPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGClipPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGClipPathElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGClipPathElementConstructor, JSDOMWrapper>(exec, &JSSVGClipPathElementConstructorTable, jsCast<JSSVGClipPathElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGClipPathElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGClipPathElementConstructor, JSDOMWrapper>(exec, &JSSVGClipPathElementConstructorTable, jsCast<JSSVGClipPathElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGClipPathElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementPrototypeTable = { 1, 0, JSSVGClipPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGClipPathElementPrototype::s_info = { "SVGClipPathElementPrototype", &Base::s_info, &JSSVGClipPathElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGClipPathElementPrototype) };

JSObject* JSSVGClipPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGClipPathElement>(exec, globalObject);
}

const ClassInfo JSSVGClipPathElement::s_info = { "SVGClipPathElement", &Base::s_info, &JSSVGClipPathElementTable, 0 , CREATE_METHOD_TABLE(JSSVGClipPathElement) };

JSSVGClipPathElement::JSSVGClipPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGClipPathElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGClipPathElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGClipPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGClipPathElementPrototype::create(exec->vm(), globalObject, JSSVGClipPathElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGClipPathElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGClipPathElement* thisObject = jsCast<JSSVGClipPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGClipPathElement, Base>(exec, &JSSVGClipPathElementTable, thisObject, propertyName, slot);
}

bool JSSVGClipPathElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGClipPathElement* thisObject = jsCast<JSSVGClipPathElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGClipPathElement, Base>(exec, &JSSVGClipPathElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGClipPathElementClipPathUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->clipPathUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGClipPathElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGClipPathElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* domObject = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    return JSSVGClipPathElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGClipPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGClipPathElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
