/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedNumberList.h"

#include "JSSVGNumberList.h"
#include "SVGNumberList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedNumberListTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedNumberListBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedNumberListAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedNumberListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedNumberListTable = { 8, 7, JSSVGAnimatedNumberListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedNumberListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedNumberListConstructorTable = { 1, 0, JSSVGAnimatedNumberListConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedNumberListConstructor::s_info = { "SVGAnimatedNumberListConstructor", &Base::s_info, &JSSVGAnimatedNumberListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedNumberListConstructor) };

JSSVGAnimatedNumberListConstructor::JSSVGAnimatedNumberListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedNumberListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAnimatedNumberListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAnimatedNumberListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedNumberListConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedNumberListConstructorTable, jsCast<JSSVGAnimatedNumberListConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedNumberListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedNumberListConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedNumberListConstructorTable, jsCast<JSSVGAnimatedNumberListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedNumberListPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedNumberListPrototypeTable = { 1, 0, JSSVGAnimatedNumberListPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedNumberListPrototype::s_info = { "SVGAnimatedNumberListPrototype", &Base::s_info, &JSSVGAnimatedNumberListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedNumberListPrototype) };

JSObject* JSSVGAnimatedNumberListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedNumberList>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedNumberList::s_info = { "SVGAnimatedNumberList", &Base::s_info, &JSSVGAnimatedNumberListTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedNumberList) };

JSSVGAnimatedNumberList::JSSVGAnimatedNumberList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedNumberList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedNumberList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedNumberList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedNumberListPrototype::create(exec->vm(), globalObject, JSSVGAnimatedNumberListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedNumberList::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedNumberList* thisObject = static_cast<JSSVGAnimatedNumberList*>(cell);
    thisObject->JSSVGAnimatedNumberList::~JSSVGAnimatedNumberList();
}

JSSVGAnimatedNumberList::~JSSVGAnimatedNumberList()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedNumberList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedNumberList* thisObject = jsCast<JSSVGAnimatedNumberList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedNumberList, Base>(exec, &JSSVGAnimatedNumberListTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedNumberList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedNumberList* thisObject = jsCast<JSSVGAnimatedNumberList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedNumberList, Base>(exec, &JSSVGAnimatedNumberListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedNumberListBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedNumberList* castedThis = jsCast<JSSVGAnimatedNumberList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedNumberList* impl = static_cast<SVGAnimatedNumberList*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGListPropertyTearOff<SVGNumberList>*>(impl->baseVal().get())));
    return result;
}


JSValue jsSVGAnimatedNumberListAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedNumberList* castedThis = jsCast<JSSVGAnimatedNumberList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedNumberList* impl = static_cast<SVGAnimatedNumberList*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGListPropertyTearOff<SVGNumberList>*>(impl->animVal().get())));
    return result;
}


JSValue jsSVGAnimatedNumberListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedNumberList* domObject = jsCast<JSSVGAnimatedNumberList*>(asObject(slotBase));
    return JSSVGAnimatedNumberList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedNumberList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedNumberListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedNumberList* jsSVGAnimatedNumberList)
{
    if (jsSVGAnimatedNumberList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedNumberListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedNumberList* jsSVGAnimatedNumberList = jsCast<JSSVGAnimatedNumberList*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedNumberList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedNumberListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedNumberList* jsSVGAnimatedNumberList = jsCast<JSSVGAnimatedNumberList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedNumberList->impl(), jsSVGAnimatedNumberList);
    jsSVGAnimatedNumberList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedNumberList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedNumberList>(exec, impl))
        return result;
    ReportMemoryCost<SVGAnimatedNumberList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGAnimatedNumberList>(exec, globalObject, impl);
}

SVGAnimatedNumberList* toSVGAnimatedNumberList(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedNumberList::s_info) ? jsCast<JSSVGAnimatedNumberList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
