/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSMediaController_h
#define JSMediaController_h

#if ENABLE(VIDEO)

#include "JSDOMBinding.h"
#include "MediaController.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSMediaController : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSMediaController* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaController> impl)
    {
        JSMediaController* ptr = new (NotNull, JSC::allocateCell<JSMediaController>(globalObject->vm().heap)) JSMediaController(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSMediaController();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    MediaController* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    MediaController* m_impl;
protected:
    JSMediaController(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<MediaController>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSMediaControllerOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, MediaController*)
{
    DEFINE_STATIC_LOCAL(JSMediaControllerOwner, jsMediaControllerOwner, ());
    return &jsMediaControllerOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, MediaController*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, MediaController*);
MediaController* toMediaController(JSC::JSValue);

class JSMediaControllerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSMediaControllerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaControllerPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaControllerPrototype>(vm.heap)) JSMediaControllerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSMediaControllerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesVisitChildren | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSMediaControllerConstructor : public DOMConstructorObject {
private:
    JSMediaControllerConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSMediaControllerConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSMediaControllerConstructor* ptr = new (NotNull, JSC::allocateCell<JSMediaControllerConstructor>(*exec->heap())) JSMediaControllerConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSMediaController(JSC::ExecState*);
    static JSC::ConstructType getConstructData(JSC::JSCell*, JSC::ConstructData&);
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPlay(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionPause(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionUnpause(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControllerPrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsMediaControllerBuffered(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerSeekable(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerDuration(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerCurrentTime(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaControllerCurrentTime(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaControllerPaused(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerPlayed(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerPlaybackState(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsMediaControllerDefaultPlaybackRate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaControllerDefaultPlaybackRate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaControllerPlaybackRate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaControllerPlaybackRate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaControllerVolume(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaControllerVolume(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaControllerMuted(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSMediaControllerMuted(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsMediaControllerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(VIDEO)

#endif
