/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeTypeArray.h"

#include "DOMMimeType.h"
#include "DOMMimeTypeArray.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMMimeType.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMMimeTypeArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypeArrayTable = { 5, 3, JSDOMMimeTypeArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMMimeTypeArrayConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypeArrayConstructorTable = { 1, 0, JSDOMMimeTypeArrayConstructorTableValues, 0 };
const ClassInfo JSDOMMimeTypeArrayConstructor::s_info = { "MimeTypeArrayConstructor", &Base::s_info, &JSDOMMimeTypeArrayConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeArrayConstructor) };

JSDOMMimeTypeArrayConstructor::JSDOMMimeTypeArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMMimeTypeArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDOMMimeTypeArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDOMMimeTypeArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMMimeTypeArrayConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeArrayConstructorTable, jsCast<JSDOMMimeTypeArrayConstructor*>(cell), propertyName, slot);
}

bool JSDOMMimeTypeArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMMimeTypeArrayConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeArrayConstructorTable, jsCast<JSDOMMimeTypeArrayConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypeArrayPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMMimeTypeArrayPrototypeFunctionItem), (intptr_t)0, NoIntrinsic },
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMMimeTypeArrayPrototypeFunctionNamedItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMMimeTypeArrayPrototypeTable = { 5, 3, JSDOMMimeTypeArrayPrototypeTableValues, 0 };
const ClassInfo JSDOMMimeTypeArrayPrototype::s_info = { "MimeTypeArrayPrototype", &Base::s_info, &JSDOMMimeTypeArrayPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMMimeTypeArrayPrototype) };

JSObject* JSDOMMimeTypeArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMMimeTypeArray>(exec, globalObject);
}

bool JSDOMMimeTypeArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMMimeTypeArrayPrototype* thisObject = jsCast<JSDOMMimeTypeArrayPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMMimeTypeArrayPrototypeTable, thisObject, propertyName, slot);
}

bool JSDOMMimeTypeArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMMimeTypeArrayPrototype* thisObject = jsCast<JSDOMMimeTypeArrayPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMMimeTypeArrayPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDOMMimeTypeArray::s_info = { "MimeTypeArray", &Base::s_info, &JSDOMMimeTypeArrayTable, 0 , CREATE_METHOD_TABLE(JSDOMMimeTypeArray) };

JSDOMMimeTypeArray::JSDOMMimeTypeArray(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMMimeTypeArray> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMMimeTypeArray::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMMimeTypeArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMMimeTypeArrayPrototype::create(exec->vm(), globalObject, JSDOMMimeTypeArrayPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMMimeTypeArray::destroy(JSC::JSCell* cell)
{
    JSDOMMimeTypeArray* thisObject = static_cast<JSDOMMimeTypeArray*>(cell);
    thisObject->JSDOMMimeTypeArray::~JSDOMMimeTypeArray();
}

JSDOMMimeTypeArray::~JSDOMMimeTypeArray()
{
    releaseImplIfNotNull();
}

bool JSDOMMimeTypeArray::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMMimeTypeArray* thisObject = jsCast<JSDOMMimeTypeArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSDOMMimeTypeArray>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMMimeTypeArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMMimeTypeArray*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMMimeTypeArray, Base>(exec, &JSDOMMimeTypeArrayTable, thisObject, propertyName, slot);
}

bool JSDOMMimeTypeArray::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMMimeTypeArray* thisObject = jsCast<JSDOMMimeTypeArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSDOMMimeTypeArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<DOMMimeTypeArray*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMMimeTypeArray*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMMimeTypeArray, Base>(exec, &JSDOMMimeTypeArrayTable, thisObject, propertyName, descriptor);
}

bool JSDOMMimeTypeArray::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSDOMMimeTypeArray* thisObject = jsCast<JSDOMMimeTypeArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<DOMMimeTypeArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<DOMMimeTypeArray*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsDOMMimeTypeArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeTypeArray* castedThis = jsCast<JSDOMMimeTypeArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeTypeArray* impl = static_cast<DOMMimeTypeArray*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsDOMMimeTypeArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMMimeTypeArray* domObject = jsCast<JSDOMMimeTypeArray*>(asObject(slotBase));
    return JSDOMMimeTypeArray::getConstructor(exec, domObject->globalObject());
}

void JSDOMMimeTypeArray::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSDOMMimeTypeArray* thisObject = jsCast<JSDOMMimeTypeArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<DOMMimeTypeArray*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSDOMMimeTypeArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMMimeTypeArray::s_info))
        return throwVMTypeError(exec);
    JSDOMMimeTypeArray* castedThis = jsCast<JSDOMMimeTypeArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMMimeTypeArray::s_info);
    DOMMimeTypeArray* impl = static_cast<DOMMimeTypeArray*>(castedThis->impl());
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMMimeTypeArrayPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMMimeTypeArray::s_info))
        return throwVMTypeError(exec);
    JSDOMMimeTypeArray* castedThis = jsCast<JSDOMMimeTypeArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMMimeTypeArray::s_info);
    DOMMimeTypeArray* impl = static_cast<DOMMimeTypeArray*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->namedItem(name)));
    return JSValue::encode(result);
}


JSValue JSDOMMimeTypeArray::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMMimeTypeArray* thisObj = jsCast<JSDOMMimeTypeArray*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<DOMMimeTypeArray*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSDOMMimeTypeArray* jsDOMMimeTypeArray)
{
    if (jsDOMMimeTypeArray->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMMimeTypeArrayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMMimeTypeArray* jsDOMMimeTypeArray = jsCast<JSDOMMimeTypeArray*>(handle.get().asCell());
    if (!isObservable(jsDOMMimeTypeArray))
        return false;
    Frame* root = jsDOMMimeTypeArray->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSDOMMimeTypeArrayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMMimeTypeArray* jsDOMMimeTypeArray = jsCast<JSDOMMimeTypeArray*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMMimeTypeArray->impl(), jsDOMMimeTypeArray);
    jsDOMMimeTypeArray->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMimeTypeArray@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16DOMMimeTypeArrayE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMMimeTypeArray* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMMimeTypeArray>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMMimeTypeArray@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16DOMMimeTypeArrayE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails DOMMimeTypeArray does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMMimeTypeArray), DOMMimeTypeArray_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMMimeTypeArray has subclasses. If DOMMimeTypeArray has subclasses that get passed
    // to toJS() we currently require DOMMimeTypeArray you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DOMMimeTypeArray>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMMimeTypeArray>(exec, globalObject, impl);
}

DOMMimeTypeArray* toDOMMimeTypeArray(JSC::JSValue value)
{
    return value.inherits(&JSDOMMimeTypeArray::s_info) ? jsCast<JSDOMMimeTypeArray*>(asObject(value))->impl() : 0;
}

}
