/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathResult.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "KURL.h"
#include "Node.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathResultTableValues[] =
{
    { "resultType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultResultType), (intptr_t)0, NoIntrinsic },
    { "numberValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultNumberValue), (intptr_t)0, NoIntrinsic },
    { "stringValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultStringValue), (intptr_t)0, NoIntrinsic },
    { "booleanValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultBooleanValue), (intptr_t)0, NoIntrinsic },
    { "singleNodeValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSingleNodeValue), (intptr_t)0, NoIntrinsic },
    { "invalidIteratorState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultInvalidIteratorState), (intptr_t)0, NoIntrinsic },
    { "snapshotLength", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSnapshotLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathResultTable = { 18, 15, JSXPathResultTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSXPathResultConstructorTableValues[] =
{
    { "ANY_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultANY_TYPE), (intptr_t)0, NoIntrinsic },
    { "NUMBER_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultNUMBER_TYPE), (intptr_t)0, NoIntrinsic },
    { "STRING_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSTRING_TYPE), (intptr_t)0, NoIntrinsic },
    { "BOOLEAN_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultBOOLEAN_TYPE), (intptr_t)0, NoIntrinsic },
    { "UNORDERED_NODE_ITERATOR_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultUNORDERED_NODE_ITERATOR_TYPE), (intptr_t)0, NoIntrinsic },
    { "ORDERED_NODE_ITERATOR_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultORDERED_NODE_ITERATOR_TYPE), (intptr_t)0, NoIntrinsic },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE), (intptr_t)0, NoIntrinsic },
    { "ORDERED_NODE_SNAPSHOT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultORDERED_NODE_SNAPSHOT_TYPE), (intptr_t)0, NoIntrinsic },
    { "ANY_UNORDERED_NODE_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultANY_UNORDERED_NODE_TYPE), (intptr_t)0, NoIntrinsic },
    { "FIRST_ORDERED_NODE_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultFIRST_ORDERED_NODE_TYPE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathResultConstructorTable = { 33, 31, JSXPathResultConstructorTableValues, 0 };

COMPILE_ASSERT(0 == XPathResult::ANY_TYPE, XPathResultEnumANY_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == XPathResult::NUMBER_TYPE, XPathResultEnumNUMBER_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == XPathResult::STRING_TYPE, XPathResultEnumSTRING_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == XPathResult::BOOLEAN_TYPE, XPathResultEnumBOOLEAN_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == XPathResult::UNORDERED_NODE_ITERATOR_TYPE, XPathResultEnumUNORDERED_NODE_ITERATOR_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == XPathResult::ORDERED_NODE_ITERATOR_TYPE, XPathResultEnumORDERED_NODE_ITERATOR_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == XPathResult::UNORDERED_NODE_SNAPSHOT_TYPE, XPathResultEnumUNORDERED_NODE_SNAPSHOT_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == XPathResult::ORDERED_NODE_SNAPSHOT_TYPE, XPathResultEnumORDERED_NODE_SNAPSHOT_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == XPathResult::ANY_UNORDERED_NODE_TYPE, XPathResultEnumANY_UNORDERED_NODE_TYPEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == XPathResult::FIRST_ORDERED_NODE_TYPE, XPathResultEnumFIRST_ORDERED_NODE_TYPEIsWrongUseDoNotCheckConstants);

const ClassInfo JSXPathResultConstructor::s_info = { "XPathResultConstructor", &Base::s_info, &JSXPathResultConstructorTable, 0, CREATE_METHOD_TABLE(JSXPathResultConstructor) };

JSXPathResultConstructor::JSXPathResultConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSXPathResultConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSXPathResultPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSXPathResultConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResultConstructor, JSDOMWrapper>(exec, &JSXPathResultConstructorTable, jsCast<JSXPathResultConstructor*>(cell), propertyName, slot);
}

bool JSXPathResultConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXPathResultConstructor, JSDOMWrapper>(exec, &JSXPathResultConstructorTable, jsCast<JSXPathResultConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSXPathResultPrototypeTableValues[] =
{
    { "ANY_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultANY_TYPE), (intptr_t)0, NoIntrinsic },
    { "NUMBER_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultNUMBER_TYPE), (intptr_t)0, NoIntrinsic },
    { "STRING_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSTRING_TYPE), (intptr_t)0, NoIntrinsic },
    { "BOOLEAN_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultBOOLEAN_TYPE), (intptr_t)0, NoIntrinsic },
    { "UNORDERED_NODE_ITERATOR_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultUNORDERED_NODE_ITERATOR_TYPE), (intptr_t)0, NoIntrinsic },
    { "ORDERED_NODE_ITERATOR_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultORDERED_NODE_ITERATOR_TYPE), (intptr_t)0, NoIntrinsic },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE), (intptr_t)0, NoIntrinsic },
    { "ORDERED_NODE_SNAPSHOT_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultORDERED_NODE_SNAPSHOT_TYPE), (intptr_t)0, NoIntrinsic },
    { "ANY_UNORDERED_NODE_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultANY_UNORDERED_NODE_TYPE), (intptr_t)0, NoIntrinsic },
    { "FIRST_ORDERED_NODE_TYPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultFIRST_ORDERED_NODE_TYPE), (intptr_t)0, NoIntrinsic },
    { "iterateNext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathResultPrototypeFunctionIterateNext), (intptr_t)0, NoIntrinsic },
    { "snapshotItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsXPathResultPrototypeFunctionSnapshotItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSXPathResultPrototypeTable = { 33, 31, JSXPathResultPrototypeTableValues, 0 };
const ClassInfo JSXPathResultPrototype::s_info = { "XPathResultPrototype", &Base::s_info, &JSXPathResultPrototypeTable, 0, CREATE_METHOD_TABLE(JSXPathResultPrototype) };

JSObject* JSXPathResultPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathResult>(exec, globalObject);
}

bool JSXPathResultPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathResultPrototype* thisObject = jsCast<JSXPathResultPrototype*>(cell);
    return getStaticPropertySlot<JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, thisObject, propertyName, slot);
}

bool JSXPathResultPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathResultPrototype* thisObject = jsCast<JSXPathResultPrototype*>(object);
    return getStaticPropertyDescriptor<JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSXPathResult::s_info = { "XPathResult", &Base::s_info, &JSXPathResultTable, 0 , CREATE_METHOD_TABLE(JSXPathResult) };

JSXPathResult::JSXPathResult(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<XPathResult> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSXPathResult::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSXPathResult::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSXPathResultPrototype::create(exec->vm(), globalObject, JSXPathResultPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSXPathResult::destroy(JSC::JSCell* cell)
{
    JSXPathResult* thisObject = static_cast<JSXPathResult*>(cell);
    thisObject->JSXPathResult::~JSXPathResult();
}

JSXPathResult::~JSXPathResult()
{
    releaseImplIfNotNull();
}

bool JSXPathResult::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSXPathResult* thisObject = jsCast<JSXPathResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSXPathResult, Base>(exec, &JSXPathResultTable, thisObject, propertyName, slot);
}

bool JSXPathResult::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSXPathResult* thisObject = jsCast<JSXPathResult*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSXPathResult, Base>(exec, &JSXPathResultTable, thisObject, propertyName, descriptor);
}

JSValue jsXPathResultResultType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSValue result = jsNumber(impl->resultType());
    return result;
}


JSValue jsXPathResultNumberValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->numberValue(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsXPathResultStringValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSC::JSValue result = jsStringWithCache(exec, impl->stringValue(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsXPathResultBooleanValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSC::JSValue result = jsBoolean(impl->booleanValue(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsXPathResultSingleNodeValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->singleNodeValue(ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue jsXPathResultInvalidIteratorState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSValue result = jsBoolean(impl->invalidIteratorState());
    return result;
}


JSValue jsXPathResultSnapshotLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->snapshotLength(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsXPathResultConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSXPathResult* domObject = jsCast<JSXPathResult*>(asObject(slotBase));
    return JSXPathResult::getConstructor(exec, domObject->globalObject());
}

JSValue JSXPathResult::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathResultConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionIterateNext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathResult::s_info))
        return throwVMTypeError(exec);
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathResult::s_info);
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->iterateNext(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionSnapshotItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSXPathResult::s_info))
        return throwVMTypeError(exec);
    JSXPathResult* castedThis = jsCast<JSXPathResult*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSXPathResult::s_info);
    XPathResult* impl = static_cast<XPathResult*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->snapshotItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

// Constant getters

JSValue jsXPathResultANY_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsXPathResultNUMBER_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsXPathResultSTRING_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsXPathResultBOOLEAN_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsXPathResultUNORDERED_NODE_ITERATOR_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsXPathResultORDERED_NODE_ITERATOR_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsXPathResultUNORDERED_NODE_SNAPSHOT_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsXPathResultORDERED_NODE_SNAPSHOT_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsXPathResultANY_UNORDERED_NODE_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsXPathResultFIRST_ORDERED_NODE_TYPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(9));
}

static inline bool isObservable(JSXPathResult* jsXPathResult)
{
    if (jsXPathResult->hasCustomProperties())
        return true;
    return false;
}

bool JSXPathResultOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSXPathResult* jsXPathResult = jsCast<JSXPathResult*>(handle.get().asCell());
    if (!isObservable(jsXPathResult))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathResultOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSXPathResult* jsXPathResult = jsCast<JSXPathResult*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXPathResult->impl(), jsXPathResult);
    jsXPathResult->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XPathResult* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathResult>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathResult.
    COMPILE_ASSERT(!__is_polymorphic(XPathResult), XPathResult_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<XPathResult>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSXPathResult>(exec, globalObject, impl);
}

XPathResult* toXPathResult(JSC::JSValue value)
{
    return value.inherits(&JSXPathResult::s_info) ? jsCast<JSXPathResult*>(asObject(value))->impl() : 0;
}

}
