/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLProgram.h"

#include "WebGLProgram.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLProgramTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLProgramConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLProgramTable = { 2, 1, JSWebGLProgramTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLProgramConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLProgramConstructorTable = { 1, 0, JSWebGLProgramConstructorTableValues, 0 };
const ClassInfo JSWebGLProgramConstructor::s_info = { "WebGLProgramConstructor", &Base::s_info, &JSWebGLProgramConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLProgramConstructor) };

JSWebGLProgramConstructor::JSWebGLProgramConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLProgramConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSWebGLProgramPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSWebGLProgramConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLProgramConstructor, JSDOMWrapper>(exec, &JSWebGLProgramConstructorTable, jsCast<JSWebGLProgramConstructor*>(cell), propertyName, slot);
}

bool JSWebGLProgramConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLProgramConstructor, JSDOMWrapper>(exec, &JSWebGLProgramConstructorTable, jsCast<JSWebGLProgramConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebGLProgramPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLProgramPrototypeTable = { 1, 0, JSWebGLProgramPrototypeTableValues, 0 };
const ClassInfo JSWebGLProgramPrototype::s_info = { "WebGLProgramPrototype", &Base::s_info, &JSWebGLProgramPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLProgramPrototype) };

JSObject* JSWebGLProgramPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLProgram>(exec, globalObject);
}

const ClassInfo JSWebGLProgram::s_info = { "WebGLProgram", &Base::s_info, &JSWebGLProgramTable, 0 , CREATE_METHOD_TABLE(JSWebGLProgram) };

JSWebGLProgram::JSWebGLProgram(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLProgram> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLProgram::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLProgram::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLProgramPrototype::create(exec->vm(), globalObject, JSWebGLProgramPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLProgram::destroy(JSC::JSCell* cell)
{
    JSWebGLProgram* thisObject = static_cast<JSWebGLProgram*>(cell);
    thisObject->JSWebGLProgram::~JSWebGLProgram();
}

JSWebGLProgram::~JSWebGLProgram()
{
    releaseImplIfNotNull();
}

bool JSWebGLProgram::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLProgram* thisObject = jsCast<JSWebGLProgram*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLProgram, Base>(exec, &JSWebGLProgramTable, thisObject, propertyName, slot);
}

bool JSWebGLProgram::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLProgram* thisObject = jsCast<JSWebGLProgram*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLProgram, Base>(exec, &JSWebGLProgramTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLProgramConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLProgram* domObject = jsCast<JSWebGLProgram*>(asObject(slotBase));
    return JSWebGLProgram::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLProgram::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLProgramConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSWebGLProgram* jsWebGLProgram)
{
    if (jsWebGLProgram->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLProgramOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLProgram* jsWebGLProgram = jsCast<JSWebGLProgram*>(handle.get().asCell());
    if (!isObservable(jsWebGLProgram))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLProgramOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLProgram* jsWebGLProgram = jsCast<JSWebGLProgram*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLProgram->impl(), jsWebGLProgram);
    jsWebGLProgram->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLProgram@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGLProgramE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLProgram* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLProgram>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLProgram@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGLProgramE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails WebGLProgram does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLProgram), WebGLProgram_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLProgram has subclasses. If WebGLProgram has subclasses that get passed
    // to toJS() we currently require WebGLProgram you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<WebGLProgram>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSWebGLProgram>(exec, globalObject, impl);
}

WebGLProgram* toWebGLProgram(JSC::JSValue value)
{
    return value.inherits(&JSWebGLProgram::s_info) ? jsCast<JSWebGLProgram*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
