/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSVideoTrack.h"

#include "Element.h"
#include "JSNodeCustom.h"
#include "KURL.h"
#include "VideoTrack.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSVideoTrackTableValues[] =
{
    { "id", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackId), (intptr_t)0, NoIntrinsic },
    { "kind", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackKind), (intptr_t)0, NoIntrinsic },
    { "label", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLabel), (intptr_t)0, NoIntrinsic },
    { "language", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackLanguage), (intptr_t)0, NoIntrinsic },
    { "selected", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsVideoTrackSelected), (intptr_t)setJSVideoTrackSelected, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSVideoTrackTable = { 16, 15, JSVideoTrackTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSVideoTrackPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSVideoTrackPrototypeTable = { 1, 0, JSVideoTrackPrototypeTableValues, 0 };
const ClassInfo JSVideoTrackPrototype::s_info = { "VideoTrackPrototype", &Base::s_info, &JSVideoTrackPrototypeTable, 0, CREATE_METHOD_TABLE(JSVideoTrackPrototype) };

JSObject* JSVideoTrackPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSVideoTrack>(exec, globalObject);
}

const ClassInfo JSVideoTrack::s_info = { "VideoTrack", &Base::s_info, &JSVideoTrackTable, 0 , CREATE_METHOD_TABLE(JSVideoTrack) };

JSVideoTrack::JSVideoTrack(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<VideoTrack> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSVideoTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSVideoTrack::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSVideoTrackPrototype::create(exec->vm(), globalObject, JSVideoTrackPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSVideoTrack::destroy(JSC::JSCell* cell)
{
    JSVideoTrack* thisObject = static_cast<JSVideoTrack*>(cell);
    thisObject->JSVideoTrack::~JSVideoTrack();
}

JSVideoTrack::~JSVideoTrack()
{
    releaseImplIfNotNull();
}

bool JSVideoTrack::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSVideoTrack* thisObject = jsCast<JSVideoTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSVideoTrack, Base>(exec, &JSVideoTrackTable, thisObject, propertyName, slot);
}

bool JSVideoTrack::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSVideoTrack* thisObject = jsCast<JSVideoTrack*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSVideoTrack, Base>(exec, &JSVideoTrackTable, thisObject, propertyName, descriptor);
}

JSValue jsVideoTrackId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->id());
    return result;
}


JSValue jsVideoTrackKind(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->kind());
    return result;
}


JSValue jsVideoTrackLabel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->label());
    return result;
}


JSValue jsVideoTrackLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->language());
    return result;
}


JSValue jsVideoTrackSelected(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    JSValue result = jsBoolean(impl->selected());
    return result;
}


void JSVideoTrack::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSVideoTrack* thisObject = jsCast<JSVideoTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSVideoTrack, Base>(exec, propertyName, value, &JSVideoTrackTable, thisObject, slot);
}

void setJSVideoTrackSelected(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSVideoTrack* castedThis = jsCast<JSVideoTrack*>(thisObject);
    VideoTrack* impl = static_cast<VideoTrack*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setSelected(nativeValue);
}


static inline bool isObservable(JSVideoTrack* jsVideoTrack)
{
    if (jsVideoTrack->hasCustomProperties())
        return true;
    return false;
}

bool JSVideoTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSVideoTrack* jsVideoTrack = jsCast<JSVideoTrack*>(handle.get().asCell());
    if (!isObservable(jsVideoTrack))
        return false;
    Element* element = jsVideoTrack->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSVideoTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSVideoTrack* jsVideoTrack = jsCast<JSVideoTrack*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsVideoTrack->impl(), jsVideoTrack);
    jsVideoTrack->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10VideoTrackE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, VideoTrack* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSVideoTrack>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7VideoTrack@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10VideoTrackE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails VideoTrack does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(VideoTrack), VideoTrack_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // VideoTrack has subclasses. If VideoTrack has subclasses that get passed
    // to toJS() we currently require VideoTrack you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<VideoTrack>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSVideoTrack>(exec, globalObject, impl);
}

VideoTrack* toVideoTrack(JSC::JSValue value)
{
    return value.inherits(&JSVideoTrack::s_info) ? jsCast<JSVideoTrack*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO_TRACK)
