/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSwitchElement.h"

#include "SVGSwitchElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGSwitchElementTableValues[] =
{
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSwitchElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementTable = { 5, 3, JSSVGSwitchElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGSwitchElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementConstructorTable = { 1, 0, JSSVGSwitchElementConstructorTableValues, 0 };
const ClassInfo JSSVGSwitchElementConstructor::s_info = { "SVGSwitchElementConstructor", &Base::s_info, &JSSVGSwitchElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGSwitchElementConstructor) };

JSSVGSwitchElementConstructor::JSSVGSwitchElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGSwitchElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGSwitchElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGSwitchElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSwitchElementConstructor, JSDOMWrapper>(exec, &JSSVGSwitchElementConstructorTable, jsCast<JSSVGSwitchElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGSwitchElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSwitchElementConstructor, JSDOMWrapper>(exec, &JSSVGSwitchElementConstructorTable, jsCast<JSSVGSwitchElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSwitchElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSwitchElementPrototypeTable = { 1, 0, JSSVGSwitchElementPrototypeTableValues, 0 };
const ClassInfo JSSVGSwitchElementPrototype::s_info = { "SVGSwitchElementPrototype", &Base::s_info, &JSSVGSwitchElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGSwitchElementPrototype) };

JSObject* JSSVGSwitchElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSwitchElement>(exec, globalObject);
}

const ClassInfo JSSVGSwitchElement::s_info = { "SVGSwitchElement", &Base::s_info, &JSSVGSwitchElementTable, 0 , CREATE_METHOD_TABLE(JSSVGSwitchElement) };

JSSVGSwitchElement::JSSVGSwitchElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSwitchElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGSwitchElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGSwitchElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGSwitchElementPrototype::create(exec->vm(), globalObject, JSSVGSwitchElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGSwitchElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSwitchElement* thisObject = jsCast<JSSVGSwitchElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, thisObject, propertyName, slot);
}

bool JSSVGSwitchElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSwitchElement* thisObject = jsCast<JSSVGSwitchElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGSwitchElement, Base>(exec, &JSSVGSwitchElementTable, thisObject, propertyName, descriptor);
}

#if ENABLE(SVG)
JSValue jsSVGSwitchElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* castedThis = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSwitchElement* impl = static_cast<SVGSwitchElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGSwitchElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSwitchElement* domObject = jsCast<JSSVGSwitchElement*>(asObject(slotBase));
    return JSSVGSwitchElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGSwitchElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSwitchElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
