/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SQL_DATABASE)

#include "JSSQLError.h"

#include "KURL.h"
#include "SQLError.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSQLErrorTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorCode), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorMessage), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSQLErrorTable = { 4, 3, JSSQLErrorTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSQLErrorPrototypeTableValues[] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorUNKNOWN_ERR), (intptr_t)0, NoIntrinsic },
    { "DATABASE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorDATABASE_ERR), (intptr_t)0, NoIntrinsic },
    { "VERSION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorVERSION_ERR), (intptr_t)0, NoIntrinsic },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorTOO_LARGE_ERR), (intptr_t)0, NoIntrinsic },
    { "QUOTA_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorQUOTA_ERR), (intptr_t)0, NoIntrinsic },
    { "SYNTAX_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorSYNTAX_ERR), (intptr_t)0, NoIntrinsic },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorCONSTRAINT_ERR), (intptr_t)0, NoIntrinsic },
    { "TIMEOUT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorTIMEOUT_ERR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSQLErrorPrototypeTable = { 16, 15, JSSQLErrorPrototypeTableValues, 0 };
static const HashTable* getJSSQLErrorPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSSQLErrorPrototypeTable);
}

const ClassInfo JSSQLErrorPrototype::s_info = { "SQLErrorPrototype", &Base::s_info, 0, getJSSQLErrorPrototypeTable, CREATE_METHOD_TABLE(JSSQLErrorPrototype) };

JSObject* JSSQLErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLError>(exec, globalObject);
}

bool JSSQLErrorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSQLErrorPrototype* thisObject = jsCast<JSSQLErrorPrototype*>(cell);
    return getStaticValueSlot<JSSQLErrorPrototype, JSObject>(exec, getJSSQLErrorPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSSQLErrorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSQLErrorPrototype* thisObject = jsCast<JSSQLErrorPrototype*>(object);
    return getStaticValueDescriptor<JSSQLErrorPrototype, JSObject>(exec, getJSSQLErrorPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSSQLErrorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSSQLErrorTable);
}

const ClassInfo JSSQLError::s_info = { "SQLError", &Base::s_info, 0, getJSSQLErrorTable , CREATE_METHOD_TABLE(JSSQLError) };

JSSQLError::JSSQLError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SQLError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSQLError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSQLError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSQLErrorPrototype::create(exec->vm(), globalObject, JSSQLErrorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSQLError::destroy(JSC::JSCell* cell)
{
    JSSQLError* thisObject = static_cast<JSSQLError*>(cell);
    thisObject->JSSQLError::~JSSQLError();
}

JSSQLError::~JSSQLError()
{
    releaseImplIfNotNull();
}

bool JSSQLError::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSQLError* thisObject = jsCast<JSSQLError*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSQLError, Base>(exec, getJSSQLErrorTable(exec), thisObject, propertyName, slot);
}

bool JSSQLError::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSQLError* thisObject = jsCast<JSSQLError*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSQLError, Base>(exec, getJSSQLErrorTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsSQLErrorCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSQLError* castedThis = jsCast<JSSQLError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLError* impl = static_cast<SQLError*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsSQLErrorMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSQLError* castedThis = jsCast<JSSQLError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SQLError* impl = static_cast<SQLError*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


// Constant getters

JSValue jsSQLErrorUNKNOWN_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSQLErrorDATABASE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSQLErrorVERSION_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSQLErrorTOO_LARGE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSQLErrorQUOTA_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSQLErrorSYNTAX_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSQLErrorCONSTRAINT_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsSQLErrorTIMEOUT_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

static inline bool isObservable(JSSQLError* jsSQLError)
{
    if (jsSQLError->hasCustomProperties())
        return true;
    return false;
}

bool JSSQLErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSQLError* jsSQLError = jsCast<JSSQLError*>(handle.get().asCell());
    if (!isObservable(jsSQLError))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSQLError* jsSQLError = jsCast<JSSQLError*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSQLError->impl(), jsSQLError);
    jsSQLError->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SQLError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLError>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLError.
    COMPILE_ASSERT(!__is_polymorphic(SQLError), SQLError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<SQLError>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSQLError>(exec, globalObject, impl);
}

SQLError* toSQLError(JSC::JSValue value)
{
    return value.inherits(&JSSQLError::s_info) ? jsCast<JSSQLError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SQL_DATABASE)
