/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformanceNavigation.h"

#include "PerformanceNavigation.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPerformanceNavigationTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationType), (intptr_t)0, NoIntrinsic },
    { "redirectCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationRedirectCount), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceNavigationTable = { 9, 7, JSPerformanceNavigationTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSPerformanceNavigationConstructorTableValues[] =
{
    { "TYPE_NAVIGATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_NAVIGATE), (intptr_t)0, NoIntrinsic },
    { "TYPE_RELOAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RELOAD), (intptr_t)0, NoIntrinsic },
    { "TYPE_BACK_FORWARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_BACK_FORWARD), (intptr_t)0, NoIntrinsic },
    { "TYPE_RESERVED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RESERVED), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceNavigationConstructorTable = { 9, 7, JSPerformanceNavigationConstructorTableValues, 0 };

COMPILE_ASSERT(0 == PerformanceNavigation::TYPE_NAVIGATE, PerformanceNavigationEnumTYPE_NAVIGATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == PerformanceNavigation::TYPE_RELOAD, PerformanceNavigationEnumTYPE_RELOADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == PerformanceNavigation::TYPE_BACK_FORWARD, PerformanceNavigationEnumTYPE_BACK_FORWARDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(255 == PerformanceNavigation::TYPE_RESERVED, PerformanceNavigationEnumTYPE_RESERVEDIsWrongUseDoNotCheckConstants);

const ClassInfo JSPerformanceNavigationConstructor::s_info = { "PerformanceNavigationConstructor", &Base::s_info, &JSPerformanceNavigationConstructorTable, 0, CREATE_METHOD_TABLE(JSPerformanceNavigationConstructor) };

JSPerformanceNavigationConstructor::JSPerformanceNavigationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPerformanceNavigationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSPerformanceNavigationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSPerformanceNavigationConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPerformanceNavigationConstructor, JSDOMWrapper>(exec, &JSPerformanceNavigationConstructorTable, jsCast<JSPerformanceNavigationConstructor*>(cell), propertyName, slot);
}

bool JSPerformanceNavigationConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPerformanceNavigationConstructor, JSDOMWrapper>(exec, &JSPerformanceNavigationConstructorTable, jsCast<JSPerformanceNavigationConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPerformanceNavigationPrototypeTableValues[] =
{
    { "TYPE_NAVIGATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_NAVIGATE), (intptr_t)0, NoIntrinsic },
    { "TYPE_RELOAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RELOAD), (intptr_t)0, NoIntrinsic },
    { "TYPE_BACK_FORWARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_BACK_FORWARD), (intptr_t)0, NoIntrinsic },
    { "TYPE_RESERVED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceNavigationTYPE_RESERVED), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceNavigationPrototypeTable = { 9, 7, JSPerformanceNavigationPrototypeTableValues, 0 };
const ClassInfo JSPerformanceNavigationPrototype::s_info = { "PerformanceNavigationPrototype", &Base::s_info, &JSPerformanceNavigationPrototypeTable, 0, CREATE_METHOD_TABLE(JSPerformanceNavigationPrototype) };

JSObject* JSPerformanceNavigationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformanceNavigation>(exec, globalObject);
}

bool JSPerformanceNavigationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformanceNavigationPrototype* thisObject = jsCast<JSPerformanceNavigationPrototype*>(cell);
    return getStaticValueSlot<JSPerformanceNavigationPrototype, JSObject>(exec, &JSPerformanceNavigationPrototypeTable, thisObject, propertyName, slot);
}

bool JSPerformanceNavigationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformanceNavigationPrototype* thisObject = jsCast<JSPerformanceNavigationPrototype*>(object);
    return getStaticValueDescriptor<JSPerformanceNavigationPrototype, JSObject>(exec, &JSPerformanceNavigationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSPerformanceNavigation::s_info = { "PerformanceNavigation", &Base::s_info, &JSPerformanceNavigationTable, 0 , CREATE_METHOD_TABLE(JSPerformanceNavigation) };

JSPerformanceNavigation::JSPerformanceNavigation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PerformanceNavigation> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPerformanceNavigation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformanceNavigation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPerformanceNavigationPrototype::create(exec->vm(), globalObject, JSPerformanceNavigationPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSPerformanceNavigation::destroy(JSC::JSCell* cell)
{
    JSPerformanceNavigation* thisObject = static_cast<JSPerformanceNavigation*>(cell);
    thisObject->JSPerformanceNavigation::~JSPerformanceNavigation();
}

JSPerformanceNavigation::~JSPerformanceNavigation()
{
    releaseImplIfNotNull();
}

bool JSPerformanceNavigation::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformanceNavigation* thisObject = jsCast<JSPerformanceNavigation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPerformanceNavigation, Base>(exec, &JSPerformanceNavigationTable, thisObject, propertyName, slot);
}

bool JSPerformanceNavigation::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformanceNavigation* thisObject = jsCast<JSPerformanceNavigation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPerformanceNavigation, Base>(exec, &JSPerformanceNavigationTable, thisObject, propertyName, descriptor);
}

JSValue jsPerformanceNavigationType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceNavigation* castedThis = jsCast<JSPerformanceNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceNavigation* impl = static_cast<PerformanceNavigation*>(castedThis->impl());
    JSValue result = jsNumber(impl->type());
    return result;
}


JSValue jsPerformanceNavigationRedirectCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceNavigation* castedThis = jsCast<JSPerformanceNavigation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceNavigation* impl = static_cast<PerformanceNavigation*>(castedThis->impl());
    JSValue result = jsNumber(impl->redirectCount());
    return result;
}


JSValue jsPerformanceNavigationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceNavigation* domObject = jsCast<JSPerformanceNavigation*>(asObject(slotBase));
    return JSPerformanceNavigation::getConstructor(exec, domObject->globalObject());
}

JSValue JSPerformanceNavigation::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceNavigationConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsPerformanceNavigationTYPE_NAVIGATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsPerformanceNavigationTYPE_RELOAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsPerformanceNavigationTYPE_BACK_FORWARD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsPerformanceNavigationTYPE_RESERVED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(255));
}

static inline bool isObservable(JSPerformanceNavigation* jsPerformanceNavigation)
{
    if (jsPerformanceNavigation->hasCustomProperties())
        return true;
    return false;
}

bool JSPerformanceNavigationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPerformanceNavigation* jsPerformanceNavigation = jsCast<JSPerformanceNavigation*>(handle.get().asCell());
    if (!isObservable(jsPerformanceNavigation))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceNavigationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPerformanceNavigation* jsPerformanceNavigation = jsCast<JSPerformanceNavigation*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformanceNavigation->impl(), jsPerformanceNavigation);
    jsPerformanceNavigation->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceNavigation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21PerformanceNavigationE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PerformanceNavigation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformanceNavigation>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PerformanceNavigation@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21PerformanceNavigationE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails PerformanceNavigation does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PerformanceNavigation), PerformanceNavigation_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PerformanceNavigation has subclasses. If PerformanceNavigation has subclasses that get passed
    // to toJS() we currently require PerformanceNavigation you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<PerformanceNavigation>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSPerformanceNavigation>(exec, globalObject, impl);
}

PerformanceNavigation* toPerformanceNavigation(JSC::JSValue value)
{
    return value.inherits(&JSPerformanceNavigation::s_info) ? jsCast<JSPerformanceNavigation*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
