/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLSourceElement.h"

#include "HTMLNames.h"
#include "HTMLSourceElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLSourceElementTableValues[] =
{
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementSrc), (intptr_t)setJSHTMLSourceElementSrc, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementType), (intptr_t)setJSHTMLSourceElementType, NoIntrinsic },
    { "media", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementMedia), (intptr_t)setJSHTMLSourceElementMedia, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSourceElementTable = { 9, 7, JSHTMLSourceElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLSourceElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSourceElementConstructorTable = { 1, 0, JSHTMLSourceElementConstructorTableValues, 0 };
const ClassInfo JSHTMLSourceElementConstructor::s_info = { "HTMLSourceElementConstructor", &Base::s_info, &JSHTMLSourceElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLSourceElementConstructor) };

JSHTMLSourceElementConstructor::JSHTMLSourceElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLSourceElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLSourceElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLSourceElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSourceElementConstructor, JSDOMWrapper>(exec, &JSHTMLSourceElementConstructorTable, jsCast<JSHTMLSourceElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLSourceElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSourceElementConstructor, JSDOMWrapper>(exec, &JSHTMLSourceElementConstructorTable, jsCast<JSHTMLSourceElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLSourceElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSourceElementPrototypeTable = { 1, 0, JSHTMLSourceElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLSourceElementPrototype::s_info = { "HTMLSourceElementPrototype", &Base::s_info, &JSHTMLSourceElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLSourceElementPrototype) };

JSObject* JSHTMLSourceElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSourceElement>(exec, globalObject);
}

const ClassInfo JSHTMLSourceElement::s_info = { "HTMLSourceElement", &Base::s_info, &JSHTMLSourceElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLSourceElement) };

JSHTMLSourceElement::JSHTMLSourceElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLSourceElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLSourceElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLSourceElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLSourceElementPrototype::create(exec->vm(), globalObject, JSHTMLSourceElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSourceElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLSourceElement* thisObject = jsCast<JSHTMLSourceElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLSourceElement, Base>(exec, &JSHTMLSourceElementTable, thisObject, propertyName, slot);
}

bool JSHTMLSourceElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLSourceElement* thisObject = jsCast<JSHTMLSourceElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLSourceElement, Base>(exec, &JSHTMLSourceElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLSourceElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLSourceElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLSourceElementMedia(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->media());
    return result;
}


JSValue jsHTMLSourceElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSourceElement* domObject = jsCast<JSHTMLSourceElement*>(asObject(slotBase));
    return JSHTMLSourceElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLSourceElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLSourceElement* thisObject = jsCast<JSHTMLSourceElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLSourceElement, Base>(exec, propertyName, value, &JSHTMLSourceElementTable, thisObject, slot);
}

void setJSHTMLSourceElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::srcAttr, nativeValue);
}


void setJSHTMLSourceElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setType(nativeValue);
}


void setJSHTMLSourceElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSourceElement* castedThis = jsCast<JSHTMLSourceElement*>(thisObject);
    HTMLSourceElement* impl = static_cast<HTMLSourceElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setMedia(nativeValue);
}


JSValue JSHTMLSourceElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSourceElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(VIDEO)
