/* math-equation.c generated by valac 0.36.5, the Vala compiler
 * generated from math-equation.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <langinfo.h>
#include <gdk/gdk.h>


#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_MATH_EQUATION_STATE (math_equation_state_get_type ())
#define MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION_STATE, MathEquationState))
#define MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))
#define IS_MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION_STATE))
#define IS_MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION_STATE))
#define MATH_EQUATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))

typedef struct _MathEquationState MathEquationState;
typedef struct _MathEquationStateClass MathEquationStateClass;
typedef struct _MathEquationStatePrivate MathEquationStatePrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SOLVE_DATA (solve_data_get_type ())
#define SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_DATA, SolveData))
#define SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_DATA, SolveDataClass))
#define IS_SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_DATA))
#define IS_SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_DATA))
#define SOLVE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_DATA, SolveDataClass))

typedef struct _SolveData SolveData;
typedef struct _SolveDataClass SolveDataClass;
typedef struct _SolveDataPrivate SolveDataPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
typedef struct _MathEquationPrivate MathEquationPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_MEQUATION (mequation_get_type ())
#define MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEQUATION, MEquation))
#define MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEQUATION, MEquationClass))
#define IS_MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEQUATION))
#define IS_MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEQUATION))
#define MEQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEQUATION, MEquationClass))

typedef struct _MEquation MEquation;
typedef struct _MEquationClass MEquationClass;
typedef struct _EquationPrivate EquationPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
enum  {
	MATH_EQUATION_HISTORY_SIGNAL_SIGNAL,
	MATH_EQUATION_LAST_SIGNAL
};
static guint math_equation_signals[MATH_EQUATION_LAST_SIGNAL] = {0};
typedef struct _MEquationPrivate MEquationPrivate;

#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;

struct _MathEquationState {
	GObject parent_instance;
	MathEquationStatePrivate * priv;
	Number* ans;
	guint ans_base;
	gchar* expression;
	gint ans_start;
	gint ans_end;
	gint cursor;
	NumberMode number_mode;
	gboolean can_super_minus;
	gboolean entered_multiply;
	gchar* status;
	guint error_token_start;
	guint error_token_end;
};

struct _MathEquationStateClass {
	GObjectClass parent_class;
};

struct _SolveData {
	GObject parent_instance;
	SolveDataPrivate * priv;
	Number* number_result;
	gchar* text_result;
	gchar* error;
	guint error_start;
	guint error_end;
	guint representation_base;
};

struct _SolveDataClass {
	GObjectClass parent_class;
};

struct _MathEquation {
	GtkSourceBuffer parent_instance;
	MathEquationPrivate * priv;
};

struct _MathEquationClass {
	GtkSourceBufferClass parent_class;
};

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _MathEquationPrivate {
	GtkTextTag* ans_tag;
	gint _word_size;
	gchar* _source_currency;
	gchar* _target_currency;
	gchar* _source_units;
	gchar* _target_units;
	AngleUnit _angle_units;
	NumberMode _number_mode;
	gboolean can_super_minus;
	gunichar digits[16];
	GtkTextMark* ans_start_mark;
	GtkTextMark* ans_end_mark;
	MathEquationState* state;
	GList* undo_stack;
	GList* redo_stack;
	gboolean in_undo_operation;
	gboolean in_reformat;
	gboolean in_delete;
	gboolean _in_solve;
	MathVariables* _variables;
	Serializer* _serializer;
	GAsyncQueue* queue;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _Equation {
	GObject parent_instance;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GObjectClass parent_class;
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	gboolean (*unit_is_defined) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _MEquation {
	Equation parent_instance;
	MEquationPrivate * priv;
};

struct _MEquationClass {
	EquationClass parent_class;
};

struct _MEquationPrivate {
	MathEquation* m_equation;
};


static gpointer math_equation_state_parent_class = NULL;
static gpointer solve_data_parent_class = NULL;
static gpointer math_equation_parent_class = NULL;
static gpointer mequation_parent_class = NULL;

GType number_mode_get_type (void) G_GNUC_CONST;
GType math_equation_state_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
enum  {
	MATH_EQUATION_STATE_DUMMY_PROPERTY
};
MathEquationState* math_equation_state_new (void);
MathEquationState* math_equation_state_construct (GType object_type);
static void math_equation_state_finalize (GObject * obj);
GType solve_data_get_type (void) G_GNUC_CONST;
enum  {
	SOLVE_DATA_DUMMY_PROPERTY
};
SolveData* solve_data_new (void);
SolveData* solve_data_construct (GType object_type);
static void solve_data_finalize (GObject * obj);
GType math_equation_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
GType math_variables_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define MATH_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_EQUATION, MathEquationPrivate))
enum  {
	MATH_EQUATION_DUMMY_PROPERTY,
	MATH_EQUATION_WORD_SIZE,
	MATH_EQUATION_SOURCE_CURRENCY,
	MATH_EQUATION_TARGET_CURRENCY,
	MATH_EQUATION_SOURCE_UNITS,
	MATH_EQUATION_TARGET_UNITS,
	MATH_EQUATION_DISPLAY,
	MATH_EQUATION_IN_SOLVE,
	MATH_EQUATION_VARIABLES,
	MATH_EQUATION_SERIALIZER,
	MATH_EQUATION_ACCURACY,
	MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS,
	MATH_EQUATION_SHOW_TRAILING_ZEROES,
	MATH_EQUATION_NUMBER_FORMAT,
	MATH_EQUATION_NUMBER_BASE,
	MATH_EQUATION_ANGLE_UNITS,
	MATH_EQUATION_STATUS,
	MATH_EQUATION_ERROR_TOKEN_START,
	MATH_EQUATION_ERROR_TOKEN_END,
	MATH_EQUATION_IS_EMPTY,
	MATH_EQUATION_IS_RESULT,
	MATH_EQUATION_EQUATION,
	MATH_EQUATION_NUMBER,
	MATH_EQUATION_NUMBER_MODE,
	MATH_EQUATION_ANSWER
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathEquation* math_equation_new (void);
MathEquation* math_equation_construct (GType object_type);
MathVariables* math_variables_new (void);
MathVariables* math_variables_construct (GType object_type);
void math_equation_set_word_size (MathEquation* self, gint value);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
Number* number_new_integer (gint64 real, gint64 imag);
Number* number_construct_integer (GType object_type, gint64 real, gint64 imag);
void math_equation_display_selected (MathEquation* self, const gchar* selected);
static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end);
static void math_equation_reformat_ans (MathEquation* self);
Serializer* math_equation_get_serializer (MathEquation* self);
gchar* serializer_to_string (Serializer* self, Number* x);
void math_equation_remove_trailing_spaces (MathEquation* self);
static void math_equation_reformat_separators (MathEquation* self);
gchar* math_equation_get_display (MathEquation* self);
gint math_equation_get_number_base (MathEquation* self);
gboolean serializer_get_show_thousands_separators (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index);
gunichar serializer_get_thousands_separator (Serializer* self);
gunichar serializer_get_radix (Serializer* self);
static void math_equation_reformat_display (MathEquation* self);
static MathEquationState* math_equation_get_current_state (MathEquation* self);
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_equation_push_undo_stack (MathEquation* self);
void math_equation_set_status (MathEquation* self, const gchar* value);
static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag);
static void math_equation_apply_state (MathEquation* self, MathEquationState* s);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text);
static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self);
void math_equation_insert (MathEquation* self, const gchar* text);
static void math_equation_real_undo (GtkSourceBuffer* base);
static void math_equation_real_redo (GtkSourceBuffer* base);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
void math_equation_store (MathEquation* self, const gchar* name);
Number* math_equation_get_number (MathEquation* self);
MathVariables* math_equation_get_variables (MathEquation* self);
void math_variables_set (MathVariables* self, const gchar* name, Number* value);
void math_equation_recall (MathEquation* self, const gchar* name);
void math_equation_set (MathEquation* self, const gchar* text);
void math_equation_set_number (MathEquation* self, Number* x, guint representation_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
gint serializer_get_base (Serializer* self);
const gchar* serializer_get_error (Serializer* self);
void serializer_set_error (Serializer* self, const gchar* value);
void math_equation_insert_selected (MathEquation* self, const gchar* answer);
void math_equation_insert_square (MathEquation* self);
void math_equation_insert_digit (MathEquation* self, guint digit);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_insert_subtract (MathEquation* self);
GType error_code_get_type (void) G_GNUC_CONST;
static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar* * error_token, guint** error_start, guint* error_end);
GType equation_get_type (void) G_GNUC_CONST;
GType mequation_get_type (void) G_GNUC_CONST;
MEquation* mequation_new (MathEquation* m_equation, const gchar* equation);
MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation);
gint math_equation_get_word_size (MathEquation* self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar* * error_token, guint** error_start, guint** error_end);
static void* math_equation_solve_real (MathEquation* self);
gchar* math_equation_get_equation (MathEquation* self);
const gchar* number_get_error (void);
static gboolean math_equation_show_in_progress (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
static gboolean math_equation_look_for_answer (MathEquation* self);
static void math_equation_error_token_fix_thousands_separator (MathEquation* self);
static void math_equation_error_token_fix_parenthesis (MathEquation* self);
void math_equation_solve (MathEquation* self);
gboolean math_equation_get_is_empty (MathEquation* self);
gboolean math_equation_get_is_result (MathEquation* self);
static gpointer _math_equation_solve_real_gthread_func (gpointer self);
static gboolean _math_equation_look_for_answer_gsource_func (gpointer self);
static gboolean _math_equation_show_in_progress_gsource_func (gpointer self);
guint math_equation_get_error_token_start (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
static void* math_equation_factorize_real (MathEquation* self);
GList* number_factorize (Number* self);
void math_equation_factorize (MathEquation* self);
gboolean number_is_integer (Number* self);
static gpointer _math_equation_factorize_real_gthread_func (gpointer self);
void math_equation_delete_next (MathEquation* self);
void math_equation_backspace (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_shift (MathEquation* self, gint count);
Number* number_shift (Number* self, gint count);
void math_equation_toggle_bit (MathEquation* self, guint bit);
Number* number_new_unsigned_integer (guint64 real, guint64 imag);
Number* number_construct_unsigned_integer (GType object_type, guint64 real, guint64 imag);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
guint64 number_to_unsigned_integer (Number* self);
static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len);
static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end);
static gboolean __lambda10_ (MathEquation* self);
static gboolean ___lambda10__gsource_func (gpointer self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gint math_equation_get_accuracy (MathEquation* self);
gint serializer_get_trailing_digits (Serializer* self);
void math_equation_set_accuracy (MathEquation* self, gint value);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
DisplayFormat math_equation_get_number_format (MathEquation* self);
DisplayFormat serializer_get_number_format (Serializer* self);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
void math_equation_set_number_base (MathEquation* self, gint value);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_base (Serializer* self, gint number_base);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
gchar* math_equation_get_status (MathEquation* self);
Number* math_equation_get_answer (MathEquation* self);
Number* serializer_from_string (Serializer* self, const gchar* str);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void math_equation_finalize (GObject * obj);
static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define MEQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEQUATION, MEquationPrivate))
enum  {
	MEQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name);
Number* math_variables_get (MathVariables* self, const gchar* name);
static Number* mequation_real_get_variable (Equation* base, const gchar* name);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x);
static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
GType unit_manager_get_type (void) G_GNUC_CONST;
UnitManager* unit_manager_get_default (void);
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
static void mequation_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType number_mode_get_type (void) {
	static volatile gsize number_mode_type_id__volatile = 0;
	if (g_once_init_enter (&number_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{NUMBER_MODE_NORMAL, "NUMBER_MODE_NORMAL", "normal"}, {NUMBER_MODE_SUPERSCRIPT, "NUMBER_MODE_SUPERSCRIPT", "superscript"}, {NUMBER_MODE_SUBSCRIPT, "NUMBER_MODE_SUBSCRIPT", "subscript"}, {0, NULL, NULL}};
		GType number_mode_type_id;
		number_mode_type_id = g_enum_register_static ("NumberMode", values);
		g_once_init_leave (&number_mode_type_id__volatile, number_mode_type_id);
	}
	return number_mode_type_id__volatile;
}


MathEquationState* math_equation_state_construct (GType object_type) {
	MathEquationState * self = NULL;
	self = (MathEquationState*) g_object_new (object_type, NULL);
	return self;
}


MathEquationState* math_equation_state_new (void) {
	return math_equation_state_construct (TYPE_MATH_EQUATION_STATE);
}


static void math_equation_state_class_init (MathEquationStateClass * klass) {
	math_equation_state_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = math_equation_state_finalize;
}


static void math_equation_state_instance_init (MathEquationState * self) {
}


static void math_equation_state_finalize (GObject * obj) {
	MathEquationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION_STATE, MathEquationState);
	_g_object_unref0 (self->ans);
	_g_free0 (self->expression);
	_g_free0 (self->status);
	G_OBJECT_CLASS (math_equation_state_parent_class)->finalize (obj);
}


GType math_equation_state_get_type (void) {
	static volatile gsize math_equation_state_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquationState), 0, (GInstanceInitFunc) math_equation_state_instance_init, NULL };
		GType math_equation_state_type_id;
		math_equation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "MathEquationState", &g_define_type_info, 0);
		g_once_init_leave (&math_equation_state_type_id__volatile, math_equation_state_type_id);
	}
	return math_equation_state_type_id__volatile;
}


SolveData* solve_data_construct (GType object_type) {
	SolveData * self = NULL;
	self = (SolveData*) g_object_new (object_type, NULL);
	return self;
}


SolveData* solve_data_new (void) {
	return solve_data_construct (TYPE_SOLVE_DATA);
}


static void solve_data_class_init (SolveDataClass * klass) {
	solve_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = solve_data_finalize;
}


static void solve_data_instance_init (SolveData * self) {
}


static void solve_data_finalize (GObject * obj) {
	SolveData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOLVE_DATA, SolveData);
	_g_object_unref0 (self->number_result);
	_g_free0 (self->text_result);
	_g_free0 (self->error);
	G_OBJECT_CLASS (solve_data_parent_class)->finalize (obj);
}


GType solve_data_get_type (void) {
	static volatile gsize solve_data_type_id__volatile = 0;
	if (g_once_init_enter (&solve_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveData), 0, (GInstanceInitFunc) solve_data_instance_init, NULL };
		GType solve_data_type_id;
		solve_data_type_id = g_type_register_static (G_TYPE_OBJECT, "SolveData", &g_define_type_info, 0);
		g_once_init_leave (&solve_data_type_id__volatile, solve_data_type_id);
	}
	return solve_data_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MathEquation* math_equation_construct (GType object_type) {
	MathEquation * self = NULL;
	gboolean use_default_digits = FALSE;
	static const gunichar default_digits[] = {(gunichar) '0', (gunichar) '1', (gunichar) '2', (gunichar) '3', (gunichar) '4', (gunichar) '5', (gunichar) '6', (gunichar) '7', (gunichar) '8', (gunichar) '9', (gunichar) 'A', (gunichar) 'B', (gunichar) 'C', (gunichar) 'D', (gunichar) 'E', (gunichar) 'F'};
	gchar** ds = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint ds_length1;
	gint _ds_size_;
	MathVariables* _tmp20_;
	MathEquationState* _tmp21_;
	MathEquationState* _tmp22_;
	gchar* _tmp23_;
	Serializer* _tmp24_;
	GAsyncQueue* _tmp25_;
	MathEquationState* _tmp26_;
	Number* _tmp27_;
	MathEquationState* _tmp28_;
	GtkTextTag* _tmp29_;
	GtkTextTag* _tmp30_;
	self = (MathEquation*) g_object_new (object_type, NULL);
	__g_list_free__g_object_unref0_0 (self->priv->undo_stack);
	self->priv->undo_stack = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
	self->priv->redo_stack = NULL;
	use_default_digits = TRUE;
	_tmp1_ = _tmp0_ = g_strsplit (_ ("0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F"), ",", -1);
	ds = _tmp1_;
	ds_length1 = _vala_array_length (_tmp0_);
	_ds_size_ = ds_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 16)) {
					break;
				}
				_tmp6_ = use_default_digits;
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					const gchar* _tmp9_;
					_tmp7_ = ds;
					_tmp7__length1 = ds_length1;
					_tmp8_ = i;
					_tmp9_ = _tmp7_[_tmp8_];
					_tmp5_ = _tmp9_ == NULL;
				}
				if (_tmp5_) {
					gint _tmp10_;
					gint _tmp11_;
					gunichar _tmp12_;
					gunichar _tmp13_;
					use_default_digits = TRUE;
					_tmp10_ = i;
					_tmp11_ = i;
					_tmp12_ = default_digits[_tmp11_];
					self->priv->digits[_tmp10_] = _tmp12_;
					_tmp13_ = self->priv->digits[_tmp10_];
				} else {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					const gchar* _tmp17_;
					gunichar _tmp18_;
					gunichar _tmp19_;
					_tmp14_ = i;
					_tmp15_ = ds;
					_tmp15__length1 = ds_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp18_ = string_get_char (_tmp17_, (glong) 0);
					self->priv->digits[_tmp14_] = _tmp18_;
					_tmp19_ = self->priv->digits[_tmp14_];
				}
			}
		}
	}
	_tmp20_ = math_variables_new ();
	_g_object_unref0 (self->priv->_variables);
	self->priv->_variables = _tmp20_;
	_tmp21_ = math_equation_state_new ();
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp21_;
	_tmp22_ = self->priv->state;
	_tmp23_ = g_strdup ("");
	_g_free0 (_tmp22_->status);
	_tmp22_->status = _tmp23_;
	math_equation_set_word_size (self, 32);
	self->priv->_angle_units = ANGLE_UNIT_DEGREES;
	math_equation_set_source_currency (self, "");
	math_equation_set_target_currency (self, "");
	math_equation_set_source_units (self, "");
	math_equation_set_target_units (self, "");
	_tmp24_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	_g_object_unref0 (self->priv->_serializer);
	self->priv->_serializer = _tmp24_;
	_tmp25_ = g_async_queue_new_full (_g_object_unref0_);
	_g_async_queue_unref0 (self->priv->queue);
	self->priv->queue = _tmp25_;
	_tmp26_ = self->priv->state;
	_tmp27_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (_tmp26_->ans);
	_tmp26_->ans = _tmp27_;
	_tmp28_ = self->priv->state;
	_tmp28_->ans_base = (guint) 10;
	_tmp29_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, NULL, "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (self->priv->ans_tag);
	self->priv->ans_tag = _tmp30_;
	ds = (_vala_array_free (ds, ds_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


MathEquation* math_equation_new (void) {
	return math_equation_construct (TYPE_MATH_EQUATION);
}


void math_equation_display_selected (MathEquation* self, const gchar* selected) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected != NULL);
	_tmp0_ = selected;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp0_, -1);
}


static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end) {
	gint _vala_start = 0;
	gint _vala_end = 0;
	GtkTextMark* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		_vala_start = -1;
		_vala_end = -1;
		if (start) {
			*start = _vala_start;
		}
		if (end) {
			*end = _vala_end;
		}
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = gtk_text_iter_get_offset (&iter);
	_vala_start = _tmp3_;
	_tmp4_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_tmp6_ = gtk_text_iter_get_offset (&iter);
	_vala_end = _tmp6_;
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
}


static void math_equation_reformat_ans (MathEquation* self) {
	GtkTextMark* _tmp0_;
	GtkTextIter ans_start = {0};
	GtkTextIter ans_end = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gchar* orig_ans_text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* ans_text = NULL;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	MathEquationState* _tmp10_;
	Number* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GtkTextMark* _tmp33_;
	GtkTextIter _tmp34_ = {0};
	GtkTextMark* _tmp35_;
	GtkTextIter _tmp36_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	ans_start = _tmp2_;
	_tmp3_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
	ans_end = _tmp4_;
	_tmp5_ = ans_start;
	_tmp6_ = ans_end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	orig_ans_text = _tmp7_;
	_tmp8_ = math_equation_get_serializer (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->state;
	_tmp11_ = _tmp10_->ans;
	_tmp12_ = serializer_to_string (_tmp9_, _tmp11_);
	ans_text = _tmp12_;
	_tmp13_ = orig_ans_text;
	_tmp14_ = ans_text;
	if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_ = {0};
		GtkTextMark* _tmp17_;
		GtkTextIter _tmp18_ = {0};
		const gchar* _tmp19_;
		GtkTextTag* _tmp20_;
		GtkTextMark* _tmp21_;
		GtkTextIter _tmp22_ = {0};
		GtkTextMark* _tmp23_;
		GtkTextIter _tmp24_ = {0};
		GtkTextMark* _tmp25_;
		GtkTextMark* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextMark* _tmp28_;
		GtkTextMark* _tmp29_;
		GtkTextIter _tmp30_;
		GtkTextMark* _tmp31_;
		GtkTextMark* _tmp32_;
		self->priv->in_undo_operation = TRUE;
		self->priv->in_reformat = TRUE;
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &ans_start, &ans_end);
		_tmp15_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp16_, _tmp15_);
		ans_start = _tmp16_;
		_tmp17_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp18_, _tmp17_);
		ans_end = _tmp18_;
		_tmp19_ = ans_text;
		_tmp20_ = self->priv->ans_tag;
		gtk_text_buffer_insert_with_tags ((GtkTextBuffer*) self, &ans_end, _tmp19_, -1, _tmp20_, NULL);
		_tmp21_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp22_, _tmp21_);
		ans_start = _tmp22_;
		_tmp23_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp24_, _tmp23_);
		ans_end = _tmp24_;
		_tmp25_ = self->priv->ans_start_mark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp25_);
		_tmp26_ = self->priv->ans_end_mark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp26_);
		_tmp27_ = ans_end;
		_tmp28_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp27_, FALSE);
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_g_object_unref0 (self->priv->ans_start_mark);
		self->priv->ans_start_mark = _tmp29_;
		_tmp30_ = ans_start;
		_tmp31_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp30_, TRUE);
		_tmp32_ = _g_object_ref0 (_tmp31_);
		_g_object_unref0 (self->priv->ans_end_mark);
		self->priv->ans_end_mark = _tmp32_;
		self->priv->in_reformat = FALSE;
		self->priv->in_undo_operation = FALSE;
	}
	_tmp33_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp34_, _tmp33_);
	ans_start = _tmp34_;
	_tmp35_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp36_, _tmp35_);
	ans_end = _tmp36_;
	_g_free0 (ans_text);
	_g_free0 (orig_ans_text);
}


void math_equation_remove_trailing_spaces (MathEquation* self) {
	GtkTextMark* insert_mark = NULL;
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	insert_mark = _tmp1_;
	_tmp2_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	_tmp4_ = end;
	start = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_;
		gunichar _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = gtk_text_iter_backward_char (&start);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = gtk_text_iter_get_char (&start);
		_tmp7_ = g_unichar_isspace (_tmp6_);
		if (!_tmp7_) {
			gtk_text_iter_forward_char (&start);
			break;
		}
	}
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
	_g_object_unref0 (insert_mark);
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void math_equation_reformat_separators (MathEquation* self) {
	gboolean in_number = FALSE;
	gboolean in_radix = FALSE;
	gboolean last_is_tsep = FALSE;
	gint digit_offset = 0;
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint offset = 0;
	gint index = 0;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	in_number = FALSE;
	in_radix = FALSE;
	last_is_tsep = FALSE;
	digit_offset = 0;
	self->priv->in_undo_operation = TRUE;
	self->priv->in_reformat = TRUE;
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	math_equation_get_ans_offsets (self, &_tmp2_, &_tmp3_);
	ans_start = _tmp2_;
	ans_end = _tmp3_;
	offset = -1;
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gint _tmp15_;
		gboolean expect_tsep = FALSE;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		gint _tmp29_;
		gunichar _tmp33_;
		gboolean _tmp34_;
		_tmp4_ = text;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = offset;
		offset = _tmp7_ + 1;
		_tmp14_ = math_equation_get_number_base (self);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == 10) {
			Serializer* _tmp16_;
			Serializer* _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = math_equation_get_serializer (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = serializer_get_show_thousands_separators (_tmp17_);
			_tmp13_ = _tmp18_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gboolean _tmp19_;
			_tmp19_ = in_number;
			_tmp12_ = _tmp19_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean _tmp20_;
			_tmp20_ = in_radix;
			_tmp11_ = !_tmp20_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gboolean _tmp21_;
			_tmp21_ = last_is_tsep;
			_tmp10_ = !_tmp21_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gint _tmp22_;
			_tmp22_ = digit_offset;
			_tmp9_ = _tmp22_ > 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gint _tmp23_;
			Serializer* _tmp24_;
			Serializer* _tmp25_;
			gint _tmp26_;
			_tmp23_ = digit_offset;
			_tmp24_ = math_equation_get_serializer (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = serializer_get_thousands_separator_count (_tmp25_);
			_tmp8_ = (_tmp23_ % _tmp26_) == 0;
		} else {
			_tmp8_ = FALSE;
		}
		expect_tsep = _tmp8_;
		last_is_tsep = FALSE;
		_tmp28_ = offset;
		_tmp29_ = ans_start;
		if (_tmp28_ >= _tmp29_) {
			gint _tmp30_;
			gint _tmp31_;
			_tmp30_ = offset;
			_tmp31_ = ans_end;
			_tmp27_ = _tmp30_ <= _tmp31_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			gboolean _tmp32_;
			in_radix = FALSE;
			_tmp32_ = in_radix;
			in_number = _tmp32_;
			continue;
		}
		_tmp33_ = c;
		_tmp34_ = g_unichar_isdigit (_tmp33_);
		if (_tmp34_) {
			gboolean _tmp35_;
			gboolean _tmp39_;
			gint _tmp48_;
			_tmp35_ = in_number;
			if (!_tmp35_) {
				const gchar* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				_tmp36_ = text;
				_tmp37_ = index;
				_tmp38_ = math_equation_count_digits (self, _tmp36_, _tmp37_);
				digit_offset = _tmp38_ + 1;
			}
			in_number = TRUE;
			_tmp39_ = expect_tsep;
			if (_tmp39_) {
				GtkTextIter iter = {0};
				gint _tmp40_;
				GtkTextIter _tmp41_ = {0};
				Serializer* _tmp42_;
				Serializer* _tmp43_;
				gunichar _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gint _tmp47_;
				_tmp40_ = offset;
				gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp41_, _tmp40_);
				iter = _tmp41_;
				_tmp42_ = math_equation_get_serializer (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = serializer_get_thousands_separator (_tmp43_);
				_tmp45_ = g_unichar_to_string (_tmp44_);
				_tmp46_ = _tmp45_;
				gtk_text_buffer_insert (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &iter, _tmp46_, -1);
				_g_free0 (_tmp46_);
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
				last_is_tsep = TRUE;
			}
			_tmp48_ = digit_offset;
			digit_offset = _tmp48_ - 1;
		} else {
			gunichar _tmp49_;
			Serializer* _tmp50_;
			Serializer* _tmp51_;
			gunichar _tmp52_;
			_tmp49_ = c;
			_tmp50_ = math_equation_get_serializer (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = serializer_get_radix (_tmp51_);
			if (_tmp49_ == _tmp52_) {
				in_number = TRUE;
				in_radix = TRUE;
			} else {
				gunichar _tmp53_;
				Serializer* _tmp54_;
				Serializer* _tmp55_;
				gunichar _tmp56_;
				_tmp53_ = c;
				_tmp54_ = math_equation_get_serializer (self);
				_tmp55_ = _tmp54_;
				_tmp56_ = serializer_get_thousands_separator (_tmp55_);
				if (_tmp53_ == _tmp56_) {
					gboolean _tmp57_ = FALSE;
					gboolean _tmp58_;
					_tmp58_ = expect_tsep;
					if (!_tmp58_) {
						gboolean _tmp59_;
						_tmp59_ = in_number;
						_tmp57_ = _tmp59_;
					} else {
						_tmp57_ = FALSE;
					}
					if (_tmp57_) {
						GtkTextIter start = {0};
						GtkTextIter end = {0};
						gint _tmp60_;
						GtkTextIter _tmp61_ = {0};
						gint _tmp62_;
						GtkTextIter _tmp63_ = {0};
						gint _tmp64_;
						_tmp60_ = offset;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp61_, _tmp60_);
						start = _tmp61_;
						_tmp62_ = offset;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp63_, _tmp62_ + 1);
						end = _tmp63_;
						gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
						_tmp64_ = offset;
						offset = _tmp64_ - 1;
					} else {
						last_is_tsep = TRUE;
					}
				} else {
					in_number = FALSE;
					in_radix = FALSE;
				}
			}
		}
	}
	self->priv->in_reformat = FALSE;
	self->priv->in_undo_operation = FALSE;
	_g_free0 (text);
}


static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index) {
	gint result = 0;
	gint count = 0;
	gboolean following_separator = FALSE;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	count = 0;
	following_separator = FALSE;
	while (TRUE) {
		const gchar* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gunichar _tmp3_;
		Serializer* _tmp4_;
		Serializer* _tmp5_;
		gunichar _tmp6_;
		_tmp0_ = text;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = c;
		_tmp4_ = math_equation_get_serializer (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = serializer_get_thousands_separator (_tmp5_);
		if (_tmp3_ == _tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = following_separator;
			if (_tmp7_) {
				result = count;
				return result;
			}
			following_separator = TRUE;
		} else {
			gunichar _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = c;
			_tmp9_ = g_unichar_isdigit (_tmp8_);
			if (_tmp9_) {
				gint _tmp10_;
				following_separator = FALSE;
				_tmp10_ = count;
				count = _tmp10_ + 1;
			} else {
				result = count;
				return result;
			}
		}
	}
	result = count;
	return result;
}


static void math_equation_reformat_display (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_reformat_ans (self);
	math_equation_reformat_separators (self);
}


static MathEquationState* math_equation_get_current_state (MathEquation* self) {
	MathEquationState* result = NULL;
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp0_;
	MathEquationState* s = NULL;
	MathEquationState* _tmp7_;
	MathEquationState* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	MathEquationState* _tmp11_;
	guint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NumberMode _tmp17_;
	NumberMode _tmp18_;
	gboolean _tmp19_;
	MathEquationState* _tmp20_;
	gboolean _tmp21_;
	MathEquationState* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	ans_start = -1;
	ans_end = -1;
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		gint _tmp3_;
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		gint _tmp6_;
		_tmp1_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
		iter = _tmp2_;
		_tmp3_ = gtk_text_iter_get_offset (&iter);
		ans_start = _tmp3_;
		_tmp4_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
		_tmp6_ = gtk_text_iter_get_offset (&iter);
		ans_end = _tmp6_;
	}
	_tmp7_ = math_equation_state_new ();
	s = _tmp7_;
	_tmp8_ = self->priv->state;
	_tmp9_ = _tmp8_->ans;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (s->ans);
	s->ans = _tmp10_;
	_tmp11_ = self->priv->state;
	_tmp12_ = _tmp11_->ans_base;
	s->ans_base = _tmp12_;
	_tmp13_ = math_equation_get_display (self);
	_tmp14_ = _tmp13_;
	_g_free0 (s->expression);
	s->expression = _tmp14_;
	_tmp15_ = ans_start;
	s->ans_start = _tmp15_;
	_tmp16_ = ans_end;
	s->ans_end = _tmp16_;
	g_object_get ((GObject*) self, "cursor-position", &s->cursor, NULL, NULL);
	_tmp17_ = math_equation_get_number_mode (self);
	_tmp18_ = _tmp17_;
	s->number_mode = _tmp18_;
	_tmp19_ = self->priv->can_super_minus;
	s->can_super_minus = _tmp19_;
	_tmp20_ = self->priv->state;
	_tmp21_ = _tmp20_->entered_multiply;
	s->entered_multiply = _tmp21_;
	_tmp22_ = self->priv->state;
	_tmp23_ = _tmp22_->status;
	_tmp24_ = g_strdup (_tmp23_);
	_g_free0 (s->status);
	s->status = _tmp24_;
	result = s;
	return result;
}


static void math_equation_push_undo_stack (MathEquation* self) {
	gboolean _tmp0_;
	MathEquationState* _tmp1_;
	MathEquationState* _tmp2_;
	MathEquationState* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->in_undo_operation;
	if (_tmp0_) {
		return;
	}
	math_equation_set_status (self, "");
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
	self->priv->redo_stack = NULL;
	_tmp1_ = math_equation_get_current_state (self);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp1_;
	g_object_notify ((GObject*) self, "status");
	_tmp2_ = self->priv->state;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp3_);
}


static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag) {
	GtkTextMark* _tmp0_;
	gboolean _tmp1_;
	GtkTextMark* _tmp9_;
	GtkTextMark* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = do_remove_tag;
	if (_tmp1_) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextTag* _tmp6_;
		GtkTextIter _tmp7_;
		GtkTextIter _tmp8_;
		_tmp2_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
		start = _tmp3_;
		_tmp4_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		end = _tmp5_;
		_tmp6_ = self->priv->ans_tag;
		_tmp7_ = start;
		_tmp8_ = end;
		gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp6_, &_tmp7_, &_tmp8_);
	}
	_tmp9_ = self->priv->ans_start_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp9_);
	_tmp10_ = self->priv->ans_end_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp10_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = NULL;
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = NULL;
}


static void math_equation_apply_state (MathEquation* self, MathEquationState* s) {
	MathEquationState* _tmp0_;
	MathEquationState* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	guint _tmp6_;
	MathEquationState* _tmp7_;
	const gchar* _tmp8_;
	GtkTextIter cursor = {0};
	MathEquationState* _tmp9_;
	gint _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_;
	MathEquationState* _tmp13_;
	gint _tmp14_;
	MathEquationState* _tmp30_;
	NumberMode _tmp31_;
	MathEquationState* _tmp32_;
	gboolean _tmp33_;
	MathEquationState* _tmp34_;
	MathEquationState* _tmp35_;
	gboolean _tmp36_;
	MathEquationState* _tmp37_;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	self->priv->in_undo_operation = TRUE;
	_tmp0_ = self->priv->state;
	_tmp1_ = s;
	_tmp2_ = _tmp1_->ans;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_tmp0_->ans);
	_tmp0_->ans = _tmp3_;
	_tmp4_ = self->priv->state;
	_tmp5_ = s;
	_tmp6_ = _tmp5_->ans_base;
	_tmp4_->ans_base = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = _tmp7_->expression;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp8_, -1);
	_tmp9_ = s;
	_tmp10_ = _tmp9_->cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
	cursor = _tmp11_;
	_tmp12_ = cursor;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp12_);
	math_equation_clear_ans (self, FALSE);
	_tmp13_ = s;
	_tmp14_ = _tmp13_->ans_start;
	if (_tmp14_ >= 0) {
		GtkTextIter start = {0};
		MathEquationState* _tmp15_;
		gint _tmp16_;
		GtkTextIter _tmp17_ = {0};
		GtkTextIter _tmp18_;
		GtkTextMark* _tmp19_;
		GtkTextMark* _tmp20_;
		GtkTextIter end = {0};
		MathEquationState* _tmp21_;
		gint _tmp22_;
		GtkTextIter _tmp23_ = {0};
		GtkTextIter _tmp24_;
		GtkTextMark* _tmp25_;
		GtkTextMark* _tmp26_;
		GtkTextTag* _tmp27_;
		GtkTextIter _tmp28_;
		GtkTextIter _tmp29_;
		_tmp15_ = s;
		_tmp16_ = _tmp15_->ans_start;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp17_, _tmp16_);
		start = _tmp17_;
		_tmp18_ = start;
		_tmp19_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp18_, FALSE);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (self->priv->ans_start_mark);
		self->priv->ans_start_mark = _tmp20_;
		_tmp21_ = s;
		_tmp22_ = _tmp21_->ans_end;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp23_, _tmp22_);
		end = _tmp23_;
		_tmp24_ = end;
		_tmp25_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp24_, TRUE);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_g_object_unref0 (self->priv->ans_end_mark);
		self->priv->ans_end_mark = _tmp26_;
		_tmp27_ = self->priv->ans_tag;
		_tmp28_ = start;
		_tmp29_ = end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp27_, &_tmp28_, &_tmp29_);
	}
	_tmp30_ = s;
	_tmp31_ = _tmp30_->number_mode;
	math_equation_set_number_mode (self, _tmp31_);
	_tmp32_ = s;
	_tmp33_ = _tmp32_->can_super_minus;
	self->priv->can_super_minus = _tmp33_;
	_tmp34_ = self->priv->state;
	_tmp35_ = s;
	_tmp36_ = _tmp35_->entered_multiply;
	_tmp34_->entered_multiply = _tmp36_;
	_tmp37_ = s;
	_tmp38_ = _tmp37_->status;
	math_equation_set_status (self, _tmp38_);
	self->priv->in_undo_operation = FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void math_equation_copy (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* tsep_string = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GdkAtom _tmp17_;
	GtkClipboard* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp2_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	if (!_tmp2_) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
		start = _tmp3_;
		end = _tmp4_;
	}
	_tmp5_ = start;
	_tmp6_ = end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = nl_langinfo (THOUSEP);
	_tmp9_ = g_strdup (_tmp8_);
	tsep_string = _tmp9_;
	_tmp11_ = tsep_string;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = tsep_string;
		_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
	}
	if (_tmp10_) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (" ");
		_g_free0 (tsep_string);
		tsep_string = _tmp13_;
	}
	_tmp14_ = text;
	_tmp15_ = tsep_string;
	_tmp16_ = string_replace (_tmp14_, _tmp15_, "");
	_g_free0 (text);
	text = _tmp16_;
	_tmp17_ = GDK_NONE;
	_tmp18_ = gtk_clipboard_get (_tmp17_);
	_tmp19_ = text;
	gtk_clipboard_set_text (_tmp18_, _tmp19_, -1);
	_g_free0 (tsep_string);
	_g_free0 (text);
}


static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self) {
	math_equation_on_paste ((MathEquation*) self, clipboard, text);
	g_object_unref (self);
}


void math_equation_paste (MathEquation* self) {
	GdkAtom _tmp0_;
	GtkClipboard* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = GDK_NONE;
	_tmp1_ = gtk_clipboard_get (_tmp0_);
	gtk_clipboard_request_text (_tmp1_, _math_equation_on_paste_gtk_clipboard_text_received_func, g_object_ref (self));
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = delimiters;
	_tmp3_ = new_delimiter;
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
	result = _result_;
	return result;
}


static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = text;
		_tmp2_ = string_delimit (_tmp1_, "\n", ' ');
		_tmp3_ = _tmp2_;
		math_equation_insert (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
}


static void math_equation_real_undo (GtkSourceBuffer* base) {
	MathEquation * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	MathEquationState* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	GList* _tmp6_;
	MathEquationState* _tmp12_;
	self = (MathEquation*) base;
	_tmp0_ = self->priv->undo_stack;
	if (_tmp0_ == NULL) {
		math_equation_set_status (self, _ ("No undo history"));
		return;
	}
	_tmp1_ = self->priv->undo_stack;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	_tmp3_ = _g_object_ref0 ((MathEquationState*) _tmp2_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp3_;
	g_object_notify ((GObject*) self, "status");
	_tmp4_ = self->priv->state;
	self->priv->undo_stack = g_list_remove (self->priv->undo_stack, _tmp4_);
	_tmp5_ = math_equation_get_current_state (self);
	self->priv->redo_stack = g_list_prepend (self->priv->redo_stack, _tmp5_);
	_tmp6_ = self->priv->undo_stack;
	if (_tmp6_ != NULL) {
		MathEquationState* _tmp7_;
		GList* _tmp8_;
		gconstpointer _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp7_ = self->priv->state;
		_tmp8_ = self->priv->undo_stack;
		_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
		_tmp10_ = ((MathEquationState*) _tmp9_)->ans;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (_tmp7_->ans);
		_tmp7_->ans = _tmp11_;
	}
	_tmp12_ = self->priv->state;
	math_equation_apply_state (self, _tmp12_);
}


static void math_equation_real_redo (GtkSourceBuffer* base) {
	MathEquation * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	MathEquationState* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	MathEquationState* _tmp6_;
	self = (MathEquation*) base;
	_tmp0_ = self->priv->redo_stack;
	if (_tmp0_ == NULL) {
		math_equation_set_status (self, _ ("No redo history"));
		return;
	}
	_tmp1_ = self->priv->redo_stack;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	_tmp3_ = _g_object_ref0 ((MathEquationState*) _tmp2_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp3_;
	g_object_notify ((GObject*) self, "status");
	_tmp4_ = self->priv->state;
	self->priv->redo_stack = g_list_remove (self->priv->redo_stack, _tmp4_);
	_tmp5_ = math_equation_get_current_state (self);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp5_);
	_tmp6_ = self->priv->state;
	math_equation_apply_state (self, _tmp6_);
}


gunichar math_equation_get_digit_text (MathEquation* self, guint digit) {
	gunichar result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = digit;
	if (_tmp0_ >= ((guint) 16)) {
		result = (gunichar) '?';
		return result;
	}
	_tmp1_ = digit;
	_tmp2_ = self->priv->digits[_tmp1_];
	result = _tmp2_;
	return result;
}


void math_equation_store (MathEquation* self, const gchar* name) {
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	t = _tmp1_;
	_tmp2_ = t;
	if (_tmp2_ == NULL) {
		math_equation_set_status (self, _ ("No sane value to store"));
	} else {
		MathVariables* _tmp3_;
		MathVariables* _tmp4_;
		const gchar* _tmp5_;
		Number* _tmp6_;
		_tmp3_ = math_equation_get_variables (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = name;
		_tmp6_ = t;
		math_variables_set (_tmp4_, _tmp5_, _tmp6_);
	}
	_g_object_unref0 (t);
}


void math_equation_recall (MathEquation* self, const gchar* name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	math_equation_insert (self, _tmp0_);
}


void math_equation_set (MathEquation* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp0_, -1);
	math_equation_clear_ans (self, FALSE);
}


void math_equation_set_number (MathEquation* self, Number* x, guint representation_base) {
	guint _tmp0_;
	gchar* text = NULL;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	Number* _tmp6_;
	gchar* _tmp7_;
	guint _tmp8_;
	MathEquationState* _tmp14_;
	MathEquationState* _tmp15_;
	const gchar* _tmp16_;
	Number* _tmp17_;
	Serializer* _tmp18_;
	Serializer* _tmp19_;
	gint _tmp20_;
	guint _tmp21_;
	const gchar* _tmp22_;
	MathEquationState* _tmp23_;
	Number* _tmp24_;
	Number* _tmp25_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp26_ = {0};
	GtkTextIter _tmp27_ = {0};
	GtkTextIter _tmp28_;
	GtkTextMark* _tmp29_;
	GtkTextMark* _tmp30_;
	GtkTextIter _tmp31_;
	GtkTextMark* _tmp32_;
	GtkTextMark* _tmp33_;
	GtkTextTag* _tmp34_;
	GtkTextIter _tmp35_;
	GtkTextIter _tmp36_;
	Serializer* _tmp37_;
	Serializer* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = representation_base;
	if (_tmp0_ != ((guint) 0)) {
		Serializer* _tmp1_;
		Serializer* _tmp2_;
		guint _tmp3_;
		_tmp1_ = math_equation_get_serializer (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = representation_base;
		serializer_set_representation_base (_tmp2_, _tmp3_);
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = x;
	_tmp7_ = serializer_to_string (_tmp5_, _tmp6_);
	text = _tmp7_;
	_tmp8_ = representation_base;
	if (_tmp8_ != ((guint) 0)) {
		Serializer* _tmp9_;
		Serializer* _tmp10_;
		Serializer* _tmp11_;
		Serializer* _tmp12_;
		gint _tmp13_;
		_tmp9_ = math_equation_get_serializer (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = math_equation_get_serializer (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = serializer_get_base (_tmp12_);
		serializer_set_representation_base (_tmp10_, (guint) _tmp13_);
	}
	_tmp14_ = math_equation_get_current_state (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_->expression;
	_tmp17_ = x;
	_tmp18_ = math_equation_get_serializer (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = serializer_get_base (_tmp19_);
	_tmp21_ = representation_base;
	g_signal_emit (self, math_equation_signals[MATH_EQUATION_HISTORY_SIGNAL_SIGNAL], 0, _tmp16_, _tmp17_, _tmp20_, _tmp21_);
	_g_object_unref0 (_tmp15_);
	_tmp22_ = text;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp22_, -1);
	_tmp23_ = self->priv->state;
	_tmp24_ = x;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (_tmp23_->ans);
	_tmp23_->ans = _tmp25_;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp26_, &_tmp27_);
	start = _tmp26_;
	end = _tmp27_;
	math_equation_clear_ans (self, FALSE);
	_tmp28_ = start;
	_tmp29_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp28_, FALSE);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = _tmp30_;
	_tmp31_ = end;
	_tmp32_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp31_, TRUE);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = _tmp33_;
	_tmp34_ = self->priv->ans_tag;
	_tmp35_ = start;
	_tmp36_ = end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp34_, &_tmp35_, &_tmp36_);
	_tmp37_ = math_equation_get_serializer (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = serializer_get_error (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ != NULL) {
		Serializer* _tmp41_;
		Serializer* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		Serializer* _tmp45_;
		Serializer* _tmp46_;
		_tmp41_ = math_equation_get_serializer (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = serializer_get_error (_tmp42_);
		_tmp44_ = _tmp43_;
		math_equation_set_status (self, _tmp44_);
		_tmp45_ = math_equation_get_serializer (self);
		_tmp46_ = _tmp45_;
		serializer_set_error (_tmp46_, NULL);
	}
	_g_free0 (text);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void math_equation_insert (MathEquation* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gint _tmp12_;
	const gchar* _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = text;
		_tmp1_ = g_strcmp0 (_tmp4_, "×") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		MathEquationState* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = self->priv->state;
		_tmp6_ = _tmp5_->entered_multiply;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp7_;
		GtkTextIter _tmp8_ = {0};
		GtkTextIter _tmp9_;
		_tmp7_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp8_, _tmp7_);
		iter = _tmp8_;
		_tmp9_ = iter;
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &_tmp9_, TRUE, TRUE);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "^", -1);
		return;
	}
	_tmp11_ = text;
	_tmp12_ = string_index_of ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp11_, 0);
	if (_tmp12_ >= 0) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = text;
		_tmp10_ = g_strcmp0 (_tmp13_, "⁻") == 0;
	}
	if (_tmp10_) {
		self->priv->can_super_minus = FALSE;
	}
	_tmp14_ = text;
	_tmp15_ = string_index_of ("⁻⁰¹²³⁴⁵⁶⁷⁸⁹₀₁₂₃₄₅₆₇₈₉", _tmp14_, 0);
	if (_tmp15_ < 0) {
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
	gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	_tmp16_ = text;
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, _tmp16_, -1);
}


void math_equation_insert_selected (MathEquation* self, const gchar* answer) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = answer;
	math_equation_insert (self, _tmp0_);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void math_equation_insert_square (MathEquation* self) {
	gboolean space_required = FALSE;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	space_required = FALSE;
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	iter = _tmp1_;
	_tmp2_ = gtk_text_iter_backward_char (&iter);
	if (_tmp2_) {
		gunichar previous_character = 0U;
		gunichar _tmp3_;
		gunichar _tmp4_;
		gint _tmp5_;
		_tmp3_ = gtk_text_iter_get_char (&iter);
		previous_character = _tmp3_;
		_tmp4_ = previous_character;
		_tmp5_ = string_index_of_char ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp4_, 0);
		if (_tmp5_ >= 0) {
			space_required = TRUE;
		}
	}
	_tmp6_ = space_required;
	if (_tmp6_) {
		math_equation_insert (self, " ²");
	} else {
		math_equation_insert (self, "²");
	}
}


void math_equation_insert_digit (MathEquation* self, guint digit) {
	static const gunichar subscript_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	static const gunichar superscript_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	NumberMode _tmp2_;
	NumberMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = digit;
	if (_tmp0_ >= ((guint) 16)) {
		return;
	}
	_tmp2_ = math_equation_get_number_mode (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NUMBER_MODE_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		guint _tmp4_;
		_tmp4_ = digit;
		_tmp1_ = _tmp4_ >= ((guint) 10);
	}
	if (_tmp1_) {
		guint _tmp5_;
		gunichar _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = digit;
		_tmp6_ = math_equation_get_digit_text (self, _tmp5_);
		_tmp7_ = g_unichar_to_string (_tmp6_);
		_tmp8_ = _tmp7_;
		math_equation_insert (self, _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		NumberMode _tmp9_;
		NumberMode _tmp10_;
		_tmp9_ = math_equation_get_number_mode (self);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
			guint _tmp11_;
			gunichar _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = digit;
			_tmp12_ = superscript_digits[_tmp11_];
			_tmp13_ = g_unichar_to_string (_tmp12_);
			_tmp14_ = _tmp13_;
			math_equation_insert (self, _tmp14_);
			_g_free0 (_tmp14_);
		} else {
			NumberMode _tmp15_;
			NumberMode _tmp16_;
			_tmp15_ = math_equation_get_number_mode (self);
			_tmp16_ = _tmp15_;
			if (_tmp16_ == NUMBER_MODE_SUBSCRIPT) {
				guint _tmp17_;
				gunichar _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = digit;
				_tmp18_ = subscript_digits[_tmp17_];
				_tmp19_ = g_unichar_to_string (_tmp18_);
				_tmp20_ = _tmp19_;
				math_equation_insert (self, _tmp20_);
				_g_free0 (_tmp20_);
			}
		}
	}
}


void math_equation_insert_numeric_point (MathEquation* self) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gunichar _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_radix (_tmp1_);
	_tmp3_ = g_unichar_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	math_equation_insert (self, _tmp4_);
	_g_free0 (_tmp4_);
}


void math_equation_insert_number (MathEquation* self, Number* x) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Number* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = serializer_to_string (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	math_equation_insert (self, _tmp4_);
	_g_free0 (_tmp4_);
}


void math_equation_insert_exponent (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_insert (self, "×10");
	math_equation_set_number_mode (self, NUMBER_MODE_SUPERSCRIPT);
}


void math_equation_insert_subtract (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_number_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->can_super_minus;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		math_equation_insert (self, "⁻");
		self->priv->can_super_minus = FALSE;
	} else {
		math_equation_insert (self, "−");
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
}


static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar* * error_token, guint** error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint* _vala_error_start = NULL;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	MEquation* equation = NULL;
	const gchar* _tmp0_;
	MEquation* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	AngleUnit _tmp7_;
	AngleUnit _tmp8_;
	guint _tmp9_ = 0U;
	ErrorCode _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	guint* _tmp12_ = NULL;
	guint* _tmp13_ = NULL;
	Number* _tmp14_;
	guint* _tmp15_;
	Number* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = mequation_new (self, _tmp0_);
	equation = _tmp1_;
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = serializer_get_base (_tmp3_);
	((Equation*) equation)->base = _tmp4_;
	_tmp5_ = math_equation_get_word_size (self);
	_tmp6_ = _tmp5_;
	((Equation*) equation)->wordlen = _tmp6_;
	_tmp7_ = math_equation_get_angle_units (self);
	_tmp8_ = _tmp7_;
	((Equation*) equation)->angle_units = _tmp8_;
	_tmp14_ = equation_parse ((Equation*) equation, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	_vala_representation_base = _tmp9_;
	_vala_error_code = _tmp10_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp11_;
	_g_free0 (_vala_error_start);
	_vala_error_start = _tmp12_;
	_tmp15_ = _tmp13_;
	_vala_error_end = *_tmp15_;
	_tmp16_ = _tmp14_;
	_g_free0 (_tmp15_);
	result = _tmp16_;
	_g_object_unref0 (equation);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	} else {
		_g_free0 (_vala_error_start);
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void* math_equation_solve_real (MathEquation* self) {
	void* result = NULL;
	SolveData* solvedata = NULL;
	SolveData* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint n_brackets = 0;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	guint representation_base = 0U;
	Number* z = NULL;
	const gchar* _tmp20_;
	guint _tmp21_ = 0U;
	ErrorCode _tmp22_ = 0;
	gchar* _tmp23_ = NULL;
	guint* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	Number* _tmp26_;
	guint* _tmp27_;
	Number* _tmp28_;
	SolveData* _tmp29_;
	guint _tmp30_;
	ErrorCode _tmp31_;
	GAsyncQueue* _tmp71_;
	SolveData* _tmp72_;
	SolveData* _tmp73_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = solve_data_new ();
	solvedata = _tmp0_;
	_tmp1_ = math_equation_get_equation (self);
	_tmp2_ = _tmp1_;
	text = _tmp2_;
	n_brackets = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				gint _tmp6_;
				gchar _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = text;
				_tmp6_ = i;
				_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
				if (!(_tmp7_ != '\0')) {
					break;
				}
				_tmp8_ = text;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				if (_tmp10_ == '(') {
					gint _tmp11_;
					_tmp11_ = n_brackets;
					n_brackets = _tmp11_ + 1;
				} else {
					const gchar* _tmp12_;
					gint _tmp13_;
					gchar _tmp14_;
					_tmp12_ = text;
					_tmp13_ = i;
					_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
					if (_tmp14_ == ')') {
						gint _tmp15_;
						_tmp15_ = n_brackets;
						n_brackets = _tmp15_ - 1;
					}
				}
			}
		}
	}
	while (TRUE) {
		gint _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gint _tmp19_;
		_tmp16_ = n_brackets;
		if (!(_tmp16_ > 0)) {
			break;
		}
		_tmp17_ = text;
		_tmp18_ = g_strconcat (_tmp17_, ")", NULL);
		_g_free0 (text);
		text = _tmp18_;
		_tmp19_ = n_brackets;
		n_brackets = _tmp19_ - 1;
	}
	_tmp20_ = text;
	_tmp26_ = math_equation_parse (self, _tmp20_, &_tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
	representation_base = _tmp21_;
	error_code = _tmp22_;
	_g_free0 (error_token);
	error_token = _tmp23_;
	_tmp27_ = _tmp24_;
	error_start = *_tmp27_;
	error_end = _tmp25_;
	_tmp28_ = _tmp26_;
	_g_free0 (_tmp27_);
	z = _tmp28_;
	_tmp29_ = solvedata;
	_tmp30_ = representation_base;
	_tmp29_->representation_base = _tmp30_;
	_tmp31_ = error_code;
	switch (_tmp31_) {
		case ERROR_CODE_NONE:
		{
			SolveData* _tmp32_;
			Number* _tmp33_;
			Number* _tmp34_;
			_tmp32_ = solvedata;
			_tmp33_ = z;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_g_object_unref0 (_tmp32_->number_result);
			_tmp32_->number_result = _tmp34_;
			break;
		}
		case ERROR_CODE_OVERFLOW:
		{
			SolveData* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = solvedata;
			_tmp36_ = g_strdup (_ ("Overflow. Try a bigger word size"));
			_g_free0 (_tmp35_->error);
			_tmp35_->error = _tmp36_;
			break;
		}
		case ERROR_CODE_UNKNOWN_VARIABLE:
		{
			SolveData* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			SolveData* _tmp40_;
			guint _tmp41_;
			SolveData* _tmp42_;
			guint _tmp43_;
			_tmp37_ = solvedata;
			_tmp38_ = error_token;
			_tmp39_ = g_strdup_printf (_ ("Unknown variable “%s”"), _tmp38_);
			_g_free0 (_tmp37_->error);
			_tmp37_->error = _tmp39_;
			_tmp40_ = solvedata;
			_tmp41_ = error_start;
			_tmp40_->error_start = _tmp41_;
			_tmp42_ = solvedata;
			_tmp43_ = error_end;
			_tmp42_->error_end = _tmp43_;
			break;
		}
		case ERROR_CODE_UNKNOWN_FUNCTION:
		{
			SolveData* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			SolveData* _tmp47_;
			guint _tmp48_;
			SolveData* _tmp49_;
			guint _tmp50_;
			_tmp44_ = solvedata;
			_tmp45_ = error_token;
			_tmp46_ = g_strdup_printf (_ ("Function “%s” is not defined"), _tmp45_);
			_g_free0 (_tmp44_->error);
			_tmp44_->error = _tmp46_;
			_tmp47_ = solvedata;
			_tmp48_ = error_start;
			_tmp47_->error_start = _tmp48_;
			_tmp49_ = solvedata;
			_tmp50_ = error_end;
			_tmp49_->error_end = _tmp50_;
			break;
		}
		case ERROR_CODE_UNKNOWN_CONVERSION:
		{
			SolveData* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = solvedata;
			_tmp52_ = g_strdup (_ ("Unknown conversion"));
			_g_free0 (_tmp51_->error);
			_tmp51_->error = _tmp52_;
			break;
		}
		case ERROR_CODE_MP:
		{
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			_tmp53_ = number_get_error ();
			_tmp54_ = _tmp53_;
			if (_tmp54_ != NULL) {
				SolveData* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp55_ = solvedata;
				_tmp56_ = number_get_error ();
				_tmp57_ = _tmp56_;
				_tmp58_ = g_strdup (_tmp57_);
				_g_free0 (_tmp55_->error);
				_tmp55_->error = _tmp58_;
			} else {
				const gchar* _tmp59_;
				_tmp59_ = error_token;
				if (_tmp59_ != NULL) {
					SolveData* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					SolveData* _tmp63_;
					guint _tmp64_;
					SolveData* _tmp65_;
					guint _tmp66_;
					_tmp60_ = solvedata;
					_tmp61_ = error_token;
					_tmp62_ = g_strdup_printf (_ ("%s"), _tmp61_);
					_g_free0 (_tmp60_->error);
					_tmp60_->error = _tmp62_;
					_tmp63_ = solvedata;
					_tmp64_ = error_start;
					_tmp63_->error_start = _tmp64_;
					_tmp65_ = solvedata;
					_tmp66_ = error_end;
					_tmp65_->error_end = _tmp66_;
				} else {
					SolveData* _tmp67_;
					gchar* _tmp68_;
					_tmp67_ = solvedata;
					_tmp68_ = g_strdup (_ ("Malformed expression"));
					_g_free0 (_tmp67_->error);
					_tmp67_->error = _tmp68_;
				}
			}
			break;
		}
		default:
		{
			SolveData* _tmp69_;
			gchar* _tmp70_;
			_tmp69_ = solvedata;
			_tmp70_ = g_strdup (_ ("Malformed expression"));
			_g_free0 (_tmp69_->error);
			_tmp69_->error = _tmp70_;
			break;
		}
	}
	_tmp71_ = self->priv->queue;
	_tmp72_ = solvedata;
	_tmp73_ = _g_object_ref0 (_tmp72_);
	g_async_queue_push (_tmp71_, _tmp73_);
	result = NULL;
	_g_object_unref0 (z);
	_g_free0 (error_token);
	_g_free0 (text);
	_g_object_unref0 (solvedata);
	return result;
}


static gboolean math_equation_show_in_progress (MathEquation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		math_equation_set_status (self, _ ("Calculating"));
	}
	result = FALSE;
	return result;
}


static gboolean math_equation_look_for_answer (MathEquation* self) {
	gboolean result = FALSE;
	SolveData* _result_ = NULL;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_;
	SolveData* _tmp2_;
	SolveData* _tmp3_;
	const gchar* _tmp4_;
	SolveData* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->queue;
	_tmp1_ = g_async_queue_try_pop (_tmp0_);
	_result_ = (SolveData*) _tmp1_;
	_tmp2_ = _result_;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_object_unref0 (_result_);
		return result;
	}
	self->priv->_in_solve = FALSE;
	_tmp3_ = _result_;
	_tmp4_ = _tmp3_->error;
	if (_tmp4_ == NULL) {
		math_equation_set_status (self, "");
	}
	_tmp5_ = _result_;
	_tmp6_ = _tmp5_->error;
	if (_tmp6_ != NULL) {
		SolveData* _tmp7_;
		const gchar* _tmp8_;
		MathEquationState* _tmp9_;
		SolveData* _tmp10_;
		guint _tmp11_;
		MathEquationState* _tmp12_;
		SolveData* _tmp13_;
		guint _tmp14_;
		_tmp7_ = _result_;
		_tmp8_ = _tmp7_->error;
		math_equation_set_status (self, _tmp8_);
		_tmp9_ = self->priv->state;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->error_start;
		_tmp9_->error_token_start = _tmp11_;
		_tmp12_ = self->priv->state;
		_tmp13_ = _result_;
		_tmp14_ = _tmp13_->error_end;
		_tmp12_->error_token_end = _tmp14_;
		math_equation_error_token_fix_thousands_separator (self);
		math_equation_error_token_fix_parenthesis (self);
		g_object_notify ((GObject*) self, "error-token-end");
	} else {
		SolveData* _tmp15_;
		Number* _tmp16_;
		_tmp15_ = _result_;
		_tmp16_ = _tmp15_->number_result;
		if (_tmp16_ != NULL) {
			SolveData* _tmp17_;
			Number* _tmp18_;
			SolveData* _tmp19_;
			guint _tmp20_;
			_tmp17_ = _result_;
			_tmp18_ = _tmp17_->number_result;
			_tmp19_ = _result_;
			_tmp20_ = _tmp19_->representation_base;
			math_equation_set_number (self, _tmp18_, _tmp20_);
		} else {
			SolveData* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = _result_;
			_tmp22_ = _tmp21_->text_result;
			if (_tmp22_ != NULL) {
				SolveData* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = _result_;
				_tmp24_ = _tmp23_->text_result;
				math_equation_set (self, _tmp24_);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (_result_);
	return result;
}


static gpointer _math_equation_solve_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_solve_real ((MathEquation*) self);
	g_object_unref (self);
	return result;
}


static gboolean _math_equation_look_for_answer_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_look_for_answer ((MathEquation*) self);
	return result;
}


static gboolean _math_equation_show_in_progress_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_show_in_progress ((MathEquation*) self);
	return result;
}


void math_equation_solve (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GThread* _tmp6_;
	GThread* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_is_empty (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_is_result (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		gtk_source_buffer_undo ((GtkSourceBuffer*) self);
		return;
	}
	self->priv->_in_solve = TRUE;
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	_tmp6_ = g_thread_new ("", _math_equation_solve_real_gthread_func, g_object_ref (self));
	_tmp7_ = _tmp6_;
	_g_thread_unref0 (_tmp7_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
}


static void math_equation_error_token_fix_thousands_separator (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter temp = {0};
	GtkTextIter _tmp1_;
	GtkTextIter end = {0};
	GtkTextIter _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gchar* str = NULL;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	gunichar _tmp9_;
	gchar* _tmp10_;
	gint length = 0;
	const gchar* _tmp11_;
	gint _tmp12_;
	GtkTextIter _tmp27_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	_tmp1_ = start;
	temp = _tmp1_;
	_tmp2_ = start;
	end = _tmp2_;
	_tmp3_ = math_equation_get_error_token_start (self);
	_tmp4_ = _tmp3_;
	gtk_text_iter_set_offset (&start, (gint) _tmp4_);
	_tmp5_ = math_equation_get_error_token_end (self);
	_tmp6_ = _tmp5_;
	gtk_text_iter_set_offset (&end, (gint) _tmp6_);
	_tmp7_ = math_equation_get_serializer (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = serializer_get_thousands_separator (_tmp8_);
	_tmp10_ = g_unichar_to_string (_tmp9_);
	str = _tmp10_;
	_tmp11_ = str;
	_tmp12_ = g_utf8_strlen (_tmp11_, (gssize) -1);
	length = _tmp12_;
	while (TRUE) {
		const gchar* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_ = {0};
		gboolean _tmp16_;
		MathEquationState* _tmp17_;
		MathEquationState* _tmp18_;
		guint _tmp19_;
		gint _tmp20_;
		MathEquationState* _tmp21_;
		MathEquationState* _tmp22_;
		guint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp13_ = str;
		_tmp14_ = start;
		_tmp16_ = gtk_text_iter_forward_search (&temp, _tmp13_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp15_, &_tmp14_);
		temp = _tmp15_;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = self->priv->state;
		_tmp18_ = self->priv->state;
		_tmp19_ = _tmp18_->error_token_start;
		_tmp20_ = length;
		_tmp18_->error_token_start = _tmp19_ + _tmp20_;
		_tmp21_ = self->priv->state;
		_tmp22_ = self->priv->state;
		_tmp23_ = _tmp22_->error_token_end;
		_tmp24_ = length;
		_tmp22_->error_token_end = _tmp23_ + _tmp24_;
		_tmp25_ = length;
		gtk_text_iter_forward_chars (&start, _tmp25_);
		_tmp26_ = length;
		gtk_text_iter_forward_chars (&start, _tmp26_);
	}
	_tmp27_ = start;
	temp = _tmp27_;
	while (TRUE) {
		const gchar* _tmp28_;
		GtkTextIter _tmp29_;
		GtkTextIter _tmp30_ = {0};
		gboolean _tmp31_;
		MathEquationState* _tmp32_;
		MathEquationState* _tmp33_;
		guint _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp28_ = str;
		_tmp29_ = end;
		_tmp31_ = gtk_text_iter_forward_search (&temp, _tmp28_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp30_, &_tmp29_);
		temp = _tmp30_;
		if (!_tmp31_) {
			break;
		}
		_tmp32_ = self->priv->state;
		_tmp33_ = self->priv->state;
		_tmp34_ = _tmp33_->error_token_end;
		_tmp35_ = length;
		_tmp33_->error_token_end = _tmp34_ + _tmp35_;
		_tmp36_ = length;
		gtk_text_iter_forward_chars (&end, _tmp36_);
	}
	_g_free0 (str);
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		gunichar _tmp4_;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static void math_equation_error_token_fix_parenthesis (MathEquation* self) {
	gunichar c = 0U;
	gint count = 0;
	gint real_end = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint real_start = 0;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	guint _tmp72_;
	guint _tmp73_;
	gint _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	guint _tmp78_;
	guint _tmp79_;
	gint _tmp80_;
	gunichar d = 0U;
	g_return_if_fail (self != NULL);
	count = 0;
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_error_token_end (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_index_of_nth_char (_tmp2_, (glong) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp2_);
	real_end = _tmp6_;
	_tmp7_ = math_equation_get_display (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = math_equation_get_error_token_start (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_index_of_nth_char (_tmp9_, (glong) _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp9_);
	real_start = _tmp13_;
	{
		gint i = 0;
		gint _tmp14_;
		_tmp14_ = real_start;
		i = _tmp14_;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_ = FALSE;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gunichar _tmp20_ = 0U;
				gboolean _tmp21_;
				gboolean _tmp22_;
				gunichar _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gboolean _tmp28_;
				gunichar _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				if (!_tmp15_) {
				}
				_tmp15_ = FALSE;
				_tmp17_ = math_equation_get_display (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_;
				_tmp21_ = string_get_next_char (_tmp19_, &i, &_tmp20_);
				c = _tmp20_;
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp19_);
				if (_tmp22_) {
					gint _tmp23_;
					gint _tmp24_;
					_tmp23_ = i;
					_tmp24_ = real_end;
					_tmp16_ = _tmp23_ <= _tmp24_;
				} else {
					_tmp16_ = FALSE;
				}
				if (!_tmp16_) {
					break;
				}
				_tmp25_ = c;
				_tmp26_ = g_unichar_to_string (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strcmp0 (_tmp27_, "(") == 0;
				_g_free0 (_tmp27_);
				if (_tmp28_) {
					gint _tmp29_;
					_tmp29_ = count;
					count = _tmp29_ + 1;
				}
				_tmp30_ = c;
				_tmp31_ = g_unichar_to_string (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (_tmp32_, ")") == 0;
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					gint _tmp34_;
					_tmp34_ = count;
					count = _tmp34_ - 1;
				}
			}
		}
	}
	{
		gint i = 0;
		gint _tmp35_;
		_tmp35_ = real_end;
		i = _tmp35_;
		{
			gboolean _tmp36_ = FALSE;
			_tmp36_ = TRUE;
			while (TRUE) {
				gboolean _tmp37_ = FALSE;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gunichar _tmp41_ = 0U;
				gboolean _tmp42_;
				gboolean _tmp43_;
				gunichar _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gboolean _tmp48_;
				if (!_tmp36_) {
				}
				_tmp36_ = FALSE;
				_tmp38_ = math_equation_get_display (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = _tmp39_;
				_tmp42_ = string_get_next_char (_tmp40_, &i, &_tmp41_);
				c = _tmp41_;
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp40_);
				if (_tmp43_) {
					gint _tmp44_;
					_tmp44_ = count;
					_tmp37_ = _tmp44_ > 0;
				} else {
					_tmp37_ = FALSE;
				}
				if (!_tmp37_) {
					break;
				}
				_tmp45_ = c;
				_tmp46_ = g_unichar_to_string (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strcmp0 (_tmp47_, ")") == 0;
				_g_free0 (_tmp47_);
				if (_tmp48_) {
					MathEquationState* _tmp49_;
					guint _tmp50_;
					gint _tmp51_;
					_tmp49_ = self->priv->state;
					_tmp50_ = _tmp49_->error_token_end;
					_tmp49_->error_token_end = _tmp50_ + 1;
					_tmp51_ = count;
					count = _tmp51_ - 1;
				} else {
					break;
				}
			}
		}
	}
	{
		gint i = 0;
		gint _tmp52_;
		_tmp52_ = real_start;
		i = _tmp52_;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				gboolean _tmp54_ = FALSE;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gunichar _tmp58_ = 0U;
				gboolean _tmp59_;
				gboolean _tmp60_;
				gunichar _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gboolean _tmp65_;
				if (!_tmp53_) {
				}
				_tmp53_ = FALSE;
				_tmp55_ = math_equation_get_display (self);
				_tmp56_ = _tmp55_;
				_tmp57_ = _tmp56_;
				_tmp59_ = string_get_prev_char (_tmp57_, &i, &_tmp58_);
				c = _tmp58_;
				_tmp60_ = _tmp59_;
				_g_free0 (_tmp57_);
				if (_tmp60_) {
					gint _tmp61_;
					_tmp61_ = count;
					_tmp54_ = _tmp61_ < 0;
				} else {
					_tmp54_ = FALSE;
				}
				if (!_tmp54_) {
					break;
				}
				_tmp62_ = c;
				_tmp63_ = g_unichar_to_string (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strcmp0 (_tmp64_, "(") == 0;
				_g_free0 (_tmp64_);
				if (_tmp65_) {
					MathEquationState* _tmp66_;
					guint _tmp67_;
					gint _tmp68_;
					_tmp66_ = self->priv->state;
					_tmp67_ = _tmp66_->error_token_start;
					_tmp66_->error_token_start = _tmp67_ - 1;
					_tmp68_ = count;
					count = _tmp68_ + 1;
				} else {
					break;
				}
			}
		}
	}
	_tmp69_ = math_equation_get_display (self);
	_tmp70_ = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp72_ = math_equation_get_error_token_end (self);
	_tmp73_ = _tmp72_;
	_tmp74_ = string_index_of_nth_char (_tmp71_, (glong) _tmp73_);
	real_end = _tmp74_;
	_g_free0 (_tmp71_);
	_tmp75_ = math_equation_get_display (self);
	_tmp76_ = _tmp75_;
	_tmp77_ = _tmp76_;
	_tmp78_ = math_equation_get_error_token_start (self);
	_tmp79_ = _tmp78_;
	_tmp80_ = string_index_of_nth_char (_tmp77_, (glong) _tmp79_);
	real_start = _tmp80_;
	_g_free0 (_tmp77_);
	while (TRUE) {
		gboolean _tmp81_ = FALSE;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gunichar _tmp85_ = 0U;
		gboolean _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp93_ = FALSE;
		gunichar _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gboolean _tmp97_;
		_tmp82_ = math_equation_get_display (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = _tmp83_;
		_tmp86_ = string_get_next_char (_tmp84_, &real_end, &_tmp85_);
		d = _tmp85_;
		_tmp87_ = _tmp86_;
		_g_free0 (_tmp84_);
		if (_tmp87_) {
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gunichar _tmp91_ = 0U;
			gboolean _tmp92_;
			_tmp88_ = math_equation_get_display (self);
			_tmp89_ = _tmp88_;
			_tmp90_ = _tmp89_;
			_tmp92_ = string_get_prev_char (_tmp90_, &real_start, &_tmp91_);
			c = _tmp91_;
			_tmp81_ = _tmp92_;
			_g_free0 (_tmp90_);
		} else {
			_tmp81_ = FALSE;
		}
		if (!_tmp81_) {
			break;
		}
		_tmp94_ = c;
		_tmp95_ = g_unichar_to_string (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strcmp0 (_tmp96_, "(") == 0;
		_g_free0 (_tmp96_);
		if (_tmp97_) {
			gunichar _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp98_ = d;
			_tmp99_ = g_unichar_to_string (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp93_ = g_strcmp0 (_tmp100_, ")") == 0;
			_g_free0 (_tmp100_);
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			MathEquationState* _tmp101_;
			guint _tmp102_;
			MathEquationState* _tmp103_;
			guint _tmp104_;
			_tmp101_ = self->priv->state;
			_tmp102_ = _tmp101_->error_token_start;
			_tmp101_->error_token_start = _tmp102_ - 1;
			_tmp103_ = self->priv->state;
			_tmp104_ = _tmp103_->error_token_end;
			_tmp103_->error_token_end = _tmp104_ + 1;
		} else {
			break;
		}
	}
}


static void* math_equation_factorize_real (MathEquation* self) {
	void* result = NULL;
	Number* x = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	GList* factors = NULL;
	Number* _tmp2_;
	GList* _tmp3_;
	gchar* text = NULL;
	gchar* _tmp4_;
	gint i = 0;
	GList* _tmp5_;
	SolveData* _result_ = NULL;
	SolveData* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GAsyncQueue* _tmp21_;
	SolveData* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = x;
	_tmp3_ = number_factorize (_tmp2_);
	factors = _tmp3_;
	_tmp4_ = g_strdup ("");
	text = _tmp4_;
	i = 0;
	_tmp5_ = factors;
	{
		GList* factor_collection = NULL;
		GList* factor_it = NULL;
		factor_collection = _tmp5_;
		for (factor_it = factor_collection; factor_it != NULL; factor_it = factor_it->next) {
			Number* _tmp6_;
			Number* factor = NULL;
			_tmp6_ = _g_object_ref0 ((Number*) factor_it->data);
			factor = _tmp6_;
			{
				gint _tmp7_;
				const gchar* _tmp10_;
				Serializer* _tmp11_;
				Serializer* _tmp12_;
				Number* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gint _tmp17_;
				_tmp7_ = i;
				if (_tmp7_ != 0) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text;
					_tmp9_ = g_strconcat (_tmp8_, "×", NULL);
					_g_free0 (text);
					text = _tmp9_;
				}
				_tmp10_ = text;
				_tmp11_ = math_equation_get_serializer (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = factor;
				_tmp14_ = serializer_to_string (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
				_g_free0 (text);
				text = _tmp16_;
				_g_free0 (_tmp15_);
				_tmp17_ = i;
				i = _tmp17_ + 1;
				_g_object_unref0 (factor);
			}
		}
	}
	_tmp18_ = solve_data_new ();
	_result_ = _tmp18_;
	_tmp19_ = text;
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_result_->text_result);
	_result_->text_result = _tmp20_;
	_tmp21_ = self->priv->queue;
	_tmp22_ = _g_object_ref0 (_result_);
	g_async_queue_push (_tmp21_, _tmp22_);
	result = NULL;
	_g_object_unref0 (_result_);
	_g_free0 (text);
	__g_list_free__g_object_unref0_0 (factors);
	_g_object_unref0 (x);
	return result;
}


static gpointer _math_equation_factorize_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_factorize_real ((MathEquation*) self);
	g_object_unref (self);
	return result;
}


void math_equation_factorize (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	Number* x = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	GThread* _tmp8_;
	GThread* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_number (self);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	_tmp5_ = x;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = x;
		_tmp7_ = number_is_integer (_tmp6_);
		_tmp4_ = !_tmp7_;
	}
	if (_tmp4_) {
		math_equation_set_status (self, _ ("Need an integer to factorize"));
		_g_object_unref0 (x);
		return;
	}
	self->priv->_in_solve = TRUE;
	_tmp8_ = g_thread_new ("", _math_equation_factorize_real_gthread_func, g_object_ref (self));
	_tmp9_ = _tmp8_;
	_g_thread_unref0 (_tmp9_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (x);
}


void math_equation_delete_next (MathEquation* self) {
	gint cursor = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint _tmp2_;
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
	_tmp0_ = cursor;
	_tmp1_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
	if (_tmp0_ >= _tmp1_) {
		return;
	}
	_tmp2_ = cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	start = _tmp3_;
	_tmp4_ = cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp5_, _tmp4_ + 1);
	end = _tmp5_;
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
}


void math_equation_backspace (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_is_empty (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	} else {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_;
		_tmp4_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
		_tmp6_ = iter;
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &_tmp6_, TRUE, TRUE);
	}
}


void math_equation_clear (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
	math_equation_clear_ans (self, FALSE);
}


void math_equation_shift (MathEquation* self, gint count) {
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	gint _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	z = _tmp1_;
	_tmp2_ = z;
	if (_tmp2_ == NULL) {
		math_equation_set_status (self, _ ("No sane value to bitwise shift"));
		_g_object_unref0 (z);
		return;
	}
	_tmp3_ = z;
	_tmp4_ = count;
	_tmp5_ = number_shift (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	math_equation_set_number (self, _tmp6_, (guint) 0);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (z);
}


void math_equation_toggle_bit (MathEquation* self, guint bit) {
	Number* x = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* max = NULL;
	Number* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	guint64 bits = 0ULL;
	Number* _tmp11_;
	guint64 _tmp12_;
	guint64 _tmp13_;
	guint _tmp14_;
	guint64 _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
	max = _tmp2_;
	_tmp5_ = x;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = x;
		_tmp7_ = number_is_negative (_tmp6_);
		_tmp4_ = _tmp7_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		Number* _tmp8_;
		Number* _tmp9_;
		gint _tmp10_;
		_tmp8_ = x;
		_tmp9_ = max;
		_tmp10_ = number_compare (_tmp8_, _tmp9_);
		_tmp3_ = _tmp10_ > 0;
	}
	if (_tmp3_) {
		math_equation_set_status (self, _ ("Displayed value not an integer"));
		_g_object_unref0 (max);
		_g_object_unref0 (x);
		return;
	}
	_tmp11_ = x;
	_tmp12_ = number_to_unsigned_integer (_tmp11_);
	bits = _tmp12_;
	_tmp13_ = bits;
	_tmp14_ = bit;
	bits = _tmp13_ ^ (1LL << (63 - _tmp14_));
	_tmp15_ = bits;
	_tmp16_ = number_new_unsigned_integer (_tmp15_, (guint64) 0);
	_g_object_unref0 (x);
	x = _tmp16_;
	_tmp17_ = x;
	math_equation_set_number (self, _tmp17_, (guint) 0);
	_g_object_unref0 (max);
	_g_object_unref0 (x);
}


static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len) {
	MathEquation * self;
	gboolean _tmp0_;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	gboolean _tmp6_;
	gunichar c = 0U;
	const gchar* _tmp7_;
	gunichar _tmp8_;
	gint cursor = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gunichar _tmp12_;
	gboolean _tmp13_;
	GtkTextMark* _tmp23_;
	const gchar* _tmp32_;
	gint _tmp33_;
	MathEquationState* _tmp34_;
	const gchar* _tmp35_;
	GtkTextMark* _tmp36_;
	GtkTextIter _tmp37_ = {0};
	GtkTextMark* _tmp38_;
	self = (MathEquation*) base;
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->in_reformat;
	if (_tmp0_) {
		const gchar* _tmp1_;
		gint _tmp2_;
		_tmp1_ = text;
		_tmp2_ = len;
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, _tmp1_, _tmp2_);
		return;
	}
	_tmp3_ = *location;
	_tmp4_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp3_, FALSE);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	mark = _tmp5_;
	_tmp6_ = self->priv->in_delete;
	if (!_tmp6_) {
		math_equation_push_undo_stack (self);
	}
	_tmp7_ = text;
	_tmp8_ = string_get_char (_tmp7_, (glong) 0);
	c = _tmp8_;
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
	_tmp12_ = c;
	_tmp13_ = g_unichar_isdigit (_tmp12_);
	if (_tmp13_) {
		_tmp11_ = TRUE;
	} else {
		gunichar _tmp14_;
		Serializer* _tmp15_;
		Serializer* _tmp16_;
		gunichar _tmp17_;
		_tmp14_ = c;
		_tmp15_ = math_equation_get_serializer (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = serializer_get_radix (_tmp16_);
		_tmp11_ = _tmp14_ == _tmp17_;
	}
	if (_tmp11_) {
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp18_ = math_equation_get_is_result (self);
		_tmp19_ = _tmp18_;
		_tmp10_ = _tmp19_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gint _tmp20_;
		gint _tmp21_;
		_tmp20_ = cursor;
		_tmp21_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
		_tmp9_ = _tmp20_ >= _tmp21_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkTextIter _tmp22_ = {0};
		gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
		math_equation_clear_ans (self, FALSE);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp22_);
		*location = _tmp22_;
	}
	_tmp23_ = self->priv->ans_start_mark;
	if (_tmp23_ != NULL) {
		gint offset = 0;
		gint _tmp24_;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		gint _tmp29_;
		_tmp24_ = gtk_text_iter_get_offset (location);
		offset = _tmp24_;
		math_equation_get_ans_offsets (self, &_tmp25_, &_tmp26_);
		ans_start = _tmp25_;
		ans_end = _tmp26_;
		_tmp28_ = offset;
		_tmp29_ = ans_start;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			gint _tmp31_;
			_tmp30_ = offset;
			_tmp31_ = ans_end;
			_tmp27_ = _tmp30_ < _tmp31_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	_tmp32_ = text;
	_tmp33_ = len;
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, _tmp32_, _tmp33_);
	_tmp34_ = self->priv->state;
	_tmp35_ = text;
	_tmp34_->entered_multiply = g_strcmp0 (_tmp35_, "×") == 0;
	math_equation_reformat_separators (self);
	_tmp36_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp37_, _tmp36_);
	*location = _tmp37_;
	_tmp38_ = mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp38_);
	g_object_notify ((GObject*) self, "display");
	_g_object_unref0 (mark);
}


static gboolean __lambda10_ (MathEquation* self) {
	gboolean result = FALSE;
	self->priv->in_delete = FALSE;
	result = FALSE;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ ((MathEquation*) self);
	return result;
}


static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end) {
	MathEquation * self;
	gboolean _tmp0_;
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp13_;
	GtkTextIter _tmp14_;
	MathEquationState* _tmp15_;
	self = (MathEquation*) base;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = self->priv->in_reformat;
	if (_tmp0_) {
		GtkTextIter _tmp1_;
		GtkTextIter _tmp2_;
		_tmp1_ = *start;
		_tmp2_ = *end;
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp1_, &_tmp2_);
		return;
	}
	math_equation_push_undo_stack (self);
	self->priv->in_delete = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->ans_start_mark;
	if (_tmp3_ != NULL) {
		gint start_offset = 0;
		gint _tmp4_;
		gint end_offset = 0;
		gint _tmp5_;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = gtk_text_iter_get_offset (start);
		start_offset = _tmp4_;
		_tmp5_ = gtk_text_iter_get_offset (end);
		end_offset = _tmp5_;
		math_equation_get_ans_offsets (self, &_tmp6_, &_tmp7_);
		ans_start = _tmp6_;
		ans_end = _tmp7_;
		_tmp9_ = start_offset;
		_tmp10_ = ans_end;
		if (_tmp9_ < _tmp10_) {
			gint _tmp11_;
			gint _tmp12_;
			_tmp11_ = end_offset;
			_tmp12_ = ans_start;
			_tmp8_ = _tmp11_ > _tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	_tmp13_ = *start;
	_tmp14_ = *end;
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp13_, &_tmp14_);
	_tmp15_ = self->priv->state;
	_tmp15_->entered_multiply = FALSE;
	math_equation_reformat_separators (self);
	g_object_notify ((GObject*) self, "display");
}


gint math_equation_get_word_size (MathEquation* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_word_size;
	result = _tmp0_;
	return result;
}


void math_equation_set_word_size (MathEquation* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_word_size;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_word_size = _tmp2_;
	g_object_notify ((GObject *) self, "word-size");
}


gchar* math_equation_get_source_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_source_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_currency;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_source_currency);
	self->priv->_source_currency = _tmp3_;
	g_object_notify ((GObject *) self, "source-currency");
}


gchar* math_equation_get_target_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_target_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_currency;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_target_currency);
	self->priv->_target_currency = _tmp3_;
	g_object_notify ((GObject *) self, "target-currency");
}


gchar* math_equation_get_source_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_source_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_source_units);
	self->priv->_source_units = _tmp3_;
	g_object_notify ((GObject *) self, "source-units");
}


gchar* math_equation_get_target_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_target_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_target_units);
	self->priv->_target_units = _tmp3_;
	g_object_notify ((GObject *) self, "target-units");
}


gchar* math_equation_get_display (MathEquation* self) {
	gchar* result;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_, FALSE);
	result = _tmp4_;
	return result;
}


gboolean math_equation_get_in_solve (MathEquation* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_in_solve;
	result = _tmp0_;
	return result;
}


MathVariables* math_equation_get_variables (MathEquation* self) {
	MathVariables* result;
	MathVariables* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variables;
	result = _tmp0_;
	return result;
}


Serializer* math_equation_get_serializer (MathEquation* self) {
	Serializer* result;
	Serializer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serializer;
	result = _tmp0_;
	return result;
}


gint math_equation_get_accuracy (MathEquation* self) {
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_accuracy (MathEquation* self, gint value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_trailing_digits (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject *) self, "accuracy");
}


gboolean math_equation_get_show_thousands_separators (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_show_thousands_separators (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject *) self, "show-thousands-separators");
}


gboolean math_equation_get_show_trailing_zeroes (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_show_trailing_zeroes (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject *) self, "show-trailing-zeroes");
}


DisplayFormat math_equation_get_number_format (MathEquation* self) {
	DisplayFormat result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	DisplayFormat _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_number_format (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_number_format (MathEquation* self, DisplayFormat value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	DisplayFormat _tmp2_;
	DisplayFormat _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	DisplayFormat _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_number_format (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_number_format (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject *) self, "number-format");
}


gint math_equation_get_number_base (MathEquation* self) {
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_base (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_number_base (MathEquation* self, gint value) {
	gboolean _tmp0_ = FALSE;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Serializer* _tmp9_;
	Serializer* _tmp10_;
	gint _tmp11_;
	Serializer* _tmp12_;
	Serializer* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_serializer (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = serializer_get_base (_tmp2_);
	_tmp4_ = value;
	if (_tmp3_ == _tmp4_) {
		Serializer* _tmp5_;
		Serializer* _tmp6_;
		guint _tmp7_;
		gint _tmp8_;
		_tmp5_ = math_equation_get_serializer (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = serializer_get_representation_base (_tmp6_);
		_tmp8_ = value;
		_tmp0_ = _tmp7_ == ((guint) _tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = math_equation_get_serializer (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = value;
	serializer_set_base (_tmp10_, _tmp11_);
	_tmp12_ = math_equation_get_serializer (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = value;
	serializer_set_representation_base (_tmp13_, (guint) _tmp14_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject *) self, "number-base");
}


AngleUnit math_equation_get_angle_units (MathEquation* self) {
	AngleUnit result;
	AngleUnit _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_angle_units;
	result = _tmp0_;
	return result;
}


void math_equation_set_angle_units (MathEquation* self, AngleUnit value) {
	AngleUnit _tmp0_;
	AngleUnit _tmp1_;
	AngleUnit _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_angle_units;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_angle_units = _tmp2_;
	g_object_notify ((GObject *) self, "angle-units");
}


gchar* math_equation_get_status (MathEquation* self) {
	gchar* result;
	MathEquationState* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->status;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_status (MathEquation* self, const gchar* value) {
	MathEquationState* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_tmp0_->status);
	_tmp0_->status = _tmp2_;
	g_object_notify ((GObject *) self, "status");
}


guint math_equation_get_error_token_start (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	MathEquationState* _tmp11_;
	guint _tmp12_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	_tmp3_ = ans_start;
	if (_tmp3_ != -1) {
		gint _tmp4_;
		MathEquationState* _tmp5_;
		guint _tmp6_;
		_tmp4_ = ans_start;
		_tmp5_ = self->priv->state;
		_tmp6_ = _tmp5_->error_token_start;
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MathEquationState* _tmp7_;
		guint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->state;
		_tmp8_ = _tmp7_->error_token_start;
		_tmp9_ = ans_end;
		_tmp10_ = ans_start;
		result = ((_tmp8_ + _tmp9_) - _tmp10_) - 3;
		return result;
	}
	_tmp11_ = self->priv->state;
	_tmp12_ = _tmp11_->error_token_start;
	result = _tmp12_;
	return result;
}


guint math_equation_get_error_token_end (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	MathEquationState* _tmp11_;
	guint _tmp12_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	_tmp3_ = ans_start;
	if (_tmp3_ != -1) {
		gint _tmp4_;
		MathEquationState* _tmp5_;
		guint _tmp6_;
		_tmp4_ = ans_start;
		_tmp5_ = self->priv->state;
		_tmp6_ = _tmp5_->error_token_end;
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MathEquationState* _tmp7_;
		guint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->state;
		_tmp8_ = _tmp7_->error_token_end;
		_tmp9_ = ans_end;
		_tmp10_ = ans_start;
		result = ((_tmp8_ + _tmp9_) - _tmp10_) - 3;
		return result;
	}
	_tmp11_ = self->priv->state;
	_tmp12_ = _tmp11_->error_token_end;
	result = _tmp12_;
	return result;
}


gboolean math_equation_get_is_empty (MathEquation* self) {
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
	result = _tmp0_ == 0;
	return result;
}


gboolean math_equation_get_is_result (MathEquation* self) {
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "ans") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* string_splice (const gchar* self, glong start, glong end, const gchar* str) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	gsize str_size = 0UL;
	const gchar* _tmp18_;
	const gchar* _result_ = NULL;
	gint _tmp22_;
	gint _tmp23_;
	glong _tmp24_;
	glong _tmp25_;
	gsize _tmp26_;
	void* _tmp27_;
	gchar* dest = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	glong _tmp30_;
	gchar* _tmp31_;
	glong _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gsize _tmp35_;
	gchar* _tmp36_;
	gsize _tmp37_;
	gchar* _tmp38_;
	glong _tmp39_;
	glong _tmp40_;
	glong _tmp41_;
	const gchar* _tmp42_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = str;
	if (_tmp18_ == NULL) {
		str_size = (gsize) 0;
	} else {
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp19_ = str;
		_tmp20_ = strlen ((const gchar*) _tmp19_);
		_tmp21_ = _tmp20_;
		str_size = (gsize) _tmp21_;
	}
	_tmp22_ = strlen (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = end;
	_tmp25_ = start;
	_tmp26_ = str_size;
	_tmp27_ = g_malloc0 (((_tmp23_ - (_tmp24_ - _tmp25_)) + _tmp26_) + 1);
	_result_ = _tmp27_;
	_tmp28_ = _result_;
	dest = (gchar*) _tmp28_;
	_tmp29_ = dest;
	_tmp30_ = start;
	memcpy (_tmp29_, self, (gsize) _tmp30_);
	_tmp31_ = dest;
	_tmp32_ = start;
	dest = _tmp31_ + _tmp32_;
	_tmp33_ = dest;
	_tmp34_ = str;
	_tmp35_ = str_size;
	memcpy (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = dest;
	_tmp37_ = str_size;
	dest = _tmp36_ + _tmp37_;
	_tmp38_ = dest;
	_tmp39_ = end;
	_tmp40_ = string_length;
	_tmp41_ = end;
	memcpy (_tmp38_, ((gchar*) self) + _tmp39_, (gsize) (_tmp40_ - _tmp41_));
	_tmp42_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp42_;
	return result;
}


gchar* math_equation_get_equation (MathEquation* self) {
	gchar* result;
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* eq_text = NULL;
	gchar* _tmp2_;
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp3_;
	gint _tmp6_;
	gboolean last_is_digit = FALSE;
	gint index = 0;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	_tmp2_ = g_strdup ("");
	eq_text = _tmp2_;
	ans_start = -1;
	ans_end = -1;
	_tmp3_ = self->priv->ans_start_mark;
	if (_tmp3_ != NULL) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		math_equation_get_ans_offsets (self, &_tmp4_, &_tmp5_);
		ans_start = _tmp4_;
		ans_end = _tmp5_;
	}
	_tmp6_ = ans_start;
	if (_tmp6_ >= 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		_tmp7_ = text;
		_tmp8_ = text;
		_tmp9_ = ans_start;
		_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
		_tmp11_ = text;
		_tmp12_ = ans_end;
		_tmp13_ = string_index_of_nth_char (_tmp11_, (glong) _tmp12_);
		_tmp14_ = string_splice (_tmp7_, (glong) _tmp10_, (glong) _tmp13_, "ans");
		_g_free0 (text);
		text = _tmp14_;
	}
	last_is_digit = FALSE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp15_;
		gunichar _tmp16_ = 0U;
		gboolean _tmp17_;
		gboolean is_digit = FALSE;
		gunichar _tmp18_;
		gboolean _tmp19_;
		gboolean next_is_digit = FALSE;
		gunichar next_char = 0U;
		gint i = 0;
		gint _tmp20_;
		const gchar* _tmp21_;
		gunichar _tmp22_ = 0U;
		gboolean _tmp23_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gunichar _tmp28_;
		Serializer* _tmp29_;
		Serializer* _tmp30_;
		gunichar _tmp31_;
		gboolean _tmp49_;
		_tmp15_ = text;
		_tmp17_ = string_get_next_char (_tmp15_, &index, &_tmp16_);
		c = _tmp16_;
		if (!_tmp17_) {
			break;
		}
		_tmp18_ = c;
		_tmp19_ = g_unichar_isdigit (_tmp18_);
		is_digit = _tmp19_;
		next_is_digit = FALSE;
		_tmp20_ = index;
		i = _tmp20_;
		_tmp21_ = text;
		_tmp23_ = string_get_next_char (_tmp21_, &i, &_tmp22_);
		next_char = _tmp22_;
		if (_tmp23_) {
			gunichar _tmp24_;
			gboolean _tmp25_;
			_tmp24_ = next_char;
			_tmp25_ = g_unichar_isdigit (_tmp24_);
			next_is_digit = _tmp25_;
		}
		_tmp28_ = c;
		_tmp29_ = math_equation_get_serializer (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = serializer_get_thousands_separator (_tmp30_);
		if (_tmp28_ != _tmp31_) {
			_tmp27_ = TRUE;
		} else {
			gboolean _tmp32_;
			_tmp32_ = last_is_digit;
			_tmp27_ = !_tmp32_;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp33_;
			_tmp33_ = next_is_digit;
			_tmp26_ = !_tmp33_;
		}
		if (_tmp26_) {
			gboolean _tmp34_ = FALSE;
			gunichar _tmp35_;
			Serializer* _tmp36_;
			Serializer* _tmp37_;
			gunichar _tmp38_;
			_tmp35_ = c;
			_tmp36_ = math_equation_get_serializer (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = serializer_get_radix (_tmp37_);
			if (_tmp35_ == _tmp38_) {
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
				_tmp40_ = last_is_digit;
				if (_tmp40_) {
					_tmp39_ = TRUE;
				} else {
					gboolean _tmp41_;
					_tmp41_ = next_is_digit;
					_tmp39_ = _tmp41_;
				}
				_tmp34_ = _tmp39_;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp42_ = eq_text;
				_tmp43_ = g_strconcat (_tmp42_, ".", NULL);
				_g_free0 (eq_text);
				eq_text = _tmp43_;
			} else {
				const gchar* _tmp44_;
				gunichar _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp44_ = eq_text;
				_tmp45_ = c;
				_tmp46_ = g_unichar_to_string (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
				_g_free0 (eq_text);
				eq_text = _tmp48_;
				_g_free0 (_tmp47_);
			}
		}
		_tmp49_ = is_digit;
		last_is_digit = _tmp49_;
	}
	result = eq_text;
	_g_free0 (text);
	return result;
}


Number* math_equation_get_number (MathEquation* self) {
	Number* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_is_result (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp2_ = math_equation_get_answer (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		Serializer* _tmp5_;
		Serializer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp5_ = math_equation_get_serializer (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = math_equation_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = serializer_from_string (_tmp6_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	}
}


NumberMode math_equation_get_number_mode (MathEquation* self) {
	NumberMode result;
	NumberMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_number_mode;
	result = _tmp0_;
	return result;
}


void math_equation_set_number_mode (MathEquation* self, NumberMode value) {
	NumberMode _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	NumberMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_number_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->can_super_minus = _tmp2_ == NUMBER_MODE_SUPERSCRIPT;
	_tmp3_ = value;
	self->priv->_number_mode = _tmp3_;
	g_object_notify ((GObject *) self, "number-mode");
}


Number* math_equation_get_answer (MathEquation* self) {
	Number* result;
	MathEquationState* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->ans;
	result = _tmp1_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, guint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT_INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), g_value_get_uint (param_values + 4), data2);
}


static void math_equation_class_init (MathEquationClass * klass) {
	math_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathEquationPrivate));
	((GtkSourceBufferClass *) klass)->undo = (void (*) (GtkSourceBuffer *)) math_equation_real_undo;
	((GtkSourceBufferClass *) klass)->redo = (void (*) (GtkSourceBuffer *)) math_equation_real_redo;
	((GtkTextBufferClass *) klass)->insert_text = (void (*) (GtkTextBuffer *, GtkTextIter*, const gchar*, gint)) math_equation_real_insert_text;
	((GtkTextBufferClass *) klass)->delete_range = (void (*) (GtkTextBuffer *, GtkTextIter*, GtkTextIter*)) math_equation_real_delete_range;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_equation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_equation_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_equation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_WORD_SIZE, g_param_spec_int ("word-size", "word-size", "word-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_CURRENCY, g_param_spec_string ("source-currency", "source-currency", "source-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_CURRENCY, g_param_spec_string ("target-currency", "target-currency", "target-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_UNITS, g_param_spec_string ("source-units", "source-units", "source-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_UNITS, g_param_spec_string ("target-units", "target-units", "target-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_DISPLAY, g_param_spec_string ("display", "display", "display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IN_SOLVE, g_param_spec_boolean ("in-solve", "in-solve", "in-solve", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_VARIABLES, g_param_spec_object ("variables", "variables", "variables", TYPE_MATH_VARIABLES, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SERIALIZER, g_param_spec_object ("serializer", "serializer", "serializer", TYPE_SERIALIZER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ACCURACY, g_param_spec_int ("accuracy", "accuracy", "accuracy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS, g_param_spec_boolean ("show-thousands-separators", "show-thousands-separators", "show-thousands-separators", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_TRAILING_ZEROES, g_param_spec_boolean ("show-trailing-zeroes", "show-trailing-zeroes", "show-trailing-zeroes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_FORMAT, g_param_spec_enum ("number-format", "number-format", "number-format", TYPE_DISPLAY_FORMAT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_BASE, g_param_spec_int ("number-base", "number-base", "number-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANGLE_UNITS, g_param_spec_enum ("angle-units", "angle-units", "angle-units", TYPE_ANGLE_UNIT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_START, g_param_spec_uint ("error-token-start", "error-token-start", "error-token-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_END, g_param_spec_uint ("error-token-end", "error-token-end", "error-token-end", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_RESULT, g_param_spec_boolean ("is-result", "is-result", "is-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_EQUATION, g_param_spec_string ("equation", "equation", "equation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER, g_param_spec_object ("number", "number", "number", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_MODE, g_param_spec_enum ("number-mode", "number-mode", "number-mode", TYPE_NUMBER_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANSWER, g_param_spec_object ("answer", "answer", "answer", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	math_equation_signals[MATH_EQUATION_HISTORY_SIGNAL_SIGNAL] = g_signal_new ("history_signal", TYPE_MATH_EQUATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT, G_TYPE_NONE, 4, G_TYPE_STRING, TYPE_NUMBER, G_TYPE_INT, G_TYPE_UINT);
}


static void math_equation_instance_init (MathEquation * self) {
	self->priv = MATH_EQUATION_GET_PRIVATE (self);
	self->priv->ans_start_mark = NULL;
	self->priv->ans_end_mark = NULL;
}


static void math_equation_finalize (GObject * obj) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION, MathEquation);
	_g_object_unref0 (self->priv->ans_tag);
	_g_free0 (self->priv->_source_currency);
	_g_free0 (self->priv->_target_currency);
	_g_free0 (self->priv->_source_units);
	_g_free0 (self->priv->_target_units);
	_g_object_unref0 (self->priv->ans_start_mark);
	_g_object_unref0 (self->priv->ans_end_mark);
	_g_object_unref0 (self->priv->state);
	__g_list_free__g_object_unref0_0 (self->priv->undo_stack);
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
	_g_object_unref0 (self->priv->_variables);
	_g_object_unref0 (self->priv->_serializer);
	_g_async_queue_unref0 (self->priv->queue);
	G_OBJECT_CLASS (math_equation_parent_class)->finalize (obj);
}


GType math_equation_get_type (void) {
	static volatile gsize math_equation_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquation), 0, (GInstanceInitFunc) math_equation_instance_init, NULL };
		GType math_equation_type_id;
		math_equation_type_id = g_type_register_static (gtk_source_buffer_get_type (), "MathEquation", &g_define_type_info, 0);
		g_once_init_leave (&math_equation_type_id__volatile, math_equation_type_id);
	}
	return math_equation_type_id__volatile;
}


static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE:
		g_value_set_int (value, math_equation_get_word_size (self));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY:
		g_value_take_string (value, math_equation_get_source_currency (self));
		break;
		case MATH_EQUATION_TARGET_CURRENCY:
		g_value_take_string (value, math_equation_get_target_currency (self));
		break;
		case MATH_EQUATION_SOURCE_UNITS:
		g_value_take_string (value, math_equation_get_source_units (self));
		break;
		case MATH_EQUATION_TARGET_UNITS:
		g_value_take_string (value, math_equation_get_target_units (self));
		break;
		case MATH_EQUATION_DISPLAY:
		g_value_take_string (value, math_equation_get_display (self));
		break;
		case MATH_EQUATION_IN_SOLVE:
		g_value_set_boolean (value, math_equation_get_in_solve (self));
		break;
		case MATH_EQUATION_VARIABLES:
		g_value_set_object (value, math_equation_get_variables (self));
		break;
		case MATH_EQUATION_SERIALIZER:
		g_value_set_object (value, math_equation_get_serializer (self));
		break;
		case MATH_EQUATION_ACCURACY:
		g_value_set_int (value, math_equation_get_accuracy (self));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
		g_value_set_boolean (value, math_equation_get_show_thousands_separators (self));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
		g_value_set_boolean (value, math_equation_get_show_trailing_zeroes (self));
		break;
		case MATH_EQUATION_NUMBER_FORMAT:
		g_value_set_enum (value, math_equation_get_number_format (self));
		break;
		case MATH_EQUATION_NUMBER_BASE:
		g_value_set_int (value, math_equation_get_number_base (self));
		break;
		case MATH_EQUATION_ANGLE_UNITS:
		g_value_set_enum (value, math_equation_get_angle_units (self));
		break;
		case MATH_EQUATION_STATUS:
		g_value_take_string (value, math_equation_get_status (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_START:
		g_value_set_uint (value, math_equation_get_error_token_start (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_END:
		g_value_set_uint (value, math_equation_get_error_token_end (self));
		break;
		case MATH_EQUATION_IS_EMPTY:
		g_value_set_boolean (value, math_equation_get_is_empty (self));
		break;
		case MATH_EQUATION_IS_RESULT:
		g_value_set_boolean (value, math_equation_get_is_result (self));
		break;
		case MATH_EQUATION_EQUATION:
		g_value_take_string (value, math_equation_get_equation (self));
		break;
		case MATH_EQUATION_NUMBER:
		g_value_take_object (value, math_equation_get_number (self));
		break;
		case MATH_EQUATION_NUMBER_MODE:
		g_value_set_enum (value, math_equation_get_number_mode (self));
		break;
		case MATH_EQUATION_ANSWER:
		g_value_set_object (value, math_equation_get_answer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE:
		math_equation_set_word_size (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY:
		math_equation_set_source_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_CURRENCY:
		math_equation_set_target_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_SOURCE_UNITS:
		math_equation_set_source_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_UNITS:
		math_equation_set_target_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_ACCURACY:
		math_equation_set_accuracy (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
		math_equation_set_show_thousands_separators (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
		math_equation_set_show_trailing_zeroes (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_NUMBER_FORMAT:
		math_equation_set_number_format (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_NUMBER_BASE:
		math_equation_set_number_base (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_ANGLE_UNITS:
		math_equation_set_angle_units (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_STATUS:
		math_equation_set_status (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_NUMBER_MODE:
		math_equation_set_number_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation) {
	MEquation * self = NULL;
	const gchar* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_val_if_fail (m_equation != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = equation;
	self = (MEquation*) equation_construct (object_type, _tmp0_);
	_tmp1_ = m_equation;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->m_equation);
	self->priv->m_equation = _tmp2_;
	return self;
}


MEquation* mequation_new (MathEquation* m_equation, const gchar* equation) {
	return mequation_construct (TYPE_MEQUATION, m_equation, equation);
}


static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name) {
	MEquation * self;
	gboolean result = FALSE;
	gchar* lower_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	MathEquation* _tmp5_;
	MathVariables* _tmp6_;
	MathVariables* _tmp7_;
	const gchar* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	gboolean _tmp11_;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	lower_name = _tmp1_;
	_tmp3_ = lower_name;
	if (g_strcmp0 (_tmp3_, "rand") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = lower_name;
		_tmp2_ = g_strcmp0 (_tmp4_, "ans") == 0;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp5_ = self->priv->m_equation;
	_tmp6_ = math_equation_get_variables (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = name;
	_tmp9_ = math_variables_get (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_object_unref0 (_tmp10_);
	result = _tmp11_;
	_g_free0 (lower_name);
	return result;
}


static Number* mequation_real_get_variable (Equation* base, const gchar* name) {
	MEquation * self;
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	lower_name = _tmp1_;
	_tmp2_ = lower_name;
	if (g_strcmp0 (_tmp2_, "rand") == 0) {
		Number* _tmp3_;
		_tmp3_ = number_new_random ();
		result = _tmp3_;
		_g_free0 (lower_name);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = lower_name;
		if (g_strcmp0 (_tmp4_, "ans") == 0) {
			MathEquation* _tmp5_;
			Number* _tmp6_;
			Number* _tmp7_;
			Number* _tmp8_;
			_tmp5_ = self->priv->m_equation;
			_tmp6_ = math_equation_get_answer (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			result = _tmp8_;
			_g_free0 (lower_name);
			return result;
		} else {
			MathEquation* _tmp9_;
			MathVariables* _tmp10_;
			MathVariables* _tmp11_;
			const gchar* _tmp12_;
			Number* _tmp13_;
			_tmp9_ = self->priv->m_equation;
			_tmp10_ = math_equation_get_variables (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = name;
			_tmp13_ = math_variables_get (_tmp11_, _tmp12_);
			result = _tmp13_;
			_g_free0 (lower_name);
			return result;
		}
	}
	_g_free0 (lower_name);
}


static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x) {
	MEquation * self;
	MathEquation* _tmp0_;
	MathVariables* _tmp1_;
	MathVariables* _tmp2_;
	const gchar* _tmp3_;
	Number* _tmp4_;
	self = (MEquation*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = self->priv->m_equation;
	_tmp1_ = math_equation_get_variables (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = name;
	_tmp4_ = x;
	math_variables_set (_tmp2_, _tmp3_, _tmp4_);
}


static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	MEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_;
	UnitManager* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	self = (MEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = x_units;
	_tmp4_ = z_units;
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void mequation_class_init (MEquationClass * klass) {
	mequation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MEquationPrivate));
	((EquationClass *) klass)->variable_is_defined = (gboolean (*) (Equation *, const gchar*)) mequation_real_variable_is_defined;
	((EquationClass *) klass)->get_variable = (Number* (*) (Equation *, const gchar*)) mequation_real_get_variable;
	((EquationClass *) klass)->set_variable = (void (*) (Equation *, const gchar*, Number*)) mequation_real_set_variable;
	((EquationClass *) klass)->convert = (Number* (*) (Equation *, Number*, const gchar*, const gchar*)) mequation_real_convert;
	G_OBJECT_CLASS (klass)->finalize = mequation_finalize;
}


static void mequation_instance_init (MEquation * self) {
	self->priv = MEQUATION_GET_PRIVATE (self);
}


static void mequation_finalize (GObject * obj) {
	MEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEQUATION, MEquation);
	_g_object_unref0 (self->priv->m_equation);
	G_OBJECT_CLASS (mequation_parent_class)->finalize (obj);
}


GType mequation_get_type (void) {
	static volatile gsize mequation_type_id__volatile = 0;
	if (g_once_init_enter (&mequation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mequation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MEquation), 0, (GInstanceInitFunc) mequation_instance_init, NULL };
		GType mequation_type_id;
		mequation_type_id = g_type_register_static (TYPE_EQUATION, "MEquation", &g_define_type_info, 0);
		g_once_init_leave (&mequation_type_id__volatile, mequation_type_id);
	}
	return mequation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



