<?xml version='1.0' encoding='UTF-8'?><!-- -*- indent-tabs-mode: nil -*- -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:yelp="http://www.gnome.org/yelp/ns"
                extension-element-prefixes="yelp"
                version="1.0">

<xsl:import href="/usr/share/xml/gnome/xslt/docbook/html/db2html.xsl"/>

<xsl:param name="yelp.image.blockquote"/>
<xsl:param name="yelp.image.caution"/>
<xsl:param name="yelp.image.important"/>
<xsl:param name="yelp.image.note"/>
<xsl:param name="yelp.image.programlisting"/>
<xsl:param name="yelp.image.tip"/>
<xsl:param name="yelp.image.warning"/>

<xsl:param name="db.chunk.chunk_top" select="true()"/>
<xsl:param name="db.chunk.extension" select="''"/>
<xsl:param name="db.chunk.cover_basename" select="'__yelp_cover'"/>
<xsl:param name="db.chunk.info_basename"  select="'__yelp_info'"/>
<xsl:param name="db.chunk.index_basename" select="'__yelp_index'"/>
<xsl:param name="db.chunk.toc_basename"   select="'__yelp_toc'"/>

<!-- == db.chunk == -->
<xsl:template name="db.chunk">
  <xsl:param name="node" select="."/>
  <xsl:param name="info"/>
  <xsl:param name="template"/>
  <xsl:param name="href">
    <xsl:choose>
      <xsl:when test="$template = 'cover'">
        <xsl:value-of select="$db.chunk.cover_basename"/>
      </xsl:when>
      <xsl:when test="$template = 'info'">
        <xsl:value-of select="$db.chunk.info_basename"/>
      </xsl:when>
      <xsl:when test="$template = 'index'">
        <xsl:value-of select="$db.chunk.index_basename"/>
      </xsl:when>
      <xsl:when test="$template = 'toc'">
        <xsl:value-of select="$db.chunk.toc_basename"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$node/@id"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="depth_of_chunk">
    <xsl:call-template name="db.chunk.depth-of-chunk">
      <xsl:with-param name="node" select="$node"/>
    </xsl:call-template>
  </xsl:param>
  <yelp:document href="{$href}">
    <xsl:call-template name="db.chunk.content">
      <xsl:with-param name="node" select="$node"/>
      <xsl:with-param name="info" select="$info"/>
      <xsl:with-param name="template" select="$template"/>
      <xsl:with-param name="depth_of_chunk" select="$depth_of_chunk"/>
    </xsl:call-template>
  </yelp:document>
</xsl:template>

<!-- == db2html.admon.image == -->
<xsl:template name="db2html.admon.image">
  <xsl:param name="node" select="."/>
  <img style="float:left;">
    <xsl:attribute name="src">
      <xsl:choose>
        <xsl:when test="$node/self::caution">
          <xsl:value-of select="$yelp.image.caution"/>
        </xsl:when>
        <xsl:when test="$node/self::important">
          <xsl:value-of select="$yelp.image.important"/>
        </xsl:when>
        <xsl:when test="$node/self::note">
          <xsl:value-of select="$yelp.image.note"/>
        </xsl:when>
        <xsl:when test="$node/self::tip">
          <xsl:value-of select="$yelp.image.tip"/>
        </xsl:when>
        <xsl:when test="$node/self::warning">
          <xsl:value-of select="$yelp.image.warning"/>
        </xsl:when>
      </xsl:choose>
    </xsl:attribute>
  </img>
</xsl:template>

<!-- == db2html.css.custom == -->
<xsl:template name="db2html.css.custom">
  <xsl:text>
    div[class="programlisting"] {
      background-image: url(</xsl:text>
      <xsl:value-of select="$yelp.image.programlisting"/><xsl:text>);
      background-repeat: no-repeat;
    }
   div[class="blockquote"] {
      background-image: url(</xsl:text>
      <xsl:value-of select="$yelp.image.blockquote"/><xsl:text>);
      background-repeat: no-repeat;
    }
  </xsl:text>
</xsl:template>

<!--
<xsl:variable name="newline"><xsl:text>
</xsl:text></xsl:variable>

<xsl:include href="db2html-param.xsl"/>

<xsl:include href="gettext.xsl"/>

<xsl:include href="db2html-common.xsl"/>
<xsl:include href="db2html-header.xsl"/>
<xsl:include href="db2html-title.xsl"/>

<xsl:include href="db2html-chunk.xsl"/>
<xsl:include href="db2html-html.xsl"/>
<xsl:include href="db2html-navbar.xsl"/>

<xsl:include href="db2html-suppressed.xsl"/>

<xsl:include href="db2html-division.xsl"/>
<xsl:include href="db2html-titlepage.xsl"/>

<xsl:include href="db2html-admon.xsl"/>
<xsl:include href="db2html-biblio.xsl"/>
<xsl:include href="db2html-block.xsl"/>
<xsl:include href="db2html-callout.xsl"/>
<xsl:include href="db2html-glossary.xsl"/>
<xsl:include href="db2html-index.xsl"/>
<xsl:include href="db2html-inline.xsl"/>
<xsl:include href="db2html-list.xsl"/>
<xsl:include href="db2html-media.xsl"/>
<xsl:include href="db2html-refentry.xsl"/>
<xsl:include href="db2html-synopsis.xsl"/>
<xsl:include href="db2html-table.xsl"/>
<xsl:include href="db2html-toc.xsl"/>
<xsl:include href="db2html-xref.xsl"/>

<xsl:template match="/">
	<xsl:call-template name="chunk">
		<xsl:with-param name="node" select="*"/>
	</xsl:call-template>
</xsl:template>

<xsl:template match="*">
	<xsl:call-template name="FIXME"/>
</xsl:template>

<xsl:template name="FIXME">
	<span class="{name(.)}">
		<span class="FIXME" style="color: red">
			<xsl:apply-templates/>
		</span>
	</span>
</xsl:template>
-->

</xsl:stylesheet>
