/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

/*#include "xchat.h" */
typedef void *GtkWidget;
#include <string.h>
#include <glib.h>
#include <fcntl.h>
#include <time.h>
#include "cfgfiles.h"
#include "menu.h"
#include "util.h"


extern int handle_command (char *cmd, void *sess, int history, int nocommand);

extern GSList *ctcp_list;


void
ctcp_reply (void *sess, char *tbuf, char *nick, char *word[], char *word_eol[], char *conf)
{
   int i = 0, j = 0;

   while (1)
   {
      switch (conf[i])
      {
      case '%':
         i++;
         switch (conf[i])
         {
         case '\n':
         case 0:
            goto jump;
         case 'd':
            tbuf[j] = 0;
            strcat (tbuf, word_eol[5]);
            j = strlen (tbuf);
            break;
         case 's':
            tbuf[j] = 0;
            strcat (tbuf, nick);
            j = strlen (tbuf);
            break;
         case 't':
            {
               char timestr[64];
               long tt = time (0);
               char *p, *t = ctime (&tt);
               strcpy (timestr, t);
               p = strchr (timestr, '\n');
               if (p)
                  *p = 0;
               tbuf[j] = 0;
               strcat (tbuf, timestr);
               j = strlen (tbuf);
            }
            break;
         }
         break;
      case '\n':
      case 0:
       jump:
         tbuf[j] = 0;
         handle_command (tbuf, sess, 0, 0);
         return;
      default:
         tbuf[j] = conf[i];
         j++;
      }
      i++;
   }
}

int
ctcp_check (void *sess, char *tbuf, char *nick, char *word[], char *word_eol[], char *ctcp)
{
   int ret = 0;
   char *po;
   struct popup *pop;
   GSList *list = ctcp_list;

   po = strchr (ctcp, '\001');
   if (po)
      *po = 0;

   po = strchr (word_eol[5], '\001');
   if (po)
      *po = 0;

   while (list)
   {
      pop = (struct popup *) list->data;
      if (!strcasecmp (ctcp, pop->name))
      {
         ctcp_reply (sess, tbuf, nick, word, word_eol, pop->cmd);
         ret = 1;
      }
      list = list->next;
   }
   return ret;
}
