/*
 * Decompiled with CFR 0.152.
 */
package rdr;

import java.io.OutputStream;
import rdr.Exception;
import rdr.IOException;
import rdr.OutStream;

public class JavaOutStream
extends OutStream {
    static final int defaultBufSize = 16384;
    static final int minBulkSize = 1024;
    private OutputStream jos;
    private int ptrOffset;
    private int bufSize;

    public JavaOutStream(OutputStream outputStream, int n) {
        this.jos = outputStream;
        this.bufSize = n;
        this.b = new byte[this.bufSize];
        this.ptr = 0;
        this.end = this.bufSize;
    }

    public JavaOutStream(OutputStream outputStream) {
        this(outputStream, 16384);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        if (n2 < 1024) {
            super.writeBytes(byArray, n, n2);
            return;
        }
        this.flush();
        try {
            this.jos.write(byArray, n, n2);
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        this.ptrOffset += n2;
    }

    public void flush() {
        try {
            this.jos.write(this.b, 0, this.ptr);
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        this.ptrOffset += this.ptr;
        this.ptr = 0;
    }

    public int length() {
        return this.ptrOffset + this.ptr;
    }

    protected int overrun(int n, int n2) {
        if (n > this.bufSize) {
            throw new Exception("JavaOutStream overrun: max itemSize exceeded");
        }
        this.flush();
        if (n * n2 > this.end) {
            n2 = this.end / n;
        }
        return n2;
    }
}

