/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;
typedef struct _ValaVariablePrivate ValaVariablePrivate;
typedef struct _ValaLocalVariablePrivate ValaLocalVariablePrivate;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_FIELD_PROTOTYPE (vala_field_prototype_get_type ())
#define VALA_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototype))
#define VALA_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))
#define VALA_IS_FIELD_PROTOTYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_IS_FIELD_PROTOTYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD_PROTOTYPE))
#define VALA_FIELD_PROTOTYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypeClass))

typedef struct _ValaFieldPrototype ValaFieldPrototype;
typedef struct _ValaFieldPrototypeClass ValaFieldPrototypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
};

struct _ValaVariable {
	ValaSymbol parent_instance;
	ValaVariablePrivate * priv;
};

struct _ValaVariableClass {
	ValaSymbolClass parent_class;
};

struct _ValaLocalVariable {
	ValaVariable parent_instance;
	ValaLocalVariablePrivate * priv;
};

struct _ValaLocalVariableClass {
	ValaVariableClass parent_class;
};

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _floating;
	gboolean _captured;
	gboolean _no_init;
};


static gpointer vala_local_variable_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
enum  {
	VALA_LOCAL_VARIABLE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaVariable* vala_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_code_visitor_visit_local_variable (ValaCodeVisitor* self, ValaLocalVariable* local);
static void vala_local_variable_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_end_full_expression (ValaCodeVisitor* self, ValaExpression* expr);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
static void vala_local_variable_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_variable_set_initializer (ValaVariable* self, ValaExpression* value);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
static void vala_local_variable_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_field_prototype_get_type (void) G_GNUC_CONST;
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
GType vala_member_access_get_type (void) G_GNUC_CONST;
GType vala_lambda_expression_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_delegate_type_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
GType vala_pointer_type_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_value_owned (ValaDataType* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
GType vala_block_get_type (void) G_GNUC_CONST;
void vala_block_add_local_variable (ValaBlock* self, ValaLocalVariable* local);
void vala_symbol_set_active (ValaSymbol* self, gboolean value);
static gboolean vala_local_variable_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_local_variable_get_is_result (ValaLocalVariable* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
gboolean vala_local_variable_get_floating (ValaLocalVariable* self);
void vala_local_variable_set_floating (ValaLocalVariable* self, gboolean value);
gboolean vala_local_variable_get_captured (ValaLocalVariable* self);
void vala_local_variable_set_captured (ValaLocalVariable* self, gboolean value);
gboolean vala_local_variable_get_no_init (ValaLocalVariable* self);
void vala_local_variable_set_no_init (ValaLocalVariable* self, gboolean value);
static void vala_local_variable_finalize (ValaCodeNode* obj);



/**
 * Creates a new local variable.
 *
 * @param name   name of the variable
 * @param init   optional initializer expression
 * @param source reference to source code
 * @return       newly created variable declarator
 */
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference) {
	ValaLocalVariable* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference) {
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void vala_local_variable_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void vala_local_variable_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_variable_get_initializer ((ValaVariable*) self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_variable_get_initializer ((ValaVariable*) self), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_variable_get_initializer ((ValaVariable*) self));
	}
	if (vala_variable_get_variable_type ((ValaVariable*) self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_variable_get_variable_type ((ValaVariable*) self), visitor);
	}
}


static void vala_local_variable_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_variable_get_initializer ((ValaVariable*) self) == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void vala_local_variable_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_variable_get_variable_type ((ValaVariable*) self) == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_local_variable_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaSymbol* _tmp13_;
	ValaBlock* block;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (vala_variable_get_variable_type ((ValaVariable*) self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_variable_get_variable_type ((ValaVariable*) self), analyzer);
	}
	if (vala_variable_get_initializer ((ValaVariable*) self) != NULL) {
		vala_expression_set_target_type (vala_variable_get_initializer ((ValaVariable*) self), vala_variable_get_variable_type ((ValaVariable*) self));
		vala_code_node_check ((ValaCodeNode*) vala_variable_get_initializer ((ValaVariable*) self), analyzer);
	}
	if (vala_variable_get_variable_type ((ValaVariable*) self) == NULL) {
		ValaDataType* _tmp2_;
		if (vala_variable_get_initializer ((ValaVariable*) self) == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		if (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self)) == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		if (VALA_IS_FIELD_PROTOTYPE (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self)))) {
			char* _tmp1_;
			char* _tmp0_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_variable_get_initializer ((ValaVariable*) self)), _tmp1_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp0_ = vala_symbol_get_full_name (vala_expression_get_symbol_reference (vala_variable_get_initializer ((ValaVariable*) self)))));
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			result = FALSE;
			return result;
		}
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp2_ = vala_data_type_copy (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self))));
		_vala_code_node_unref0 (_tmp2_);
		vala_data_type_set_value_owned (vala_variable_get_variable_type ((ValaVariable*) self), TRUE);
		vala_data_type_set_floating_reference (vala_variable_get_variable_type ((ValaVariable*) self), FALSE);
		vala_expression_set_target_type (vala_variable_get_initializer ((ValaVariable*) self), vala_variable_get_variable_type ((ValaVariable*) self));
	}
	if (vala_variable_get_initializer ((ValaVariable*) self) != NULL) {
		_tmp3_ = !vala_code_node_get_error ((ValaCodeNode*) vala_variable_get_initializer ((ValaVariable*) self));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		if (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self)) == NULL) {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (!VALA_IS_MEMBER_ACCESS (vala_variable_get_initializer ((ValaVariable*) self))) {
				_tmp4_ = !VALA_IS_LAMBDA_EXPRESSION (vala_variable_get_initializer ((ValaVariable*) self));
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			if (VALA_IS_METHOD (vala_expression_get_symbol_reference (vala_variable_get_initializer ((ValaVariable*) self)))) {
				_tmp5_ = VALA_IS_DELEGATE_TYPE (vala_variable_get_variable_type ((ValaVariable*) self));
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				ValaMethod* m;
				ValaDelegateType* dt;
				ValaDelegate* cb;
				m = _vala_code_node_ref0 (VALA_METHOD (vala_expression_get_symbol_reference (vala_variable_get_initializer ((ValaVariable*) self))));
				dt = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_variable_get_variable_type ((ValaVariable*) self)));
				cb = _vala_code_node_ref0 (vala_delegate_type_get_delegate_symbol (dt));
				if (!vala_delegate_matches_method (cb, m, (ValaDataType*) dt)) {
					char* _tmp8_;
					char* _tmp7_;
					char* _tmp6_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp8_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) m), _tmp7_ = vala_symbol_get_full_name ((ValaSymbol*) cb)));
					_g_free0 (_tmp8_);
					_g_free0 (_tmp7_);
					_g_free0 (_tmp6_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				vala_expression_set_value_type (vala_variable_get_initializer ((ValaVariable*) self), vala_variable_get_variable_type ((ValaVariable*) self));
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		if (!vala_data_type_compatible (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self)), vala_variable_get_variable_type ((ValaVariable*) self))) {
			char* _tmp11_;
			char* _tmp10_;
			char* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp11_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp9_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self))), _tmp10_ = vala_code_node_to_string ((ValaCodeNode*) vala_variable_get_variable_type ((ValaVariable*) self))));
			_g_free0 (_tmp11_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp9_);
			result = FALSE;
			return result;
		}
		if (vala_data_type_is_disposable (vala_expression_get_value_type (vala_variable_get_initializer ((ValaVariable*) self)))) {
			gboolean _tmp12_ = FALSE;
			if (!VALA_IS_POINTER_TYPE (vala_variable_get_variable_type ((ValaVariable*) self))) {
				_tmp12_ = !vala_data_type_get_value_owned (vala_variable_get_variable_type ((ValaVariable*) self));
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	vala_scope_add (vala_symbol_get_scope (vala_semantic_analyzer_get_current_symbol (analyzer)), vala_symbol_get_name ((ValaSymbol*) self), (ValaSymbol*) self);
	block = _vala_code_node_ref0 ((_tmp13_ = vala_semantic_analyzer_get_current_symbol (analyzer), VALA_IS_BLOCK (_tmp13_) ? ((ValaBlock*) _tmp13_) : NULL));
	if (block != NULL) {
		vala_block_add_local_variable (block, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_code_node_unref0 (block);
	return result;
}


gboolean vala_local_variable_get_is_result (ValaLocalVariable* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}


void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean vala_local_variable_get_floating (ValaLocalVariable* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_floating;
	return result;
}


void vala_local_variable_set_floating (ValaLocalVariable* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_floating = value;
}


gboolean vala_local_variable_get_captured (ValaLocalVariable* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}


void vala_local_variable_set_captured (ValaLocalVariable* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean vala_local_variable_get_no_init (ValaLocalVariable* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_init;
	return result;
}


void vala_local_variable_set_no_init (ValaLocalVariable* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_init = value;
}


static void vala_local_variable_class_init (ValaLocalVariableClass * klass) {
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_local_variable_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_local_variable_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_local_variable_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_local_variable_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_local_variable_real_check;
}


static void vala_local_variable_instance_init (ValaLocalVariable * self) {
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void vala_local_variable_finalize (ValaCodeNode* obj) {
	ValaLocalVariable * self;
	self = VALA_LOCAL_VARIABLE (obj);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType vala_local_variable_get_type (void) {
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}




