/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;
typedef struct _ValaDelegatePrivate ValaDelegatePrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_take_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
};

struct _ValaDelegate {
	ValaTypeSymbol parent_instance;
	ValaDelegatePrivate * priv;
};

struct _ValaDelegateClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaDelegatePrivate {
	gboolean _has_target;
	ValaDataType* _sender_type;
	double _cinstance_parameter_position;
	double _carray_length_parameter_position;
	double _cdelegate_target_parameter_position;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	ValaList* type_parameters;
	ValaList* parameters;
	char* cname;
	ValaDataType* _return_type;
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;


static gpointer vala_delegate_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_delegate_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_formal_parameter_get_type (void);
#define VALA_DELEGATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE, ValaDelegatePrivate))
enum  {
	VALA_DELEGATE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value);
void vala_delegate_set_cinstance_parameter_position (ValaDelegate* self, double value);
void vala_delegate_set_carray_length_parameter_position (ValaDelegate* self, double value);
void vala_delegate_set_cdelegate_target_parameter_position (ValaDelegate* self, double value);
ValaDelegate* vala_delegate_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaDelegate* vala_delegate_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
void vala_formal_parameter_set_cparameter_position (ValaFormalParameter* self, double value);
double vala_formal_parameter_get_cparameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_carray_length_parameter_position (ValaFormalParameter* self, double value);
void vala_formal_parameter_set_cdelegate_target_parameter_position (ValaFormalParameter* self, double value);
void vala_formal_parameter_set_cdestroy_notify_parameter_position (ValaFormalParameter* self, double value);
void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param);
ValaList* vala_delegate_get_parameters (ValaDelegate* self);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2);
ValaDataType* vala_delegate_get_return_type (ValaDelegate* self);
ValaList* vala_method_get_parameters (ValaMethod* self);
ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
GType member_binding_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
gboolean vala_delegate_get_has_target (ValaDelegate* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m);
void vala_code_visitor_visit_delegate (ValaCodeVisitor* self, ValaDelegate* d);
static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
static char* vala_delegate_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
void vala_delegate_set_cname (ValaDelegate* self, const char* cname);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_delegate_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_delegate_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
double vala_attribute_get_double (ValaAttribute* self, const char* name);
void vala_delegate_set_no_array_length (ValaDelegate* self, gboolean value);
void vala_delegate_set_array_null_terminated (ValaDelegate* self, gboolean value);
void vala_typesymbol_add_cheader_filename (ValaTypeSymbol* self, const char* filename);
static void vala_delegate_process_ccode_attribute (ValaDelegate* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_delegate_process_attributes (ValaDelegate* self);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static char* vala_delegate_real_get_type_id (ValaTypeSymbol* base);
static char* vala_delegate_real_get_marshaller_type_name (ValaTypeSymbol* base);
static char* vala_delegate_real_get_get_value_function (ValaTypeSymbol* base);
static char* vala_delegate_real_get_set_value_function (ValaTypeSymbol* base);
static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static char* vala_delegate_get_return_type_string (ValaDelegate* self);
static char* vala_delegate_get_parameters_string (ValaDelegate* self);
char* vala_delegate_get_prototype_string (ValaDelegate* self, const char* name);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
GType vala_reference_type_get_type (void);
char* vala_code_node_to_string (ValaCodeNode* self);
GType vala_parameter_direction_get_type (void);
ValaParameterDirection vala_formal_parameter_get_direction (ValaFormalParameter* self);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value);
double vala_delegate_get_cinstance_parameter_position (ValaDelegate* self);
double vala_delegate_get_carray_length_parameter_position (ValaDelegate* self);
double vala_delegate_get_cdelegate_target_parameter_position (ValaDelegate* self);
gboolean vala_delegate_get_no_array_length (ValaDelegate* self);
gboolean vala_delegate_get_array_null_terminated (ValaDelegate* self);
static void vala_delegate_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDelegate* vala_delegate_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaDelegate* self;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	vala_delegate_set_return_type (self, return_type);
	vala_delegate_set_cinstance_parameter_position (self, (double) (-2));
	vala_delegate_set_carray_length_parameter_position (self, (double) (-3));
	vala_delegate_set_cdelegate_target_parameter_position (self, (double) (-3));
	return self;
}


ValaDelegate* vala_delegate_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}


void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	vala_collection_add ((ValaCollection*) self->priv->type_parameters, p);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) p), (ValaSymbol*) p);
}


void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	vala_formal_parameter_set_cparameter_position (param, (double) (vala_collection_get_size ((ValaCollection*) self->priv->parameters) + 1));
	vala_formal_parameter_set_carray_length_parameter_position (param, vala_formal_parameter_get_cparameter_position (param) + 0.1);
	vala_formal_parameter_set_cdelegate_target_parameter_position (param, vala_formal_parameter_get_cparameter_position (param) + 0.1);
	vala_formal_parameter_set_cdestroy_notify_parameter_position (param, vala_formal_parameter_get_cparameter_position (param) + 0.1);
	vala_collection_add ((ValaCollection*) self->priv->parameters, param);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) param), (ValaSymbol*) param);
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vala_delegate_get_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->parameters);
	return result;
}


gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m) {
	gboolean result = FALSE;
	ValaList* method_params;
	ValaIterator* method_params_it;
	gboolean _tmp0_ = FALSE;
	gboolean first;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	if (!vala_data_type_stricter (vala_method_get_return_type (m), vala_delegate_get_return_type (self))) {
		result = FALSE;
		return result;
	}
	method_params = vala_method_get_parameters (m);
	method_params_it = vala_iterable_iterator ((ValaIterable*) method_params);
	if (self->priv->_sender_type != NULL) {
		_tmp0_ = vala_collection_get_size ((ValaCollection*) method_params) == (vala_collection_get_size ((ValaCollection*) self->priv->parameters) + 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaFormalParameter* method_param;
		vala_iterator_next (method_params_it);
		method_param = (ValaFormalParameter*) vala_iterator_get (method_params_it);
		if (!vala_data_type_stricter (self->priv->_sender_type, vala_formal_parameter_get_parameter_type (method_param))) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_collection_object_unref0 (method_params);
			_vala_collection_object_unref0 (method_params_it);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaIterator* _param_it;
		_param_it = vala_iterable_iterator ((ValaIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			ValaFormalParameter* method_param;
			if (!vala_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) vala_iterator_get (_param_it);
			if (first) {
				_tmp2_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_tmp1_ = !self->priv->_has_target;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			if (!vala_iterator_next (method_params_it)) {
				_vala_code_node_unref0 (param);
				break;
			}
			method_param = (ValaFormalParameter*) vala_iterator_get (method_params_it);
			if (!vala_data_type_stricter (vala_formal_parameter_get_parameter_type (param), vala_formal_parameter_get_parameter_type (method_param))) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (method_param);
				_vala_collection_object_unref0 (_param_it);
				_vala_collection_object_unref0 (method_params);
				_vala_collection_object_unref0 (method_params_it);
				return result;
			}
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (method_param);
		}
		_vala_collection_object_unref0 (_param_it);
	}
	if (vala_iterator_next (method_params_it)) {
		result = FALSE;
		_vala_collection_object_unref0 (method_params);
		_vala_collection_object_unref0 (method_params_it);
		return result;
	}
	result = TRUE;
	_vala_collection_object_unref0 (method_params);
	_vala_collection_object_unref0 (method_params_it);
	return result;
}


static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delegate (visitor, self);
}


static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!vala_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) vala_iterator_get (_p_it);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
	vala_code_node_accept ((ValaCodeNode*) vala_delegate_get_return_type (self), visitor);
	{
		ValaIterator* _param_it;
		_param_it = vala_iterable_iterator ((ValaIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!vala_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) vala_iterator_get (_param_it);
			vala_code_node_accept ((ValaCodeNode*) param, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_collection_object_unref0 (_param_it);
	}
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _error_type_it;
		_error_type_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* error_type;
			if (!vala_iterator_next (_error_type_it)) {
				break;
			}
			error_type = (ValaDataType*) vala_iterator_get (_error_type_it);
			vala_code_node_accept ((ValaCodeNode*) error_type, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_collection_object_unref0 (_error_type_it);
	}
}


static char* vala_delegate_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaDelegate * self;
	char* result = NULL;
	self = (ValaDelegate*) base;
	if (self->priv->cname == NULL) {
		char* _tmp1_;
		char* _tmp0_;
		self->priv->cname = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (self->priv->cname), _tmp1_);
		_g_free0 (_tmp0_);
	}
	result = g_strdup (self->priv->cname);
	return result;
}


void vala_delegate_set_cname (ValaDelegate* self, const char* cname) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	self->priv->cname = (_tmp0_ = g_strdup (cname), _g_free0 (self->priv->cname), _tmp0_);
}


static char* vala_delegate_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaDelegate * self;
	char* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	self = (ValaDelegate*) base;
	if (infix == NULL) {
		infix = "";
	}
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static char* vala_delegate_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaDelegate * self;
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaDelegate*) base;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static void vala_delegate_process_ccode_attribute (ValaDelegate* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "cname")) {
		char* _tmp0_;
		vala_delegate_set_cname (self, _tmp0_ = vala_attribute_get_string (a, "cname"));
		_g_free0 (_tmp0_);
	}
	if (vala_attribute_has_argument (a, "has_target")) {
		vala_delegate_set_has_target (self, vala_attribute_get_bool (a, "has_target"));
	}
	if (vala_attribute_has_argument (a, "instance_pos")) {
		vala_delegate_set_cinstance_parameter_position (self, vala_attribute_get_double (a, "instance_pos"));
	}
	if (vala_attribute_has_argument (a, "array_length")) {
		vala_delegate_set_no_array_length (self, !vala_attribute_get_bool (a, "array_length"));
	}
	if (vala_attribute_has_argument (a, "array_null_terminated")) {
		vala_delegate_set_array_null_terminated (self, vala_attribute_get_bool (a, "array_null_terminated"));
	}
	if (vala_attribute_has_argument (a, "array_length_pos")) {
		vala_delegate_set_carray_length_parameter_position (self, vala_attribute_get_double (a, "array_length_pos"));
	}
	if (vala_attribute_has_argument (a, "delegate_target_pos")) {
		vala_delegate_set_cdelegate_target_parameter_position (self, vala_attribute_get_double (a, "delegate_target_pos"));
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp1_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp1_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp1_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp1_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_delegate_process_attributes (ValaDelegate* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_delegate_process_ccode_attribute (self, a);
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}


static char* vala_delegate_real_get_type_id (ValaTypeSymbol* base) {
	ValaDelegate * self;
	char* result = NULL;
	self = (ValaDelegate*) base;
	result = g_strdup ("G_TYPE_POINTER");
	return result;
}


static char* vala_delegate_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaDelegate * self;
	char* result = NULL;
	self = (ValaDelegate*) base;
	result = g_strdup ("POINTER");
	return result;
}


static char* vala_delegate_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaDelegate * self;
	char* result = NULL;
	self = (ValaDelegate*) base;
	result = g_strdup ("g_value_get_pointer");
	return result;
}


static char* vala_delegate_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaDelegate * self;
	char* result = NULL;
	self = (ValaDelegate*) base;
	result = g_strdup ("g_value_set_pointer");
	return result;
}


static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDelegate * self;
	ValaList* error_types;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_delegate_get_return_type (self) == old_type) {
		vala_delegate_set_return_type (self, new_type);
		return;
	}
	error_types = vala_code_node_get_error_types ((ValaCodeNode*) self);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < vala_collection_get_size ((ValaCollection*) error_types))) {
					break;
				}
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) vala_list_get (error_types, i)) == old_type, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
					vala_list_set (error_types, i, new_type);
					_vala_collection_object_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_collection_object_unref0 (error_types);
}


char* vala_delegate_get_prototype_string (ValaDelegate* self, const char* name) {
	char* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = (_tmp2_ = g_strdup_printf ("%s %s %s", _tmp0_ = vala_delegate_get_return_type_string (self), name, _tmp1_ = vala_delegate_get_parameters_string (self)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static char* vala_delegate_get_return_type_string (ValaDelegate* self) {
	char* result = NULL;
	char* str;
	gboolean _tmp0_ = FALSE;
	char* _tmp3_;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	str = g_strdup ("");
	if (!vala_data_type_get_value_owned (vala_delegate_get_return_type (self))) {
		_tmp0_ = VALA_IS_REFERENCE_TYPE (vala_delegate_get_return_type (self));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		str = (_tmp1_ = g_strdup ("weak "), _g_free0 (str), _tmp1_);
	}
	str = (_tmp3_ = g_strconcat (str, _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) vala_delegate_get_return_type (self)), NULL), _g_free0 (str), _tmp3_);
	_g_free0 (_tmp2_);
	result = str;
	return result;
}


static char* vala_delegate_get_parameters_string (ValaDelegate* self) {
	char* result = NULL;
	char* str;
	gint i;
	char* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	str = g_strdup ("(");
	i = 1;
	{
		ValaIterator* _param_it;
		_param_it = vala_iterable_iterator ((ValaIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			char* _tmp7_;
			char* _tmp6_;
			if (!vala_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) vala_iterator_get (_param_it);
			if (i > 1) {
				char* _tmp0_;
				str = (_tmp0_ = g_strconcat (str, ", ", NULL), _g_free0 (str), _tmp0_);
			}
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
				if (vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) {
					char* _tmp1_;
					str = (_tmp1_ = g_strconcat (str, "owned ", NULL), _g_free0 (str), _tmp1_);
				}
			} else {
				gboolean _tmp4_ = FALSE;
				if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
					char* _tmp2_;
					str = (_tmp2_ = g_strconcat (str, "ref ", NULL), _g_free0 (str), _tmp2_);
				} else {
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						char* _tmp3_;
						str = (_tmp3_ = g_strconcat (str, "out ", NULL), _g_free0 (str), _tmp3_);
					}
				}
				if (!vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) {
					_tmp4_ = VALA_IS_REFERENCE_TYPE (vala_formal_parameter_get_parameter_type (param));
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					char* _tmp5_;
					str = (_tmp5_ = g_strconcat (str, "weak ", NULL), _g_free0 (str), _tmp5_);
				}
			}
			str = (_tmp7_ = g_strconcat (str, _tmp6_ = vala_code_node_to_string ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param)), NULL), _g_free0 (str), _tmp7_);
			_g_free0 (_tmp6_);
			i++;
			_vala_code_node_unref0 (param);
		}
		_vala_collection_object_unref0 (_param_it);
	}
	str = (_tmp8_ = g_strconcat (str, ")", NULL), _g_free0 (str), _tmp8_);
	result = str;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDelegate * self;
	gboolean result = FALSE;
	ValaSourceFile* old_source_file;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_delegate_process_attributes (self);
	old_source_file = _vala_source_file_ref0 (vala_semantic_analyzer_get_current_source_file (analyzer));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!vala_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) vala_iterator_get (_p_it);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
	vala_code_node_check ((ValaCodeNode*) vala_delegate_get_return_type (self), analyzer);
	{
		ValaIterator* _param_it;
		_param_it = vala_iterable_iterator ((ValaIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!vala_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) vala_iterator_get (_param_it);
			vala_code_node_check ((ValaCodeNode*) param, analyzer);
			_vala_code_node_unref0 (param);
		}
		_vala_collection_object_unref0 (_param_it);
	}
	{
		ValaList* _tmp0_;
		ValaIterator* _tmp1_;
		ValaIterator* _error_type_it;
		_error_type_it = (_tmp1_ = vala_iterable_iterator ((ValaIterable*) (_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), _vala_collection_object_unref0 (_tmp0_), _tmp1_);
		while (TRUE) {
			ValaDataType* error_type;
			if (!vala_iterator_next (_error_type_it)) {
				break;
			}
			error_type = (ValaDataType*) vala_iterator_get (_error_type_it);
			vala_code_node_check ((ValaCodeNode*) error_type, analyzer);
			_vala_code_node_unref0 (error_type);
		}
		_vala_collection_object_unref0 (_error_type_it);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_delegate_get_return_type (ValaDelegate* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_type;
	return result;
}


void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_return_type = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_return_type), _tmp0_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_return_type, (ValaCodeNode*) self);
}


gboolean vala_delegate_get_has_target (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_target;
	return result;
}


void vala_delegate_set_has_target (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_target = value;
}


ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sender_type;
	return result;
}


void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sender_type = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_sender_type), _tmp0_);
}


double vala_delegate_get_cinstance_parameter_position (ValaDelegate* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cinstance_parameter_position;
	return result;
}


void vala_delegate_set_cinstance_parameter_position (ValaDelegate* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_cinstance_parameter_position = value;
}


double vala_delegate_get_carray_length_parameter_position (ValaDelegate* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_carray_length_parameter_position;
	return result;
}


void vala_delegate_set_carray_length_parameter_position (ValaDelegate* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_carray_length_parameter_position = value;
}


double vala_delegate_get_cdelegate_target_parameter_position (ValaDelegate* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cdelegate_target_parameter_position;
	return result;
}


void vala_delegate_set_cdelegate_target_parameter_position (ValaDelegate* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_cdelegate_target_parameter_position = value;
}


gboolean vala_delegate_get_no_array_length (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_delegate_set_no_array_length (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_delegate_get_array_null_terminated (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_delegate_set_array_null_terminated (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


static void vala_delegate_class_init (ValaDelegateClass * klass) {
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_delegate_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegatePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_delegate_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_delegate_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_delegate_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_delegate_real_get_lower_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_delegate_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_delegate_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_delegate_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_delegate_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_delegate_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_delegate_real_get_set_value_function;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_delegate_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_delegate_real_check;
}


static void vala_delegate_instance_init (ValaDelegate * self) {
	self->priv = VALA_DELEGATE_GET_PRIVATE (self);
	self->priv->type_parameters = (ValaList*) vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->parameters = (ValaList*) vala_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_delegate_finalize (ValaCodeNode* obj) {
	ValaDelegate * self;
	self = VALA_DELEGATE (obj);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_collection_object_unref0 (self->priv->type_parameters);
	_vala_collection_object_unref0 (self->priv->parameters);
	_g_free0 (self->priv->cname);
	_vala_code_node_unref0 (self->priv->_return_type);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}


GType vala_delegate_get_type (void) {
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




