/* gstreamer-rtp-0.10.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cheader_filename = "gst/rtp/gstbasertpaudiopayload.h")]
	public class BaseRTPAudioPayload : Gst.BaseRTPPayload {
		public Gst.ClockTime base_ts;
		public int frame_duration;
		public int frame_size;
		public int sample_size;
		public unowned Gst.Adapter get_adapter ();
		public Gst.FlowReturn push (uchar data, uint payload_len, Gst.ClockTime timestamp);
		public void set_frame_based ();
		public void set_frame_options (int frame_duration, int frame_size);
		public void set_sample_based ();
		public void set_sample_options (int sample_size);
		public void set_samplebits_options (int sample_size);
	}
	[CCode (cheader_filename = "gst/rtp/gstbasertpdepayload.h")]
	public class BaseRTPDepayload : Gst.Element {
		public uint clock_rate;
		public bool need_newsegment;
		public weak GLib.Queue queue;
		public void* queuelock;
		public weak Gst.Segment segment;
		public weak Gst.Pad sinkpad;
		public weak Gst.Pad srcpad;
		public weak GLib.Thread thread;
		public bool thread_running;
		[NoWrapper]
		public virtual Gst.FlowReturn add_to_queue (Gst.Buffer @in);
		[NoWrapper]
		public virtual bool packet_lost (Gst.Event event);
		[NoWrapper]
		public virtual unowned Gst.Buffer process (Gst.Buffer @in);
		public Gst.FlowReturn push (Gst.Buffer out_buf);
		public Gst.FlowReturn push_ts (uint32 timestamp, Gst.Buffer out_buf);
		[NoWrapper]
		public virtual bool set_caps (Gst.Caps caps);
		[NoWrapper]
		public virtual void set_gst_timestamp (uint32 timestamp, Gst.Buffer buf);
		[NoAccessorMethod]
		public uint queue_delay { get; set; }
	}
	[CCode (cheader_filename = "gst/rtp/gstbasertpaudiopayload.h")]
	public class BaseRTPPayload : Gst.Element {
		public uint32 clock_rate;
		public uint current_ssrc;
		public bool @dynamic;
		public weak string encoding_name;
		public weak string media;
		public weak Gst.Segment segment;
		public weak GLib.Rand seq_rand;
		public uint16 seqnum_base;
		public weak Gst.Pad sinkpad;
		public weak Gst.Pad srcpad;
		public weak GLib.Rand ssrc_rand;
		public uint32 ts_base;
		public int32 ts_offset;
		public weak GLib.Rand ts_rand;
		[NoWrapper]
		public virtual unowned Gst.Caps get_caps (Gst.Pad pad);
		[NoWrapper]
		public virtual Gst.FlowReturn handle_buffer (Gst.Buffer buffer);
		[NoWrapper]
		public virtual bool handle_event (Gst.Pad pad, Gst.Event event);
		[CCode (cname = "gst_basertppayload_is_filled")]
		public bool is_filled (uint size, Gst.ClockTime duration);
		[CCode (cname = "gst_basertppayload_push")]
		public Gst.FlowReturn push (Gst.Buffer buffer);
		[NoWrapper]
		public virtual bool set_caps (Gst.Caps caps);
		[CCode (cname = "gst_basertppayload_set_options")]
		public void set_options (string media, bool @dynamic, string encoding_name, uint32 clock_rate);
		[CCode (cname = "gst_basertppayload_set_outcaps")]
		public bool set_outcaps (string fieldname);
		[NoAccessorMethod]
		public int64 max_ptime { get; set; }
		[NoAccessorMethod]
		public int64 min_ptime { get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set; }
		[NoAccessorMethod]
		public uint pt { get; set; }
		[NoAccessorMethod]
		public uint seqnum { get; }
		[NoAccessorMethod]
		public int seqnum_offset { get; set; }
		[NoAccessorMethod]
		public uint ssrc { get; set; }
		[NoAccessorMethod]
		public uint timestamp { get; }
		[NoAccessorMethod]
		public uint timestamp_offset { get; set; }
	}
	[Compact]
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public class RTPPayloadInfo {
		public uint bitrate;
		public uint clock_rate;
		public weak string encoding_name;
		public weak string encoding_parameters;
		public weak string media;
		public uchar payload_type;
		public static unowned Gst.RTPPayloadInfo for_name (string media, string encoding_name);
		public static unowned Gst.RTPPayloadInfo for_pt (uchar payload_type);
	}
	[CCode (type_id = "GST_TYPE_RTCP_PACKET", cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public struct RTCPPacket {
		public weak Gst.Buffer buffer;
		public uint offset;
		public bool padding;
		public uchar count;
		public Gst.RTCPType type;
		public uint16 length;
		public uint item_offset;
		public uint item_count;
		public uint entry_offset;
		public bool add_rb (uint32 ssrc, uchar fractionlost, int32 packetslost, uint32 exthighestseq, uint32 jitter, uint32 lsr, uint32 dlsr);
		public bool bye_add_ssrc (uint32 ssrc);
		public bool bye_add_ssrcs (uint32 ssrc, uint len);
		public uint32 bye_get_nth_ssrc (uint nth);
		public unowned string bye_get_reason ();
		public uchar bye_get_reason_len ();
		public uint bye_get_ssrc_count ();
		public bool bye_set_reason (string reason);
		public uchar get_count ();
		public uint16 get_length ();
		public bool get_padding ();
		public void get_rb (uint nth, uint32 ssrc, uchar fractionlost, int32 packetslost, uint32 exthighestseq, uint32 jitter, uint32 lsr, uint32 dlsr);
		public uint get_rb_count ();
		public bool move_to_next ();
		public bool remove ();
		public uint32 rr_get_ssrc ();
		public void rr_set_ssrc (uint32 ssrc);
		public bool sdes_add_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public bool sdes_add_item (uint32 ssrc);
		public bool sdes_copy_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public bool sdes_first_entry ();
		public bool sdes_first_item ();
		public bool sdes_get_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public uint sdes_get_item_count ();
		public uint32 sdes_get_ssrc ();
		public bool sdes_next_entry ();
		public bool sdes_next_item ();
		public void set_rb (uint nth, uint32 ssrc, uchar fractionlost, int32 packetslost, uint32 exthighestseq, uint32 jitter, uint32 lsr, uint32 dlsr);
		public void sr_get_sender_info (uint32 ssrc, uint64 ntptime, uint32 rtptime, uint32 packet_count, uint32 octet_count);
		public void sr_set_sender_info (uint32 ssrc, uint64 ntptime, uint32 rtptime, uint32 packet_count, uint32 octet_count);
	}
	[CCode (cprefix = "GST_RTCP_SDES_", has_type_id = "0", cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public enum RTCPSDESType {
		INVALID,
		END,
		CNAME,
		NAME,
		EMAIL,
		PHONE,
		LOC,
		TOOL,
		NOTE,
		PRIV
	}
	[CCode (cprefix = "GST_RTCP_TYPE_", has_type_id = "0", cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public enum RTCPType {
		INVALID,
		SR,
		RR,
		SDES,
		BYE,
		APP
	}
	[CCode (cprefix = "GST_RTP_PAYLOAD_", has_type_id = "0", cheader_filename = "gst/rtp/gstbasertpaudiopayload.h")]
	public enum RTPPayload {
		PCMU,
		@1016,
		G721,
		GSM,
		G723,
		DVI4_8000,
		DVI4_16000,
		LPC,
		PCMA,
		G722,
		L16_STEREO,
		L16_MONO,
		QCELP,
		CN,
		MPA,
		G728,
		DVI4_11025,
		DVI4_22050,
		G729,
		CELLB,
		JPEG,
		NV,
		H261,
		MPV,
		MP2T,
		H263
	}
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_MAX_BYE_SSRC_COUNT;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_MAX_RB_COUNT;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_MAX_SDES;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_MAX_SDES_ITEM_COUNT;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_VALID_MASK;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_VALID_VALUE;
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public const int RTCP_VERSION;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_1016_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_CELLB_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_CN_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_DVI4_11025_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_DVI4_16000_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_DVI4_22050_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_DVI4_8000_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_DYNAMIC_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G721_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G722_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const int RTP_PAYLOAD_G723_53;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G723_53_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const int RTP_PAYLOAD_G723_63;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G723_63_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G723_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G728_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_G729_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_GSM_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_H261_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_H263_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_JPEG_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_L16_MONO_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_L16_STEREO_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_LPC_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_MP2T_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_MPA_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_MPV_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_NV_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_PCMA_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_PCMU_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_QCELP_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const int RTP_PAYLOAD_TS41;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_TS41_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const int RTP_PAYLOAD_TS48;
	[CCode (cheader_filename = "gst/rtp/gstrtppayloads.h")]
	public const string RTP_PAYLOAD_TS48_STRING;
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public const int RTP_VERSION;
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool rtcp_buffer_add_packet (Gst.Buffer buffer, Gst.RTCPType type, ref Gst.RTCPPacket packet);
	[CCode (cheader_filename = "gst/gst.h")]
	public static void rtcp_buffer_end (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool rtcp_buffer_get_first_packet (Gst.Buffer buffer, ref Gst.RTCPPacket packet);
	[CCode (cheader_filename = "gst/gst.h")]
	public static uint rtcp_buffer_get_packet_count (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Buffer rtcp_buffer_new (uint mtu);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Buffer rtcp_buffer_new_copy_data (void* data, uint len);
	[CCode (cheader_filename = "gst/gst.h")]
	public static unowned Gst.Buffer rtcp_buffer_new_take_data (void* data, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public static bool rtcp_buffer_validate (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public static bool rtcp_buffer_validate_data (uchar data, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public static uint64 rtcp_ntp_to_unix (uint64 ntptime);
	[CCode (cheader_filename = "gst/rtp/gstrtcpbuffer.h")]
	public static uint64 rtcp_unix_to_ntp (uint64 unixtime);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_allocate_data (Gst.Buffer buffer, uint payload_len, uchar pad_len, uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_calc_header_len (uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_calc_packet_len (uint payload_len, uchar pad_len, uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_calc_payload_len (uint packet_len, uchar pad_len, uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static int rtp_buffer_compare_seqnum (uint16 seqnum1, uint16 seqnum2);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint32 rtp_buffer_default_clock_rate (uchar payload_type);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint64 rtp_buffer_ext_timestamp (uint64 exttimestamp, uint32 timestamp);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint32 rtp_buffer_get_csrc (Gst.Buffer buffer, uchar idx);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uchar rtp_buffer_get_csrc_count (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_get_extension (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_get_extension_data (Gst.Buffer buffer, out uint16 bits, out void* data, out uint wordlen);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_get_header_len (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_get_marker (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_get_packet_len (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_get_padding (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void* rtp_buffer_get_payload (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_get_payload_buffer (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint rtp_buffer_get_payload_len (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_get_payload_subbuffer (Gst.Buffer buffer, uint offset, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uchar rtp_buffer_get_payload_type (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint16 rtp_buffer_get_seq (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint32 rtp_buffer_get_ssrc (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uint32 rtp_buffer_get_timestamp (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static uchar rtp_buffer_get_version (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_new_allocate (uint payload_len, uchar pad_len, uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_new_allocate_len (uint packet_len, uchar pad_len, uchar csrc_count);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_new_copy_data (void* data, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static unowned Gst.Buffer rtp_buffer_new_take_data (void* data, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_pad_to (Gst.Buffer buffer, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_csrc (Gst.Buffer buffer, uchar idx, uint32 csrc);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_extension (Gst.Buffer buffer, bool extension);
	[CCode (cheader_filename = "gst/gst.h")]
	public static bool rtp_buffer_set_extension_data (Gst.Buffer buffer, uint16 bits, uint16 length);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_marker (Gst.Buffer buffer, bool marker);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_packet_len (Gst.Buffer buffer, uint len);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_padding (Gst.Buffer buffer, bool padding);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_payload_type (Gst.Buffer buffer, uchar payload_type);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_seq (Gst.Buffer buffer, uint16 seq);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_ssrc (Gst.Buffer buffer, uint32 ssrc);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_timestamp (Gst.Buffer buffer, uint32 timestamp);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static void rtp_buffer_set_version (Gst.Buffer buffer, uchar version);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_validate (Gst.Buffer buffer);
	[CCode (cheader_filename = "gst/rtp/gstrtpbuffer.h")]
	public static bool rtp_buffer_validate_data (uchar data, uint len);
}
