/* valastruct.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;
typedef struct _ValaStructPrivate ValaStructPrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_LOOP (vala_loop_get_type ())
#define VALA_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOOP, ValaLoop))
#define VALA_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOOP, ValaLoopClass))
#define VALA_IS_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOOP))
#define VALA_IS_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOOP))
#define VALA_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOOP, ValaLoopClass))

typedef struct _ValaLoop ValaLoop;
typedef struct _ValaLoopClass ValaLoopClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Represents a node in the symbol tree.
 */
struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

/**
 * Represents a runtime data type. This data type may be defined in Vala source
 * code or imported from an external library with a Vala API file.
 */
struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
	char* (*get_type_signature) (ValaTypeSymbol* self);
};

/**
 * Represents a struct declaration in the source code.
 */
struct _ValaStruct {
	ValaTypeSymbol parent_instance;
	ValaStructPrivate * priv;
};

struct _ValaStructClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaStructPrivate {
	GeeList* type_parameters;
	GeeList* constants;
	GeeList* fields;
	GeeList* methods;
	ValaDataType* _base_type;
	char* cname;
	char* const_cname;
	char* type_id;
	char* lower_case_cprefix;
	char* lower_case_csuffix;
	gboolean boolean_type;
	gboolean integer_type;
	gboolean floating_type;
	gint rank;
	char* marshaller_type_name;
	char* get_value_function;
	char* set_value_function;
	char* default_value;
	char* type_signature;
	char* copy_function;
	char* destroy_function;
	ValaMethod* _default_construction_method;
	gboolean _use_const;
	gboolean _has_type_id;
	gint _width;
	gboolean _signed;
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCodeVisitor* self, ValaLoop* stmt);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaStructValueType* gvalue_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaDataType* gvaluearray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};


static gpointer vala_struct_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_struct_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_member_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_method_get_type (void);
#define VALA_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT, ValaStructPrivate))
enum  {
	VALA_STRUCT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
ValaTypeSymbol* vala_typesymbol_new (const char* name, ValaSourceReference* source_reference);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference);
ValaStruct* vala_struct_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p);
GeeList* vala_struct_get_type_parameters (ValaStruct* self);
void vala_struct_add_constant (ValaStruct* self, ValaConstant* c);
void vala_struct_add_field (ValaStruct* self, ValaField* f);
GeeList* vala_struct_get_fields (ValaStruct* self);
GeeList* vala_struct_get_constants (ValaStruct* self);
GType member_binding_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
GType vala_formal_parameter_get_type (void);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void);
GeeList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
const char* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_struct_add_method (ValaStruct* self, ValaMethod* m);
GeeList* vala_struct_get_methods (ValaStruct* self);
void vala_code_visitor_visit_struct (ValaCodeVisitor* self, ValaStruct* st);
static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_struct_get_base_type (ValaStruct* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
char* vala_struct_get_default_cname (ValaStruct* self);
static char* vala_struct_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
void vala_struct_set_cname (ValaStruct* self, const char* cname);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
static void vala_struct_set_const_cname (ValaStruct* self, const char* cname);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_struct_real_get_lower_case_cprefix (ValaSymbol* base);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_struct_get_lower_case_csuffix (ValaStruct* self);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_struct_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
static char* vala_struct_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
MemberBinding vala_field_get_binding (ValaField* self);
ValaDataType* vala_field_get_field_type (ValaField* self);
char* vala_data_type_get_type_signature (ValaDataType* self);
static char* vala_struct_real_get_type_signature (ValaTypeSymbol* base);
ValaStruct* vala_struct_get_base_struct (ValaStruct* self);
gboolean vala_struct_is_boolean_type (ValaStruct* self);
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
gint vala_struct_get_rank (ValaStruct* self);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
void vala_typesymbol_add_cheader_filename (ValaTypeSymbol* self, const char* filename);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_struct_set_has_type_id (ValaStruct* self, gboolean value);
void vala_struct_set_type_id (ValaStruct* self, const char* name);
static void vala_struct_set_marshaller_type_name (ValaStruct* self, const char* name);
static void vala_struct_set_get_value_function (ValaStruct* self, const char* function);
static void vala_struct_set_set_value_function (ValaStruct* self, const char* function);
static void vala_struct_set_default_value (ValaStruct* self, const char* value);
void vala_struct_set_copy_function (ValaStruct* self, const char* name);
void vala_struct_set_destroy_function (ValaStruct* self, const char* name);
void vala_struct_set_use_const (ValaStruct* self, gboolean value);
static void vala_struct_process_ccode_attribute (ValaStruct* self, ValaAttribute* a);
static void vala_struct_process_boolean_type_attribute (ValaStruct* self, ValaAttribute* a);
gint vala_attribute_get_integer (ValaAttribute* self, const char* name);
void vala_struct_set_width (ValaStruct* self, gint value);
void vala_struct_set_signed (ValaStruct* self, gboolean value);
static void vala_struct_process_integer_type_attribute (ValaStruct* self, ValaAttribute* a);
static void vala_struct_process_floating_type_attribute (ValaStruct* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_struct_process_attributes (ValaStruct* self);
gboolean vala_struct_get_has_type_id (ValaStruct* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
gboolean vala_struct_is_simple_type (ValaStruct* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
static char* vala_struct_real_get_type_id (ValaTypeSymbol* base);
char* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
static char* vala_struct_real_get_marshaller_type_name (ValaTypeSymbol* base);
char* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
static char* vala_struct_real_get_get_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static char* vala_struct_real_get_set_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_default_value (ValaTypeSymbol* self);
static char* vala_struct_real_get_default_value (ValaTypeSymbol* base);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name);
ValaAttribute* vala_attribute_new (const char* name, ValaSourceReference* source_reference);
ValaAttribute* vala_attribute_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type);
void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value);
static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
static char* vala_struct_real_get_dup_function (ValaTypeSymbol* base);
static char* vala_struct_real_get_free_function (ValaTypeSymbol* base);
char* vala_struct_get_default_copy_function (ValaStruct* self);
static char* vala_struct_real_get_copy_function (ValaTypeSymbol* base);
char* vala_struct_get_default_destroy_function (ValaStruct* self);
static char* vala_struct_real_get_destroy_function (ValaTypeSymbol* base);
gboolean vala_data_type_is_disposable (ValaDataType* self);
gboolean vala_struct_is_disposable (ValaStruct* self);
GType vala_value_type_get_type (void);
GType vala_struct_value_type_get_type (void);
ValaTypeSymbol* vala_value_type_get_type_symbol (ValaValueType* self);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
GType vala_namespace_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_delegate_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_loop_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_member_access_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
static gboolean vala_struct_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self);
gboolean vala_struct_get_use_const (ValaStruct* self);
gint vala_struct_get_width (ValaStruct* self);
gboolean vala_struct_get_signed (ValaStruct* self);
static void vala_struct_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct* vala_struct_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaStruct* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaStruct*) vala_typesymbol_construct (object_type, name, source_reference);
	return self;
}


ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference) {
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gee_collection_add ((GeeCollection*) self->priv->type_parameters, p);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) p), (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
GeeList* vala_struct_get_type_parameters (ValaStruct* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->type_parameters);
	return result;
}


/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
void vala_struct_add_constant (ValaStruct* self, ValaConstant* c) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	gee_collection_add ((GeeCollection*) self->priv->constants, c);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) c), (ValaSymbol*) c);
}


/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
void vala_struct_add_field (ValaStruct* self, ValaField* f) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	gee_collection_add ((GeeCollection*) self->priv->fields, f);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
GeeList* vala_struct_get_fields (ValaStruct* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->fields);
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
GeeList* vala_struct_get_constants (ValaStruct* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->constants);
	return result;
}


/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
void vala_struct_add_method (ValaStruct* self, ValaMethod* m) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaFormalParameter* _tmp2_;
		ValaDataType* _tmp1_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		vala_method_set_this_parameter (m, _tmp2_ = vala_formal_parameter_new ("this", _tmp1_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self), NULL));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	_tmp3_ = FALSE;
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		GeeList* _tmp4_;
		_tmp4_ = NULL;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaLocalVariable* _tmp6_;
		ValaDataType* _tmp5_;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCreationMethod* _tmp7_;
		ValaCreationMethod* cm;
		gboolean _tmp8_;
		if (vala_symbol_get_name ((ValaSymbol*) m) == NULL) {
			vala_struct_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, "new");
		}
		_tmp7_ = NULL;
		cm = (_tmp7_ = VALA_CREATION_METHOD (m), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
		_tmp8_ = FALSE;
		if (vala_creation_method_get_class_name (cm) != NULL) {
			_tmp8_ = _vala_strcmp0 (vala_creation_method_get_class_name (cm), vala_symbol_get_name ((ValaSymbol*) self)) != 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			char* _tmp10_;
			char* _tmp9_;
			/* type_name is null for constructors generated by GIdlParser*/
			_tmp10_ = NULL;
			_tmp9_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), _tmp10_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self), vala_creation_method_get_class_name (cm)));
			_tmp10_ = (g_free (_tmp10_), NULL);
			_tmp9_ = (g_free (_tmp9_), NULL);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
			return;
		}
		(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	}
	gee_collection_add ((GeeCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
GeeList* vala_struct_get_methods (ValaStruct* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->methods);
	return result;
}


static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_struct (visitor, self);
}


static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_struct_get_base_type (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_struct_get_base_type (self), visitor);
	}
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		}
		(_c_it == NULL) ? NULL : (_c_it = (gee_collection_object_unref (_c_it), NULL));
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
}


static char* vala_struct_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaStruct * self;
	char* result;
	gboolean _tmp0_;
	const char* _tmp4_;
	self = (ValaStruct*) base;
	_tmp0_ = FALSE;
	if (const_type) {
		_tmp0_ = self->priv->const_cname != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const char* _tmp1_;
		_tmp1_ = NULL;
		result = (_tmp1_ = self->priv->const_cname, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
		return result;
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* attr;
		attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		if (attr != NULL) {
			char* _tmp2_;
			_tmp2_ = NULL;
			self->priv->cname = (_tmp2_ = vala_attribute_get_string (attr, "cname"), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp2_);
		}
		if (self->priv->cname == NULL) {
			char* _tmp3_;
			_tmp3_ = NULL;
			self->priv->cname = (_tmp3_ = vala_struct_get_default_cname (self), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp3_);
		}
		(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
	}
	_tmp4_ = NULL;
	result = (_tmp4_ = self->priv->cname, (_tmp4_ == NULL) ? NULL : g_strdup (_tmp4_));
	return result;
}


void vala_struct_set_cname (ValaStruct* self, const char* cname) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->cname = (_tmp1_ = (_tmp0_ = cname, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp1_);
}


/**
 * Returns the default name of this struct as it is used in C code.
 *
 * @return the name to be used in C code by default
 */
char* vala_struct_get_default_cname (ValaStruct* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static void vala_struct_set_const_cname (ValaStruct* self, const char* cname) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->const_cname = (_tmp1_ = (_tmp0_ = cname, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->const_cname = (g_free (self->priv->const_cname), NULL), _tmp1_);
}


static char* vala_struct_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp2_;
	self = (ValaStruct*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		char* _tmp1_;
		char* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->lower_case_cprefix = (_tmp1_ = g_strdup_printf ("%s_", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL)), self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL), _tmp1_);
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->lower_case_cprefix, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


static char* vala_struct_get_lower_case_csuffix (ValaStruct* self) {
	char* result;
	const char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->lower_case_csuffix = (_tmp0_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self)), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp0_);
	}
	_tmp1_ = NULL;
	result = (_tmp1_ = self->priv->lower_case_csuffix, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	return result;
}


static char* vala_struct_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaStruct * self;
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	self = (ValaStruct*) base;
	if (infix == NULL) {
		infix = "";
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_struct_get_lower_case_csuffix (self)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	return result;
}


static char* vala_struct_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaStruct * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaStruct*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_struct_real_get_type_signature (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp2_;
	self = (ValaStruct*) base;
	if (self->priv->type_signature == NULL) {
		GString* str;
		const char* _tmp1_;
		str = g_string_new ("");
		g_string_append_c (str, '(');
		{
			GeeIterator* _f_it;
			_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
			while (TRUE) {
				ValaField* f;
				if (!gee_iterator_next (_f_it)) {
					break;
				}
				f = (ValaField*) gee_iterator_get (_f_it);
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					char* _tmp0_;
					_tmp0_ = NULL;
					g_string_append (str, _tmp0_ = vala_data_type_get_type_signature (vala_field_get_field_type (f)));
					_tmp0_ = (g_free (_tmp0_), NULL);
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			}
			(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
		}
		g_string_append_c (str, ')');
		_tmp1_ = NULL;
		result = (_tmp1_ = str->str, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
		(str == NULL) ? NULL : (str = (g_string_free (str, TRUE), NULL));
		return result;
		(str == NULL) ? NULL : (str = (g_string_free (str, TRUE), NULL));
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->type_signature, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
gboolean vala_struct_is_boolean_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* _tmp0_;
		ValaStruct* st;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (st != NULL) {
			_tmp1_ = vala_struct_is_boolean_type (st);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	result = self->priv->boolean_type;
	return result;
}


/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean vala_struct_is_integer_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* _tmp0_;
		ValaStruct* st;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (st != NULL) {
			_tmp1_ = vala_struct_is_integer_type (st);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	result = self->priv->integer_type;
	return result;
}


/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean vala_struct_is_floating_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* _tmp0_;
		ValaStruct* st;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (st != NULL) {
			_tmp1_ = vala_struct_is_floating_type (st);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	result = self->priv->floating_type;
	return result;
}


/**
 * Returns the rank of this integer or floating point type.
 *
 * @return the rank if this is an integer or floating point type
 */
gint vala_struct_get_rank (ValaStruct* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->rank;
	return result;
}


static void vala_struct_process_ccode_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "const_cname")) {
		char* _tmp0_;
		_tmp0_ = NULL;
		vala_struct_set_const_cname (self, _tmp0_ = vala_attribute_get_string (a, "const_cname"));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* _tmp1_;
		_tmp1_ = NULL;
		self->priv->lower_case_cprefix = (_tmp1_ = vala_attribute_get_string (a, "cprefix"), self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL), _tmp1_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp2_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			_tmp2_ = NULL;
			filename_collection = _tmp2_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp2_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp2_); filename_it = filename_it + 1) {
				const char* _tmp3_;
				char* filename;
				_tmp3_ = NULL;
				filename = (_tmp3_ = filename_collection[filename_it], (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
				{
					vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) self, filename);
					filename = (g_free (filename), NULL);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		val = (g_free (val), NULL);
	}
	if (vala_attribute_has_argument (a, "has_type_id")) {
		vala_struct_set_has_type_id (self, vala_attribute_get_bool (a, "has_type_id"));
	}
	if (vala_attribute_has_argument (a, "type_id")) {
		char* _tmp4_;
		_tmp4_ = NULL;
		vala_struct_set_type_id (self, _tmp4_ = vala_attribute_get_string (a, "type_id"));
		_tmp4_ = (g_free (_tmp4_), NULL);
	}
	if (vala_attribute_has_argument (a, "marshaller_type_name")) {
		char* _tmp5_;
		_tmp5_ = NULL;
		vala_struct_set_marshaller_type_name (self, _tmp5_ = vala_attribute_get_string (a, "marshaller_type_name"));
		_tmp5_ = (g_free (_tmp5_), NULL);
	}
	if (vala_attribute_has_argument (a, "get_value_function")) {
		char* _tmp6_;
		_tmp6_ = NULL;
		vala_struct_set_get_value_function (self, _tmp6_ = vala_attribute_get_string (a, "get_value_function"));
		_tmp6_ = (g_free (_tmp6_), NULL);
	}
	if (vala_attribute_has_argument (a, "set_value_function")) {
		char* _tmp7_;
		_tmp7_ = NULL;
		vala_struct_set_set_value_function (self, _tmp7_ = vala_attribute_get_string (a, "set_value_function"));
		_tmp7_ = (g_free (_tmp7_), NULL);
	}
	if (vala_attribute_has_argument (a, "default_value")) {
		char* _tmp8_;
		_tmp8_ = NULL;
		vala_struct_set_default_value (self, _tmp8_ = vala_attribute_get_string (a, "default_value"));
		_tmp8_ = (g_free (_tmp8_), NULL);
	}
	if (vala_attribute_has_argument (a, "type_signature")) {
		char* _tmp9_;
		_tmp9_ = NULL;
		self->priv->type_signature = (_tmp9_ = vala_attribute_get_string (a, "type_signature"), self->priv->type_signature = (g_free (self->priv->type_signature), NULL), _tmp9_);
	}
	if (vala_attribute_has_argument (a, "copy_function")) {
		char* _tmp10_;
		_tmp10_ = NULL;
		vala_struct_set_copy_function (self, _tmp10_ = vala_attribute_get_string (a, "copy_function"));
		_tmp10_ = (g_free (_tmp10_), NULL);
	}
	if (vala_attribute_has_argument (a, "destroy_function")) {
		char* _tmp11_;
		_tmp11_ = NULL;
		vala_struct_set_destroy_function (self, _tmp11_ = vala_attribute_get_string (a, "destroy_function"));
		_tmp11_ = (g_free (_tmp11_), NULL);
	}
	if (vala_attribute_has_argument (a, "use_const")) {
		vala_struct_set_use_const (self, vala_attribute_get_bool (a, "use_const"));
	}
}


static void vala_struct_process_boolean_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->boolean_type = TRUE;
}


static void vala_struct_process_integer_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->integer_type = TRUE;
	if (vala_attribute_has_argument (a, "rank")) {
		self->priv->rank = vala_attribute_get_integer (a, "rank");
	}
	if (vala_attribute_has_argument (a, "width")) {
		vala_struct_set_width (self, vala_attribute_get_integer (a, "width"));
	}
	if (vala_attribute_has_argument (a, "signed")) {
		vala_struct_set_signed (self, vala_attribute_get_bool (a, "signed"));
	}
}


static void vala_struct_process_floating_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->floating_type = TRUE;
	if (vala_attribute_has_argument (a, "rank")) {
		self->priv->rank = vala_attribute_get_integer (a, "rank");
	}
	if (vala_attribute_has_argument (a, "width")) {
		vala_struct_set_width (self, vala_attribute_get_integer (a, "width"));
	}
}


/**
 * Process all associated attributes.
 */
void vala_struct_process_attributes (ValaStruct* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = NULL;
			a = (_tmp0_ = (ValaAttribute*) a_it->data, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_struct_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "BooleanType") == 0) {
						vala_struct_process_boolean_type_attribute (self, a);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "IntegerType") == 0) {
							vala_struct_process_integer_type_attribute (self, a);
						} else {
							if (_vala_strcmp0 (vala_attribute_get_name (a), "FloatingType") == 0) {
								vala_struct_process_floating_type_attribute (self, a);
							}
						}
					}
				}
				(a == NULL) ? NULL : (a = (vala_code_node_unref (a), NULL));
			}
		}
	}
}


static char* vala_struct_real_get_type_id (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp2_;
	self = (ValaStruct*) base;
	if (self->priv->type_id == NULL) {
		if (!self->priv->_has_type_id) {
			if (vala_struct_get_base_type (self) != NULL) {
				ValaStruct* _tmp0_;
				ValaStruct* st;
				_tmp0_ = NULL;
				st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
				if (st != NULL) {
					result = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st);
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return result;
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			}
			if (vala_struct_is_simple_type (self)) {
				result = NULL;
				return result;
			} else {
				result = g_strdup ("G_TYPE_POINTER");
				return result;
			}
		} else {
			char* _tmp1_;
			_tmp1_ = NULL;
			self->priv->type_id = (_tmp1_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_"), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp1_);
		}
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->type_id, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


void vala_struct_set_type_id (ValaStruct* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->type_id = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp1_);
}


static char* vala_struct_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp3_;
	self = (ValaStruct*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* _tmp0_;
			ValaStruct* st;
			_tmp0_ = NULL;
			st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			if (st != NULL) {
				result = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) st);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				return result;
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp2_;
			char* _tmp1_;
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp2_ = g_strdup_printf ("The type `%s` doesn't declare a marshaller type name", _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp2_ = (g_free (_tmp2_), NULL);
			_tmp1_ = (g_free (_tmp1_), NULL);
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("BOXED");
				return result;
			} else {
				result = g_strdup ("POINTER");
				return result;
			}
		}
	}
	_tmp3_ = NULL;
	result = (_tmp3_ = self->priv->marshaller_type_name, (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
	return result;
}


static void vala_struct_set_marshaller_type_name (ValaStruct* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->marshaller_type_name = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL), _tmp1_);
}


static char* vala_struct_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->get_value_function == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* _tmp0_;
			ValaStruct* st;
			_tmp0_ = NULL;
			st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			if (st != NULL) {
				result = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) st);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				return result;
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp2_;
			char* _tmp1_;
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp2_ = g_strdup_printf ("The value type `%s` doesn't declare a GValue get function", _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp2_ = (g_free (_tmp2_), NULL);
			_tmp1_ = (g_free (_tmp1_), NULL);
			result = NULL;
			return result;
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("g_value_get_boxed");
				return result;
			} else {
				result = g_strdup ("g_value_get_pointer");
				return result;
			}
		}
	} else {
		const char* _tmp3_;
		_tmp3_ = NULL;
		result = (_tmp3_ = self->priv->get_value_function, (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
		return result;
	}
}


static char* vala_struct_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->set_value_function == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* _tmp0_;
			ValaStruct* st;
			_tmp0_ = NULL;
			st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			if (st != NULL) {
				result = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) st);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				return result;
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp2_;
			char* _tmp1_;
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp2_ = g_strdup_printf ("The value type `%s` doesn't declare a GValue set function", _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp2_ = (g_free (_tmp2_), NULL);
			_tmp1_ = (g_free (_tmp1_), NULL);
			result = NULL;
			return result;
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("g_value_set_boxed");
				return result;
			} else {
				result = g_strdup ("g_value_set_pointer");
				return result;
			}
		}
	} else {
		const char* _tmp3_;
		_tmp3_ = NULL;
		result = (_tmp3_ = self->priv->set_value_function, (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
		return result;
	}
}


static void vala_struct_set_get_value_function (ValaStruct* self, const char* function) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->get_value_function = (_tmp1_ = (_tmp0_ = function, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp1_);
}


static void vala_struct_set_set_value_function (ValaStruct* self, const char* function) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->set_value_function = (_tmp1_ = (_tmp0_ = function, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp1_);
}


static char* vala_struct_real_get_default_value (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->default_value != NULL) {
		const char* _tmp0_;
		_tmp0_ = NULL;
		result = (_tmp0_ = self->priv->default_value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
		return result;
	}
	/* inherit default value from base type*/
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* _tmp1_;
		ValaStruct* st;
		_tmp1_ = NULL;
		st = (_tmp1_ = vala_struct_get_base_struct (self), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		if (st != NULL) {
			result = vala_typesymbol_get_default_value ((ValaTypeSymbol*) st);
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	result = NULL;
	return result;
}


static void vala_struct_set_default_value (ValaStruct* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->default_value = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->default_value = (g_free (self->priv->default_value), NULL), _tmp1_);
}


static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name) {
	ValaStruct * self;
	gint result;
	gint i;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), name) == 0) {
				result = i;
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
				(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
				return result;
			}
			i++;
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	result = -1;
	return result;
}


/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean vala_struct_is_simple_type (ValaStruct* self) {
	gboolean result;
	ValaAttribute* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* _tmp0_;
		ValaStruct* st;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		st = (_tmp0_ = vala_struct_get_base_struct (self), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (st != NULL) {
			_tmp1_ = vala_struct_is_simple_type (st);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	_tmp2_ = NULL;
	if ((_tmp3_ = (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ByRef")) != NULL, (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_)) {
		/* used by time_t*/
		result = FALSE;
		return result;
	}
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	if (self->priv->boolean_type) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = self->priv->integer_type;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = self->priv->floating_type;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		ValaAttribute* _tmp7_;
		_tmp7_ = NULL;
		_tmp4_ = (_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType")) != NULL;
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_code_node_unref (_tmp7_), NULL));
	}
	result = _tmp4_;
	return result;
}


/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type) {
	g_return_if_fail (self != NULL);
	((ValaCodeNode*) self)->attributes = g_list_append (((ValaCodeNode*) self)->attributes, vala_attribute_new ("SimpleType", NULL));
}


static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_struct_get_base_type (self) == old_type) {
		vala_struct_set_base_type (self, new_type);
	}
}


static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaStruct * self;
	gboolean result;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	if (vala_struct_get_base_type (self) != NULL) {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_data_type_get_data_type (vala_struct_get_base_type (self)) != NULL) {
			_tmp0_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_struct_get_base_type (self)), t);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static char* vala_struct_real_get_dup_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	/* TODO use attribute check instead*/
	if (vala_symbol_get_external_package ((ValaSymbol*) self)) {
		result = NULL;
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "dup", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		return result;
	}
}


static char* vala_struct_real_get_free_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	/* TODO use attribute check instead*/
	if (vala_symbol_get_external_package ((ValaSymbol*) self)) {
		result = NULL;
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "free", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		return result;
	}
}


char* vala_struct_get_default_copy_function (ValaStruct* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "copy", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_struct_real_get_copy_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp1_;
	self = (ValaStruct*) base;
	if (self->priv->copy_function == NULL) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->copy_function = (_tmp0_ = vala_struct_get_default_copy_function (self), self->priv->copy_function = (g_free (self->priv->copy_function), NULL), _tmp0_);
	}
	_tmp1_ = NULL;
	result = (_tmp1_ = self->priv->copy_function, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	return result;
}


void vala_struct_set_copy_function (ValaStruct* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->copy_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->copy_function = (g_free (self->priv->copy_function), NULL), _tmp1_);
}


char* vala_struct_get_default_destroy_function (ValaStruct* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "destroy", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_struct_real_get_destroy_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	const char* _tmp1_;
	self = (ValaStruct*) base;
	if (self->priv->destroy_function == NULL) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->destroy_function = (_tmp0_ = vala_struct_get_default_destroy_function (self), self->priv->destroy_function = (g_free (self->priv->destroy_function), NULL), _tmp0_);
	}
	_tmp1_ = NULL;
	result = (_tmp1_ = self->priv->destroy_function, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	return result;
}


void vala_struct_set_destroy_function (ValaStruct* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->destroy_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->destroy_function = (g_free (self->priv->destroy_function), NULL), _tmp1_);
}


gboolean vala_struct_is_disposable (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->destroy_function != NULL) {
		result = TRUE;
		return result;
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			gboolean _tmp0_;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			_tmp0_ = FALSE;
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp0_ = vala_data_type_is_disposable (vala_field_get_field_type (f));
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = TRUE;
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
				return result;
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	result = FALSE;
	return result;
}


static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type) {
	gboolean result;
	ValaStructValueType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaStructValueType* struct_type;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	struct_type = (_tmp1_ = (_tmp0_ = type, VALA_IS_STRUCT_VALUE_TYPE (_tmp0_) ? ((ValaStructValueType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (struct_type != NULL) {
		ValaStruct* _tmp2_;
		ValaStruct* st;
		_tmp2_ = NULL;
		st = (_tmp2_ = VALA_STRUCT (vala_value_type_get_type_symbol ((ValaValueType*) struct_type)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		if (st == self) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(struct_type == NULL) ? NULL : (struct_type = (vala_code_node_unref (struct_type), NULL));
			return result;
		}
		{
			GeeIterator* _f_it;
			_f_it = gee_iterable_iterator ((GeeIterable*) st->priv->fields);
			while (TRUE) {
				ValaField* f;
				gboolean _tmp3_;
				if (!gee_iterator_next (_f_it)) {
					break;
				}
				f = (ValaField*) gee_iterator_get (_f_it);
				_tmp3_ = FALSE;
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					_tmp3_ = vala_struct_is_recursive_value_type (self, vala_field_get_field_type (f));
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = TRUE;
					(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
					(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(struct_type == NULL) ? NULL : (struct_type = (vala_code_node_unref (struct_type), NULL));
					return result;
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			}
			(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	result = FALSE;
	(struct_type == NULL) ? NULL : (struct_type = (vala_code_node_unref (struct_type), NULL));
	return result;
}


static gboolean vala_struct_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaStruct * self;
	gboolean result;
	ValaSourceFile* _tmp0_;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp1_;
	ValaSymbol* old_symbol;
	ValaStruct* _tmp2_;
	ValaStruct* old_struct;
	ValaStruct* _tmp4_;
	ValaStruct* _tmp3_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	ValaStruct* _tmp18_;
	ValaStruct* _tmp17_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_struct_process_attributes (self);
	_tmp0_ = NULL;
	old_source_file = (_tmp0_ = vala_semantic_analyzer_get_current_source_file (analyzer), (_tmp0_ == NULL) ? NULL : vala_source_file_ref (_tmp0_));
	_tmp1_ = NULL;
	old_symbol = (_tmp1_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	old_struct = (_tmp2_ = analyzer->current_struct, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	analyzer->current_struct = (_tmp4_ = (_tmp3_ = self, (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp4_);
	if (vala_struct_get_base_type (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_struct_get_base_type (self), analyzer);
		if (!VALA_IS_VALUE_TYPE (vala_struct_get_base_type (self))) {
			char* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp7_ = g_strdup_printf ("The base type `%s` of struct `%s` is not a struct", _tmp5_ = vala_code_node_to_string ((ValaCodeNode*) vala_struct_get_base_type (self)), _tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp7_ = (g_free (_tmp7_), NULL);
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			result = FALSE;
			(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
			(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
			(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
			return result;
		}
	}
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			gboolean _tmp8_;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_check ((ValaCodeNode*) f, analyzer);
			_tmp8_ = FALSE;
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp8_ = vala_struct_is_recursive_value_type (self, vala_field_get_field_type (f));
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "Recursive value types are not allowed");
				result = FALSE;
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
				return result;
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_check ((ValaCodeNode*) c, analyzer);
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		}
		(_c_it == NULL) ? NULL : (_c_it = (gee_collection_object_unref (_c_it), NULL));
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_check ((ValaCodeNode*) m, analyzer);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	_tmp9_ = FALSE;
	_tmp10_ = FALSE;
	_tmp11_ = FALSE;
	_tmp12_ = FALSE;
	_tmp13_ = FALSE;
	_tmp14_ = FALSE;
	if (!vala_symbol_get_external ((ValaSymbol*) self)) {
		_tmp14_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = vala_struct_get_base_type (self) == NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GeeList* _tmp15_;
		_tmp15_ = NULL;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) (_tmp15_ = vala_struct_get_fields (self))) == 0;
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (gee_collection_object_unref (_tmp15_), NULL));
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = !vala_struct_is_boolean_type (self);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = !vala_struct_is_integer_type (self);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = !vala_struct_is_floating_type (self);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		char* _tmp16_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp16_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp16_ = g_strdup_printf ("structs cannot be empty: %s", vala_symbol_get_name ((ValaSymbol*) self)));
		_tmp16_ = (g_free (_tmp16_), NULL);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	analyzer->current_struct = (_tmp18_ = (_tmp17_ = old_struct, (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp18_);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
	return result;
}


ValaDataType* vala_struct_get_base_type (ValaStruct* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_type;
	return result;
}


void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value) {
	ValaDataType* _tmp1_;
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) value, (ValaCodeNode*) self);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_base_type = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_base_type == NULL) ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL)), _tmp1_);
}


ValaStruct* vala_struct_get_base_struct (ValaStruct* self) {
	ValaStruct* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_base_type != NULL) {
		ValaTypeSymbol* _tmp0_;
		_tmp0_ = NULL;
		result = (_tmp0_ = vala_data_type_get_data_type (self->priv->_base_type), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		return result;
	}
	result = NULL;
	return result;
}


ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value) {
	ValaMethod* _tmp1_;
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_default_construction_method = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_default_construction_method == NULL) ? NULL : (self->priv->_default_construction_method = (vala_code_node_unref (self->priv->_default_construction_method), NULL)), _tmp1_);
}


gboolean vala_struct_get_use_const (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_const;
	return result;
}


void vala_struct_set_use_const (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_const = value;
}


gboolean vala_struct_get_has_type_id (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_type_id;
	return result;
}


void vala_struct_set_has_type_id (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_type_id = value;
}


gint vala_struct_get_width (ValaStruct* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}


void vala_struct_set_width (ValaStruct* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
}


gboolean vala_struct_get_signed (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_signed;
	return result;
}


void vala_struct_set_signed (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_signed = value;
}


static void vala_struct_class_init (ValaStructClass * klass) {
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_struct_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_struct_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_struct_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_struct_real_get_lower_case_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_struct_real_get_lower_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_struct_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_signature = vala_struct_real_get_type_signature;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_struct_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_struct_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_struct_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_struct_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_default_value = vala_struct_real_get_default_value;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_struct_real_get_type_parameter_index;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_struct_real_replace_type;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_struct_real_is_subtype_of;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_struct_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_struct_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_copy_function = vala_struct_real_get_copy_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_destroy_function = vala_struct_real_get_destroy_function;
	VALA_CODE_NODE_CLASS (klass)->check = vala_struct_real_check;
}


static void vala_struct_instance_init (ValaStruct * self) {
	self->priv = VALA_STRUCT_GET_PRIVATE (self);
	self->priv->type_parameters = (GeeList*) gee_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (GeeList*) gee_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (GeeList*) gee_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (GeeList*) gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->_base_type = NULL;
	self->priv->default_value = NULL;
	self->priv->_use_const = TRUE;
	self->priv->_has_type_id = TRUE;
	self->priv->_width = 32;
	self->priv->_signed = TRUE;
}


static void vala_struct_finalize (ValaCodeNode* obj) {
	ValaStruct * self;
	self = VALA_STRUCT (obj);
	(self->priv->type_parameters == NULL) ? NULL : (self->priv->type_parameters = (gee_collection_object_unref (self->priv->type_parameters), NULL));
	(self->priv->constants == NULL) ? NULL : (self->priv->constants = (gee_collection_object_unref (self->priv->constants), NULL));
	(self->priv->fields == NULL) ? NULL : (self->priv->fields = (gee_collection_object_unref (self->priv->fields), NULL));
	(self->priv->methods == NULL) ? NULL : (self->priv->methods = (gee_collection_object_unref (self->priv->methods), NULL));
	(self->priv->_base_type == NULL) ? NULL : (self->priv->_base_type = (vala_code_node_unref (self->priv->_base_type), NULL));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	self->priv->const_cname = (g_free (self->priv->const_cname), NULL);
	self->priv->type_id = (g_free (self->priv->type_id), NULL);
	self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL);
	self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL);
	self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL);
	self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL);
	self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL);
	self->priv->default_value = (g_free (self->priv->default_value), NULL);
	self->priv->type_signature = (g_free (self->priv->type_signature), NULL);
	self->priv->copy_function = (g_free (self->priv->copy_function), NULL);
	self->priv->destroy_function = (g_free (self->priv->destroy_function), NULL);
	(self->priv->_default_construction_method == NULL) ? NULL : (self->priv->_default_construction_method = (vala_code_node_unref (self->priv->_default_construction_method), NULL));
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}


GType vala_struct_get_type (void) {
	static GType vala_struct_type_id = 0;
	if (vala_struct_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
	}
	return vala_struct_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




