/* valaccodecontrolflowmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};


static gpointer vala_ccode_control_flow_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
enum  {
	VALA_CCODE_CONTROL_FLOW_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt);
void vala_ccode_module_visit_block (ValaCCodeModule* self, ValaBlock* b);
static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section);
static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
static void vala_ccode_control_flow_module_real_visit_loop (ValaCCodeModule* base, ValaLoop* stmt);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt);
void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt);



ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeControlFlowModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeControlFlowModule*) vala_ccode_method_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_control_flow_module_construct (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, codegen, next);
}


static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0_;
		_tmp0_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0_ = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_false_statement (stmt))))));
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	} else {
		ValaCCodeIfStatement* _tmp1_;
		_tmp1_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp1_ = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), NULL)));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	}
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt) {
	ValaLocalVariable* temp_var;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeConstant* _tmp0_;
	ValaCCodeBinaryExpression* _tmp1_;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* cquark;
	ValaCCodeConstant* _tmp4_;
	ValaCCodeConditionalExpression* _tmp5_;
	ValaCCodeConditionalExpression* ccond;
	ValaLocalVariable* _tmp6_;
	gint label_count;
	ValaCCodeExpressionStatement* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeAssignment* _tmp17_;
	ValaCCodeExpressionStatement* _tmp18_;
	GeeList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	/* we need a temporary variable to save the property value*/
	temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), FALSE, (ValaCodeNode*) stmt);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
	cinit = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitchblock);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cisnull = (_tmp1_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) ctemp), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cquark = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	vala_ccode_function_call_add_argument (cquark, (ValaCCodeExpression*) ctemp);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	ccond = (_tmp5_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("0")), (ValaCCodeExpression*) cquark), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	_tmp6_ = NULL;
	temp_var = (_tmp6_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL), (temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)), _tmp6_);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	label_count = 0;
	{
		GeeList* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _section_it;
		_tmp7_ = NULL;
		_tmp8_ = NULL;
		_section_it = (_tmp8_ = gee_iterable_iterator ((GeeIterable*) (_tmp7_ = vala_switch_statement_get_sections (stmt))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (gee_collection_object_unref (_tmp7_), NULL)), _tmp8_);
		while (TRUE) {
			ValaSwitchSection* section;
			if (!gee_iterator_next (_section_it)) {
				break;
			}
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp9_;
				GeeIterator* _tmp10_;
				GeeIterator* _label_it;
				_tmp9_ = NULL;
				_tmp10_ = NULL;
				_label_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_switch_section_get_labels (section))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
				while (TRUE) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp11_;
					ValaCCodeExpression* cexpr;
					if (!gee_iterator_next (_label_it)) {
						break;
					}
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp11_ = NULL;
					cexpr = (_tmp11_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp11_ == NULL) ? NULL : vala_ccode_node_ref (_tmp11_));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* cname;
						char* _tmp12_;
						ValaCCodeDeclaration* _tmp13_;
						ValaCCodeDeclaration* _cdecl_;
						ValaCCodeVariableDeclarator* _tmp14_;
						cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++);
						_tmp12_ = NULL;
						_tmp13_ = NULL;
						_cdecl_ = (_tmp13_ = vala_ccode_declaration_new (_tmp12_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->gquark_type)), _tmp12_ = (g_free (_tmp12_), NULL), _tmp13_);
						vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
						_tmp14_ = NULL;
						vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new (cname, (ValaCCodeExpression*) czero, NULL)));
						(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
						vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) _cdecl_);
						cname = (g_free (cname), NULL);
						(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	_tmp15_ = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp15_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	ctemp = (_tmp16_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), _tmp16_);
	_tmp17_ = NULL;
	cinit = (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, (ValaCCodeExpression*) ccond, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp17_);
	_tmp18_ = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp18_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars);
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeList* _tmp19_;
		GeeIterator* _tmp20_;
		GeeIterator* _section_it;
		_tmp19_ = NULL;
		_tmp20_ = NULL;
		_section_it = (_tmp20_ = gee_iterable_iterator ((GeeIterable*) (_tmp19_ = vala_switch_statement_get_sections (stmt))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (gee_collection_object_unref (_tmp19_), NULL)), _tmp20_);
		while (TRUE) {
			ValaSwitchSection* section;
			ValaCCodeBinaryExpression* cor;
			ValaCCodeBlock* cblock;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeDoStatement* _tmp43_;
			ValaCCodeDoStatement* cdo;
			ValaCCodeIfStatement* cif;
			ValaCCodeIfStatement* _tmp47_;
			ValaCCodeIfStatement* _tmp46_;
			if (!gee_iterator_next (_section_it)) {
				break;
			}
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				GeeList* _tmp21_;
				_tmp21_ = NULL;
				default_statements = (_tmp21_ = vala_block_get_statements ((ValaBlock*) section), (default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL)), _tmp21_);
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			cor = NULL;
			{
				GeeList* _tmp22_;
				GeeIterator* _tmp23_;
				GeeIterator* _label_it;
				_tmp22_ = NULL;
				_tmp23_ = NULL;
				_label_it = (_tmp23_ = gee_iterable_iterator ((GeeIterable*) (_tmp22_ = vala_switch_section_get_labels (section))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp23_);
				while (TRUE) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp24_;
					ValaCCodeExpression* cexpr;
					ValaCCodeBinaryExpression* ccmp;
					if (!gee_iterator_next (_label_it)) {
						break;
					}
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp24_ = NULL;
					cexpr = (_tmp24_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp24_ == NULL) ? NULL : vala_ccode_node_ref (_tmp24_));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* _tmp25_;
						ValaCCodeIdentifier* _tmp26_;
						ValaCCodeIdentifier* cname;
						ValaCCodeBinaryExpression* ccondition;
						ValaCCodeIdentifier* _tmp27_;
						ValaCCodeFunctionCall* _tmp28_;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeAssignment* _tmp29_;
						ValaCCodeExpression* _tmp30_;
						_tmp25_ = NULL;
						_tmp26_ = NULL;
						cname = (_tmp26_ = vala_ccode_identifier_new (_tmp25_ = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++)), _tmp25_ = (g_free (_tmp25_), NULL), _tmp26_);
						ccondition = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) cname);
						_tmp27_ = NULL;
						_tmp28_ = NULL;
						ccall = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp28_);
						_tmp29_ = NULL;
						cinit = (_tmp29_ = vala_ccode_assignment_new ((ValaCCodeExpression*) cname, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp29_);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp30_ = NULL;
						cexpr = (_tmp30_ = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccondition, (ValaCCodeExpression*) cname, (ValaCCodeExpression*) cinit), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp30_);
						(cname == NULL) ? NULL : (cname = (vala_ccode_node_unref (cname), NULL));
						(ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					} else {
						ValaCCodeIdentifier* _tmp31_;
						ValaCCodeFunctionCall* _tmp32_;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeExpression* _tmp34_;
						ValaCCodeExpression* _tmp33_;
						_tmp31_ = NULL;
						_tmp32_ = NULL;
						ccall = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp34_ = NULL;
						_tmp33_ = NULL;
						cexpr = (_tmp34_ = (_tmp33_ = (ValaCCodeExpression*) ccall, (_tmp33_ == NULL) ? NULL : vala_ccode_node_ref (_tmp33_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp34_);
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					}
					ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ctemp, cexpr);
					if (cor == NULL) {
						ValaCCodeBinaryExpression* _tmp36_;
						ValaCCodeBinaryExpression* _tmp35_;
						_tmp36_ = NULL;
						_tmp35_ = NULL;
						cor = (_tmp36_ = (_tmp35_ = ccmp, (_tmp35_ == NULL) ? NULL : vala_ccode_node_ref (_tmp35_)), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp36_);
					} else {
						ValaCCodeBinaryExpression* _tmp37_;
						_tmp37_ = NULL;
						cor = (_tmp37_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cor, (ValaCCodeExpression*) ccmp), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp37_);
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			{
				GeeList* _tmp38_;
				GeeIterator* _tmp39_;
				GeeIterator* _body_stmt_it;
				_tmp38_ = NULL;
				_tmp39_ = NULL;
				_body_stmt_it = (_tmp39_ = gee_iterable_iterator ((GeeIterable*) (_tmp38_ = vala_block_get_statements ((ValaBlock*) section))), (_tmp38_ == NULL) ? NULL : (_tmp38_ = (gee_collection_object_unref (_tmp38_), NULL)), _tmp39_);
				while (TRUE) {
					ValaCodeNode* body_stmt;
					if (!gee_iterator_next (_body_stmt_it)) {
						break;
					}
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
						{
							GeeList* _tmp40_;
							GeeIterator* _tmp41_;
							GeeIterator* _cstmt_it;
							_tmp40_ = NULL;
							_tmp41_ = NULL;
							_cstmt_it = (_tmp41_ = gee_iterable_iterator ((GeeIterable*) (_tmp40_ = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (gee_collection_object_unref (_tmp40_), NULL)), _tmp41_);
							while (TRUE) {
								ValaCCodeNode* cstmt;
								if (!gee_iterator_next (_cstmt_it)) {
									break;
								}
								cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					}
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			_tmp42_ = NULL;
			_tmp43_ = NULL;
			cdo = (_tmp43_ = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("0"))), (_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL)), _tmp43_);
			cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cor, (ValaCCodeStatement*) cdo, NULL);
			if (coldif != NULL) {
				vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cif);
			} else {
				ValaCCodeStatement* _tmp45_;
				ValaCCodeStatement* _tmp44_;
				_tmp45_ = NULL;
				_tmp44_ = NULL;
				ctopstmt = (_tmp45_ = (_tmp44_ = (ValaCCodeStatement*) cif, (_tmp44_ == NULL) ? NULL : vala_ccode_node_ref (_tmp44_)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp45_);
			}
			_tmp47_ = NULL;
			_tmp46_ = NULL;
			coldif = (_tmp47_ = (_tmp46_ = cif, (_tmp46_ == NULL) ? NULL : vala_ccode_node_ref (_tmp46_)), (coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL)), _tmp47_);
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
			(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
			(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp48_;
		ValaCCodeDoStatement* _tmp49_;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeIterator* _body_stmt_it;
			_body_stmt_it = gee_iterable_iterator ((GeeIterable*) default_statements);
			while (TRUE) {
				ValaCodeNode* body_stmt;
				if (!gee_iterator_next (_body_stmt_it)) {
					break;
				}
				body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
				(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
			}
			(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
		}
		_tmp48_ = NULL;
		_tmp49_ = NULL;
		cdo = (_tmp49_ = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_constant_new ("0"))), (_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL)), _tmp49_);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp51_;
			ValaCCodeStatement* _tmp50_;
			/* there is only one section and that section
			 contains a default label*/
			_tmp51_ = NULL;
			_tmp50_ = NULL;
			ctopstmt = (_tmp51_ = (_tmp50_ = (ValaCCodeStatement*) cdo, (_tmp50_ == NULL) ? NULL : vala_ccode_node_ref (_tmp50_)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp51_);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cdo);
		}
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
	}
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) ctopstmt);
	(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
	(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
	(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
	(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
	(cswitchblock == NULL) ? NULL : (cswitchblock = (vala_ccode_node_unref (cswitchblock), NULL));
	(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
	(cquark == NULL) ? NULL : (cquark = (vala_ccode_node_unref (cquark), NULL));
	(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
	(default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL));
	(ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL));
	(coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeSwitchStatement* cswitch;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), ((ValaCCodeBaseModule*) self)->string_type)) {
		vala_ccode_control_flow_module_visit_string_switch_statement (self, stmt);
		return;
	}
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitch);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _section_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_section_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_switch_statement_get_sections (stmt))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaSwitchSection* section;
			ValaCCodeBlock* cblock;
			if (!gee_iterator_next (_section_it)) {
				break;
			}
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				ValaCCodeLabel* _tmp2_;
				ValaCCodeBlock* cdefaultblock;
				_tmp2_ = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp2_ = vala_ccode_label_new ("default")));
				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
				cdefaultblock = vala_ccode_block_new ();
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cdefaultblock);
				{
					GeeList* _tmp3_;
					GeeIterator* _tmp4_;
					GeeIterator* _default_stmt_it;
					_tmp3_ = NULL;
					_tmp4_ = NULL;
					_default_stmt_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_block_get_statements ((ValaBlock*) section))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
					while (TRUE) {
						ValaCodeNode* default_stmt;
						if (!gee_iterator_next (_default_stmt_it)) {
							break;
						}
						default_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_default_stmt_it));
						vala_ccode_block_add_statement (cdefaultblock, vala_code_node_get_ccodenode (default_stmt));
						(default_stmt == NULL) ? NULL : (default_stmt = (vala_code_node_unref (default_stmt), NULL));
					}
					(_default_stmt_it == NULL) ? NULL : (_default_stmt_it = (gee_collection_object_unref (_default_stmt_it), NULL));
				}
				(cdefaultblock == NULL) ? NULL : (cdefaultblock = (vala_ccode_node_unref (cdefaultblock), NULL));
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _label_it;
				_tmp5_ = NULL;
				_tmp6_ = NULL;
				_label_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = vala_switch_section_get_labels (section))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL)), _tmp6_);
				while (TRUE) {
					ValaSwitchLabel* label;
					ValaCCodeCaseStatement* _tmp7_;
					if (!gee_iterator_next (_label_it)) {
						break;
					}
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp7_ = NULL;
					vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp7_ = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))))));
					(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cblock);
			{
				GeeList* _tmp8_;
				GeeIterator* _tmp9_;
				GeeIterator* _body_stmt_it;
				_tmp8_ = NULL;
				_tmp9_ = NULL;
				_body_stmt_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_block_get_statements ((ValaBlock*) section))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (gee_collection_object_unref (_tmp8_), NULL)), _tmp9_);
				while (TRUE) {
					ValaCodeNode* body_stmt;
					if (!gee_iterator_next (_body_stmt_it)) {
						break;
					}
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars);
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) section);
}


static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (label != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) label, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_loop (ValaCCodeModule* base, ValaLoop* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
		ValaCCodeWhileStatement* _tmp1_;
		ValaCCodeConstant* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp1_ = vala_ccode_while_statement_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("TRUE")), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_loop_get_body (stmt))))));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	} else {
		ValaCCodeWhileStatement* _tmp3_;
		ValaCCodeConstant* _tmp2_;
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "stdbool.h", FALSE);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp3_ = vala_ccode_while_statement_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new ("true")), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_loop_get_body (stmt))))));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	}
}


static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	ValaArrayType* _tmp2_;
	ValaDataType* _tmp1_;
	ValaArrayType* array_type;
	gboolean _tmp3_;
	gboolean _tmp10_;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_element_variable (stmt), TRUE);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_collection_variable (stmt), TRUE);
	if (vala_foreach_statement_get_iterator_variable (stmt) != NULL) {
		vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_iterator_variable (stmt), TRUE);
	}
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) stmt);
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cblock);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	_tmp0_ = NULL;
	collection_backup = (_tmp0_ = vala_foreach_statement_get_collection_variable (stmt), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	collection_type = vala_data_type_copy (vala_local_variable_get_variable_type (collection_backup));
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	array_type = (_tmp2_ = (_tmp1_ = collection_type, VALA_IS_ARRAY_TYPE (_tmp1_) ? ((ValaArrayType*) _tmp1_) : NULL), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	if (array_type != NULL) {
		/* avoid assignment issues*/
		vala_array_type_set_fixed_length (array_type, FALSE);
	}
	_tmp3_ = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
		_tmp3_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		char* _tmp4_;
		ValaCCodeExpressionStatement* _tmp7_;
		ValaCCodeAssignment* _tmp6_;
		ValaCCodeExpression* _tmp5_;
		_tmp4_ = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp4_ = vala_data_type_get_cname (collection_type), vala_symbol_get_name ((ValaSymbol*) collection_backup));
		_tmp4_ = (g_free (_tmp4_), NULL);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp7_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_assignment_new (_tmp5_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	} else {
		char* _tmp8_;
		ValaCCodeDeclaration* _tmp9_;
		ValaCCodeDeclaration* ccoldecl;
		ValaCCodeVariableDeclarator* ccolvardecl;
		_tmp8_ = NULL;
		_tmp9_ = NULL;
		ccoldecl = (_tmp9_ = vala_ccode_declaration_new (_tmp8_ = vala_data_type_get_cname (collection_type)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_);
		ccolvardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) collection_backup), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))), NULL);
		vala_ccode_node_set_line ((ValaCCodeNode*) ccolvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
		vala_ccode_declaration_add_declarator (ccoldecl, (ValaCCodeDeclarator*) ccolvardecl);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ccoldecl);
		(ccoldecl == NULL) ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL));
		(ccolvardecl == NULL) ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL));
	}
	_tmp10_ = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp10_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt));
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		ValaCCodeFragment* _tmp11_;
		/* exception handling*/
		_tmp11_ = NULL;
		cfrag = (_tmp11_ = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp11_);
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_foreach_statement_get_collection (stmt), cfrag);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp13_;
		ValaArrayType* _tmp12_;
		ValaCCodeExpression* array_len;
		gboolean _tmp14_;
		char* it_name;
		gboolean _tmp22_;
		ValaCCodeBlock* cbody;
		ValaCCodeExpression* _tmp25_;
		ValaCCodeExpression* _tmp24_;
		ValaCCodeExpression* _tmp26_;
		ValaCCodeExpression* element_expr;
		ValaDataType* element_type;
		ValaCCodeExpression* _tmp27_;
		ValaCCodeFragment* _tmp28_;
		gboolean _tmp29_;
		ValaCCodeExpression* _tmp49_;
		ValaCCodeBinaryExpression* _tmp50_;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp53_;
		ValaCCodeConstant* _tmp52_;
		ValaCCodeExpression* _tmp51_;
		ValaCCodeAssignment* _tmp58_;
		ValaCCodeBinaryExpression* _tmp57_;
		ValaCCodeConstant* _tmp56_;
		ValaCCodeExpression* _tmp55_;
		ValaCCodeExpression* _tmp54_;
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		array_type = (_tmp13_ = (_tmp12_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_)), (array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)), _tmp13_);
		array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_collection (stmt), -1);
		_tmp14_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp14_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp14_ = FALSE;
		}
		/* store array length for use by _vala_array_free*/
		if (_tmp14_) {
			char* _tmp15_;
			ValaCCodeExpressionStatement* _tmp19_;
			ValaCCodeAssignment* _tmp18_;
			ValaCCodeExpression* _tmp17_;
			char* _tmp16_;
			_tmp15_ = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp15_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1));
			_tmp15_ = (g_free (_tmp15_), NULL);
			_tmp19_ = NULL;
			_tmp18_ = NULL;
			_tmp17_ = NULL;
			_tmp16_ = NULL;
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_assignment_new (_tmp17_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp16_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1)), array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
			(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
			(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
			_tmp16_ = (g_free (_tmp16_), NULL);
		} else {
			ValaCCodeDeclaration* clendecl;
			ValaCCodeVariableDeclarator* _tmp21_;
			char* _tmp20_;
			clendecl = vala_ccode_declaration_new ("int");
			_tmp21_ = NULL;
			_tmp20_ = NULL;
			vala_ccode_declaration_add_declarator (clendecl, (ValaCCodeDeclarator*) (_tmp21_ = vala_ccode_variable_declarator_new (_tmp20_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1), array_len, NULL)));
			(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
			_tmp20_ = (g_free (_tmp20_), NULL);
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) clendecl);
			(clendecl == NULL) ? NULL : (clendecl = (vala_ccode_node_unref (clendecl), NULL));
		}
		it_name = g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL);
		_tmp22_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp22_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", it_name);
		} else {
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp23_;
			citdecl = vala_ccode_declaration_new ("int");
			_tmp23_ = NULL;
			vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp23_ = vala_ccode_variable_declarator_new (it_name, NULL, NULL)));
			(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
			(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
		}
		cbody = vala_ccode_block_new ();
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		_tmp26_ = NULL;
		element_expr = (_tmp26_ = (ValaCCodeExpression*) vala_ccode_element_access_new (_tmp24_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), _tmp25_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name)), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp26_);
		element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
		vala_data_type_set_value_owned (element_type, FALSE);
		_tmp27_ = NULL;
		element_expr = (_tmp27_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp27_);
		_tmp28_ = NULL;
		cfrag = (_tmp28_ = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp28_);
		vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
		vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
		gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
		_tmp29_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp29_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			char* _tmp30_;
			ValaCCodeExpressionStatement* _tmp33_;
			ValaCCodeAssignment* _tmp32_;
			ValaCCodeExpression* _tmp31_;
			_tmp30_ = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp30_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt));
			_tmp30_ = (g_free (_tmp30_), NULL);
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			_tmp31_ = NULL;
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp33_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_assignment_new (_tmp31_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
			(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		} else {
			char* _tmp34_;
			ValaCCodeDeclaration* _tmp35_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp36_;
			_tmp34_ = NULL;
			_tmp35_ = NULL;
			_cdecl_ = (_tmp35_ = vala_ccode_declaration_new (_tmp34_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp34_ = (g_free (_tmp34_), NULL), _tmp35_);
			_tmp36_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp36_ = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), element_expr, NULL)));
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		}
		/* add array length variable for stacked arrays*/
		if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
			ValaArrayType* _tmp37_;
			ValaArrayType* inner_array_type;
			_tmp37_ = NULL;
			inner_array_type = (_tmp37_ = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp37_ == NULL) ? NULL : vala_code_node_ref (_tmp37_));
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp38_;
					_tmp38_ = TRUE;
					while (TRUE) {
						gboolean _tmp39_;
						if (!_tmp38_) {
							dim++;
						}
						_tmp38_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (inner_array_type))) {
							break;
						}
						_tmp39_ = FALSE;
						if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
							_tmp39_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
						} else {
							_tmp39_ = FALSE;
						}
						if (_tmp39_) {
							char* _tmp40_;
							ValaCCodeExpressionStatement* _tmp45_;
							ValaCCodeAssignment* _tmp44_;
							ValaCCodeConstant* _tmp43_;
							ValaCCodeExpression* _tmp42_;
							char* _tmp41_;
							_tmp40_ = NULL;
							vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", _tmp40_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim));
							_tmp40_ = (g_free (_tmp40_), NULL);
							_tmp45_ = NULL;
							_tmp44_ = NULL;
							_tmp43_ = NULL;
							_tmp42_ = NULL;
							_tmp41_ = NULL;
							vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp45_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_assignment_new (_tmp42_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp41_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim)), (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("-1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
							(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
							(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
							(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
							_tmp41_ = (g_free (_tmp41_), NULL);
						} else {
							ValaCCodeDeclaration* _cdecl_;
							ValaCCodeVariableDeclarator* _tmp48_;
							ValaCCodeConstant* _tmp47_;
							char* _tmp46_;
							_cdecl_ = vala_ccode_declaration_new ("int");
							_tmp48_ = NULL;
							_tmp47_ = NULL;
							_tmp46_ = NULL;
							vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp48_ = vala_ccode_variable_declarator_new (_tmp46_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim), (ValaCCodeExpression*) (_tmp47_ = vala_ccode_constant_new ("-1")), NULL)));
							(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
							(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
							_tmp46_ = (g_free (_tmp46_), NULL);
							vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) _cdecl_);
							(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
						}
					}
				}
			}
			(inner_array_type == NULL) ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL));
		}
		vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
		_tmp49_ = NULL;
		_tmp50_ = NULL;
		ccond = (_tmp50_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, _tmp49_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), array_len), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL)), _tmp50_);
		cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
		_tmp53_ = NULL;
		_tmp52_ = NULL;
		_tmp51_ = NULL;
		vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_assignment_new (_tmp51_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp52_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
		(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
		(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		_tmp58_ = NULL;
		_tmp57_ = NULL;
		_tmp56_ = NULL;
		_tmp55_ = NULL;
		_tmp54_ = NULL;
		vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_assignment_new (_tmp54_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp57_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp55_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
		(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
		(array_len == NULL) ? NULL : (array_len = (vala_ccode_node_unref (array_len), NULL));
		it_name = (g_free (it_name), NULL);
		(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
		(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
		(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
	} else {
		gboolean _tmp59_;
		ValaObjectType* _tmp60_;
		gboolean _tmp61_;
		_tmp59_ = FALSE;
		_tmp60_ = NULL;
		if ((_tmp61_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp60_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->glist_type))), (_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_code_node_unref (_tmp60_), NULL)), _tmp61_)) {
			_tmp59_ = TRUE;
		} else {
			ValaObjectType* _tmp62_;
			_tmp62_ = NULL;
			_tmp59_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp62_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gslist_type)));
			(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_code_node_unref (_tmp62_), NULL));
		}
		if (_tmp59_) {
			char* it_name;
			gboolean _tmp63_;
			ValaCCodeBlock* cbody;
			ValaCCodeExpression* _tmp67_;
			ValaCCodeExpression* _tmp68_;
			ValaCCodeExpression* element_expr;
			GeeList* _tmp69_;
			gboolean _tmp70_;
			ValaDataType* _tmp72_;
			GeeList* _tmp71_;
			ValaDataType* _tmp73_;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp74_;
			ValaCCodeExpression* _tmp75_;
			ValaCCodeFragment* _tmp76_;
			gboolean _tmp77_;
			ValaCCodeConstant* _tmp85_;
			ValaCCodeExpression* _tmp84_;
			ValaCCodeBinaryExpression* _tmp86_;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp89_;
			ValaCCodeExpression* _tmp88_;
			ValaCCodeExpression* _tmp87_;
			ValaCCodeAssignment* _tmp93_;
			ValaCCodeMemberAccess* _tmp92_;
			ValaCCodeExpression* _tmp91_;
			ValaCCodeExpression* _tmp90_;
			/* iterating over a GList or GSList*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp63_ = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp63_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
			} else {
				_tmp63_ = FALSE;
			}
			if (_tmp63_) {
				char* _tmp64_;
				_tmp64_ = NULL;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp64_ = vala_data_type_get_cname (collection_type), it_name);
				_tmp64_ = (g_free (_tmp64_), NULL);
			} else {
				char* _tmp65_;
				ValaCCodeDeclaration* _tmp66_;
				ValaCCodeDeclaration* citdecl;
				ValaCCodeVariableDeclarator* citvardecl;
				_tmp65_ = NULL;
				_tmp66_ = NULL;
				citdecl = (_tmp66_ = vala_ccode_declaration_new (_tmp65_ = vala_data_type_get_cname (collection_type)), _tmp65_ = (g_free (_tmp65_), NULL), _tmp66_);
				citvardecl = vala_ccode_variable_declarator_new (it_name, NULL, NULL);
				vala_ccode_node_set_line ((ValaCCodeNode*) citvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) citvardecl);
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
				(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
				(citvardecl == NULL) ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL));
			}
			cbody = vala_ccode_block_new ();
			_tmp67_ = NULL;
			_tmp68_ = NULL;
			element_expr = (_tmp68_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp67_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "data"), (_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL)), _tmp68_);
			_tmp69_ = NULL;
			if ((_tmp70_ = gee_collection_get_size ((GeeCollection*) (_tmp69_ = vala_data_type_get_type_arguments (collection_type))) != 1, (_tmp69_ == NULL) ? NULL : (_tmp69_ = (gee_collection_object_unref (_tmp69_), NULL)), _tmp70_)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) stmt), "internal error: missing generic type argument");
				vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
				it_name = (g_free (it_name), NULL);
				(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
				(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
				(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
				(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				return;
			}
			_tmp72_ = NULL;
			_tmp71_ = NULL;
			_tmp73_ = NULL;
			element_data_type = (_tmp73_ = vala_data_type_copy (_tmp72_ = (ValaDataType*) gee_list_get (_tmp71_ = vala_data_type_get_type_arguments (collection_type), 0)), (_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_code_node_unref (_tmp72_), NULL)), (_tmp71_ == NULL) ? NULL : (_tmp71_ = (gee_collection_object_unref (_tmp71_), NULL)), _tmp73_);
			vala_data_type_set_value_owned (element_data_type, FALSE);
			_tmp74_ = NULL;
			element_expr = (_tmp74_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, element_expr, element_data_type), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp74_);
			_tmp75_ = NULL;
			element_expr = (_tmp75_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp75_);
			_tmp76_ = NULL;
			cfrag = (_tmp76_ = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp76_);
			vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
			gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
			_tmp77_ = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp77_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				char* _tmp78_;
				ValaCCodeExpressionStatement* _tmp81_;
				ValaCCodeAssignment* _tmp80_;
				ValaCCodeExpression* _tmp79_;
				_tmp78_ = NULL;
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp78_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt));
				_tmp78_ = (g_free (_tmp78_), NULL);
				_tmp81_ = NULL;
				_tmp80_ = NULL;
				_tmp79_ = NULL;
				vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp81_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_assignment_new (_tmp79_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
				(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
				(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
			} else {
				char* _tmp82_;
				ValaCCodeDeclaration* _tmp83_;
				ValaCCodeDeclaration* _cdecl_;
				ValaCCodeVariableDeclarator* cvardecl;
				_tmp82_ = NULL;
				_tmp83_ = NULL;
				_cdecl_ = (_tmp83_ = vala_ccode_declaration_new (_tmp82_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp82_ = (g_free (_tmp82_), NULL), _tmp83_);
				cvardecl = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), element_expr, NULL);
				vala_ccode_node_set_line ((ValaCCodeNode*) cvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) cvardecl);
				vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) _cdecl_);
				(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
			_tmp85_ = NULL;
			_tmp84_ = NULL;
			_tmp86_ = NULL;
			ccond = (_tmp86_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp84_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp85_ = vala_ccode_constant_new ("NULL"))), (_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL)), (_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL)), _tmp86_);
			cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
			_tmp89_ = NULL;
			_tmp88_ = NULL;
			_tmp87_ = NULL;
			vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_assignment_new (_tmp87_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), _tmp88_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
			(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
			(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
			_tmp93_ = NULL;
			_tmp92_ = NULL;
			_tmp91_ = NULL;
			_tmp90_ = NULL;
			vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_assignment_new (_tmp90_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), (ValaCCodeExpression*) (_tmp92_ = vala_ccode_member_access_new_pointer (_tmp91_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, it_name), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
			(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
			(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
			(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
			it_name = (g_free (it_name), NULL);
			(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
			(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
			(element_data_type == NULL) ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL));
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
			(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		} else {
			ValaObjectType* _tmp94_;
			gboolean _tmp95_;
			_tmp94_ = NULL;
			if ((_tmp95_ = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp94_ = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gvaluearray_type))), (_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_code_node_unref (_tmp94_), NULL)), _tmp95_)) {
				char* arr_index;
				gboolean _tmp96_;
				ValaCCodeBlock* cbody;
				ValaCCodeIdentifier* _tmp100_;
				ValaCCodeFunctionCall* _tmp101_;
				ValaCCodeFunctionCall* get_item;
				ValaCCodeExpression* _tmp102_;
				ValaCCodeExpression* _tmp103_;
				ValaCCodeExpression* element_expr;
				ValaCCodeFragment* _tmp106_;
				gboolean _tmp107_;
				ValaCCodeMemberAccess* _tmp116_;
				ValaCCodeExpression* _tmp115_;
				ValaCCodeExpression* _tmp114_;
				ValaCCodeBinaryExpression* _tmp117_;
				ValaCCodeBinaryExpression* ccond;
				ValaCCodeForStatement* cfor;
				ValaCCodeAssignment* _tmp120_;
				ValaCCodeConstant* _tmp119_;
				ValaCCodeExpression* _tmp118_;
				ValaCCodeAssignment* _tmp125_;
				ValaCCodeBinaryExpression* _tmp124_;
				ValaCCodeConstant* _tmp123_;
				ValaCCodeExpression* _tmp122_;
				ValaCCodeExpression* _tmp121_;
				/* iterating over a GValueArray*/
				arr_index = g_strdup_printf ("%s_index", vala_foreach_statement_get_variable_name (stmt));
				_tmp96_ = FALSE;
				if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
					_tmp96_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					char* _tmp97_;
					_tmp97_ = NULL;
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp97_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->uint_type), arr_index);
					_tmp97_ = (g_free (_tmp97_), NULL);
				} else {
					char* _tmp98_;
					ValaCCodeDeclaration* _tmp99_;
					ValaCCodeDeclaration* citdecl;
					ValaCCodeVariableDeclarator* citvardecl;
					_tmp98_ = NULL;
					_tmp99_ = NULL;
					citdecl = (_tmp99_ = vala_ccode_declaration_new (_tmp98_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->uint_type)), _tmp98_ = (g_free (_tmp98_), NULL), _tmp99_);
					citvardecl = vala_ccode_variable_declarator_new (arr_index, NULL, NULL);
					vala_ccode_node_set_line ((ValaCCodeNode*) citvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
					vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) citvardecl);
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
					(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
					(citvardecl == NULL) ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL));
				}
				cbody = vala_ccode_block_new ();
				_tmp100_ = NULL;
				_tmp101_ = NULL;
				get_item = (_tmp101_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new ("g_value_array_get_nth"))), (_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL)), _tmp101_);
				_tmp102_ = NULL;
				vala_ccode_function_call_add_argument (get_item, _tmp102_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)));
				(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
				_tmp103_ = NULL;
				vala_ccode_function_call_add_argument (get_item, _tmp103_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index));
				(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
				element_expr = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) get_item);
				if (vala_data_type_get_value_owned (vala_foreach_statement_get_type_reference (stmt))) {
					ValaCCodeExpression* _tmp105_;
					ValaStructValueType* _tmp104_;
					_tmp105_ = NULL;
					_tmp104_ = NULL;
					element_expr = (_tmp105_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_type_reference (stmt), element_expr, NULL, (ValaCodeNode*) (_tmp104_ = vala_struct_value_type_new (((ValaCCodeBaseModule*) self)->gvalue_type))), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp105_);
					(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_code_node_unref (_tmp104_), NULL));
				}
				_tmp106_ = NULL;
				cfrag = (_tmp106_ = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp106_);
				vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
				vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
				gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
				_tmp107_ = FALSE;
				if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
					_tmp107_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
				} else {
					_tmp107_ = FALSE;
				}
				if (_tmp107_) {
					char* _tmp108_;
					ValaCCodeExpressionStatement* _tmp111_;
					ValaCCodeAssignment* _tmp110_;
					ValaCCodeExpression* _tmp109_;
					_tmp108_ = NULL;
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp108_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt)), vala_foreach_statement_get_variable_name (stmt));
					_tmp108_ = (g_free (_tmp108_), NULL);
					_tmp111_ = NULL;
					_tmp110_ = NULL;
					_tmp109_ = NULL;
					vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp111_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp110_ = vala_ccode_assignment_new (_tmp109_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_foreach_statement_get_variable_name (stmt)), element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
					(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
					(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
				} else {
					char* _tmp112_;
					ValaCCodeDeclaration* _tmp113_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* cvardecl;
					_tmp112_ = NULL;
					_tmp113_ = NULL;
					_cdecl_ = (_tmp113_ = vala_ccode_declaration_new (_tmp112_ = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp112_ = (g_free (_tmp112_), NULL), _tmp113_);
					cvardecl = vala_ccode_variable_declarator_new (vala_foreach_statement_get_variable_name (stmt), element_expr, NULL);
					vala_ccode_node_set_line ((ValaCCodeNode*) cvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) cvardecl);
					vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) _cdecl_);
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
					(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
				}
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
				_tmp116_ = NULL;
				_tmp115_ = NULL;
				_tmp114_ = NULL;
				_tmp117_ = NULL;
				ccond = (_tmp117_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, _tmp114_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp116_ = vala_ccode_member_access_new_pointer (_tmp115_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) collection_backup)), "n_values"))), (_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL)), (_tmp115_ == NULL) ? NULL : (_tmp115_ = (vala_ccode_node_unref (_tmp115_), NULL)), (_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL)), _tmp117_);
				cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
				_tmp120_ = NULL;
				_tmp119_ = NULL;
				_tmp118_ = NULL;
				vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp120_ = vala_ccode_assignment_new (_tmp118_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp119_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp120_ == NULL) ? NULL : (_tmp120_ = (vala_ccode_node_unref (_tmp120_), NULL));
				(_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_ccode_node_unref (_tmp119_), NULL));
				(_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_ccode_node_unref (_tmp118_), NULL));
				_tmp125_ = NULL;
				_tmp124_ = NULL;
				_tmp123_ = NULL;
				_tmp122_ = NULL;
				_tmp121_ = NULL;
				vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp125_ = vala_ccode_assignment_new (_tmp121_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp124_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp122_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, arr_index), (ValaCCodeExpression*) (_tmp123_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL));
				(_tmp124_ == NULL) ? NULL : (_tmp124_ = (vala_ccode_node_unref (_tmp124_), NULL));
				(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
				(_tmp122_ == NULL) ? NULL : (_tmp122_ = (vala_ccode_node_unref (_tmp122_), NULL));
				(_tmp121_ == NULL) ? NULL : (_tmp121_ = (vala_ccode_node_unref (_tmp121_), NULL));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
				arr_index = (g_free (arr_index), NULL);
				(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
				(get_item == NULL) ? NULL : (get_item = (vala_ccode_node_unref (get_item), NULL));
				(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
				(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
				(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
			}
		}
	}
	{
		GeeList* _tmp126_;
		GeeIterator* _tmp127_;
		GeeIterator* _local_it;
		_tmp126_ = NULL;
		_tmp127_ = NULL;
		_local_it = (_tmp127_ = gee_iterable_iterator ((GeeIterable*) (_tmp126_ = vala_block_get_local_variables ((ValaBlock*) stmt))), (_tmp126_ == NULL) ? NULL : (_tmp126_ = (gee_collection_object_unref (_tmp126_), NULL)), _tmp127_);
		while (TRUE) {
			ValaLocalVariable* local;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_local_variable_get_variable_type (local))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp129_;
				ValaCCodeExpression* _tmp128_;
				ValaCCodeExpressionStatement* _tmp130_;
				ValaCCodeExpressionStatement* cunref;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp129_ = NULL;
				_tmp128_ = NULL;
				_tmp130_ = NULL;
				cunref = (_tmp130_ = vala_ccode_expression_statement_new (_tmp129_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp128_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma)), (_tmp129_ == NULL) ? NULL : (_tmp129_ = (vala_ccode_node_unref (_tmp129_), NULL)), (_tmp128_ == NULL) ? NULL : (_tmp128_ = (vala_ccode_node_unref (_tmp128_), NULL)), _tmp130_);
				vala_ccode_node_set_line ((ValaCCodeNode*) cunref, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cunref);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(cunref == NULL) ? NULL : (cunref = (vala_ccode_node_unref (cunref), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
	(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
}


static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBreakStatement* _tmp0_;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0_ = vala_ccode_break_statement_new ()));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeContinueStatement* _tmp0_;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0_ = vala_ccode_continue_statement_new ()));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_class_init (ValaCCodeControlFlowModuleClass * klass) {
	vala_ccode_control_flow_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_if_statement = vala_ccode_control_flow_module_real_visit_if_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_statement = vala_ccode_control_flow_module_real_visit_switch_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_section = vala_ccode_control_flow_module_real_visit_switch_section;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_label = vala_ccode_control_flow_module_real_visit_switch_label;
	VALA_CCODE_MODULE_CLASS (klass)->visit_loop = vala_ccode_control_flow_module_real_visit_loop;
	VALA_CCODE_MODULE_CLASS (klass)->visit_foreach_statement = vala_ccode_control_flow_module_real_visit_foreach_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_break_statement = vala_ccode_control_flow_module_real_visit_break_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_continue_statement = vala_ccode_control_flow_module_real_visit_continue_statement;
}


static void vala_ccode_control_flow_module_instance_init (ValaCCodeControlFlowModule * self) {
}


GType vala_ccode_control_flow_module_get_type (void) {
	static GType vala_ccode_control_flow_module_type_id = 0;
	if (vala_ccode_control_flow_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeControlFlowModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_control_flow_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeControlFlowModule), 0, (GInstanceInitFunc) vala_ccode_control_flow_module_instance_init, NULL };
		vala_ccode_control_flow_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_MODULE, "ValaCCodeControlFlowModule", &g_define_type_info, 0);
	}
	return vala_ccode_control_flow_module_type_id;
}




