/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gboolean vala_ccode_base_module_add_generated_external_symbol (ValaCCodeBaseModule* self, ValaSymbol* external_symbol);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
gboolean vala_ccode_module_method_has_wrapper (ValaCCodeModule* self, ValaMethod* method);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
void vala_ccode_base_module_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_field_declaration (ValaCCodeBaseModule* self, ValaField* f, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_constant_declaration (ValaCCodeBaseModule* self, ValaConstant* c, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_property_accessor_declaration (ValaCCodeBaseModule* self, ValaPropertyAccessor* acc, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
void vala_ccode_base_module_generate_enum_declaration (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMemberAccessModule*) vala_ccode_control_flow_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = (ValaCCodeMemberAccessModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1_;
		ValaCCodeExpression* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		pub_inst = (_tmp1_ = (_tmp0_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1_);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3_;
			ValaDataType* _tmp2_;
			_tmp3_ = NULL;
			_tmp2_ = NULL;
			base_type = (_tmp3_ = (_tmp2_ = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp3_);
		}
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaMethod* _tmp4_;
		ValaMethod* m;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = NULL;
		m = (_tmp4_ = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
		_tmp5_ = FALSE;
		_tmp6_ = FALSE;
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = VALA_IS_ARRAY_MOVE_METHOD (m);
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = VALA_IS_ARRAY_RESIZE_METHOD (m);
		}
		if (!_tmp5_) {
			gboolean _tmp7_;
			vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
			_tmp7_ = FALSE;
			if (!vala_symbol_get_external ((ValaSymbol*) m)) {
				_tmp7_ = vala_symbol_get_external_package ((ValaSymbol*) m);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				/* internal VAPI methods
				 only add them once per source file*/
				if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) m)) {
					vala_ccode_module_visit_method ((ValaCCodeModule*) self, m);
				}
			}
		}
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp8_;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp11_;
				char* _tmp10_;
				char* _tmp9_;
				ValaCCodeFunctionCall* _tmp12_;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp15_;
				char* _tmp14_;
				char* _tmp13_;
				ValaCCodeMemberAccess* _tmp16_;
				_tmp8_ = NULL;
				base_class = (_tmp8_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				_tmp9_ = NULL;
				_tmp12_ = NULL;
				vcast = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (_tmp10_ = g_strdup_printf ("%s_CLASS", _tmp9_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp10_ = (g_free (_tmp10_), NULL), _tmp9_ = (g_free (_tmp9_), NULL), _tmp12_);
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = g_strdup_printf ("%s_parent_class", _tmp13_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
				(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
				_tmp14_ = (g_free (_tmp14_), NULL);
				_tmp13_ = (g_free (_tmp13_), NULL);
				_tmp16_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp16_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_method_get_vfunc_name (m))));
				(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp17_;
					ValaInterface* base_iface;
					char* _tmp19_;
					char* _tmp18_;
					char* _tmp20_;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp22_;
					ValaCCodeIdentifier* _tmp21_;
					_tmp17_ = NULL;
					base_iface = (_tmp17_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
					_tmp19_ = NULL;
					_tmp18_ = NULL;
					_tmp20_ = NULL;
					parent_iface_var = (_tmp20_ = g_strdup_printf ("%s_%s_parent_iface", _tmp18_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp19_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp19_ = (g_free (_tmp19_), NULL), _tmp18_ = (g_free (_tmp18_), NULL), _tmp20_);
					_tmp22_ = NULL;
					_tmp21_ = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp22_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (parent_iface_var)), vala_method_get_vfunc_name (m))));
					(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
					(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
					(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp23_;
				ValaCCodeExpression* inst;
				gboolean _tmp24_;
				ValaClass* _tmp26_;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp29_;
				char* _tmp28_;
				char* _tmp27_;
				ValaCCodeFunctionCall* _tmp30_;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp31_;
				_tmp23_ = NULL;
				inst = (_tmp23_ = pub_inst, (_tmp23_ == NULL) ? NULL : vala_ccode_node_ref (_tmp23_));
				_tmp24_ = FALSE;
				if (vala_member_access_get_inner (expr) != NULL) {
					_tmp24_ = !vala_expression_is_pure (vala_member_access_get_inner (expr));
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp25_;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					_tmp25_ = NULL;
					inst = (_tmp25_ = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp25_);
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr), (ValaCCodeNode*) ctemp);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				}
				_tmp26_ = NULL;
				base_class = (_tmp26_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_));
				_tmp29_ = NULL;
				_tmp28_ = NULL;
				_tmp27_ = NULL;
				_tmp30_ = NULL;
				vclass = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = g_strdup_printf ("%s_GET_CLASS", _tmp27_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp28_ = (g_free (_tmp28_), NULL), _tmp27_ = (g_free (_tmp27_), NULL), _tmp30_);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp31_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp31_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vclass, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vclass == NULL) ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL));
			} else {
				ValaCCodeIdentifier* _tmp33_;
				char* _tmp32_;
				_tmp33_ = NULL;
				_tmp32_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp33_ = vala_ccode_identifier_new (_tmp32_ = vala_method_get_cname (vala_method_get_base_method (m)))));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
				_tmp32_ = (g_free (_tmp32_), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp35_;
				char* _tmp34_;
				_tmp35_ = NULL;
				_tmp34_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp35_ = vala_ccode_identifier_new (_tmp34_ = vala_method_get_cname (vala_method_get_base_interface_method (m)))));
				(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
				_tmp34_ = (g_free (_tmp34_), NULL);
			} else {
				if (VALA_IS_CREATION_METHOD (m)) {
					ValaCCodeIdentifier* _tmp37_;
					char* _tmp36_;
					_tmp37_ = NULL;
					_tmp36_ = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp37_ = vala_ccode_identifier_new (_tmp36_ = vala_method_get_real_cname (m))));
					(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
					_tmp36_ = (g_free (_tmp36_), NULL);
				} else {
					ValaCCodeIdentifier* _tmp39_;
					char* _tmp38_;
					_tmp39_ = NULL;
					_tmp38_ = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp39_ = vala_ccode_identifier_new (_tmp38_ = vala_method_get_cname (m))));
					(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
					_tmp38_ = (g_free (_tmp38_), NULL);
				}
			}
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaCCodeExpression* _tmp40_;
			_tmp40_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp40_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (expr), 1)));
			(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaField* _tmp41_;
				ValaField* f;
				_tmp41_ = NULL;
				f = (_tmp41_ = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp41_ == NULL) ? NULL : vala_code_node_ref (_tmp41_));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* instance_target_type;
					ValaClass* _tmp43_;
					ValaTypeSymbol* _tmp42_;
					ValaClass* cl;
					gboolean _tmp44_;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					gboolean _tmp46_;
					gboolean _tmp50_;
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					_tmp43_ = NULL;
					_tmp42_ = NULL;
					cl = (_tmp43_ = (_tmp42_ = vala_data_type_get_data_type (instance_target_type), VALA_IS_CLASS (_tmp42_) ? ((ValaClass*) _tmp42_) : NULL), (_tmp43_ == NULL) ? NULL : vala_code_node_ref (_tmp43_));
					_tmp44_ = FALSE;
					if (vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl)) {
						gboolean _tmp45_;
						_tmp45_ = FALSE;
						if (cl == NULL) {
							_tmp45_ = TRUE;
						} else {
							_tmp45_ = !vala_class_get_is_compact (cl);
						}
						_tmp44_ = _tmp45_;
					} else {
						_tmp44_ = FALSE;
					}
					is_gtypeinstance = _tmp44_;
					inst = NULL;
					_tmp46_ = FALSE;
					if (is_gtypeinstance) {
						_tmp46_ = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						ValaCCodeExpression* _tmp47_;
						_tmp47_ = NULL;
						inst = (_tmp47_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp47_);
					} else {
						ValaCCodeExpression* _tmp49_;
						ValaCCodeExpression* _tmp48_;
						if (cl != NULL) {
							vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, cl, ((ValaCCodeBaseModule*) self)->source_declarations);
						}
						_tmp49_ = NULL;
						_tmp48_ = NULL;
						inst = (_tmp49_ = (_tmp48_ = pub_inst, (_tmp48_ == NULL) ? NULL : vala_ccode_node_ref (_tmp48_)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp49_);
					}
					_tmp50_ = FALSE;
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						_tmp50_ = TRUE;
					} else {
						gboolean _tmp51_;
						_tmp51_ = FALSE;
						if (vala_member_access_get_inner (expr) != NULL) {
							_tmp51_ = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr)));
						} else {
							_tmp51_ = FALSE;
						}
						_tmp50_ = _tmp51_;
					}
					if (_tmp50_) {
						ValaCCodeMemberAccess* _tmp53_;
						char* _tmp52_;
						_tmp53_ = NULL;
						_tmp52_ = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp53_ = vala_ccode_member_access_new_pointer (inst, _tmp52_ = vala_field_get_cname (f))));
						(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
						_tmp52_ = (g_free (_tmp52_), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp55_;
						char* _tmp54_;
						_tmp55_ = NULL;
						_tmp54_ = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp55_ = vala_ccode_member_access_new (inst, _tmp54_ = vala_field_get_cname (f), FALSE)));
						(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
						_tmp54_ = (g_free (_tmp54_), NULL);
					}
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp56_;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp59_;
						char* _tmp58_;
						char* _tmp57_;
						ValaCCodeFunctionCall* _tmp60_;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						_tmp56_ = NULL;
						cl = (_tmp56_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f)), (_tmp56_ == NULL) ? NULL : vala_code_node_ref (_tmp56_));
						_tmp59_ = NULL;
						_tmp58_ = NULL;
						_tmp57_ = NULL;
						_tmp60_ = NULL;
						cast = (_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new (_tmp58_ = g_strconcat (_tmp57_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL)), _tmp58_ = (g_free (_tmp58_), NULL), _tmp57_ = (g_free (_tmp57_), NULL), _tmp60_);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp61_;
								/* Accessing the field from a static or class constructor*/
								_tmp61_ = NULL;
								klass = (_tmp61_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp61_);
							} else {
								ValaCCodeIdentifier* _tmp62_;
								ValaCCodeFunctionCall* _tmp63_;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp64_;
								ValaCCodeExpression* _tmp66_;
								ValaCCodeExpression* _tmp65_;
								/* Accessing the field from within an instance method*/
								_tmp62_ = NULL;
								_tmp63_ = NULL;
								k = (_tmp63_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL)), _tmp63_);
								_tmp64_ = NULL;
								vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp64_ = vala_ccode_identifier_new ("self")));
								(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
								_tmp66_ = NULL;
								_tmp65_ = NULL;
								klass = (_tmp66_ = (_tmp65_ = (ValaCCodeExpression*) k, (_tmp65_ == NULL) ? NULL : vala_ccode_node_ref (_tmp65_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp66_);
								(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
							}
						} else {
							ValaCCodeIdentifier* _tmp67_;
							ValaCCodeFunctionCall* _tmp68_;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp70_;
							ValaCCodeExpression* _tmp69_;
							/* Accessing the field of an instance*/
							_tmp67_ = NULL;
							_tmp68_ = NULL;
							k = (_tmp68_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL)), _tmp68_);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
							_tmp70_ = NULL;
							_tmp69_ = NULL;
							klass = (_tmp70_ = (_tmp69_ = (ValaCCodeExpression*) k, (_tmp69_ == NULL) ? NULL : vala_ccode_node_ref (_tmp69_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp70_);
							(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							ValaCCodeIdentifier* _tmp73_;
							char* _tmp72_;
							char* _tmp71_;
							ValaCCodeFunctionCall* _tmp74_;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp75_;
							ValaCCodeFunctionCall* _tmp76_;
							ValaCCodeFunctionCall* ccall2;
							ValaCCodeMemberAccess* _tmp78_;
							char* _tmp77_;
							_tmp73_ = NULL;
							_tmp72_ = NULL;
							_tmp71_ = NULL;
							_tmp74_ = NULL;
							ccall = (_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp73_ = vala_ccode_identifier_new (_tmp72_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp71_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL)), _tmp72_ = (g_free (_tmp72_), NULL), _tmp71_ = (g_free (_tmp71_), NULL), _tmp74_);
							_tmp75_ = NULL;
							_tmp76_ = NULL;
							ccall2 = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL)), _tmp76_);
							vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) cast);
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
							_tmp78_ = NULL;
							_tmp77_ = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp78_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, _tmp77_ = vala_field_get_cname (f))));
							(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
							_tmp77_ = (g_free (_tmp77_), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
						} else {
							ValaCCodeMemberAccess* _tmp80_;
							char* _tmp79_;
							_tmp80_ = NULL;
							_tmp79_ = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp80_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, _tmp79_ = vala_field_get_cname (f))));
							(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
							_tmp79_ = (g_free (_tmp79_), NULL);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
						(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
					} else {
						ValaCCodeIdentifier* _tmp82_;
						char* _tmp81_;
						vala_ccode_base_module_generate_field_declaration ((ValaCCodeBaseModule*) self, f, ((ValaCCodeBaseModule*) self)->source_declarations);
						_tmp82_ = NULL;
						_tmp81_ = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp82_ = vala_ccode_identifier_new (_tmp81_ = vala_field_get_cname (f))));
						(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
						_tmp81_ = (g_free (_tmp81_), NULL);
					}
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
					ValaConstant* _tmp83_;
					ValaConstant* c;
					char* fn;
					_tmp83_ = NULL;
					c = (_tmp83_ = VALA_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp83_ == NULL) ? NULL : vala_code_node_ref (_tmp83_));
					vala_ccode_base_module_generate_constant_declaration ((ValaCCodeBaseModule*) self, c, ((ValaCCodeBaseModule*) self)->source_declarations);
					fn = vala_symbol_get_full_name ((ValaSymbol*) c);
					if (_vala_strcmp0 (fn, "GLib.Log.FILE") == 0) {
						char* s;
						ValaCCodeConstant* _tmp85_;
						char* _tmp84_;
						s = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) expr))));
						_tmp85_ = NULL;
						_tmp84_ = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp85_ = vala_ccode_constant_new (_tmp84_ = g_strdup_printf ("\"%s\"", s))));
						(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
						_tmp84_ = (g_free (_tmp84_), NULL);
						s = (g_free (s), NULL);
					} else {
						if (_vala_strcmp0 (fn, "GLib.Log.LINE") == 0) {
							gint i;
							ValaCCodeConstant* _tmp87_;
							char* _tmp86_;
							i = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) expr));
							_tmp87_ = NULL;
							_tmp86_ = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp87_ = vala_ccode_constant_new (_tmp86_ = g_strdup_printf ("%d", i))));
							(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
							_tmp86_ = (g_free (_tmp86_), NULL);
						} else {
							if (_vala_strcmp0 (fn, "GLib.Log.METHOD") == 0) {
								char* s;
								ValaCCodeConstant* _tmp90_;
								char* _tmp89_;
								s = g_strdup ("");
								if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
									char* _tmp88_;
									_tmp88_ = NULL;
									s = (_tmp88_ = vala_symbol_get_full_name ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_method), s = (g_free (s), NULL), _tmp88_);
								}
								_tmp90_ = NULL;
								_tmp89_ = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp90_ = vala_ccode_constant_new (_tmp89_ = g_strdup_printf ("\"%s\"", s))));
								(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
								_tmp89_ = (g_free (_tmp89_), NULL);
								s = (g_free (s), NULL);
							} else {
								ValaCCodeIdentifier* _tmp92_;
								char* _tmp91_;
								_tmp92_ = NULL;
								_tmp91_ = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp92_ = vala_ccode_identifier_new (_tmp91_ = vala_constant_get_cname (c))));
								(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
								_tmp91_ = (g_free (_tmp91_), NULL);
							}
						}
					}
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
					fn = (g_free (fn), NULL);
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
						ValaProperty* _tmp93_;
						ValaProperty* prop;
						gboolean _tmp114_;
						gboolean _tmp115_;
						gboolean _tmp116_;
						_tmp93_ = NULL;
						prop = (_tmp93_ = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp93_ == NULL) ? NULL : vala_code_node_ref (_tmp93_));
						if (!VALA_IS_DYNAMIC_PROPERTY (prop)) {
							gboolean _tmp94_;
							vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, vala_property_get_get_accessor (prop), ((ValaCCodeBaseModule*) self)->source_declarations);
							_tmp94_ = FALSE;
							if (!vala_symbol_get_external ((ValaSymbol*) prop)) {
								_tmp94_ = vala_symbol_get_external_package ((ValaSymbol*) prop);
							} else {
								_tmp94_ = FALSE;
							}
							if (_tmp94_) {
								/* internal VAPI properties
								 only add them once per source file*/
								if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) prop)) {
									vala_ccode_module_visit_property ((ValaCCodeModule*) self, prop);
								}
							}
						}
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp95_;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp98_;
								char* _tmp97_;
								char* _tmp96_;
								ValaCCodeFunctionCall* _tmp99_;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp102_;
								char* _tmp101_;
								char* _tmp100_;
								ValaCCodeMemberAccess* _tmp104_;
								char* _tmp103_;
								ValaCCodeFunctionCall* _tmp105_;
								ValaCCodeFunctionCall* ccall;
								_tmp95_ = NULL;
								base_class = (_tmp95_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp95_ == NULL) ? NULL : vala_code_node_ref (_tmp95_));
								_tmp98_ = NULL;
								_tmp97_ = NULL;
								_tmp96_ = NULL;
								_tmp99_ = NULL;
								vcast = (_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new (_tmp97_ = g_strdup_printf ("%s_CLASS", _tmp96_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL)), _tmp97_ = (g_free (_tmp97_), NULL), _tmp96_ = (g_free (_tmp96_), NULL), _tmp99_);
								_tmp102_ = NULL;
								_tmp101_ = NULL;
								_tmp100_ = NULL;
								vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new (_tmp101_ = g_strdup_printf ("%s_parent_class", _tmp100_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
								(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
								_tmp101_ = (g_free (_tmp101_), NULL);
								_tmp100_ = (g_free (_tmp100_), NULL);
								_tmp104_ = NULL;
								_tmp103_ = NULL;
								_tmp105_ = NULL;
								ccall = (_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp104_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp103_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL)), _tmp103_ = (g_free (_tmp103_), NULL), _tmp105_);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
								(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp106_;
									ValaInterface* base_iface;
									char* _tmp108_;
									char* _tmp107_;
									char* _tmp109_;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp112_;
									char* _tmp111_;
									ValaCCodeIdentifier* _tmp110_;
									ValaCCodeFunctionCall* _tmp113_;
									ValaCCodeFunctionCall* ccall;
									_tmp106_ = NULL;
									base_iface = (_tmp106_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp106_ == NULL) ? NULL : vala_code_node_ref (_tmp106_));
									_tmp108_ = NULL;
									_tmp107_ = NULL;
									_tmp109_ = NULL;
									parent_iface_var = (_tmp109_ = g_strdup_printf ("%s_%s_parent_iface", _tmp107_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp108_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp108_ = (g_free (_tmp108_), NULL), _tmp107_ = (g_free (_tmp107_), NULL), _tmp109_);
									_tmp112_ = NULL;
									_tmp111_ = NULL;
									_tmp110_ = NULL;
									_tmp113_ = NULL;
									ccall = (_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp112_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp110_ = vala_ccode_identifier_new (parent_iface_var)), _tmp111_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL)), _tmp111_ = (g_free (_tmp111_), NULL), (_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL)), _tmp113_);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
									(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
									(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
									return;
								}
							}
						}
						_tmp114_ = FALSE;
						_tmp115_ = FALSE;
						_tmp116_ = FALSE;
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop))) {
							_tmp116_ = VALA_SYMBOL (((ValaCCodeBaseModule*) self)->current_type_symbol) == vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
						} else {
							_tmp116_ = FALSE;
						}
						if (_tmp116_) {
							_tmp115_ = vala_property_get_base_property (prop) == NULL;
						} else {
							_tmp115_ = FALSE;
						}
						if (_tmp115_) {
							_tmp114_ = vala_property_get_base_interface_property (prop) == NULL;
						} else {
							_tmp114_ = FALSE;
						}
						if (_tmp114_) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp117_;
							ValaCCodeMemberAccess* _tmp119_;
							char* _tmp118_;
							inst = NULL;
							_tmp117_ = NULL;
							inst = (_tmp117_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp117_);
							_tmp119_ = NULL;
							_tmp118_ = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp119_ = vala_ccode_member_access_new_pointer (inst, _tmp118_ = vala_field_get_cname (vala_property_get_field (prop)))));
							(_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_ccode_node_unref (_tmp119_), NULL));
							_tmp118_ = (g_free (_tmp118_), NULL);
							(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp120_;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp127_;
								ValaCCodeFunctionCall* _tmp128_;
								ValaCCodeFunctionCall* ccall;
								_tmp120_ = NULL;
								base_property = (_tmp120_ = prop, (_tmp120_ == NULL) ? NULL : vala_code_node_ref (_tmp120_));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp122_;
									ValaProperty* _tmp121_;
									_tmp122_ = NULL;
									_tmp121_ = NULL;
									base_property = (_tmp122_ = (_tmp121_ = vala_property_get_base_property (prop), (_tmp121_ == NULL) ? NULL : vala_code_node_ref (_tmp121_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp122_);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp124_;
										ValaProperty* _tmp123_;
										_tmp124_ = NULL;
										_tmp123_ = NULL;
										base_property = (_tmp124_ = (_tmp123_ = vala_property_get_base_interface_property (prop), (_tmp123_ == NULL) ? NULL : vala_code_node_ref (_tmp123_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp124_);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp125_;
									_tmp125_ = NULL;
									getter_cname = (_tmp125_ = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), getter_cname = (g_free (getter_cname), NULL), _tmp125_);
								} else {
									char* _tmp126_;
									_tmp126_ = NULL;
									getter_cname = (_tmp126_ = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), getter_cname = (g_free (getter_cname), NULL), _tmp126_);
								}
								_tmp127_ = NULL;
								_tmp128_ = NULL;
								ccall = (_tmp128_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp127_ = vala_ccode_identifier_new (getter_cname))), (_tmp127_ == NULL) ? NULL : (_tmp127_ = (vala_ccode_node_unref (_tmp127_), NULL)), _tmp128_);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property access to real struct types is handled differently
								 The value is returned by out parameter*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp129_;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_property_accessor_get_value_type (vala_property_get_get_accessor (base_property)), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
									gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
									_tmp129_ = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp129_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
									(_tmp129_ == NULL) ? NULL : (_tmp129_ = (vala_ccode_node_unref (_tmp129_), NULL));
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
									(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
									(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
									(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								} else {
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								}
								(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							} else {
								ValaCCodeIdentifier* _tmp130_;
								ValaCCodeFunctionCall* _tmp131_;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeConstant* _tmp132_;
								ValaCCodeCommaExpression* ccomma;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp135_;
								ValaCCodeConstant* _tmp136_;
								_tmp130_ = NULL;
								_tmp131_ = NULL;
								ccall = (_tmp131_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp130_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL)), _tmp131_);
								vala_ccode_function_call_add_argument (ccall, pub_inst);
								/* property name is second argument of g_object_get*/
								_tmp132_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp132_ = vala_property_get_canonical_cconstant (prop)));
								(_tmp132_ == NULL) ? NULL : (_tmp132_ = (vala_ccode_node_unref (_tmp132_), NULL));
								/* g_object_get always returns owned values
								 therefore, property getters of properties
								 without accessor methods need to be marked as owned*/
								if (!vala_data_type_get_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)))) {
									ValaDataType* owned_value_type;
									/* only report error for types where there actually
									 is a difference between `owned' and `unowned'*/
									owned_value_type = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)));
									vala_data_type_set_value_owned (owned_value_type, TRUE);
									if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, owned_value_type)) {
										char* _tmp134_;
										char* _tmp133_;
										_tmp134_ = NULL;
										_tmp133_ = NULL;
										vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_get_get_accessor (prop)), _tmp134_ = g_strdup_printf ("unowned return value for getter of property `%s' not supported without accessor", _tmp133_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
										_tmp134_ = (g_free (_tmp134_), NULL);
										_tmp133_ = (g_free (_tmp133_), NULL);
									}
									(owned_value_type == NULL) ? NULL : (owned_value_type = (vala_code_node_unref (owned_value_type), NULL));
								}
								ccomma = vala_ccode_comma_expression_new ();
								temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, NULL);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
								gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
								_tmp135_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp135_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
								(_tmp135_ == NULL) ? NULL : (_tmp135_ = (vala_ccode_node_unref (_tmp135_), NULL));
								_tmp136_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp136_ = vala_ccode_constant_new ("NULL")));
								(_tmp136_ == NULL) ? NULL : (_tmp136_ = (vala_ccode_node_unref (_tmp136_), NULL));
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
								(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
								(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
							}
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
							ValaEnumValue* _tmp137_;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp139_;
							char* _tmp138_;
							_tmp137_ = NULL;
							ev = (_tmp137_ = VALA_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp137_ == NULL) ? NULL : vala_code_node_ref (_tmp137_));
							vala_ccode_base_module_generate_enum_declaration ((ValaCCodeBaseModule*) self, VALA_ENUM (vala_symbol_get_parent_symbol ((ValaSymbol*) ev)), ((ValaCCodeBaseModule*) self)->source_declarations);
							_tmp139_ = NULL;
							_tmp138_ = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp139_ = vala_ccode_constant_new (_tmp138_ = vala_enum_value_get_cname (ev))));
							(_tmp139_ == NULL) ? NULL : (_tmp139_ = (vala_ccode_node_unref (_tmp139_), NULL));
							_tmp138_ = (g_free (_tmp138_), NULL);
							(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
								ValaLocalVariable* _tmp140_;
								ValaLocalVariable* local;
								ValaCCodeExpression* _tmp141_;
								_tmp140_ = NULL;
								local = (_tmp140_ = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp140_ == NULL) ? NULL : vala_code_node_ref (_tmp140_));
								_tmp141_ = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp141_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))));
								(_tmp141_ == NULL) ? NULL : (_tmp141_ = (vala_ccode_node_unref (_tmp141_), NULL));
								(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
									ValaFormalParameter* _tmp142_;
									ValaFormalParameter* p;
									_tmp142_ = NULL;
									p = (_tmp142_ = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp142_ == NULL) ? NULL : vala_code_node_ref (_tmp142_));
									if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "this") == 0) {
										gboolean _tmp143_;
										_tmp143_ = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp143_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp143_ = FALSE;
										}
										if (_tmp143_) {
											ValaCCodeExpression* _tmp144_;
											/* use closure*/
											_tmp144_ = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp144_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "self")));
											(_tmp144_ == NULL) ? NULL : (_tmp144_ = (vala_ccode_node_unref (_tmp144_), NULL));
										} else {
											ValaStruct* _tmp146_;
											ValaTypeSymbol* _tmp145_;
											ValaStruct* st;
											gboolean _tmp147_;
											_tmp146_ = NULL;
											_tmp145_ = NULL;
											st = (_tmp146_ = (_tmp145_ = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_STRUCT (_tmp145_) ? ((ValaStruct*) _tmp145_) : NULL), (_tmp146_ == NULL) ? NULL : vala_code_node_ref (_tmp146_));
											_tmp147_ = FALSE;
											if (st != NULL) {
												_tmp147_ = !vala_struct_is_simple_type (st);
											} else {
												_tmp147_ = FALSE;
											}
											if (_tmp147_) {
												ValaCCodeIdentifier* _tmp148_;
												_tmp148_ = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp148_ = vala_ccode_identifier_new ("(*self)")));
												(_tmp148_ == NULL) ? NULL : (_tmp148_ = (vala_ccode_node_unref (_tmp148_), NULL));
											} else {
												ValaCCodeIdentifier* _tmp149_;
												_tmp149_ = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp149_ = vala_ccode_identifier_new ("self")));
												(_tmp149_ == NULL) ? NULL : (_tmp149_ = (vala_ccode_node_unref (_tmp149_), NULL));
											}
											(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
										}
									} else {
										gboolean _tmp150_;
										_tmp150_ = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp150_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp150_ = FALSE;
										}
										if (_tmp150_) {
											ValaCCodeExpression* _tmp151_;
											/* use closure*/
											_tmp151_ = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp151_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))));
											(_tmp151_ == NULL) ? NULL : (_tmp151_ = (vala_ccode_node_unref (_tmp151_), NULL));
										} else {
											ValaStruct* _tmp153_;
											ValaTypeSymbol* _tmp152_;
											ValaStruct* type_as_struct;
											gboolean _tmp154_;
											_tmp153_ = NULL;
											_tmp152_ = NULL;
											type_as_struct = (_tmp153_ = (_tmp152_ = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), VALA_IS_STRUCT (_tmp152_) ? ((ValaStruct*) _tmp152_) : NULL), (_tmp153_ == NULL) ? NULL : vala_code_node_ref (_tmp153_));
											_tmp154_ = FALSE;
											if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
												_tmp154_ = TRUE;
											} else {
												gboolean _tmp155_;
												gboolean _tmp156_;
												_tmp155_ = FALSE;
												_tmp156_ = FALSE;
												if (type_as_struct != NULL) {
													_tmp156_ = !vala_struct_is_simple_type (type_as_struct);
												} else {
													_tmp156_ = FALSE;
												}
												if (_tmp156_) {
													_tmp155_ = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
												} else {
													_tmp155_ = FALSE;
												}
												_tmp154_ = _tmp155_;
											}
											if (_tmp154_) {
												ValaCCodeIdentifier* _tmp159_;
												char* _tmp158_;
												char* _tmp157_;
												_tmp159_ = NULL;
												_tmp158_ = NULL;
												_tmp157_ = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp159_ = vala_ccode_identifier_new (_tmp158_ = g_strdup_printf ("(*%s)", _tmp157_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))))));
												(_tmp159_ == NULL) ? NULL : (_tmp159_ = (vala_ccode_node_unref (_tmp159_), NULL));
												_tmp158_ = (g_free (_tmp158_), NULL);
												_tmp157_ = (g_free (_tmp157_), NULL);
											} else {
												gboolean _tmp160_;
												gboolean _tmp161_;
												gboolean _tmp162_;
												_tmp160_ = FALSE;
												_tmp161_ = FALSE;
												_tmp162_ = FALSE;
												if (((ValaCCodeBaseModule*) self)->current_property_accessor != NULL) {
													_tmp162_ = vala_property_accessor_get_writable (((ValaCCodeBaseModule*) self)->current_property_accessor);
												} else {
													_tmp162_ = FALSE;
												}
												if (_tmp162_) {
													_tmp161_ = vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) self)->current_property_accessor) == p;
												} else {
													_tmp161_ = FALSE;
												}
												if (_tmp161_) {
													_tmp160_ = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) self)->current_property_accessor)));
												} else {
													_tmp160_ = FALSE;
												}
												/* Property setters of non simple structs shall replace all occurences
												 of the "value" formal parameter with a dereferencing version of that
												 parameter.*/
												if (_tmp160_) {
													ValaCCodeIdentifier* _tmp163_;
													_tmp163_ = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp163_ = vala_ccode_identifier_new ("(*value)")));
													(_tmp163_ == NULL) ? NULL : (_tmp163_ = (vala_ccode_node_unref (_tmp163_), NULL));
												} else {
													ValaCCodeExpression* _tmp164_;
													_tmp164_ = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp164_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))));
													(_tmp164_ == NULL) ? NULL : (_tmp164_ = (vala_ccode_node_unref (_tmp164_), NULL));
												}
											}
											(type_as_struct == NULL) ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL));
										}
									}
									(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
								}
							}
						}
					}
				}
			}
		}
	}
	(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
	(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




