/* valagenieparser.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;

#define VALA_GENIE_TYPE_PARSER (vala_genie_parser_get_type ())
#define VALA_GENIE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_PARSER, ValaGenieParser))
#define VALA_GENIE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_PARSER, ValaGenieParserClass))
#define VALA_GENIE_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_PARSER))
#define VALA_GENIE_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_PARSER))
#define VALA_GENIE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_PARSER, ValaGenieParserClass))

typedef struct _ValaGenieParser ValaGenieParser;
typedef struct _ValaGenieParserClass ValaGenieParserClass;
typedef struct _ValaGenieParserPrivate ValaGenieParserPrivate;

#define VALA_GENIE_TYPE_SCANNER (vala_genie_scanner_get_type ())
#define VALA_GENIE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScanner))
#define VALA_GENIE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))
#define VALA_GENIE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))

typedef struct _ValaGenieScanner ValaGenieScanner;
typedef struct _ValaGenieScannerClass ValaGenieScannerClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_GENIE_PARSER_TYPE_TOKEN_INFO (vala_genie_parser_token_info_get_type ())

#define VALA_GENIE_TYPE_TOKEN_TYPE (vala_genie_token_type_get_type ())

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;
typedef struct _ValaGenieParserTokenInfo ValaGenieParserTokenInfo;

#define VALA_GENIE_PARSER_TYPE_MODIFIER_FLAGS (vala_genie_parser_modifier_flags_get_type ())

#define VALA_GENIE_PARSER_TYPE_RECOVERY_STATE (vala_genie_parser_recovery_state_get_type ())

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_UNRESOLVED_SYMBOL (vala_unresolved_symbol_get_type ())
#define VALA_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol))
#define VALA_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))
#define VALA_IS_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_IS_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_UNRESOLVED_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))

typedef struct _ValaUnresolvedSymbol ValaUnresolvedSymbol;
typedef struct _ValaUnresolvedSymbolClass ValaUnresolvedSymbolClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_UNRESOLVED_TYPE (vala_unresolved_type_get_type ())
#define VALA_UNRESOLVED_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType))
#define VALA_UNRESOLVED_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypeClass))
#define VALA_IS_UNRESOLVED_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_TYPE))
#define VALA_IS_UNRESOLVED_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_TYPE))
#define VALA_UNRESOLVED_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypeClass))

typedef struct _ValaUnresolvedType ValaUnresolvedType;
typedef struct _ValaUnresolvedTypeClass ValaUnresolvedTypeClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_UNARY_OPERATOR (vala_unary_operator_get_type ())

#define VALA_TYPE_TUPLE (vala_tuple_get_type ())
#define VALA_TUPLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TUPLE, ValaTuple))
#define VALA_TUPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TUPLE, ValaTupleClass))
#define VALA_IS_TUPLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TUPLE))
#define VALA_IS_TUPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TUPLE))
#define VALA_TUPLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TUPLE, ValaTupleClass))

typedef struct _ValaTuple ValaTuple;
typedef struct _ValaTupleClass ValaTupleClass;

#define VALA_TYPE_BINARY_OPERATOR (vala_binary_operator_get_type ())

#define VALA_TYPE_MEMBER_INITIALIZER (vala_member_initializer_get_type ())
#define VALA_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer))
#define VALA_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))
#define VALA_IS_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_IS_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_MEMBER_INITIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))

typedef struct _ValaMemberInitializer ValaMemberInitializer;
typedef struct _ValaMemberInitializerClass ValaMemberInitializerClass;

#define VALA_TYPE_ASSIGNMENT_OPERATOR (vala_assignment_operator_get_type ())

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor parsing all Genie source files.
 */
struct _ValaGenieParser {
	ValaCodeVisitor parent_instance;
	ValaGenieParserPrivate * priv;
};

struct _ValaGenieParserClass {
	ValaCodeVisitorClass parent_class;
};

typedef enum  {
	VALA_GENIE_TOKEN_TYPE_NONE,
	VALA_GENIE_TOKEN_TYPE_ABSTRACT,
	VALA_GENIE_TOKEN_TYPE_ARRAY,
	VALA_GENIE_TOKEN_TYPE_AS,
	VALA_GENIE_TOKEN_TYPE_ASSERT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB,
	VALA_GENIE_TOKEN_TYPE_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_BREAK,
	VALA_GENIE_TOKEN_TYPE_CARRET,
	VALA_GENIE_TOKEN_TYPE_CASE,
	VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLASS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS,
	VALA_GENIE_TOKEN_TYPE_COLON,
	VALA_GENIE_TOKEN_TYPE_COMMA,
	VALA_GENIE_TOKEN_TYPE_CONST,
	VALA_GENIE_TOKEN_TYPE_CONSTRUCT,
	VALA_GENIE_TOKEN_TYPE_CONTINUE,
	VALA_GENIE_TOKEN_TYPE_DEDENT,
	VALA_GENIE_TOKEN_TYPE_DEF,
	VALA_GENIE_TOKEN_TYPE_DEFAULT,
	VALA_GENIE_TOKEN_TYPE_DELEGATE,
	VALA_GENIE_TOKEN_TYPE_DELETE,
	VALA_GENIE_TOKEN_TYPE_DICT,
	VALA_GENIE_TOKEN_TYPE_DIV,
	VALA_GENIE_TOKEN_TYPE_DO,
	VALA_GENIE_TOKEN_TYPE_DOT,
	VALA_GENIE_TOKEN_TYPE_DOWNTO,
	VALA_GENIE_TOKEN_TYPE_DYNAMIC,
	VALA_GENIE_TOKEN_TYPE_ELLIPSIS,
	VALA_GENIE_TOKEN_TYPE_ELSE,
	VALA_GENIE_TOKEN_TYPE_ENUM,
	VALA_GENIE_TOKEN_TYPE_ENSURES,
	VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN,
	VALA_GENIE_TOKEN_TYPE_EOF,
	VALA_GENIE_TOKEN_TYPE_EOL,
	VALA_GENIE_TOKEN_TYPE_EVENT,
	VALA_GENIE_TOKEN_TYPE_EXCEPT,
	VALA_GENIE_TOKEN_TYPE_EXTERN,
	VALA_GENIE_TOKEN_TYPE_FALSE,
	VALA_GENIE_TOKEN_TYPE_FINAL,
	VALA_GENIE_TOKEN_TYPE_FINALLY,
	VALA_GENIE_TOKEN_TYPE_FOR,
	VALA_GENIE_TOKEN_TYPE_FOREACH,
	VALA_GENIE_TOKEN_TYPE_GET,
	VALA_GENIE_TOKEN_TYPE_HASH,
	VALA_GENIE_TOKEN_TYPE_IDENTIFIER,
	VALA_GENIE_TOKEN_TYPE_IF,
	VALA_GENIE_TOKEN_TYPE_IMPLEMENTS,
	VALA_GENIE_TOKEN_TYPE_IN,
	VALA_GENIE_TOKEN_TYPE_INDENT,
	VALA_GENIE_TOKEN_TYPE_INIT,
	VALA_GENIE_TOKEN_TYPE_INLINE,
	VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_INTERFACE,
	VALA_GENIE_TOKEN_TYPE_INTERNAL,
	VALA_GENIE_TOKEN_TYPE_INTERR,
	VALA_GENIE_TOKEN_TYPE_IS,
	VALA_GENIE_TOKEN_TYPE_ISA,
	VALA_GENIE_TOKEN_TYPE_LAMBDA,
	VALA_GENIE_TOKEN_TYPE_LIST,
	VALA_GENIE_TOKEN_TYPE_LOCK,
	VALA_GENIE_TOKEN_TYPE_MINUS,
	VALA_GENIE_TOKEN_TYPE_NAMESPACE,
	VALA_GENIE_TOKEN_TYPE_NEW,
	VALA_GENIE_TOKEN_TYPE_NULL,
	VALA_GENIE_TOKEN_TYPE_OF,
	VALA_GENIE_TOKEN_TYPE_OUT,
	VALA_GENIE_TOKEN_TYPE_OP_AND,
	VALA_GENIE_TOKEN_TYPE_OP_DEC,
	VALA_GENIE_TOKEN_TYPE_OP_EQ,
	VALA_GENIE_TOKEN_TYPE_OP_GE,
	VALA_GENIE_TOKEN_TYPE_OP_GT,
	VALA_GENIE_TOKEN_TYPE_OP_INC,
	VALA_GENIE_TOKEN_TYPE_OP_LE,
	VALA_GENIE_TOKEN_TYPE_OP_LT,
	VALA_GENIE_TOKEN_TYPE_OP_NE,
	VALA_GENIE_TOKEN_TYPE_OP_NEG,
	VALA_GENIE_TOKEN_TYPE_OP_OR,
	VALA_GENIE_TOKEN_TYPE_OP_PTR,
	VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACE,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET,
	VALA_GENIE_TOKEN_TYPE_OPEN_PARENS,
	VALA_GENIE_TOKEN_TYPE_OVERRIDE,
	VALA_GENIE_TOKEN_TYPE_OWNED,
	VALA_GENIE_TOKEN_TYPE_PARAMS,
	VALA_GENIE_TOKEN_TYPE_PASS,
	VALA_GENIE_TOKEN_TYPE_PERCENT,
	VALA_GENIE_TOKEN_TYPE_PLUS,
	VALA_GENIE_TOKEN_TYPE_PRINT,
	VALA_GENIE_TOKEN_TYPE_PRIVATE,
	VALA_GENIE_TOKEN_TYPE_PROP,
	VALA_GENIE_TOKEN_TYPE_PROTECTED,
	VALA_GENIE_TOKEN_TYPE_PUBLIC,
	VALA_GENIE_TOKEN_TYPE_RAISE,
	VALA_GENIE_TOKEN_TYPE_RAISES,
	VALA_GENIE_TOKEN_TYPE_REAL_LITERAL,
	VALA_GENIE_TOKEN_TYPE_READONLY,
	VALA_GENIE_TOKEN_TYPE_REF,
	VALA_GENIE_TOKEN_TYPE_REQUIRES,
	VALA_GENIE_TOKEN_TYPE_RETURN,
	VALA_GENIE_TOKEN_TYPE_SEMICOLON,
	VALA_GENIE_TOKEN_TYPE_SET,
	VALA_GENIE_TOKEN_TYPE_SIZEOF,
	VALA_GENIE_TOKEN_TYPE_STAR,
	VALA_GENIE_TOKEN_TYPE_STATIC,
	VALA_GENIE_TOKEN_TYPE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_STRUCT,
	VALA_GENIE_TOKEN_TYPE_SUPER,
	VALA_GENIE_TOKEN_TYPE_THIS,
	VALA_GENIE_TOKEN_TYPE_TILDE,
	VALA_GENIE_TOKEN_TYPE_TO,
	VALA_GENIE_TOKEN_TYPE_TRUE,
	VALA_GENIE_TOKEN_TYPE_TRY,
	VALA_GENIE_TOKEN_TYPE_TYPEOF,
	VALA_GENIE_TOKEN_TYPE_UNOWNED,
	VALA_GENIE_TOKEN_TYPE_USES,
	VALA_GENIE_TOKEN_TYPE_VAR,
	VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_VIRTUAL,
	VALA_GENIE_TOKEN_TYPE_VOID,
	VALA_GENIE_TOKEN_TYPE_VOLATILE,
	VALA_GENIE_TOKEN_TYPE_WEAK,
	VALA_GENIE_TOKEN_TYPE_WHEN,
	VALA_GENIE_TOKEN_TYPE_WHILE,
	VALA_GENIE_TOKEN_TYPE_WRITEONLY,
	VALA_GENIE_TOKEN_TYPE_YIELD,
	VALA_GENIE_TOKEN_TYPE_YIELDS
} ValaGenieTokenType;

/**
 * Represents a position in a source file.
 */
struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _ValaGenieParserTokenInfo {
	ValaGenieTokenType type;
	ValaSourceLocation begin;
	ValaSourceLocation end;
};

struct _ValaGenieParserPrivate {
	ValaGenieScanner* scanner;
	ValaCodeContext* context;
	ValaGenieParserTokenInfo* tokens;
	gint tokens_length1;
	gint tokens_size;
	gint index;
	gint size;
	char* comment;
	char* class_name;
	gboolean current_expr_is_lambda;
};

typedef enum  {
	VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT = 1 << 0,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS = 1 << 1,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN = 1 << 2,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE = 1 << 3,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW = 1 << 4,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE = 1 << 5,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC = 1 << 6,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL = 1 << 7,
	VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE = 1 << 8
} ValaGenieParserModifierFlags;

typedef enum  {
	VALA_GENIE_PARSER_RECOVERY_STATE_EOF,
	VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN,
	VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN
} ValaGenieParserRecoveryState;

typedef enum  {
	VALA_PARSE_ERROR_FAILED,
	VALA_PARSE_ERROR_SYNTAX
} ValaParseError;
#define VALA_PARSE_ERROR vala_parse_error_quark ()
typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_UNARY_OPERATOR_NONE,
	VALA_UNARY_OPERATOR_PLUS,
	VALA_UNARY_OPERATOR_MINUS,
	VALA_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_UNARY_OPERATOR_INCREMENT,
	VALA_UNARY_OPERATOR_DECREMENT,
	VALA_UNARY_OPERATOR_REF,
	VALA_UNARY_OPERATOR_OUT
} ValaUnaryOperator;

typedef enum  {
	VALA_BINARY_OPERATOR_NONE,
	VALA_BINARY_OPERATOR_PLUS,
	VALA_BINARY_OPERATOR_MINUS,
	VALA_BINARY_OPERATOR_MUL,
	VALA_BINARY_OPERATOR_DIV,
	VALA_BINARY_OPERATOR_MOD,
	VALA_BINARY_OPERATOR_SHIFT_LEFT,
	VALA_BINARY_OPERATOR_SHIFT_RIGHT,
	VALA_BINARY_OPERATOR_LESS_THAN,
	VALA_BINARY_OPERATOR_GREATER_THAN,
	VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL,
	VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL,
	VALA_BINARY_OPERATOR_EQUALITY,
	VALA_BINARY_OPERATOR_INEQUALITY,
	VALA_BINARY_OPERATOR_BITWISE_AND,
	VALA_BINARY_OPERATOR_BITWISE_OR,
	VALA_BINARY_OPERATOR_BITWISE_XOR,
	VALA_BINARY_OPERATOR_AND,
	VALA_BINARY_OPERATOR_OR,
	VALA_BINARY_OPERATOR_IN
} ValaBinaryOperator;

typedef enum  {
	VALA_ASSIGNMENT_OPERATOR_NONE,
	VALA_ASSIGNMENT_OPERATOR_SIMPLE,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_OR,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_AND,
	VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR,
	VALA_ASSIGNMENT_OPERATOR_ADD,
	VALA_ASSIGNMENT_OPERATOR_SUB,
	VALA_ASSIGNMENT_OPERATOR_MUL,
	VALA_ASSIGNMENT_OPERATOR_DIV,
	VALA_ASSIGNMENT_OPERATOR_PERCENT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT,
	VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT
} ValaAssignmentOperator;

/**
 * Interface for all statement types.
 */
struct _ValaStatementIface {
	GTypeInterface parent_iface;
};

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;



gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
GType vala_symbol_get_type (void);
GType vala_namespace_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
GType vala_struct_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_delegate_get_type (void);
GType vala_member_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_method_get_type (void);
GType vala_creation_method_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_data_type_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_expression_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_member_access_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
GType vala_genie_parser_get_type (void);
gpointer vala_genie_scanner_ref (gpointer instance);
void vala_genie_scanner_unref (gpointer instance);
GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_genie_value_set_scanner (GValue* value, gpointer v_object);
gpointer vala_genie_value_get_scanner (const GValue* value);
GType vala_genie_scanner_get_type (void);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
static GType vala_genie_parser_token_info_get_type (void);
GType vala_genie_token_type_get_type (void);
GType vala_source_location_get_type (void);
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
static ValaGenieParserTokenInfo* vala_genie_parser_token_info_dup (const ValaGenieParserTokenInfo* self);
static void vala_genie_parser_token_info_free (ValaGenieParserTokenInfo* self);
#define VALA_GENIE_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GENIE_TYPE_PARSER, ValaGenieParserPrivate))
enum  {
	VALA_GENIE_PARSER_DUMMY_PROPERTY
};
static GType vala_genie_parser_modifier_flags_get_type (void);
static GType vala_genie_parser_recovery_state_get_type (void);
#define VALA_GENIE_PARSER_BUFFER_SIZE 32
ValaGenieParser* vala_genie_parser_new (void);
ValaGenieParser* vala_genie_parser_construct (GType object_type);
ValaGenieParser* vala_genie_parser_new (void);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_genie_parser_parse (ValaGenieParser* self, ValaCodeContext* context);
const char* vala_source_file_get_filename (ValaSourceFile* self);
void vala_genie_parser_parse_file (ValaGenieParser* self, ValaSourceFile* source_file);
static void vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static inline gboolean vala_genie_parser_next (ValaGenieParser* self);
static inline void vala_genie_parser_prev (ValaGenieParser* self);
static inline ValaGenieTokenType vala_genie_parser_current (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept (ValaGenieParser* self, ValaGenieTokenType type);
static inline gboolean vala_genie_parser_accept_terminator (ValaGenieParser* self);
static inline gboolean vala_genie_parser_accept_block (ValaGenieParser* self);
static inline ValaSourceLocation vala_genie_parser_get_location (ValaGenieParser* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_report_error (ValaSourceReference* source, const char* message);
static ValaSourceReference* vala_genie_parser_get_src (ValaGenieParser* self, const ValaSourceLocation* begin);
static char* vala_genie_parser_get_error (ValaGenieParser* self, const char* msg);
const char* vala_genie_token_type_to_string (ValaGenieTokenType self);
GQuark vala_parse_error_quark (void);
static inline gboolean vala_genie_parser_expect (ValaGenieParser* self, ValaGenieTokenType type, GError** error);
static inline gboolean vala_genie_parser_expect_terminator (ValaGenieParser* self, GError** error);
static char* vala_genie_parser_get_current_string (ValaGenieParser* self);
static char* vala_genie_parser_get_last_string (ValaGenieParser* self);
ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_new_with_comment (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column, const char* _comment);
ValaSourceReference* vala_source_reference_construct_with_comment (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column, const char* _comment);
static ValaSourceReference* vala_genie_parser_get_src_com (ValaGenieParser* self, const ValaSourceLocation* begin);
static ValaSourceReference* vala_genie_parser_get_current_src (ValaGenieParser* self);
static void vala_genie_parser_rollback (ValaGenieParser* self, const ValaSourceLocation* location);
GType vala_symbol_accessibility_get_type (void);
static inline ValaSymbolAccessibility vala_genie_parser_get_access (ValaGenieParser* self, const char* s);
static void vala_genie_parser_skip_identifier (ValaGenieParser* self, GError** error);
static char* vala_genie_parser_parse_identifier (ValaGenieParser* self, GError** error);
ValaBooleanLiteral* vala_boolean_literal_new (gboolean b, ValaSourceReference* source);
ValaBooleanLiteral* vala_boolean_literal_construct (GType object_type, gboolean b, ValaSourceReference* source);
ValaIntegerLiteral* vala_integer_literal_new (const char* i, ValaSourceReference* source);
ValaIntegerLiteral* vala_integer_literal_construct (GType object_type, const char* i, ValaSourceReference* source);
ValaRealLiteral* vala_real_literal_new (const char* r, ValaSourceReference* source);
ValaRealLiteral* vala_real_literal_construct (GType object_type, const char* r, ValaSourceReference* source);
ValaCharacterLiteral* vala_character_literal_new (const char* c, ValaSourceReference* source);
ValaCharacterLiteral* vala_character_literal_construct (GType object_type, const char* c, ValaSourceReference* source);
gboolean vala_code_node_get_error (ValaCodeNode* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaStringLiteral* vala_string_literal_new (const char* value, ValaSourceReference* source_reference);
ValaStringLiteral* vala_string_literal_construct (GType object_type, const char* value, ValaSourceReference* source_reference);
ValaNullLiteral* vala_null_literal_new (ValaSourceReference* source);
ValaNullLiteral* vala_null_literal_construct (GType object_type, ValaSourceReference* source);
static ValaExpression* vala_genie_parser_parse_literal (ValaGenieParser* self, GError** error);
ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file);
ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file);
void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value);
static void vala_genie_parser_parse_using_directives (ValaGenieParser* self, GError** error);
static void vala_genie_parser_parse_declarations (ValaGenieParser* self, ValaSymbol* parent, gboolean root, GError** error);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
static void vala_genie_parser_skip_symbol_name (ValaGenieParser* self, GError** error);
GType vala_unresolved_symbol_get_type (void);
ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
static ValaUnresolvedSymbol* vala_genie_parser_parse_symbol_name (ValaGenieParser* self, GError** error);
static void vala_genie_parser_skip_type_argument_list (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_expression (ValaGenieParser* self, GError** error);
static void vala_genie_parser_skip_type (ValaGenieParser* self, GError** error);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void);
ValaPointerType* vala_pointer_type_new (ValaDataType* base_type, ValaSourceReference* source_reference);
ValaPointerType* vala_pointer_type_construct (GType object_type, ValaDataType* base_type, ValaSourceReference* source_reference);
GType vala_pointer_type_get_type (void);
static GeeList* vala_genie_parser_parse_type_argument_list (ValaGenieParser* self, gboolean maybe_expression, GError** error);
ValaUnresolvedType* vala_unresolved_type_new_from_symbol (ValaUnresolvedSymbol* symbol, ValaSourceReference* source);
ValaUnresolvedType* vala_unresolved_type_construct_from_symbol (GType object_type, ValaUnresolvedSymbol* symbol, ValaSourceReference* source);
GType vala_unresolved_type_get_type (void);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
GType vala_reference_type_get_type (void);
GType vala_array_type_get_type (void);
const char* vala_integer_literal_get_value (ValaIntegerLiteral* self);
void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value);
void vala_array_type_set_length (ValaArrayType* self, gint value);
void vala_data_type_set_is_dynamic (ValaDataType* self, gboolean value);
static ValaDataType* vala_genie_parser_parse_type (ValaGenieParser* self, gboolean owned_by_default, GError** error);
static ValaExpression* vala_genie_parser_parse_argument (ValaGenieParser* self, GError** error);
static GeeList* vala_genie_parser_parse_argument_list (ValaGenieParser* self, GError** error);
GType vala_unary_operator_get_type (void);
ValaUnaryExpression* vala_unary_expression_new (ValaUnaryOperator op, ValaExpression* _inner, ValaSourceReference* source);
ValaUnaryExpression* vala_unary_expression_construct (GType object_type, ValaUnaryOperator op, ValaExpression* _inner, ValaSourceReference* source);
static ValaExpression* vala_genie_parser_parse_assert_expression (ValaGenieParser* self, GError** error);
static ValaInitializerList* vala_genie_parser_parse_initializer (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_tuple (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_this_access (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_base_access (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_print_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_typeof_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_simple_name (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_member_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_method_call (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_element_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error);
static ValaExpression* vala_genie_parser_parse_primary_expression (ValaGenieParser* self, GError** error);
ValaMemberAccess* vala_member_access_new (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
void vala_member_access_add_type_argument (ValaMemberAccess* self, ValaDataType* arg);
ValaTuple* vala_tuple_new (void);
ValaTuple* vala_tuple_construct (GType object_type);
GType vala_tuple_get_type (void);
void vala_tuple_add_expression (ValaTuple* self, ValaExpression* expr);
ValaMemberAccess* vala_member_access_new_pointer (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct_pointer (GType object_type, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
const char* vala_string_literal_get_value (ValaStringLiteral* self);
void vala_string_literal_set_value (ValaStringLiteral* self, const char* value);
GType vala_binary_operator_get_type (void);
ValaBinaryExpression* vala_binary_expression_new (ValaBinaryOperator op, ValaExpression* _left, ValaExpression* _right, ValaSourceReference* source);
ValaBinaryExpression* vala_binary_expression_construct (GType object_type, ValaBinaryOperator op, ValaExpression* _left, ValaExpression* _right, ValaSourceReference* source);
static GeeList* vala_genie_parser_parse_print_argument_list (ValaGenieParser* self, GError** error);
ValaMethodCall* vala_method_call_new (ValaExpression* call, ValaSourceReference* source_reference);
ValaMethodCall* vala_method_call_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference);
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg);
GType vala_member_initializer_get_type (void);
static GeeList* vala_genie_parser_parse_object_initializer (ValaGenieParser* self, GError** error);
void vala_member_access_set_creation_member (ValaMemberAccess* self, gboolean value);
ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference);
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference);
void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value);
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg);
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init);
static GeeList* vala_genie_parser_parse_expression_list (ValaGenieParser* self, GError** error);
ValaElementAccess* vala_element_access_new (ValaExpression* container, ValaSourceReference* source_reference);
ValaElementAccess* vala_element_access_construct (GType object_type, ValaExpression* container, ValaSourceReference* source_reference);
void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index);
ValaBaseAccess* vala_base_access_new (ValaSourceReference* source);
ValaBaseAccess* vala_base_access_construct (GType object_type, ValaSourceReference* source);
ValaPostfixExpression* vala_postfix_expression_new (ValaExpression* _inner, gboolean inc, ValaSourceReference* source);
ValaPostfixExpression* vala_postfix_expression_construct (GType object_type, ValaExpression* _inner, gboolean inc, ValaSourceReference* source);
static ValaMemberAccess* vala_genie_parser_parse_member_name (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error);
static ValaExpression* vala_genie_parser_parse_list_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error);
static ValaExpression* vala_genie_parser_parse_dict_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member_key, ValaMemberAccess* member_value, GError** error);
static ValaExpression* vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error);
ValaUnresolvedType* vala_unresolved_type_new_from_expression (ValaExpression* expr);
ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size);
const char* vala_member_access_get_member_name (ValaMemberAccess* self);
static ValaMemberInitializer* vala_genie_parser_parse_member_initializer (ValaGenieParser* self, GError** error);
ValaMemberInitializer* vala_member_initializer_new (const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaMemberInitializer* vala_member_initializer_construct (GType object_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaSizeofExpression* vala_sizeof_expression_new (ValaDataType* type, ValaSourceReference* source);
ValaSizeofExpression* vala_sizeof_expression_construct (GType object_type, ValaDataType* type, ValaSourceReference* source);
ValaTypeofExpression* vala_typeof_expression_new (ValaDataType* type, ValaSourceReference* source);
ValaTypeofExpression* vala_typeof_expression_construct (GType object_type, ValaDataType* type, ValaSourceReference* source);
static ValaUnaryOperator vala_genie_parser_get_unary_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_unary_expression (ValaGenieParser* self, GError** error);
ValaReferenceTransferExpression* vala_reference_transfer_expression_new (ValaExpression* inner, ValaSourceReference* source_reference);
ValaReferenceTransferExpression* vala_reference_transfer_expression_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference);
ValaCastExpression* vala_cast_expression_new (ValaExpression* inner, ValaDataType* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast);
ValaCastExpression* vala_cast_expression_construct (GType object_type, ValaExpression* inner, ValaDataType* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast);
ValaPointerIndirection* vala_pointer_indirection_new (ValaExpression* inner, ValaSourceReference* source_reference);
ValaPointerIndirection* vala_pointer_indirection_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference);
ValaAddressofExpression* vala_addressof_expression_new (ValaExpression* inner, ValaSourceReference* source_reference);
ValaAddressofExpression* vala_addressof_expression_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference);
static ValaBinaryOperator vala_genie_parser_get_binary_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
static ValaExpression* vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_additive_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_shift_expression (ValaGenieParser* self, GError** error);
ValaTypeCheck* vala_typecheck_new (ValaExpression* expr, ValaDataType* type, ValaSourceReference* source);
ValaTypeCheck* vala_typecheck_construct (GType object_type, ValaExpression* expr, ValaDataType* type, ValaSourceReference* source);
static ValaExpression* vala_genie_parser_parse_relational_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_equality_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_and_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_in_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self, GError** error);
static ValaExpression* vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self, GError** error);
ValaConditionalExpression* vala_conditional_expression_new (ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source);
ValaConditionalExpression* vala_conditional_expression_construct (GType object_type, ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source);
static ValaExpression* vala_genie_parser_parse_conditional_expression (ValaGenieParser* self, GError** error);
static ValaBlock* vala_genie_parser_parse_block (ValaGenieParser* self, GError** error);
ValaLambdaExpression* vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body, ValaSourceReference* source_reference);
ValaLambdaExpression* vala_lambda_expression_construct_with_statement_body (GType object_type, ValaBlock* statement_body, ValaSourceReference* source_reference);
ValaLambdaExpression* vala_lambda_expression_new (ValaExpression* expression_body, ValaSourceReference* source_reference);
ValaLambdaExpression* vala_lambda_expression_construct (GType object_type, ValaExpression* expression_body, ValaSourceReference* source_reference);
void vala_lambda_expression_add_parameter (ValaLambdaExpression* self, const char* param);
static ValaExpression* vala_genie_parser_parse_lambda_expression (ValaGenieParser* self, GError** error);
GType vala_assignment_operator_get_type (void);
static ValaAssignmentOperator vala_genie_parser_get_assignment_operator (ValaGenieParser* self, ValaGenieTokenType token_type);
ValaAssignment* vala_assignment_new (ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference);
ValaAssignment* vala_assignment_construct (GType object_type, ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference);
GType vala_statement_get_type (void);
static ValaStatement* vala_genie_parser_parse_foreach_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_for_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_get_for_statement_type (ValaGenieParser* self, GError** error);
char* vala_genie_scanner_pop_comment (ValaGenieScanner* self);
ValaEmptyStatement* vala_empty_statement_new (ValaSourceReference* source);
ValaEmptyStatement* vala_empty_statement_construct (GType object_type, ValaSourceReference* source);
static ValaStatement* vala_genie_parser_parse_empty_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_expression_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_if_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_switch_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_while_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_do_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_break_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_continue_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_return_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_throw_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_try_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_lock_statement (ValaGenieParser* self, GError** error);
static ValaStatement* vala_genie_parser_parse_delete_statement (ValaGenieParser* self, GError** error);
static void vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self, ValaBlock* block, GError** error);
static ValaStatement* vala_genie_parser_parse_yield_statement (ValaGenieParser* self, GError** error);
static gboolean vala_genie_parser_is_expression (ValaGenieParser* self, GError** error);
void vala_block_add_statement (ValaBlock* self, ValaStatement* stmt);
static ValaGenieParserRecoveryState vala_genie_parser_recover (ValaGenieParser* self);
static void vala_genie_parser_parse_statements (ValaGenieParser* self, ValaBlock* block, GError** error);
ValaBlock* vala_block_new (ValaSourceReference* source_reference);
ValaBlock* vala_block_construct (GType object_type, ValaSourceReference* source_reference);
static ValaStatement* vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self, GError** error);
static ValaBlock* vala_genie_parser_parse_embedded_statement (ValaGenieParser* self, GError** error);
GType vala_report_get_type (void);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
gint vala_report_get_errors (ValaReport* self);
gint vala_source_reference_get_last_line (ValaSourceReference* self);
void vala_source_reference_set_last_line (ValaSourceReference* self, gint value);
gint vala_source_reference_get_last_column (ValaSourceReference* self);
void vala_source_reference_set_last_column (ValaSourceReference* self, gint value);
static ValaLocalVariable* vala_genie_parser_parse_local_variable (ValaGenieParser* self, ValaDataType* variable_type, const char* id, GError** error);
ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference);
ValaDeclarationStatement* vala_declaration_statement_construct (GType object_type, ValaSymbol* declaration, ValaSourceReference* source_reference);
static void vala_genie_parser_add_local_var_variable (ValaGenieParser* self, ValaBlock* block, const char* id, GError** error);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
static ValaExpression* vala_genie_parser_parse_statement_expression (ValaGenieParser* self, GError** error);
ValaExpressionStatement* vala_expression_statement_new (ValaExpression* expression, ValaSourceReference* source_reference);
ValaExpressionStatement* vala_expression_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference);
ValaIfStatement* vala_if_statement_new (ValaExpression* cond, ValaBlock* true_stmt, ValaBlock* false_stmt, ValaSourceReference* source);
ValaIfStatement* vala_if_statement_construct (GType object_type, ValaExpression* cond, ValaBlock* true_stmt, ValaBlock* false_stmt, ValaSourceReference* source);
ValaSwitchStatement* vala_switch_statement_new (ValaExpression* expression, ValaSourceReference* source_reference);
ValaSwitchStatement* vala_switch_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference);
ValaSwitchSection* vala_switch_section_new (ValaSourceReference* source_reference);
ValaSwitchSection* vala_switch_section_construct (GType object_type, ValaSourceReference* source_reference);
void vala_switch_section_add_label (ValaSwitchSection* self, ValaSwitchLabel* label);
ValaSwitchLabel* vala_switch_label_new (ValaExpression* expr, ValaSourceReference* source);
ValaSwitchLabel* vala_switch_label_construct (GType object_type, ValaExpression* expr, ValaSourceReference* source);
ValaSwitchLabel* vala_switch_label_new_with_default (ValaSourceReference* source);
ValaSwitchLabel* vala_switch_label_construct_with_default (GType object_type, ValaSourceReference* source);
ValaBreakStatement* vala_break_statement_new (ValaSourceReference* source);
ValaBreakStatement* vala_break_statement_construct (GType object_type, ValaSourceReference* source);
void vala_switch_statement_add_section (ValaSwitchStatement* self, ValaSwitchSection* section);
ValaWhileStatement* vala_while_statement_new (ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
ValaWhileStatement* vala_while_statement_construct (GType object_type, ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
ValaDoStatement* vala_do_statement_new (ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference);
ValaDoStatement* vala_do_statement_construct (GType object_type, ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference);
ValaForStatement* vala_for_statement_new (ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
ValaForStatement* vala_for_statement_construct (GType object_type, ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
void vala_for_statement_add_initializer (ValaForStatement* self, ValaExpression* init);
void vala_for_statement_add_iterator (ValaForStatement* self, ValaExpression* iter);
ValaForeachStatement* vala_foreach_statement_new (ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference);
ValaForeachStatement* vala_foreach_statement_construct (GType object_type, ValaDataType* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference);
ValaContinueStatement* vala_continue_statement_new (ValaSourceReference* source);
ValaContinueStatement* vala_continue_statement_construct (GType object_type, ValaSourceReference* source);
ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaYieldStatement* vala_yield_statement_new (ValaExpression* yield_expression, ValaSourceReference* source_reference);
ValaYieldStatement* vala_yield_statement_construct (GType object_type, ValaExpression* yield_expression, ValaSourceReference* source_reference);
ValaThrowStatement* vala_throw_statement_new (ValaExpression* error_expression, ValaSourceReference* source_reference);
ValaThrowStatement* vala_throw_statement_construct (GType object_type, ValaExpression* error_expression, ValaSourceReference* source_reference);
static void vala_genie_parser_parse_catch_clauses (ValaGenieParser* self, GeeList* catch_clauses, GError** error);
static ValaBlock* vala_genie_parser_parse_finally_clause (ValaGenieParser* self, GError** error);
ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
ValaTryStatement* vala_try_statement_construct (GType object_type, ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause);
ValaCatchClause* vala_catch_clause_new (ValaDataType* error_type, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaCatchClause* vala_catch_clause_construct (GType object_type, ValaDataType* error_type, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaLockStatement* vala_lock_statement_new (ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference);
ValaLockStatement* vala_lock_statement_construct (GType object_type, ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference);
ValaDeleteStatement* vala_delete_statement_new (ValaExpression* expression, ValaSourceReference* source_reference);
ValaDeleteStatement* vala_delete_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference);
GType vala_attribute_get_type (void);
ValaAttribute* vala_attribute_new (const char* name, ValaSourceReference* source_reference);
ValaAttribute* vala_attribute_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_attribute_add_argument (ValaAttribute* self, const char* key, ValaExpression* value);
static GeeList* vala_genie_parser_parse_attributes (ValaGenieParser* self, GError** error);
GType vala_semantic_analyzer_get_type (void);
static void vala_genie_parser_set_attributes (ValaGenieParser* self, ValaCodeNode* node, GeeList* attributes);
static ValaConstant* vala_genie_parser_parse_constant_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaCreationMethod* vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_class_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaMethod* vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaConstructor* vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaMethod* vala_genie_parser_parse_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_enum_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaDestructor* vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_interface_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaNamespace* vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaProperty* vala_genie_parser_parse_property_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSignal* vala_genie_parser_parse_signal_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_struct_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaField* vala_genie_parser_parse_field_declaration (ValaGenieParser* self, GeeList* attrs, GError** error);
static ValaSymbol* vala_genie_parser_parse_declaration (ValaGenieParser* self, gboolean is_root, GError** error);
static void vala_genie_parser_parse_namespace_member (ValaGenieParser* self, ValaNamespace* ns, GError** error);
static void vala_genie_parser_parse_class_member (ValaGenieParser* self, ValaClass* cl, GError** error);
static void vala_genie_parser_parse_struct_member (ValaGenieParser* self, ValaStruct* st, GError** error);
static void vala_genie_parser_parse_interface_member (ValaGenieParser* self, ValaInterface* iface, GError** error);
const char* vala_symbol_get_name (ValaSymbol* self);
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_get_inner (ValaUnresolvedSymbol* self);
void vala_namespace_add_namespace (ValaNamespace* self, ValaNamespace* ns);
void vala_namespace_add_class (ValaNamespace* self, ValaClass* cl);
void vala_namespace_add_interface (ValaNamespace* self, ValaInterface* iface);
void vala_namespace_add_struct (ValaNamespace* self, ValaStruct* st);
void vala_namespace_add_enum (ValaNamespace* self, ValaEnum* en);
void vala_namespace_add_error_domain (ValaNamespace* self, ValaErrorDomain* edomain);
void vala_namespace_add_delegate (ValaNamespace* self, ValaDelegate* d);
GType member_binding_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
void vala_method_set_binding (ValaMethod* self, MemberBinding value);
void vala_namespace_add_method (ValaNamespace* self, ValaMethod* m);
MemberBinding vala_field_get_binding (ValaField* self);
void vala_field_set_binding (ValaField* self, MemberBinding value);
void vala_namespace_add_field (ValaNamespace* self, ValaField* f);
void vala_namespace_add_constant (ValaNamespace* self, ValaConstant* constant);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
ValaUsingDirective* vala_using_directive_new (ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_construct (GType object_type, ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
static void vala_genie_parser_add_uses_clause (ValaGenieParser* self, GError** error);
static ValaGenieParserModifierFlags vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self);
static GeeList* vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self, GError** error);
ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference);
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
void vala_object_type_symbol_add_type_parameter (ValaObjectTypeSymbol* self, ValaTypeParameter* p);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
gboolean vala_source_file_get_external_package (ValaSourceFile* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
ValaCreationMethod* vala_creation_method_new (const char* class_name, const char* name, ValaSourceReference* source_reference);
ValaCreationMethod* vala_creation_method_construct (GType object_type, const char* class_name, const char* name, ValaSourceReference* source_reference);
void vala_method_set_body (ValaMethod* self, ValaBlock* value);
void vala_class_add_method (ValaClass* self, ValaMethod* m);
void vala_class_add_class (ValaClass* self, ValaClass* cl);
void vala_class_add_struct (ValaClass* self, ValaStruct* st);
void vala_class_add_enum (ValaClass* self, ValaEnum* en);
void vala_class_add_delegate (ValaClass* self, ValaDelegate* d);
void vala_class_add_signal (ValaClass* self, ValaSignal* sig);
void vala_class_add_field (ValaClass* self, ValaField* f);
void vala_class_add_constant (ValaClass* self, ValaConstant* c);
void vala_class_add_property (ValaClass* self, ValaProperty* prop);
MemberBinding vala_constructor_get_binding (ValaConstructor* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
MemberBinding vala_destructor_get_binding (ValaDestructor* self);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
static ValaGenieParserModifierFlags vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaConstant* vala_constant_new (const char* name, ValaDataType* type_reference, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaConstant* vala_constant_construct (GType object_type, const char* name, ValaDataType* type_reference, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
void vala_member_set_hides (ValaMember* self, gboolean value);
ValaField* vala_field_new (const char* name, ValaDataType* field_type, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaField* vala_field_construct (GType object_type, const char* name, ValaDataType* field_type, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_field_set_initializer (ValaField* self, ValaExpression* value);
ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference);
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference);
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr);
ValaMethod* vala_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaMethod* vala_method_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
static ValaFormalParameter* vala_genie_parser_parse_parameter (ValaGenieParser* self, GError** error);
void vala_method_set_coroutine (ValaMethod* self, gboolean value);
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type);
void vala_method_set_is_abstract (ValaMethod* self, gboolean value);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
void vala_method_set_overrides (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_abstract (ValaMethod* self);
gboolean vala_method_get_is_virtual (ValaMethod* self);
gboolean vala_method_get_overrides (ValaMethod* self);
void vala_method_set_is_inline (ValaMethod* self, gboolean value);
void vala_method_add_precondition (ValaMethod* self, ValaExpression* precondition);
void vala_method_add_postcondition (ValaMethod* self, ValaExpression* postcondition);
ValaProperty* vala_property_new (const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference);
ValaProperty* vala_property_construct (GType object_type, const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference);
void vala_property_set_binding (ValaProperty* self, MemberBinding value);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
void vala_property_set_default_expression (ValaProperty* self, ValaExpression* value);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference);
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_accessor_set_access (ValaPropertyAccessor* self, ValaSymbolAccessibility value);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
gboolean vala_property_get_is_abstract (ValaProperty* self);
ValaBlock* vala_property_accessor_get_body (ValaPropertyAccessor* self);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
ValaExpression* vala_property_get_default_expression (ValaProperty* self);
void vala_property_set_field (ValaProperty* self, ValaField* value);
ValaField* vala_property_get_field (ValaProperty* self);
ValaSignal* vala_signal_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaSignal* vala_signal_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_signal_set_is_virtual (ValaSignal* self, gboolean value);
void vala_signal_add_parameter (ValaSignal* self, ValaFormalParameter* param);
ValaConstructor* vala_constructor_new (ValaSourceReference* source);
ValaConstructor* vala_constructor_construct (GType object_type, ValaSourceReference* source);
void vala_constructor_set_binding (ValaConstructor* self, MemberBinding value);
void vala_constructor_set_body (ValaConstructor* self, ValaBlock* value);
ValaDestructor* vala_destructor_new (ValaSourceReference* source_reference);
ValaDestructor* vala_destructor_construct (GType object_type, ValaSourceReference* source_reference);
void vala_destructor_set_body (ValaDestructor* self, ValaBlock* value);
ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference);
ValaStruct* vala_struct_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p);
void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value);
void vala_struct_add_method (ValaStruct* self, ValaMethod* m);
void vala_struct_add_field (ValaStruct* self, ValaField* f);
void vala_struct_add_constant (ValaStruct* self, ValaConstant* c);
ValaInterface* vala_interface_new (const char* name, ValaSourceReference* source_reference);
ValaInterface* vala_interface_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_interface_add_prerequisite (ValaInterface* self, ValaDataType* type);
void vala_interface_add_class (ValaInterface* self, ValaClass* cl);
void vala_interface_add_struct (ValaInterface* self, ValaStruct* st);
void vala_interface_add_enum (ValaInterface* self, ValaEnum* en);
void vala_interface_add_delegate (ValaInterface* self, ValaDelegate* d);
void vala_interface_add_method (ValaInterface* self, ValaMethod* m);
void vala_interface_add_signal (ValaInterface* self, ValaSignal* sig);
void vala_interface_add_field (ValaInterface* self, ValaField* f);
void vala_interface_add_property (ValaInterface* self, ValaProperty* prop);
ValaEnum* vala_enum_new (const char* name, ValaSourceReference* source_reference);
ValaEnum* vala_enum_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaEnumValue* vala_enum_value_new (const char* name, ValaSourceReference* source_reference);
ValaEnumValue* vala_enum_value_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_enum_value_set_value (ValaEnumValue* self, ValaExpression* value);
void vala_enum_add_value (ValaEnum* self, ValaEnumValue* value);
ValaErrorDomain* vala_error_domain_new (const char* name, ValaSourceReference* source_reference);
ValaErrorDomain* vala_error_domain_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaErrorCode* vala_error_code_new (const char* name, ValaSourceReference* source_reference);
ValaErrorCode* vala_error_code_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_error_code_set_value (ValaErrorCode* self, ValaExpression* value);
void vala_error_domain_add_code (ValaErrorDomain* self, ValaErrorCode* ecode);
ValaFormalParameter* vala_formal_parameter_new_with_ellipsis (ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference);
GType vala_parameter_direction_get_type (void);
void vala_formal_parameter_set_direction (ValaFormalParameter* self, ValaParameterDirection value);
void vala_formal_parameter_set_params_array (ValaFormalParameter* self, gboolean value);
void vala_formal_parameter_set_default_expression (ValaFormalParameter* self, ValaExpression* value);
ValaDelegate* vala_delegate_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDelegate* vala_delegate_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param);
ValaTypeParameter* vala_typeparameter_new (const char* name, ValaSourceReference* source_reference);
ValaTypeParameter* vala_typeparameter_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
static gpointer vala_genie_parser_parent_class = NULL;
static void vala_genie_parser_finalize (ValaCodeVisitor* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




static GType vala_genie_parser_modifier_flags_get_type (void) {
	static GType vala_genie_parser_modifier_flags_type_id = 0;
	if (G_UNLIKELY (vala_genie_parser_modifier_flags_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_NONE", "none"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT, "VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT", "abstract"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS, "VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS", "class"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN, "VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN", "extern"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE", "inline"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW, "VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW", "new"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE", "override"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC, "VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC", "static"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL, "VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL", "virtual"}, {VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE, "VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE", "private"}, {0, NULL, NULL}};
		vala_genie_parser_modifier_flags_type_id = g_enum_register_static ("ValaGenieParserModifierFlags", values);
	}
	return vala_genie_parser_modifier_flags_type_id;
}



static GType vala_genie_parser_recovery_state_get_type (void) {
	static GType vala_genie_parser_recovery_state_type_id = 0;
	if (G_UNLIKELY (vala_genie_parser_recovery_state_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_GENIE_PARSER_RECOVERY_STATE_EOF, "VALA_GENIE_PARSER_RECOVERY_STATE_EOF", "eof"}, {VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN", "declaration-begin"}, {VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN, "VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN", "statement-begin"}, {0, NULL, NULL}};
		vala_genie_parser_recovery_state_type_id = g_enum_register_static ("ValaGenieParserRecoveryState", values);
	}
	return vala_genie_parser_recovery_state_type_id;
}


ValaGenieParser* vala_genie_parser_construct (GType object_type) {
	ValaGenieParser* self;
	ValaGenieParserTokenInfo* _tmp0_;
	char* _tmp1_;
	self = (ValaGenieParser*) g_type_create_instance (object_type);
	_tmp0_ = NULL;
	self->priv->tokens = (_tmp0_ = g_new0 (ValaGenieParserTokenInfo, VALA_GENIE_PARSER_BUFFER_SIZE), self->priv->tokens = (g_free (self->priv->tokens), NULL), self->priv->tokens_length1 = VALA_GENIE_PARSER_BUFFER_SIZE, self->priv->tokens_size = self->priv->tokens_length1, _tmp0_);
	_tmp1_ = NULL;
	self->priv->class_name = (_tmp1_ = NULL, self->priv->class_name = (g_free (self->priv->class_name), NULL), _tmp1_);
	self->priv->current_expr_is_lambda = FALSE;
	return self;
}


ValaGenieParser* vala_genie_parser_new (void) {
	return vala_genie_parser_construct (VALA_GENIE_TYPE_PARSER);
}


/**
 * Parses all .gs source files in the specified code context and
 * builds a code tree.
 *
 * @param context a code context
 */
void vala_genie_parser_parse (ValaGenieParser* self, ValaCodeContext* context) {
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->context = (_tmp1_ = (_tmp0_ = context, (_tmp0_ == NULL) ? NULL : vala_code_context_ref (_tmp0_)), (self->priv->context == NULL) ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL)), _tmp1_);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
}


static void vala_genie_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGenieParser * self;
	self = (ValaGenieParser*) base;
	g_return_if_fail (source_file != NULL);
	if (g_str_has_suffix (vala_source_file_get_filename (source_file), ".gs")) {
		vala_genie_parser_parse_file (self, source_file);
	}
}


static inline gboolean vala_genie_parser_next (ValaGenieParser* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->index = (self->priv->index + 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		ValaSourceLocation begin = {0};
		ValaSourceLocation end = {0};
		ValaGenieTokenType type;
		type = vala_genie_scanner_read_token (self->priv->scanner, &begin, &end);
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	return self->priv->tokens[self->priv->index].type != VALA_GENIE_TOKEN_TYPE_EOF;
}


static inline void vala_genie_parser_prev (ValaGenieParser* self) {
	g_return_if_fail (self != NULL);
	self->priv->index = ((self->priv->index - 1) + VALA_GENIE_PARSER_BUFFER_SIZE) % VALA_GENIE_PARSER_BUFFER_SIZE;
	self->priv->size++;
	g_assert (self->priv->size <= VALA_GENIE_PARSER_BUFFER_SIZE);
}


static inline ValaGenieTokenType vala_genie_parser_current (ValaGenieParser* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->tokens[self->priv->index].type;
}


static inline gboolean vala_genie_parser_accept (ValaGenieParser* self, ValaGenieTokenType type) {
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_genie_parser_current (self) == type) {
		vala_genie_parser_next (self);
		return TRUE;
	}
	return FALSE;
}


static inline gboolean vala_genie_parser_accept_terminator (ValaGenieParser* self) {
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = FALSE;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp0_) {
		vala_genie_parser_next (self);
		return TRUE;
	}
	return FALSE;
}


static inline gboolean vala_genie_parser_accept_block (ValaGenieParser* self) {
	gboolean has_term;
	g_return_val_if_fail (self != NULL, FALSE);
	has_term = vala_genie_parser_accept_terminator (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		vala_genie_parser_prev (self);
		return TRUE;
	}
	if (has_term) {
		vala_genie_parser_prev (self);
	}
	return FALSE;
}


static char* vala_genie_parser_get_error (ValaGenieParser* self, const char* msg) {
	ValaSourceLocation begin;
	char* _tmp1_;
	ValaSourceReference* _tmp0_;
	const char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_next (self);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_report_error (_tmp0_ = vala_genie_parser_get_src (self, &begin), _tmp1_ = g_strconcat ("syntax error, ", msg, NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
	_tmp2_ = NULL;
	return (_tmp2_ = msg, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
}


static inline gboolean vala_genie_parser_expect (ValaGenieParser* self, ValaGenieTokenType type, GError** error) {
	GError * _inner_error_;
	ValaGenieTokenType cur;
	ValaGenieTokenType pre;
	char* _tmp2_;
	char* _tmp1_;
	GError* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	if (vala_genie_parser_accept (self, type)) {
		return TRUE;
	}
	cur = vala_genie_parser_current (self);
	pre = self->priv->tokens[self->priv->index - 1].type;
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp3_ = NULL;
	_inner_error_ = (_tmp3_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp2_ = vala_genie_parser_get_error (self, _tmp1_ = g_strdup_printf ("expected %s but got %s with previous %s", vala_genie_token_type_to_string (type), vala_genie_token_type_to_string (cur), vala_genie_token_type_to_string (pre)))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
}


static inline gboolean vala_genie_parser_expect_terminator (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaGenieTokenType cur;
	char* _tmp2_;
	char* _tmp1_;
	GError* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	if (vala_genie_parser_accept_terminator (self)) {
		return TRUE;
	}
	cur = vala_genie_parser_current (self);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp3_ = NULL;
	_inner_error_ = (_tmp3_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp2_ = vala_genie_parser_get_error (self, _tmp1_ = g_strdup_printf ("expected line end or semicolon but got %s", vala_genie_token_type_to_string (cur)))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
}


static inline ValaSourceLocation vala_genie_parser_get_location (ValaGenieParser* self) {
	return self->priv->tokens[self->priv->index].begin;
}


static char* vala_genie_parser_get_current_string (ValaGenieParser* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_strndup ((const char*) self->priv->tokens[self->priv->index].begin.pos, self->priv->tokens[self->priv->index].end.pos - self->priv->tokens[self->priv->index].begin.pos);
}


static char* vala_genie_parser_get_last_string (ValaGenieParser* self) {
	gint last_index;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE) - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	return g_strndup ((const char*) self->priv->tokens[last_index].begin.pos, self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos);
}


static ValaSourceReference* vala_genie_parser_get_src (ValaGenieParser* self, const ValaSourceLocation* begin) {
	gint last_index;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE) - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	return vala_source_reference_new (vala_genie_scanner_get_source_file (self->priv->scanner), (*begin).line, (*begin).column, self->priv->tokens[last_index].end.line, self->priv->tokens[last_index].end.column);
}


static ValaSourceReference* vala_genie_parser_get_src_com (ValaGenieParser* self, const ValaSourceLocation* begin) {
	gint last_index;
	ValaSourceReference* src;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + VALA_GENIE_PARSER_BUFFER_SIZE) - 1) % VALA_GENIE_PARSER_BUFFER_SIZE;
	src = vala_source_reference_new_with_comment (vala_genie_scanner_get_source_file (self->priv->scanner), (*begin).line, (*begin).column, self->priv->tokens[last_index].end.line, self->priv->tokens[last_index].end.column, self->priv->comment);
	_tmp0_ = NULL;
	self->priv->comment = (_tmp0_ = NULL, self->priv->comment = (g_free (self->priv->comment), NULL), _tmp0_);
	return src;
}


static ValaSourceReference* vala_genie_parser_get_current_src (ValaGenieParser* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return vala_source_reference_new (vala_genie_scanner_get_source_file (self->priv->scanner), self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, self->priv->tokens[self->priv->index].end.line, self->priv->tokens[self->priv->index].end.column);
}


static void vala_genie_parser_rollback (ValaGenieParser* self, const ValaSourceLocation* location) {
	g_return_if_fail (self != NULL);
	while (self->priv->tokens[self->priv->index].begin.pos != (*location).pos) {
		vala_genie_parser_prev (self);
	}
}


static inline ValaSymbolAccessibility vala_genie_parser_get_access (ValaGenieParser* self, const char* s) {
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (s, 0)) == '_') {
		return VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	return VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
}


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


static gboolean string_contains (const char* self, const char* needle) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	return strstr (self, needle) != NULL;
}


static void vala_genie_parser_skip_identifier (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	char* _tmp1_;
	GError* _tmp2_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	/* also accept keywords as identifiers where there is no conflict*/
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
		case VALA_GENIE_TOKEN_TYPE_AS:
		case VALA_GENIE_TOKEN_TYPE_ASSERT:
		case VALA_GENIE_TOKEN_TYPE_BREAK:
		case VALA_GENIE_TOKEN_TYPE_CLASS:
		case VALA_GENIE_TOKEN_TYPE_CONST:
		case VALA_GENIE_TOKEN_TYPE_CONTINUE:
		case VALA_GENIE_TOKEN_TYPE_DEDENT:
		case VALA_GENIE_TOKEN_TYPE_DEF:
		case VALA_GENIE_TOKEN_TYPE_DEFAULT:
		case VALA_GENIE_TOKEN_TYPE_DELEGATE:
		case VALA_GENIE_TOKEN_TYPE_DELETE:
		case VALA_GENIE_TOKEN_TYPE_DO:
		case VALA_GENIE_TOKEN_TYPE_DOWNTO:
		case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
		case VALA_GENIE_TOKEN_TYPE_ELSE:
		case VALA_GENIE_TOKEN_TYPE_EOL:
		case VALA_GENIE_TOKEN_TYPE_ENUM:
		case VALA_GENIE_TOKEN_TYPE_ENSURES:
		case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
		case VALA_GENIE_TOKEN_TYPE_EVENT:
		case VALA_GENIE_TOKEN_TYPE_EXCEPT:
		case VALA_GENIE_TOKEN_TYPE_EXTERN:
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		case VALA_GENIE_TOKEN_TYPE_FINAL:
		case VALA_GENIE_TOKEN_TYPE_FINALLY:
		case VALA_GENIE_TOKEN_TYPE_FOR:
		case VALA_GENIE_TOKEN_TYPE_GET:
		case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
		case VALA_GENIE_TOKEN_TYPE_IF:
		case VALA_GENIE_TOKEN_TYPE_IN:
		case VALA_GENIE_TOKEN_TYPE_INDENT:
		case VALA_GENIE_TOKEN_TYPE_INIT:
		case VALA_GENIE_TOKEN_TYPE_INLINE:
		case VALA_GENIE_TOKEN_TYPE_INTERFACE:
		case VALA_GENIE_TOKEN_TYPE_INTERNAL:
		case VALA_GENIE_TOKEN_TYPE_IS:
		case VALA_GENIE_TOKEN_TYPE_ISA:
		case VALA_GENIE_TOKEN_TYPE_LOCK:
		case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
		case VALA_GENIE_TOKEN_TYPE_NEW:
		case VALA_GENIE_TOKEN_TYPE_NULL:
		case VALA_GENIE_TOKEN_TYPE_OF:
		case VALA_GENIE_TOKEN_TYPE_OUT:
		case VALA_GENIE_TOKEN_TYPE_OVERRIDE:
		case VALA_GENIE_TOKEN_TYPE_OWNED:
		case VALA_GENIE_TOKEN_TYPE_PASS:
		case VALA_GENIE_TOKEN_TYPE_PRINT:
		case VALA_GENIE_TOKEN_TYPE_PRIVATE:
		case VALA_GENIE_TOKEN_TYPE_PROP:
		case VALA_GENIE_TOKEN_TYPE_RAISE:
		case VALA_GENIE_TOKEN_TYPE_RAISES:
		case VALA_GENIE_TOKEN_TYPE_REF:
		case VALA_GENIE_TOKEN_TYPE_REQUIRES:
		case VALA_GENIE_TOKEN_TYPE_RETURN:
		case VALA_GENIE_TOKEN_TYPE_SET:
		case VALA_GENIE_TOKEN_TYPE_SIZEOF:
		case VALA_GENIE_TOKEN_TYPE_STATIC:
		case VALA_GENIE_TOKEN_TYPE_STRUCT:
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		case VALA_GENIE_TOKEN_TYPE_THIS:
		case VALA_GENIE_TOKEN_TYPE_TO:
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		case VALA_GENIE_TOKEN_TYPE_TRY:
		case VALA_GENIE_TOKEN_TYPE_TYPEOF:
		case VALA_GENIE_TOKEN_TYPE_UNOWNED:
		case VALA_GENIE_TOKEN_TYPE_USES:
		case VALA_GENIE_TOKEN_TYPE_VAR:
		case VALA_GENIE_TOKEN_TYPE_VIRTUAL:
		case VALA_GENIE_TOKEN_TYPE_VOID:
		case VALA_GENIE_TOKEN_TYPE_VOLATILE:
		case VALA_GENIE_TOKEN_TYPE_WEAK:
		case VALA_GENIE_TOKEN_TYPE_WHEN:
		case VALA_GENIE_TOKEN_TYPE_WHILE:
		case VALA_GENIE_TOKEN_TYPE_YIELD:
		case VALA_GENIE_TOKEN_TYPE_YIELDS:
		{
			vala_genie_parser_next (self);
			return;
		}
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		{
			char* id;
			gboolean _tmp0_;
			id = vala_genie_parser_get_current_string (self);
			_tmp0_ = FALSE;
			if (g_unichar_isalpha (g_utf8_get_char (g_utf8_offset_to_pointer (id, string_get_length (id) - 1)))) {
				_tmp0_ = !string_contains (id, ".");
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				vala_genie_parser_next (self);
				id = (g_free (id), NULL);
				return;
			}
			id = (g_free (id), NULL);
			break;
		}
	}
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	_inner_error_ = (_tmp2_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp1_ = vala_genie_parser_get_error (self, "expected identifier")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static char* vala_genie_parser_parse_identifier (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_skip_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return vala_genie_parser_get_last_string (self);
}


static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


static ValaExpression* vala_genie_parser_parse_literal (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp0_;
			ValaExpression* _tmp1_;
			vala_genie_parser_next (self);
			_tmp0_ = NULL;
			_tmp1_ = NULL;
			return (_tmp1_ = (ValaExpression*) vala_boolean_literal_new (TRUE, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
		}
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp3_;
			ValaExpression* _tmp4_;
			vala_genie_parser_next (self);
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			return (_tmp4_ = (ValaExpression*) vala_boolean_literal_new (FALSE, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
		}
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		{
			ValaSourceReference* _tmp7_;
			char* _tmp6_;
			ValaExpression* _tmp8_;
			vala_genie_parser_next (self);
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp8_ = NULL;
			return (_tmp8_ = (ValaExpression*) vala_integer_literal_new (_tmp6_ = vala_genie_parser_get_last_string (self), _tmp7_ = vala_genie_parser_get_src (self, &begin)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_source_reference_unref (_tmp7_), NULL)), _tmp6_ = (g_free (_tmp6_), NULL), _tmp8_);
		}
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		{
			ValaSourceReference* _tmp11_;
			char* _tmp10_;
			ValaExpression* _tmp12_;
			vala_genie_parser_next (self);
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			_tmp12_ = NULL;
			return (_tmp12_ = (ValaExpression*) vala_real_literal_new (_tmp10_ = vala_genie_parser_get_last_string (self), _tmp11_ = vala_genie_parser_get_src (self, &begin)), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_source_reference_unref (_tmp11_), NULL)), _tmp10_ = (g_free (_tmp10_), NULL), _tmp12_);
		}
		case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
		{
			ValaSourceReference* _tmp15_;
			char* _tmp14_;
			ValaCharacterLiteral* _tmp16_;
			ValaCharacterLiteral* lit;
			vala_genie_parser_next (self);
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			_tmp16_ = NULL;
			lit = (_tmp16_ = vala_character_literal_new (_tmp14_ = vala_genie_parser_get_last_string (self), _tmp15_ = vala_genie_parser_get_src (self, &begin)), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_source_reference_unref (_tmp15_), NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp16_);
			if (vala_code_node_get_error ((ValaCodeNode*) lit)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) lit), "invalid character literal");
			}
			return (ValaExpression*) lit;
		}
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		{
			ValaSourceReference* _tmp19_;
			char* _tmp18_;
			ValaExpression* _tmp20_;
			vala_genie_parser_next (self);
			_tmp19_ = NULL;
			_tmp18_ = NULL;
			_tmp20_ = NULL;
			return (_tmp20_ = (ValaExpression*) vala_string_literal_new (_tmp18_ = vala_genie_parser_get_last_string (self), _tmp19_ = vala_genie_parser_get_src (self, &begin)), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_source_reference_unref (_tmp19_), NULL)), _tmp18_ = (g_free (_tmp18_), NULL), _tmp20_);
		}
		case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		{
			char* raw_string;
			char* _tmp22_;
			char* _tmp23_;
			char* escaped_string;
			ValaSourceReference* _tmp25_;
			char* _tmp24_;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			vala_genie_parser_next (self);
			raw_string = vala_genie_parser_get_last_string (self);
			_tmp22_ = NULL;
			_tmp23_ = NULL;
			escaped_string = (_tmp23_ = g_strescape (_tmp22_ = string_substring (raw_string, (glong) 3, g_utf8_strlen (raw_string, -1) - 6), ""), _tmp22_ = (g_free (_tmp22_), NULL), _tmp23_);
			_tmp25_ = NULL;
			_tmp24_ = NULL;
			_tmp26_ = NULL;
			_tmp27_ = NULL;
			return (_tmp27_ = (_tmp26_ = (ValaExpression*) vala_string_literal_new (_tmp24_ = g_strdup_printf ("\"%s\"", escaped_string), _tmp25_ = vala_genie_parser_get_src (self, &begin)), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_source_reference_unref (_tmp25_), NULL)), _tmp24_ = (g_free (_tmp24_), NULL), _tmp26_), raw_string = (g_free (raw_string), NULL), escaped_string = (g_free (escaped_string), NULL), _tmp27_);
		}
		case VALA_GENIE_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp28_;
			ValaExpression* _tmp29_;
			vala_genie_parser_next (self);
			_tmp28_ = NULL;
			_tmp29_ = NULL;
			return (_tmp29_ = (ValaExpression*) vala_null_literal_new (_tmp28_ = vala_genie_parser_get_src (self, &begin)), (_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_source_reference_unref (_tmp28_), NULL)), _tmp29_);
		}
		default:
		{
			char* _tmp31_;
			GError* _tmp32_;
			_tmp31_ = NULL;
			_tmp32_ = NULL;
			_inner_error_ = (_tmp32_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp31_ = vala_genie_parser_get_error (self, "expected literal")), _tmp31_ = (g_free (_tmp31_), NULL), _tmp32_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
}


void vala_genie_parser_parse_file (ValaGenieParser* self, ValaSourceFile* source_file) {
	GError * _inner_error_;
	ValaGenieScanner* _tmp0_;
	ValaGenieScanner* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_inner_error_ = NULL;
	_tmp0_ = NULL;
	self->priv->scanner = (_tmp0_ = vala_genie_scanner_new (source_file), (self->priv->scanner == NULL) ? NULL : (self->priv->scanner = (vala_genie_scanner_unref (self->priv->scanner), NULL)), _tmp0_);
	vala_genie_scanner_set_indent_spaces (self->priv->scanner, 0);
	self->priv->index = -1;
	self->priv->size = 0;
	vala_genie_parser_next (self);
	{
		ValaSourceLocation begin;
		begin = vala_genie_parser_get_location (self);
		/* see if there is an indent attribute */
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			char* id;
			id = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					goto __catch0_vala_parse_error;
				}
				goto __finally0;
			}
			if (_vala_strcmp0 (id, "indent") == 0) {
				char* _tmp1_;
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error_);
				if (_inner_error_ != NULL) {
					id = (g_free (id), NULL);
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					goto __finally0;
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL, &_inner_error_);
				if (_inner_error_ != NULL) {
					id = (g_free (id), NULL);
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					goto __finally0;
				}
				_tmp1_ = NULL;
				vala_genie_scanner_set_indent_spaces (self->priv->scanner, atoi (_tmp1_ = vala_genie_parser_get_last_string (self)));
				_tmp1_ = (g_free (_tmp1_), NULL);
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
				if (_inner_error_ != NULL) {
					id = (g_free (id), NULL);
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					goto __finally0;
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
				if (_inner_error_ != NULL) {
					id = (g_free (id), NULL);
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						goto __catch0_vala_parse_error;
					}
					goto __finally0;
				}
			} else {
				vala_genie_parser_rollback (self, &begin);
			}
			id = (g_free (id), NULL);
		}
		vala_genie_parser_parse_using_directives (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				goto __catch0_vala_parse_error;
			}
			goto __finally0;
		}
		vala_genie_parser_parse_declarations (self, (ValaSymbol*) vala_code_context_get_root (self->priv->context), TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				goto __catch0_vala_parse_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_vala_parse_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	/* already reported*/
	_tmp2_ = NULL;
	self->priv->scanner = (_tmp2_ = NULL, (self->priv->scanner == NULL) ? NULL : (self->priv->scanner = (vala_genie_scanner_unref (self->priv->scanner), NULL)), _tmp2_);
}


static void vala_genie_parser_skip_symbol_name (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	do {
		vala_genie_parser_skip_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
}


static ValaUnresolvedSymbol* vala_genie_parser_parse_symbol_name (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	sym = NULL;
	do {
		char* name;
		ValaUnresolvedSymbol* _tmp1_;
		ValaSourceReference* _tmp0_;
		name = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		sym = (_tmp1_ = vala_unresolved_symbol_new (sym, name, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		name = (g_free (name), NULL);
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
	return sym;
}


static void vala_genie_parser_skip_type (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID)) {
		while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
		}
		return;
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_UNOWNED);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT);
	}
	if (_tmp0_) {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF);
	}
	vala_genie_parser_skip_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	vala_genie_parser_skip_type_argument_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
		do {
			gboolean _tmp2_;
			_tmp2_ = FALSE;
			if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA) {
				_tmp2_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				ValaExpression* _tmp3_;
				_tmp3_ = NULL;
				_tmp3_ = vala_genie_parser_parse_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL));
			}
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_NEG);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_HASH);
}


static ValaDataType* vala_genie_parser_parse_type (ValaGenieParser* self, gboolean owned_by_default, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	GeeList* type_arg_list;
	ValaUnresolvedSymbol* sym;
	gboolean is_dynamic;
	gboolean value_owned;
	gboolean is_array;
	gboolean is_list;
	gboolean is_dict;
	GeeList* _tmp13_;
	GeeList* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* type;
	ValaDataType* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VOID)) {
		ValaDataType* type;
		type = (ValaDataType*) vala_void_type_new (NULL);
		while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
			ValaDataType* _tmp0_;
			_tmp0_ = NULL;
			type = (_tmp0_ = (ValaDataType*) vala_pointer_type_new (type, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0_);
		}
		return type;
	}
	type_arg_list = NULL;
	sym = NULL;
	is_dynamic = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DYNAMIC);
	value_owned = owned_by_default;
	if (owned_by_default) {
		gboolean _tmp2_;
		_tmp2_ = FALSE;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_UNOWNED)) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WEAK);
		}
		if (_tmp2_) {
			value_owned = FALSE;
		}
	} else {
		value_owned = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED);
	}
	/* handle arrays */
	is_array = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return NULL;
			} else {
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		is_array = TRUE;
	}
	/* handle lists */
	is_list = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return NULL;
			} else {
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_genie_parser_prev (self);
		is_list = TRUE;
	}
	/* handle dicts */
	is_dict = FALSE;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return NULL;
			} else {
				(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_genie_parser_prev (self);
		is_dict = TRUE;
	}
	if (is_list) {
		ValaSourceReference* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* sym_parent;
		ValaUnresolvedSymbol* _tmp6_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		sym_parent = (_tmp4_ = vala_unresolved_symbol_new (NULL, "Gee", _tmp3_ = vala_genie_parser_get_src (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		sym = (_tmp6_ = vala_unresolved_symbol_new (sym_parent, "ArrayList", _tmp5_ = vala_genie_parser_get_src (self, &begin)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp6_);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_source_reference_unref (_tmp5_), NULL));
		(sym_parent == NULL) ? NULL : (sym_parent = (vala_code_node_unref (sym_parent), NULL));
	} else {
		if (is_dict) {
			ValaSourceReference* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			ValaUnresolvedSymbol* sym_parent;
			ValaUnresolvedSymbol* _tmp10_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = NULL;
			_tmp8_ = NULL;
			sym_parent = (_tmp8_ = vala_unresolved_symbol_new (NULL, "Gee", _tmp7_ = vala_genie_parser_get_src (self, &begin)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_source_reference_unref (_tmp7_), NULL)), _tmp8_);
			_tmp10_ = NULL;
			_tmp9_ = NULL;
			sym = (_tmp10_ = vala_unresolved_symbol_new (sym_parent, "HashMap", _tmp9_ = vala_genie_parser_get_src (self, &begin)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp10_);
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_source_reference_unref (_tmp9_), NULL));
			(sym_parent == NULL) ? NULL : (sym_parent = (vala_code_node_unref (sym_parent), NULL));
		} else {
			ValaUnresolvedSymbol* _tmp11_;
			ValaUnresolvedSymbol* _tmp12_;
			_tmp11_ = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					return NULL;
				} else {
					(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = NULL;
			sym = (_tmp12_ = _tmp11_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp12_);
		}
	}
	_tmp13_ = vala_genie_parser_parse_type_argument_list (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return NULL;
		} else {
			(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = NULL;
	type_arg_list = (_tmp14_ = _tmp13_, (type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL)), _tmp14_);
	_tmp15_ = NULL;
	_tmp16_ = NULL;
	type = (_tmp16_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, _tmp15_ = vala_genie_parser_get_src (self, &begin)), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_source_reference_unref (_tmp15_), NULL)), _tmp16_);
	if (type_arg_list != NULL) {
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_arg_list);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_data_type_add_type_argument (type, type_arg);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_STAR)) {
		ValaDataType* _tmp18_;
		ValaSourceReference* _tmp17_;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		type = (_tmp18_ = (ValaDataType*) vala_pointer_type_new (type, _tmp17_ = vala_genie_parser_get_src (self, &begin)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp18_);
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_source_reference_unref (_tmp17_), NULL));
	}
	if (!VALA_IS_POINTER_TYPE (type)) {
		vala_data_type_set_nullable (type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
	}
	if (is_array) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
			ValaDataType* _tmp20_;
			ValaSourceReference* _tmp19_;
			vala_data_type_set_value_owned (type, TRUE);
			_tmp20_ = NULL;
			_tmp19_ = NULL;
			type = (_tmp20_ = (ValaDataType*) vala_array_type_new (type, 1, _tmp19_ = vala_genie_parser_get_src (self, &begin)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp20_);
			(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_source_reference_unref (_tmp19_), NULL));
			vala_data_type_set_nullable (type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
		} else {
			vala_genie_parser_prev (self);
			while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
				gint array_length;
				gint array_rank;
				ValaSourceReference* _tmp24_;
				ValaArrayType* _tmp25_;
				ValaArrayType* array_type;
				gboolean _tmp26_;
				ValaDataType* _tmp28_;
				ValaDataType* _tmp27_;
				array_length = -1;
				array_rank = 0;
				do {
					gboolean _tmp21_;
					array_rank++;
					_tmp21_ = FALSE;
					if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA) {
						_tmp21_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
					} else {
						_tmp21_ = FALSE;
					}
					/* support for stack-allocated arrays
					 also required for decision between expression and declaration statement*/
					if (_tmp21_) {
						ValaExpression* length_expression;
						ValaIntegerLiteral* _tmp23_;
						ValaExpression* _tmp22_;
						ValaIntegerLiteral* length_literal;
						length_expression = vala_genie_parser_parse_expression (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
								(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
								(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
								return NULL;
							} else {
								(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
								(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
								(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp23_ = NULL;
						_tmp22_ = NULL;
						length_literal = (_tmp23_ = (_tmp22_ = length_expression, VALA_IS_INTEGER_LITERAL (_tmp22_) ? ((ValaIntegerLiteral*) _tmp22_) : NULL), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
						if (length_literal != NULL) {
							array_length = atoi (vala_integer_literal_get_value (length_literal));
						}
						(length_expression == NULL) ? NULL : (length_expression = (vala_code_node_unref (length_expression), NULL));
						(length_literal == NULL) ? NULL : (length_literal = (vala_code_node_unref (length_literal), NULL));
					}
				} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
						(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						return NULL;
					} else {
						(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
						(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				vala_data_type_set_value_owned (type, TRUE);
				_tmp24_ = NULL;
				_tmp25_ = NULL;
				array_type = (_tmp25_ = vala_array_type_new (type, array_rank, _tmp24_ = vala_genie_parser_get_src (self, &begin)), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_source_reference_unref (_tmp24_), NULL)), _tmp25_);
				vala_data_type_set_nullable ((ValaDataType*) array_type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR));
				_tmp26_ = FALSE;
				if (array_rank == 1) {
					_tmp26_ = array_length > 0;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					/* fixed length (stack-allocated) array*/
					vala_array_type_set_fixed_length (array_type, TRUE);
					vala_array_type_set_length (array_type, array_length);
				}
				_tmp28_ = NULL;
				_tmp27_ = NULL;
				type = (_tmp28_ = (_tmp27_ = (ValaDataType*) array_type, (_tmp27_ == NULL) ? NULL : vala_code_node_ref (_tmp27_)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp28_);
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
		}
	}
	if (!owned_by_default) {
		value_owned = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_HASH);
	}
	vala_data_type_set_is_dynamic (type, is_dynamic);
	vala_data_type_set_value_owned (type, value_owned);
	_tmp29_ = NULL;
	return (_tmp29_ = type, (type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp29_);
}


static GeeList* vala_genie_parser_parse_argument_list (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* list;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* _tmp0_;
			ValaExpression* _tmp1_;
			_tmp0_ = vala_genie_parser_parse_argument (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					return NULL;
				} else {
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			gee_collection_add ((GeeCollection*) list, _tmp1_ = _tmp0_);
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return (GeeList*) list;
}


static ValaExpression* vala_genie_parser_parse_argument (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
		ValaExpression* inner;
		ValaSourceReference* _tmp0_;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		inner = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		return (_tmp2_ = (_tmp1_ = (ValaExpression*) vala_unary_expression_new (VALA_UNARY_OPERATOR_REF, inner, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (inner == NULL) ? NULL : (inner = (vala_code_node_unref (inner), NULL)), _tmp2_);
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
			ValaExpression* inner;
			ValaSourceReference* _tmp3_;
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			inner = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			_tmp5_ = NULL;
			return (_tmp5_ = (_tmp4_ = (ValaExpression*) vala_unary_expression_new (VALA_UNARY_OPERATOR_OUT, inner, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_), (inner == NULL) ? NULL : (inner = (vala_code_node_unref (inner), NULL)), _tmp5_);
		} else {
			ValaExpression* _tmp6_;
			_tmp6_ = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp6_;
		}
	}
}


static ValaExpression* vala_genie_parser_parse_primary_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = NULL;
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_TRUE:
		case VALA_GENIE_TOKEN_TYPE_FALSE:
		case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
		case VALA_GENIE_TOKEN_TYPE_NULL:
		{
			ValaExpression* _tmp0_;
			ValaExpression* _tmp1_;
			_tmp0_ = vala_genie_parser_parse_literal (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			expr = (_tmp1_ = _tmp0_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp1_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSERT:
		{
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = vala_genie_parser_parse_assert_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp3_ = NULL;
			return (_tmp3_ = _tmp2_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp3_);
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
		{
			ValaInitializerList* _tmp4_;
			ValaExpression* _tmp5_;
			_tmp4_ = vala_genie_parser_parse_initializer (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp5_ = NULL;
			expr = (_tmp5_ = (ValaExpression*) _tmp4_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp5_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_genie_parser_parse_tuple (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp7_ = NULL;
			expr = (_tmp7_ = _tmp6_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp7_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_THIS:
		{
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_genie_parser_parse_this_access (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = NULL;
			expr = (_tmp9_ = _tmp8_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp9_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_SUPER:
		{
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			_tmp10_ = vala_genie_parser_parse_base_access (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp11_ = NULL;
			expr = (_tmp11_ = _tmp10_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp11_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_NEW:
		{
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			_tmp12_ = vala_genie_parser_parse_object_or_array_creation_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp13_ = NULL;
			expr = (_tmp13_ = _tmp12_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp13_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_PRINT:
		{
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			_tmp14_ = vala_genie_parser_parse_print_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp15_ = NULL;
			return (_tmp15_ = _tmp14_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp15_);
		}
		case VALA_GENIE_TOKEN_TYPE_SIZEOF:
		{
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_genie_parser_parse_sizeof_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp17_ = NULL;
			expr = (_tmp17_ = _tmp16_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp17_);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_TYPEOF:
		{
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			_tmp18_ = vala_genie_parser_parse_typeof_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp19_ = NULL;
			expr = (_tmp19_ = _tmp18_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp19_);
			break;
		}
		default:
		{
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			_tmp20_ = vala_genie_parser_parse_simple_name (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp21_ = NULL;
			expr = (_tmp21_ = _tmp20_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp21_);
			break;
		}
	}
	/* process primary expressions that start with an inner primary expression*/
	found = TRUE;
	while (found) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_DOT:
			{
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp22_ = vala_genie_parser_parse_member_access (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp23_ = NULL;
				expr = (_tmp23_ = _tmp22_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp23_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_PTR:
			{
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				_tmp24_ = vala_genie_parser_parse_pointer_member_access (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp25_ = NULL;
				expr = (_tmp25_ = _tmp24_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp25_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
			{
				ValaExpression* _tmp26_;
				ValaExpression* _tmp27_;
				_tmp26_ = vala_genie_parser_parse_method_call (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp27_ = NULL;
				expr = (_tmp27_ = _tmp26_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp27_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET:
			{
				ValaExpression* _tmp28_;
				ValaExpression* _tmp29_;
				_tmp28_ = vala_genie_parser_parse_element_access (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp29_ = NULL;
				expr = (_tmp29_ = _tmp28_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp29_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_INC:
			{
				ValaExpression* _tmp30_;
				ValaExpression* _tmp31_;
				_tmp30_ = vala_genie_parser_parse_post_increment_expression (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp31_ = NULL;
				expr = (_tmp31_ = _tmp30_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp31_);
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_DEC:
			{
				ValaExpression* _tmp32_;
				ValaExpression* _tmp33_;
				_tmp32_ = vala_genie_parser_parse_post_decrement_expression (self, &begin, expr, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						return NULL;
					} else {
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp33_ = NULL;
				expr = (_tmp33_ = _tmp32_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp33_);
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	return expr;
}


static ValaExpression* vala_genie_parser_parse_simple_name (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_member_access_new (NULL, id, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if (type_arg_list != NULL) {
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_arg_list);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_member_access_add_type_argument (expr, type_arg);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
	}
	_tmp2_ = NULL;
	return (_tmp2_ = (ValaExpression*) expr, id = (g_free (id), NULL), (type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL)), _tmp2_);
}


static ValaExpression* vala_genie_parser_parse_tuple (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* expr_list;
	ValaExpression* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr_list = gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* _tmp0_;
			ValaExpression* _tmp1_;
			_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL));
					return NULL;
				} else {
					(expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			gee_collection_add ((GeeCollection*) expr_list, _tmp1_ = _tmp0_);
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL));
			return NULL;
		} else {
			(expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (gee_collection_get_size ((GeeCollection*) expr_list) != 1) {
		ValaTuple* tuple;
		ValaExpression* _tmp2_;
		tuple = vala_tuple_new ();
		{
			GeeIterator* _expr_it;
			_expr_it = gee_iterable_iterator ((GeeIterable*) expr_list);
			while (gee_iterator_next (_expr_it)) {
				ValaExpression* expr;
				expr = (ValaExpression*) gee_iterator_get (_expr_it);
				vala_tuple_add_expression (tuple, expr);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		_tmp2_ = NULL;
		return (_tmp2_ = (ValaExpression*) tuple, (expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL)), _tmp2_);
	}
	_tmp3_ = NULL;
	return (_tmp3_ = (ValaExpression*) gee_list_get ((GeeList*) expr_list, 0), (expr_list == NULL) ? NULL : (expr_list = (gee_collection_object_unref (expr_list), NULL)), _tmp3_);
}


static ValaExpression* vala_genie_parser_parse_member_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_member_access_new (inner, id, _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if (type_arg_list != NULL) {
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_arg_list);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_member_access_add_type_argument (expr, type_arg);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
	}
	_tmp2_ = NULL;
	return (_tmp2_ = (ValaExpression*) expr, id = (g_free (id), NULL), (type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL)), _tmp2_);
}


static ValaExpression* vala_genie_parser_parse_pointer_member_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	char* id;
	GeeList* type_arg_list;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* expr;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_PTR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_arg_list = vala_genie_parser_parse_type_argument_list (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_member_access_new_pointer (inner, id, _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if (type_arg_list != NULL) {
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_arg_list);
			while (gee_iterator_next (_type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_member_access_add_type_argument (expr, type_arg);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
	}
	_tmp2_ = NULL;
	return (_tmp2_ = (ValaExpression*) expr, id = (g_free (id), NULL), (type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL)), _tmp2_);
}


static GeeList* vala_genie_parser_parse_print_argument_list (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* list;
	gint i;
	ValaSourceLocation begin;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	i = 0;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaExpression* p_expr;
			p_expr = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					return NULL;
				} else {
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (i == 0) {
				i++;
				if (p_expr != NULL) {
					if (VALA_IS_STRING_LITERAL (p_expr)) {
						ValaStringLiteral* _tmp0_;
						ValaStringLiteral* s_exp;
						glong len;
						_tmp0_ = NULL;
						s_exp = (_tmp0_ = VALA_STRING_LITERAL (p_expr), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
						len = strlen (vala_string_literal_get_value (s_exp));
						if (len > 2) {
							char* s;
							char* st;
							char* _tmp1_;
							s = g_strdup ("\\n\"");
							st = g_strndup (vala_string_literal_get_value (s_exp), (gsize) (len - 1));
							_tmp1_ = NULL;
							st = (_tmp1_ = g_strconcat (st, s, NULL), st = (g_free (st), NULL), _tmp1_);
							vala_string_literal_set_value (s_exp, st);
							s = (g_free (s), NULL);
							st = (g_free (st), NULL);
						}
						(s_exp == NULL) ? NULL : (s_exp = (vala_code_node_unref (s_exp), NULL));
					} else {
						char* s;
						ValaSourceReference* _tmp2_;
						ValaStringLiteral* _tmp3_;
						ValaStringLiteral* rhs;
						ValaExpression* _tmp5_;
						ValaSourceReference* _tmp4_;
						s = g_strdup ("\"\\n\"");
						_tmp2_ = NULL;
						_tmp3_ = NULL;
						rhs = (_tmp3_ = vala_string_literal_new (s, _tmp2_ = vala_genie_parser_get_src (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
						_tmp5_ = NULL;
						_tmp4_ = NULL;
						p_expr = (_tmp5_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, p_expr, (ValaExpression*) rhs, _tmp4_ = vala_genie_parser_get_src (self, &begin)), (p_expr == NULL) ? NULL : (p_expr = (vala_code_node_unref (p_expr), NULL)), _tmp5_);
						(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
						s = (g_free (s), NULL);
						(rhs == NULL) ? NULL : (rhs = (vala_code_node_unref (rhs), NULL));
					}
				}
			}
			gee_collection_add ((GeeCollection*) list, p_expr);
			(p_expr == NULL) ? NULL : (p_expr = (vala_code_node_unref (p_expr), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return (GeeList*) list;
}


static ValaExpression* vala_genie_parser_parse_print_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* expr;
	GeeList* arg_list;
	ValaSourceReference* _tmp2_;
	ValaMethodCall* _tmp3_;
	ValaMethodCall* print_expr;
	ValaExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PRINT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_member_access_new (NULL, "print", _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	arg_list = vala_genie_parser_parse_print_argument_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	print_expr = (_tmp3_ = vala_method_call_new ((ValaExpression*) expr, _tmp2_ = vala_genie_parser_get_src (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) arg_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_method_call_add_argument (print_expr, arg);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	_tmp4_ = NULL;
	return (_tmp4_ = (ValaExpression*) print_expr, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), _tmp4_);
}


static ValaExpression* vala_genie_parser_parse_assert_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* expr;
	GeeList* arg_list;
	ValaSourceReference* _tmp2_;
	ValaMethodCall* _tmp3_;
	ValaMethodCall* assert_expr;
	ValaExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSERT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_member_access_new (NULL, "assert", _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	arg_list = vala_genie_parser_parse_argument_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	assert_expr = (_tmp3_ = vala_method_call_new ((ValaExpression*) expr, _tmp2_ = vala_genie_parser_get_src (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) arg_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_method_call_add_argument (assert_expr, arg);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	_tmp4_ = NULL;
	return (_tmp4_ = (ValaExpression*) assert_expr, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), _tmp4_);
}


static ValaExpression* vala_genie_parser_parse_method_call (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	GeeList* arg_list;
	GeeList* init_list;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	arg_list = vala_genie_parser_parse_argument_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			return NULL;
		} else {
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	init_list = vala_genie_parser_parse_object_initializer (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			return NULL;
		} else {
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = FALSE;
	if (gee_collection_get_size ((GeeCollection*) init_list) > 0) {
		_tmp0_ = VALA_IS_MEMBER_ACCESS (inner);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaMemberAccess* _tmp1_;
		ValaMemberAccess* member;
		ValaSourceReference* _tmp2_;
		ValaObjectCreationExpression* _tmp3_;
		ValaObjectCreationExpression* expr;
		ValaExpression* _tmp4_;
		/* struct creation expression*/
		_tmp1_ = NULL;
		member = (_tmp1_ = VALA_MEMBER_ACCESS (inner), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		vala_member_access_set_creation_member (member, TRUE);
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		expr = (_tmp3_ = vala_object_creation_expression_new (member, _tmp2_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
		vala_object_creation_expression_set_struct_creation (expr, TRUE);
		{
			GeeIterator* _arg_it;
			_arg_it = gee_iterable_iterator ((GeeIterable*) arg_list);
			while (gee_iterator_next (_arg_it)) {
				ValaExpression* arg;
				arg = (ValaExpression*) gee_iterator_get (_arg_it);
				vala_object_creation_expression_add_argument (expr, arg);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
		}
		{
			GeeIterator* _initializer_it;
			_initializer_it = gee_iterable_iterator ((GeeIterable*) init_list);
			while (gee_iterator_next (_initializer_it)) {
				ValaMemberInitializer* initializer;
				initializer = (ValaMemberInitializer*) gee_iterator_get (_initializer_it);
				vala_object_creation_expression_add_member_initializer (expr, initializer);
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			}
			(_initializer_it == NULL) ? NULL : (_initializer_it = (gee_collection_object_unref (_initializer_it), NULL));
		}
		_tmp4_ = NULL;
		return (_tmp4_ = (ValaExpression*) expr, (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), (init_list == NULL) ? NULL : (init_list = (gee_collection_object_unref (init_list), NULL)), _tmp4_);
	} else {
		ValaSourceReference* _tmp5_;
		ValaMethodCall* _tmp6_;
		ValaMethodCall* expr;
		ValaExpression* _tmp7_;
		_tmp5_ = NULL;
		_tmp6_ = NULL;
		expr = (_tmp6_ = vala_method_call_new (inner, _tmp5_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_source_reference_unref (_tmp5_), NULL)), _tmp6_);
		{
			GeeIterator* _arg_it;
			_arg_it = gee_iterable_iterator ((GeeIterable*) arg_list);
			while (gee_iterator_next (_arg_it)) {
				ValaExpression* arg;
				arg = (ValaExpression*) gee_iterator_get (_arg_it);
				vala_method_call_add_argument (expr, arg);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
		}
		_tmp7_ = NULL;
		return (_tmp7_ = (ValaExpression*) expr, (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), (init_list == NULL) ? NULL : (init_list = (gee_collection_object_unref (init_list), NULL)), _tmp7_);
	}
	(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
	(init_list == NULL) ? NULL : (init_list = (gee_collection_object_unref (init_list), NULL));
}


static ValaExpression* vala_genie_parser_parse_element_access (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	GeeList* index_list;
	ValaSourceReference* _tmp0_;
	ValaElementAccess* _tmp1_;
	ValaElementAccess* expr;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	index_list = vala_genie_parser_parse_expression_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(index_list == NULL) ? NULL : (index_list = (gee_collection_object_unref (index_list), NULL));
			return NULL;
		} else {
			(index_list == NULL) ? NULL : (index_list = (gee_collection_object_unref (index_list), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_element_access_new (inner, _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	{
		GeeIterator* _index_it;
		_index_it = gee_iterable_iterator ((GeeIterable*) index_list);
		while (gee_iterator_next (_index_it)) {
			ValaExpression* index;
			index = (ValaExpression*) gee_iterator_get (_index_it);
			vala_element_access_append_index (expr, index);
			(index == NULL) ? NULL : (index = (vala_code_node_unref (index), NULL));
		}
		(_index_it == NULL) ? NULL : (_index_it = (gee_collection_object_unref (_index_it), NULL));
	}
	_tmp2_ = NULL;
	return (_tmp2_ = (ValaExpression*) expr, (index_list == NULL) ? NULL : (index_list = (gee_collection_object_unref (index_list), NULL)), _tmp2_);
}


static GeeList* vala_genie_parser_parse_expression_list (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* list;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	list = gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	do {
		ValaExpression* _tmp0_;
		ValaExpression* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
				return NULL;
			} else {
				(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		gee_collection_add ((GeeCollection*) list, _tmp1_ = _tmp0_);
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	return (GeeList*) list;
}


static ValaExpression* vala_genie_parser_parse_this_access (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_THIS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaExpression*) vala_member_access_new (NULL, "this", _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaExpression* vala_genie_parser_parse_base_access (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SUPER, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaExpression*) vala_base_access_new (_tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaExpression* vala_genie_parser_parse_post_increment_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_INC, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaExpression*) vala_postfix_expression_new (inner, TRUE, _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaExpression* vala_genie_parser_parse_post_decrement_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaExpression* inner, GError** error) {
	GError * _inner_error_;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OP_DEC, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaExpression*) vala_postfix_expression_new (inner, FALSE, _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaExpression* vala_genie_parser_parse_object_or_array_creation_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaMemberAccess* member;
	ValaExpression* expr;
	ValaExpression* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NEW, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ARRAY)) {
		ValaMemberAccess* m;
		ValaExpression* expr;
		ValaExpression* _tmp0_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		m = vala_genie_parser_parse_member_name (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		expr = vala_genie_parser_parse_array_creation_expression (self, &begin, m, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				return NULL;
			} else {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp0_ = NULL;
		return (_tmp0_ = expr, (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp0_);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_LIST)) {
		ValaMemberAccess* m;
		ValaExpression* expr;
		ValaExpression* _tmp1_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		m = vala_genie_parser_parse_member_name (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		expr = vala_genie_parser_parse_list_creation_expression (self, &begin, m, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				return NULL;
			} else {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		return (_tmp1_ = expr, (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp1_);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DICT)) {
		ValaMemberAccess* m1;
		ValaMemberAccess* m2;
		ValaExpression* expr;
		ValaExpression* _tmp2_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		m1 = vala_genie_parser_parse_member_name (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				return NULL;
			} else {
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		m2 = vala_genie_parser_parse_member_name (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				return NULL;
			} else {
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		expr = vala_genie_parser_parse_dict_creation_expression (self, &begin, m1, m2, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				(m2 == NULL) ? NULL : (m2 = (vala_code_node_unref (m2), NULL));
				return NULL;
			} else {
				(m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL));
				(m2 == NULL) ? NULL : (m2 = (vala_code_node_unref (m2), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = NULL;
		return (_tmp2_ = expr, (m1 == NULL) ? NULL : (m1 = (vala_code_node_unref (m1), NULL)), (m2 == NULL) ? NULL : (m2 = (vala_code_node_unref (m2), NULL)), _tmp2_);
	}
	member = vala_genie_parser_parse_member_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = vala_genie_parser_parse_object_creation_expression (self, &begin, member, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
			return NULL;
		} else {
			(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	return (_tmp3_ = expr, (member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL)), _tmp3_);
}


static ValaExpression* vala_genie_parser_parse_object_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error) {
	GError * _inner_error_;
	GeeList* arg_list;
	GeeList* init_list;
	ValaSourceReference* _tmp3_;
	ValaObjectCreationExpression* _tmp4_;
	ValaObjectCreationExpression* expr;
	ValaExpression* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	_inner_error_ = NULL;
	vala_member_access_set_creation_member (member, TRUE);
	arg_list = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_argument_list (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
				return NULL;
			} else {
				(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		arg_list = (_tmp1_ = _tmp0_, (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), _tmp1_);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
				return NULL;
			} else {
				(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		GeeList* _tmp2_;
		_tmp2_ = NULL;
		arg_list = (_tmp2_ = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), _tmp2_);
	}
	init_list = vala_genie_parser_parse_object_initializer (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			return NULL;
		} else {
			(arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	expr = (_tmp4_ = vala_object_creation_expression_new (member, _tmp3_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) arg_list);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_object_creation_expression_add_argument (expr, arg);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	{
		GeeIterator* _initializer_it;
		_initializer_it = gee_iterable_iterator ((GeeIterable*) init_list);
		while (gee_iterator_next (_initializer_it)) {
			ValaMemberInitializer* initializer;
			initializer = (ValaMemberInitializer*) gee_iterator_get (_initializer_it);
			vala_object_creation_expression_add_member_initializer (expr, initializer);
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
		}
		(_initializer_it == NULL) ? NULL : (_initializer_it = (gee_collection_object_unref (_initializer_it), NULL));
	}
	_tmp5_ = NULL;
	return (_tmp5_ = (ValaExpression*) expr, (arg_list == NULL) ? NULL : (arg_list = (gee_collection_object_unref (arg_list), NULL)), (init_list == NULL) ? NULL : (init_list = (gee_collection_object_unref (init_list), NULL)), _tmp5_);
}


static ValaExpression* vala_genie_parser_parse_array_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error) {
	GError * _inner_error_;
	gboolean size_specified;
	GeeList* size_specifier_list;
	gboolean first;
	ValaDataType* element_type;
	gboolean has_bracket;
	ValaInitializerList* initializer;
	ValaSourceReference* _tmp8_;
	ValaArrayCreationExpression* _tmp9_;
	ValaArrayCreationExpression* expr;
	ValaExpression* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	_inner_error_ = NULL;
	size_specified = FALSE;
	size_specifier_list = NULL;
	first = TRUE;
	element_type = (ValaDataType*) vala_unresolved_type_new_from_expression ((ValaExpression*) member);
	has_bracket = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET);
	do {
		GeeList* _tmp1_;
		if (!first) {
			ValaDataType* _tmp0_;
			/* array of arrays: new T[][42]*/
			_tmp0_ = NULL;
			element_type = (_tmp0_ = (ValaDataType*) vala_array_type_new (element_type, gee_collection_get_size ((GeeCollection*) size_specifier_list), vala_code_node_get_source_reference ((ValaCodeNode*) element_type)), (element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)), _tmp0_);
		} else {
			first = FALSE;
		}
		_tmp1_ = NULL;
		size_specifier_list = (_tmp1_ = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL)), _tmp1_);
		do {
			ValaExpression* size;
			gboolean _tmp2_;
			gboolean _tmp3_;
			size = NULL;
			_tmp2_ = FALSE;
			_tmp3_ = FALSE;
			if (has_bracket) {
				_tmp3_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				_tmp2_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_COMMA;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				ValaExpression* _tmp4_;
				ValaExpression* _tmp5_;
				_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
						(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
						(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
						return NULL;
					} else {
						(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
						(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
						(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp5_ = NULL;
				size = (_tmp5_ = _tmp4_, (size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL)), _tmp5_);
				size_specified = TRUE;
			}
			gee_collection_add ((GeeCollection*) size_specifier_list, size);
			(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		if (has_bracket) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
					(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
					return NULL;
				} else {
					(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
					(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET));
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaInitializerList* _tmp6_;
		ValaInitializerList* _tmp7_;
		_tmp6_ = vala_genie_parser_parse_initializer (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
				(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				return NULL;
			} else {
				(size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL));
				(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = NULL;
		initializer = (_tmp7_ = _tmp6_, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp7_);
	}
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	expr = (_tmp9_ = vala_array_creation_expression_new (element_type, gee_collection_get_size ((GeeCollection*) size_specifier_list), initializer, _tmp8_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_source_reference_unref (_tmp8_), NULL)), _tmp9_);
	if (size_specified) {
		{
			GeeIterator* _size_it;
			_size_it = gee_iterable_iterator ((GeeIterable*) size_specifier_list);
			while (gee_iterator_next (_size_it)) {
				ValaExpression* size;
				size = (ValaExpression*) gee_iterator_get (_size_it);
				vala_array_creation_expression_append_size (expr, size);
				(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
			}
			(_size_it == NULL) ? NULL : (_size_it = (gee_collection_object_unref (_size_it), NULL));
		}
	}
	_tmp10_ = NULL;
	return (_tmp10_ = (ValaExpression*) expr, (size_specifier_list == NULL) ? NULL : (size_specifier_list = (gee_collection_object_unref (size_specifier_list), NULL)), (element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)), (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp10_);
}


static ValaExpression* vala_genie_parser_parse_list_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member, GError** error) {
	ValaDataType* element_type;
	ValaMemberAccess* list_member;
	ValaMemberAccess* parent_member;
	ValaMemberAccess* _tmp1_;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp3_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp4_;
	ValaObjectCreationExpression* _tmp5_;
	ValaObjectCreationExpression* expr;
	ValaExpression* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	element_type = (ValaDataType*) vala_unresolved_type_new_from_expression ((ValaExpression*) member);
	list_member = NULL;
	parent_member = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	parent_member = (_tmp1_ = vala_member_access_new (NULL, "Gee", _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp1_);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	list_member = (_tmp3_ = vala_member_access_new ((ValaExpression*) parent_member, "ArrayList", _tmp2_ = vala_genie_parser_get_src (self, &(*begin))), (list_member == NULL) ? NULL : (list_member = (vala_code_node_unref (list_member), NULL)), _tmp3_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL));
	vala_member_access_add_type_argument (list_member, element_type);
	vala_member_access_set_creation_member (list_member, TRUE);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	expr = (_tmp5_ = vala_object_creation_expression_new (list_member, _tmp4_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL)), _tmp5_);
	if (_vala_strcmp0 (vala_member_access_get_member_name (member), "string") == 0) {
		ValaMemberAccess* _tmp7_;
		ValaSourceReference* _tmp6_;
		ValaMemberAccess* _tmp9_;
		ValaSourceReference* _tmp8_;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		parent_member = (_tmp7_ = vala_member_access_new (NULL, "GLib", _tmp6_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp7_);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		vala_object_creation_expression_add_argument (expr, (ValaExpression*) (_tmp9_ = vala_member_access_new ((ValaExpression*) parent_member, "str_equal", _tmp8_ = vala_genie_parser_get_src (self, &(*begin)))));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_code_node_unref (_tmp9_), NULL));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_source_reference_unref (_tmp8_), NULL));
	} else {
		if (_vala_strcmp0 (vala_member_access_get_member_name (member), "int") == 0) {
			ValaMemberAccess* _tmp11_;
			ValaSourceReference* _tmp10_;
			ValaMemberAccess* _tmp13_;
			ValaSourceReference* _tmp12_;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			parent_member = (_tmp11_ = vala_member_access_new (NULL, "GLib", _tmp10_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp11_);
			(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_source_reference_unref (_tmp10_), NULL));
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			vala_object_creation_expression_add_argument (expr, (ValaExpression*) (_tmp13_ = vala_member_access_new ((ValaExpression*) parent_member, "int_equal", _tmp12_ = vala_genie_parser_get_src (self, &(*begin)))));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_code_node_unref (_tmp13_), NULL));
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_source_reference_unref (_tmp12_), NULL));
		}
	}
	_tmp14_ = NULL;
	return (_tmp14_ = (ValaExpression*) expr, (element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)), (list_member == NULL) ? NULL : (list_member = (vala_code_node_unref (list_member), NULL)), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp14_);
}


static ValaExpression* vala_genie_parser_parse_dict_creation_expression (ValaGenieParser* self, const ValaSourceLocation* begin, ValaMemberAccess* member_key, ValaMemberAccess* member_value, GError** error) {
	ValaDataType* key_type;
	ValaDataType* value_type;
	ValaMemberAccess* dict_member;
	ValaMemberAccess* parent_member;
	ValaMemberAccess* dict_hash;
	ValaMemberAccess* dict_equal;
	ValaMemberAccess* _tmp1_;
	ValaSourceReference* _tmp0_;
	ValaMemberAccess* _tmp3_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp16_;
	ValaObjectCreationExpression* _tmp17_;
	ValaObjectCreationExpression* expr;
	gboolean _tmp18_;
	ValaExpression* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member_key != NULL, NULL);
	g_return_val_if_fail (member_value != NULL, NULL);
	key_type = (ValaDataType*) vala_unresolved_type_new_from_expression ((ValaExpression*) member_key);
	value_type = (ValaDataType*) vala_unresolved_type_new_from_expression ((ValaExpression*) member_value);
	dict_member = NULL;
	parent_member = NULL;
	dict_hash = NULL;
	dict_equal = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	parent_member = (_tmp1_ = vala_member_access_new (NULL, "Gee", _tmp0_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp1_);
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	dict_member = (_tmp3_ = vala_member_access_new ((ValaExpression*) parent_member, "HashMap", _tmp2_ = vala_genie_parser_get_src (self, &(*begin))), (dict_member == NULL) ? NULL : (dict_member = (vala_code_node_unref (dict_member), NULL)), _tmp3_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL));
	vala_member_access_add_type_argument (dict_member, key_type);
	vala_member_access_add_type_argument (dict_member, value_type);
	if (_vala_strcmp0 (vala_member_access_get_member_name (member_key), "string") == 0) {
		ValaMemberAccess* _tmp5_;
		ValaSourceReference* _tmp4_;
		ValaMemberAccess* _tmp7_;
		ValaSourceReference* _tmp6_;
		ValaMemberAccess* _tmp9_;
		ValaSourceReference* _tmp8_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		parent_member = (_tmp5_ = vala_member_access_new (NULL, "GLib", _tmp4_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp5_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		dict_hash = (_tmp7_ = vala_member_access_new ((ValaExpression*) parent_member, "str_hash", _tmp6_ = vala_genie_parser_get_src (self, &(*begin))), (dict_hash == NULL) ? NULL : (dict_hash = (vala_code_node_unref (dict_hash), NULL)), _tmp7_);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		dict_equal = (_tmp9_ = vala_member_access_new ((ValaExpression*) parent_member, "str_equal", _tmp8_ = vala_genie_parser_get_src (self, &(*begin))), (dict_equal == NULL) ? NULL : (dict_equal = (vala_code_node_unref (dict_equal), NULL)), _tmp9_);
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_source_reference_unref (_tmp8_), NULL));
	} else {
		if (_vala_strcmp0 (vala_member_access_get_member_name (member_key), "int") == 0) {
			ValaMemberAccess* _tmp11_;
			ValaSourceReference* _tmp10_;
			ValaMemberAccess* _tmp13_;
			ValaSourceReference* _tmp12_;
			ValaMemberAccess* _tmp15_;
			ValaSourceReference* _tmp14_;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			parent_member = (_tmp11_ = vala_member_access_new (NULL, "GLib", _tmp10_ = vala_genie_parser_get_src (self, &(*begin))), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), _tmp11_);
			(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_source_reference_unref (_tmp10_), NULL));
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			dict_hash = (_tmp13_ = vala_member_access_new ((ValaExpression*) parent_member, "int_hash", _tmp12_ = vala_genie_parser_get_src (self, &(*begin))), (dict_hash == NULL) ? NULL : (dict_hash = (vala_code_node_unref (dict_hash), NULL)), _tmp13_);
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_source_reference_unref (_tmp12_), NULL));
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			dict_equal = (_tmp15_ = vala_member_access_new ((ValaExpression*) parent_member, "int_equal", _tmp14_ = vala_genie_parser_get_src (self, &(*begin))), (dict_equal == NULL) ? NULL : (dict_equal = (vala_code_node_unref (dict_equal), NULL)), _tmp15_);
			(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_source_reference_unref (_tmp14_), NULL));
		}
	}
	vala_member_access_set_creation_member (dict_member, TRUE);
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	expr = (_tmp17_ = vala_object_creation_expression_new (dict_member, _tmp16_ = vala_genie_parser_get_src (self, &(*begin))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_source_reference_unref (_tmp16_), NULL)), _tmp17_);
	_tmp18_ = FALSE;
	if (dict_hash != NULL) {
		_tmp18_ = dict_equal != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		vala_object_creation_expression_add_argument (expr, (ValaExpression*) dict_hash);
		vala_object_creation_expression_add_argument (expr, (ValaExpression*) dict_equal);
	}
	_tmp19_ = NULL;
	return (_tmp19_ = (ValaExpression*) expr, (key_type == NULL) ? NULL : (key_type = (vala_code_node_unref (key_type), NULL)), (value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)), (dict_member == NULL) ? NULL : (dict_member = (vala_code_node_unref (dict_member), NULL)), (parent_member == NULL) ? NULL : (parent_member = (vala_code_node_unref (parent_member), NULL)), (dict_hash == NULL) ? NULL : (dict_hash = (vala_code_node_unref (dict_hash), NULL)), (dict_equal == NULL) ? NULL : (dict_equal = (vala_code_node_unref (dict_equal), NULL)), _tmp19_);
}


static GeeList* vala_genie_parser_parse_object_initializer (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* list;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	list = gee_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE)) {
		do {
			ValaMemberInitializer* _tmp0_;
			ValaMemberInitializer* _tmp1_;
			_tmp0_ = vala_genie_parser_parse_member_initializer (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					return NULL;
				} else {
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			gee_collection_add ((GeeCollection*) list, _tmp1_ = _tmp0_);
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
				return NULL;
			} else {
				(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	return (GeeList*) list;
}


static ValaMemberInitializer* vala_genie_parser_parse_member_initializer (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	char* id;
	ValaExpression* expr;
	ValaSourceReference* _tmp0_;
	ValaMemberInitializer* _tmp1_;
	ValaMemberInitializer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = vala_member_initializer_new (id, expr, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), id = (g_free (id), NULL), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
}


static ValaExpression* vala_genie_parser_parse_sizeof_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_SIZEOF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaExpression*) vala_sizeof_expression_new (type, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2_);
}


static ValaExpression* vala_genie_parser_parse_typeof_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TYPEOF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaExpression*) vala_typeof_expression_new (type, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2_);
}


static ValaUnaryOperator vala_genie_parser_get_unary_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_PLUS:
		{
			return VALA_UNARY_OPERATOR_PLUS;
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			return VALA_UNARY_OPERATOR_MINUS;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NEG:
		{
			return VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		}
		case VALA_GENIE_TOKEN_TYPE_TILDE:
		{
			return VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		{
			return VALA_UNARY_OPERATOR_INCREMENT;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		{
			return VALA_UNARY_OPERATOR_DECREMENT;
		}
		default:
		{
			return VALA_UNARY_OPERATOR_NONE;
		}
	}
}


static ValaExpression* vala_genie_parser_parse_unary_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaUnaryOperator operator;
	ValaExpression* expr;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	operator = vala_genie_parser_get_unary_operator (self, vala_genie_parser_current (self));
	if (operator != VALA_UNARY_OPERATOR_NONE) {
		ValaExpression* op;
		ValaSourceReference* _tmp0_;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		vala_genie_parser_next (self);
		op = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		return (_tmp2_ = (_tmp1_ = (ValaExpression*) vala_unary_expression_new (operator, op, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (op == NULL) ? NULL : (op = (vala_code_node_unref (op), NULL)), _tmp2_);
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_HASH:
		{
			ValaExpression* op;
			ValaSourceReference* _tmp3_;
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			vala_genie_parser_next (self);
			op = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			_tmp5_ = NULL;
			return (_tmp5_ = (_tmp4_ = (ValaExpression*) vala_reference_transfer_expression_new (op, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_), (op == NULL) ? NULL : (op = (vala_code_node_unref (op), NULL)), _tmp5_);
		}
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		{
			vala_genie_parser_next (self);
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_OWNED:
				{
					vala_genie_parser_next (self);
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
						ValaExpression* op;
						ValaSourceReference* _tmp6_;
						ValaExpression* _tmp7_;
						ValaExpression* _tmp8_;
						op = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								return NULL;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp6_ = NULL;
						_tmp7_ = NULL;
						_tmp8_ = NULL;
						return (_tmp8_ = (_tmp7_ = (ValaExpression*) vala_reference_transfer_expression_new (op, _tmp6_ = vala_genie_parser_get_src (self, &begin)), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL)), _tmp7_), (op == NULL) ? NULL : (op = (vala_code_node_unref (op), NULL)), _tmp8_);
					}
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_VOID:
				case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
				case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
				{
					ValaDataType* type;
					type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return NULL;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
						/* check follower to decide whether to create cast expression*/
						switch (vala_genie_parser_current (self)) {
							case VALA_GENIE_TOKEN_TYPE_OP_NEG:
							case VALA_GENIE_TOKEN_TYPE_TILDE:
							case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
							case VALA_GENIE_TOKEN_TYPE_TRUE:
							case VALA_GENIE_TOKEN_TYPE_FALSE:
							case VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_REAL_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_STRING_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL:
							case VALA_GENIE_TOKEN_TYPE_NULL:
							case VALA_GENIE_TOKEN_TYPE_THIS:
							case VALA_GENIE_TOKEN_TYPE_SUPER:
							case VALA_GENIE_TOKEN_TYPE_NEW:
							case VALA_GENIE_TOKEN_TYPE_SIZEOF:
							case VALA_GENIE_TOKEN_TYPE_TYPEOF:
							case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
							case VALA_GENIE_TOKEN_TYPE_PARAMS:
							{
								ValaExpression* inner;
								ValaSourceReference* _tmp9_;
								ValaExpression* _tmp10_;
								ValaExpression* _tmp11_;
								inner = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == VALA_PARSE_ERROR) {
										g_propagate_error (error, _inner_error_);
										(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
										return NULL;
									} else {
										(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
										g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp9_ = NULL;
								_tmp10_ = NULL;
								_tmp11_ = NULL;
								return (_tmp11_ = (_tmp10_ = (ValaExpression*) vala_cast_expression_new (inner, type, _tmp9_ = vala_genie_parser_get_src (self, &begin), FALSE), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_source_reference_unref (_tmp9_), NULL)), _tmp10_), (inner == NULL) ? NULL : (inner = (vala_code_node_unref (inner), NULL)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp11_);
							}
							default:
							{
								break;
							}
						}
					}
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					break;
				}
				default:
				{
					break;
				}
			}
			vala_genie_parser_rollback (self, &begin);
			break;
		}
		case VALA_GENIE_TOKEN_TYPE_STAR:
		{
			ValaExpression* op;
			ValaSourceReference* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			vala_genie_parser_next (self);
			op = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = NULL;
			_tmp13_ = NULL;
			_tmp14_ = NULL;
			return (_tmp14_ = (_tmp13_ = (ValaExpression*) vala_pointer_indirection_new (op, _tmp12_ = vala_genie_parser_get_src (self, &begin)), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_source_reference_unref (_tmp12_), NULL)), _tmp13_), (op == NULL) ? NULL : (op = (vala_code_node_unref (op), NULL)), _tmp14_);
		}
		case VALA_GENIE_TOKEN_TYPE_BITWISE_AND:
		{
			ValaExpression* op;
			ValaSourceReference* _tmp15_;
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			vala_genie_parser_next (self);
			op = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp15_ = NULL;
			_tmp16_ = NULL;
			_tmp17_ = NULL;
			return (_tmp17_ = (_tmp16_ = (ValaExpression*) vala_addressof_expression_new (op, _tmp15_ = vala_genie_parser_get_src (self, &begin)), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_source_reference_unref (_tmp15_), NULL)), _tmp16_), (op == NULL) ? NULL : (op = (vala_code_node_unref (op), NULL)), _tmp17_);
		}
		default:
		{
			break;
		}
	}
	expr = vala_genie_parser_parse_primary_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return expr;
}


static ValaBinaryOperator vala_genie_parser_get_binary_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_STAR:
		{
			return VALA_BINARY_OPERATOR_MUL;
		}
		case VALA_GENIE_TOKEN_TYPE_DIV:
		{
			return VALA_BINARY_OPERATOR_DIV;
		}
		case VALA_GENIE_TOKEN_TYPE_PERCENT:
		{
			return VALA_BINARY_OPERATOR_MOD;
		}
		case VALA_GENIE_TOKEN_TYPE_PLUS:
		{
			return VALA_BINARY_OPERATOR_PLUS;
		}
		case VALA_GENIE_TOKEN_TYPE_MINUS:
		{
			return VALA_BINARY_OPERATOR_MINUS;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LT:
		{
			return VALA_BINARY_OPERATOR_LESS_THAN;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GT:
		{
			return VALA_BINARY_OPERATOR_GREATER_THAN;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_LE:
		{
			return VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_GE:
		{
			return VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_EQ:
		{
			return VALA_BINARY_OPERATOR_EQUALITY;
		}
		case VALA_GENIE_TOKEN_TYPE_IS:
		{
			vala_genie_parser_next (self);
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_NEG) {
				vala_genie_parser_prev (self);
				return VALA_BINARY_OPERATOR_INEQUALITY;
			}
			vala_genie_parser_prev (self);
			return VALA_BINARY_OPERATOR_EQUALITY;
		}
		case VALA_GENIE_TOKEN_TYPE_OP_NE:
		{
			return VALA_BINARY_OPERATOR_INEQUALITY;
		}
		default:
		{
			return VALA_BINARY_OPERATOR_NONE;
		}
	}
}


static ValaExpression* vala_genie_parser_parse_multiplicative_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		switch (operator) {
			case VALA_BINARY_OPERATOR_MUL:
			case VALA_BINARY_OPERATOR_DIV:
			case VALA_BINARY_OPERATOR_MOD:
			{
				ValaExpression* right;
				ValaExpression* _tmp1_;
				ValaSourceReference* _tmp0_;
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_unary_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						return NULL;
					} else {
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp1_ = NULL;
				_tmp0_ = NULL;
				left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (operator, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
				(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
				(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_additive_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_multiplicative_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		switch (operator) {
			case VALA_BINARY_OPERATOR_PLUS:
			case VALA_BINARY_OPERATOR_MINUS:
			{
				ValaExpression* right;
				ValaExpression* _tmp1_;
				ValaSourceReference* _tmp0_;
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_multiplicative_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						return NULL;
					} else {
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp1_ = NULL;
				_tmp0_ = NULL;
				left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (operator, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
				(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
				(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_shift_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_additive_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (found) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT:
			{
				ValaExpression* right;
				ValaExpression* _tmp1_;
				ValaSourceReference* _tmp0_;
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_additive_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						return NULL;
					} else {
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp1_ = NULL;
				_tmp0_ = NULL;
				left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_LEFT, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
				(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
				(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OP_GT:
			{
				gchar* first_gt_pos;
				gboolean _tmp2_;
				first_gt_pos = self->priv->tokens[self->priv->index].begin.pos;
				vala_genie_parser_next (self);
				_tmp2_ = FALSE;
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT) {
					_tmp2_ = self->priv->tokens[self->priv->index].begin.pos == (first_gt_pos + 1);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					ValaExpression* right;
					ValaExpression* _tmp4_;
					ValaSourceReference* _tmp3_;
					vala_genie_parser_next (self);
					right = vala_genie_parser_parse_additive_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
							return NULL;
						} else {
							(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp4_ = NULL;
					_tmp3_ = NULL;
					left = (_tmp4_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_SHIFT_RIGHT, left, right, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp4_);
					(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL));
					(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				} else {
					vala_genie_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_relational_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_shift_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		switch (operator) {
			case VALA_BINARY_OPERATOR_LESS_THAN:
			case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
			case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
			{
				ValaExpression* right;
				ValaExpression* _tmp1_;
				ValaSourceReference* _tmp0_;
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_shift_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						return NULL;
					} else {
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp1_ = NULL;
				_tmp0_ = NULL;
				left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (operator, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
				(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
				(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				break;
			}
			case VALA_BINARY_OPERATOR_GREATER_THAN:
			{
				gboolean _tmp2_;
				vala_genie_parser_next (self);
				_tmp2_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GT) {
					_tmp2_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OP_GE;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					ValaExpression* right;
					ValaExpression* _tmp4_;
					ValaSourceReference* _tmp3_;
					right = vala_genie_parser_parse_shift_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
							return NULL;
						} else {
							(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp4_ = NULL;
					_tmp3_ = NULL;
					left = (_tmp4_ = (ValaExpression*) vala_binary_expression_new (operator, left, right, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp4_);
					(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL));
					(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				} else {
					vala_genie_parser_prev (self);
					found = FALSE;
				}
				break;
			}
			default:
			{
				switch (vala_genie_parser_current (self)) {
					case VALA_GENIE_TOKEN_TYPE_ISA:
					{
						ValaDataType* type;
						ValaExpression* _tmp6_;
						ValaSourceReference* _tmp5_;
						vala_genie_parser_next (self);
						type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
								return NULL;
							} else {
								(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp6_ = NULL;
						_tmp5_ = NULL;
						left = (_tmp6_ = (ValaExpression*) vala_typecheck_new (left, type, _tmp5_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp6_);
						(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_source_reference_unref (_tmp5_), NULL));
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						break;
					}
					case VALA_GENIE_TOKEN_TYPE_AS:
					{
						ValaDataType* type;
						ValaExpression* _tmp8_;
						ValaSourceReference* _tmp7_;
						vala_genie_parser_next (self);
						type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
								return NULL;
							} else {
								(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp8_ = NULL;
						_tmp7_ = NULL;
						left = (_tmp8_ = (ValaExpression*) vala_cast_expression_new (left, type, _tmp7_ = vala_genie_parser_get_src (self, &begin), TRUE), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp8_);
						(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_source_reference_unref (_tmp7_), NULL));
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						break;
					}
					default:
					{
						found = FALSE;
						break;
					}
				}
				break;
			}
		}
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_equality_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	gboolean found;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_relational_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = TRUE;
	while (found) {
		ValaBinaryOperator operator;
		operator = vala_genie_parser_get_binary_operator (self, vala_genie_parser_current (self));
		switch (operator) {
			case VALA_BINARY_OPERATOR_INEQUALITY:
			case VALA_BINARY_OPERATOR_EQUALITY:
			{
				gboolean _tmp0_;
				ValaExpression* right;
				ValaExpression* _tmp2_;
				ValaSourceReference* _tmp1_;
				_tmp0_ = FALSE;
				if (operator == VALA_BINARY_OPERATOR_INEQUALITY) {
					_tmp0_ = vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_IS;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					vala_genie_parser_next (self);
				}
				vala_genie_parser_next (self);
				right = vala_genie_parser_parse_relational_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						return NULL;
					} else {
						(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp2_ = NULL;
				_tmp1_ = NULL;
				left = (_tmp2_ = (ValaExpression*) vala_binary_expression_new (operator, left, right, _tmp1_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp2_);
				(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_source_reference_unref (_tmp1_), NULL));
				(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
				break;
			}
			default:
			{
				found = FALSE;
				break;
			}
		}
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_and_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_equality_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_AND)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_equality_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_AND, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_exclusive_or_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_and_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CARRET)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_and_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_XOR, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_inclusive_or_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_exclusive_or_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_BITWISE_OR)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_exclusive_or_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_BITWISE_OR, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_in_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_inclusive_or_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_inclusive_or_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_IN, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_and_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_in_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_AND)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_in_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_AND, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_or_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* left;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	left = vala_genie_parser_parse_conditional_and_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OP_OR)) {
		ValaExpression* right;
		ValaExpression* _tmp1_;
		ValaSourceReference* _tmp0_;
		right = vala_genie_parser_parse_conditional_and_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				return NULL;
			} else {
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		left = (_tmp1_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_OR, left, right, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	return left;
}


static ValaExpression* vala_genie_parser_parse_conditional_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* condition;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	condition = vala_genie_parser_parse_conditional_or_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INTERR)) {
		ValaExpression* true_expr;
		ValaExpression* false_expr;
		ValaSourceReference* _tmp0_;
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		true_expr = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				return NULL;
			} else {
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(true_expr == NULL) ? NULL : (true_expr = (vala_code_node_unref (true_expr), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				return NULL;
			} else {
				(true_expr == NULL) ? NULL : (true_expr = (vala_code_node_unref (true_expr), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		false_expr = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(true_expr == NULL) ? NULL : (true_expr = (vala_code_node_unref (true_expr), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				return NULL;
			} else {
				(true_expr == NULL) ? NULL : (true_expr = (vala_code_node_unref (true_expr), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		return (_tmp2_ = (_tmp1_ = (ValaExpression*) vala_conditional_expression_new (condition, true_expr, false_expr, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (true_expr == NULL) ? NULL : (true_expr = (vala_code_node_unref (true_expr), NULL)), (false_expr == NULL) ? NULL : (false_expr = (vala_code_node_unref (false_expr), NULL)), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), _tmp2_);
	} else {
		return condition;
	}
	(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
}


static ValaExpression* vala_genie_parser_parse_lambda_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	GeeList* params;
	ValaLambdaExpression* lambda;
	ValaExpression* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	params = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
			do {
				char* _tmp0_;
				char* _tmp1_;
				_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						return NULL;
					} else {
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp1_ = NULL;
				gee_collection_add ((GeeCollection*) params, _tmp1_ = _tmp0_);
				_tmp1_ = (g_free (_tmp1_), NULL);
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		gee_collection_add ((GeeCollection*) params, _tmp3_ = _tmp2_);
		_tmp3_ = (g_free (_tmp3_), NULL);
	}
	lambda = NULL;
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* block;
		ValaLambdaExpression* _tmp5_;
		ValaSourceReference* _tmp4_;
		block = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				return NULL;
			} else {
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		lambda = (_tmp5_ = vala_lambda_expression_new_with_statement_body (block, _tmp4_ = vala_genie_parser_get_src (self, &begin)), (lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL)), _tmp5_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
		(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
	} else {
		ValaExpression* expr;
		ValaLambdaExpression* _tmp7_;
		ValaSourceReference* _tmp6_;
		expr = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				return NULL;
			} else {
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		lambda = (_tmp7_ = vala_lambda_expression_new (expr, _tmp6_ = vala_genie_parser_get_src (self, &begin)), (lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL)), _tmp7_);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
		vala_genie_parser_expect_terminator (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				return NULL;
			} else {
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
	}
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			char* param;
			param = (char*) gee_iterator_get (_param_it);
			vala_lambda_expression_add_parameter (lambda, param);
			param = (g_free (param), NULL);
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp8_ = NULL;
	return (_tmp8_ = (ValaExpression*) lambda, (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp8_);
}


static ValaAssignmentOperator vala_genie_parser_get_assignment_operator (ValaGenieParser* self, ValaGenieTokenType token_type) {
	g_return_val_if_fail (self != NULL, 0);
	switch (token_type) {
		case VALA_GENIE_TOKEN_TYPE_ASSIGN:
		{
			return VALA_ASSIGNMENT_OPERATOR_SIMPLE;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD:
		{
			return VALA_ASSIGNMENT_OPERATOR_ADD;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB:
		{
			return VALA_ASSIGNMENT_OPERATOR_SUB;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		{
			return VALA_ASSIGNMENT_OPERATOR_BITWISE_OR;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		{
			return VALA_ASSIGNMENT_OPERATOR_BITWISE_AND;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		{
			return VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV:
		{
			return VALA_ASSIGNMENT_OPERATOR_DIV;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL:
		{
			return VALA_ASSIGNMENT_OPERATOR_MUL;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT:
		{
			return VALA_ASSIGNMENT_OPERATOR_PERCENT;
		}
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		{
			return VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
		}
		default:
		{
			return VALA_ASSIGNMENT_OPERATOR_NONE;
		}
	}
}


static ValaExpression* vala_genie_parser_parse_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEF) {
		ValaExpression* lambda;
		lambda = vala_genie_parser_parse_lambda_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		self->priv->current_expr_is_lambda = TRUE;
		return lambda;
	}
	begin = vala_genie_parser_get_location (self);
	expr = vala_genie_parser_parse_conditional_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (TRUE) {
		ValaAssignmentOperator operator;
		operator = vala_genie_parser_get_assignment_operator (self, vala_genie_parser_current (self));
		if (operator != VALA_ASSIGNMENT_OPERATOR_NONE) {
			ValaExpression* rhs;
			ValaExpression* _tmp2_;
			ValaSourceReference* _tmp1_;
			vala_genie_parser_next (self);
			rhs = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					return NULL;
				} else {
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			expr = (_tmp2_ = (ValaExpression*) vala_assignment_new (expr, rhs, operator, _tmp1_ = vala_genie_parser_get_src (self, &begin)), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_source_reference_unref (_tmp1_), NULL));
			(rhs == NULL) ? NULL : (rhs = (vala_code_node_unref (rhs), NULL));
		} else {
			if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GT) {
				gchar* first_gt_pos;
				gboolean _tmp3_;
				/* >>=*/
				first_gt_pos = self->priv->tokens[self->priv->index].begin.pos;
				vala_genie_parser_next (self);
				_tmp3_ = FALSE;
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_OP_GE) {
					_tmp3_ = self->priv->tokens[self->priv->index].begin.pos == (first_gt_pos + 1);
				} else {
					_tmp3_ = FALSE;
				}
				/* only accept >>= when there is no space between the two > signs*/
				if (_tmp3_) {
					ValaExpression* rhs;
					ValaExpression* _tmp5_;
					ValaSourceReference* _tmp4_;
					vala_genie_parser_next (self);
					rhs = vala_genie_parser_parse_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
							return NULL;
						} else {
							(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp5_ = NULL;
					_tmp4_ = NULL;
					expr = (_tmp5_ = (ValaExpression*) vala_assignment_new (expr, rhs, VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, _tmp4_ = vala_genie_parser_get_src (self, &begin)), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp5_);
					(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
					(rhs == NULL) ? NULL : (rhs = (vala_code_node_unref (rhs), NULL));
				} else {
					vala_genie_parser_prev (self);
					break;
				}
			} else {
				break;
			}
		}
	}
	return expr;
}


static ValaStatement* vala_genie_parser_get_for_statement_type (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	gboolean is_foreach;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	is_foreach = FALSE;
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DO;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		vala_genie_parser_next (self);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IN)) {
			is_foreach = TRUE;
			break;
		}
	}
	vala_genie_parser_rollback (self, &begin);
	if (is_foreach) {
		ValaStatement* _tmp1_;
		_tmp1_ = vala_genie_parser_parse_foreach_statement (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		return _tmp1_;
	} else {
		ValaStatement* _tmp3_;
		_tmp3_ = vala_genie_parser_parse_for_statement (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		return _tmp3_;
	}
}


static void vala_genie_parser_parse_statements (ValaGenieParser* self, ValaBlock* block, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = FALSE;
		_tmp1_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			_tmp1_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_WHEN;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEFAULT;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			ValaStatement* stmt;
			gboolean is_decl;
			char* _tmp2_;
			stmt = NULL;
			is_decl = FALSE;
			_tmp2_ = NULL;
			self->priv->comment = (_tmp2_ = vala_genie_scanner_pop_comment (self->priv->scanner), self->priv->comment = (g_free (self->priv->comment), NULL), _tmp2_);
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_REQUIRES:
				case VALA_GENIE_TOKEN_TYPE_ENSURES:
				{
					ValaSourceLocation begin;
					gboolean _tmp3_;
					ValaStatement* _tmp5_;
					ValaSourceReference* _tmp4_;
					begin = vala_genie_parser_get_location (self);
					vala_genie_parser_next (self);
					_tmp3_ = FALSE;
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
						_tmp3_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
							vala_genie_parser_next (self);
						}
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
						if (_inner_error_ != NULL) {
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch1_vala_parse_error;
							}
							goto __finally1;
						}
					} else {
						while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
							vala_genie_parser_next (self);
						}
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
						if (_inner_error_ != NULL) {
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch1_vala_parse_error;
							}
							goto __finally1;
						}
					}
					_tmp5_ = NULL;
					_tmp4_ = NULL;
					stmt = (_tmp5_ = (ValaStatement*) vala_empty_statement_new (_tmp4_ = vala_genie_parser_get_src_com (self, &begin)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp5_);
					(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_INDENT:
				{
					ValaBlock* _tmp6_;
					ValaStatement* _tmp7_;
					_tmp6_ = vala_genie_parser_parse_block (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp7_ = NULL;
					stmt = (_tmp7_ = (ValaStatement*) _tmp6_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp7_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_SEMICOLON:
				case VALA_GENIE_TOKEN_TYPE_PASS:
				{
					ValaStatement* _tmp8_;
					ValaStatement* _tmp9_;
					_tmp8_ = vala_genie_parser_parse_empty_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp9_ = NULL;
					stmt = (_tmp9_ = _tmp8_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp9_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_PRINT:
				case VALA_GENIE_TOKEN_TYPE_ASSERT:
				{
					ValaStatement* _tmp10_;
					ValaStatement* _tmp11_;
					_tmp10_ = vala_genie_parser_parse_expression_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp11_ = NULL;
					stmt = (_tmp11_ = _tmp10_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp11_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_IF:
				{
					ValaStatement* _tmp12_;
					ValaStatement* _tmp13_;
					_tmp12_ = vala_genie_parser_parse_if_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp13_ = NULL;
					stmt = (_tmp13_ = _tmp12_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp13_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_CASE:
				{
					ValaStatement* _tmp14_;
					ValaStatement* _tmp15_;
					_tmp14_ = vala_genie_parser_parse_switch_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp15_ = NULL;
					stmt = (_tmp15_ = _tmp14_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp15_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_WHILE:
				{
					ValaStatement* _tmp16_;
					ValaStatement* _tmp17_;
					_tmp16_ = vala_genie_parser_parse_while_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp17_ = NULL;
					stmt = (_tmp17_ = _tmp16_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp17_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_DO:
				{
					ValaStatement* _tmp18_;
					ValaStatement* _tmp19_;
					_tmp18_ = vala_genie_parser_parse_do_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp19_ = NULL;
					stmt = (_tmp19_ = _tmp18_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp19_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_FOR:
				{
					ValaStatement* _tmp20_;
					ValaStatement* _tmp21_;
					_tmp20_ = vala_genie_parser_get_for_statement_type (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp21_ = NULL;
					stmt = (_tmp21_ = _tmp20_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp21_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_BREAK:
				{
					ValaStatement* _tmp22_;
					ValaStatement* _tmp23_;
					_tmp22_ = vala_genie_parser_parse_break_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp23_ = NULL;
					stmt = (_tmp23_ = _tmp22_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp23_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_CONTINUE:
				{
					ValaStatement* _tmp24_;
					ValaStatement* _tmp25_;
					_tmp24_ = vala_genie_parser_parse_continue_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp25_ = NULL;
					stmt = (_tmp25_ = _tmp24_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp25_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_RETURN:
				{
					ValaStatement* _tmp26_;
					ValaStatement* _tmp27_;
					_tmp26_ = vala_genie_parser_parse_return_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp27_ = NULL;
					stmt = (_tmp27_ = _tmp26_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp27_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_RAISE:
				{
					ValaStatement* _tmp28_;
					ValaStatement* _tmp29_;
					_tmp28_ = vala_genie_parser_parse_throw_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp29_ = NULL;
					stmt = (_tmp29_ = _tmp28_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp29_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_TRY:
				{
					ValaStatement* _tmp30_;
					ValaStatement* _tmp31_;
					_tmp30_ = vala_genie_parser_parse_try_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp31_ = NULL;
					stmt = (_tmp31_ = _tmp30_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp31_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_LOCK:
				{
					ValaStatement* _tmp32_;
					ValaStatement* _tmp33_;
					_tmp32_ = vala_genie_parser_parse_lock_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp33_ = NULL;
					stmt = (_tmp33_ = _tmp32_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp33_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_DELETE:
				{
					ValaStatement* _tmp34_;
					ValaStatement* _tmp35_;
					_tmp34_ = vala_genie_parser_parse_delete_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp35_ = NULL;
					stmt = (_tmp35_ = _tmp34_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp35_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_VAR:
				{
					is_decl = TRUE;
					vala_genie_parser_parse_local_variable_declarations (self, block, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_YIELD:
				{
					ValaStatement* _tmp36_;
					ValaStatement* _tmp37_;
					_tmp36_ = vala_genie_parser_parse_yield_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp37_ = NULL;
					stmt = (_tmp37_ = _tmp36_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp37_);
					break;
				}
				case VALA_GENIE_TOKEN_TYPE_OP_INC:
				case VALA_GENIE_TOKEN_TYPE_OP_DEC:
				case VALA_GENIE_TOKEN_TYPE_SUPER:
				case VALA_GENIE_TOKEN_TYPE_THIS:
				case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
				case VALA_GENIE_TOKEN_TYPE_STAR:
				case VALA_GENIE_TOKEN_TYPE_NEW:
				{
					ValaStatement* _tmp38_;
					ValaStatement* _tmp39_;
					_tmp38_ = vala_genie_parser_parse_expression_statement (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					_tmp39_ = NULL;
					stmt = (_tmp39_ = _tmp38_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp39_);
					break;
				}
				default:
				{
					gboolean is_expr;
					is_expr = vala_genie_parser_is_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch1_vala_parse_error;
						}
						goto __finally1;
					}
					if (is_expr) {
						ValaStatement* _tmp40_;
						ValaStatement* _tmp41_;
						_tmp40_ = vala_genie_parser_parse_expression_statement (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch1_vala_parse_error;
							}
							goto __finally1;
						}
						_tmp41_ = NULL;
						stmt = (_tmp41_ = _tmp40_, (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp41_);
					} else {
						is_decl = TRUE;
						vala_genie_parser_parse_local_variable_declarations (self, block, &_inner_error_);
						if (_inner_error_ != NULL) {
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch1_vala_parse_error;
							}
							goto __finally1;
						}
					}
					break;
				}
			}
			if (!is_decl) {
				vala_block_add_statement (block, stmt);
			}
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
		}
		goto __finally1;
		__catch1_vala_parse_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				if (vala_genie_parser_recover (self) != VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
					/* beginning of next declaration or end of file reached
					 return what we have so far*/
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
					break;
				}
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gboolean vala_genie_parser_is_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	/* decide between declaration and expression statement*/
	vala_genie_parser_skip_type (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
		case VALA_GENIE_TOKEN_TYPE_OP_INC:
		case VALA_GENIE_TOKEN_TYPE_OP_DEC:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT:
		case VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB:
		case VALA_GENIE_TOKEN_TYPE_OP_GT:
		case VALA_GENIE_TOKEN_TYPE_DOT:
		case VALA_GENIE_TOKEN_TYPE_OP_PTR:
		{
			vala_genie_parser_rollback (self, &begin);
			return TRUE;
		}
		default:
		{
			vala_genie_parser_rollback (self, &begin);
			return FALSE;
		}
	}
}


static ValaBlock* vala_genie_parser_parse_embedded_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	char* _tmp1_;
	ValaSourceReference* _tmp3_;
	ValaSourceLocation _tmp2_ = {0};
	ValaBlock* _tmp4_;
	ValaBlock* block;
	ValaStatement* _tmp5_;
	ValaStatement* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_INDENT) {
		ValaBlock* block;
		block = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		return block;
	}
	_tmp1_ = NULL;
	self->priv->comment = (_tmp1_ = vala_genie_scanner_pop_comment (self->priv->scanner), self->priv->comment = (g_free (self->priv->comment), NULL), _tmp1_);
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	block = (_tmp4_ = vala_block_new (_tmp3_ = vala_genie_parser_get_src_com (self, (_tmp2_ = vala_genie_parser_get_location (self), &_tmp2_))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
	_tmp5_ = vala_genie_parser_parse_embedded_statement_without_block (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			return NULL;
		} else {
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = NULL;
	vala_block_add_statement (block, _tmp6_ = _tmp5_);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
	return block;
}


static ValaStatement* vala_genie_parser_parse_embedded_statement_without_block (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_PASS:
		case VALA_GENIE_TOKEN_TYPE_SEMICOLON:
		{
			ValaStatement* _tmp0_;
			_tmp0_ = vala_genie_parser_parse_empty_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp0_;
		}
		case VALA_GENIE_TOKEN_TYPE_IF:
		{
			ValaStatement* _tmp2_;
			_tmp2_ = vala_genie_parser_parse_if_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp2_;
		}
		case VALA_GENIE_TOKEN_TYPE_CASE:
		{
			ValaStatement* _tmp4_;
			_tmp4_ = vala_genie_parser_parse_switch_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp4_;
		}
		case VALA_GENIE_TOKEN_TYPE_WHILE:
		{
			ValaStatement* _tmp6_;
			_tmp6_ = vala_genie_parser_parse_while_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp6_;
		}
		case VALA_GENIE_TOKEN_TYPE_DO:
		{
			ValaStatement* _tmp8_;
			_tmp8_ = vala_genie_parser_parse_do_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp8_;
		}
		case VALA_GENIE_TOKEN_TYPE_FOR:
		{
			ValaStatement* _tmp10_;
			_tmp10_ = vala_genie_parser_get_for_statement_type (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp10_;
		}
		case VALA_GENIE_TOKEN_TYPE_BREAK:
		{
			ValaStatement* _tmp12_;
			_tmp12_ = vala_genie_parser_parse_break_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp12_;
		}
		case VALA_GENIE_TOKEN_TYPE_CONTINUE:
		{
			ValaStatement* _tmp14_;
			_tmp14_ = vala_genie_parser_parse_continue_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp14_;
		}
		case VALA_GENIE_TOKEN_TYPE_RETURN:
		{
			ValaStatement* _tmp16_;
			_tmp16_ = vala_genie_parser_parse_return_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp16_;
		}
		case VALA_GENIE_TOKEN_TYPE_YIELD:
		{
			ValaStatement* _tmp18_;
			_tmp18_ = vala_genie_parser_parse_yield_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp18_;
		}
		case VALA_GENIE_TOKEN_TYPE_RAISE:
		{
			ValaStatement* _tmp20_;
			_tmp20_ = vala_genie_parser_parse_throw_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp20_;
		}
		case VALA_GENIE_TOKEN_TYPE_TRY:
		{
			ValaStatement* _tmp22_;
			_tmp22_ = vala_genie_parser_parse_try_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp22_;
		}
		case VALA_GENIE_TOKEN_TYPE_LOCK:
		{
			ValaStatement* _tmp24_;
			_tmp24_ = vala_genie_parser_parse_lock_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp24_;
		}
		case VALA_GENIE_TOKEN_TYPE_DELETE:
		{
			ValaStatement* _tmp26_;
			_tmp26_ = vala_genie_parser_parse_delete_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp26_;
		}
		default:
		{
			ValaStatement* _tmp28_;
			_tmp28_ = vala_genie_parser_parse_expression_statement (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			return _tmp28_;
		}
	}
}


static ValaBlock* vala_genie_parser_parse_block (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* block;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	block = (_tmp1_ = vala_block_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_genie_parser_parse_statements (self, block, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			return NULL;
		} else {
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
		/* only report error if it's not a secondary error*/
		if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
			ValaSourceReference* _tmp2_;
			_tmp2_ = NULL;
			vala_report_error (_tmp2_ = vala_genie_parser_get_current_src (self), "tab indentation is incorrect");
			(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL));
		}
	}
	_tmp3_ = NULL;
	vala_source_reference_set_last_line (vala_code_node_get_source_reference ((ValaCodeNode*) block), vala_source_reference_get_last_line (_tmp3_ = vala_genie_parser_get_current_src (self)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_source_reference_set_last_column (vala_code_node_get_source_reference ((ValaCodeNode*) block), vala_source_reference_get_last_column (_tmp4_ = vala_genie_parser_get_current_src (self)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
	return block;
}


static ValaStatement* vala_genie_parser_parse_empty_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_PASS);
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SEMICOLON);
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaStatement*) vala_empty_statement_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static void vala_genie_parser_add_local_var_variable (ValaGenieParser* self, ValaBlock* block, const char* id, GError** error) {
	GError * _inner_error_;
	ValaDataType* type_copy;
	ValaLocalVariable* local;
	ValaDeclarationStatement* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (id != NULL);
	_inner_error_ = NULL;
	type_copy = NULL;
	local = vala_genie_parser_parse_local_variable (self, type_copy, id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
			return;
		} else {
			(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = NULL;
	vala_block_add_statement (block, (ValaStatement*) (_tmp0_ = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) local))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL));
	(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


static void vala_genie_parser_parse_local_variable_declarations (ValaGenieParser* self, ValaBlock* block, GError** error) {
	GError * _inner_error_;
	GeeArrayList* id_list;
	ValaDataType* variable_type;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			_tmp0_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
		} else {
			_tmp0_ = FALSE;
		}
		/* support block vars */
		if (_tmp0_) {
			while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
				char* s;
				s = vala_genie_parser_parse_identifier (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				vala_genie_parser_add_local_var_variable (self, block, s, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						s = (g_free (s), NULL);
						return;
					} else {
						s = (g_free (s), NULL);
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
				vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SEMICOLON);
				s = (g_free (s), NULL);
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			char* s;
			s = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_genie_parser_add_local_var_variable (self, block, s, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					s = (g_free (s), NULL);
					return;
				} else {
					s = (g_free (s), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_genie_parser_expect_terminator (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					s = (g_free (s), NULL);
					return;
				} else {
					s = (g_free (s), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			s = (g_free (s), NULL);
		}
		return;
	}
	id_list = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	variable_type = NULL;
	do {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
				(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
				return;
			} else {
				(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
				(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp2_ = NULL;
		gee_collection_add ((GeeCollection*) id_list, _tmp2_ = _tmp1_);
		_tmp2_ = (g_free (_tmp2_), NULL);
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			return;
		} else {
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			return;
		} else {
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = NULL;
	variable_type = (_tmp4_ = _tmp3_, (variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL)), _tmp4_);
	{
		GeeIterator* _id_it;
		_id_it = gee_iterable_iterator ((GeeIterable*) id_list);
		while (gee_iterator_next (_id_it)) {
			char* id;
			ValaDataType* type_copy;
			ValaLocalVariable* local;
			ValaDeclarationStatement* _tmp6_;
			id = (char*) gee_iterator_get (_id_it);
			type_copy = NULL;
			if (variable_type != NULL) {
				ValaDataType* _tmp5_;
				_tmp5_ = NULL;
				type_copy = (_tmp5_ = vala_data_type_copy (variable_type), (type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL)), _tmp5_);
			}
			local = vala_genie_parser_parse_local_variable (self, type_copy, id, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					id = (g_free (id), NULL);
					(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
					(_id_it == NULL) ? NULL : (_id_it = (gee_collection_object_unref (_id_it), NULL));
					(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					return;
				} else {
					id = (g_free (id), NULL);
					(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
					(_id_it == NULL) ? NULL : (_id_it = (gee_collection_object_unref (_id_it), NULL));
					(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp6_ = NULL;
			vala_block_add_statement (block, (ValaStatement*) (_tmp6_ = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) local))));
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
			id = (g_free (id), NULL);
			(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_id_it == NULL) ? NULL : (_id_it = (gee_collection_object_unref (_id_it), NULL));
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			return;
		} else {
			(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
			(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	(id_list == NULL) ? NULL : (id_list = (gee_collection_object_unref (id_list), NULL));
	(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
}


static ValaLocalVariable* vala_genie_parser_parse_local_variable (ValaGenieParser* self, ValaDataType* variable_type, const char* id, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* initializer;
	ValaSourceReference* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaLocalVariable* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp0_;
		ValaExpression* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				return NULL;
			} else {
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		initializer = (_tmp1_ = _tmp0_, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp1_);
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	return (_tmp4_ = (_tmp3_ = vala_local_variable_new (variable_type, id, initializer, _tmp2_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_), (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp4_);
}


static ValaStatement* vala_genie_parser_parse_expression_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = vala_genie_parser_parse_statement_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (self->priv->current_expr_is_lambda) {
		self->priv->current_expr_is_lambda = FALSE;
	} else {
		vala_genie_parser_expect_terminator (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				return NULL;
			} else {
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_expression_statement_new (expr, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
}


static ValaExpression* vala_genie_parser_parse_statement_expression (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaExpression* expr;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	/* invocation expression, assignment,
	 or pre/post increment/decrement expression*/
	expr = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return expr;
}


static ValaStatement* vala_genie_parser_parse_if_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaSourceReference* src;
	ValaBlock* true_stmt;
	ValaBlock* false_stmt;
	ValaStatement* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	condition = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				return NULL;
			} else {
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	true_stmt = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			return NULL;
		} else {
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	false_stmt = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELSE)) {
		gboolean _tmp0_;
		ValaBlock* _tmp1_;
		ValaBlock* _tmp2_;
		_tmp0_ = FALSE;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_IF;
		} else {
			_tmp0_ = FALSE;
		}
		/* allow `else if' on the same line without `do'*/
		if (_tmp0_) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
					(true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL));
					(false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL));
					return NULL;
				} else {
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
					(true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL));
					(false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		} else {
			vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		}
		_tmp1_ = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
				(true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL));
				(false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL));
				return NULL;
			} else {
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
				(true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL));
				(false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = NULL;
		false_stmt = (_tmp2_ = _tmp1_, (false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL)), _tmp2_);
	}
	_tmp3_ = NULL;
	return (_tmp3_ = (ValaStatement*) vala_if_statement_new (condition, true_stmt, false_stmt, src), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), (src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL)), (true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL)), (false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL)), _tmp3_);
}


static ValaStatement* vala_genie_parser_parse_switch_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaSourceReference* _tmp0_;
	ValaSwitchStatement* _tmp1_;
	ValaSwitchStatement* stmt;
	ValaStatement* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CASE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	condition = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			return NULL;
		} else {
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	stmt = (_tmp1_ = vala_switch_statement_new (condition, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			return NULL;
		} else {
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
		ValaSourceReference* _tmp2_;
		ValaSwitchSection* _tmp3_;
		ValaSwitchSection* section;
		ValaSourceReference* _tmp10_;
		ValaBreakStatement* _tmp11_;
		ValaBreakStatement* break_stmt;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		section = (_tmp3_ = vala_switch_section_new (_tmp2_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_WHEN)) {
			do {
				ValaExpression* _tmp4_;
				ValaSwitchLabel* _tmp7_;
				ValaSourceReference* _tmp6_;
				ValaExpression* _tmp5_;
				_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
						(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						return NULL;
					} else {
						(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
						(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				_tmp5_ = NULL;
				vala_switch_section_add_label (section, _tmp7_ = vala_switch_label_new (_tmp5_ = _tmp4_, _tmp6_ = vala_genie_parser_get_src_com (self, &begin)));
				(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_code_node_unref (_tmp7_), NULL));
				(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		} else {
			ValaSwitchLabel* _tmp9_;
			ValaSourceReference* _tmp8_;
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEFAULT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					return NULL;
				} else {
					(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			vala_switch_section_add_label (section, _tmp9_ = vala_switch_label_new_with_default (_tmp8_ = vala_genie_parser_get_src_com (self, &begin)));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_code_node_unref (_tmp9_), NULL));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_source_reference_unref (_tmp8_), NULL));
		}
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					return NULL;
				} else {
					(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		vala_genie_parser_parse_statements (self, (ValaBlock*) section, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				return NULL;
			} else {
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		/* add break statement for each block */
		_tmp10_ = NULL;
		_tmp11_ = NULL;
		break_stmt = (_tmp11_ = vala_break_statement_new (_tmp10_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_source_reference_unref (_tmp10_), NULL)), _tmp11_);
		vala_block_add_statement ((ValaBlock*) section, (ValaStatement*) break_stmt);
		vala_switch_statement_add_section (stmt, section);
		(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
		(break_stmt == NULL) ? NULL : (break_stmt = (vala_code_node_unref (break_stmt), NULL));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			return NULL;
		} else {
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = NULL;
	return (_tmp12_ = (ValaStatement*) stmt, (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), _tmp12_);
}


static ValaStatement* vala_genie_parser_parse_while_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* condition;
	ValaBlock* body;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	condition = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DO)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				return NULL;
			} else {
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	}
	body = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			return NULL;
		} else {
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_while_statement_new (condition, body, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), (body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL)), _tmp2_);
}


static ValaStatement* vala_genie_parser_parse_do_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaBlock* body;
	ValaExpression* condition;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	body = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_WHILE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			return NULL;
		} else {
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	condition = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			return NULL;
		} else {
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			return NULL;
		} else {
			(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_do_statement_new (body, condition, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL)), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), _tmp2_);
}


static ValaStatement* vala_genie_parser_parse_for_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaBlock* block;
	ValaExpression* initializer;
	ValaExpression* condition;
	ValaExpression* iterator;
	gboolean is_expr;
	char* id;
	ValaSourceReference* src;
	ValaBlock* body;
	ValaForStatement* stmt;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	block = NULL;
	initializer = NULL;
	condition = NULL;
	iterator = NULL;
	is_expr = FALSE;
	id = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
			id = (g_free (id), NULL);
			return NULL;
		} else {
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_VAR:
		{
			is_expr = FALSE;
			break;
		}
		default:
		{
			gboolean local_is_expr;
			local_is_expr = vala_genie_parser_is_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			is_expr = local_is_expr;
			break;
		}
	}
	if (is_expr) {
		ValaSourceLocation expr_begin;
		char* _tmp0_;
		char* _tmp1_;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		expr_begin = vala_genie_parser_get_location (self);
		_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		id = (_tmp1_ = _tmp0_, id = (g_free (id), NULL), _tmp1_);
		vala_genie_parser_rollback (self, &expr_begin);
		_tmp2_ = vala_genie_parser_parse_statement_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		initializer = (_tmp3_ = _tmp2_, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp3_);
	} else {
		ValaBlock* _tmp5_;
		ValaSourceReference* _tmp4_;
		ValaDataType* variable_type;
		ValaDataType* type_copy;
		ValaLocalVariable* local;
		ValaDeclarationStatement* _tmp14_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		block = (_tmp5_ = vala_block_new (_tmp4_ = vala_genie_parser_get_src (self, &begin)), (block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL)), _tmp5_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
		variable_type = NULL;
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
			ValaDataType* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			_tmp6_ = NULL;
			variable_type = (_tmp6_ = NULL, (variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL)), _tmp6_);
			_tmp7_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp8_ = NULL;
			id = (_tmp8_ = _tmp7_, id = (g_free (id), NULL), _tmp8_);
		} else {
			char* _tmp9_;
			char* _tmp10_;
			ValaDataType* _tmp11_;
			ValaDataType* _tmp12_;
			_tmp9_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp10_ = NULL;
			id = (_tmp10_ = _tmp9_, id = (g_free (id), NULL), _tmp10_);
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp11_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
					(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
					(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = NULL;
			variable_type = (_tmp12_ = _tmp11_, (variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL)), _tmp12_);
		}
		type_copy = NULL;
		if (variable_type != NULL) {
			ValaDataType* _tmp13_;
			_tmp13_ = NULL;
			type_copy = (_tmp13_ = vala_data_type_copy (variable_type), (type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL)), _tmp13_);
		}
		local = vala_genie_parser_parse_local_variable (self, type_copy, id, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
				(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
				(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp14_ = NULL;
		vala_block_add_statement (block, (ValaStatement*) (_tmp14_ = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) local))));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_code_node_unref (_tmp14_), NULL));
		(variable_type == NULL) ? NULL : (variable_type = (vala_code_node_unref (variable_type), NULL));
		(type_copy == NULL) ? NULL : (type_copy = (vala_code_node_unref (type_copy), NULL));
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_TO)) {
		ValaSourceLocation to_begin;
		ValaSourceReference* to_src;
		ValaMemberAccess* left;
		ValaExpression* right;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		/* create expression for condition and incrementing iterator */
		to_begin = vala_genie_parser_get_location (self);
		to_src = vala_genie_parser_get_src (self, &to_begin);
		left = vala_member_access_new (NULL, id, to_src);
		right = vala_genie_parser_parse_primary_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(to_src == NULL) ? NULL : (to_src = (vala_source_reference_unref (to_src), NULL));
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(to_src == NULL) ? NULL : (to_src = (vala_source_reference_unref (to_src), NULL));
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp15_ = NULL;
		condition = (_tmp15_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, (ValaExpression*) left, right, to_src), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), _tmp15_);
		_tmp16_ = NULL;
		iterator = (_tmp16_ = (ValaExpression*) vala_postfix_expression_new ((ValaExpression*) left, TRUE, to_src), (iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL)), _tmp16_);
		(to_src == NULL) ? NULL : (to_src = (vala_source_reference_unref (to_src), NULL));
		(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	} else {
		ValaSourceLocation downto_begin;
		ValaSourceReference* downto_src;
		ValaMemberAccess* left;
		ValaExpression* right;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DOWNTO, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		downto_begin = vala_genie_parser_get_location (self);
		downto_src = vala_genie_parser_get_src (self, &downto_begin);
		/* create expression for condition and decrementing iterator */
		left = vala_member_access_new (NULL, id, downto_src);
		right = vala_genie_parser_parse_primary_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(downto_src == NULL) ? NULL : (downto_src = (vala_source_reference_unref (downto_src), NULL));
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(downto_src == NULL) ? NULL : (downto_src = (vala_source_reference_unref (downto_src), NULL));
				(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp17_ = NULL;
		condition = (_tmp17_ = (ValaExpression*) vala_binary_expression_new (VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaExpression*) left, right, downto_src), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), _tmp17_);
		_tmp18_ = NULL;
		iterator = (_tmp18_ = (ValaExpression*) vala_postfix_expression_new ((ValaExpression*) left, FALSE, downto_src), (iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL)), _tmp18_);
		(downto_src == NULL) ? NULL : (downto_src = (vala_source_reference_unref (downto_src), NULL));
		(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
		(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
				(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	body = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
			id = (g_free (id), NULL);
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			return NULL;
		} else {
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
			(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
			id = (g_free (id), NULL);
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	stmt = vala_for_statement_new (condition, body, src);
	if (initializer != NULL) {
		vala_for_statement_add_initializer (stmt, initializer);
	}
	vala_for_statement_add_iterator (stmt, iterator);
	if (block != NULL) {
		ValaStatement* _tmp19_;
		vala_block_add_statement (block, (ValaStatement*) stmt);
		_tmp19_ = NULL;
		return (_tmp19_ = (ValaStatement*) block, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), (iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL)), id = (g_free (id), NULL), (src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL)), (body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp19_);
	} else {
		ValaStatement* _tmp20_;
		_tmp20_ = NULL;
		return (_tmp20_ = (ValaStatement*) stmt, (block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL)), (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), (condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL)), (iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL)), id = (g_free (id), NULL), (src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL)), (body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL)), _tmp20_);
	}
	(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
	(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
	(condition == NULL) ? NULL : (condition = (vala_code_node_unref (condition), NULL));
	(iterator == NULL) ? NULL : (iterator = (vala_code_node_unref (iterator), NULL));
	id = (g_free (id), NULL);
	(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
	(body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL));
	(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
}


static ValaStatement* vala_genie_parser_parse_foreach_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	char* id;
	ValaExpression* collection;
	ValaSourceReference* src;
	ValaBlock* body;
	ValaStatement* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	id = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FOR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_VAR)) {
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		id = (_tmp1_ = _tmp0_, id = (g_free (id), NULL), _tmp1_);
	} else {
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		id = (_tmp3_ = _tmp2_, id = (g_free (id), NULL), _tmp3_);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
			ValaDataType* _tmp4_;
			ValaDataType* _tmp5_;
			_tmp4_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp5_ = NULL;
			type = (_tmp5_ = _tmp4_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5_);
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_IN, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	collection = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DO, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(collection == NULL) ? NULL : (collection = (vala_code_node_unref (collection), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(collection == NULL) ? NULL : (collection = (vala_code_node_unref (collection), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	src = vala_genie_parser_get_src_com (self, &begin);
	body = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(collection == NULL) ? NULL : (collection = (vala_code_node_unref (collection), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(collection == NULL) ? NULL : (collection = (vala_code_node_unref (collection), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = NULL;
	return (_tmp6_ = (ValaStatement*) vala_foreach_statement_new (type, id, collection, body, src), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), id = (g_free (id), NULL), (collection == NULL) ? NULL : (collection = (vala_code_node_unref (collection), NULL)), (src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL)), (body == NULL) ? NULL : (body = (vala_code_node_unref (body), NULL)), _tmp6_);
}


static ValaStatement* vala_genie_parser_parse_break_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_BREAK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaStatement*) vala_break_statement_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaStatement* vala_genie_parser_parse_continue_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONTINUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	return (_tmp1_ = (ValaStatement*) vala_continue_statement_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
}


static ValaStatement* vala_genie_parser_parse_return_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	gboolean _tmp0_;
	ValaSourceReference* _tmp3_;
	ValaStatement* _tmp4_;
	ValaStatement* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RETURN, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = NULL;
	_tmp0_ = FALSE;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				return NULL;
			} else {
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = NULL;
		expr = (_tmp2_ = _tmp1_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	return (_tmp5_ = (_tmp4_ = (ValaStatement*) vala_return_statement_new (expr, _tmp3_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp5_);
}


static ValaStatement* vala_genie_parser_parse_yield_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	gboolean _tmp0_;
	ValaSourceReference* _tmp3_;
	ValaStatement* _tmp4_;
	ValaStatement* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_YIELD, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = NULL;
	_tmp0_ = FALSE;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON) {
		_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				return NULL;
			} else {
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = NULL;
		expr = (_tmp2_ = _tmp1_, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	return (_tmp5_ = (_tmp4_ = (ValaStatement*) vala_yield_statement_new (expr, _tmp3_ = vala_genie_parser_get_src (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp5_);
}


static ValaStatement* vala_genie_parser_parse_throw_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_RAISE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_throw_statement_new (expr, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
}


static ValaStatement* vala_genie_parser_parse_try_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaBlock* try_block;
	ValaBlock* finally_clause;
	GeeArrayList* catch_clauses;
	ValaSourceReference* _tmp4_;
	ValaTryStatement* _tmp5_;
	ValaTryStatement* stmt;
	ValaStatement* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_TRY, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	try_block = vala_genie_parser_parse_block (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	finally_clause = NULL;
	catch_clauses = gee_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_EXCEPT) {
		vala_genie_parser_parse_catch_clauses (self, (GeeList*) catch_clauses, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
				(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
				(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
				return NULL;
			} else {
				(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
				(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
				(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_FINALLY) {
			ValaBlock* _tmp0_;
			ValaBlock* _tmp1_;
			_tmp0_ = vala_genie_parser_parse_finally_clause (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
					(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
					(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
					return NULL;
				} else {
					(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
					(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
					(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			finally_clause = (_tmp1_ = _tmp0_, (finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL)), _tmp1_);
		}
	} else {
		ValaBlock* _tmp2_;
		ValaBlock* _tmp3_;
		_tmp2_ = vala_genie_parser_parse_finally_clause (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
				(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
				(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
				return NULL;
			} else {
				(try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL));
				(finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL));
				(catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		finally_clause = (_tmp3_ = _tmp2_, (finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL)), _tmp3_);
	}
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	stmt = (_tmp5_ = vala_try_statement_new (try_block, finally_clause, _tmp4_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL)), _tmp5_);
	{
		GeeIterator* _clause_it;
		_clause_it = gee_iterable_iterator ((GeeIterable*) catch_clauses);
		while (gee_iterator_next (_clause_it)) {
			ValaCatchClause* clause;
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			vala_try_statement_add_catch_clause (stmt, clause);
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	_tmp6_ = NULL;
	return (_tmp6_ = (ValaStatement*) stmt, (try_block == NULL) ? NULL : (try_block = (vala_code_node_unref (try_block), NULL)), (finally_clause == NULL) ? NULL : (finally_clause = (vala_code_node_unref (finally_clause), NULL)), (catch_clauses == NULL) ? NULL : (catch_clauses = (gee_collection_object_unref (catch_clauses), NULL)), _tmp6_);
}


static void vala_genie_parser_parse_catch_clauses (ValaGenieParser* self, GeeList* catch_clauses, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (catch_clauses != NULL);
	_inner_error_ = NULL;
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EXCEPT)) {
		ValaSourceLocation begin;
		ValaDataType* type;
		char* id;
		ValaBlock* block;
		ValaCatchClause* _tmp5_;
		ValaSourceReference* _tmp4_;
		begin = vala_genie_parser_get_location (self);
		type = NULL;
		id = NULL;
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
			char* _tmp0_;
			char* _tmp1_;
			ValaDataType* _tmp2_;
			ValaDataType* _tmp3_;
			_tmp0_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					return;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp1_ = NULL;
			id = (_tmp1_ = _tmp0_, id = (g_free (id), NULL), _tmp1_);
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					return;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp2_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					return;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp3_ = NULL;
			type = (_tmp3_ = _tmp2_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3_);
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					return;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		block = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				return;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		gee_collection_add ((GeeCollection*) catch_clauses, _tmp5_ = vala_catch_clause_new (type, id, block, _tmp4_ = vala_genie_parser_get_src (self, &begin)));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		id = (g_free (id), NULL);
		(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
	}
}


static ValaBlock* vala_genie_parser_parse_finally_clause (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaBlock* block;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINALLY, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_accept_block (self);
	block = vala_genie_parser_parse_block (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return block;
}


static ValaStatement* vala_genie_parser_parse_lock_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaBlock* stmt;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_LOCK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	stmt = vala_genie_parser_parse_embedded_statement (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_lock_statement_new (expr, stmt, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), _tmp2_);
}


static ValaStatement* vala_genie_parser_parse_delete_statement (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaExpression* expr;
	ValaSourceReference* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELETE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	expr = vala_genie_parser_parse_expression (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			return NULL;
		} else {
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	return (_tmp2_ = (_tmp1_ = (ValaStatement*) vala_delete_statement_new (expr, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp2_);
}


static GeeList* vala_genie_parser_parse_attributes (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* attrs;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET) {
		return NULL;
	}
	attrs = gee_array_list_new (VALA_TYPE_ATTRIBUTE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET)) {
		do {
			ValaSourceLocation begin;
			char* id;
			ValaSourceReference* _tmp1_;
			ValaAttribute* _tmp2_;
			ValaAttribute* attr;
			begin = vala_genie_parser_get_location (self);
			id = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			_tmp2_ = NULL;
			attr = (_tmp2_ = vala_attribute_new (id, _tmp1_ = vala_genie_parser_get_src (self, &begin)), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_source_reference_unref (_tmp1_), NULL)), _tmp2_);
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
					do {
						char* _tmp3_;
						char* _tmp4_;
						ValaExpression* expr;
						_tmp3_ = vala_genie_parser_parse_identifier (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								return NULL;
							} else {
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp4_ = NULL;
						id = (_tmp4_ = _tmp3_, id = (g_free (id), NULL), _tmp4_);
						vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ASSIGN, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								return NULL;
							} else {
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						expr = vala_genie_parser_parse_expression (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								return NULL;
							} else {
								id = (g_free (id), NULL);
								(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
								(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						vala_attribute_add_argument (attr, id, expr);
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						id = (g_free (id), NULL);
						(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
						(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
						return NULL;
					} else {
						id = (g_free (id), NULL);
						(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
						(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
			gee_collection_add ((GeeCollection*) attrs, attr);
			id = (g_free (id), NULL);
			(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				return NULL;
			} else {
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			return NULL;
		} else {
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return (GeeList*) attrs;
}


static void vala_genie_parser_set_attributes (ValaGenieParser* self, ValaCodeNode* node, GeeList* attributes) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (attributes != NULL) {
		{
			GeeIterator* _attr_it;
			_attr_it = gee_iterable_iterator ((GeeIterable*) GEE_LIST (attributes));
			while (gee_iterator_next (_attr_it)) {
				ValaAttribute* attr;
				ValaAttribute* _tmp0_;
				attr = (ValaAttribute*) gee_iterator_get (_attr_it);
				_tmp0_ = NULL;
				node->attributes = g_list_append (node->attributes, (_tmp0_ = attr, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)));
				(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
			}
			(_attr_it == NULL) ? NULL : (_attr_it = (gee_collection_object_unref (_attr_it), NULL));
		}
	}
}


static ValaSymbol* vala_genie_parser_parse_declaration (ValaGenieParser* self, gboolean is_root, GError** error) {
	GError * _inner_error_;
	char* _tmp0_;
	GeeList* attrs;
	ValaSourceLocation begin;
	ValaGenieTokenType cur;
	ValaGenieTokenType pre;
	char* _tmp36_;
	char* _tmp35_;
	GError* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	_tmp0_ = NULL;
	self->priv->comment = (_tmp0_ = vala_genie_scanner_pop_comment (self->priv->scanner), self->priv->comment = (g_free (self->priv->comment), NULL), _tmp0_);
	attrs = vala_genie_parser_parse_attributes (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	begin = vala_genie_parser_get_location (self);
	switch (vala_genie_parser_current (self)) {
		case VALA_GENIE_TOKEN_TYPE_CONST:
		{
			ValaConstant* _tmp1_;
			ValaSymbol* _tmp2_;
			_tmp1_ = vala_genie_parser_parse_constant_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp2_ = NULL;
			return (_tmp2_ = (ValaSymbol*) _tmp1_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp2_);
		}
		case VALA_GENIE_TOKEN_TYPE_CONSTRUCT:
		{
			ValaCreationMethod* _tmp3_;
			ValaSymbol* _tmp4_;
			_tmp3_ = vala_genie_parser_parse_creation_method_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp4_ = NULL;
			return (_tmp4_ = (ValaSymbol*) _tmp3_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp4_);
		}
		case VALA_GENIE_TOKEN_TYPE_CLASS:
		{
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			_tmp5_ = vala_genie_parser_parse_class_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = NULL;
			return (_tmp6_ = _tmp5_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp6_);
		}
		case VALA_GENIE_TOKEN_TYPE_INIT:
		{
			ValaConstructor* _tmp9_;
			ValaSymbol* _tmp10_;
			if (is_root) {
				ValaMethod* _tmp7_;
				ValaSymbol* _tmp8_;
				_tmp7_ = vala_genie_parser_parse_main_method_declaration (self, attrs, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
						return NULL;
					} else {
						(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp8_ = NULL;
				return (_tmp8_ = (ValaSymbol*) _tmp7_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp8_);
			}
			_tmp9_ = vala_genie_parser_parse_constructor_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp10_ = NULL;
			return (_tmp10_ = (ValaSymbol*) _tmp9_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp10_);
		}
		case VALA_GENIE_TOKEN_TYPE_DELEGATE:
		{
			ValaSymbol* _tmp11_;
			ValaSymbol* _tmp12_;
			_tmp11_ = vala_genie_parser_parse_delegate_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = NULL;
			return (_tmp12_ = _tmp11_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp12_);
		}
		case VALA_GENIE_TOKEN_TYPE_DEF:
		{
			ValaMethod* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp13_ = vala_genie_parser_parse_method_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp14_ = NULL;
			return (_tmp14_ = (ValaSymbol*) _tmp13_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp14_);
		}
		case VALA_GENIE_TOKEN_TYPE_ENUM:
		{
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			_tmp15_ = vala_genie_parser_parse_enum_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp16_ = NULL;
			return (_tmp16_ = _tmp15_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp16_);
		}
		case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
		{
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			_tmp17_ = vala_genie_parser_parse_errordomain_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp18_ = NULL;
			return (_tmp18_ = _tmp17_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp18_);
		}
		case VALA_GENIE_TOKEN_TYPE_FINAL:
		{
			ValaDestructor* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp19_ = vala_genie_parser_parse_destructor_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp20_ = NULL;
			return (_tmp20_ = (ValaSymbol*) _tmp19_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp20_);
		}
		case VALA_GENIE_TOKEN_TYPE_INTERFACE:
		{
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			_tmp21_ = vala_genie_parser_parse_interface_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp22_ = NULL;
			return (_tmp22_ = _tmp21_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp22_);
		}
		case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
		{
			ValaNamespace* _tmp23_;
			ValaSymbol* _tmp24_;
			_tmp23_ = vala_genie_parser_parse_namespace_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp24_ = NULL;
			return (_tmp24_ = (ValaSymbol*) _tmp23_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp24_);
		}
		case VALA_GENIE_TOKEN_TYPE_PROP:
		{
			ValaProperty* _tmp25_;
			ValaSymbol* _tmp26_;
			_tmp25_ = vala_genie_parser_parse_property_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp26_ = NULL;
			return (_tmp26_ = (ValaSymbol*) _tmp25_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp26_);
		}
		case VALA_GENIE_TOKEN_TYPE_EVENT:
		{
			ValaSignal* _tmp27_;
			ValaSymbol* _tmp28_;
			_tmp27_ = vala_genie_parser_parse_signal_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp28_ = NULL;
			return (_tmp28_ = (ValaSymbol*) _tmp27_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp28_);
		}
		case VALA_GENIE_TOKEN_TYPE_STRUCT:
		{
			ValaSymbol* _tmp29_;
			ValaSymbol* _tmp30_;
			_tmp29_ = vala_genie_parser_parse_struct_declaration (self, attrs, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					return NULL;
				} else {
					(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp30_ = NULL;
			return (_tmp30_ = _tmp29_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp30_);
		}
		default:
		{
			while (TRUE) {
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp31_ = FALSE;
				_tmp32_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOL) {
					_tmp32_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					_tmp31_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
				} else {
					_tmp31_ = FALSE;
				}
				if (!_tmp31_) {
					break;
				}
				if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_COLON) {
					ValaField* _tmp33_;
					ValaSymbol* _tmp34_;
					vala_genie_parser_rollback (self, &begin);
					_tmp33_ = vala_genie_parser_parse_field_declaration (self, attrs, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
							return NULL;
						} else {
							(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp34_ = NULL;
					return (_tmp34_ = (ValaSymbol*) _tmp33_, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp34_);
				} else {
					vala_genie_parser_next (self);
				}
			}
			vala_genie_parser_rollback (self, &begin);
			break;
		}
	}
	cur = vala_genie_parser_current (self);
	pre = self->priv->tokens[self->priv->index - 1].type;
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	_tmp37_ = NULL;
	_inner_error_ = (_tmp37_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp36_ = vala_genie_parser_get_error (self, _tmp35_ = g_strdup_printf ("expected declaration  but got %s with previous %s", vala_genie_token_type_to_string (cur), vala_genie_token_type_to_string (pre)))), _tmp36_ = (g_free (_tmp36_), NULL), _tmp35_ = (g_free (_tmp35_), NULL), _tmp37_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			return NULL;
		} else {
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
}


static void vala_genie_parser_parse_declarations (ValaGenieParser* self, ValaSymbol* parent, gboolean root, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_inner_error_ = NULL;
	if (!root) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			if (VALA_IS_NAMESPACE (parent)) {
				vala_genie_parser_parse_namespace_member (self, VALA_NAMESPACE (parent), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						goto __catch2_vala_parse_error;
					}
					goto __finally2;
				}
			} else {
				if (VALA_IS_CLASS (parent)) {
					vala_genie_parser_parse_class_member (self, VALA_CLASS (parent), &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							goto __catch2_vala_parse_error;
						}
						goto __finally2;
					}
				} else {
					if (VALA_IS_STRUCT (parent)) {
						vala_genie_parser_parse_struct_member (self, VALA_STRUCT (parent), &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								goto __catch2_vala_parse_error;
							}
							goto __finally2;
						}
					} else {
						if (VALA_IS_INTERFACE (parent)) {
							vala_genie_parser_parse_interface_member (self, VALA_INTERFACE (parent), &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									goto __catch2_vala_parse_error;
								}
								goto __finally2;
							}
						}
					}
				}
			}
		}
		goto __finally2;
		__catch2_vala_parse_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				gint r;
				r = 0;
				do {
					r = (gint) vala_genie_parser_recover (self);
					if (r == VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN) {
						vala_genie_parser_next (self);
					} else {
						break;
					}
				} while (TRUE);
				if (r == VALA_GENIE_PARSER_RECOVERY_STATE_EOF) {
					(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
					return;
				}
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (!root) {
		if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DEDENT)) {
			/* only report error if it's not a secondary error*/
			if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
				ValaSourceReference* _tmp1_;
				_tmp1_ = NULL;
				vala_report_error (_tmp1_ = vala_genie_parser_get_current_src (self), "expected dedent");
				(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_source_reference_unref (_tmp1_), NULL));
			}
		}
	}
}


static ValaGenieParserRecoveryState vala_genie_parser_recover (ValaGenieParser* self) {
	g_return_val_if_fail (self != NULL, 0);
	while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_CLASS:
			case VALA_GENIE_TOKEN_TYPE_CONST:
			case VALA_GENIE_TOKEN_TYPE_CONSTRUCT:
			case VALA_GENIE_TOKEN_TYPE_INIT:
			case VALA_GENIE_TOKEN_TYPE_DEF:
			case VALA_GENIE_TOKEN_TYPE_DELEGATE:
			case VALA_GENIE_TOKEN_TYPE_ENUM:
			case VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN:
			case VALA_GENIE_TOKEN_TYPE_FINAL:
			case VALA_GENIE_TOKEN_TYPE_INTERFACE:
			case VALA_GENIE_TOKEN_TYPE_NAMESPACE:
			case VALA_GENIE_TOKEN_TYPE_PROP:
			case VALA_GENIE_TOKEN_TYPE_EVENT:
			case VALA_GENIE_TOKEN_TYPE_STRUCT:
			{
				return VALA_GENIE_PARSER_RECOVERY_STATE_DECLARATION_BEGIN;
			}
			case VALA_GENIE_TOKEN_TYPE_BREAK:
			case VALA_GENIE_TOKEN_TYPE_CASE:
			case VALA_GENIE_TOKEN_TYPE_CONTINUE:
			case VALA_GENIE_TOKEN_TYPE_DELETE:
			case VALA_GENIE_TOKEN_TYPE_DO:
			case VALA_GENIE_TOKEN_TYPE_FOR:
			case VALA_GENIE_TOKEN_TYPE_FOREACH:
			case VALA_GENIE_TOKEN_TYPE_IF:
			case VALA_GENIE_TOKEN_TYPE_LOCK:
			case VALA_GENIE_TOKEN_TYPE_RETURN:
			case VALA_GENIE_TOKEN_TYPE_RAISE:
			case VALA_GENIE_TOKEN_TYPE_TRY:
			case VALA_GENIE_TOKEN_TYPE_VAR:
			case VALA_GENIE_TOKEN_TYPE_WHILE:
			case VALA_GENIE_TOKEN_TYPE_YIELD:
			{
				return VALA_GENIE_PARSER_RECOVERY_STATE_STATEMENT_BEGIN;
			}
			default:
			{
				vala_genie_parser_next (self);
				break;
			}
		}
	}
	return VALA_GENIE_PARSER_RECOVERY_STATE_EOF;
}


static ValaNamespace* vala_genie_parser_parse_namespace_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0_;
	ValaNamespace* _tmp1_;
	ValaNamespace* ns;
	ValaNamespace* _tmp2_;
	ValaNamespace* _result_;
	ValaNamespace* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_NAMESPACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ns = (_tmp1_ = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) ns, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) ns, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = NULL;
	_result_ = (_tmp2_ = ns, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp3_;
		ValaNamespace* _tmp5_;
		ValaNamespace* _tmp7_;
		ValaNamespace* _tmp6_;
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		sym = (_tmp4_ = (_tmp3_ = vala_unresolved_symbol_get_inner (sym), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp4_);
		_tmp5_ = NULL;
		ns = (_tmp5_ = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) _result_)), (ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL)), _tmp5_);
		vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_result_ = (_tmp7_ = (_tmp6_ = ns, (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp7_);
	}
	_tmp8_ = NULL;
	return (_tmp8_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL)), _tmp8_);
}


static void vala_genie_parser_parse_namespace_member (ValaGenieParser* self, ValaNamespace* ns, GError** error) {
	GError * _inner_error_;
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_inner_error_ = NULL;
	sym = vala_genie_parser_parse_declaration (self, ns == vala_code_context_get_root (self->priv->context), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (VALA_IS_NAMESPACE (sym)) {
		vala_namespace_add_namespace (ns, VALA_NAMESPACE (sym));
	} else {
		if (VALA_IS_CLASS (sym)) {
			vala_namespace_add_class (ns, VALA_CLASS (sym));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				vala_namespace_add_interface (ns, VALA_INTERFACE (sym));
			} else {
				if (VALA_IS_STRUCT (sym)) {
					vala_namespace_add_struct (ns, VALA_STRUCT (sym));
				} else {
					if (VALA_IS_ENUM (sym)) {
						vala_namespace_add_enum (ns, VALA_ENUM (sym));
					} else {
						if (VALA_IS_ERROR_DOMAIN (sym)) {
							vala_namespace_add_error_domain (ns, VALA_ERROR_DOMAIN (sym));
						} else {
							if (VALA_IS_DELEGATE (sym)) {
								vala_namespace_add_delegate (ns, VALA_DELEGATE (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaMethod* _tmp0_;
									ValaMethod* method;
									_tmp0_ = NULL;
									method = (_tmp0_ = VALA_METHOD (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
									if (vala_method_get_binding (method) == MEMBER_BINDING_INSTANCE) {
										vala_method_set_binding (method, MEMBER_BINDING_STATIC);
									}
									vala_namespace_add_method (ns, method);
									(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
								} else {
									if (VALA_IS_FIELD (sym)) {
										ValaField* _tmp1_;
										ValaField* field;
										_tmp1_ = NULL;
										field = (_tmp1_ = VALA_FIELD (sym), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
										if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
											vala_field_set_binding (field, MEMBER_BINDING_STATIC);
										}
										vala_namespace_add_field (ns, field);
										(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
									} else {
										if (VALA_IS_CONSTANT (sym)) {
											vala_namespace_add_constant (ns, VALA_CONSTANT (sym));
										} else {
											vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), "unexpected declaration in namespace");
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) sym);
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
}


static void vala_genie_parser_add_uses_clause (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0_;
	ValaUsingDirective* _tmp1_;
	ValaUsingDirective* ns_ref;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ns_ref = (_tmp1_ = vala_using_directive_new ((ValaSymbol*) sym, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_source_file_add_using_directive (vala_genie_scanner_get_source_file (self->priv->scanner), ns_ref);
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	(ns_ref == NULL) ? NULL : (ns_ref = (vala_code_node_unref (ns_ref), NULL));
}


static void vala_genie_parser_parse_using_directives (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_USES)) {
		if (vala_genie_parser_accept_block (self)) {
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			while (TRUE) {
				gboolean _tmp0_;
				_tmp0_ = FALSE;
				if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					_tmp0_ = vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_EOF;
				} else {
					_tmp0_ = FALSE;
				}
				if (!_tmp0_) {
					break;
				}
				vala_genie_parser_add_uses_clause (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			do {
				vala_genie_parser_add_uses_clause (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
			vala_genie_parser_expect_terminator (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static ValaSymbol* vala_genie_parser_parse_class_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* base_types;
	ValaSourceReference* _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* cl;
	char* _tmp3_;
	const char* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLASS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	base_types = gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* type1;
		type1 = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		gee_collection_add ((GeeCollection*) base_types, type1);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_IMPLEMENTS)) {
			do {
				ValaDataType* type2;
				type2 = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type1 == NULL) ? NULL : (type1 = (vala_code_node_unref (type1), NULL));
						(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
						(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
						(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
						return NULL;
					} else {
						(type1 == NULL) ? NULL : (type1 = (vala_code_node_unref (type1), NULL));
						(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
						(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
						(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				gee_collection_add ((GeeCollection*) base_types, type2);
				(type2 == NULL) ? NULL : (type2 = (vala_code_node_unref (type2), NULL));
			} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		}
		(type1 == NULL) ? NULL : (type1 = (vala_code_node_unref (type1), NULL));
	}
	vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cl = (_tmp1_ = vala_class_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		/* class must always be Public unless its name starts wtih underscore */
		if (g_utf8_get_char (g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) sym), 0)) == '_') {
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
		} else {
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		vala_class_set_is_abstract (cl, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) cl, attrs);
	{
		GeeIterator* _type_param_it;
		_type_param_it = gee_iterable_iterator ((GeeIterable*) type_param_list);
		while (gee_iterator_next (_type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) cl, type_param);
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	{
		GeeIterator* _base_type_it;
		_base_type_it = gee_iterable_iterator ((GeeIterable*) base_types);
		while (gee_iterator_next (_base_type_it)) {
			ValaDataType* base_type;
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			vala_class_add_base_type (cl, base_type);
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->priv->class_name = (_tmp3_ = (_tmp2_ = vala_symbol_get_name ((ValaSymbol*) cl), (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_)), self->priv->class_name = (g_free (self->priv->class_name), NULL), _tmp3_);
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) cl, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	if (!vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner))) {
		_tmp5_ = !vala_class_get_is_abstract (cl);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = vala_class_get_default_construction_method (cl) == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	/* ensure there is always a default construction method*/
	if (_tmp4_) {
		ValaCreationMethod* m;
		ValaBlock* _tmp6_;
		m = vala_creation_method_new (vala_symbol_get_name ((ValaSymbol*) cl), NULL, vala_code_node_get_source_reference ((ValaCodeNode*) cl));
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp6_ = NULL;
		vala_method_set_body ((ValaMethod*) m, _tmp6_ = vala_block_new (vala_code_node_get_source_reference ((ValaCodeNode*) cl)));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		vala_class_add_method (cl, (ValaMethod*) m);
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	}
	_tmp7_ = NULL;
	_result_ = (_tmp7_ = (ValaSymbol*) cl, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaNamespace* ns;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp10_;
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		sym = (_tmp9_ = (_tmp8_ = vala_unresolved_symbol_get_inner (sym), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp9_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) cl));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_class (ns, VALA_CLASS (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_result_ = (_tmp11_ = (_tmp10_ = (ValaSymbol*) ns, (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp11_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp12_ = NULL;
	return (_tmp12_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL)), (base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp12_);
}


static void vala_genie_parser_parse_class_member (ValaGenieParser* self, ValaClass* cl, GError** error) {
	GError * _inner_error_;
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_inner_error_ = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (VALA_IS_CLASS (sym)) {
		vala_class_add_class (cl, VALA_CLASS (sym));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			vala_class_add_struct (cl, VALA_STRUCT (sym));
		} else {
			if (VALA_IS_ENUM (sym)) {
				vala_class_add_enum (cl, VALA_ENUM (sym));
			} else {
				if (VALA_IS_DELEGATE (sym)) {
					vala_class_add_delegate (cl, VALA_DELEGATE (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_class_add_method (cl, VALA_METHOD (sym));
					} else {
						if (VALA_IS_SIGNAL (sym)) {
							vala_class_add_signal (cl, VALA_SIGNAL (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_class_add_field (cl, VALA_FIELD (sym));
							} else {
								if (VALA_IS_CONSTANT (sym)) {
									vala_class_add_constant (cl, VALA_CONSTANT (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_class_add_property (cl, VALA_PROPERTY (sym));
									} else {
										if (VALA_IS_CONSTRUCTOR (sym)) {
											ValaConstructor* _tmp0_;
											ValaConstructor* c;
											_tmp0_ = NULL;
											c = (_tmp0_ = VALA_CONSTRUCTOR (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
											if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
												vala_class_set_constructor (cl, c);
											} else {
												if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
													vala_class_set_class_constructor (cl, c);
												} else {
													vala_class_set_static_constructor (cl, c);
												}
											}
											(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
										} else {
											if (VALA_IS_DESTRUCTOR (sym)) {
												ValaDestructor* _tmp1_;
												ValaDestructor* d;
												_tmp1_ = NULL;
												d = (_tmp1_ = VALA_DESTRUCTOR (sym), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
												if (vala_destructor_get_binding (d) == MEMBER_BINDING_STATIC) {
													vala_class_set_static_destructor (cl, VALA_DESTRUCTOR (d));
												} else {
													if (vala_destructor_get_binding (d) == MEMBER_BINDING_CLASS) {
														vala_class_set_class_destructor (cl, VALA_DESTRUCTOR (d));
													} else {
														vala_class_set_destructor (cl, VALA_DESTRUCTOR (d));
													}
												}
												(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
											} else {
												vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), "unexpected declaration in class");
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
}


static ValaConstant* vala_genie_parser_parse_constant_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	char* id;
	ValaDataType* type;
	ValaExpression* initializer;
	ValaArrayType* _tmp3_;
	ValaDataType* _tmp2_;
	ValaArrayType* array_type;
	ValaSourceReference* _tmp4_;
	ValaConstant* _tmp5_;
	ValaConstant* c;
	gboolean _tmp6_;
	ValaConstant* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONST, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = vala_genie_parser_parse_type (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	initializer = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp0_;
		ValaExpression* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		initializer = (_tmp1_ = _tmp0_, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), _tmp1_);
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			return NULL;
		} else {
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	/* constant arrays don't own their element*/
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	array_type = (_tmp3_ = (_tmp2_ = type, VALA_IS_ARRAY_TYPE (_tmp2_) ? ((ValaArrayType*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	if (array_type != NULL) {
		vala_data_type_set_value_owned (vala_array_type_get_element_type (array_type), FALSE);
	}
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	c = (_tmp5_ = vala_constant_new (id, type, initializer, _tmp4_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL)), _tmp5_);
	vala_symbol_set_access ((ValaSymbol*) c, vala_genie_parser_get_access (self, id));
	_tmp6_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp6_) {
		vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		vala_member_set_hides ((ValaMember*) c, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) c, attrs);
	_tmp7_ = NULL;
	return (_tmp7_ = c, id = (g_free (id), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), (array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)), _tmp7_);
}


static ValaField* vala_genie_parser_parse_field_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	char* id;
	ValaGenieParserModifierFlags flags;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaField* _tmp1_;
	ValaField* f;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaField* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	f = (_tmp1_ = vala_field_new (id, type, NULL, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = FALSE;
	_tmp3_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = (flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
	}
	if (_tmp2_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "abstract, virtual, and override modifiers are not applicable to fields");
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) f, vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) f, attrs);
	_tmp4_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp4_) {
		vala_symbol_set_external ((ValaSymbol*) f, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		vala_member_set_hides ((ValaMember*) f, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp6_ = NULL;
		vala_field_set_initializer (f, _tmp6_ = _tmp5_);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		vala_field_set_binding (f, MEMBER_BINDING_STATIC);
	} else {
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			vala_field_set_binding (f, MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			return NULL;
		} else {
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = NULL;
	return (_tmp7_ = f, id = (g_free (id), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7_);
}


static ValaInitializerList* vala_genie_parser_parse_initializer (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaInitializerList* _tmp1_;
	ValaInitializerList* initializer;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	initializer = (_tmp1_ = vala_initializer_list_new (_tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
		do {
			ValaExpression* init;
			init = vala_genie_parser_parse_argument (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					return NULL;
				} else {
					(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			vala_initializer_list_append (initializer, init);
			(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				return NULL;
			} else {
				(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	return initializer;
}


static ValaMethod* vala_genie_parser_parse_main_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	char* id;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* method;
	ValaSourceReference* _tmp2_;
	ValaUnresolvedSymbol* _tmp3_;
	ValaUnresolvedSymbol* sym;
	ValaDataType* _tmp5_;
	ValaSourceReference* _tmp4_;
	ValaDataType* _tmp7_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* _tmp8_;
	ValaFormalParameter* _tmp9_;
	ValaFormalParameter* param;
	ValaMethod* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	id = g_strdup ("main");
	begin = vala_genie_parser_get_location (self);
	type = (ValaDataType*) vala_void_type_new (NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	method = (_tmp1_ = vala_method_new (id, type, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_symbol_set_access ((ValaSymbol*) method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) method, attrs);
	vala_method_set_binding (method, MEMBER_BINDING_STATIC);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	sym = (_tmp3_ = vala_unresolved_symbol_new (NULL, "string", _tmp2_ = vala_genie_parser_get_src (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	type = (_tmp5_ = (ValaDataType*) vala_unresolved_type_new_from_symbol (sym, _tmp4_ = vala_genie_parser_get_src (self, &begin)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
	vala_data_type_set_value_owned (type, TRUE);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	type = (_tmp7_ = (ValaDataType*) vala_array_type_new (type, 1, _tmp6_ = vala_genie_parser_get_src (self, &begin)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7_);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
	vala_data_type_set_nullable (type, FALSE);
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	param = (_tmp9_ = vala_formal_parameter_new ("args", type, _tmp8_ = vala_genie_parser_get_src (self, &begin)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_source_reference_unref (_tmp8_), NULL)), _tmp9_);
	vala_method_add_parameter (method, param);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			return NULL;
		} else {
			id = (g_free (id), NULL);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		_tmp10_ = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp11_ = NULL;
		vala_method_set_body (method, _tmp11_ = _tmp10_);
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_code_node_unref (_tmp11_), NULL));
	}
	_tmp12_ = NULL;
	return (_tmp12_ = method, id = (g_free (id), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp12_);
}


static ValaMethod* vala_genie_parser_parse_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	char* id;
	GeeArrayList* params;
	ValaSourceReference* _tmp3_;
	ValaMethod* _tmp4_;
	ValaMethod* method;
	gboolean _tmp7_;
	ValaSourceLocation body_location;
	ValaMethod* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	type = (ValaDataType*) vala_void_type_new (NULL);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			gee_collection_add ((GeeCollection*) params, param);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	/* deal with return value */
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0_;
		ValaDataType* _tmp1_;
		GeeList* _tmp2_;
		_tmp0_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		type = (_tmp1_ = _tmp0_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1_);
		_tmp2_ = NULL;
		_tmp2_ = vala_genie_parser_parse_type_parameter_list (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL));
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	method = (_tmp4_ = vala_method_new (id, type, _tmp3_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) method, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) method, vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) method, attrs);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_method_add_parameter (method, param);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_YIELDS)) {
		vala_method_set_coroutine (method, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp5_;
			ValaDataType* _tmp6_;
			_tmp5_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = NULL;
			vala_code_node_add_error_type ((ValaCodeNode*) method, _tmp6_ = _tmp5_);
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	_tmp7_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = _vala_strcmp0 (id, "main") == 0;
	}
	if (_tmp7_) {
		vala_method_set_binding (method, MEMBER_BINDING_STATIC);
	} else {
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			vala_method_set_binding (method, MEMBER_BINDING_CLASS);
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		vala_member_set_hides ((ValaMember*) method, TRUE);
	}
	if (vala_method_get_binding (method) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			vala_method_set_is_abstract (method, TRUE);
		}
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
			vala_method_set_is_virtual (method, TRUE);
		}
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) {
			vala_method_set_overrides (method, TRUE);
		}
		_tmp8_ = FALSE;
		_tmp9_ = FALSE;
		_tmp10_ = FALSE;
		if (vala_method_get_is_abstract (method)) {
			_tmp10_ = vala_method_get_is_virtual (method);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gboolean _tmp11_;
			_tmp11_ = FALSE;
			if (vala_method_get_is_abstract (method)) {
				_tmp11_ = vala_method_get_overrides (method);
			} else {
				_tmp11_ = FALSE;
			}
			_tmp9_ = _tmp11_;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp12_;
			_tmp12_ = FALSE;
			if (vala_method_get_is_virtual (method)) {
				_tmp12_ = vala_method_get_overrides (method);
			} else {
				_tmp12_ = FALSE;
			}
			_tmp8_ = _tmp12_;
		}
		if (_tmp8_) {
			char* _tmp13_;
			GError* _tmp14_;
			_tmp13_ = NULL;
			_tmp14_ = NULL;
			_inner_error_ = (_tmp14_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp13_ = vala_genie_parser_get_error (self, "only one of `abstract', `virtual', or `override' may be specified")), _tmp13_ = (g_free (_tmp13_), NULL), _tmp14_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} else {
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = FALSE;
		_tmp16_ = FALSE;
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = (flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = (flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
		}
		if (_tmp15_) {
			char* _tmp17_;
			GError* _tmp18_;
			_tmp17_ = NULL;
			_tmp18_ = NULL;
			_inner_error_ = (_tmp18_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp17_ = vala_genie_parser_get_error (self, "the modifiers `abstract', `virtual', and `override' are not valid for static methods")), _tmp17_ = (g_free (_tmp17_), NULL), _tmp18_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE) {
		vala_method_set_is_inline (method, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		vala_symbol_set_external ((ValaSymbol*) method, TRUE);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	body_location = vala_genie_parser_get_location (self);
	/* "requires" and "ensures" if present will be at  start of the method body */
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT)) {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REQUIRES)) {
			gboolean _tmp19_;
			_tmp19_ = FALSE;
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
				_tmp19_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					ValaExpression* _tmp20_;
					ValaExpression* _tmp21_;
					_tmp20_ = vala_genie_parser_parse_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							return NULL;
						} else {
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp21_ = NULL;
					vala_method_add_precondition (method, _tmp21_ = _tmp20_);
					(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_code_node_unref (_tmp21_), NULL));
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							return NULL;
						} else {
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp22_ = vala_genie_parser_parse_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp23_ = NULL;
				vala_method_add_precondition (method, _tmp23_ = _tmp22_);
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_code_node_unref (_tmp23_), NULL));
				vala_genie_parser_expect_terminator (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ENSURES)) {
			gboolean _tmp24_;
			_tmp24_ = FALSE;
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
				_tmp24_ = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_INDENT);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
					ValaExpression* _tmp25_;
					ValaExpression* _tmp26_;
					_tmp25_ = vala_genie_parser_parse_expression (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							return NULL;
						} else {
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp26_ = NULL;
					vala_method_add_postcondition (method, _tmp26_ = _tmp25_);
					(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_code_node_unref (_tmp26_), NULL));
					vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							return NULL;
						} else {
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							id = (g_free (id), NULL);
							(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
							(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				vala_genie_parser_accept_terminator (self);
			} else {
				ValaExpression* _tmp27_;
				ValaExpression* _tmp28_;
				_tmp27_ = vala_genie_parser_parse_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp28_ = NULL;
				vala_method_add_postcondition (method, _tmp28_ = _tmp27_);
				(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_code_node_unref (_tmp28_), NULL));
				vala_genie_parser_expect_terminator (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == VALA_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						return NULL;
					} else {
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						id = (g_free (id), NULL);
						(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
						(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	vala_genie_parser_rollback (self, &body_location);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp29_;
		ValaBlock* _tmp30_;
		_tmp29_ = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp30_ = NULL;
		vala_method_set_body (method, _tmp30_ = _tmp29_);
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_code_node_unref (_tmp30_), NULL));
	} else {
		if (vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner))) {
			vala_symbol_set_external ((ValaSymbol*) method, TRUE);
		}
	}
	_tmp31_ = NULL;
	return (_tmp31_ = method, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), id = (g_free (id), NULL), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp31_);
}


static ValaProperty* vala_genie_parser_parse_property_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	gboolean readonly;
	ValaGenieParserModifierFlags flags;
	char* id;
	ValaDataType* type;
	ValaSourceReference* _tmp0_;
	ValaProperty* _tmp1_;
	ValaProperty* prop;
	gboolean _tmp2_;
	gboolean _tmp26_;
	ValaProperty* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	readonly = FALSE;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_PROP, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	readonly = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_READONLY);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = vala_genie_parser_parse_type (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			id = (g_free (id), NULL);
			return NULL;
		} else {
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	prop = (_tmp1_ = vala_property_new (id, type, NULL, NULL, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) prop, vala_genie_parser_get_access (self, id));
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) prop, attrs);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		vala_property_set_binding (prop, MEMBER_BINDING_STATIC);
	} else {
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			vala_property_set_binding (prop, MEMBER_BINDING_CLASS);
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) == VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT) {
		vala_property_set_is_abstract (prop, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		vala_property_set_is_virtual (prop, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE) {
		vala_property_set_overrides (prop, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		vala_member_set_hides ((ValaMember*) prop, TRUE);
	}
	_tmp2_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp2_) {
		vala_symbol_set_external ((ValaSymbol*) prop, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = NULL;
		vala_property_set_default_expression (prop, _tmp4_ = _tmp3_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_code_node_unref (_tmp4_), NULL));
	}
	if (vala_genie_parser_accept_block (self)) {
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		while (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_DEDENT) {
			ValaSourceLocation accessor_begin;
			GeeList* attribs;
			ValaDataType* value_type;
			accessor_begin = vala_genie_parser_get_location (self);
			attribs = vala_genie_parser_parse_attributes (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					id = (g_free (id), NULL);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					return NULL;
				} else {
					id = (g_free (id), NULL);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			value_type = vala_data_type_copy (type);
			vala_data_type_set_value_owned (value_type, vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OWNED));
			if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_GET)) {
				ValaBlock* block;
				ValaPropertyAccessor* _tmp10_;
				ValaSourceReference* _tmp9_;
				if (vala_property_get_get_accessor (prop) != NULL) {
					char* _tmp5_;
					GError* _tmp6_;
					_tmp5_ = NULL;
					_tmp6_ = NULL;
					_inner_error_ = (_tmp6_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp5_ = vala_genie_parser_get_error (self, "property get accessor already defined")), _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							return NULL;
						} else {
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp7_;
					ValaBlock* _tmp8_;
					_tmp7_ = vala_genie_parser_parse_block (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							return NULL;
						} else {
							(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp8_ = NULL;
					block = (_tmp8_ = _tmp7_, (block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL)), _tmp8_);
					vala_symbol_set_external ((ValaSymbol*) prop, FALSE);
				}
				_tmp10_ = NULL;
				_tmp9_ = NULL;
				vala_property_set_get_accessor (prop, _tmp10_ = vala_property_accessor_new (TRUE, FALSE, FALSE, value_type, block, _tmp9_ = vala_genie_parser_get_src (self, &accessor_begin)));
				(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_code_node_unref (_tmp10_), NULL));
				(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_source_reference_unref (_tmp9_), NULL));
				vala_genie_parser_set_attributes (self, (ValaCodeNode*) vala_property_get_get_accessor (prop), attribs);
				vala_property_accessor_set_access (vala_property_get_get_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			} else {
				gboolean _construct;
				ValaBlock* block;
				ValaPropertyAccessor* _tmp20_;
				ValaSourceReference* _tmp19_;
				_construct = FALSE;
				if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_SET)) {
					if (readonly) {
						char* _tmp11_;
						GError* _tmp12_;
						_tmp11_ = NULL;
						_tmp12_ = NULL;
						_inner_error_ = (_tmp12_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp11_ = vala_genie_parser_get_error (self, "set block not allowed for a read only property")), _tmp11_ = (g_free (_tmp11_), NULL), _tmp12_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == VALA_PARSE_ERROR) {
								g_propagate_error (error, _inner_error_);
								(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
								(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
								id = (g_free (id), NULL);
								(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								return NULL;
							} else {
								(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
								(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
								id = (g_free (id), NULL);
								(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
					_construct = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT);
				} else {
					if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT)) {
						_construct = TRUE;
					} else {
						if (!vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL)) {
							char* _tmp13_;
							GError* _tmp14_;
							_tmp13_ = NULL;
							_tmp14_ = NULL;
							_inner_error_ = (_tmp14_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp13_ = vala_genie_parser_get_error (self, "expected get, set, or construct")), _tmp13_ = (g_free (_tmp13_), NULL), _tmp14_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == VALA_PARSE_ERROR) {
									g_propagate_error (error, _inner_error_);
									(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
									(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
									id = (g_free (id), NULL);
									(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									return NULL;
								} else {
									(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
									(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
									id = (g_free (id), NULL);
									(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
						}
					}
				}
				if (vala_property_get_set_accessor (prop) != NULL) {
					char* _tmp15_;
					GError* _tmp16_;
					_tmp15_ = NULL;
					_tmp16_ = NULL;
					_inner_error_ = (_tmp16_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp15_ = vala_genie_parser_get_error (self, "property set accessor already defined")), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							return NULL;
						} else {
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				block = NULL;
				if (vala_genie_parser_accept_block (self)) {
					ValaBlock* _tmp17_;
					ValaBlock* _tmp18_;
					_tmp17_ = vala_genie_parser_parse_block (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							return NULL;
						} else {
							(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
							(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
							(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
							id = (g_free (id), NULL);
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp18_ = NULL;
					block = (_tmp18_ = _tmp17_, (block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL)), _tmp18_);
					vala_symbol_set_external ((ValaSymbol*) prop, FALSE);
				}
				_tmp20_ = NULL;
				_tmp19_ = NULL;
				vala_property_set_set_accessor (prop, _tmp20_ = vala_property_accessor_new (FALSE, !readonly, _construct, value_type, block, _tmp19_ = vala_genie_parser_get_src (self, &accessor_begin)));
				(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_code_node_unref (_tmp20_), NULL));
				(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_source_reference_unref (_tmp19_), NULL));
				vala_genie_parser_set_attributes (self, (ValaCodeNode*) vala_property_get_set_accessor (prop), attribs);
				vala_property_accessor_set_access (vala_property_get_set_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
			}
			(attribs == NULL) ? NULL : (attribs = (gee_collection_object_unref (attribs), NULL));
			(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
		}
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		ValaDataType* value_type;
		ValaPropertyAccessor* _tmp22_;
		ValaSourceReference* _tmp21_;
		value_type = vala_data_type_copy (type);
		vala_data_type_set_value_owned (value_type, FALSE);
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		vala_property_set_get_accessor (prop, _tmp22_ = vala_property_accessor_new (TRUE, FALSE, FALSE, value_type, NULL, _tmp21_ = vala_genie_parser_get_src (self, &begin)));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_code_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_source_reference_unref (_tmp21_), NULL));
		vala_property_accessor_set_access (vala_property_get_get_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		if (!readonly) {
			ValaDataType* _tmp23_;
			ValaPropertyAccessor* _tmp25_;
			ValaSourceReference* _tmp24_;
			_tmp23_ = NULL;
			value_type = (_tmp23_ = vala_data_type_copy (type), (value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)), _tmp23_);
			vala_data_type_set_value_owned (value_type, FALSE);
			_tmp25_ = NULL;
			_tmp24_ = NULL;
			vala_property_set_set_accessor (prop, _tmp25_ = vala_property_accessor_new (FALSE, TRUE, FALSE, value_type, NULL, _tmp24_ = vala_genie_parser_get_src (self, &begin)));
			(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_code_node_unref (_tmp25_), NULL));
			(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_source_reference_unref (_tmp24_), NULL));
			vala_property_accessor_set_access (vala_property_get_set_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		}
		vala_genie_parser_expect_terminator (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				return NULL;
			} else {
				(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
	}
	_tmp26_ = FALSE;
	if (!vala_property_get_is_abstract (prop)) {
		_tmp26_ = !vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		gboolean _tmp27_;
		gboolean needs_var;
		_tmp27_ = FALSE;
		if (readonly) {
			gboolean _tmp28_;
			_tmp28_ = FALSE;
			if (vala_property_get_get_accessor (prop) != NULL) {
				_tmp28_ = vala_property_accessor_get_body (vala_property_get_get_accessor (prop)) == NULL;
			} else {
				_tmp28_ = FALSE;
			}
			_tmp27_ = _tmp28_;
		} else {
			_tmp27_ = FALSE;
		}
		needs_var = _tmp27_;
		if (!needs_var) {
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp29_ = FALSE;
			_tmp30_ = FALSE;
			if (vala_property_get_get_accessor (prop) != NULL) {
				_tmp30_ = vala_property_accessor_get_body (vala_property_get_get_accessor (prop)) == NULL;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				_tmp29_ = TRUE;
			} else {
				gboolean _tmp31_;
				_tmp31_ = FALSE;
				if (vala_property_get_set_accessor (prop) != NULL) {
					_tmp31_ = vala_property_accessor_get_body (vala_property_get_set_accessor (prop)) == NULL;
				} else {
					_tmp31_ = FALSE;
				}
				_tmp29_ = _tmp31_;
			}
			needs_var = _tmp29_;
		}
		if (needs_var) {
			ValaDataType* field_type;
			ValaField* _tmp33_;
			char* _tmp32_;
			/* automatic property accessor body generation */
			field_type = vala_data_type_copy (vala_property_get_property_type (prop));
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			vala_property_set_field (prop, _tmp33_ = vala_field_new (_tmp32_ = g_strdup_printf ("_%s", vala_symbol_get_name ((ValaSymbol*) prop)), field_type, vala_property_get_default_expression (prop), vala_code_node_get_source_reference ((ValaCodeNode*) prop)));
			(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_code_node_unref (_tmp33_), NULL));
			_tmp32_ = (g_free (_tmp32_), NULL);
			vala_symbol_set_access ((ValaSymbol*) vala_property_get_field (prop), VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
			(field_type == NULL) ? NULL : (field_type = (vala_code_node_unref (field_type), NULL));
		}
	}
	_tmp34_ = NULL;
	return (_tmp34_ = prop, id = (g_free (id), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp34_);
}


static ValaSignal* vala_genie_parser_parse_signal_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	char* id;
	GeeArrayList* params;
	ValaSourceReference* _tmp3_;
	ValaSignal* _tmp4_;
	ValaSignal* sig;
	ValaSignal* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EVENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					id = (g_free (id), NULL);
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			gee_collection_add ((GeeCollection*) params, param);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0_;
		ValaDataType* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				id = (g_free (id), NULL);
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		type = (_tmp1_ = _tmp0_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1_);
	} else {
		ValaDataType* _tmp2_;
		_tmp2_ = NULL;
		type = (_tmp2_ = (ValaDataType*) vala_void_type_new (NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2_);
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	sig = (_tmp4_ = vala_signal_new (id, type, _tmp3_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) sig, vala_genie_parser_get_access (self, id));
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) == VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL) {
		vala_signal_set_is_virtual (sig, TRUE);
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		vala_member_set_hides ((ValaMember*) sig, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) sig, attrs);
	{
		GeeIterator* _formal_param_it;
		_formal_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_formal_param_it)) {
			ValaFormalParameter* formal_param;
			formal_param = (ValaFormalParameter*) gee_iterator_get (_formal_param_it);
			vala_signal_add_parameter (sig, formal_param);
			(formal_param == NULL) ? NULL : (formal_param = (vala_code_node_unref (formal_param), NULL));
		}
		(_formal_param_it == NULL) ? NULL : (_formal_param_it = (gee_collection_object_unref (_formal_param_it), NULL));
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			id = (g_free (id), NULL);
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = NULL;
	return (_tmp5_ = sig, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), id = (g_free (id), NULL), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp5_);
}


static ValaConstructor* vala_genie_parser_parse_constructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaSourceReference* _tmp0_;
	ValaConstructor* _tmp1_;
	ValaConstructor* c;
	ValaBlock* _tmp2_;
	ValaBlock* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INIT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	c = (_tmp1_ = vala_constructor_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) {
		vala_constructor_set_binding (c, MEMBER_BINDING_STATIC);
	} else {
		if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) == VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS) {
			vala_constructor_set_binding (c, MEMBER_BINDING_CLASS);
		}
	}
	vala_genie_parser_accept_block (self);
	_tmp2_ = vala_genie_parser_parse_block (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
			return NULL;
		} else {
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	vala_constructor_set_body (c, _tmp3_ = _tmp2_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL));
	return c;
}


static ValaDestructor* vala_genie_parser_parse_destructor_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaSourceReference* _tmp0_;
	ValaDestructor* _tmp1_;
	ValaDestructor* d;
	ValaBlock* _tmp2_;
	ValaBlock* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_FINAL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	d = (_tmp1_ = vala_destructor_new (_tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	vala_genie_parser_accept_block (self);
	_tmp2_ = vala_genie_parser_parse_block (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			return NULL;
		} else {
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	vala_destructor_set_body (d, _tmp3_ = _tmp2_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL));
	return d;
}


static ValaSymbol* vala_genie_parser_parse_struct_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	ValaDataType* base_type;
	ValaSourceReference* _tmp2_;
	ValaStruct* _tmp3_;
	ValaStruct* st;
	ValaSymbol* _tmp4_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_STRUCT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	base_type = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp0_;
		ValaDataType* _tmp1_;
		_tmp0_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		base_type = (_tmp1_ = _tmp0_, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp1_);
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	st = (_tmp3_ = vala_struct_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp2_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) st, vala_genie_parser_get_access (self, vala_symbol_get_name ((ValaSymbol*) sym)));
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) st, attrs);
	{
		GeeIterator* _type_param_it;
		_type_param_it = gee_iterable_iterator ((GeeIterable*) type_param_list);
		while (gee_iterator_next (_type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			vala_struct_add_type_parameter (st, type_param);
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	if (base_type != NULL) {
		vala_struct_set_base_type (st, base_type);
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) st, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = NULL;
	_result_ = (_tmp4_ = (ValaSymbol*) st, (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaNamespace* ns;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp7_;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		sym = (_tmp6_ = (_tmp5_ = vala_unresolved_symbol_get_inner (sym), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp6_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) st));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_struct (ns, VALA_STRUCT (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		_result_ = (_tmp8_ = (_tmp7_ = (ValaSymbol*) ns, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp8_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp9_ = NULL;
	return (_tmp9_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp9_);
}


static void vala_genie_parser_parse_struct_member (ValaGenieParser* self, ValaStruct* st, GError** error) {
	GError * _inner_error_;
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_inner_error_ = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (VALA_IS_METHOD (sym)) {
		vala_struct_add_method (st, VALA_METHOD (sym));
	} else {
		if (VALA_IS_FIELD (sym)) {
			vala_struct_add_field (st, VALA_FIELD (sym));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				vala_struct_add_constant (st, VALA_CONSTANT (sym));
			} else {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), "unexpected declaration in struct");
			}
		}
	}
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
}


static ValaSymbol* vala_genie_parser_parse_interface_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* base_types;
	ValaSourceReference* _tmp0_;
	ValaInterface* _tmp1_;
	ValaInterface* iface;
	gboolean _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INTERFACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	base_types = gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		do {
			ValaDataType* type;
			type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
					return NULL;
				} else {
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			gee_collection_add ((GeeCollection*) base_types, type);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	iface = (_tmp1_ = vala_interface_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) iface, vala_genie_parser_get_access (self, vala_symbol_get_name ((ValaSymbol*) sym)));
	}
	_tmp2_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp2_) {
		vala_symbol_set_external ((ValaSymbol*) iface, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) iface, attrs);
	{
		GeeIterator* _type_param_it;
		_type_param_it = gee_iterable_iterator ((GeeIterable*) type_param_list);
		while (gee_iterator_next (_type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) iface, type_param);
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	{
		GeeIterator* _base_type_it;
		_base_type_it = gee_iterable_iterator ((GeeIterable*) base_types);
		while (gee_iterator_next (_base_type_it)) {
			ValaDataType* base_type;
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			vala_interface_add_prerequisite (iface, base_type);
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_parse_declarations (self, (ValaSymbol*) iface, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = NULL;
	_result_ = (_tmp3_ = (ValaSymbol*) iface, (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaNamespace* ns;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp6_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		sym = (_tmp5_ = (_tmp4_ = vala_unresolved_symbol_get_inner (sym), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp5_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) iface));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_interface (ns, VALA_INTERFACE (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_result_ = (_tmp7_ = (_tmp6_ = (ValaSymbol*) ns, (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp7_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp8_ = NULL;
	return (_tmp8_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL)), (base_types == NULL) ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp8_);
}


static void vala_genie_parser_parse_interface_member (ValaGenieParser* self, ValaInterface* iface, GError** error) {
	GError * _inner_error_;
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_inner_error_ = NULL;
	sym = vala_genie_parser_parse_declaration (self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (VALA_IS_CLASS (sym)) {
		vala_interface_add_class (iface, VALA_CLASS (sym));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			vala_interface_add_struct (iface, VALA_STRUCT (sym));
		} else {
			if (VALA_IS_ENUM (sym)) {
				vala_interface_add_enum (iface, VALA_ENUM (sym));
			} else {
				if (VALA_IS_DELEGATE (sym)) {
					vala_interface_add_delegate (iface, VALA_DELEGATE (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_interface_add_method (iface, VALA_METHOD (sym));
					} else {
						if (VALA_IS_SIGNAL (sym)) {
							vala_interface_add_signal (iface, VALA_SIGNAL (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_interface_add_field (iface, VALA_FIELD (sym));
							} else {
								if (VALA_IS_PROPERTY (sym)) {
									vala_interface_add_property (iface, VALA_PROPERTY (sym));
								} else {
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), "unexpected declaration in interface");
								}
							}
						}
					}
				}
			}
		}
	}
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
}


static ValaSymbol* vala_genie_parser_parse_enum_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0_;
	ValaEnum* _tmp1_;
	ValaEnum* en;
	gboolean _tmp2_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ENUM, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	en = (_tmp1_ = vala_enum_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) en, vala_genie_parser_get_access (self, vala_symbol_get_name ((ValaSymbol*) sym)));
	}
	_tmp2_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp2_) {
		vala_symbol_set_external ((ValaSymbol*) en, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) en, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	do {
		GeeList* value_attrs;
		ValaSourceLocation value_begin;
		char* id;
		ValaSourceReference* _tmp3_;
		ValaEnumValue* _tmp4_;
		ValaEnumValue* ev;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			/* allow trailing comma*/
			break;
		}
		value_attrs = vala_genie_parser_parse_attributes (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		value_begin = vala_genie_parser_get_location (self);
		id = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				return NULL;
			} else {
				(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		ev = (_tmp4_ = vala_enum_value_new (id, _tmp3_ = vala_genie_parser_get_src (self, &value_begin)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_source_reference_unref (_tmp3_), NULL)), _tmp4_);
		vala_genie_parser_set_attributes (self, (ValaCodeNode*) ev, value_attrs);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp5_;
			ValaExpression* _tmp6_;
			_tmp5_ = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
					id = (g_free (id), NULL);
					(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
					return NULL;
				} else {
					(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
					id = (g_free (id), NULL);
					(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp6_ = NULL;
			vala_enum_value_set_value (ev, _tmp6_ = _tmp5_);
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		}
		vala_enum_add_value (en, ev);
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
				id = (g_free (id), NULL);
				(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				return NULL;
			} else {
				(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
				id = (g_free (id), NULL);
				(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		(value_attrs == NULL) ? NULL : (value_attrs = (gee_collection_object_unref (value_attrs), NULL));
		id = (g_free (id), NULL);
		(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
	} while (TRUE);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = NULL;
	_result_ = (_tmp7_ = (ValaSymbol*) en, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaNamespace* ns;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp10_;
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		sym = (_tmp9_ = (_tmp8_ = vala_unresolved_symbol_get_inner (sym), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp9_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) en));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_enum (ns, VALA_ENUM (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_result_ = (_tmp11_ = (_tmp10_ = (ValaSymbol*) ns, (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp11_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp12_ = NULL;
	return (_tmp12_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL)), _tmp12_);
}


static ValaSymbol* vala_genie_parser_parse_errordomain_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	ValaSourceReference* _tmp0_;
	ValaErrorDomain* _tmp1_;
	ValaErrorDomain* ed;
	ValaSymbol* _tmp6_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_type_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ed = (_tmp1_ = vala_error_domain_new (vala_symbol_get_name ((ValaSymbol*) sym), _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_);
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) ed, vala_genie_parser_get_access (self, vala_symbol_get_name ((ValaSymbol*) sym)));
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) ed, attrs);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_EOL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_INDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	do {
		GeeList* code_attrs;
		ValaSourceLocation code_begin;
		char* id;
		ValaSourceReference* _tmp2_;
		ValaErrorCode* _tmp3_;
		ValaErrorCode* ec;
		if (vala_genie_parser_current (self) == VALA_GENIE_TOKEN_TYPE_DEDENT) {
			/* allow trailing comma*/
			break;
		}
		code_attrs = vala_genie_parser_parse_attributes (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		code_begin = vala_genie_parser_get_location (self);
		id = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(code_attrs == NULL) ? NULL : (code_attrs = (gee_collection_object_unref (code_attrs), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
				return NULL;
			} else {
				(code_attrs == NULL) ? NULL : (code_attrs = (gee_collection_object_unref (code_attrs), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		ec = (_tmp3_ = vala_error_code_new (id, _tmp2_ = vala_genie_parser_get_src (self, &code_begin)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL)), _tmp3_);
		vala_genie_parser_set_attributes (self, (ValaCodeNode*) ec, code_attrs);
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			_tmp4_ = vala_genie_parser_parse_expression (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(code_attrs == NULL) ? NULL : (code_attrs = (gee_collection_object_unref (code_attrs), NULL));
					id = (g_free (id), NULL);
					(ec == NULL) ? NULL : (ec = (vala_code_node_unref (ec), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
					return NULL;
				} else {
					(code_attrs == NULL) ? NULL : (code_attrs = (gee_collection_object_unref (code_attrs), NULL));
					id = (g_free (id), NULL);
					(ec == NULL) ? NULL : (ec = (vala_code_node_unref (ec), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp5_ = NULL;
			vala_error_code_set_value (ec, _tmp5_ = _tmp4_);
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		}
		vala_error_domain_add_code (ed, ec);
		vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_EOL);
		(code_attrs == NULL) ? NULL : (code_attrs = (gee_collection_object_unref (code_attrs), NULL));
		id = (g_free (id), NULL);
		(ec == NULL) ? NULL : (ec = (vala_code_node_unref (ec), NULL));
	} while (TRUE);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DEDENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			return NULL;
		} else {
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = NULL;
	_result_ = (_tmp6_ = (ValaSymbol*) ed, (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaNamespace* ns;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp9_;
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		sym = (_tmp8_ = (_tmp7_ = vala_unresolved_symbol_get_inner (sym), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp8_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) ed));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_error_domain (ns, VALA_ERROR_DOMAIN (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		_result_ = (_tmp10_ = (_tmp9_ = (ValaSymbol*) ns, (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp10_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp11_ = NULL;
	return (_tmp11_ = _result_, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (ed == NULL) ? NULL : (ed = (vala_code_node_unref (ed), NULL)), _tmp11_);
}


static ValaGenieParserModifierFlags vala_genie_parser_parse_type_declaration_modifiers (ValaGenieParser* self) {
	ValaGenieParserModifierFlags flags;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_EXTERN:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_STATIC:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PRIVATE:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE;
				break;
			}
			default:
			{
				return flags;
			}
		}
	}
}


static ValaGenieParserModifierFlags vala_genie_parser_parse_member_declaration_modifiers (ValaGenieParser* self) {
	ValaGenieParserModifierFlags flags;
	g_return_val_if_fail (self != NULL, 0);
	flags = 0;
	while (TRUE) {
		switch (vala_genie_parser_current (self)) {
			case VALA_GENIE_TOKEN_TYPE_ABSTRACT:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_ABSTRACT;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_CLASS:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_CLASS;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_EXTERN:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_INLINE:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_INLINE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_NEW:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_OVERRIDE:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_OVERRIDE;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_STATIC:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_VIRTUAL:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_VIRTUAL;
				break;
			}
			case VALA_GENIE_TOKEN_TYPE_PRIVATE:
			{
				vala_genie_parser_next (self);
				flags = flags | VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE;
				break;
			}
			default:
			{
				return flags;
			}
		}
	}
}


static ValaFormalParameter* vala_genie_parser_parse_parameter (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeList* attrs;
	ValaSourceLocation begin;
	gboolean params_array;
	ValaParameterDirection direction;
	char* id;
	ValaDataType* type;
	ValaSourceReference* _tmp7_;
	ValaFormalParameter* _tmp8_;
	ValaFormalParameter* param;
	ValaFormalParameter* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	attrs = vala_genie_parser_parse_attributes (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ELLIPSIS)) {
		ValaSourceReference* _tmp0_;
		ValaFormalParameter* _tmp1_;
		ValaFormalParameter* _tmp2_;
		/* varargs*/
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		return (_tmp2_ = (_tmp1_ = vala_formal_parameter_new_with_ellipsis (_tmp0_ = vala_genie_parser_get_src (self, &begin)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL)), _tmp1_), (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), _tmp2_);
	}
	params_array = vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_PARAMS);
	direction = VALA_PARAMETER_DIRECTION_IN;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OUT)) {
		direction = VALA_PARAMETER_DIRECTION_OUT;
	} else {
		if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_REF)) {
			direction = VALA_PARAMETER_DIRECTION_REF;
		}
	}
	id = vala_genie_parser_parse_identifier (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			return NULL;
		} else {
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_COLON, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			id = (g_free (id), NULL);
			return NULL;
		} else {
			(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
			id = (g_free (id), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type = NULL;
	if (direction == VALA_PARAMETER_DIRECTION_IN) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_genie_parser_parse_type (self, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				return NULL;
			} else {
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp4_ = NULL;
		type = (_tmp4_ = _tmp3_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4_);
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp5_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				return NULL;
			} else {
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp6_ = NULL;
		type = (_tmp6_ = _tmp5_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp6_);
	}
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	param = (_tmp8_ = vala_formal_parameter_new (id, type, _tmp7_ = vala_genie_parser_get_src (self, &begin)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_source_reference_unref (_tmp7_), NULL)), _tmp8_);
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) param, attrs);
	vala_formal_parameter_set_direction (param, direction);
	vala_formal_parameter_set_params_array (param, params_array);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_ASSIGN)) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_genie_parser_parse_expression (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				return NULL;
			} else {
				(attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL));
				id = (g_free (id), NULL);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp10_ = NULL;
		vala_formal_parameter_set_default_expression (param, _tmp10_ = _tmp9_);
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_code_node_unref (_tmp10_), NULL));
	}
	_tmp11_ = NULL;
	return (_tmp11_ = param, (attrs == NULL) ? NULL : (attrs = (gee_collection_object_unref (attrs), NULL)), id = (g_free (id), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp11_);
}


static ValaCreationMethod* vala_genie_parser_parse_creation_method_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaCreationMethod* method;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	method = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CONSTRUCT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			return NULL;
		} else {
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_genie_parser_parse_member_declaration_modifiers (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS)) {
		ValaCreationMethod* _tmp1_;
		ValaSourceReference* _tmp0_;
		/* create default name using class name */
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		method = (_tmp1_ = vala_creation_method_new (self->priv->class_name, NULL, _tmp0_ = vala_genie_parser_get_src_com (self, &begin)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
	} else {
		ValaUnresolvedSymbol* sym;
		sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				return NULL;
			} else {
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		if (vala_unresolved_symbol_get_inner (sym) == NULL) {
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) sym), self->priv->class_name) != 0) {
				ValaCreationMethod* _tmp3_;
				ValaSourceReference* _tmp2_;
				_tmp3_ = NULL;
				_tmp2_ = NULL;
				method = (_tmp3_ = vala_creation_method_new (self->priv->class_name, vala_symbol_get_name ((ValaSymbol*) sym), _tmp2_ = vala_genie_parser_get_src_com (self, &begin)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp3_);
				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_source_reference_unref (_tmp2_), NULL));
			} else {
				ValaCreationMethod* _tmp5_;
				ValaSourceReference* _tmp4_;
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				method = (_tmp5_ = vala_creation_method_new (vala_symbol_get_name ((ValaSymbol*) sym), NULL, _tmp4_ = vala_genie_parser_get_src_com (self, &begin)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp5_);
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_source_reference_unref (_tmp4_), NULL));
			}
		} else {
			ValaCreationMethod* _tmp7_;
			ValaSourceReference* _tmp6_;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			method = (_tmp7_ = vala_creation_method_new (vala_symbol_get_name ((ValaSymbol*) vala_unresolved_symbol_get_inner (sym)), vala_symbol_get_name ((ValaSymbol*) sym), _tmp6_ = vala_genie_parser_get_src_com (self, &begin)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp7_);
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_source_reference_unref (_tmp6_), NULL));
		}
		vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				return NULL;
			} else {
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					return NULL;
				} else {
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			vala_method_add_parameter ((ValaMethod*) method, param);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			return NULL;
		} else {
			(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_YIELDS)) {
		vala_method_set_coroutine ((ValaMethod*) method, TRUE);
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_tmp8_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					return NULL;
				} else {
					(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp9_ = NULL;
			vala_code_node_add_error_type ((ValaCodeNode*) method, _tmp9_ = _tmp8_);
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_code_node_unref (_tmp9_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_symbol_set_access ((ValaSymbol*) method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) method, attrs);
	vala_method_set_binding ((ValaMethod*) method, MEMBER_BINDING_STATIC);
	if (vala_genie_parser_accept_block (self)) {
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		_tmp10_ = vala_genie_parser_parse_block (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				return NULL;
			} else {
				(method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp11_ = NULL;
		vala_method_set_body ((ValaMethod*) method, _tmp11_ = _tmp10_);
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_code_node_unref (_tmp11_), NULL));
	} else {
		if (vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner))) {
			vala_symbol_set_external ((ValaSymbol*) method, TRUE);
		}
	}
	return method;
}


static ValaSymbol* vala_genie_parser_parse_delegate_declaration (ValaGenieParser* self, GeeList* attrs, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaDataType* type;
	ValaGenieParserModifierFlags flags;
	ValaUnresolvedSymbol* sym;
	GeeList* type_param_list;
	GeeArrayList* params;
	ValaSourceReference* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* d;
	gboolean _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _result_;
	ValaSymbol* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	type = NULL;
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_DELEGATE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	flags = vala_genie_parser_parse_member_declaration_modifiers (self);
	sym = vala_genie_parser_parse_symbol_name (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	type_param_list = vala_genie_parser_parse_type_parameter_list (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) == VALA_GENIE_PARSER_MODIFIER_FLAGS_NEW) {
		char* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_inner_error_ = (_tmp1_ = g_error_new_literal (VALA_PARSE_ERROR, VALA_PARSE_ERROR_SYNTAX, _tmp0_ = vala_genie_parser_get_error (self, "`new' modifier not allowed on delegates")), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	params = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_current (self) != VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS) {
		do {
			ValaFormalParameter* param;
			param = vala_genie_parser_parse_parameter (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			gee_collection_add ((GeeCollection*) params, param);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect (self, VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COLON)) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				return NULL;
			} else {
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
				(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp3_ = NULL;
		type = (_tmp3_ = _tmp2_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3_);
	} else {
		ValaDataType* _tmp4_;
		_tmp4_ = NULL;
		type = (_tmp4_ = (ValaDataType*) vala_void_type_new (NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4_);
	}
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	d = (_tmp6_ = vala_delegate_new (vala_symbol_get_name ((ValaSymbol*) sym), type, _tmp5_ = vala_genie_parser_get_src_com (self, &begin)), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_source_reference_unref (_tmp5_), NULL)), _tmp6_);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_RAISES)) {
		do {
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			_tmp7_ = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
					return NULL;
				} else {
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp8_ = NULL;
			vala_code_node_add_error_type ((ValaCodeNode*) d, _tmp8_ = _tmp7_);
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_code_node_unref (_tmp8_), NULL));
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	vala_genie_parser_expect_terminator (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == VALA_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			return NULL;
		} else {
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			(type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) == VALA_GENIE_PARSER_MODIFIER_FLAGS_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
	} else {
		vala_symbol_set_access ((ValaSymbol*) d, vala_genie_parser_get_access (self, vala_symbol_get_name ((ValaSymbol*) sym)));
	}
	if (!((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC) == VALA_GENIE_PARSER_MODIFIER_FLAGS_STATIC)) {
		vala_delegate_set_has_target (d, TRUE);
	}
	_tmp9_ = FALSE;
	if ((flags & VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) == VALA_GENIE_PARSER_MODIFIER_FLAGS_EXTERN) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = vala_source_file_get_external_package (vala_genie_scanner_get_source_file (self->priv->scanner));
	}
	if (_tmp9_) {
		vala_symbol_set_external ((ValaSymbol*) d, TRUE);
	}
	vala_genie_parser_set_attributes (self, (ValaCodeNode*) d, attrs);
	{
		GeeIterator* _type_param_it;
		_type_param_it = gee_iterable_iterator ((GeeIterable*) type_param_list);
		while (gee_iterator_next (_type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			vala_delegate_add_type_parameter (d, type_param);
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	{
		GeeIterator* _formal_param_it;
		_formal_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_formal_param_it)) {
			ValaFormalParameter* formal_param;
			formal_param = (ValaFormalParameter*) gee_iterator_get (_formal_param_it);
			vala_delegate_add_parameter (d, formal_param);
			(formal_param == NULL) ? NULL : (formal_param = (vala_code_node_unref (formal_param), NULL));
		}
		(_formal_param_it == NULL) ? NULL : (_formal_param_it = (gee_collection_object_unref (_formal_param_it), NULL));
	}
	_tmp10_ = NULL;
	_result_ = (_tmp10_ = (ValaSymbol*) d, (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
	while (vala_unresolved_symbol_get_inner (sym) != NULL) {
		ValaUnresolvedSymbol* _tmp12_;
		ValaUnresolvedSymbol* _tmp11_;
		ValaNamespace* ns;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp13_;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		sym = (_tmp12_ = (_tmp11_ = vala_unresolved_symbol_get_inner (sym), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp12_);
		ns = vala_namespace_new (vala_symbol_get_name ((ValaSymbol*) sym), vala_code_node_get_source_reference ((ValaCodeNode*) d));
		if (VALA_IS_NAMESPACE (_result_)) {
			vala_namespace_add_namespace (ns, VALA_NAMESPACE (_result_));
		} else {
			vala_namespace_add_delegate (ns, VALA_DELEGATE (_result_));
			vala_source_file_add_node (vala_genie_scanner_get_source_file (self->priv->scanner), (ValaCodeNode*) _result_);
		}
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		_result_ = (_tmp14_ = (_tmp13_ = (ValaSymbol*) ns, (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp14_);
		(ns == NULL) ? NULL : (ns = (vala_code_node_unref (ns), NULL));
	}
	_tmp15_ = NULL;
	return (_tmp15_ = _result_, (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (type_param_list == NULL) ? NULL : (type_param_list = (gee_collection_object_unref (type_param_list), NULL)), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), (d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL)), _tmp15_);
}


static GeeList* vala_genie_parser_parse_type_parameter_list (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	GeeArrayList* list;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	list = gee_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		do {
			ValaSourceLocation begin;
			char* id;
			ValaTypeParameter* _tmp1_;
			ValaSourceReference* _tmp0_;
			begin = vala_genie_parser_get_location (self);
			id = vala_genie_parser_parse_identifier (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					return NULL;
				} else {
					(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp1_ = NULL;
			_tmp0_ = NULL;
			gee_collection_add ((GeeCollection*) list, _tmp1_ = vala_typeparameter_new (id, _tmp0_ = vala_genie_parser_get_src (self, &begin)));
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
			(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
			id = (g_free (id), NULL);
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
	return (GeeList*) list;
}


static void vala_genie_parser_skip_type_argument_list (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		do {
			vala_genie_parser_skip_type (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == VALA_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
	}
}


/* try to parse type argument list*/
static GeeList* vala_genie_parser_parse_type_argument_list (ValaGenieParser* self, gboolean maybe_expression, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	if (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_OF)) {
		GeeArrayList* list;
		list = gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
		do {
			switch (vala_genie_parser_current (self)) {
				case VALA_GENIE_TOKEN_TYPE_VOID:
				case VALA_GENIE_TOKEN_TYPE_DYNAMIC:
				case VALA_GENIE_TOKEN_TYPE_UNOWNED:
				case VALA_GENIE_TOKEN_TYPE_WEAK:
				case VALA_GENIE_TOKEN_TYPE_IDENTIFIER:
				{
					ValaDataType* type;
					type = vala_genie_parser_parse_type (self, TRUE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == VALA_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
							return NULL;
						} else {
							(list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL));
							g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					gee_collection_add ((GeeCollection*) list, type);
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					break;
				}
				default:
				{
					GeeList* _tmp0_;
					vala_genie_parser_rollback (self, &begin);
					_tmp0_ = NULL;
					return (_tmp0_ = NULL, (list == NULL) ? NULL : (list = (gee_collection_object_unref (list), NULL)), _tmp0_);
				}
			}
		} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_COMMA));
		return (GeeList*) list;
	}
	return NULL;
}


static ValaMemberAccess* vala_genie_parser_parse_member_name (ValaGenieParser* self, GError** error) {
	GError * _inner_error_;
	ValaSourceLocation begin;
	ValaMemberAccess* expr;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	begin = vala_genie_parser_get_location (self);
	expr = NULL;
	do {
		char* id;
		GeeList* type_arg_list;
		ValaMemberAccess* _tmp1_;
		ValaSourceReference* _tmp0_;
		id = vala_genie_parser_parse_identifier (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				return NULL;
			} else {
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		type_arg_list = vala_genie_parser_parse_type_argument_list (self, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == VALA_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				id = (g_free (id), NULL);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				return NULL;
			} else {
				id = (g_free (id), NULL);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		expr = (_tmp1_ = vala_member_access_new ((ValaExpression*) expr, id, _tmp0_ = vala_genie_parser_get_src (self, &begin)), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), _tmp1_);
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_source_reference_unref (_tmp0_), NULL));
		if (type_arg_list != NULL) {
			{
				GeeIterator* _type_arg_it;
				_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_arg_list);
				while (gee_iterator_next (_type_arg_it)) {
					ValaDataType* type_arg;
					type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
					vala_member_access_add_type_argument (expr, type_arg);
					(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
				}
				(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
			}
		}
		id = (g_free (id), NULL);
		(type_arg_list == NULL) ? NULL : (type_arg_list = (gee_collection_object_unref (type_arg_list), NULL));
	} while (vala_genie_parser_accept (self, VALA_GENIE_TOKEN_TYPE_DOT));
	return expr;
}


static ValaGenieParserTokenInfo* vala_genie_parser_token_info_dup (const ValaGenieParserTokenInfo* self) {
	ValaGenieParserTokenInfo* dup;
	dup = g_new0 (ValaGenieParserTokenInfo, 1);
	memcpy (dup, self, sizeof (ValaGenieParserTokenInfo));
	return dup;
}


static void vala_genie_parser_token_info_free (ValaGenieParserTokenInfo* self) {
	g_free (self);
}


static GType vala_genie_parser_token_info_get_type (void) {
	static GType vala_genie_parser_token_info_type_id = 0;
	if (vala_genie_parser_token_info_type_id == 0) {
		vala_genie_parser_token_info_type_id = g_boxed_type_register_static ("ValaGenieParserTokenInfo", (GBoxedCopyFunc) vala_genie_parser_token_info_dup, (GBoxedFreeFunc) vala_genie_parser_token_info_free);
	}
	return vala_genie_parser_token_info_type_id;
}


static void vala_genie_parser_class_init (ValaGenieParserClass * klass) {
	vala_genie_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_genie_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenieParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_genie_parser_real_visit_source_file;
}


static void vala_genie_parser_instance_init (ValaGenieParser * self) {
	self->priv = VALA_GENIE_PARSER_GET_PRIVATE (self);
}


static void vala_genie_parser_finalize (ValaCodeVisitor* obj) {
	ValaGenieParser * self;
	self = VALA_GENIE_PARSER (obj);
	(self->priv->scanner == NULL) ? NULL : (self->priv->scanner = (vala_genie_scanner_unref (self->priv->scanner), NULL));
	(self->priv->context == NULL) ? NULL : (self->priv->context = (vala_code_context_unref (self->priv->context), NULL));
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	self->priv->comment = (g_free (self->priv->comment), NULL);
	self->priv->class_name = (g_free (self->priv->class_name), NULL);
	VALA_CODE_VISITOR_CLASS (vala_genie_parser_parent_class)->finalize (obj);
}


GType vala_genie_parser_get_type (void) {
	static GType vala_genie_parser_type_id = 0;
	if (vala_genie_parser_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieParser), 0, (GInstanceInitFunc) vala_genie_parser_instance_init, NULL };
		vala_genie_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGenieParser", &g_define_type_info, 0);
	}
	return vala_genie_parser_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




