/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAFLOWANALYZER_H__
#define __VALA_VALAFLOWANALYZER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaerrordomain.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valablock.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valayieldstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valalockstatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_FLOW_ANALYZER (vala_flow_analyzer_get_type ())
#define VALA_FLOW_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer))
#define VALA_FLOW_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerClass))
#define VALA_IS_FLOW_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLOW_ANALYZER))
#define VALA_IS_FLOW_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLOW_ANALYZER))
#define VALA_FLOW_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerClass))

typedef struct _ValaFlowAnalyzer ValaFlowAnalyzer;
typedef struct _ValaFlowAnalyzerClass ValaFlowAnalyzerClass;
typedef struct _ValaFlowAnalyzerPrivate ValaFlowAnalyzerPrivate;

/**
 * Code visitor building the control flow graph.
 */
struct _ValaFlowAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaFlowAnalyzerPrivate * priv;
};

struct _ValaFlowAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};


ValaFlowAnalyzer* vala_flow_analyzer_construct (GType object_type);
ValaFlowAnalyzer* vala_flow_analyzer_new (void);
void vala_flow_analyzer_analyze (ValaFlowAnalyzer* self, ValaCodeContext* context);
GType vala_flow_analyzer_get_type (void);


G_END_DECLS

#endif
