/* valaexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <vala/valablock.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valastatement.h>
#include <vala/valalocalvariable.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>




struct _ValaExpressionPrivate {
	ValaDataType* _value_type;
	ValaDataType* _formal_value_type;
	ValaDataType* _target_type;
	ValaDataType* _formal_target_type;
	ValaSymbol* _symbol_reference;
	gboolean _lvalue;
};

#define VALA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION, ValaExpressionPrivate))
enum  {
	VALA_EXPRESSION_DUMMY_PROPERTY
};
static gboolean vala_expression_real_is_constant (ValaExpression* self);
static gboolean vala_expression_real_is_pure (ValaExpression* self);
static gboolean vala_expression_real_is_non_null (ValaExpression* self);
static gpointer vala_expression_parent_class = NULL;
static void vala_expression_finalize (ValaCodeNode* obj);



/**
 * Returns whether this expression is constant, i.e. whether this
 * expression only consists of literals and other constants.
 */
static gboolean vala_expression_real_is_constant (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FALSE;
}


gboolean vala_expression_is_constant (ValaExpression* self) {
	return VALA_EXPRESSION_GET_CLASS (self)->is_constant (self);
}


static gboolean vala_expression_real_is_pure (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `vala_expression_is_pure'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


/**
 * Returns whether this expression is pure, i.e. whether this expression
 * is free of side-effects.
 */
gboolean vala_expression_is_pure (ValaExpression* self) {
	return VALA_EXPRESSION_GET_CLASS (self)->is_pure (self);
}


/**
 * Returns whether this expression is guaranteed to be non-null.
 */
static gboolean vala_expression_real_is_non_null (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FALSE;
}


gboolean vala_expression_is_non_null (ValaExpression* self) {
	return VALA_EXPRESSION_GET_CLASS (self)->is_non_null (self);
}


ValaBlock* vala_expression_prepare_condition_split (ValaExpression* self, ValaSemanticAnalyzer* analyzer) {
	ValaWhileStatement* _tmp1;
	ValaStatement* _tmp0;
	ValaWhileStatement* while_stmt;
	ValaDoStatement* _tmp3;
	ValaStatement* _tmp2;
	ValaDoStatement* do_stmt;
	ValaForStatement* _tmp5;
	ValaStatement* _tmp4;
	ValaForStatement* for_stmt;
	ValaBlock* _tmp9;
	ValaBlock* _tmp10;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (analyzer != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	while_stmt = (_tmp1 = (_tmp0 = vala_expression_get_parent_statement (self), VALA_IS_WHILE_STATEMENT (_tmp0) ? ((ValaWhileStatement*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	do_stmt = (_tmp3 = (_tmp2 = vala_expression_get_parent_statement (self), VALA_IS_DO_STATEMENT (_tmp2) ? ((ValaDoStatement*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp5 = NULL;
	_tmp4 = NULL;
	for_stmt = (_tmp5 = (_tmp4 = vala_expression_get_parent_statement (self), VALA_IS_FOR_STATEMENT (_tmp4) ? ((ValaForStatement*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	if (while_stmt != NULL) {
		ValaBlock* _tmp6;
		_tmp6 = NULL;
		return (_tmp6 = vala_while_statement_prepare_condition_split (while_stmt, analyzer), (while_stmt == NULL) ? NULL : (while_stmt = (vala_code_node_unref (while_stmt), NULL)), (do_stmt == NULL) ? NULL : (do_stmt = (vala_code_node_unref (do_stmt), NULL)), (for_stmt == NULL) ? NULL : (for_stmt = (vala_code_node_unref (for_stmt), NULL)), _tmp6);
	} else {
		if (do_stmt != NULL) {
			ValaBlock* _tmp7;
			_tmp7 = NULL;
			return (_tmp7 = vala_do_statement_prepare_condition_split (do_stmt, analyzer), (while_stmt == NULL) ? NULL : (while_stmt = (vala_code_node_unref (while_stmt), NULL)), (do_stmt == NULL) ? NULL : (do_stmt = (vala_code_node_unref (do_stmt), NULL)), (for_stmt == NULL) ? NULL : (for_stmt = (vala_code_node_unref (for_stmt), NULL)), _tmp7);
		} else {
			if (for_stmt != NULL) {
				ValaBlock* _tmp8;
				_tmp8 = NULL;
				return (_tmp8 = vala_for_statement_prepare_condition_split (for_stmt, analyzer), (while_stmt == NULL) ? NULL : (while_stmt = (vala_code_node_unref (while_stmt), NULL)), (do_stmt == NULL) ? NULL : (do_stmt = (vala_code_node_unref (do_stmt), NULL)), (for_stmt == NULL) ? NULL : (for_stmt = (vala_code_node_unref (for_stmt), NULL)), _tmp8);
			}
		}
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	return (_tmp10 = (_tmp9 = analyzer->insert_block, (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9)), (while_stmt == NULL) ? NULL : (while_stmt = (vala_code_node_unref (while_stmt), NULL)), (do_stmt == NULL) ? NULL : (do_stmt = (vala_code_node_unref (do_stmt), NULL)), (for_stmt == NULL) ? NULL : (for_stmt = (vala_code_node_unref (for_stmt), NULL)), _tmp10);
}


void vala_expression_insert_statement (ValaExpression* self, ValaBlock* block, ValaStatement* stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (stmt != NULL);
	vala_block_insert_before (block, vala_expression_get_parent_statement (self), stmt);
}


ValaDataType* vala_expression_get_value_type (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value_type;
}


void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_value_type == NULL) ? NULL : (self->priv->_value_type = (vala_code_node_unref (self->priv->_value_type), NULL)), _tmp2);
}


ValaDataType* vala_expression_get_formal_value_type (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_formal_value_type;
}


void vala_expression_set_formal_value_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_formal_value_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_formal_value_type == NULL) ? NULL : (self->priv->_formal_value_type = (vala_code_node_unref (self->priv->_formal_value_type), NULL)), _tmp2);
}


ValaDataType* vala_expression_get_target_type (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_target_type;
}


void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_target_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_target_type == NULL) ? NULL : (self->priv->_target_type = (vala_code_node_unref (self->priv->_target_type), NULL)), _tmp2);
}


ValaDataType* vala_expression_get_formal_target_type (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_formal_target_type;
}


void vala_expression_set_formal_target_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_formal_target_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_formal_target_type == NULL) ? NULL : (self->priv->_formal_target_type = (vala_code_node_unref (self->priv->_formal_target_type), NULL)), _tmp2);
}


ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_symbol_reference;
}


void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_symbol_reference = value;
}


gboolean vala_expression_get_lvalue (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_lvalue;
}


void vala_expression_set_lvalue (ValaExpression* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_lvalue = value;
}


ValaStatement* vala_expression_get_parent_statement (ValaExpression* self) {
	ValaExpression* _tmp1;
	ValaCodeNode* _tmp0;
	ValaExpression* expr;
	ValaStatement* _tmp3;
	ValaCodeNode* _tmp2;
	ValaStatement* stmt;
	ValaLocalVariable* _tmp5;
	ValaCodeNode* _tmp4;
	ValaLocalVariable* local;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	expr = (_tmp1 = (_tmp0 = vala_code_node_get_parent_node ((ValaCodeNode*) self), VALA_IS_EXPRESSION (_tmp0) ? ((ValaExpression*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	stmt = (_tmp3 = (_tmp2 = vala_code_node_get_parent_node ((ValaCodeNode*) self), VALA_IS_STATEMENT (_tmp2) ? ((ValaStatement*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp5 = NULL;
	_tmp4 = NULL;
	local = (_tmp5 = (_tmp4 = vala_code_node_get_parent_node ((ValaCodeNode*) self), VALA_IS_LOCAL_VARIABLE (_tmp4) ? ((ValaLocalVariable*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	if (stmt != NULL) {
		ValaStatement* _tmp6;
		ValaStatement* _tmp7;
		ValaStatement* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = _tmp6 = stmt, (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)), _tmp7), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp8);
	} else {
		if (expr != NULL) {
			ValaStatement* _tmp9;
			_tmp9 = NULL;
			return (_tmp9 = vala_expression_get_parent_statement (expr), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp9);
		} else {
			if (local != NULL) {
				ValaStatement* _tmp10;
				_tmp10 = NULL;
				return (_tmp10 = VALA_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) local)), (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp10);
			} else {
				ValaStatement* _tmp11;
				_tmp11 = NULL;
				return (_tmp11 = NULL, (expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL)), (stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp11);
			}
		}
	}
	(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
	(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


static void vala_expression_class_init (ValaExpressionClass * klass) {
	vala_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaExpressionPrivate));
	VALA_EXPRESSION_CLASS (klass)->is_constant = vala_expression_real_is_constant;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_expression_real_is_pure;
	VALA_EXPRESSION_CLASS (klass)->is_non_null = vala_expression_real_is_non_null;
}


static void vala_expression_instance_init (ValaExpression * self) {
	self->priv = VALA_EXPRESSION_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_expression_finalize (ValaCodeNode* obj) {
	ValaExpression * self;
	self = VALA_EXPRESSION (obj);
	(self->priv->_value_type == NULL) ? NULL : (self->priv->_value_type = (vala_code_node_unref (self->priv->_value_type), NULL));
	(self->priv->_formal_value_type == NULL) ? NULL : (self->priv->_formal_value_type = (vala_code_node_unref (self->priv->_formal_value_type), NULL));
	(self->priv->_target_type == NULL) ? NULL : (self->priv->_target_type = (vala_code_node_unref (self->priv->_target_type), NULL));
	(self->priv->_formal_target_type == NULL) ? NULL : (self->priv->_formal_target_type = (vala_code_node_unref (self->priv->_formal_target_type), NULL));
	(self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL));
	VALA_CODE_NODE_CLASS (vala_expression_parent_class)->finalize (obj);
}


GType vala_expression_get_type (void) {
	static GType vala_expression_type_id = 0;
	if (vala_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpression), 0, (GInstanceInitFunc) vala_expression_instance_init, NULL };
		vala_expression_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_expression_type_id;
}




