/* valaccodearraymodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodearraymodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valatypesymbol.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaintegerliteral.h>
#include <vala/valamemberaccess.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valamethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valagenerictype.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valabinaryexpression.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodefragment.h>
#include <vala/valaunaryexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valalocalvariable.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valaclass.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valaconstant.h>
#include <vala/valanullliteral.h>
#include <gee/arraylist.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valainitializerlist.h>
#include <ccode/valaccodewhilestatement.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaccodeassignmentmodule.h>




struct _ValaCCodeArrayModulePrivate {
	gint next_array_dup_id;
	gint next_array_add_id;
};

#define VALA_CCODE_ARRAY_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModulePrivate))
enum  {
	VALA_CCODE_ARRAY_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i);
static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr);
static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim);
static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeModule* base, const char* array_cname);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeModule* base, ValaExpression* array_expr);
static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr);
static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self);
static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base);
static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference);
static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
static void vala_ccode_array_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment);
static void vala_ccode_array_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
static gpointer vala_ccode_array_module_parent_class = NULL;
static void vala_ccode_array_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeArrayModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeArrayModule*) vala_ccode_method_call_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_array_module_construct (VALA_TYPE_CCODE_ARRAY_MODULE, codegen, next);
}


static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ce != NULL);
	g_return_if_fail (name_cnode != NULL);
	g_return_if_fail (initializer_list != NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _e_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_e_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_initializer_list_get_initializers (initializer_list))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_e_it)) {
			ValaExpression* e;
			e = (ValaExpression*) gee_iterator_get (_e_it);
			if (rank > 1) {
				vala_ccode_array_module_append_initializer_list (self, ce, name_cnode, VALA_INITIALIZER_LIST (e), rank - 1, &(*i));
			} else {
				ValaCCodeAssignment* _tmp5;
				ValaCCodeElementAccess* _tmp4;
				ValaCCodeConstant* _tmp3;
				char* _tmp2;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp5 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_element_access_new (name_cnode, (ValaCCodeExpression*) (_tmp3 = vala_ccode_constant_new (_tmp2 = g_strdup_printf ("%i", (*i)))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) e)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
				_tmp2 = (g_free (_tmp2), NULL);
				(*i)++;
			}
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
		}
		(_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL));
	}
}


static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	gboolean first;
	ValaCCodeExpression* cexpr;
	gboolean _tmp11;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	gnew = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_new0"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr)))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	first = TRUE;
	cexpr = NULL;
	/* iterate over each dimension*/
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _size_it;
		/* iterate over each dimension*/
		_tmp4 = NULL;
		_tmp5 = NULL;
		_size_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_array_creation_expression_get_sizes (expr))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		/* iterate over each dimension*/
		while (gee_iterator_next (_size_it)) {
			ValaExpression* size;
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* csize;
			/* iterate over each dimension*/
			size = (ValaExpression*) gee_iterator_get (_size_it);
			_tmp6 = NULL;
			csize = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6));
			if (!vala_ccode_base_module_is_pure_ccode_expression ((ValaCCodeBaseModule*) self, csize)) {
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* name_cnode;
				ValaCCodeExpression* _tmp7;
				temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, FALSE, (ValaCodeNode*) expr);
				name_cnode = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				vala_code_node_set_ccodenode ((ValaCodeNode*) size, (ValaCCodeNode*) name_cnode);
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp7 = NULL;
				csize = (_tmp7 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) name_cnode, csize, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (csize == NULL) ? NULL : (csize = (vala_ccode_node_unref (csize), NULL)), _tmp7);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(name_cnode == NULL) ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL));
			}
			if (first) {
				ValaCCodeExpression* _tmp9;
				ValaCCodeExpression* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				cexpr = (_tmp9 = (_tmp8 = csize, (_tmp8 == NULL) ? NULL : vala_ccode_node_ref (_tmp8)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp9);
				first = FALSE;
			} else {
				ValaCCodeExpression* _tmp10;
				_tmp10 = NULL;
				cexpr = (_tmp10 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp10);
			}
			(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
			(csize == NULL) ? NULL : (csize = (vala_ccode_node_unref (csize), NULL));
		}
		(_size_it == NULL) ? NULL : (_size_it = (gee_collection_object_unref (_size_it), NULL));
	}
	_tmp11 = FALSE;
	if (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL) {
		_tmp11 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)));
	} else {
		_tmp11 = FALSE;
	}
	/* add extra item to have array NULL-terminated for all reference types*/
	if (_tmp11) {
		ValaCCodeExpression* _tmp13;
		ValaCCodeConstant* _tmp12;
		_tmp13 = NULL;
		_tmp12 = NULL;
		cexpr = (_tmp13 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, cexpr, (ValaCCodeExpression*) (_tmp12 = vala_ccode_constant_new ("1"))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp13);
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp14;
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr);
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
		i = 0;
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
		_tmp14 = NULL;
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp14 = vala_ccode_assignment_new ((ValaCCodeExpression*) name_cnode, (ValaCCodeExpression*) gnew, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		vala_ccode_array_module_append_initializer_list (self, ce, (ValaCCodeExpression*) name_cnode, vala_array_creation_expression_get_initializer_list (expr), vala_array_creation_expression_get_rank (expr), &i);
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) name_cnode);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ce);
		(ce == NULL) ? NULL : (ce = (vala_ccode_node_unref (ce), NULL));
		(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
		(name_cnode == NULL) ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) gnew);
	}
	(gnew == NULL) ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL));
	(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
}


static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim) {
	ValaCCodeArrayModule * self;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim) {
	ValaCCodeArrayModule * self;
	gboolean is_out;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	/* dim == -1 => total size over all dimensions*/
	if (dim == (-1)) {
		ValaArrayType* _tmp1;
		ValaDataType* _tmp0;
		ValaArrayType* array_type;
		gboolean _tmp2;
		_tmp1 = NULL;
		_tmp0 = NULL;
		array_type = (_tmp1 = (_tmp0 = vala_expression_get_value_type (array_expr), VALA_IS_ARRAY_TYPE (_tmp0) ? ((ValaArrayType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		if (array_type != NULL) {
			_tmp2 = vala_array_type_get_rank (array_type) > 1;
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			ValaCCodeExpression* cexpr;
			ValaCCodeExpression* _tmp5;
			cexpr = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array_expr, 1);
			for (dim = 2; dim <= vala_array_type_get_rank (array_type); dim++) {
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				cexpr = (_tmp4 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, _tmp3 = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array_expr, dim)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp4);
				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
			}
			_tmp5 = NULL;
			return (_tmp5 = cexpr, (array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)), _tmp5);
		} else {
			dim = 1;
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp6;
		ValaUnaryExpression* unary_expr;
		gboolean _tmp7;
		_tmp6 = NULL;
		unary_expr = (_tmp6 = VALA_UNARY_EXPRESSION (array_expr), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp7 = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp7) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL) ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp8;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp8 = NULL;
			reftransfer_expr = (_tmp8 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL) ? NULL : (reftransfer_expr = (vala_code_node_unref (reftransfer_expr), NULL));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* _tmp9;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = (ValaExpression*) gee_list_get ((GeeList*) size, dim - 1);
		_tmp9 = NULL;
		return (_tmp9 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) length_expr)), (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), (length_expr == NULL) ? NULL : (length_expr = (vala_code_node_unref (length_expr), NULL)), _tmp9);
	} else {
		if (VALA_IS_METHOD_CALL (array_expr)) {
			ValaMethodCall* _tmp10;
			ValaMethodCall* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* _tmp11;
			_tmp10 = NULL;
			invocation_expr = (_tmp10 = VALA_METHOD_CALL (array_expr), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
			size = vala_method_call_get_array_sizes (invocation_expr);
			_tmp11 = NULL;
			return (_tmp11 = (ValaCCodeExpression*) gee_list_get ((GeeList*) size, dim - 1), (invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL)), (size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL)), _tmp11);
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp12;
					ValaFormalParameter* param;
					_tmp12 = NULL;
					param = (_tmp12 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
					if (vala_formal_parameter_get_array_null_terminated (param)) {
						ValaCCodeExpression* carray_expr;
						ValaCCodeIdentifier* _tmp13;
						ValaCCodeFunctionCall* _tmp14;
						ValaCCodeFunctionCall* len_call;
						ValaCCodeExpression* _tmp15;
						carray_expr = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param));
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp13 = NULL;
						_tmp14 = NULL;
						len_call = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
						vala_ccode_function_call_add_argument (len_call, carray_expr);
						_tmp15 = NULL;
						return (_tmp15 = (ValaCCodeExpression*) len_call, (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp15);
					} else {
						if (!vala_formal_parameter_get_no_array_length (param)) {
							char* _tmp16;
							ValaCCodeExpression* _tmp17;
							ValaCCodeExpression* length_expr;
							_tmp16 = NULL;
							_tmp17 = NULL;
							length_expr = (_tmp17 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp16 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) param), dim)), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
								ValaCCodeExpression* _tmp18;
								/* accessing argument of out/ref param*/
								_tmp18 = NULL;
								length_expr = (_tmp18 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp18);
							}
							if (is_out) {
								ValaCCodeExpression* _tmp19;
								/* passing array as out/ref*/
								_tmp19 = NULL;
								return (_tmp19 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp19);
							} else {
								ValaCCodeExpression* _tmp20;
								_tmp20 = NULL;
								return (_tmp20 = length_expr, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp20);
							}
							(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
						}
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
						ValaLocalVariable* _tmp21;
						ValaLocalVariable* local;
						char* _tmp23;
						char* _tmp22;
						ValaCCodeExpression* _tmp24;
						ValaCCodeExpression* length_expr;
						_tmp21 = NULL;
						local = (_tmp21 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp21 == NULL) ? NULL : vala_code_node_ref (_tmp21));
						_tmp23 = NULL;
						_tmp22 = NULL;
						_tmp24 = NULL;
						length_expr = (_tmp24 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp23 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, _tmp22 = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _tmp23 = (g_free (_tmp23), NULL), _tmp22 = (g_free (_tmp22), NULL), _tmp24);
						if (is_out) {
							ValaCCodeExpression* _tmp25;
							_tmp25 = NULL;
							return (_tmp25 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp25);
						} else {
							ValaCCodeExpression* _tmp26;
							_tmp26 = NULL;
							return (_tmp26 = length_expr, (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp26);
						}
						(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
						(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp27;
							ValaField* field;
							_tmp27 = NULL;
							field = (_tmp27 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp27 == NULL) ? NULL : vala_code_node_ref (_tmp27));
							if (vala_field_get_array_null_terminated (field)) {
								ValaMemberAccess* _tmp28;
								ValaMemberAccess* ma;
								ValaCCodeExpression* carray_expr;
								ValaCCodeIdentifier* _tmp40;
								ValaCCodeFunctionCall* _tmp41;
								ValaCCodeFunctionCall* len_call;
								ValaCCodeExpression* _tmp42;
								_tmp28 = NULL;
								ma = (_tmp28 = VALA_MEMBER_ACCESS (array_expr), (_tmp28 == NULL) ? NULL : vala_code_node_ref (_tmp28));
								carray_expr = NULL;
								if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
									ValaClass* _tmp30;
									ValaSymbol* _tmp29;
									ValaClass* cl;
									gboolean _tmp31;
									gboolean is_gtypeinstance;
									char* array_cname;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									gboolean _tmp32;
									_tmp30 = NULL;
									_tmp29 = NULL;
									cl = (_tmp30 = (_tmp29 = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp29) ? ((ValaClass*) _tmp29) : NULL), (_tmp30 == NULL) ? NULL : vala_code_node_ref (_tmp30));
									_tmp31 = FALSE;
									if (cl != NULL) {
										_tmp31 = !vala_class_get_is_compact (cl);
									} else {
										_tmp31 = FALSE;
									}
									is_gtypeinstance = (_tmp31);
									array_cname = vala_field_get_cname (field);
									typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
									inst = NULL;
									_tmp32 = FALSE;
									if (is_gtypeinstance) {
										_tmp32 = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
									} else {
										_tmp32 = FALSE;
									}
									if (_tmp32) {
										ValaCCodeExpression* _tmp33;
										_tmp33 = NULL;
										inst = (_tmp33 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp33);
									} else {
										ValaCCodeExpression* _tmp35;
										ValaCCodeExpression* _tmp34;
										_tmp35 = NULL;
										_tmp34 = NULL;
										inst = (_tmp35 = (_tmp34 = typed_inst, (_tmp34 == NULL) ? NULL : vala_ccode_node_ref (_tmp34)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp35);
									}
									if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field))))) {
										ValaCCodeExpression* _tmp36;
										_tmp36 = NULL;
										carray_expr = (_tmp36 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, array_cname), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp36);
									} else {
										ValaCCodeExpression* _tmp37;
										_tmp37 = NULL;
										carray_expr = (_tmp37 = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, array_cname, FALSE), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp37);
									}
									(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
									array_cname = (g_free (array_cname), NULL);
									(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
									(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
								} else {
									ValaCCodeExpression* _tmp39;
									char* _tmp38;
									_tmp39 = NULL;
									_tmp38 = NULL;
									carray_expr = (_tmp39 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp38 = vala_field_get_cname (field)), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp39);
									_tmp38 = (g_free (_tmp38), NULL);
								}
								((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
								_tmp40 = NULL;
								_tmp41 = NULL;
								len_call = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)), _tmp41);
								vala_ccode_function_call_add_argument (len_call, carray_expr);
								_tmp42 = NULL;
								return (_tmp42 = (ValaCCodeExpression*) len_call, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp42);
							} else {
								if (!vala_field_get_no_array_length (field)) {
									ValaMemberAccess* _tmp43;
									ValaMemberAccess* ma;
									ValaCCodeExpression* length_expr;
									_tmp43 = NULL;
									ma = (_tmp43 = VALA_MEMBER_ACCESS (array_expr), (_tmp43 == NULL) ? NULL : vala_code_node_ref (_tmp43));
									length_expr = NULL;
									if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
										ValaClass* _tmp45;
										ValaSymbol* _tmp44;
										ValaClass* cl;
										gboolean _tmp46;
										gboolean is_gtypeinstance;
										char* length_cname;
										ValaCCodeExpression* typed_inst;
										ValaCCodeExpression* inst;
										gboolean _tmp49;
										_tmp45 = NULL;
										_tmp44 = NULL;
										cl = (_tmp45 = (_tmp44 = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp44) ? ((ValaClass*) _tmp44) : NULL), (_tmp45 == NULL) ? NULL : vala_code_node_ref (_tmp45));
										_tmp46 = FALSE;
										if (cl != NULL) {
											_tmp46 = !vala_class_get_is_compact (cl);
										} else {
											_tmp46 = FALSE;
										}
										is_gtypeinstance = (_tmp46);
										length_cname = NULL;
										if (vala_field_get_has_array_length_cname (field)) {
											char* _tmp47;
											_tmp47 = NULL;
											length_cname = (_tmp47 = vala_field_get_array_length_cname (field), length_cname = (g_free (length_cname), NULL), _tmp47);
										} else {
											char* _tmp48;
											_tmp48 = NULL;
											length_cname = (_tmp48 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) field), dim), length_cname = (g_free (length_cname), NULL), _tmp48);
										}
										typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
										inst = NULL;
										_tmp49 = FALSE;
										if (is_gtypeinstance) {
											_tmp49 = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
										} else {
											_tmp49 = FALSE;
										}
										if (_tmp49) {
											ValaCCodeExpression* _tmp50;
											_tmp50 = NULL;
											inst = (_tmp50 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp50);
										} else {
											ValaCCodeExpression* _tmp52;
											ValaCCodeExpression* _tmp51;
											_tmp52 = NULL;
											_tmp51 = NULL;
											inst = (_tmp52 = (_tmp51 = typed_inst, (_tmp51 == NULL) ? NULL : vala_ccode_node_ref (_tmp51)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp52);
										}
										if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field))))) {
											ValaCCodeExpression* _tmp53;
											_tmp53 = NULL;
											length_expr = (_tmp53 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, length_cname), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp53);
										} else {
											ValaCCodeExpression* _tmp54;
											_tmp54 = NULL;
											length_expr = (_tmp54 = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, length_cname, FALSE), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp54);
										}
										(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
										length_cname = (g_free (length_cname), NULL);
										(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
										(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
									} else {
										ValaCCodeExpression* _tmp57;
										char* _tmp56;
										char* _tmp55;
										_tmp57 = NULL;
										_tmp56 = NULL;
										_tmp55 = NULL;
										length_expr = (_tmp57 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp56 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, _tmp55 = vala_field_get_cname (field), dim)), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp57);
										_tmp56 = (g_free (_tmp56), NULL);
										_tmp55 = (g_free (_tmp55), NULL);
									}
									if (is_out) {
										ValaCCodeExpression* _tmp58;
										_tmp58 = NULL;
										return (_tmp58 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp58);
									} else {
										ValaCCodeExpression* _tmp59;
										_tmp59 = NULL;
										return (_tmp59 = length_expr, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp59);
									}
									(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
									(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
								}
							}
							(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
						} else {
							if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (array_expr))) {
								ValaConstant* _tmp60;
								ValaConstant* constant;
								ValaCCodeIdentifier* _tmp61;
								ValaCCodeFunctionCall* _tmp62;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp64;
								char* _tmp63;
								ValaCCodeExpression* _tmp65;
								_tmp60 = NULL;
								constant = (_tmp60 = VALA_CONSTANT (vala_expression_get_symbol_reference (array_expr)), (_tmp60 == NULL) ? NULL : vala_code_node_ref (_tmp60));
								_tmp61 = NULL;
								_tmp62 = NULL;
								ccall = (_tmp62 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("G_N_ELEMENTS"))), (_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)), _tmp62);
								_tmp64 = NULL;
								_tmp63 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new (_tmp63 = vala_constant_get_cname (constant))));
								(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
								_tmp63 = (g_free (_tmp63), NULL);
								_tmp65 = NULL;
								return (_tmp65 = (ValaCCodeExpression*) ccall, (constant == NULL) ? NULL : (constant = (vala_code_node_unref (constant), NULL)), _tmp65);
							}
						}
					}
				}
			} else {
				if (VALA_IS_NULL_LITERAL (array_expr)) {
					return (ValaCCodeExpression*) vala_ccode_constant_new ("0");
				}
			}
		}
	}
	if (!is_out) {
		/* allow arrays with unknown length even for value types
		 * as else it may be impossible to bind some libraries
		 * users of affected libraries should explicitly set
		 * the array length as early as possible
		 * by setting the virtual length field of the array
		 */
		return (ValaCCodeExpression*) vala_ccode_constant_new ("-1");
	} else {
		return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
	}
}


static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeModule* base, const char* array_cname) {
	ValaCCodeArrayModule * self;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_size", array_cname);
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeModule* base, ValaExpression* array_expr) {
	ValaCCodeArrayModule * self;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
		ValaLocalVariable* _tmp0;
		ValaLocalVariable* local;
		char* _tmp2;
		char* _tmp1;
		ValaCCodeExpression* _tmp3;
		ValaCCodeExpression* _tmp4;
		_tmp0 = NULL;
		local = (_tmp0 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2 = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, _tmp1 = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp4);
	} else {
		if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
			ValaField* _tmp5;
			ValaField* field;
			ValaMemberAccess* _tmp6;
			ValaMemberAccess* ma;
			ValaCCodeExpression* size_expr;
			ValaCCodeExpression* _tmp19;
			_tmp5 = NULL;
			field = (_tmp5 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
			_tmp6 = NULL;
			ma = (_tmp6 = VALA_MEMBER_ACCESS (array_expr), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			size_expr = NULL;
			if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
				ValaClass* _tmp8;
				ValaSymbol* _tmp7;
				ValaClass* cl;
				gboolean _tmp9;
				gboolean is_gtypeinstance;
				char* size_cname;
				ValaCCodeExpression* typed_inst;
				ValaCCodeExpression* inst;
				gboolean _tmp10;
				_tmp8 = NULL;
				_tmp7 = NULL;
				cl = (_tmp8 = (_tmp7 = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp7) ? ((ValaClass*) _tmp7) : NULL), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
				_tmp9 = FALSE;
				if (cl != NULL) {
					_tmp9 = !vala_class_get_is_compact (cl);
				} else {
					_tmp9 = FALSE;
				}
				is_gtypeinstance = (_tmp9);
				size_cname = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) field));
				typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
				inst = NULL;
				_tmp10 = FALSE;
				if (is_gtypeinstance) {
					_tmp10 = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp10 = FALSE;
				}
				if (_tmp10) {
					ValaCCodeExpression* _tmp11;
					_tmp11 = NULL;
					inst = (_tmp11 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp11);
				} else {
					ValaCCodeExpression* _tmp13;
					ValaCCodeExpression* _tmp12;
					_tmp13 = NULL;
					_tmp12 = NULL;
					inst = (_tmp13 = (_tmp12 = typed_inst, (_tmp12 == NULL) ? NULL : vala_ccode_node_ref (_tmp12)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp13);
				}
				if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field))))) {
					ValaCCodeExpression* _tmp14;
					_tmp14 = NULL;
					size_expr = (_tmp14 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, size_cname), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp14);
				} else {
					ValaCCodeExpression* _tmp15;
					_tmp15 = NULL;
					size_expr = (_tmp15 = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, size_cname, FALSE), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp15);
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				size_cname = (g_free (size_cname), NULL);
				(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
			} else {
				ValaCCodeExpression* _tmp18;
				char* _tmp17;
				char* _tmp16;
				_tmp18 = NULL;
				_tmp17 = NULL;
				_tmp16 = NULL;
				size_expr = (_tmp18 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp17 = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, _tmp16 = vala_field_get_cname (field))), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp18);
				_tmp17 = (g_free (_tmp17), NULL);
				_tmp16 = (g_free (_tmp16), NULL);
			}
			_tmp19 = NULL;
			return (_tmp19 = size_expr, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp19);
		}
	}
	g_assert_not_reached ();
}


static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr) {
	ValaCCodeArrayModule * self;
	GeeList* indices;
	gint rank;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* container_type;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp3;
	ValaExpression* _tmp2;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* cindex;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size ((GeeCollection*) indices);
	_tmp0 = NULL;
	container_type = (_tmp0 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	ccontainer = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_element_access_get_container (expr))), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp4 = NULL;
	cindex = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp2 = (ValaExpression*) gee_list_get ((GeeList*) indices, 0)))), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)), _tmp4);
	if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		ValaExpression* _tmp5;
		ValaIntegerLiteral* lit;
		ValaMemberAccess* _tmp7;
		ValaExpression* _tmp6;
		ValaMemberAccess* memberaccess;
		gboolean _tmp8;
		/* Figure if cindex is a constant expression and calculate dim...*/
		_tmp5 = NULL;
		lit = (_tmp5 = (ValaExpression*) gee_list_get ((GeeList*) indices, 0), VALA_IS_INTEGER_LITERAL (_tmp5) ? ((ValaIntegerLiteral*) _tmp5) : NULL);
		_tmp7 = NULL;
		_tmp6 = NULL;
		memberaccess = (_tmp7 = (_tmp6 = vala_element_access_get_container (expr), VALA_IS_MEMBER_ACCESS (_tmp6) ? ((ValaMemberAccess*) _tmp6) : NULL), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
		_tmp8 = FALSE;
		if (lit != NULL) {
			_tmp8 = memberaccess != NULL;
		} else {
			_tmp8 = FALSE;
		}
		if (_tmp8) {
			gint dim;
			ValaCCodeExpression* _tmp9;
			dim = atoi (vala_integer_literal_get_value (lit));
			_tmp9 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (memberaccess), dim + 1)));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		}
		(lit == NULL) ? NULL : (lit = (vala_code_node_unref (lit), NULL));
		(memberaccess == NULL) ? NULL : (memberaccess = (vala_code_node_unref (memberaccess), NULL));
	} else {
		if (container_type == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeFunctionCall* _tmp11;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeFunctionCall* _tmp13;
			ValaCCodeFunctionCall* ccall;
			/* should be moved to a different module
			 access to unichar in a string*/
			_tmp10 = NULL;
			_tmp11 = NULL;
			coffsetcall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
			vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
			vala_ccode_function_call_add_argument (coffsetcall, cindex);
			_tmp12 = NULL;
			_tmp13 = NULL;
			ccall = (_tmp13 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("g_utf8_get_char"))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) coffsetcall);
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(coffsetcall == NULL) ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		} else {
			gboolean _tmp14;
			gboolean _tmp15;
			gboolean _tmp16;
			_tmp14 = FALSE;
			_tmp15 = FALSE;
			_tmp16 = FALSE;
			if (container_type != NULL) {
				_tmp16 = ((ValaCCodeBaseModule*) self)->list_type != NULL;
			} else {
				_tmp16 = FALSE;
			}
			if (_tmp16) {
				_tmp15 = ((ValaCCodeBaseModule*) self)->map_type != NULL;
			} else {
				_tmp15 = FALSE;
			}
			if (_tmp15) {
				gboolean _tmp17;
				_tmp17 = FALSE;
				if (vala_typesymbol_is_subtype_of (container_type, (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->list_type)) {
					_tmp17 = TRUE;
				} else {
					_tmp17 = vala_typesymbol_is_subtype_of (container_type, (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->map_type);
				}
				_tmp14 = (_tmp17);
			} else {
				_tmp14 = FALSE;
			}
			if (_tmp14) {
				ValaTypeSymbol* collection_iface;
				ValaMethod* get_method;
				GeeList* get_params;
				GeeIterator* get_params_it;
				ValaFormalParameter* get_param;
				ValaCCodeIdentifier* _tmp24;
				char* _tmp23;
				ValaCCodeFunctionCall* _tmp25;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeCastExpression* _tmp28;
				char* _tmp27;
				char* _tmp26;
				ValaCCodeExpression* _tmp29;
				/* should be moved to a different module*/
				collection_iface = NULL;
				if (vala_typesymbol_is_subtype_of (container_type, (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->list_type)) {
					ValaTypeSymbol* _tmp19;
					ValaTypeSymbol* _tmp18;
					_tmp19 = NULL;
					_tmp18 = NULL;
					collection_iface = (_tmp19 = (_tmp18 = (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->list_type, (_tmp18 == NULL) ? NULL : vala_code_node_ref (_tmp18)), (collection_iface == NULL) ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL)), _tmp19);
				} else {
					if (vala_typesymbol_is_subtype_of (container_type, (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->map_type)) {
						ValaTypeSymbol* _tmp21;
						ValaTypeSymbol* _tmp20;
						_tmp21 = NULL;
						_tmp20 = NULL;
						collection_iface = (_tmp21 = (_tmp20 = (ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->map_type, (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20)), (collection_iface == NULL) ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL)), _tmp21);
					}
				}
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) collection_iface), "get"));
				get_params = vala_method_get_parameters (get_method);
				get_params_it = gee_iterable_iterator ((GeeIterable*) get_params);
				gee_iterator_next (get_params_it);
				get_param = (ValaFormalParameter*) gee_iterator_get (get_params_it);
				if (VALA_IS_GENERIC_TYPE (vala_formal_parameter_get_parameter_type (get_param))) {
					ValaDataType* index_type;
					ValaCCodeExpression* _tmp22;
					index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), VALA_GENERIC_TYPE (vala_formal_parameter_get_parameter_type (get_param)), (ValaCodeNode*) expr);
					_tmp22 = NULL;
					cindex = (_tmp22 = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, cindex, index_type), (cindex == NULL) ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL)), _tmp22);
					(index_type == NULL) ? NULL : (index_type = (vala_code_node_unref (index_type), NULL));
				}
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp25 = NULL;
				get_ccall = (_tmp25 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new (_tmp23 = vala_method_get_cname (get_method)))), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp23 = (g_free (_tmp23), NULL), _tmp25);
				_tmp28 = NULL;
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, (ValaCCodeExpression*) (_tmp28 = vala_ccode_cast_expression_new (ccontainer, _tmp27 = g_strconcat (_tmp26 = vala_typesymbol_get_cname (collection_iface, FALSE), "*", NULL))));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				_tmp27 = (g_free (_tmp27), NULL);
				_tmp26 = (g_free (_tmp26), NULL);
				vala_ccode_function_call_add_argument (get_ccall, cindex);
				_tmp29 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp29 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) get_ccall, vala_expression_get_value_type ((ValaExpression*) expr))));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				(collection_iface == NULL) ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL));
				(get_method == NULL) ? NULL : (get_method = (vala_code_node_unref (get_method), NULL));
				(get_params == NULL) ? NULL : (get_params = (gee_collection_object_unref (get_params), NULL));
				(get_params_it == NULL) ? NULL : (get_params_it = (gee_collection_object_unref (get_params_it), NULL));
				(get_param == NULL) ? NULL : (get_param = (vala_code_node_unref (get_param), NULL));
				(get_ccall == NULL) ? NULL : (get_ccall = (vala_ccode_node_unref (get_ccall), NULL));
			} else {
				ValaCCodeElementAccess* _tmp34;
				{
					gint i;
					/* access to element in an array*/
					i = 1;
					for (; i < rank; i++) {
						ValaCCodeExpression* _tmp30;
						ValaCCodeBinaryExpression* _tmp31;
						ValaCCodeBinaryExpression* cmul;
						ValaCCodeExpression* _tmp33;
						ValaExpression* _tmp32;
						_tmp30 = NULL;
						_tmp31 = NULL;
						cmul = (_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cindex, _tmp30 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_element_access_get_container (expr), i + 1)), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
						_tmp33 = NULL;
						_tmp32 = NULL;
						cindex = (_tmp33 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) cmul, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp32 = (ValaExpression*) gee_list_get ((GeeList*) indices, i))))), (cindex == NULL) ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL)), _tmp33);
						(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL));
						(cmul == NULL) ? NULL : (cmul = (vala_ccode_node_unref (cmul), NULL));
					}
				}
				_tmp34 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp34 = vala_ccode_element_access_new (ccontainer, cindex)));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
			}
		}
	}
	(indices == NULL) ? NULL : (indices = (gee_collection_object_unref (indices), NULL));
	(container_type == NULL) ? NULL : (container_type = (vala_code_node_unref (container_type), NULL));
	(ccontainer == NULL) ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL));
	(cindex == NULL) ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL));
}


static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self) {
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeCastExpression* _tmp1;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeElementAccess* _tmp3;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeConstant* _tmp6;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* cfreecond;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* cforcond;
	ValaCCodeBlock* cfreeblock;
	ValaCCodeExpressionStatement* _tmp11;
	ValaCCodeIfStatement* _tmp12;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp15;
	ValaCCodeConstant* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeAssignment* _tmp20;
	ValaCCodeBinaryExpression* _tmp19;
	ValaCCodeConstant* _tmp18;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeForStatement* _tmp21;
	g_return_val_if_fail (self != NULL, NULL);
	cbody = vala_ccode_block_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	cptrarray = (_tmp1 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("array")), "gpointer*"), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cea = (_tmp3 = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("i"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cfreecall = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("destroy_func"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) cea);
	_tmp6 = NULL;
	_tmp7 = NULL;
	cfreecond = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) cea, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new ("NULL"))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	cforcond = (_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("array_length"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp10);
	cfreeblock = vala_ccode_block_new ();
	_tmp11 = NULL;
	vala_ccode_block_add_statement (cfreeblock, (ValaCCodeNode*) (_tmp11 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp12 = vala_ccode_if_statement_new ((ValaCCodeExpression*) cfreecond, (ValaCCodeStatement*) cfreeblock, NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) cforcond, (ValaCCodeStatement*) cbody);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp15 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp21 = NULL;
	return (_tmp21 = cfor, (cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL)), (cptrarray == NULL) ? NULL : (cptrarray = (vala_ccode_node_unref (cptrarray), NULL)), (cea == NULL) ? NULL : (cea = (vala_ccode_node_unref (cea), NULL)), (cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL)), (cfreecond == NULL) ? NULL : (cfreecond = (vala_ccode_node_unref (cfreecond), NULL)), (cforcond == NULL) ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL)), (cfreeblock == NULL) ? NULL : (cfreeblock = (vala_ccode_node_unref (cfreeblock), NULL)), _tmp21);
}


static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeForStatement* _tmp5;
	ValaCCodeConstant* _tmp7;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp10;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeBinaryExpression* _tmp11;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	self = (ValaCCodeArrayModule*) base;
	fun = vala_ccode_function_new ("_vala_array_free", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1 = vala_ccode_formal_parameter_new ("array_length", "gint"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp2 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp3 = vala_ccode_function_copy (fun)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp4 = vala_ccode_variable_declarator_new ("i", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) citdecl);
	_tmp5 = NULL;
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) (_tmp5 = vala_ccode_array_module_get_vala_array_free_loop (self)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	ccondarr = (_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("array")), (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("NULL"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	ccondfunc = (_tmp11 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("destroy_func")), (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("NULL"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccondarr, (ValaCCodeExpression*) ccondfunc)), (ValaCCodeStatement*) cdofree, NULL), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_set_block (fun, _tmp14 = vala_ccode_block_new ());
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	_tmp15 = NULL;
	_tmp16 = NULL;
	carrfree = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_free"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("array")));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) carrfree)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cdofree == NULL) ? NULL : (cdofree = (vala_ccode_node_unref (cdofree), NULL));
	(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
	(ccondarr == NULL) ? NULL : (ccondarr = (vala_ccode_node_unref (ccondarr), NULL));
	(ccondfunc == NULL) ? NULL : (ccondfunc = (vala_ccode_node_unref (ccondfunc), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(carrfree == NULL) ? NULL : (carrfree = (vala_ccode_node_unref (carrfree), NULL));
}


static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeCastExpression* _tmp7;
	ValaCCodeCastExpression* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* _tmp11;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeBinaryExpression* _tmp14;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeConstant* _tmp22;
	ValaCCodeBinaryExpression* _tmp24;
	ValaCCodeBinaryExpression* _tmp23;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeConstant* _tmp28;
	ValaCCodeBinaryExpression* _tmp30;
	ValaCCodeBinaryExpression* _tmp29;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeIfStatement* _tmp33;
	ValaCCodeBinaryExpression* _tmp32;
	self = (ValaCCodeArrayModule*) base;
	((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1 = vala_ccode_formal_parameter_new ("element_size", "gsize"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp2 = vala_ccode_formal_parameter_new ("src", "gint"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp3 = vala_ccode_formal_parameter_new ("dest", "gint"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp4 = vala_ccode_formal_parameter_new ("length", "gint"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (fun)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	_tmp7 = NULL;
	array = (_tmp7 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("array")), "char*"), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp8 = NULL;
	_tmp9 = NULL;
	src_address = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) src, (ValaCCodeExpression*) element_size))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
	_tmp10 = NULL;
	_tmp11 = NULL;
	dest_address = (_tmp11 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) element_size))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	dest_end_address = (_tmp14 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) length)), (ValaCCodeExpression*) element_size))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_set_block (fun, _tmp15 = vala_ccode_block_new ());
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	_tmp17 = NULL;
	ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_memmove"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) dest_address);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) src_address);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) length, (ValaCCodeExpression*) element_size)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	_tmp21 = NULL;
	czero1 = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("memset"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) src_address);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("0")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp24 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp23 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) src)), (ValaCCodeExpression*) element_size)));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	czeroblock1 = vala_ccode_block_new ();
	_tmp25 = NULL;
	vala_ccode_block_add_statement (czeroblock1, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero1)));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	_tmp27 = NULL;
	czero2 = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("memset"))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp27);
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) dest_end_address);
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp28 = vala_ccode_constant_new ("0")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp30 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp29 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeExpression*) element_size)));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	czeroblock2 = vala_ccode_block_new ();
	_tmp31 = NULL;
	vala_ccode_block_add_statement (czeroblock2, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero2)));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp33 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeStatement*) czeroblock1, (ValaCCodeStatement*) czeroblock2)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(array == NULL) ? NULL : (array = (vala_ccode_node_unref (array), NULL));
	(element_size == NULL) ? NULL : (element_size = (vala_ccode_node_unref (element_size), NULL));
	(length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL));
	(src == NULL) ? NULL : (src = (vala_ccode_node_unref (src), NULL));
	(dest == NULL) ? NULL : (dest = (vala_ccode_node_unref (dest), NULL));
	(src_address == NULL) ? NULL : (src_address = (vala_ccode_node_unref (src_address), NULL));
	(dest_address == NULL) ? NULL : (dest_address = (vala_ccode_node_unref (dest_address), NULL));
	(dest_end_address == NULL) ? NULL : (dest_end_address = (vala_ccode_node_unref (dest_end_address), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(czero1 == NULL) ? NULL : (czero1 = (vala_ccode_node_unref (czero1), NULL));
	(czeroblock1 == NULL) ? NULL : (czeroblock1 = (vala_ccode_node_unref (czeroblock1), NULL));
	(czero2 == NULL) ? NULL : (czero2 = (vala_ccode_node_unref (czero2), NULL));
	(czeroblock2 == NULL) ? NULL : (czeroblock2 = (vala_ccode_node_unref (czeroblock2), NULL));
}


static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeBlock* block;
	ValaCCodeDeclaration* len_decl;
	ValaCCodeVariableDeclarator* _tmp3;
	ValaCCodeConstant* _tmp2;
	ValaCCodeBlock* non_null_block;
	ValaCCodeBlock* while_body;
	ValaCCodeExpressionStatement* _tmp6;
	ValaCCodeUnaryExpression* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp9;
	ValaCCodeCastExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeElementAccess* _tmp10;
	ValaCCodeElementAccess* array_element_check;
	ValaCCodeWhileStatement* _tmp11;
	ValaCCodeIdentifier* array_check;
	ValaCCodeIfStatement* _tmp12;
	ValaCCodeReturnStatement* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	self = (ValaCCodeArrayModule*) base;
	fun = vala_ccode_function_new ("_vala_array_length", "gint");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp1 = vala_ccode_function_copy (fun)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	block = vala_ccode_block_new ();
	len_decl = vala_ccode_declaration_new ("int");
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (len_decl, (ValaCCodeDeclarator*) (_tmp3 = vala_ccode_variable_declarator_new ("length", (ValaCCodeExpression*) (_tmp2 = vala_ccode_constant_new ("0")))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) len_decl);
	non_null_block = vala_ccode_block_new ();
	while_body = vala_ccode_block_new ();
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_block_add_statement (while_body, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("length")))))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp10 = NULL;
	array_element_check = (_tmp10 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("array")), "gpointer*")), (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("length"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp10);
	_tmp11 = NULL;
	vala_ccode_block_add_statement (non_null_block, (ValaCCodeNode*) (_tmp11 = vala_ccode_while_statement_new ((ValaCCodeExpression*) array_element_check, (ValaCCodeStatement*) while_body)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	/* return 0 if the array is NULL
	 avoids an extra NULL check on the caller side*/
	array_check = vala_ccode_identifier_new ("array");
	_tmp12 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12 = vala_ccode_if_statement_new ((ValaCCodeExpression*) array_check, (ValaCCodeStatement*) non_null_block, NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp14 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("length")))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_function_set_block (fun, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(len_decl == NULL) ? NULL : (len_decl = (vala_ccode_node_unref (len_decl), NULL));
	(non_null_block == NULL) ? NULL : (non_null_block = (vala_ccode_node_unref (non_null_block), NULL));
	(while_body == NULL) ? NULL : (while_body = (vala_ccode_node_unref (while_body), NULL));
	(array_element_check == NULL) ? NULL : (array_element_check = (vala_ccode_node_unref (array_element_check), NULL));
	(array_check == NULL) ? NULL : (array_check = (vala_ccode_node_unref (array_check), NULL));
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference) {
	ValaCCodeArrayModule * self;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		char* _tmp0;
		ValaCCodeExpression* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp0 = vala_ccode_array_module_generate_array_dup_wrapper (self, VALA_ARRAY_TYPE (type))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	} else {
		return VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_dup_func_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), type, source_reference);
	}
}


static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* dup_func;
	char* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp47;
	char* _tmp48;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_dup%d", (self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1));
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, dup_func)) {
		/* wrapper already defined*/
		return dup_func;
	}
	/* declaration*/
	_tmp1 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (dup_func, _tmp1 = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = vala_data_type_get_cname ((ValaDataType*) array_type)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	/* total length over all dimensions*/
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("length", "int"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type))) {
		GeeArrayList* _tmp6;
		GeeArrayList* old_temp_vars;
		char* _tmp7;
		ValaCCodeDeclaration* _tmp8;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* cvardecl;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeFunctionCall* _tmp10;
		ValaCCodeFunctionCall* gnew;
		ValaCCodeIdentifier* _tmp12;
		char* _tmp11;
		ValaCCodeIdentifier* _tmp13;
		ValaCCodeDeclaration* idx_decl;
		ValaCCodeVariableDeclarator* _tmp14;
		ValaCCodeBlock* loop_body;
		ValaCCodeExpressionStatement* _tmp23;
		ValaCCodeAssignment* _tmp22;
		ValaCCodeExpression* _tmp21;
		ValaCCodeElementAccess* _tmp20;
		ValaCCodeIdentifier* _tmp19;
		ValaCCodeIdentifier* _tmp18;
		ValaCCodeElementAccess* _tmp17;
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeIdentifier* _tmp15;
		ValaCCodeBinaryExpression* _tmp26;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeForStatement* _tmp27;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp30;
		ValaCCodeConstant* _tmp29;
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeUnaryExpression* _tmp32;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeReturnStatement* _tmp34;
		ValaCCodeIdentifier* _tmp33;
		ValaCCodeFragment* cfrag;
		GeeArrayList* _tmp36;
		GeeArrayList* _tmp35;
		_tmp6 = NULL;
		old_temp_vars = (_tmp6 = ((ValaCCodeBaseModule*) self)->temp_vars, (_tmp6 == NULL) ? NULL : gee_collection_object_ref (_tmp6));
		_tmp7 = NULL;
		_tmp8 = NULL;
		cdecl_ = (_tmp8 = vala_ccode_declaration_new (_tmp7 = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp7 = (g_free (_tmp7), NULL), _tmp8);
		cvardecl = vala_ccode_variable_declarator_new ("result", NULL);
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) cvardecl);
		_tmp9 = NULL;
		_tmp10 = NULL;
		gnew = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("g_new0"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		_tmp11 = (g_free (_tmp11), NULL);
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("length")));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		vala_ccode_variable_declarator_set_initializer (cvardecl, (ValaCCodeExpression*) gnew);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
		idx_decl = vala_ccode_declaration_new ("int");
		_tmp14 = NULL;
		vala_ccode_declaration_add_declarator (idx_decl, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new ("i", NULL)));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) idx_decl);
		loop_body = vala_ccode_block_new ();
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("i")))), _tmp21 = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp20 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("i")))), NULL, (ValaCodeNode*) array_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp27 = NULL;
		cfor = (_tmp27 = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("length")))), (ValaCCodeStatement*) loop_body), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp27);
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp30 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp29 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("i")))));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
		(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfor);
		_tmp34 = NULL;
		_tmp33 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("result")))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfrag);
		_tmp36 = NULL;
		_tmp35 = NULL;
		((ValaCCodeBaseModule*) self)->temp_vars = (_tmp36 = (_tmp35 = old_temp_vars, (_tmp35 == NULL) ? NULL : gee_collection_object_ref (_tmp35)), (((ValaCCodeBaseModule*) self)->temp_vars == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->temp_vars = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->temp_vars), NULL)), _tmp36);
		(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
		(gnew == NULL) ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL));
		(idx_decl == NULL) ? NULL : (idx_decl = (vala_ccode_node_unref (idx_decl), NULL));
		(loop_body == NULL) ? NULL : (loop_body = (vala_ccode_node_unref (loop_body), NULL));
		(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	} else {
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeFunctionCall* _tmp41;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeIdentifier* _tmp43;
		char* _tmp42;
		ValaCCodeBinaryExpression* _tmp45;
		ValaCCodeIdentifier* _tmp44;
		ValaCCodeReturnStatement* _tmp46;
		_tmp37 = NULL;
		_tmp38 = NULL;
		dup_call = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_memdup"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("self")));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		_tmp40 = NULL;
		_tmp41 = NULL;
		sizeof_call = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("sizeof"))), (_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)), _tmp41);
		_tmp43 = NULL;
		_tmp42 = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (_tmp42 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
		_tmp42 = (g_free (_tmp42), NULL);
		_tmp45 = NULL;
		_tmp44 = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("length")), (ValaCCodeExpression*) sizeof_call)));
		(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
		(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
		_tmp46 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp46 = vala_ccode_return_statement_new ((ValaCCodeExpression*) dup_call)));
		(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
		(dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL));
		(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
	}
	/* append to file*/
	_tmp47 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp47 = vala_ccode_function_copy (function)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp48 = NULL;
	return (_tmp48 = dup_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp48);
}


static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* add_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	char* typename;
	ValaCCodeExpression* value;
	ValaCCodeFormalParameter* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeUnaryExpression* array;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeUnaryExpression* _tmp14;
	ValaCCodeUnaryExpression* length;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeUnaryExpression* _tmp16;
	ValaCCodeUnaryExpression* size;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeFunctionCall* _tmp18;
	ValaCCodeFunctionCall* renew_call;
	ValaCCodeIdentifier* _tmp20;
	char* _tmp19;
	ValaCCodeBlock* resize_block;
	ValaCCodeExpressionStatement* _tmp26;
	ValaCCodeAssignment* _tmp25;
	ValaCCodeConditionalExpression* _tmp24;
	ValaCCodeConstant* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeExpressionStatement* _tmp28;
	ValaCCodeAssignment* _tmp27;
	ValaCCodeBinaryExpression* csizecheck;
	ValaCCodeIfStatement* _tmp29;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeElementAccess* _tmp31;
	ValaCCodeUnaryExpression* _tmp30;
	ValaCCodeFunction* _tmp34;
	char* _tmp35;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	add_func = g_strdup_printf ("_vala_array_add%d", (self->priv->next_array_add_id = self->priv->next_array_add_id + 1));
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, add_func)) {
		/* wrapper already defined*/
		return add_func;
	}
	/* declaration*/
	function = vala_ccode_function_new (add_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("array", _tmp2 = g_strconcat (_tmp1 = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("length", "int*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("size", "int*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	typename = vala_data_type_get_cname (vala_array_type_get_element_type (array_type));
	value = (ValaCCodeExpression*) vala_ccode_identifier_new ("value");
	if (vala_data_type_is_real_struct_type (vala_array_type_get_element_type (array_type))) {
		gboolean _tmp6;
		_tmp6 = FALSE;
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			_tmp6 = TRUE;
		} else {
			_tmp6 = !vala_data_type_get_value_owned (vala_array_type_get_element_type (array_type));
		}
		if (_tmp6) {
			char* _tmp7;
			_tmp7 = NULL;
			typename = (_tmp7 = g_strconcat ("const ", typename, NULL), typename = (g_free (typename), NULL), _tmp7);
		}
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			char* _tmp8;
			ValaCCodeExpression* _tmp9;
			_tmp8 = NULL;
			typename = (_tmp8 = g_strconcat (typename, ("*"), NULL), typename = (g_free (typename), NULL), _tmp8);
			_tmp9 = NULL;
			value = (_tmp9 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, value), (value == NULL) ? NULL : (value = (vala_ccode_node_unref (value), NULL)), _tmp9);
		}
	}
	_tmp10 = NULL;
	vala_ccode_function_add_parameter (function, _tmp10 = vala_ccode_formal_parameter_new ("value", typename));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	_tmp12 = NULL;
	array = (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("array"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
	_tmp13 = NULL;
	_tmp14 = NULL;
	length = (_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("length"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	_tmp15 = NULL;
	_tmp16 = NULL;
	size = (_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("size"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
	/* definition*/
	block = vala_ccode_block_new ();
	_tmp17 = NULL;
	_tmp18 = NULL;
	renew_call = (_tmp18 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("g_renew"))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp18);
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (_tmp19 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp19 = (g_free (_tmp19), NULL);
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) array);
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) size);
	resize_block = vala_ccode_block_new ();
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_assignment_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp24 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("2")), (ValaCCodeExpression*) size)), (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("4")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_assignment_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) renew_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	csizecheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) length, (ValaCCodeExpression*) size);
	_tmp29 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29 = vala_ccode_if_statement_new ((ValaCCodeExpression*) csizecheck, (ValaCCodeStatement*) resize_block, NULL)));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_element_access_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp30 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) length)))), value, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	/* append to file*/
	_tmp34 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp34 = vala_ccode_function_copy (function)));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp35 = NULL;
	return (_tmp35 = add_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), typename = (g_free (typename), NULL), (value == NULL) ? NULL : (value = (vala_ccode_node_unref (value), NULL)), (array == NULL) ? NULL : (array = (vala_ccode_node_unref (array), NULL)), (length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL)), (size == NULL) ? NULL : (size = (vala_ccode_node_unref (size), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (renew_call == NULL) ? NULL : (renew_call = (vala_ccode_node_unref (renew_call), NULL)), (resize_block == NULL) ? NULL : (resize_block = (vala_ccode_node_unref (resize_block), NULL)), (csizecheck == NULL) ? NULL : (csizecheck = (vala_ccode_node_unref (csizecheck), NULL)), _tmp35);
}


static void vala_ccode_array_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeNode* _tmp0;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpression* _tmp2;
	ValaCCodeIdentifier* cid;
	gboolean _tmp4;
	ValaMemberAccess* _tmp5;
	ValaMemberAccess* ma;
	GeeList* _tmp6;
	ValaDataType* _tmp7;
	ValaDataType* element_type;
	ValaCCodeIdentifier* _tmp9;
	char* _tmp8;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->visit_method_call ((ValaCCodeModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expr);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ccall = (_tmp1 = (_tmp0 = vala_code_node_get_ccodenode ((ValaCodeNode*) expr), VALA_IS_CCODE_FUNCTION_CALL (_tmp0) ? ((ValaCCodeFunctionCall*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	if (ccall == NULL) {
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		return;
	}
	_tmp3 = NULL;
	_tmp2 = NULL;
	cid = (_tmp3 = (_tmp2 = vala_ccode_function_call_get_call (ccall), VALA_IS_CCODE_IDENTIFIER (_tmp2) ? ((ValaCCodeIdentifier*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3));
	_tmp4 = FALSE;
	if (cid == NULL) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = _vala_strcmp0 (vala_ccode_identifier_get_name (cid), "g_array_index") != 0;
	}
	if (_tmp4) {
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
		return;
	}
	/* insert type argument in calls to g_array_index macro*/
	_tmp5 = NULL;
	ma = (_tmp5 = VALA_MEMBER_ACCESS (vala_method_call_get_call (expr)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	_tmp6 = NULL;
	_tmp7 = NULL;
	element_type = (_tmp7 = (ValaDataType*) gee_list_get (_tmp6 = vala_data_type_get_type_arguments (vala_expression_get_value_type (vala_member_access_get_inner (ma))), 0), (_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_function_call_insert_argument (ccall, 1, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (_tmp8 = vala_data_type_get_cname (element_type))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp8 = (g_free (_tmp8), NULL);
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
}


static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment) {
	ValaBinaryExpression* _tmp1;
	ValaExpression* _tmp0;
	ValaBinaryExpression* binary;
	gboolean _tmp2;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (assignment != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	binary = (_tmp1 = (_tmp0 = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0) ? ((ValaBinaryExpression*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (binary != NULL) {
		_tmp2 = VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (binary)));
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		if (vala_binary_expression_get_operator (binary) == VALA_BINARY_OPERATOR_PLUS) {
			if (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)) == vala_expression_get_symbol_reference (vala_binary_expression_get_left (binary))) {
				gboolean _tmp3;
				return (_tmp3 = TRUE, (binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL)), _tmp3);
			}
		}
	}
	return (_tmp4 = FALSE, (binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL)), _tmp4);
}


static void vala_ccode_array_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaCCodeArrayModule * self;
	ValaBinaryExpression* _tmp1;
	ValaExpression* _tmp0;
	ValaBinaryExpression* binary;
	ValaExpression* _tmp2;
	ValaExpression* array;
	ValaArrayType* _tmp3;
	ValaArrayType* array_type;
	ValaExpression* _tmp4;
	ValaExpression* element;
	ValaDataType* _tmp5;
	ValaFormalParameter* value_param;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeUnaryExpression* _tmp9;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeExpression* _tmp10;
	ValaCCodeUnaryExpression* _tmp13;
	ValaCCodeExpression* _tmp12;
	ValaCCodeExpression* _tmp14;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (assignment != NULL);
	if (!vala_ccode_array_module_is_array_add (self, assignment)) {
		VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->visit_assignment ((ValaCCodeModule*) VALA_CCODE_METHOD_CALL_MODULE (self), assignment);
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	binary = (_tmp1 = (_tmp0 = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0) ? ((ValaBinaryExpression*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	array = (_tmp2 = vala_binary_expression_get_left (binary), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	array_type = (_tmp3 = VALA_ARRAY_TYPE (vala_expression_get_value_type (array)), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = NULL;
	element = (_tmp4 = vala_binary_expression_get_right (binary), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
	vala_code_node_accept ((ValaCodeNode*) array, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp5 = NULL;
	vala_expression_set_target_type (element, _tmp5 = vala_data_type_copy (vala_array_type_get_element_type (array_type)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
	vala_code_node_accept ((ValaCodeNode*) element, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	value_param = vala_formal_parameter_new ("value", vala_expression_get_target_type (element), NULL);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_ccode_array_module_generate_array_add_wrapper (self, array_type)))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp6 = (g_free (_tmp6), NULL), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) array)))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10 = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array, -1))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp12 = vala_ccode_module_get_array_size_cexpression ((ValaCCodeModule*) self, array))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (ccall, _tmp14 = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, value_param, element, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) element))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) ccall);
	(binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL));
	(array == NULL) ? NULL : (array = (vala_code_node_unref (array), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(element == NULL) ? NULL : (element = (vala_code_node_unref (element), NULL));
	(value_param == NULL) ? NULL : (value_param = (vala_code_node_unref (value_param), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_array_module_class_init (ValaCCodeArrayModuleClass * klass) {
	vala_ccode_array_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_array_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeArrayModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->visit_array_creation_expression = vala_ccode_array_module_real_visit_array_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cname = vala_ccode_array_module_real_get_array_length_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cexpression = vala_ccode_array_module_real_get_array_length_cexpression;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_size_cname = vala_ccode_array_module_real_get_array_size_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_size_cexpression = vala_ccode_array_module_real_get_array_size_cexpression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_element_access = vala_ccode_array_module_real_visit_element_access;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_array_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_array_module_real_append_vala_array_move;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_length = vala_ccode_array_module_real_append_vala_array_length;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_array_module_real_get_dup_func_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_array_module_real_visit_method_call;
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_ccode_array_module_real_visit_assignment;
}


static void vala_ccode_array_module_instance_init (ValaCCodeArrayModule * self) {
	self->priv = VALA_CCODE_ARRAY_MODULE_GET_PRIVATE (self);
	self->priv->next_array_dup_id = 0;
	self->priv->next_array_add_id = 0;
}


static void vala_ccode_array_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeArrayModule * self;
	self = VALA_CCODE_ARRAY_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->finalize (obj);
}


GType vala_ccode_array_module_get_type (void) {
	static GType vala_ccode_array_module_type_id = 0;
	if (vala_ccode_array_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayModule), 0, (GInstanceInitFunc) vala_ccode_array_module_instance_init, NULL };
		vala_ccode_array_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_CALL_MODULE, "ValaCCodeArrayModule", &g_define_type_info, 0);
	}
	return vala_ccode_array_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




