/* valayieldstatement.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valayieldstatement.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>




struct _ValaYieldStatementPrivate {
	ValaExpression* _yield_expression;
};

#define VALA_YIELD_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementPrivate))
enum  {
	VALA_YIELD_STATEMENT_DUMMY_PROPERTY
};
static void vala_yield_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_yield_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_yield_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_yield_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_yield_statement_parent_class = NULL;
static ValaStatementIface* vala_yield_statement_vala_statement_parent_iface = NULL;
static void vala_yield_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new yield statement.
 *
 * @param yield_expression the yield expression
 * @param source_reference reference to source code
 * @return                 newly created yield statement
 */
ValaYieldStatement* vala_yield_statement_construct (GType object_type, ValaExpression* yield_expression, ValaSourceReference* source_reference) {
	ValaYieldStatement* self;
	self = (ValaYieldStatement*) g_type_create_instance (object_type);
	vala_yield_statement_set_yield_expression (self, yield_expression);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaYieldStatement* vala_yield_statement_new (ValaExpression* yield_expression, ValaSourceReference* source_reference) {
	return vala_yield_statement_construct (VALA_TYPE_YIELD_STATEMENT, yield_expression, source_reference);
}


static void vala_yield_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaYieldStatement * self;
	self = (ValaYieldStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_yield_statement (visitor, self);
}


static void vala_yield_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaYieldStatement * self;
	self = (ValaYieldStatement*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_yield_statement_get_yield_expression (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_yield_statement_get_yield_expression (self), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_yield_statement_get_yield_expression (self));
	}
}


static void vala_yield_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaYieldStatement * self;
	self = (ValaYieldStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_yield_statement_get_yield_expression (self) == old_node) {
		vala_yield_statement_set_yield_expression (self, new_node);
	}
}


static gboolean vala_yield_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaYieldStatement * self;
	self = (ValaYieldStatement*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_yield_statement_get_yield_expression (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_yield_statement_get_yield_expression (self), analyzer);
		vala_code_node_set_error ((ValaCodeNode*) self, vala_code_node_get_error ((ValaCodeNode*) vala_yield_statement_get_yield_expression (self)));
	}
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


ValaExpression* vala_yield_statement_get_yield_expression (ValaYieldStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_yield_expression;
}


void vala_yield_statement_set_yield_expression (ValaYieldStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_yield_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_yield_expression == NULL) ? NULL : (self->priv->_yield_expression = (vala_code_node_unref (self->priv->_yield_expression), NULL)), _tmp2);
	if (self->priv->_yield_expression != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_yield_expression, (ValaCodeNode*) self);
	}
}


static void vala_yield_statement_class_init (ValaYieldStatementClass * klass) {
	vala_yield_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_yield_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaYieldStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_yield_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_yield_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_yield_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_yield_statement_real_check;
}


static void vala_yield_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_yield_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_yield_statement_instance_init (ValaYieldStatement * self) {
	self->priv = VALA_YIELD_STATEMENT_GET_PRIVATE (self);
}


static void vala_yield_statement_finalize (ValaCodeNode* obj) {
	ValaYieldStatement * self;
	self = VALA_YIELD_STATEMENT (obj);
	(self->priv->_yield_expression == NULL) ? NULL : (self->priv->_yield_expression = (vala_code_node_unref (self->priv->_yield_expression), NULL));
	VALA_CODE_NODE_CLASS (vala_yield_statement_parent_class)->finalize (obj);
}


GType vala_yield_statement_get_type (void) {
	static GType vala_yield_statement_type_id = 0;
	if (vala_yield_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaYieldStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_yield_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaYieldStatement), 0, (GInstanceInitFunc) vala_yield_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_yield_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_yield_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaYieldStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_yield_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_yield_statement_type_id;
}




