/* valainitializervala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valainitializerlist.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valareport.h>
#include <vala/valaarraytype.h>
#include <vala/valadatatype.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valaunaryexpression.h>




struct _ValaInitializerListPrivate {
	GeeList* initializers;
};

#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
enum  {
	VALA_INITIALIZER_LIST_DUMMY_PROPERTY
};
static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_initializer_list_parent_class = NULL;
static void vala_initializer_list_finalize (ValaCodeNode* obj);



/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_collection_add ((GeeCollection*) self->priv->initializers, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
GeeList* vala_initializer_list_get_initializers (ValaInitializerList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->initializers);
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaInitializerList* self;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference) {
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeIterator* _expr_it;
		_expr_it = gee_iterable_iterator ((GeeIterable*) self->priv->initializers);
		while (gee_iterator_next (_expr_it)) {
			ValaExpression* expr;
			expr = (ValaExpression*) gee_iterator_get (_expr_it);
			vala_code_node_accept ((ValaCodeNode*) expr, visitor);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
		}
		(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
	}
}


static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
}


static gboolean vala_initializer_list_real_is_pure (ValaExpression* base) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	{
		GeeIterator* _initializer_it;
		_initializer_it = gee_iterable_iterator ((GeeIterable*) self->priv->initializers);
		while (gee_iterator_next (_initializer_it)) {
			ValaExpression* initializer;
			initializer = (ValaExpression*) gee_iterator_get (_initializer_it);
			if (!vala_expression_is_pure (initializer)) {
				gboolean _tmp0;
				return (_tmp0 = FALSE, (initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL)), (_initializer_it == NULL) ? NULL : (_initializer_it = (gee_collection_object_unref (_initializer_it), NULL)), _tmp0);
			}
			(initializer == NULL) ? NULL : (initializer = (vala_code_node_unref (initializer), NULL));
		}
		(_initializer_it == NULL) ? NULL : (_initializer_it = (gee_collection_object_unref (_initializer_it), NULL));
	}
	return TRUE;
}


static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i;
		i = 0;
		for (; i < gee_collection_get_size ((GeeCollection*) self->priv->initializers); i++) {
			ValaExpression* _tmp0;
			gboolean _tmp1;
			_tmp0 = NULL;
			if ((_tmp1 = (_tmp0 = (ValaExpression*) gee_list_get ((GeeList*) self->priv->initializers, i)) == old_node, (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1)) {
				gee_list_set ((GeeList*) self->priv->initializers, i, new_node);
			}
		}
	}
}


static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaInitializerList * self;
	gboolean error;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (vala_expression_get_target_type ((ValaExpression*) self) == NULL) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "initializer list used for unknown type");
		return FALSE;
	} else {
		if (VALA_IS_ARRAY_TYPE (vala_expression_get_target_type ((ValaExpression*) self))) {
			ValaArrayType* _tmp2;
			ValaArrayType* array_type;
			/* initializer is used as array initializer */
			_tmp2 = NULL;
			array_type = (_tmp2 = VALA_ARRAY_TYPE (vala_expression_get_target_type ((ValaExpression*) self)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			{
				GeeList* _tmp3;
				GeeIterator* _tmp4;
				GeeIterator* _e_it;
				_tmp3 = NULL;
				_tmp4 = NULL;
				_e_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_initializer_list_get_initializers (self))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
				while (gee_iterator_next (_e_it)) {
					ValaExpression* e;
					ValaDataType* _tmp5;
					e = (ValaExpression*) gee_iterator_get (_e_it);
					_tmp5 = NULL;
					vala_expression_set_target_type (e, _tmp5 = vala_data_type_copy (vala_array_type_get_element_type (array_type)));
					(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
					(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
				}
				(_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) self)))) {
				ValaStruct* _tmp6;
				ValaStruct* st;
				GeeList* _tmp7;
				GeeIterator* _tmp8;
				GeeIterator* field_it;
				/* initializer is used as struct initializer */
				_tmp6 = NULL;
				st = (_tmp6 = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) self))), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
				_tmp7 = NULL;
				_tmp8 = NULL;
				field_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_struct_get_fields (st))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
				{
					GeeList* _tmp9;
					GeeIterator* _tmp10;
					GeeIterator* _e_it;
					_tmp9 = NULL;
					_tmp10 = NULL;
					_e_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_initializer_list_get_initializers (self))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
					while (gee_iterator_next (_e_it)) {
						ValaExpression* e;
						ValaField* field;
						ValaDataType* _tmp16;
						e = (ValaExpression*) gee_iterator_get (_e_it);
						field = NULL;
						while (field == NULL) {
							ValaField* _tmp14;
							if (!gee_iterator_next (field_it)) {
								char* _tmp12;
								char* _tmp11;
								gboolean _tmp13;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp12 = NULL;
								_tmp11 = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) e), _tmp12 = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp11 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type ((ValaExpression*) self))));
								_tmp12 = (g_free (_tmp12), NULL);
								_tmp11 = (g_free (_tmp11), NULL);
								return (_tmp13 = FALSE, (e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL)), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), (_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL)), _tmp13);
							}
							_tmp14 = NULL;
							field = (_tmp14 = (ValaField*) gee_iterator_get (field_it), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp14);
							if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
								ValaField* _tmp15;
								/* we only initialize instance fields*/
								_tmp15 = NULL;
								field = (_tmp15 = NULL, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp15);
							}
						}
						_tmp16 = NULL;
						vala_expression_set_target_type (e, _tmp16 = vala_data_type_copy (vala_field_get_field_type (field)));
						(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL));
						if (!vala_data_type_get_value_owned (vala_expression_get_target_type ((ValaExpression*) self))) {
							vala_data_type_set_value_owned (vala_expression_get_target_type (e), FALSE);
						}
						(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
						(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
					}
					(_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL));
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL));
			} else {
				char* _tmp18;
				char* _tmp17;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp18 = NULL;
				_tmp17 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp18 = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp17 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type ((ValaExpression*) self))));
				_tmp18 = (g_free (_tmp18), NULL);
				_tmp17 = (g_free (_tmp17), NULL);
				return FALSE;
			}
		}
	}
	{
		GeeIterator* _expr_it;
		_expr_it = gee_iterable_iterator ((GeeIterable*) self->priv->initializers);
		while (gee_iterator_next (_expr_it)) {
			ValaExpression* expr;
			expr = (ValaExpression*) gee_iterator_get (_expr_it);
			vala_code_node_check ((ValaCodeNode*) expr, analyzer);
			(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
		}
		(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
	}
	error = FALSE;
	{
		GeeList* _tmp20;
		GeeIterator* _tmp21;
		GeeIterator* _e_it;
		_tmp20 = NULL;
		_tmp21 = NULL;
		_e_it = (_tmp21 = gee_iterable_iterator ((GeeIterable*) (_tmp20 = vala_initializer_list_get_initializers (self))), (_tmp20 == NULL) ? NULL : (_tmp20 = (gee_collection_object_unref (_tmp20), NULL)), _tmp21);
		while (gee_iterator_next (_e_it)) {
			ValaExpression* e;
			ValaUnaryExpression* _tmp23;
			ValaExpression* _tmp22;
			ValaUnaryExpression* unary;
			gboolean _tmp24;
			e = (ValaExpression*) gee_iterator_get (_e_it);
			if (vala_expression_get_value_type (e) == NULL) {
				error = TRUE;
				(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
				continue;
			}
			_tmp23 = NULL;
			_tmp22 = NULL;
			unary = (_tmp23 = (_tmp22 = e, VALA_IS_UNARY_EXPRESSION (_tmp22) ? ((ValaUnaryExpression*) _tmp22) : NULL), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
			_tmp24 = FALSE;
			if (unary != NULL) {
				gboolean _tmp25;
				_tmp25 = FALSE;
				if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
					_tmp25 = TRUE;
				} else {
					_tmp25 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp24 = (_tmp25);
			} else {
				_tmp24 = FALSE;
			}
			if (_tmp24) {
			} else {
				if (!vala_data_type_compatible (vala_expression_get_value_type (e), vala_expression_get_target_type (e))) {
					char* _tmp28;
					char* _tmp27;
					char* _tmp26;
					error = TRUE;
					vala_code_node_set_error ((ValaCodeNode*) e, TRUE);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp26 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) e), _tmp28 = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp26 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type (e)), _tmp27 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (e))));
					_tmp28 = (g_free (_tmp28), NULL);
					_tmp27 = (g_free (_tmp27), NULL);
					_tmp26 = (g_free (_tmp26), NULL);
				}
			}
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
			(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
		}
		(_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL));
	}
	if (!error) {
		/* everything seems to be correct */
		vala_expression_set_value_type ((ValaExpression*) self, vala_expression_get_target_type ((ValaExpression*) self));
	}
	return !error;
}


gint vala_initializer_list_get_size (ValaInitializerList* self) {
	g_return_val_if_fail (self != NULL, 0);
	return gee_collection_get_size ((GeeCollection*) self->priv->initializers);
}


static void vala_initializer_list_class_init (ValaInitializerListClass * klass) {
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_initializer_list_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_initializer_list_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_initializer_list_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_initializer_list_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_initializer_list_real_check;
}


static void vala_initializer_list_instance_init (ValaInitializerList * self) {
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	self->priv->initializers = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_initializer_list_finalize (ValaCodeNode* obj) {
	ValaInitializerList * self;
	self = VALA_INITIALIZER_LIST (obj);
	(self->priv->initializers == NULL) ? NULL : (self->priv->initializers = (gee_collection_object_unref (self->priv->initializers), NULL));
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


GType vala_initializer_list_get_type (void) {
	static GType vala_initializer_list_type_id = 0;
	if (vala_initializer_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
	}
	return vala_initializer_list_type_id;
}




