/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valatyperegisterfunction.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaobjecttypesymbol.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valastruct.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/gvaluecollector.h>




struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCodeContext* _context;
};

#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
static gpointer vala_typeregister_function_parent_class = NULL;
static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp1;
	gboolean _tmp2;
	char* _tmp4;
	ValaTypeSymbol* _tmp3;
	char* _tmp5;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* fun;
	char* type_value_table_decl_name;
	ValaCCodeBlock* type_init;
	ValaTypeSymbol* _tmp41;
	gboolean _tmp42;
	ValaCCodeFragment* _tmp54;
	ValaCCodeFunctionCall* reg_call;
	ValaTypeSymbol* _tmp55;
	gboolean _tmp56;
	ValaCCodeConstant* _tmp75;
	char* _tmp74;
	char* _tmp73;
	ValaTypeSymbol* _tmp72;
	ValaTypeSymbol* _tmp76;
	gboolean _tmp77;
	gboolean _tmp88;
	ValaCCodeFragment* _tmp93;
	ValaCCodeFunction* _tmp116;
	g_return_if_fail (self != NULL);
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_context, 2, 14);
	fundamental = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = vala_typeregister_function_get_type_declaration (self), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL);
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = !vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		_tmp1 = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		fundamental = TRUE;
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	type_id_name = (_tmp5 = g_strdup_printf ("%s_type_id", _tmp4 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp3 = vala_typeregister_function_get_type_declaration (self)), NULL)), _tmp4 = (g_free (_tmp4), NULL), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)), _tmp5);
	type_block = vala_ccode_block_new ();
	cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp6;
		ValaCCodeVariableDeclarator* _tmp9;
		ValaCCodeConstant* _tmp8;
		char* _tmp7;
		_tmp6 = NULL;
		cdecl_ = (_tmp6 = vala_ccode_declaration_new ("gsize"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp6);
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new_with_initializer (_tmp7 = g_strconcat (type_id_name, "__volatile", NULL), (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("0")))));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp7 = (g_free (_tmp7), NULL);
	} else {
		ValaCCodeDeclaration* _tmp10;
		ValaCCodeVariableDeclarator* _tmp12;
		ValaCCodeConstant* _tmp11;
		_tmp10 = NULL;
		cdecl_ = (_tmp10 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("0")))));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	}
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (cdecl_, vala_ccode_declaration_get_modifiers (cdecl_) | (VALA_CCODE_MODIFIERS_VOLATILE));
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cdecl_);
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) cdecl_);
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp16;
		char* _tmp15;
		char* _tmp14;
		ValaTypeSymbol* _tmp13;
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		fun = (_tmp16 = vala_ccode_function_new (_tmp15 = g_strdup_printf ("%s_get_type", _tmp14 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp13 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp16);
		_tmp15 = (g_free (_tmp15), NULL);
		_tmp14 = (g_free (_tmp14), NULL);
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_code_node_unref (_tmp13), NULL));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp20;
		char* _tmp19;
		char* _tmp18;
		ValaTypeSymbol* _tmp17;
		ValaCCodeFormalParameter* _tmp21;
		char* _tmp24;
		char* _tmp23;
		ValaTypeSymbol* _tmp22;
		ValaCCodeFunction* _tmp25;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp26;
		ValaCCodeBlock* _tmp27;
		ValaCCodeReturnStatement* _tmp29;
		ValaCCodeIdentifier* _tmp28;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		fun = (_tmp20 = vala_ccode_function_new (_tmp19 = g_strdup_printf ("%s_register_type", _tmp18 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp17 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp20);
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_code_node_unref (_tmp17), NULL));
		_tmp21 = NULL;
		vala_ccode_function_add_parameter (fun, _tmp21 = vala_ccode_formal_parameter_new ("module", "GTypeModule *"));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		_tmp24 = NULL;
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp25 = NULL;
		get_fun = (_tmp25 = vala_ccode_function_new (_tmp24 = g_strdup_printf ("%s_get_type", _tmp23 = vala_symbol_get_lower_case_cname ((ValaSymbol*) (_tmp22 = vala_typeregister_function_get_type_declaration (self)), NULL)), "GType"), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)), _tmp25);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp26 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp26 = vala_ccode_function_copy (get_fun)));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		_tmp27 = NULL;
		vala_ccode_function_set_block (get_fun, _tmp27 = vala_ccode_block_new ());
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), (ValaCCodeNode*) (_tmp29 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new (type_id_name)))));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) get_fun);
		(get_fun == NULL) ? NULL : (get_fun = (vala_ccode_node_unref (get_fun), NULL));
	}
	type_value_table_decl_name = NULL;
	type_init = vala_ccode_block_new ();
	if (fundamental) {
		ValaCCodeDeclaration* cgtypetabledecl;
		ValaCCodeVariableDeclarator* _tmp38;
		ValaCCodeConstant* _tmp37;
		char* _tmp36;
		char* _tmp35;
		char* _tmp34;
		char* _tmp33;
		char* _tmp32;
		char* _tmp31;
		char* _tmp30;
		char* _tmp39;
		cgtypetabledecl = vala_ccode_declaration_new ("const GTypeValueTable");
		vala_ccode_declaration_set_modifiers (cgtypetabledecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp38 = NULL;
		_tmp37 = NULL;
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_declaration_add_declarator (cgtypetabledecl, (ValaCCodeDeclarator*) (_tmp38 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_value_table", (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new (_tmp36 = g_strdup_printf ("{ %s, %s, %s, %s, \"p\", %s, \"p\", %s }", _tmp30 = vala_typeregister_function_get_gtype_value_table_init_function_name (self), _tmp31 = vala_typeregister_function_get_gtype_value_table_free_function_name (self), _tmp32 = vala_typeregister_function_get_gtype_value_table_copy_function_name (self), _tmp33 = vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (self), _tmp34 = vala_typeregister_function_get_gtype_value_table_collect_value_function_name (self), _tmp35 = vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (self)))))));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		_tmp36 = (g_free (_tmp36), NULL);
		_tmp35 = (g_free (_tmp35), NULL);
		_tmp34 = (g_free (_tmp34), NULL);
		_tmp33 = (g_free (_tmp33), NULL);
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp30 = (g_free (_tmp30), NULL);
		_tmp39 = NULL;
		type_value_table_decl_name = (_tmp39 = g_strdup ("&g_define_type_value_table"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp39);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cgtypetabledecl);
		(cgtypetabledecl == NULL) ? NULL : (cgtypetabledecl = (vala_ccode_node_unref (cgtypetabledecl), NULL));
	} else {
		char* _tmp40;
		_tmp40 = NULL;
		type_value_table_decl_name = (_tmp40 = g_strdup ("NULL"), type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL), _tmp40);
	}
	_tmp41 = NULL;
	if ((_tmp42 = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp41 = vala_typeregister_function_get_type_declaration (self)), (_tmp41 == NULL) ? NULL : (_tmp41 = (vala_code_node_unref (_tmp41), NULL)), _tmp42)) {
		ValaCCodeDeclaration* ctypedecl;
		ValaCCodeVariableDeclarator* _tmp51;
		ValaCCodeConstant* _tmp50;
		char* _tmp49;
		char* _tmp48;
		char* _tmp47;
		char* _tmp46;
		char* _tmp45;
		char* _tmp44;
		char* _tmp43;
		ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
		vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp51 = NULL;
		_tmp50 = NULL;
		_tmp49 = NULL;
		_tmp48 = NULL;
		_tmp47 = NULL;
		_tmp46 = NULL;
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp51 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", (ValaCCodeExpression*) (_tmp50 = vala_ccode_constant_new (_tmp49 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) %s, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s, %s }", _tmp43 = vala_typeregister_function_get_type_struct_name (self), _tmp44 = vala_typeregister_function_get_base_init_func_name (self), _tmp45 = vala_typeregister_function_get_base_finalize_func_name (self), _tmp46 = vala_typeregister_function_get_class_init_func_name (self), _tmp47 = vala_typeregister_function_get_instance_struct_size (self), _tmp48 = vala_typeregister_function_get_instance_init_func_name (self), type_value_table_decl_name))))));
		(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
		_tmp49 = (g_free (_tmp49), NULL);
		_tmp48 = (g_free (_tmp48), NULL);
		_tmp47 = (g_free (_tmp47), NULL);
		_tmp46 = (g_free (_tmp46), NULL);
		_tmp45 = (g_free (_tmp45), NULL);
		_tmp44 = (g_free (_tmp44), NULL);
		_tmp43 = (g_free (_tmp43), NULL);
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypedecl);
		if (fundamental) {
			ValaCCodeDeclaration* ctypefundamentaldecl;
			ValaCCodeVariableDeclarator* _tmp53;
			ValaCCodeConstant* _tmp52;
			ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
			vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
			_tmp53 = NULL;
			_tmp52 = NULL;
			vala_ccode_declaration_add_declarator (ctypefundamentaldecl, (ValaCCodeDeclarator*) (_tmp53 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_fundamental_info", (ValaCCodeExpression*) (_tmp52 = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")))));
			(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
			(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) ctypefundamentaldecl);
			(ctypefundamentaldecl == NULL) ? NULL : (ctypefundamentaldecl = (vala_ccode_node_unref (ctypefundamentaldecl), NULL));
		}
		(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	}
	_tmp54 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp54 = vala_typeregister_function_get_type_interface_init_declaration (self)));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	reg_call = NULL;
	_tmp55 = NULL;
	if ((_tmp56 = VALA_IS_STRUCT (_tmp55 = vala_typeregister_function_get_type_declaration (self)), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_code_node_unref (_tmp55), NULL)), _tmp56)) {
		ValaCCodeFunctionCall* _tmp58;
		ValaCCodeIdentifier* _tmp57;
		_tmp58 = NULL;
		_tmp57 = NULL;
		reg_call = (_tmp58 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("g_boxed_type_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp58);
		(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	} else {
		if (fundamental) {
			ValaCCodeFunctionCall* _tmp60;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeFunctionCall* _tmp62;
			ValaCCodeIdentifier* _tmp61;
			_tmp60 = NULL;
			_tmp59 = NULL;
			reg_call = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("g_type_register_fundamental"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp60);
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			_tmp62 = NULL;
			_tmp61 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp62 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("g_type_fundamental_next")))));
			(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
			(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
		} else {
			if (!plugin) {
				ValaCCodeFunctionCall* _tmp64;
				ValaCCodeIdentifier* _tmp63;
				ValaCCodeIdentifier* _tmp66;
				char* _tmp65;
				_tmp64 = NULL;
				_tmp63 = NULL;
				reg_call = (_tmp64 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new ("g_type_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp64);
				(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
				_tmp66 = NULL;
				_tmp65 = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new (_tmp65 = vala_typeregister_function_get_parent_type_name (self))));
				(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
				_tmp65 = (g_free (_tmp65), NULL);
			} else {
				ValaCCodeFunctionCall* _tmp68;
				ValaCCodeIdentifier* _tmp67;
				ValaCCodeIdentifier* _tmp69;
				ValaCCodeIdentifier* _tmp71;
				char* _tmp70;
				_tmp68 = NULL;
				_tmp67 = NULL;
				reg_call = (_tmp68 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("g_type_module_register_type"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp68);
				(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
				_tmp69 = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("module")));
				(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
				_tmp71 = NULL;
				_tmp70 = NULL;
				vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp71 = vala_ccode_identifier_new (_tmp70 = vala_typeregister_function_get_parent_type_name (self))));
				(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
				_tmp70 = (g_free (_tmp70), NULL);
			}
		}
	}
	_tmp75 = NULL;
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp75 = vala_ccode_constant_new (_tmp74 = g_strdup_printf ("\"%s\"", _tmp73 = vala_typesymbol_get_cname (_tmp72 = vala_typeregister_function_get_type_declaration (self), FALSE)))));
	(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
	_tmp74 = (g_free (_tmp74), NULL);
	_tmp73 = (g_free (_tmp73), NULL);
	(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_code_node_unref (_tmp72), NULL));
	_tmp76 = NULL;
	if ((_tmp77 = VALA_IS_STRUCT (_tmp76 = vala_typeregister_function_get_type_declaration (self)), (_tmp76 == NULL) ? NULL : (_tmp76 = (vala_code_node_unref (_tmp76), NULL)), _tmp77)) {
		ValaStruct* st;
		ValaCCodeCastExpression* _tmp80;
		ValaCCodeIdentifier* _tmp79;
		char* _tmp78;
		ValaCCodeCastExpression* _tmp83;
		ValaCCodeIdentifier* _tmp82;
		char* _tmp81;
		st = VALA_STRUCT (vala_typeregister_function_get_type_declaration (self));
		_tmp80 = NULL;
		_tmp79 = NULL;
		_tmp78 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp80 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp79 = vala_ccode_identifier_new (_tmp78 = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st))), "GBoxedCopyFunc")));
		(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
		(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
		_tmp78 = (g_free (_tmp78), NULL);
		_tmp83 = NULL;
		_tmp82 = NULL;
		_tmp81 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp83 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new (_tmp81 = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st))), "GBoxedFreeFunc")));
		(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
		_tmp81 = (g_free (_tmp81), NULL);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		ValaCCodeIdentifier* _tmp84;
		ValaCCodeConstant* _tmp87;
		char* _tmp86;
		_tmp84 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("&g_define_type_info")));
		(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
		if (fundamental) {
			ValaCCodeIdentifier* _tmp85;
			_tmp85 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("&g_define_type_fundamental_info")));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
		}
		_tmp87 = NULL;
		_tmp86 = NULL;
		vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp87 = vala_ccode_constant_new (_tmp86 = vala_typeregister_function_get_type_flags (self))));
		(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
		_tmp86 = (g_free (_tmp86), NULL);
	}
	_tmp88 = FALSE;
	if (use_thread_safe) {
		_tmp88 = !plugin;
	} else {
		_tmp88 = FALSE;
	}
	if (_tmp88) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp89;
		temp_decl = vala_ccode_declaration_new ("GType");
		_tmp89 = NULL;
		vala_ccode_declaration_add_declarator (temp_decl, (ValaCCodeDeclarator*) (_tmp89 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, (ValaCCodeExpression*) reg_call)));
		(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) temp_decl);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_ccode_node_unref (temp_decl), NULL));
	} else {
		ValaCCodeExpressionStatement* _tmp92;
		ValaCCodeAssignment* _tmp91;
		ValaCCodeIdentifier* _tmp90;
		_tmp92 = NULL;
		_tmp91 = NULL;
		_tmp90 = NULL;
		vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp92 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
		(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
		(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
	}
	_tmp93 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp93 = vala_typeregister_function_get_type_interface_init_statements (self)));
	(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		/* the condition that guards the type initialisation*/
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp94;
			ValaCCodeFunctionCall* _tmp95;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp98;
			ValaCCodeIdentifier* _tmp97;
			char* _tmp96;
			ValaCCodeExpression* _tmp100;
			ValaCCodeExpression* _tmp99;
			ValaCCodeIdentifier* _tmp101;
			ValaCCodeFunctionCall* _tmp102;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp105;
			ValaCCodeIdentifier* _tmp104;
			char* _tmp103;
			ValaCCodeIdentifier* _tmp106;
			ValaCCodeExpressionStatement* _tmp107;
			_tmp94 = NULL;
			_tmp95 = NULL;
			enter = (_tmp95 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("g_once_init_enter"))), (_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)), _tmp95);
			_tmp98 = NULL;
			_tmp97 = NULL;
			_tmp96 = NULL;
			vala_ccode_function_call_add_argument (enter, (ValaCCodeExpression*) (_tmp98 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp97 = vala_ccode_identifier_new (_tmp96 = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
			(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
			_tmp96 = (g_free (_tmp96), NULL);
			_tmp100 = NULL;
			_tmp99 = NULL;
			condition = (_tmp100 = (_tmp99 = (ValaCCodeExpression*) enter, (_tmp99 == NULL) ? NULL : vala_ccode_node_ref (_tmp99)), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp100);
			_tmp101 = NULL;
			_tmp102 = NULL;
			leave = (_tmp102 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new ("g_once_init_leave"))), (_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)), _tmp102);
			_tmp105 = NULL;
			_tmp104 = NULL;
			_tmp103 = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp105 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp104 = vala_ccode_identifier_new (_tmp103 = g_strconcat (type_id_name, "__volatile", NULL))))));
			(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
			(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
			_tmp103 = (g_free (_tmp103), NULL);
			_tmp106 = NULL;
			vala_ccode_function_call_add_argument (leave, (ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new (type_id_name)));
			(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
			_tmp107 = NULL;
			vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp107 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) leave)));
			(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
			(enter == NULL) ? NULL : (enter = (vala_ccode_node_unref (enter), NULL));
			(leave == NULL) ? NULL : (leave = (vala_ccode_node_unref (leave), NULL));
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp108;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			_tmp108 = NULL;
			condition = (_tmp108 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) id, (ValaCCodeExpression*) zero), (condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)), _tmp108);
			(id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL));
			(zero == NULL) ? NULL : (zero = (vala_ccode_node_unref (zero), NULL));
		}
		cif = vala_ccode_if_statement_new (condition, (ValaCCodeStatement*) type_init, NULL);
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) cif);
		(condition == NULL) ? NULL : (condition = (vala_ccode_node_unref (condition), NULL));
		(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	} else {
		ValaCCodeBlock* _tmp110;
		ValaCCodeBlock* _tmp109;
		_tmp110 = NULL;
		_tmp109 = NULL;
		type_block = (_tmp110 = (_tmp109 = type_init, (_tmp109 == NULL) ? NULL : vala_ccode_node_ref (_tmp109)), (type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL)), _tmp110);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp113;
		ValaCCodeIdentifier* _tmp112;
		char* _tmp111;
		_tmp113 = NULL;
		_tmp112 = NULL;
		_tmp111 = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp113 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp112 = vala_ccode_identifier_new (_tmp111 = g_strconcat (type_id_name, "__volatile", NULL))))));
		(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
		(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
		_tmp111 = (g_free (_tmp111), NULL);
	} else {
		ValaCCodeReturnStatement* _tmp115;
		ValaCCodeIdentifier* _tmp114;
		_tmp115 = NULL;
		_tmp114 = NULL;
		vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) (_tmp115 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp114 = vala_ccode_identifier_new (type_id_name)))));
		(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
		(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
	}
	_tmp116 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, (ValaCCodeNode*) (_tmp116 = vala_ccode_function_copy (fun)));
	(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, (ValaCCodeNode*) fun);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL);
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


/**
 * Returns the name of the base_finalize function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_finalize_func_name (self);
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable init function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_init_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable peek pointer function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_peek_pointer_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable free function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_free_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable copy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_copy_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable lcopy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_lcopy_value_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable collect value function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_collect_value_function_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_strdup ("0");
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return vala_ccode_fragment_new ();
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
}


static void vala_value_typeregister_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_typeregister_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_typeregister_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_typeregister_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_typeregister_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_typeregister_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_typeregister_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTypeRegisterFunction* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_typeregister_function_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_typeregister_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTypeRegisterFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_typeregister_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTypeRegisterFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_typeregister_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_typeregister_function (GValue* value, gpointer v_object) {
	ValaTypeRegisterFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TYPEREGISTER_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_typeregister_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_typeregister_function_unref (old);
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_finalize_func_name = vala_typeregister_function_real_get_base_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_typeregister_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_typeregister_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_typeregister_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
	self->ref_count = 1;
}


static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL) ? NULL : (self->priv->declaration_fragment = (vala_ccode_node_unref (self->priv->declaration_fragment), NULL));
	(self->priv->definition_fragment == NULL) ? NULL : (self->priv->definition_fragment = (vala_ccode_node_unref (self->priv->definition_fragment), NULL));
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_typeregister_function_init, vala_value_typeregister_function_free_value, vala_value_typeregister_function_copy_value, vala_value_typeregister_function_peek_pointer, "p", vala_value_typeregister_function_collect_value, "p", vala_value_typeregister_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_typeregister_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTypeRegisterFunction", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}


gpointer vala_typeregister_function_ref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_typeregister_function_unref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




