/* valaccodestructmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodestructmodule.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodefragment.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaarraytype.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>




enum  {
	VALA_CCODE_STRUCT_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_dup_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_free_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st);
static gpointer vala_ccode_struct_module_parent_class = NULL;



ValaCCodeStructModule* vala_ccode_struct_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeStructModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeStructModule*) vala_ccode_base_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeStructModule* vala_ccode_struct_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_struct_module_construct (VALA_TYPE_CCODE_STRUCT_MODULE, codegen, next);
}


static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaCCodeStructModule * self;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* old_type_symbol;
	ValaCCodeStruct* _tmp1;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaTypeSymbol* _tmp4;
	ValaTypeSymbol* _tmp3;
	ValaCCodeStruct* _tmp7;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypeSymbol* _tmp24;
	ValaTypeSymbol* _tmp23;
	ValaCCodeStruct* _tmp26;
	ValaCCodeStruct* _tmp25;
	ValaCCodeFragment* _tmp28;
	ValaCCodeFragment* _tmp27;
	self = (ValaCCodeStructModule*) base;
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_instance_struct = (_tmp1 = ((ValaCCodeBaseModule*) self)->instance_struct, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	_tmp2 = NULL;
	old_instance_finalize_fragment = (_tmp2 = ((ValaCCodeBaseModule*) self)->instance_finalize_fragment, (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2));
	_tmp4 = NULL;
	_tmp3 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp4 = (_tmp3 = (ValaTypeSymbol*) st, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp4);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp7 = vala_ccode_struct_new (_tmp6 = g_strdup_printf ("_%s", _tmp5 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp8 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp8 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp8);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		decl_frag = (_tmp10 = (_tmp9 = ((ValaCCodeBaseModule*) self)->header_type_declaration, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		def_frag = (_tmp12 = (_tmp11 = ((ValaCCodeBaseModule*) self)->header_type_definition, (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp12);
	} else {
		ValaCCodeFragment* _tmp14;
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp16;
		ValaCCodeFragment* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		decl_frag = (_tmp14 = (_tmp13 = ((ValaCCodeBaseModule*) self)->source_type_declaration, (_tmp13 == NULL) ? NULL : vala_ccode_node_ref (_tmp13)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		def_frag = (_tmp16 = (_tmp15 = ((ValaCCodeBaseModule*) self)->source_type_definition, (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp16);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) st))) == NULL) {
		ValaCCodeTypeDefinition* _tmp21;
		ValaCCodeVariableDeclarator* _tmp20;
		char* _tmp19;
		char* _tmp18;
		char* _tmp17;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp21 = vala_ccode_type_definition_new (_tmp18 = g_strdup_printf ("struct _%s", _tmp17 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), (ValaCCodeDeclarator*) (_tmp20 = vala_ccode_variable_declarator_new (_tmp19 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))))));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		_tmp17 = (g_free (_tmp17), NULL);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)) != NULL) {
		ValaCCodeComment* _tmp22;
		_tmp22 = NULL;
		vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) (_tmp22 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	}
	vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_struct);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_struct_is_disposable (st)) {
		vala_ccode_struct_module_add_struct_copy_function (self, st);
		vala_ccode_struct_module_add_struct_destroy_function (self, st);
	}
	vala_ccode_struct_module_add_struct_dup_function (self, st);
	vala_ccode_struct_module_add_struct_free_function (self, st);
	_tmp24 = NULL;
	_tmp23 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp24 = (_tmp23 = old_type_symbol, (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp24);
	_tmp26 = NULL;
	_tmp25 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp26 = (_tmp25 = old_instance_struct, (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp26);
	_tmp28 = NULL;
	_tmp27 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp28 = (_tmp27 = old_instance_finalize_fragment, (_tmp27 == NULL) ? NULL : vala_ccode_node_ref (_tmp27)), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp28);
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_instance_struct == NULL) ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL));
	(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
	(decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL));
	(def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL));
}


static void vala_ccode_struct_module_add_struct_dup_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* cblock;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp13;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* creation_call;
	ValaCCodeConstant* _tmp17;
	char* _tmp16;
	ValaCCodeConstant* _tmp18;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeAssignment* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeReturnStatement* _tmp38;
	ValaCCodeIdentifier* _tmp37;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	function = (_tmp3 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st), _tmp2 = g_strconcat (_tmp1 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp3);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp7 = vala_ccode_formal_parameter_new ("self", _tmp6 = g_strconcat (_tmp5 = g_strconcat ("const ", _tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp8;
		_tmp8 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp8 = vala_ccode_function_copy (function)));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	} else {
		ValaCCodeFunction* _tmp9;
		_tmp9 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp9 = vala_ccode_function_copy (function)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	}
	cblock = vala_ccode_block_new ();
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	cdecl_ = (_tmp12 = vala_ccode_declaration_new (_tmp11 = g_strconcat (_tmp10 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp12);
	_tmp13 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp13 = vala_ccode_variable_declarator_new ("dup")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
	_tmp14 = NULL;
	_tmp15 = NULL;
	creation_call = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("g_new0"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp15);
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new (_tmp16 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("1")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dup")), (ValaCCodeExpression*) creation_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	if (vala_struct_is_disposable (st)) {
		ValaCCodeIdentifier* _tmp23;
		char* _tmp22;
		ValaCCodeFunctionCall* _tmp24;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeIdentifier* _tmp26;
		ValaCCodeExpressionStatement* _tmp27;
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp24 = NULL;
		copy_call = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new (_tmp22 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)), _tmp22 = (g_free (_tmp22), NULL), _tmp24);
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("self")));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
		_tmp26 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("dup")));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		_tmp27 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
	} else {
		ValaCCodeIdentifier* _tmp28;
		ValaCCodeFunctionCall* _tmp29;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeConstant* _tmp31;
		char* _tmp30;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeFunctionCall* _tmp33;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeIdentifier* _tmp35;
		ValaCCodeExpressionStatement* _tmp36;
		_tmp28 = NULL;
		_tmp29 = NULL;
		sizeof_call = (_tmp29 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("sizeof"))), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), _tmp29);
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp31 = vala_ccode_constant_new (_tmp30 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
		(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
		_tmp30 = (g_free (_tmp30), NULL);
		_tmp32 = NULL;
		_tmp33 = NULL;
		copy_call = (_tmp33 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("memcpy"))), (_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)), _tmp33);
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("dup")));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("self")));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) sizeof_call);
		_tmp36 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp36 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
	}
	_tmp38 = NULL;
	_tmp37 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp38 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("dup")))));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
}


static void vala_ccode_struct_module_add_struct_free_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeFunctionCall* _tmp13;
	ValaCCodeFunctionCall* free_call;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeExpressionStatement* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp5;
		_tmp5 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (function)));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunction* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (function)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	cblock = vala_ccode_block_new ();
	if (vala_struct_is_disposable (st)) {
		ValaCCodeIdentifier* _tmp8;
		char* _tmp7;
		ValaCCodeFunctionCall* _tmp9;
		ValaCCodeFunctionCall* destroy_call;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeExpressionStatement* _tmp11;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp9 = NULL;
		destroy_call = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st)))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp9);
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (destroy_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("self")));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		_tmp11 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp11 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) destroy_call)));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		(destroy_call == NULL) ? NULL : (destroy_call = (vala_ccode_node_unref (destroy_call), NULL));
	}
	_tmp12 = NULL;
	_tmp13 = NULL;
	free_call = (_tmp13 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("g_free"))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (free_call, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("self")));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp15 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free_call)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(free_call == NULL) ? NULL : (free_call = (vala_ccode_node_unref (free_call), NULL));
}


static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp8;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("self", _tmp4 = g_strconcat (_tmp3 = g_strconcat ("const ", _tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp8 = vala_ccode_formal_parameter_new ("dest", _tmp7 = g_strconcat (_tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp9;
		_tmp9 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp9 = vala_ccode_function_copy (function)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	} else {
		ValaCCodeFunction* _tmp10;
		_tmp10 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp10 = vala_ccode_function_copy (function)));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	}
	cblock = vala_ccode_block_new ();
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	{
		GeeList* _tmp11;
		GeeIterator* _tmp12;
		GeeIterator* _f_it;
		_tmp11 = NULL;
		_tmp12 = NULL;
		_f_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_struct_get_fields (st))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				ValaCCodeIdentifier* _tmp13;
				ValaCCodeExpression* _tmp14;
				ValaCCodeExpression* copy;
				ValaCCodeIdentifier* _tmp18;
				ValaCCodeMemberAccess* _tmp19;
				ValaCCodeMemberAccess* dest;
				ValaCCodeExpressionStatement* _tmp21;
				ValaCCodeAssignment* _tmp20;
				ValaArrayType* _tmp23;
				ValaDataType* _tmp22;
				ValaArrayType* array_type;
				_tmp13 = NULL;
				_tmp14 = NULL;
				copy = (_tmp14 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("self")), vala_symbol_get_name ((ValaSymbol*) f)), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
				if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f))) {
					ValaMemberAccess* this_access;
					ValaDataType* _tmp15;
					ValaCCodeIdentifier* _tmp16;
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp17;
					this_access = vala_member_access_new_simple ("this", NULL);
					_tmp15 = NULL;
					vala_expression_set_value_type ((ValaExpression*) this_access, _tmp15 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
					(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_code_node_unref (_tmp15), NULL));
					_tmp16 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp16 = vala_ccode_identifier_new ("(*self)")));
					(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
					ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
					vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
					_tmp17 = NULL;
					copy = (_tmp17 = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), copy, (ValaExpression*) ma, (ValaCodeNode*) f), (copy == NULL) ? NULL : (copy = (vala_ccode_node_unref (copy), NULL)), _tmp17);
					(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				}
				_tmp18 = NULL;
				_tmp19 = NULL;
				dest = (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("dest")), vala_symbol_get_name ((ValaSymbol*) f)), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
				_tmp21 = NULL;
				_tmp20 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new ((ValaCCodeExpression*) dest, copy, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
				_tmp23 = NULL;
				_tmp22 = NULL;
				array_type = (_tmp23 = (_tmp22 = vala_field_get_field_type (f), VALA_IS_ARRAY_TYPE (_tmp22) ? ((ValaArrayType*) _tmp22) : NULL), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
				if (array_type != NULL) {
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp25;
							ValaCCodeIdentifier* _tmp24;
							ValaCCodeMemberAccess* _tmp26;
							ValaCCodeMemberAccess* len_src;
							char* _tmp28;
							ValaCCodeIdentifier* _tmp27;
							ValaCCodeMemberAccess* _tmp29;
							ValaCCodeMemberAccess* len_dest;
							ValaCCodeExpressionStatement* _tmp31;
							ValaCCodeAssignment* _tmp30;
							_tmp25 = NULL;
							_tmp24 = NULL;
							_tmp26 = NULL;
							len_src = (_tmp26 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("self")), _tmp25 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) f), dim)), _tmp25 = (g_free (_tmp25), NULL), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp26);
							_tmp28 = NULL;
							_tmp27 = NULL;
							_tmp29 = NULL;
							len_dest = (_tmp29 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("dest")), _tmp28 = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) f), dim)), _tmp28 = (g_free (_tmp28), NULL), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp29);
							_tmp31 = NULL;
							_tmp30 = NULL;
							vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_assignment_new ((ValaCCodeExpression*) len_dest, (ValaCCodeExpression*) len_src, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
							(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
							(len_src == NULL) ? NULL : (len_src = (vala_ccode_node_unref (len_src), NULL));
							(len_dest == NULL) ? NULL : (len_dest = (vala_ccode_node_unref (len_dest), NULL));
						}
					}
				}
				(copy == NULL) ? NULL : (copy = (vala_ccode_node_unref (copy), NULL));
				(dest == NULL) ? NULL : (dest = (vala_ccode_node_unref (dest), NULL));
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp5;
		_tmp5 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (function)));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunction* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (function)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	cblock = vala_ccode_block_new ();
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_struct_module_class_init (ValaCCodeStructModuleClass * klass) {
	vala_ccode_struct_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_ccode_struct_module_real_visit_struct;
}


static void vala_ccode_struct_module_instance_init (ValaCCodeStructModule * self) {
}


GType vala_ccode_struct_module_get_type (void) {
	static GType vala_ccode_struct_module_type_id = 0;
	if (vala_ccode_struct_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStructModule), 0, (GInstanceInitFunc) vala_ccode_struct_module_instance_init, NULL };
		vala_ccode_struct_module_type_id = g_type_register_static (VALA_TYPE_CCODE_BASE_MODULE, "ValaCCodeStructModule", &g_define_type_info, 0);
	}
	return vala_ccode_struct_module_type_id;
}




