/* valaccodelabel.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODELABEL_H__
#define __CCODE_VALACCODELABEL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_LABEL (vala_ccode_label_get_type ())
#define VALA_CCODE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LABEL, ValaCCodeLabel))
#define VALA_CCODE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LABEL, ValaCCodeLabelClass))
#define VALA_IS_CCODE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LABEL))
#define VALA_IS_CCODE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LABEL))
#define VALA_CCODE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LABEL, ValaCCodeLabelClass))

typedef struct _ValaCCodeLabel ValaCCodeLabel;
typedef struct _ValaCCodeLabelClass ValaCCodeLabelClass;
typedef struct _ValaCCodeLabelPrivate ValaCCodeLabelPrivate;

/**
 * Represents a label declaration in the C code.
 */
struct _ValaCCodeLabel {
	ValaCCodeStatement parent_instance;
	ValaCCodeLabelPrivate * priv;
};

struct _ValaCCodeLabelClass {
	ValaCCodeStatementClass parent_class;
};


ValaCCodeLabel* vala_ccode_label_construct (GType object_type, const char* name);
ValaCCodeLabel* vala_ccode_label_new (const char* name);
const char* vala_ccode_label_get_name (ValaCCodeLabel* self);
void vala_ccode_label_set_name (ValaCCodeLabel* self, const char* value);
GType vala_ccode_label_get_type (void);


G_END_DECLS

#endif
