/* valaccodestructmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodestructmodule.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodefragment.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>




enum  {
	VALA_CCODE_STRUCT_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st);
static gpointer vala_ccode_struct_module_parent_class = NULL;



ValaCCodeStructModule* vala_ccode_struct_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeStructModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeStructModule*) vala_ccode_base_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeStructModule* vala_ccode_struct_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_struct_module_construct (VALA_TYPE_CCODE_STRUCT_MODULE, codegen, next);
}


static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaCCodeStructModule * self;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* old_type_symbol;
	ValaCCodeStruct* _tmp1;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaTypeSymbol* _tmp4;
	ValaTypeSymbol* _tmp3;
	ValaCCodeStruct* _tmp7;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypeSymbol* _tmp24;
	ValaTypeSymbol* _tmp23;
	ValaCCodeStruct* _tmp26;
	ValaCCodeStruct* _tmp25;
	ValaCCodeFragment* _tmp28;
	ValaCCodeFragment* _tmp27;
	self = (ValaCCodeStructModule*) base;
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_instance_struct = (_tmp1 = ((ValaCCodeBaseModule*) self)->instance_struct, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	_tmp2 = NULL;
	old_instance_finalize_fragment = (_tmp2 = ((ValaCCodeBaseModule*) self)->instance_finalize_fragment, (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2));
	_tmp4 = NULL;
	_tmp3 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp4 = (_tmp3 = (ValaTypeSymbol*) st, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp4);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp7 = vala_ccode_struct_new (_tmp6 = g_strdup_printf ("_%s", _tmp5 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp8 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp8 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp8);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		decl_frag = (_tmp10 = (_tmp9 = ((ValaCCodeBaseModule*) self)->header_type_declaration, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		def_frag = (_tmp12 = (_tmp11 = ((ValaCCodeBaseModule*) self)->header_type_definition, (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp12);
	} else {
		ValaCCodeFragment* _tmp14;
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp16;
		ValaCCodeFragment* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		decl_frag = (_tmp14 = (_tmp13 = ((ValaCCodeBaseModule*) self)->source_type_declaration, (_tmp13 == NULL) ? NULL : vala_ccode_node_ref (_tmp13)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		def_frag = (_tmp16 = (_tmp15 = ((ValaCCodeBaseModule*) self)->source_type_definition, (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp16);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) st))) == NULL) {
		ValaCCodeTypeDefinition* _tmp21;
		ValaCCodeVariableDeclarator* _tmp20;
		char* _tmp19;
		char* _tmp18;
		char* _tmp17;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp21 = vala_ccode_type_definition_new (_tmp18 = g_strdup_printf ("struct _%s", _tmp17 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), (ValaCCodeDeclarator*) (_tmp20 = vala_ccode_variable_declarator_new (_tmp19 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))))));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		_tmp19 = (g_free (_tmp19), NULL);
		_tmp18 = (g_free (_tmp18), NULL);
		_tmp17 = (g_free (_tmp17), NULL);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)) != NULL) {
		ValaCCodeComment* _tmp22;
		_tmp22 = NULL;
		vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) (_tmp22 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	}
	vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_struct);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_struct_is_disposable (st)) {
		vala_ccode_struct_module_add_struct_copy_function (self, st);
		vala_ccode_struct_module_add_struct_destroy_function (self, st);
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp24 = (_tmp23 = old_type_symbol, (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp24);
	_tmp26 = NULL;
	_tmp25 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp26 = (_tmp25 = old_instance_struct, (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp26);
	_tmp28 = NULL;
	_tmp27 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp28 = (_tmp27 = old_instance_finalize_fragment, (_tmp27 == NULL) ? NULL : vala_ccode_node_ref (_tmp27)), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp28);
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_instance_struct == NULL) ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL));
	(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
	(decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL));
	(def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL));
}


static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp8;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("self", _tmp4 = g_strconcat (_tmp3 = g_strconcat ("const ", _tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp8 = vala_ccode_formal_parameter_new ("dest", _tmp7 = g_strconcat (_tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp9;
		_tmp9 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp9 = vala_ccode_function_copy (function)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	} else {
		ValaCCodeFunction* _tmp10;
		_tmp10 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp10 = vala_ccode_function_copy (function)));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	}
	cblock = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp5;
		_tmp5 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (function)));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunction* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (function)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	cblock = vala_ccode_block_new ();
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_struct_module_class_init (ValaCCodeStructModuleClass * klass) {
	vala_ccode_struct_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_ccode_struct_module_real_visit_struct;
}


static void vala_ccode_struct_module_instance_init (ValaCCodeStructModule * self) {
}


GType vala_ccode_struct_module_get_type (void) {
	static GType vala_ccode_struct_module_type_id = 0;
	if (vala_ccode_struct_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStructModule), 0, (GInstanceInitFunc) vala_ccode_struct_module_instance_init, NULL };
		vala_ccode_struct_module_type_id = g_type_register_static (VALA_TYPE_CCODE_BASE_MODULE, "ValaCCodeStructModule", &g_define_type_info, 0);
	}
	return vala_ccode_struct_module_type_id;
}




