/* valamemberinitializer.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valamemberinitializer.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacodevisitor.h>




struct _ValaMemberInitializerPrivate {
	char* _name;
	ValaExpression* _initializer;
	ValaSymbol* _symbol_reference;
};

#define VALA_MEMBER_INITIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerPrivate))
enum  {
	VALA_MEMBER_INITIALIZER_DUMMY_PROPERTY
};
static void vala_member_initializer_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_member_initializer_parent_class = NULL;
static void vala_member_initializer_finalize (ValaCodeNode* obj);



/**
 * Creates a new member initializer.
 *
 * @param name             member name
 * @param initializer      initializer expression
 * @param source_reference reference to source code
 * @return                 newly created member initializer
 */
ValaMemberInitializer* vala_member_initializer_construct (GType object_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference) {
	ValaMemberInitializer* self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (initializer != NULL, NULL);
	self = ((ValaMemberInitializer*) (g_type_create_instance (object_type)));
	vala_member_initializer_set_initializer (self, initializer);
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source_reference);
	vala_member_initializer_set_name (self, name);
	return self;
}


ValaMemberInitializer* vala_member_initializer_new (const char* name, ValaExpression* initializer, ValaSourceReference* source_reference) {
	return vala_member_initializer_construct (VALA_TYPE_MEMBER_INITIALIZER, name, initializer, source_reference);
}


static void vala_member_initializer_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMemberInitializer * self;
	self = ((ValaMemberInitializer*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (self->priv->_initializer)), visitor);
}


const char* vala_member_initializer_get_name (ValaMemberInitializer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_member_initializer_set_name (ValaMemberInitializer* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


ValaExpression* vala_member_initializer_get_initializer (ValaMemberInitializer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_initializer;
}


void vala_member_initializer_set_initializer (ValaMemberInitializer* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (vala_code_node_unref (self->priv->_initializer), NULL))), _tmp2);
}


ValaSymbol* vala_member_initializer_get_symbol_reference (ValaMemberInitializer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_symbol_reference;
}


void vala_member_initializer_set_symbol_reference (ValaMemberInitializer* self, ValaSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_symbol_reference = value;
}


static void vala_member_initializer_class_init (ValaMemberInitializerClass * klass) {
	vala_member_initializer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_member_initializer_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberInitializerPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_member_initializer_real_accept;
}


static void vala_member_initializer_instance_init (ValaMemberInitializer * self) {
	self->priv = VALA_MEMBER_INITIALIZER_GET_PRIVATE (self);
}


static void vala_member_initializer_finalize (ValaCodeNode* obj) {
	ValaMemberInitializer * self;
	self = VALA_MEMBER_INITIALIZER (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (vala_code_node_unref (self->priv->_initializer), NULL)));
	VALA_CODE_NODE_CLASS (vala_member_initializer_parent_class)->finalize (obj);
}


GType vala_member_initializer_get_type (void) {
	static GType vala_member_initializer_type_id = 0;
	if (vala_member_initializer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberInitializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_initializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberInitializer), 0, (GInstanceInitFunc) vala_member_initializer_instance_init, NULL };
		vala_member_initializer_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaMemberInitializer", &g_define_type_info, 0);
	}
	return vala_member_initializer_type_id;
}




