/* valadynamicproperty.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicproperty.h>
#include <gee/arraylist.h>
#include <vala/valapropertyaccessor.h>




struct _ValaDynamicPropertyPrivate {
	ValaDataType* _dynamic_type;
	char* cname;
};

#define VALA_DYNAMIC_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyPrivate))
enum  {
	VALA_DYNAMIC_PROPERTY_DUMMY_PROPERTY
};
static GeeList* vala_dynamic_property_real_get_cheader_filenames (ValaSymbol* base);
static gpointer vala_dynamic_property_parent_class = NULL;
static void vala_dynamic_property_finalize (ValaCodeNode* obj);



ValaDynamicProperty* vala_dynamic_property_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference) {
	ValaDynamicProperty* self;
	g_return_val_if_fail (dynamic_type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = ((ValaDynamicProperty*) (g_type_create_instance (object_type)));
	self = ((ValaDynamicProperty*) (vala_property_construct (object_type, name, NULL, NULL, NULL, source_reference)));
	vala_dynamic_property_set_dynamic_type (self, dynamic_type);
	return self;
}


ValaDynamicProperty* vala_dynamic_property_new (ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference) {
	return vala_dynamic_property_construct (VALA_TYPE_DYNAMIC_PROPERTY, dynamic_type, name, source_reference);
}


static GeeList* vala_dynamic_property_real_get_cheader_filenames (ValaSymbol* base) {
	ValaDynamicProperty * self;
	self = ((ValaDynamicProperty*) (base));
	return ((GeeList*) (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal)));
}


ValaDataType* vala_dynamic_property_get_dynamic_type (ValaDynamicProperty* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_property_set_dynamic_type (ValaDynamicProperty* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL))), _tmp2);
}


static void vala_dynamic_property_class_init (ValaDynamicPropertyClass * klass) {
	vala_dynamic_property_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_dynamic_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaDynamicPropertyPrivate));
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_dynamic_property_real_get_cheader_filenames;
}


static void vala_dynamic_property_instance_init (ValaDynamicProperty * self) {
	self->priv = VALA_DYNAMIC_PROPERTY_GET_PRIVATE (self);
}


static void vala_dynamic_property_finalize (ValaCodeNode* obj) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (obj);
	(self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	VALA_CODE_NODE_CLASS (vala_dynamic_property_parent_class)->finalize (obj);
}


GType vala_dynamic_property_get_type (void) {
	static GType vala_dynamic_property_type_id = 0;
	if (vala_dynamic_property_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicProperty), 0, (GInstanceInitFunc) vala_dynamic_property_instance_init, NULL };
		vala_dynamic_property_type_id = g_type_register_static (VALA_TYPE_PROPERTY, "ValaDynamicProperty", &g_define_type_info, 0);
	}
	return vala_dynamic_property_type_id;
}




