/* valadostatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadostatement.h>
#include <vala/valablock.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaDoStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};

#define VALA_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DO_STATEMENT, ValaDoStatementPrivate))
enum  {
	VALA_DO_STATEMENT_DUMMY_PROPERTY
};
static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_do_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_do_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gpointer vala_do_statement_parent_class = NULL;
static ValaStatementIface* vala_do_statement_vala_statement_parent_iface = NULL;
static void vala_do_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new do statement.
 *
 * @param cond   loop condition
 * @param body   loop body
 * @param source reference to source code
 * @return       newly created do statement
 */
ValaDoStatement* vala_do_statement_construct (GType object_type, ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference) {
	ValaDoStatement* self;
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (condition != NULL, NULL);
	self = ((ValaDoStatement*) (g_type_create_instance (object_type)));
	vala_do_statement_set_condition (self, condition);
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source_reference);
	vala_do_statement_set_body (self, body);
	return self;
}


ValaDoStatement* vala_do_statement_new (ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference) {
	return vala_do_statement_construct (VALA_TYPE_DO_STATEMENT, body, condition, source_reference);
}


static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDoStatement * self;
	self = ((ValaDoStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_do_statement (visitor, self);
}


static void vala_do_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDoStatement * self;
	self = ((ValaDoStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_do_statement_get_body (self))), visitor);
	vala_code_node_accept (((ValaCodeNode*) (vala_do_statement_get_condition (self))), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_do_statement_get_condition (self));
}


static void vala_do_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaDoStatement * self;
	self = ((ValaDoStatement*) (base));
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_do_statement_get_condition (self) == old_node) {
		vala_do_statement_set_condition (self, new_node);
	}
}


ValaBlock* vala_do_statement_get_body (ValaDoStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_body;
}


void vala_do_statement_set_body (ValaDoStatement* self, ValaBlock* value) {
	ValaBlock* _tmp2;
	ValaBlock* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_body)), ((ValaCodeNode*) (self)));
}


ValaExpression* vala_do_statement_get_condition (ValaDoStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_condition;
}


void vala_do_statement_set_condition (ValaDoStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_code_node_unref (self->priv->_condition), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_condition)), ((ValaCodeNode*) (self)));
}


static void vala_do_statement_class_init (ValaDoStatementClass * klass) {
	vala_do_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_do_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDoStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_do_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_do_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_do_statement_real_replace_expression;
}


static void vala_do_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_do_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_do_statement_instance_init (ValaDoStatement * self) {
	self->priv = VALA_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_do_statement_finalize (ValaCodeNode* obj) {
	ValaDoStatement * self;
	self = VALA_DO_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_code_node_unref (self->priv->_condition), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL)));
	VALA_CODE_NODE_CLASS (vala_do_statement_parent_class)->finalize (obj);
}


GType vala_do_statement_get_type (void) {
	static GType vala_do_statement_type_id = 0;
	if (vala_do_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoStatement), 0, (GInstanceInitFunc) vala_do_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_do_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_do_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDoStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_do_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_do_statement_type_id;
}




