/* valaarraylengthfield.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraylengthfield.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valainvalidtype.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valasymbol.h>




enum  {
	VALA_ARRAY_LENGTH_FIELD_DUMMY_PROPERTY
};
static gpointer vala_array_length_field_parent_class = NULL;



/**
 * Creates a new array length field.
 *
 * @return newly created field
 */
ValaArrayLengthField* vala_array_length_field_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaArrayLengthField* self;
	ValaInvalidType* _tmp0;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = ((ValaArrayLengthField*) (g_type_create_instance (object_type)));
	_tmp0 = NULL;
	self = ((ValaArrayLengthField*) (vala_field_construct (object_type, "length", ((ValaDataType*) ((_tmp0 = vala_invalid_type_new ()))), NULL, source_reference)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	vala_symbol_set_external (((ValaSymbol*) (self)), TRUE);
	return self;
}


ValaArrayLengthField* vala_array_length_field_new (ValaSourceReference* source_reference) {
	return vala_array_length_field_construct (VALA_TYPE_ARRAY_LENGTH_FIELD, source_reference);
}


static void vala_array_length_field_class_init (ValaArrayLengthFieldClass * klass) {
	vala_array_length_field_parent_class = g_type_class_peek_parent (klass);
}


static void vala_array_length_field_instance_init (ValaArrayLengthField * self) {
}


GType vala_array_length_field_get_type (void) {
	static GType vala_array_length_field_type_id = 0;
	if (vala_array_length_field_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayLengthFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_length_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayLengthField), 0, (GInstanceInitFunc) vala_array_length_field_instance_init, NULL };
		vala_array_length_field_type_id = g_type_register_static (VALA_TYPE_FIELD, "ValaArrayLengthField", &g_define_type_info, 0);
	}
	return vala_array_length_field_type_id;
}




