/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valatyperegisterfunction.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <gobject/gvaluecollector.h>




struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCodeContext* _context;
};

#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
static gpointer vala_typeregister_function_parent_class = NULL;
static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	char* _tmp2;
	ValaTypeSymbol* _tmp1;
	char* _tmp3;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* fun;
	char* type_value_table_decl_name;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp46;
	ValaCCodeConstant* _tmp45;
	char* _tmp44;
	char* _tmp43;
	char* _tmp42;
	char* _tmp41;
	char* _tmp40;
	char* _tmp39;
	ValaCCodeFragment* _tmp49;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp64;
	char* _tmp63;
	char* _tmp62;
	ValaTypeSymbol* _tmp61;
	ValaCCodeIdentifier* _tmp65;
	ValaCCodeConstant* _tmp68;
	char* _tmp67;
	ValaCCodeFragment* _tmp73;
	ValaCCodeFunction* _tmp96;
	g_return_if_fail (self != NULL);
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_context, 2, 14);
	fundamental = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = vala_typeregister_function_get_type_declaration (self), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL));
	if (cl != NULL && !vala_class_get_is_compact (cl) && vala_class_get_base_class (cl) == NULL) {
		fundamental = TRUE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	type_id_name = (_tmp3 = g_strdup_printf ("%s_type_id", (_tmp2 = vala_symbol_get_lower_case_cname (((ValaSymbol*) ((_tmp1 = vala_typeregister_function_get_type_declaration (self)))), NULL))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL))), _tmp3);
	type_block = vala_ccode_block_new ();
	cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp4;
		ValaCCodeVariableDeclarator* _tmp7;
		ValaCCodeConstant* _tmp6;
		char* _tmp5;
		_tmp4 = NULL;
		cdecl_ = (_tmp4 = vala_ccode_declaration_new ("gsize"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp4);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp7 = vala_ccode_variable_declarator_new_with_initializer ((_tmp5 = g_strconcat (type_id_name, "__volatile", NULL)), ((ValaCCodeExpression*) ((_tmp6 = vala_ccode_constant_new ("0")))))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
		_tmp5 = (g_free (_tmp5), NULL);
	} else {
		ValaCCodeDeclaration* _tmp8;
		ValaCCodeVariableDeclarator* _tmp10;
		ValaCCodeConstant* _tmp9;
		_tmp8 = NULL;
		cdecl_ = (_tmp8 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL))), _tmp8);
		_tmp10 = NULL;
		_tmp9 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, ((ValaCCodeDeclarator*) ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_constant_new ("0")))))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	}
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (cdecl_, vala_ccode_declaration_get_modifiers (cdecl_) | (VALA_CCODE_MODIFIERS_VOLATILE));
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, ((ValaCCodeNode*) (cdecl_)));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, ((ValaCCodeNode*) (cdecl_)));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp14;
		char* _tmp13;
		char* _tmp12;
		ValaTypeSymbol* _tmp11;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		fun = (_tmp14 = vala_ccode_function_new ((_tmp13 = g_strdup_printf ("%s_get_type", (_tmp12 = vala_symbol_get_lower_case_cname (((ValaSymbol*) ((_tmp11 = vala_typeregister_function_get_type_declaration (self)))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL))), _tmp14);
		_tmp13 = (g_free (_tmp13), NULL);
		_tmp12 = (g_free (_tmp12), NULL);
		(_tmp11 == NULL ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL)));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaTypeSymbol* _tmp15;
		ValaCCodeFormalParameter* _tmp19;
		char* _tmp22;
		char* _tmp21;
		ValaTypeSymbol* _tmp20;
		ValaCCodeFunction* _tmp23;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp24;
		ValaCCodeBlock* _tmp25;
		ValaCCodeReturnStatement* _tmp27;
		ValaCCodeIdentifier* _tmp26;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		fun = (_tmp18 = vala_ccode_function_new ((_tmp17 = g_strdup_printf ("%s_register_type", (_tmp16 = vala_symbol_get_lower_case_cname (((ValaSymbol*) ((_tmp15 = vala_typeregister_function_get_type_declaration (self)))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL))), _tmp18);
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp16 = (g_free (_tmp16), NULL);
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_code_node_unref (_tmp15), NULL)));
		_tmp19 = NULL;
		vala_ccode_function_add_parameter (fun, (_tmp19 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp23 = NULL;
		get_fun = (_tmp23 = vala_ccode_function_new ((_tmp22 = g_strdup_printf ("%s_get_type", (_tmp21 = vala_symbol_get_lower_case_cname (((ValaSymbol*) ((_tmp20 = vala_typeregister_function_get_type_declaration (self)))), NULL)))), "GType"), (_tmp22 = (g_free (_tmp22), NULL)), (_tmp21 = (g_free (_tmp21), NULL)), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL))), _tmp23);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp24 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, ((ValaCCodeNode*) ((_tmp24 = vala_ccode_function_copy (get_fun)))));
		(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
		_tmp25 = NULL;
		vala_ccode_function_set_block (get_fun, (_tmp25 = vala_ccode_block_new ()));
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), ((ValaCCodeNode*) ((_tmp27 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp26 = vala_ccode_identifier_new (type_id_name)))))))));
		(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, ((ValaCCodeNode*) (get_fun)));
		(get_fun == NULL ? NULL : (get_fun = (vala_ccode_node_unref (get_fun), NULL)));
	}
	type_value_table_decl_name = NULL;
	type_init = vala_ccode_block_new ();
	if (fundamental) {
		ValaCCodeDeclaration* cgtypetabledecl;
		ValaCCodeVariableDeclarator* _tmp36;
		ValaCCodeConstant* _tmp35;
		char* _tmp34;
		char* _tmp33;
		char* _tmp32;
		char* _tmp31;
		char* _tmp30;
		char* _tmp29;
		char* _tmp28;
		char* _tmp37;
		cgtypetabledecl = vala_ccode_declaration_new ("const GTypeValueTable");
		vala_ccode_declaration_set_modifiers (cgtypetabledecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp36 = NULL;
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp28 = NULL;
		vala_ccode_declaration_add_declarator (cgtypetabledecl, ((ValaCCodeDeclarator*) ((_tmp36 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_value_table", ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_constant_new ((_tmp34 = g_strdup_printf ("{ %s, %s, %s, %s, \"p\", %s, \"p\", %s }", (_tmp28 = vala_typeregister_function_get_gtype_value_table_init_function_name (self)), (_tmp29 = vala_typeregister_function_get_gtype_value_table_free_function_name (self)), (_tmp30 = vala_typeregister_function_get_gtype_value_table_copy_function_name (self)), (_tmp31 = vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (self)), (_tmp32 = vala_typeregister_function_get_gtype_value_table_collect_value_function_name (self)), (_tmp33 = vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (self)))))))))))));
		(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
		(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
		_tmp34 = (g_free (_tmp34), NULL);
		_tmp33 = (g_free (_tmp33), NULL);
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp30 = (g_free (_tmp30), NULL);
		_tmp29 = (g_free (_tmp29), NULL);
		_tmp28 = (g_free (_tmp28), NULL);
		_tmp37 = NULL;
		type_value_table_decl_name = (_tmp37 = g_strdup ("&g_define_type_value_table"), (type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL)), _tmp37);
		vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) (cgtypetabledecl)));
		(cgtypetabledecl == NULL ? NULL : (cgtypetabledecl = (vala_ccode_node_unref (cgtypetabledecl), NULL)));
	} else {
		char* _tmp38;
		_tmp38 = NULL;
		type_value_table_decl_name = (_tmp38 = g_strdup ("NULL"), (type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL)), _tmp38);
	}
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp46 = NULL;
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	_tmp39 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, ((ValaCCodeDeclarator*) ((_tmp46 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_constant_new ((_tmp44 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s, %s }", (_tmp39 = vala_typeregister_function_get_type_struct_name (self)), (_tmp40 = vala_typeregister_function_get_base_init_func_name (self)), (_tmp41 = vala_typeregister_function_get_class_init_func_name (self)), (_tmp42 = vala_typeregister_function_get_instance_struct_size (self)), (_tmp43 = vala_typeregister_function_get_instance_init_func_name (self)), type_value_table_decl_name)))))))))));
	(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
	(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	_tmp44 = (g_free (_tmp44), NULL);
	_tmp43 = (g_free (_tmp43), NULL);
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp40 = (g_free (_tmp40), NULL);
	_tmp39 = (g_free (_tmp39), NULL);
	vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) (ctypedecl)));
	if (fundamental) {
		ValaCCodeDeclaration* ctypefundamentaldecl;
		ValaCCodeVariableDeclarator* _tmp48;
		ValaCCodeConstant* _tmp47;
		ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
		vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp48 = NULL;
		_tmp47 = NULL;
		vala_ccode_declaration_add_declarator (ctypefundamentaldecl, ((ValaCCodeDeclarator*) ((_tmp48 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_fundamental_info", ((ValaCCodeExpression*) ((_tmp47 = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")))))))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
		(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
		vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) (ctypefundamentaldecl)));
		(ctypefundamentaldecl == NULL ? NULL : (ctypefundamentaldecl = (vala_ccode_node_unref (ctypefundamentaldecl), NULL)));
	}
	_tmp49 = NULL;
	vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) ((_tmp49 = vala_typeregister_function_get_type_interface_init_declaration (self)))));
	(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
	reg_call = NULL;
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp51;
		ValaCCodeIdentifier* _tmp50;
		_tmp51 = NULL;
		_tmp50 = NULL;
		reg_call = (_tmp51 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp50 = vala_ccode_identifier_new ("g_type_register_fundamental"))))), (reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL))), _tmp51);
		(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
	} else {
		if (!plugin) {
			ValaCCodeFunctionCall* _tmp53;
			ValaCCodeIdentifier* _tmp52;
			_tmp53 = NULL;
			_tmp52 = NULL;
			reg_call = (_tmp53 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp52 = vala_ccode_identifier_new ("g_type_register_static"))))), (reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL))), _tmp53);
			(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
		} else {
			ValaCCodeFunctionCall* _tmp55;
			ValaCCodeIdentifier* _tmp54;
			ValaCCodeIdentifier* _tmp56;
			_tmp55 = NULL;
			_tmp54 = NULL;
			reg_call = (_tmp55 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp54 = vala_ccode_identifier_new ("g_type_module_register_type"))))), (reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL))), _tmp55);
			(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
			_tmp56 = NULL;
			vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp56 = vala_ccode_identifier_new ("module")))));
			(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
		}
	}
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp58;
		ValaCCodeIdentifier* _tmp57;
		_tmp58 = NULL;
		_tmp57 = NULL;
		vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp58 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp57 = vala_ccode_identifier_new ("g_type_fundamental_next")))))))));
		(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
		(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp60;
		char* _tmp59;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp60 = vala_ccode_identifier_new ((_tmp59 = vala_typeregister_function_get_parent_type_name (self)))))));
		(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
		_tmp59 = (g_free (_tmp59), NULL);
	}
	_tmp64 = NULL;
	_tmp63 = NULL;
	_tmp62 = NULL;
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp64 = vala_ccode_constant_new ((_tmp63 = g_strdup_printf ("\"%s\"", (_tmp62 = vala_typesymbol_get_cname ((_tmp61 = vala_typeregister_function_get_type_declaration (self)), FALSE)))))))));
	(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
	_tmp63 = (g_free (_tmp63), NULL);
	_tmp62 = (g_free (_tmp62), NULL);
	(_tmp61 == NULL ? NULL : (_tmp61 = (vala_code_node_unref (_tmp61), NULL)));
	_tmp65 = NULL;
	vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp65 = vala_ccode_identifier_new ("&g_define_type_info")))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
	if (fundamental) {
		ValaCCodeIdentifier* _tmp66;
		_tmp66 = NULL;
		vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp66 = vala_ccode_identifier_new ("&g_define_type_fundamental_info")))));
		(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
	}
	_tmp68 = NULL;
	_tmp67 = NULL;
	vala_ccode_function_call_add_argument (reg_call, ((ValaCCodeExpression*) ((_tmp68 = vala_ccode_constant_new ((_tmp67 = vala_typeregister_function_get_type_flags (self)))))));
	(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
	_tmp67 = (g_free (_tmp67), NULL);
	if (use_thread_safe && !plugin) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp69;
		temp_decl = vala_ccode_declaration_new ("GType");
		_tmp69 = NULL;
		vala_ccode_declaration_add_declarator (temp_decl, ((ValaCCodeDeclarator*) ((_tmp69 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, ((ValaCCodeExpression*) (reg_call)))))));
		(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
		vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) (temp_decl)));
		(temp_decl == NULL ? NULL : (temp_decl = (vala_ccode_node_unref (temp_decl), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp72;
		ValaCCodeAssignment* _tmp71;
		ValaCCodeIdentifier* _tmp70;
		_tmp72 = NULL;
		_tmp71 = NULL;
		_tmp70 = NULL;
		vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) ((_tmp72 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) ((_tmp71 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp70 = vala_ccode_identifier_new (type_id_name)))), ((ValaCCodeExpression*) (reg_call)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))))));
		(_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)));
		(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
		(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
	}
	_tmp73 = NULL;
	vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) ((_tmp73 = vala_typeregister_function_get_type_interface_init_statements (self)))));
	(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		/* the condition that guards the type initialisation*/
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp74;
			ValaCCodeFunctionCall* _tmp75;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp78;
			ValaCCodeIdentifier* _tmp77;
			char* _tmp76;
			ValaCCodeExpression* _tmp80;
			ValaCCodeExpression* _tmp79;
			ValaCCodeIdentifier* _tmp81;
			ValaCCodeFunctionCall* _tmp82;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			char* _tmp83;
			ValaCCodeIdentifier* _tmp86;
			ValaCCodeExpressionStatement* _tmp87;
			_tmp74 = NULL;
			_tmp75 = NULL;
			enter = (_tmp75 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp74 = vala_ccode_identifier_new ("g_once_init_enter"))))), (_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL))), _tmp75);
			_tmp78 = NULL;
			_tmp77 = NULL;
			_tmp76 = NULL;
			vala_ccode_function_call_add_argument (enter, ((ValaCCodeExpression*) ((_tmp78 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp77 = vala_ccode_identifier_new ((_tmp76 = g_strconcat (type_id_name, "__volatile", NULL)))))))))));
			(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
			(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
			_tmp76 = (g_free (_tmp76), NULL);
			_tmp80 = NULL;
			_tmp79 = NULL;
			condition = (_tmp80 = (_tmp79 = ((ValaCCodeExpression*) (enter)), (_tmp79 == NULL ? NULL : vala_ccode_node_ref (_tmp79))), (condition == NULL ? NULL : (condition = (vala_ccode_node_unref (condition), NULL))), _tmp80);
			_tmp81 = NULL;
			_tmp82 = NULL;
			leave = (_tmp82 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp81 = vala_ccode_identifier_new ("g_once_init_leave"))))), (_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL))), _tmp82);
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			vala_ccode_function_call_add_argument (leave, ((ValaCCodeExpression*) ((_tmp85 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp84 = vala_ccode_identifier_new ((_tmp83 = g_strconcat (type_id_name, "__volatile", NULL)))))))))));
			(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
			(_tmp84 == NULL ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)));
			_tmp83 = (g_free (_tmp83), NULL);
			_tmp86 = NULL;
			vala_ccode_function_call_add_argument (leave, ((ValaCCodeExpression*) ((_tmp86 = vala_ccode_identifier_new (type_id_name)))));
			(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
			_tmp87 = NULL;
			vala_ccode_block_add_statement (type_init, ((ValaCCodeNode*) ((_tmp87 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (leave)))))));
			(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
			(enter == NULL ? NULL : (enter = (vala_ccode_node_unref (enter), NULL)));
			(leave == NULL ? NULL : (leave = (vala_ccode_node_unref (leave), NULL)));
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp88;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			_tmp88 = NULL;
			condition = (_tmp88 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ((ValaCCodeExpression*) (id)), ((ValaCCodeExpression*) (zero))))), (condition == NULL ? NULL : (condition = (vala_ccode_node_unref (condition), NULL))), _tmp88);
			(id == NULL ? NULL : (id = (vala_ccode_node_unref (id), NULL)));
			(zero == NULL ? NULL : (zero = (vala_ccode_node_unref (zero), NULL)));
		}
		cif = vala_ccode_if_statement_new (condition, ((ValaCCodeStatement*) (type_init)), NULL);
		vala_ccode_block_add_statement (type_block, ((ValaCCodeNode*) (cif)));
		(condition == NULL ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)));
		(cif == NULL ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* _tmp90;
		ValaCCodeBlock* _tmp89;
		_tmp90 = NULL;
		_tmp89 = NULL;
		type_block = (_tmp90 = (_tmp89 = type_init, (_tmp89 == NULL ? NULL : vala_ccode_node_ref (_tmp89))), (type_block == NULL ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL))), _tmp90);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp93;
		ValaCCodeIdentifier* _tmp92;
		char* _tmp91;
		_tmp93 = NULL;
		_tmp92 = NULL;
		_tmp91 = NULL;
		vala_ccode_block_add_statement (type_block, ((ValaCCodeNode*) ((_tmp93 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp92 = vala_ccode_identifier_new ((_tmp91 = g_strconcat (type_id_name, "__volatile", NULL)))))))))));
		(_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)));
		(_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)));
		_tmp91 = (g_free (_tmp91), NULL);
	} else {
		ValaCCodeReturnStatement* _tmp95;
		ValaCCodeIdentifier* _tmp94;
		_tmp95 = NULL;
		_tmp94 = NULL;
		vala_ccode_block_add_statement (type_block, ((ValaCCodeNode*) ((_tmp95 = vala_ccode_return_statement_new (((ValaCCodeExpression*) ((_tmp94 = vala_ccode_identifier_new (type_id_name)))))))));
		(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
		(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
	}
	_tmp96 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, ((ValaCCodeNode*) ((_tmp96 = vala_ccode_function_copy (fun)))));
	(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, ((ValaCCodeNode*) (fun)));
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	type_id_name = (g_free (type_id_name), NULL);
	(type_block == NULL ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)));
	type_value_table_decl_name = (g_free (type_value_table_decl_name), NULL);
	(type_init == NULL ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)));
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_struct_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_base_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_class_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_struct_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_parent_type_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable init function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_init_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable peek pointer function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_peek_pointer_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable free function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_free_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable copy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_copy_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable lcopy function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_lcopy_value_function_name (self);
}


/**
 * Returns the C-name of the new generated GTypeValueTable collect value function or null when not available.
 *
 * @return C function name
 */
static char* vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return NULL;
}


char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_gtype_value_table_collect_value_function_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return g_strdup ("0");
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return vala_ccode_fragment_new ();
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_context_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL))), _tmp2);
}


static void vala_value_typeregister_function_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_typeregister_function_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_typeregister_function_unref (value->data[0].v_pointer);
	}
}


static void vala_value_typeregister_function_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_typeregister_function_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_typeregister_function_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_typeregister_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTypeRegisterFunction* object;
		object = value->data[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_OBJECT_TYPE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", G_OBJECT_TYPE (object), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_typeregister_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTypeRegisterFunction** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_typeregister_function_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTypeRegisterFunction* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_typeregister_function (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_typeregister_function (GValue* value, gpointer v_object) {
	ValaTypeRegisterFunction* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TYPEREGISTER_FUNCTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TYPEREGISTER_FUNCTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_typeregister_function_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_typeregister_function_unref (old);
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_typeregister_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_typeregister_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_typeregister_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_typeregister_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_typeregister_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_typeregister_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
	self->ref_count = 1;
}


static void vala_typeregister_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (vala_ccode_node_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (vala_ccode_node_unref (self->priv->definition_fragment), NULL)));
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)));
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_typeregister_function_init, vala_value_typeregister_function_free_value, vala_value_typeregister_function_copy_value, vala_value_typeregister_function_peek_pointer, "p", vala_value_typeregister_function_collect_value, "p", vala_value_typeregister_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_typeregister_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTypeRegisterFunction", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}


gpointer vala_typeregister_function_ref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_typeregister_function_unref (gpointer instance) {
	ValaTypeRegisterFunction* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance (((GTypeInstance *) (self)));
	}
}




