/* valaccodeinvocationexpressionmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valabaseaccess.h>
#include <vala/valasignal.h>
#include <vala/valaobjecttype.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valacreationmethod.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecastexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_invocation_expression_module_real_visit_invocation_expression (ValaCCodeModule* base, ValaInvocationExpression* expr);
static gpointer vala_ccode_invocation_expression_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeInvocationExpressionModule* vala_ccode_invocation_expression_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeInvocationExpressionModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeInvocationExpressionModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeInvocationExpressionModule*) (vala_ccode_assignment_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeInvocationExpressionModule* vala_ccode_invocation_expression_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_invocation_expression_module_construct (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE, codegen, next);
}


static void vala_ccode_invocation_expression_module_real_visit_invocation_expression (ValaCCodeModule* base, ValaInvocationExpression* expr) {
	ValaCCodeInvocationExpressionModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	ValaCCodeExpression* _tmp17;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	ValaDataType* _tmp135;
	gboolean _tmp136;
	gint last_pos;
	gint min_pos;
	self = ((ValaCCodeInvocationExpressionModule*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_invocation_expression_get_call (expr))))));
	m = NULL;
	params = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		g_assert (ma != NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6;
			ValaSignalType* sig_type;
			_tmp6 = NULL;
			sig_type = (_tmp6 = VALA_SIGNAL_TYPE (itype), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
			if (ma != NULL && VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma)) && vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type))) {
				ValaMethod* _tmp7;
				_tmp7 = NULL;
				m = (_tmp7 = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), _tmp7);
			} else {
				ValaCCodeFunctionCall* _tmp9;
				ValaCCodeFunctionCall* _tmp8;
				_tmp9 = NULL;
				_tmp8 = NULL;
				ccall = (_tmp9 = (_tmp8 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_invocation_expression_get_call (expr))))), (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp9);
			}
			(sig_type == NULL ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL)));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp10;
				ValaClass* cl;
				ValaMethod* _tmp12;
				ValaMethod* _tmp11;
				ValaCCodeFunctionCall* _tmp15;
				ValaCCodeIdentifier* _tmp14;
				char* _tmp13;
				ValaCCodeIdentifier* _tmp16;
				/* constructor*/
				_tmp10 = NULL;
				cl = (_tmp10 = VALA_CLASS (vala_object_type_get_type_symbol ((VALA_OBJECT_TYPE (itype)))), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
				_tmp12 = NULL;
				_tmp11 = NULL;
				m = (_tmp12 = (_tmp11 = vala_class_get_default_construction_method (cl), (_tmp11 == NULL ? NULL : vala_code_node_ref (_tmp11))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), _tmp12);
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				ccall = (_tmp15 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = vala_method_get_real_cname (m))))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp15);
				(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
				_tmp13 = (g_free (_tmp13), NULL);
				_tmp16 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp16 = vala_ccode_identifier_new ("object_type")))));
				(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			}
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp17 = NULL;
	ccall_expr = (_tmp17 = ((ValaCCodeExpression*) (ccall)), (_tmp17 == NULL ? NULL : vala_ccode_node_ref (_tmp17)));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp18;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp20;
		char* _tmp19;
		_tmp18 = NULL;
		array_type = (_tmp18 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
		_tmp20 = NULL;
		_tmp19 = NULL;
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (0)), FALSE)), ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))))));
		(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
		_tmp19 = (g_free (_tmp19), NULL);
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && !(VALA_IS_CREATION_METHOD (m))) {
		ValaCCodeExpression* _tmp22;
		ValaCCodeExpression* _tmp21;
		ValaStruct* _tmp24;
		ValaSymbol* _tmp23;
		ValaStruct* st;
		_tmp22 = NULL;
		_tmp21 = NULL;
		instance = (_tmp22 = (_tmp21 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (ma))))), (_tmp21 == NULL ? NULL : vala_ccode_node_ref (_tmp21))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp22);
		_tmp24 = NULL;
		_tmp23 = NULL;
		st = (_tmp24 = (_tmp23 = vala_symbol_get_parent_symbol (((ValaSymbol*) (m))), (VALA_IS_STRUCT (_tmp23) ? ((ValaStruct*) (_tmp23)) : NULL)), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
		if (st != NULL && !vala_struct_is_simple_type (st)) {
			ValaCCodeUnaryExpression* _tmp26;
			ValaCCodeExpression* _tmp25;
			ValaCCodeUnaryExpression* unary;
			/* we need to pass struct instance by reference*/
			_tmp26 = NULL;
			_tmp25 = NULL;
			unary = (_tmp26 = (_tmp25 = instance, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp25) ? ((ValaCCodeUnaryExpression*) (_tmp25)) : NULL)), (_tmp26 == NULL ? NULL : vala_ccode_node_ref (_tmp26)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp28;
				ValaCCodeExpression* _tmp27;
				/* *expr => expr*/
				_tmp28 = NULL;
				_tmp27 = NULL;
				instance = (_tmp28 = (_tmp27 = vala_ccode_unary_expression_get_inner (unary), (_tmp27 == NULL ? NULL : vala_ccode_node_ref (_tmp27))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp28);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
					ValaCCodeExpression* _tmp29;
					_tmp29 = NULL;
					instance = (_tmp29 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp29);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp31;
					ValaCCodeIdentifier* _tmp30;
					ValaCCodeUnaryExpression* _tmp33;
					ValaCCodeIdentifier* _tmp32;
					ValaCCodeExpression* _tmp35;
					ValaCCodeExpression* _tmp34;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
					_tmp31 = NULL;
					_tmp30 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp31 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp30 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
					(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
					_tmp33 = NULL;
					_tmp32 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))))))));
					(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
					(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
					_tmp35 = NULL;
					_tmp34 = NULL;
					instance = (_tmp35 = (_tmp34 = ((ValaCCodeExpression*) (ccomma)), (_tmp34 == NULL ? NULL : vala_ccode_node_ref (_tmp34))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp35);
					(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
				}
			}
			(unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)));
		}
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp36;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp39;
			char* _tmp38;
			char* _tmp37;
			ValaCCodeFunctionCall* _tmp40;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			ValaMemberAccess* _tmp42;
			ValaExpression* _tmp41;
			ValaMemberAccess* ma;
			_tmp36 = NULL;
			cl = (_tmp36 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp36 == NULL ? NULL : vala_code_node_ref (_tmp36)));
			_tmp39 = NULL;
			_tmp38 = NULL;
			_tmp37 = NULL;
			_tmp40 = NULL;
			cast = (_tmp40 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new ((_tmp38 = g_strconcat ((_tmp37 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (cl)), NULL)), "_CLASS", NULL))))))), (_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL))), (_tmp38 = (g_free (_tmp38), NULL)), (_tmp37 = (g_free (_tmp37), NULL)), _tmp40);
			klass = NULL;
			_tmp42 = NULL;
			_tmp41 = NULL;
			ma = (_tmp42 = (_tmp41 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp41) ? ((ValaMemberAccess*) (_tmp41)) : NULL)), (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42)));
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) (self))->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp43;
					/* Accessing the method from a static or class constructor*/
					_tmp43 = NULL;
					klass = (_tmp43 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("klass"))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp43);
				} else {
					ValaCCodeIdentifier* _tmp44;
					ValaCCodeFunctionCall* _tmp45;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp46;
					ValaCCodeExpression* _tmp48;
					ValaCCodeExpression* _tmp47;
					/* Accessing the method from within an instance method*/
					_tmp44 = NULL;
					_tmp45 = NULL;
					k = (_tmp45 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp44 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))))), (_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL))), _tmp45);
					_tmp46 = NULL;
					vala_ccode_function_call_add_argument (k, ((ValaCCodeExpression*) ((_tmp46 = vala_ccode_identifier_new ("self")))));
					(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
					_tmp48 = NULL;
					_tmp47 = NULL;
					klass = (_tmp48 = (_tmp47 = ((ValaCCodeExpression*) (k)), (_tmp47 == NULL ? NULL : vala_ccode_node_ref (_tmp47))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp48);
					(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
				}
			} else {
				ValaCCodeIdentifier* _tmp49;
				ValaCCodeFunctionCall* _tmp50;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp52;
				ValaCCodeExpression* _tmp51;
				/* Accessing the method of an instance*/
				_tmp49 = NULL;
				_tmp50 = NULL;
				k = (_tmp50 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp49 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))))), (_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL))), _tmp50);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (ma))))));
				_tmp52 = NULL;
				_tmp51 = NULL;
				klass = (_tmp52 = (_tmp51 = ((ValaCCodeExpression*) (k)), (_tmp51 == NULL ? NULL : vala_ccode_node_ref (_tmp51))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp52);
				(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), ((ValaCCodeExpression*) (cast)));
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (vala_ccode_node_unref (cast), NULL)));
			(klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)));
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp53;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp54;
		ValaCCodeFunctionCall* _tmp55;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp57;
		char* _tmp56;
		_tmp53 = NULL;
		array_type = (_tmp53 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp53 == NULL ? NULL : vala_code_node_ref (_tmp53)));
		_tmp54 = NULL;
		_tmp55 = NULL;
		csizeof = (_tmp55 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp54 = vala_ccode_identifier_new ("sizeof"))))), (_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL))), _tmp55);
		_tmp57 = NULL;
		_tmp56 = NULL;
		vala_ccode_function_call_add_argument (csizeof, ((ValaCCodeExpression*) ((_tmp57 = vala_ccode_identifier_new ((_tmp56 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type))))))));
		(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
		_tmp56 = (g_free (_tmp56), NULL);
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), 0.1, FALSE)), ((ValaCCodeExpression*) (csizeof)));
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaUnaryExpression* _tmp59;
						ValaExpression* _tmp58;
						ValaUnaryExpression* unary;
						_tmp59 = NULL;
						_tmp58 = NULL;
						unary = (_tmp59 = (_tmp58 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp58) ? ((ValaUnaryExpression*) (_tmp58)) : NULL)), (_tmp59 == NULL ? NULL : vala_code_node_ref (_tmp59)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp60;
							ValaFormalParameter* _tmp61;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp60 = NULL;
							_tmp61 = NULL;
							param = (_tmp61 = vala_formal_parameter_new ((_tmp60 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp60 = (g_free (_tmp60), NULL)), _tmp61);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp62;
								ValaFormalParameter* _tmp63;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp62 = NULL;
								_tmp63 = NULL;
								param = (_tmp63 = vala_formal_parameter_new ((_tmp62 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp62 = (g_free (_tmp62), NULL)), _tmp63);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp65;
								char* _tmp64;
								/* in argument*/
								_tmp65 = NULL;
								_tmp64 = NULL;
								vala_method_add_parameter (m, (_tmp65 = vala_formal_parameter_new ((_tmp64 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (arg), NULL)));
								(_tmp65 == NULL ? NULL : (_tmp65 = (vala_code_node_unref (_tmp65), NULL)));
								_tmp64 = (g_free (_tmp64), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						vala_code_node_accept (((ValaCodeNode*) (param)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp70;
				ValaCCodeCastExpression* _tmp69;
				char* _tmp68;
				char* _tmp67;
				ValaCCodeIdentifier* _tmp66;
				_tmp70 = NULL;
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp66 = NULL;
				ccall_expr = (_tmp70 = ((ValaCCodeExpression*) (vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp66 = vala_ccode_identifier_new ("self")))), ((ValaCCodeExpression*) ((_tmp69 = vala_ccode_cast_expression_new (((ValaCCodeExpression*) (ccall)), (_tmp68 = g_strconcat ((_tmp67 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), FALSE)), "*", NULL)))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp70);
				(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
				_tmp68 = (g_free (_tmp68), NULL);
				_tmp67 = (g_free (_tmp67), NULL);
				(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (((GeeIterable*) (params)));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaCCodeExpression* _tmp71;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp71 = NULL;
				cexpr = (_tmp71 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (arg)))), (_tmp71 == NULL ? NULL : vala_ccode_node_ref (_tmp71)));
				extra_args = ((GeeList*) (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal)));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						ValaCCodeExpression* _tmp87;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaArrayType* _tmp72;
							ValaArrayType* array_type;
							_tmp72 = NULL;
							array_type = (_tmp72 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp72 == NULL ? NULL : vala_code_node_ref (_tmp72)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp73;
									_tmp73 = NULL;
									gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp73 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), arg, dim)));
									(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaDelegateType* _tmp74;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp75;
								ValaDelegate* d;
								_tmp74 = NULL;
								deleg_type = (_tmp74 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp74 == NULL ? NULL : vala_code_node_ref (_tmp74)));
								_tmp75 = NULL;
								d = (_tmp75 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp75 == NULL ? NULL : vala_code_node_ref (_tmp75)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* delegate_target;
									delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (((ValaCCodeBaseModule*) (self)), arg);
									if (vala_data_type_get_value_owned (((ValaDataType*) (deleg_type)))) {
										ValaCCodeExpression* delegate_target_destroy_notify;
										ValaMethod* _tmp77;
										ValaSymbol* _tmp76;
										ValaMethod* delegate_method;
										ValaMemberAccess* _tmp79;
										ValaExpression* _tmp78;
										ValaMemberAccess* ma;
										delegate_target_destroy_notify = NULL;
										_tmp77 = NULL;
										_tmp76 = NULL;
										delegate_method = (_tmp77 = (_tmp76 = vala_expression_get_symbol_reference (arg), (VALA_IS_METHOD (_tmp76) ? ((ValaMethod*) (_tmp76)) : NULL)), (_tmp77 == NULL ? NULL : vala_code_node_ref (_tmp77)));
										_tmp79 = NULL;
										_tmp78 = NULL;
										ma = (_tmp79 = (_tmp78 = arg, (VALA_IS_MEMBER_ACCESS (_tmp78) ? ((ValaMemberAccess*) (_tmp78)) : NULL)), (_tmp79 == NULL ? NULL : vala_code_node_ref (_tmp79)));
										if (delegate_method != NULL && vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE && vala_member_access_get_inner (ma) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))))) {
											ValaCCodeExpression* _tmp80;
											ValaCCodeFunctionCall* _tmp81;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp83;
											ValaCCodeExpression* _tmp82;
											ValaCCodeExpression* _tmp84;
											_tmp80 = NULL;
											_tmp81 = NULL;
											ref_call = (_tmp81 = vala_ccode_function_call_new ((_tmp80 = vala_ccode_base_module_get_dup_func_expression (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference (((ValaCodeNode*) (arg)))))), (_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL))), _tmp81);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp83 = NULL;
											_tmp82 = NULL;
											delegate_target = (_tmp83 = (_tmp82 = ((ValaCCodeExpression*) (ref_call)), (_tmp82 == NULL ? NULL : vala_ccode_node_ref (_tmp82))), (delegate_target == NULL ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL))), _tmp83);
											_tmp84 = NULL;
											delegate_target_destroy_notify = (_tmp84 = vala_ccode_base_module_get_destroy_func_expression (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL))), _tmp84);
											(ref_call == NULL ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL)));
										} else {
											ValaCCodeExpression* _tmp85;
											_tmp85 = NULL;
											delegate_target_destroy_notify = (_tmp85 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL))), _tmp85);
										}
										gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
										(delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)));
										(delegate_method == NULL ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL)));
										(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
									}
									gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
									multiple_cargs = TRUE;
									(delegate_target == NULL ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)));
								}
								(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaCCodeExpression* _tmp86;
									_tmp86 = NULL;
									gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp86 = vala_ccode_base_module_get_delegate_target_cexpression (((ValaCCodeBaseModule*) (self)), arg)));
									(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						_tmp87 = NULL;
						cexpr = (_tmp87 = vala_ccode_base_module_handle_struct_argument (((ValaCCodeBaseModule*) (self)), param, arg, cexpr), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp87);
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp89;
							ValaCCodeIdentifier* _tmp88;
							ValaCCodeExpression* _tmp90;
							ValaCCodeExpression* _tmp92;
							ValaCCodeExpression* _tmp91;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (arg), TRUE, NULL);
							gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_decl);
							_tmp89 = NULL;
							_tmp88 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp89 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp88 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
							(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
							_tmp90 = NULL;
							cexpr = (_tmp90 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl)))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp90);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp92 = NULL;
							_tmp91 = NULL;
							ccall_expr = (_tmp92 = (_tmp91 = ((ValaCCodeExpression*) (ccomma)), (_tmp91 == NULL ? NULL : vala_ccode_node_ref (_tmp91))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp92);
							(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak ref/out arguments
						 disabled for arrays for now as that requires special handling
						 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN && vala_ccode_base_module_requires_destroy (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (arg)) && (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT || !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) && !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							ValaUnaryExpression* _tmp93;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp95;
							ValaCCodeIdentifier* _tmp94;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeCommaExpression* cassign_comma;
							ValaLocalVariable* assign_temp_var;
							ValaCCodeAssignment* _tmp106;
							ValaCCodeExpression* _tmp105;
							ValaCCodeIdentifier* _tmp104;
							ValaCCodeIdentifier* _tmp103;
							ValaCCodeExpression* _tmp107;
							ValaCCodeIdentifier* _tmp108;
							ValaCCodeAssignment* _tmp109;
							ValaCCodeExpression* _tmp112;
							ValaCCodeExpression* _tmp111;
							_tmp93 = NULL;
							unary = (_tmp93 = VALA_UNARY_EXPRESSION (arg), (_tmp93 == NULL ? NULL : vala_code_node_ref (_tmp93)));
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
							gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
							_tmp95 = NULL;
							_tmp94 = NULL;
							cexpr = (_tmp95 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp94 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var)))))))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp95);
							(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
								ValaCCodeCommaExpression* crefcomma;
								ValaCCodeAssignment* _tmp97;
								ValaCCodeIdentifier* _tmp96;
								ValaCCodeExpression* _tmp99;
								ValaCCodeExpression* _tmp98;
								crefcomma = vala_ccode_comma_expression_new ();
								_tmp97 = NULL;
								_tmp96 = NULL;
								vala_ccode_comma_expression_append_expression (crefcomma, ((ValaCCodeExpression*) ((_tmp97 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_unary_expression_get_inner (unary))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
								(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
								(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
								vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
								_tmp99 = NULL;
								_tmp98 = NULL;
								cexpr = (_tmp99 = (_tmp98 = ((ValaCCodeExpression*) (crefcomma)), (_tmp98 == NULL ? NULL : vala_ccode_node_ref (_tmp98))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp99);
								(crefcomma == NULL ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL)));
							}
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp100;
								ValaCCodeAssignment* _tmp102;
								ValaCCodeIdentifier* _tmp101;
								_tmp100 = NULL;
								ret_temp_var = (_tmp100 = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL))), _tmp100);
								gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, ret_temp_var);
								_tmp102 = NULL;
								_tmp101 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp102 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp101 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (ret_temp_var))))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
								(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
								(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
							}
							cassign_comma = vala_ccode_comma_expression_new ();
							assign_temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
							gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, assign_temp_var);
							_tmp106 = NULL;
							_tmp105 = NULL;
							_tmp104 = NULL;
							_tmp103 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, ((ValaCCodeExpression*) ((_tmp106 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (assign_temp_var))))))), (_tmp105 = vala_ccode_base_module_transform_expression (((ValaCCodeBaseModule*) (self)), ((ValaCCodeExpression*) ((_tmp104 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))))))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
							(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
							(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
							(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
							/* unref old value*/
							_tmp107 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, (_tmp107 = vala_ccode_base_module_get_unref_expression (((ValaCCodeBaseModule*) (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_unary_expression_get_inner (unary))))), vala_expression_get_value_type (arg), arg)));
							(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
							_tmp108 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, ((ValaCCodeExpression*) ((_tmp108 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (assign_temp_var))))))));
							(_tmp108 == NULL ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)));
							/* assign new value*/
							_tmp109 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp109 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_unary_expression_get_inner (unary))))), ((ValaCCodeExpression*) (cassign_comma)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp110;
								_tmp110 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp110 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (ret_temp_var))))))));
								(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
							}
							_tmp112 = NULL;
							_tmp111 = NULL;
							ccall_expr = (_tmp112 = (_tmp111 = ((ValaCCodeExpression*) (ccomma)), (_tmp111 == NULL ? NULL : vala_ccode_node_ref (_tmp111))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp112);
							(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)));
							(cassign_comma == NULL ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL)));
							(assign_temp_var == NULL ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL)));
						}
						if (vala_formal_parameter_get_ctype (param) != NULL) {
							ValaCCodeExpression* _tmp113;
							_tmp113 = NULL;
							cexpr = (_tmp113 = ((ValaCCodeExpression*) (vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp113);
						}
					}
					arg_pos = vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (i)), ellipsis);
				}
				gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (gee_collection_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (vala_formal_parameter_get_ellipsis (param));
		ellipsis = TRUE;
		(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp114;
		ValaArrayType* array_type;
		_tmp114 = NULL;
		array_type = (_tmp114 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp114 == NULL ? NULL : vala_code_node_ref (_tmp114)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp115;
					temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
					gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
					_tmp115 = NULL;
					gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), ((ValaCCodeExpression*) ((_tmp115 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (temp_ref)))))));
					(_tmp115 == NULL ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)));
					vala_invocation_expression_append_array_size (expr, ((ValaCCodeExpression*) (temp_ref)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp116;
					_tmp116 = NULL;
					vala_invocation_expression_append_array_size (expr, ((ValaCCodeExpression*) ((_tmp116 = vala_ccode_constant_new ("-1")))));
					(_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp117;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp118;
			ValaDelegate* d;
			_tmp117 = NULL;
			deleg_type = (_tmp117 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp117 == NULL ? NULL : vala_code_node_ref (_tmp117)));
			_tmp118 = NULL;
			d = (_tmp118 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp118 == NULL ? NULL : vala_code_node_ref (_tmp118)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp120;
				ValaVoidType* _tmp119;
				ValaLocalVariable* _tmp121;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp122;
				_tmp120 = NULL;
				_tmp119 = NULL;
				_tmp121 = NULL;
				temp_var = (_tmp121 = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaDataType*) ((_tmp120 = vala_pointer_type_new (((ValaDataType*) ((_tmp119 = vala_void_type_new ()))), NULL)))), TRUE, NULL), (_tmp120 == NULL ? NULL : (_tmp120 = (vala_code_node_unref (_tmp120), NULL))), (_tmp119 == NULL ? NULL : (_tmp119 = (vala_code_node_unref (_tmp119), NULL))), _tmp121);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
				gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
				_tmp122 = NULL;
				gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), ((ValaCCodeExpression*) ((_tmp122 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (temp_ref)))))));
				(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
				vala_invocation_expression_set_delegate_target (expr, ((ValaCCodeExpression*) (temp_ref)));
				(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	if (m != NULL && vala_method_get_coroutine (m)) {
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0 && vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference (((ValaExpression*) (ma)))) {
			ValaCCodeConstant* _tmp123;
			ValaCCodeConstant* _tmp124;
			/* asynchronous begin call*/
			_tmp123 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), ((ValaCCodeExpression*) ((_tmp123 = vala_ccode_constant_new ("NULL")))));
			(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
			_tmp124 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), -0.9, FALSE)), ((ValaCCodeExpression*) ((_tmp124 = vala_ccode_constant_new ("NULL")))));
			(_tmp124 == NULL ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp127;
			char* _tmp126;
			char* _tmp125;
			ValaCCodeIdentifier* _tmp128;
			_tmp127 = NULL;
			_tmp126 = NULL;
			_tmp125 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), ((ValaCCodeExpression*) ((_tmp127 = vala_ccode_identifier_new ((_tmp126 = g_strconcat ((_tmp125 = vala_method_get_cname (((ValaCCodeBaseModule*) (self))->current_method)), "_ready", NULL)))))));
			(_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)));
			_tmp126 = (g_free (_tmp126), NULL);
			_tmp125 = (g_free (_tmp125), NULL);
			_tmp128 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), -0.9, FALSE)), ((ValaCCodeExpression*) ((_tmp128 = vala_ccode_identifier_new ("data")))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
		}
	}
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (expr)))) {
		ValaCCodeUnaryExpression* _tmp130;
		ValaCCodeIdentifier* _tmp129;
		/* method can fail*/
		((ValaCCodeBaseModule*) (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp130 = NULL;
		_tmp129 = NULL;
		gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), FALSE)), ((ValaCCodeExpression*) ((_tmp130 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp129 = vala_ccode_identifier_new ("inner_error")))))))));
		(_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)));
		(_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (!vala_method_get_printf_format (m) && _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0) {
			ValaCCodeConstant* _tmp131;
			_tmp131 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), TRUE)), ((ValaCCodeExpression*) ((_tmp131 = vala_ccode_constant_new (vala_method_get_sentinel (m))))));
			(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp132;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp133;
			ValaDelegate* d;
			_tmp132 = NULL;
			deleg_type = (_tmp132 = VALA_DELEGATE_TYPE (itype), (_tmp132 == NULL ? NULL : vala_code_node_ref (_tmp132)));
			_tmp133 = NULL;
			d = (_tmp133 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp133 == NULL ? NULL : vala_code_node_ref (_tmp133)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp134;
				_tmp134 = NULL;
				gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp134 = vala_ccode_base_module_get_delegate_target_cexpression (((ValaCCodeBaseModule*) (self)), vala_invocation_expression_get_call (expr))));
				(_tmp134 == NULL ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	_tmp135 = NULL;
	if ((_tmp136 = VALA_IS_SIGNAL_TYPE (itype) && !(VALA_IS_VOID_TYPE ((_tmp135 = vala_data_type_get_return_type (itype)))), (_tmp135 == NULL ? NULL : (_tmp135 = (vala_code_node_unref (_tmp135), NULL))), _tmp136)) {
		ValaSignal* _tmp137;
		ValaSignal* sig;
		_tmp137 = NULL;
		sig = (_tmp137 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp137 == NULL ? NULL : vala_code_node_ref (_tmp137)));
		if (!vala_signal_get_has_emitter (sig)) {
			ValaDataType* _tmp138;
			ValaLocalVariable* _tmp139;
			ValaLocalVariable* temp_var;
			ValaCCodeIdentifier* temp_ref;
			ValaCCodeUnaryExpression* _tmp140;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp142;
			ValaCCodeExpression* _tmp141;
			_tmp138 = NULL;
			_tmp139 = NULL;
			temp_var = (_tmp139 = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), (_tmp138 = vala_data_type_get_return_type (itype)), TRUE, NULL), (_tmp138 == NULL ? NULL : (_tmp138 = (vala_code_node_unref (_tmp138), NULL))), _tmp139);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
			gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
			_tmp140 = NULL;
			gee_map_set (((GeeMap*) (carg_map)), GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (((ValaCCodeBaseModule*) (self)), ((double) (-1)), TRUE)), ((ValaCCodeExpression*) ((_tmp140 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (temp_ref)))))));
			(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp142 = NULL;
			_tmp141 = NULL;
			ccall_expr = (_tmp142 = (_tmp141 = ((ValaCCodeExpression*) (ccomma)), (_tmp141 == NULL ? NULL : vala_ccode_node_ref (_tmp141))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp142);
			(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		}
		(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp143;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (((GeeMap*) (carg_map)));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp143 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp143 = ((ValaCCodeExpression*) (gee_map_get (((GeeMap*) (carg_map)), GINT_TO_POINTER (min_pos))))));
		(_tmp143 == NULL ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp144;
		_tmp144 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp144 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp144 == NULL ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (((ValaExpression*) (expr)))) != NULL) {
			ValaCCodeExpression* _tmp145;
			_tmp145 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp145 = vala_ccode_base_module_convert_from_generic_pointer (((ValaCCodeBaseModule*) (self)), ccall_expr, vala_expression_get_value_type (((ValaExpression*) (expr))))))));
			(_tmp145 == NULL ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL)));
		} else {
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall_expr)));
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp146;
		GeeIterator* _tmp147;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp149;
		ValaExpression* _tmp148;
		ValaCCodeExpression* _tmp150;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp151;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp152;
		ValaArrayType* array_type;
		char* _tmp154;
		char* _tmp153;
		ValaCCodeIdentifier* _tmp155;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp156;
		ValaCCodeParenthesizedExpression* _tmp157;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp158;
		ValaCCodeFunctionCall* _tmp159;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp160;
		ValaCCodeConstant* _tmp161;
		ValaCCodeBinaryExpression* _tmp162;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp163;
		ValaCCodeConditionalExpression* _tmp165;
		ValaCCodeConstant* _tmp164;
		ValaCCodeAssignment* _tmp167;
		ValaCCodeExpression* _tmp166;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp146 = NULL;
		_tmp147 = NULL;
		arg_it = (_tmp147 = gee_iterable_iterator (((GeeIterable*) ((_tmp146 = vala_invocation_expression_get_argument_list (expr))))), (_tmp146 == NULL ? NULL : (_tmp146 = (gee_collection_object_unref (_tmp146), NULL))), _tmp147);
		gee_iterator_next (arg_it);
		_tmp149 = NULL;
		_tmp148 = NULL;
		_tmp150 = NULL;
		new_size = (_tmp150 = (_tmp149 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) ((_tmp148 = ((ValaExpression*) (gee_iterator_get (arg_it)))))))), (_tmp149 == NULL ? NULL : vala_ccode_node_ref (_tmp149))), (_tmp148 == NULL ? NULL : (_tmp148 = (vala_code_node_unref (_tmp148), NULL))), _tmp150);
		temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))));
		gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_decl);
		/* memset needs string.h */
		((ValaCCodeBaseModule*) (self))->string_h_needed = TRUE;
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_member_access_get_inner (ma), 1);
		_tmp151 = NULL;
		celems = (_tmp151 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (ma))))), (_tmp151 == NULL ? NULL : vala_ccode_node_ref (_tmp151)));
		_tmp152 = NULL;
		array_type = (_tmp152 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp152 == NULL ? NULL : vala_code_node_ref (_tmp152)));
		_tmp154 = NULL;
		_tmp153 = NULL;
		_tmp155 = NULL;
		csizeof = (_tmp155 = vala_ccode_identifier_new ((_tmp154 = g_strdup_printf ("sizeof (%s)", (_tmp153 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp154 = (g_free (_tmp154), NULL)), (_tmp153 = (g_free (_tmp153), NULL)), _tmp155);
		_tmp156 = NULL;
		_tmp157 = NULL;
		cdelta = (_tmp157 = vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp156 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, ((ValaCCodeExpression*) (temp_ref)), clen))))), (_tmp156 == NULL ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL))), _tmp157);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, ((ValaCCodeExpression*) (temp_ref)), clen);
		_tmp158 = NULL;
		_tmp159 = NULL;
		czero = (_tmp159 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp158 = vala_ccode_identifier_new ("memset"))))), (_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL))), _tmp159);
		_tmp160 = NULL;
		vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp160 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)))));
		(_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL)));
		_tmp161 = NULL;
		vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp161 = vala_ccode_constant_new ("0")))));
		(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
		_tmp162 = NULL;
		vala_ccode_function_call_add_argument (czero, ((ValaCCodeExpression*) ((_tmp162 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, ((ValaCCodeExpression*) (csizeof)), ((ValaCCodeExpression*) (cdelta)))))));
		(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp163 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp163 = vala_ccode_assignment_new (((ValaCCodeExpression*) (temp_ref)), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))));
		_tmp165 = NULL;
		_tmp164 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp165 = vala_ccode_conditional_expression_new (((ValaCCodeExpression*) (ccheck)), ((ValaCCodeExpression*) (czero)), ((ValaCCodeExpression*) ((_tmp164 = vala_ccode_constant_new ("NULL")))))))));
		(_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)));
		(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
		_tmp167 = NULL;
		_tmp166 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp167 = vala_ccode_assignment_new ((_tmp166 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_member_access_get_inner (ma), 1)), ((ValaCCodeExpression*) (temp_ref)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
		(_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)));
		vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
		(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (vala_ccode_node_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (vala_ccode_node_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (vala_ccode_node_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
	} else {
		if (m == ((ValaCCodeBaseModule*) (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp168;
			ValaCCodeFunctionCall* _tmp169;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp170;
			ValaCCodeExpression* _tmp171;
			ValaCCodeIdentifier* _tmp172;
			ValaCCodeFunctionCall* _tmp173;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp174;
			ValaCCodeIdentifier* _tmp175;
			ValaCCodeFunctionCall* _tmp176;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp177;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp178;
			temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))));
			gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp168 = NULL;
			_tmp169 = NULL;
			coffsetcall = (_tmp169 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp168 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))))), (_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL))), _tmp169);
			/* full string*/
			_tmp170 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp170 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 0)))));
			(_tmp170 == NULL ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL)));
			/* offset*/
			_tmp171 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp171 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 1)))));
			(_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL)));
			_tmp172 = NULL;
			_tmp173 = NULL;
			coffsetcall2 = (_tmp173 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp172 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))))), (_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL))), _tmp173);
			vala_ccode_function_call_add_argument (coffsetcall2, ((ValaCCodeExpression*) (temp_ref)));
			/* len*/
			_tmp174 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp174 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 2)))));
			(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
			_tmp175 = NULL;
			_tmp176 = NULL;
			cndupcall = (_tmp176 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp175 = vala_ccode_identifier_new ("g_strndup"))))), (_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL))), _tmp176);
			vala_ccode_function_call_add_argument (cndupcall, ((ValaCCodeExpression*) (temp_ref)));
			_tmp177 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, ((ValaCCodeExpression*) ((_tmp177 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, ((ValaCCodeExpression*) (coffsetcall2)), ((ValaCCodeExpression*) (temp_ref)))))));
			(_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp178 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp178 = vala_ccode_assignment_new (((ValaCCodeExpression*) (temp_ref)), ((ValaCCodeExpression*) (coffsetcall)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (cndupcall)));
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
			(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (vala_ccode_node_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (vala_ccode_node_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		}
	}
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (vala_code_node_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL)));
}


static void vala_ccode_invocation_expression_module_class_init (ValaCCodeInvocationExpressionModuleClass * klass) {
	vala_ccode_invocation_expression_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_invocation_expression = vala_ccode_invocation_expression_module_real_visit_invocation_expression;
}


static void vala_ccode_invocation_expression_module_instance_init (ValaCCodeInvocationExpressionModule * self) {
}


GType vala_ccode_invocation_expression_module_get_type (void) {
	static GType vala_ccode_invocation_expression_module_type_id = 0;
	if (vala_ccode_invocation_expression_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionModule), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_module_instance_init, NULL };
		vala_ccode_invocation_expression_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeInvocationExpressionModule", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




