/* valaccodedynamicsignalmodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDYNAMICSIGNALMODULE_H__
#define __GOBJECT_VALACCODEDYNAMICSIGNALMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadynamicsignal.h>
#include <gobject/valaccodedynamicpropertymodule.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemodule.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE (vala_ccode_dynamic_signal_module_get_type ())
#define VALA_CCODE_DYNAMIC_SIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE, ValaCCodeDynamicSignalModule))
#define VALA_CCODE_DYNAMIC_SIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE, ValaCCodeDynamicSignalModuleClass))
#define VALA_IS_CCODE_DYNAMIC_SIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE))
#define VALA_IS_CCODE_DYNAMIC_SIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE))
#define VALA_CCODE_DYNAMIC_SIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DYNAMIC_SIGNAL_MODULE, ValaCCodeDynamicSignalModuleClass))

typedef struct _ValaCCodeDynamicSignalModule ValaCCodeDynamicSignalModule;
typedef struct _ValaCCodeDynamicSignalModuleClass ValaCCodeDynamicSignalModuleClass;
typedef struct _ValaCCodeDynamicSignalModulePrivate ValaCCodeDynamicSignalModulePrivate;

/**
 * The link between a dynamic signal and generated code.
 */
struct _ValaCCodeDynamicSignalModule {
	ValaCCodeDynamicPropertyModule parent_instance;
	ValaCCodeDynamicSignalModulePrivate * priv;
};

struct _ValaCCodeDynamicSignalModuleClass {
	ValaCCodeDynamicPropertyModuleClass parent_class;
};


ValaCCodeDynamicSignalModule* vala_ccode_dynamic_signal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDynamicSignalModule* vala_ccode_dynamic_signal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
GType vala_ccode_dynamic_signal_module_get_type (void);


G_END_DECLS

#endif
