/* valaccodeinitializerlist.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeinitializerlist.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeInitializerListPrivate {
	GeeList* initializers;
};

#define VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListPrivate))
enum  {
	VALA_CCODE_INITIALIZER_LIST_DUMMY_PROPERTY
};
static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_initializer_list_parent_class = NULL;
static void vala_ccode_initializer_list_finalize (ValaCCodeNode* obj);



/**
 * Appends the specified expression to this initializer list.
 *
 * @param expr an expression
 */
void vala_ccode_initializer_list_append (ValaCCodeInitializerList* self, ValaCCodeExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_collection_add (((GeeCollection*) (self->priv->initializers)), expr);
}


static void vala_ccode_initializer_list_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeInitializerList * self;
	gboolean first;
	self = ((ValaCCodeInitializerList*) (base));
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "{");
	first = TRUE;
	{
		GeeList* expr_collection;
		int expr_it;
		expr_collection = self->priv->initializers;
		for (expr_it = 0; expr_it < gee_collection_get_size (GEE_COLLECTION (expr_collection)); expr_it = expr_it + 1) {
			ValaCCodeExpression* expr;
			expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (expr_collection), expr_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (expr != NULL) {
					vala_ccode_node_write (((ValaCCodeNode*) (expr)), writer);
				}
				(expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)));
			}
		}
	}
	vala_ccode_writer_write_string (writer, "}");
}


/**
 * Represents a struct or array initializer list in the C code.
 */
ValaCCodeInitializerList* vala_ccode_initializer_list_construct (GType object_type) {
	ValaCCodeInitializerList* self;
	self = ((ValaCCodeInitializerList*) (g_type_create_instance (object_type)));
	return self;
}


ValaCCodeInitializerList* vala_ccode_initializer_list_new (void) {
	return vala_ccode_initializer_list_construct (VALA_TYPE_CCODE_INITIALIZER_LIST);
}


static void vala_ccode_initializer_list_class_init (ValaCCodeInitializerListClass * klass) {
	vala_ccode_initializer_list_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeInitializerListPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_initializer_list_real_write;
}


static void vala_ccode_initializer_list_instance_init (ValaCCodeInitializerList * self) {
	self->priv = VALA_CCODE_INITIALIZER_LIST_GET_PRIVATE (self);
	self->priv->initializers = ((GeeList*) (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal)));
}


static void vala_ccode_initializer_list_finalize (ValaCCodeNode* obj) {
	ValaCCodeInitializerList * self;
	self = VALA_CCODE_INITIALIZER_LIST (obj);
	(self->priv->initializers == NULL ? NULL : (self->priv->initializers = (gee_collection_object_unref (self->priv->initializers), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_initializer_list_parent_class)->finalize (obj);
}


GType vala_ccode_initializer_list_get_type (void) {
	static GType vala_ccode_initializer_list_type_id = 0;
	if (vala_ccode_initializer_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInitializerList), 0, (GInstanceInitFunc) vala_ccode_initializer_list_instance_init, NULL };
		vala_ccode_initializer_list_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeInitializerList", &g_define_type_info, 0);
	}
	return vala_ccode_initializer_list_type_id;
}




