/* valaccodeforstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEFORSTATEMENT_H__
#define __CCODE_VALACCODEFORSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_FOR_STATEMENT (vala_ccode_for_statement_get_type ())
#define VALA_CCODE_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatement))
#define VALA_CCODE_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatementClass))
#define VALA_IS_CCODE_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FOR_STATEMENT))
#define VALA_IS_CCODE_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FOR_STATEMENT))
#define VALA_CCODE_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatementClass))

typedef struct _ValaCCodeForStatement ValaCCodeForStatement;
typedef struct _ValaCCodeForStatementClass ValaCCodeForStatementClass;
typedef struct _ValaCCodeForStatementPrivate ValaCCodeForStatementPrivate;

/**
 * Represents a for iteration statement in the C code.
 */
struct _ValaCCodeForStatement {
	ValaCCodeStatement parent_instance;
	ValaCCodeForStatementPrivate * priv;
};

struct _ValaCCodeForStatementClass {
	ValaCCodeStatementClass parent_class;
};


ValaCCodeForStatement* vala_ccode_for_statement_construct (GType object_type, ValaCCodeExpression* condition, ValaCCodeStatement* body);
ValaCCodeForStatement* vala_ccode_for_statement_new (ValaCCodeExpression* condition, ValaCCodeStatement* body);
void vala_ccode_for_statement_add_initializer (ValaCCodeForStatement* self, ValaCCodeExpression* expr);
void vala_ccode_for_statement_add_iterator (ValaCCodeForStatement* self, ValaCCodeExpression* expr);
ValaCCodeExpression* vala_ccode_for_statement_get_condition (ValaCCodeForStatement* self);
void vala_ccode_for_statement_set_condition (ValaCCodeForStatement* self, ValaCCodeExpression* value);
ValaCCodeStatement* vala_ccode_for_statement_get_body (ValaCCodeForStatement* self);
void vala_ccode_for_statement_set_body (ValaCCodeForStatement* self, ValaCCodeStatement* value);
GType vala_ccode_for_statement_get_type (void);


G_END_DECLS

#endif
