/* hashmap.c generated by valac, the Vala compiler
 * generated from hashmap.vala, do not modify */

/* hashmap.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valagee.h"
#include <glib.h>
#include <glib-object.h>

typedef struct _ValaHashMapNode ValaHashMapNode;

#define VALA_HASH_MAP_TYPE_KEY_SET (vala_hash_map_key_set_get_type ())
#define VALA_HASH_MAP_KEY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySet))
#define VALA_HASH_MAP_KEY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySetClass))
#define VALA_HASH_MAP_IS_KEY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_KEY_SET))
#define VALA_HASH_MAP_IS_KEY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_KEY_SET))
#define VALA_HASH_MAP_KEY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySetClass))

typedef struct _ValaHashMapKeySet ValaHashMapKeySet;
typedef struct _ValaHashMapKeySetClass ValaHashMapKeySetClass;

#define VALA_HASH_MAP_TYPE_VALUE_COLLECTION (vala_hash_map_value_collection_get_type ())
#define VALA_HASH_MAP_VALUE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollection))
#define VALA_HASH_MAP_VALUE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollectionClass))
#define VALA_HASH_MAP_IS_VALUE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION))
#define VALA_HASH_MAP_IS_VALUE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_VALUE_COLLECTION))
#define VALA_HASH_MAP_VALUE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollectionClass))

typedef struct _ValaHashMapValueCollection ValaHashMapValueCollection;
typedef struct _ValaHashMapValueCollectionClass ValaHashMapValueCollectionClass;

#define VALA_HASH_MAP_TYPE_MAP_ITERATOR (vala_hash_map_map_iterator_get_type ())
#define VALA_HASH_MAP_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_MAP_ITERATOR, ValaHashMapMapIterator))
#define VALA_HASH_MAP_MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_MAP_ITERATOR, ValaHashMapMapIteratorClass))
#define VALA_HASH_MAP_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_MAP_ITERATOR))
#define VALA_HASH_MAP_IS_MAP_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_MAP_ITERATOR))
#define VALA_HASH_MAP_MAP_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_MAP_ITERATOR, ValaHashMapMapIteratorClass))

typedef struct _ValaHashMapMapIterator ValaHashMapMapIterator;
typedef struct _ValaHashMapMapIteratorClass ValaHashMapMapIteratorClass;
#define _vala_hash_map_node_free0(var) ((var == NULL) ? NULL : (var = (vala_hash_map_node_free (var), NULL)))
typedef struct _ValaHashMapKeySetPrivate ValaHashMapKeySetPrivate;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VALA_HASH_MAP_TYPE_KEY_ITERATOR (vala_hash_map_key_iterator_get_type ())
#define VALA_HASH_MAP_KEY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIterator))
#define VALA_HASH_MAP_KEY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIteratorClass))
#define VALA_HASH_MAP_IS_KEY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR))
#define VALA_HASH_MAP_IS_KEY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_KEY_ITERATOR))
#define VALA_HASH_MAP_KEY_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIteratorClass))

typedef struct _ValaHashMapKeyIterator ValaHashMapKeyIterator;
typedef struct _ValaHashMapKeyIteratorClass ValaHashMapKeyIteratorClass;
typedef struct _ValaHashMapMapIteratorPrivate ValaHashMapMapIteratorPrivate;
typedef struct _ValaHashMapKeyIteratorPrivate ValaHashMapKeyIteratorPrivate;
typedef struct _ValaHashMapValueCollectionPrivate ValaHashMapValueCollectionPrivate;

#define VALA_HASH_MAP_TYPE_VALUE_ITERATOR (vala_hash_map_value_iterator_get_type ())
#define VALA_HASH_MAP_VALUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIterator))
#define VALA_HASH_MAP_VALUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIteratorClass))
#define VALA_HASH_MAP_IS_VALUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR))
#define VALA_HASH_MAP_IS_VALUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_VALUE_ITERATOR))
#define VALA_HASH_MAP_VALUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIteratorClass))

typedef struct _ValaHashMapValueIterator ValaHashMapValueIterator;
typedef struct _ValaHashMapValueIteratorClass ValaHashMapValueIteratorClass;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
typedef struct _ValaHashMapValueIteratorPrivate ValaHashMapValueIteratorPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaHashMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gint _array_size;
	gint _nnodes;
	ValaHashMapNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
	GHashFunc _key_hash_func;
	GEqualFunc _key_equal_func;
	GEqualFunc _value_equal_func;
};

struct _ValaHashMapNode {
	gpointer key;
	gpointer value;
	ValaHashMapNode* next;
	guint key_hash;
};

struct _ValaHashMapKeySet {
	ValaSet parent_instance;
	ValaHashMapKeySetPrivate * priv;
};

struct _ValaHashMapKeySetClass {
	ValaSetClass parent_class;
};

struct _ValaHashMapKeySetPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
};

struct _ValaHashMapMapIterator {
	ValaMapIterator parent_instance;
	ValaHashMapMapIteratorPrivate * priv;
};

struct _ValaHashMapMapIteratorClass {
	ValaMapIteratorClass parent_class;
};

struct _ValaHashMapMapIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
	gint _index;
	ValaHashMapNode* _node;
	gint _stamp;
};

struct _ValaHashMapKeyIterator {
	ValaIterator parent_instance;
	ValaHashMapKeyIteratorPrivate * priv;
};

struct _ValaHashMapKeyIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashMapKeyIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
	gint _index;
	ValaHashMapNode* _node;
	ValaHashMapNode* _next;
	gint _stamp;
};

struct _ValaHashMapValueCollection {
	ValaCollection parent_instance;
	ValaHashMapValueCollectionPrivate * priv;
};

struct _ValaHashMapValueCollectionClass {
	ValaCollectionClass parent_class;
};

struct _ValaHashMapValueCollectionPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
};

struct _ValaHashMapValueIterator {
	ValaIterator parent_instance;
	ValaHashMapValueIteratorPrivate * priv;
};

struct _ValaHashMapValueIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashMapValueIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
	gint _index;
	ValaHashMapNode* _node;
	ValaHashMapNode* _next;
	gint _stamp;
};

static gint ValaHashMap_private_offset;
static gpointer vala_hash_map_parent_class = NULL;
static gint ValaHashMapKeySet_private_offset;
static gpointer vala_hash_map_key_set_parent_class = NULL;
static gint ValaHashMapMapIterator_private_offset;
static gpointer vala_hash_map_map_iterator_parent_class = NULL;
static gint ValaHashMapKeyIterator_private_offset;
static gpointer vala_hash_map_key_iterator_parent_class = NULL;
static gint ValaHashMapValueCollection_private_offset;
static gpointer vala_hash_map_value_collection_parent_class = NULL;
static gint ValaHashMapValueIterator_private_offset;
static gpointer vala_hash_map_value_iterator_parent_class = NULL;

static void vala_hash_map_node_free (ValaHashMapNode * self);
#define VALA_HASH_MAP_MIN_SIZE 11
#define VALA_HASH_MAP_MAX_SIZE 13845163
static ValaSet* vala_hash_map_real_get_keys (ValaMap* base);
static ValaHashMapKeySet* vala_hash_map_key_set_new (GType k_type,
                                              GBoxedCopyFunc k_dup_func,
                                              GDestroyNotify k_destroy_func,
                                              GType v_type,
                                              GBoxedCopyFunc v_dup_func,
                                              GDestroyNotify v_destroy_func,
                                              ValaHashMap* map);
static ValaHashMapKeySet* vala_hash_map_key_set_construct (GType object_type,
                                                    GType k_type,
                                                    GBoxedCopyFunc k_dup_func,
                                                    GDestroyNotify k_destroy_func,
                                                    GType v_type,
                                                    GBoxedCopyFunc v_dup_func,
                                                    GDestroyNotify v_destroy_func,
                                                    ValaHashMap* map);
static GType vala_hash_map_key_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaCollection* vala_hash_map_real_get_values (ValaMap* base);
static ValaHashMapValueCollection* vala_hash_map_value_collection_new (GType k_type,
                                                                GBoxedCopyFunc k_dup_func,
                                                                GDestroyNotify k_destroy_func,
                                                                GType v_type,
                                                                GBoxedCopyFunc v_dup_func,
                                                                GDestroyNotify v_destroy_func,
                                                                ValaHashMap* map);
static ValaHashMapValueCollection* vala_hash_map_value_collection_construct (GType object_type,
                                                                      GType k_type,
                                                                      GBoxedCopyFunc k_dup_func,
                                                                      GDestroyNotify k_destroy_func,
                                                                      GType v_type,
                                                                      GBoxedCopyFunc v_dup_func,
                                                                      GDestroyNotify v_destroy_func,
                                                                      ValaHashMap* map);
static GType vala_hash_map_value_collection_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaMapIterator* vala_hash_map_real_map_iterator (ValaMap* base);
static ValaHashMapMapIterator* vala_hash_map_map_iterator_new (GType k_type,
                                                        GBoxedCopyFunc k_dup_func,
                                                        GDestroyNotify k_destroy_func,
                                                        GType v_type,
                                                        GBoxedCopyFunc v_dup_func,
                                                        GDestroyNotify v_destroy_func,
                                                        ValaHashMap* map);
static ValaHashMapMapIterator* vala_hash_map_map_iterator_construct (GType object_type,
                                                              GType k_type,
                                                              GBoxedCopyFunc k_dup_func,
                                                              GDestroyNotify k_destroy_func,
                                                              GType v_type,
                                                              GBoxedCopyFunc v_dup_func,
                                                              GDestroyNotify v_destroy_func,
                                                              ValaHashMap* map);
static GType vala_hash_map_map_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaHashMapNode** vala_hash_map_lookup_node (ValaHashMap* self,
                                             gconstpointer key);
static gboolean vala_hash_map_real_contains (ValaMap* base,
                                      gconstpointer key);
static gpointer vala_hash_map_real_get (ValaMap* base,
                                 gconstpointer key);
static void vala_hash_map_real_set (ValaMap* base,
                             gconstpointer key,
                             gconstpointer value);
static ValaHashMapNode* vala_hash_map_node_new (gpointer k,
                                         gpointer v,
                                         guint hash);
static void vala_hash_map_resize (ValaHashMap* self);
static gboolean vala_hash_map_real_remove (ValaMap* base,
                                    gconstpointer key);
static void vala_hash_map_real_clear (ValaMap* base);
static void vala_hash_map_node_instance_init (ValaHashMapNode * self);
static void vala_hash_map_key_set_set_map (ValaHashMapKeySet* self,
                                    ValaHashMap* value);
static GType vala_hash_map_key_set_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_map_key_set_real_iterator (ValaIterable* base);
static ValaHashMapKeyIterator* vala_hash_map_key_iterator_new (GType k_type,
                                                        GBoxedCopyFunc k_dup_func,
                                                        GDestroyNotify k_destroy_func,
                                                        GType v_type,
                                                        GBoxedCopyFunc v_dup_func,
                                                        GDestroyNotify v_destroy_func,
                                                        ValaHashMap* map);
static ValaHashMapKeyIterator* vala_hash_map_key_iterator_construct (GType object_type,
                                                              GType k_type,
                                                              GBoxedCopyFunc k_dup_func,
                                                              GDestroyNotify k_destroy_func,
                                                              GType v_type,
                                                              GBoxedCopyFunc v_dup_func,
                                                              GDestroyNotify v_destroy_func,
                                                              ValaHashMap* map);
static GType vala_hash_map_key_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_map_key_set_real_add (ValaCollection* base,
                                         gconstpointer key);
static void vala_hash_map_key_set_real_clear (ValaCollection* base);
static gboolean vala_hash_map_key_set_real_remove (ValaCollection* base,
                                            gconstpointer key);
static gboolean vala_hash_map_key_set_real_contains (ValaCollection* base,
                                              gconstpointer key);
static void vala_hash_map_key_set_finalize (ValaIterable * obj);
static void vala_hash_map_map_iterator_set_map (ValaHashMapMapIterator* self,
                                         ValaHashMap* value);
static gboolean vala_hash_map_map_iterator_real_next (ValaMapIterator* base);
static gpointer vala_hash_map_map_iterator_real_get_key (ValaMapIterator* base);
static gpointer vala_hash_map_map_iterator_real_get_value (ValaMapIterator* base);
static void vala_hash_map_map_iterator_finalize (ValaMapIterator * obj);
static void vala_hash_map_key_iterator_set_map (ValaHashMapKeyIterator* self,
                                         ValaHashMap* value);
static gboolean vala_hash_map_key_iterator_real_next (ValaIterator* base);
static gboolean vala_hash_map_key_iterator_real_has_next (ValaIterator* base);
static gpointer vala_hash_map_key_iterator_real_get (ValaIterator* base);
static void vala_hash_map_key_iterator_real_remove (ValaIterator* base);
static void vala_hash_map_key_iterator_finalize (ValaIterator * obj);
static void vala_hash_map_value_collection_set_map (ValaHashMapValueCollection* self,
                                             ValaHashMap* value);
static GType vala_hash_map_value_collection_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_map_value_collection_real_iterator (ValaIterable* base);
static ValaHashMapValueIterator* vala_hash_map_value_iterator_new (GType k_type,
                                                            GBoxedCopyFunc k_dup_func,
                                                            GDestroyNotify k_destroy_func,
                                                            GType v_type,
                                                            GBoxedCopyFunc v_dup_func,
                                                            GDestroyNotify v_destroy_func,
                                                            ValaHashMap* map);
static ValaHashMapValueIterator* vala_hash_map_value_iterator_construct (GType object_type,
                                                                  GType k_type,
                                                                  GBoxedCopyFunc k_dup_func,
                                                                  GDestroyNotify k_destroy_func,
                                                                  GType v_type,
                                                                  GBoxedCopyFunc v_dup_func,
                                                                  GDestroyNotify v_destroy_func,
                                                                  ValaHashMap* map);
static GType vala_hash_map_value_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_map_value_collection_real_add (ValaCollection* base,
                                                  gconstpointer value);
static void vala_hash_map_value_collection_real_clear (ValaCollection* base);
static gboolean vala_hash_map_value_collection_real_remove (ValaCollection* base,
                                                     gconstpointer value);
static gboolean vala_hash_map_value_collection_real_contains (ValaCollection* base,
                                                       gconstpointer value);
static void vala_hash_map_value_collection_finalize (ValaIterable * obj);
static void vala_hash_map_value_iterator_set_map (ValaHashMapValueIterator* self,
                                           ValaHashMap* value);
static gboolean vala_hash_map_value_iterator_real_next (ValaIterator* base);
static gboolean vala_hash_map_value_iterator_real_has_next (ValaIterator* base);
static gpointer vala_hash_map_value_iterator_real_get (ValaIterator* base);
static void vala_hash_map_value_iterator_real_remove (ValaIterator* base);
static void vala_hash_map_value_iterator_finalize (ValaIterator * obj);
static void vala_hash_map_finalize (ValaMap * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
vala_hash_map_get_instance_private (ValaHashMap* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMap_private_offset);
}

ValaHashMap*
vala_hash_map_construct (GType object_type,
                         GType k_type,
                         GBoxedCopyFunc k_dup_func,
                         GDestroyNotify k_destroy_func,
                         GType v_type,
                         GBoxedCopyFunc v_dup_func,
                         GDestroyNotify v_destroy_func,
                         GHashFunc key_hash_func,
                         GEqualFunc key_equal_func,
                         GEqualFunc value_equal_func)
{
	ValaHashMap* self = NULL;
	ValaHashMapNode** _tmp0_;
	self = (ValaHashMap*) vala_map_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_set_key_hash_func (self, key_hash_func);
	vala_hash_map_set_key_equal_func (self, key_equal_func);
	vala_hash_map_set_value_equal_func (self, value_equal_func);
	self->priv->_array_size = VALA_HASH_MAP_MIN_SIZE;
	_tmp0_ = g_new0 (ValaHashMapNode*, self->priv->_array_size + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	self->priv->_nodes = _tmp0_;
	self->priv->_nodes_length1 = self->priv->_array_size;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	return self;
}

ValaHashMap*
vala_hash_map_new (GType k_type,
                   GBoxedCopyFunc k_dup_func,
                   GDestroyNotify k_destroy_func,
                   GType v_type,
                   GBoxedCopyFunc v_dup_func,
                   GDestroyNotify v_destroy_func,
                   GHashFunc key_hash_func,
                   GEqualFunc key_equal_func,
                   GEqualFunc value_equal_func)
{
	return vala_hash_map_construct (VALA_TYPE_HASH_MAP, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, key_hash_func, key_equal_func, value_equal_func);
}

static ValaSet*
vala_hash_map_real_get_keys (ValaMap* base)
{
	ValaHashMap * self;
	ValaSet* result = NULL;
	ValaHashMapKeySet* _tmp0_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_key_set_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, (GDestroyNotify) self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, (GDestroyNotify) self->priv->v_destroy_func, self);
	result = (ValaSet*) _tmp0_;
	return result;
}

static ValaCollection*
vala_hash_map_real_get_values (ValaMap* base)
{
	ValaHashMap * self;
	ValaCollection* result = NULL;
	ValaHashMapValueCollection* _tmp0_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_value_collection_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, (GDestroyNotify) self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, (GDestroyNotify) self->priv->v_destroy_func, self);
	result = (ValaCollection*) _tmp0_;
	return result;
}

static ValaMapIterator*
vala_hash_map_real_map_iterator (ValaMap* base)
{
	ValaHashMap * self;
	ValaMapIterator* result = NULL;
	ValaHashMapMapIterator* _tmp0_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_map_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, (GDestroyNotify) self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, (GDestroyNotify) self->priv->v_destroy_func, self);
	result = (ValaMapIterator*) _tmp0_;
	return result;
}

static ValaHashMapNode**
vala_hash_map_lookup_node (ValaHashMap* self,
                           gconstpointer key)
{
	ValaHashMapNode** result = NULL;
	guint hash_value = 0U;
	GHashFunc _tmp0_;
	ValaHashMapNode** node = NULL;
	ValaHashMapNode** _tmp1_;
	gint _tmp1__length1;
	ValaHashMapNode** _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_key_hash_func;
	hash_value = _tmp0_ (key);
	_tmp1_ = self->priv->_nodes;
	_tmp1__length1 = self->priv->_nodes_length1;
	node = &_tmp1_[hash_value % self->priv->_array_size];
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		ValaHashMapNode** _tmp3_;
		ValaHashMapNode** _tmp9_;
		_tmp3_ = node;
		if ((*_tmp3_) != NULL) {
			gboolean _tmp4_ = FALSE;
			ValaHashMapNode** _tmp5_;
			_tmp5_ = node;
			if (hash_value != (*_tmp5_)->key_hash) {
				_tmp4_ = TRUE;
			} else {
				GEqualFunc _tmp6_;
				ValaHashMapNode** _tmp7_;
				gconstpointer _tmp8_;
				_tmp6_ = self->priv->_key_equal_func;
				_tmp7_ = node;
				_tmp8_ = (*_tmp7_)->key;
				_tmp4_ = !_tmp6_ (_tmp8_, key);
			}
			_tmp2_ = _tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp9_ = node;
		node = &(*_tmp9_)->next;
	}
	_tmp10_ = node;
	result = _tmp10_;
	return result;
}

static gboolean
vala_hash_map_real_contains (ValaMap* base,
                             gconstpointer key)
{
	ValaHashMap * self;
	gboolean result = FALSE;
	ValaHashMapNode** node = NULL;
	ValaHashMapNode** _tmp0_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	result = (*node) != NULL;
	return result;
}

static gpointer
vala_hash_map_real_get (ValaMap* base,
                        gconstpointer key)
{
	ValaHashMap * self;
	gpointer result = NULL;
	ValaHashMapNode* node = NULL;
	ValaHashMapNode** _tmp0_;
	ValaHashMapNode* _tmp1_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = *_tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaHashMapNode* _tmp2_;
		gconstpointer _tmp3_;
		gpointer _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->value;
		_tmp4_ = ((_tmp3_ != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
		result = _tmp4_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static void
vala_hash_map_real_set (ValaMap* base,
                        gconstpointer key,
                        gconstpointer value)
{
	ValaHashMap * self;
	ValaHashMapNode** node = NULL;
	ValaHashMapNode** _tmp0_;
	ValaHashMapNode** _tmp1_;
	gint _tmp10_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	_tmp1_ = node;
	if ((*_tmp1_) != NULL) {
		ValaHashMapNode** _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = node;
		_tmp3_ = ((value != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) value) : ((gpointer) value);
		(((*_tmp2_)->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : ((*_tmp2_)->value = (self->priv->v_destroy_func ((*_tmp2_)->value), NULL));
		(*_tmp2_)->value = _tmp3_;
	} else {
		guint hash_value = 0U;
		GHashFunc _tmp4_;
		ValaHashMapNode** _tmp5_;
		gpointer _tmp6_;
		gpointer _tmp7_;
		ValaHashMapNode* _tmp8_;
		gint _tmp9_;
		_tmp4_ = self->priv->_key_hash_func;
		hash_value = _tmp4_ (key);
		_tmp5_ = node;
		_tmp6_ = ((key != NULL) && (self->priv->k_dup_func != NULL)) ? self->priv->k_dup_func ((gpointer) key) : ((gpointer) key);
		_tmp7_ = ((value != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) value) : ((gpointer) value);
		_tmp8_ = vala_hash_map_node_new (_tmp6_, _tmp7_, hash_value);
		*_tmp5_ = _tmp8_;
		_tmp9_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp9_ + 1;
		vala_hash_map_resize (self);
	}
	_tmp10_ = self->priv->_stamp;
	self->priv->_stamp = _tmp10_ + 1;
}

static gboolean
vala_hash_map_real_remove (ValaMap* base,
                           gconstpointer key)
{
	ValaHashMap * self;
	gboolean result = FALSE;
	ValaHashMapNode** node = NULL;
	ValaHashMapNode** _tmp0_;
	ValaHashMapNode** _tmp1_;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	_tmp1_ = node;
	if ((*_tmp1_) != NULL) {
		ValaHashMapNode* next = NULL;
		ValaHashMapNode** _tmp2_;
		ValaHashMapNode* _tmp3_;
		ValaHashMapNode** _tmp4_;
		ValaHashMapNode** _tmp5_;
		ValaHashMapNode** _tmp6_;
		ValaHashMapNode** _tmp7_;
		ValaHashMapNode* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp2_ = node;
		_tmp3_ = (*_tmp2_)->next;
		(*_tmp2_)->next = NULL;
		next = _tmp3_;
		_tmp4_ = node;
		(((*_tmp4_)->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : ((*_tmp4_)->key = (self->priv->k_destroy_func ((*_tmp4_)->key), NULL));
		(*_tmp4_)->key = NULL;
		_tmp5_ = node;
		(((*_tmp5_)->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : ((*_tmp5_)->value = (self->priv->v_destroy_func ((*_tmp5_)->value), NULL));
		(*_tmp5_)->value = NULL;
		_tmp6_ = node;
		vala_hash_map_node_free (*_tmp6_);
		_tmp7_ = node;
		_tmp8_ = next;
		next = NULL;
		*_tmp7_ = _tmp8_;
		_tmp9_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp9_ - 1;
		vala_hash_map_resize (self);
		_tmp10_ = self->priv->_stamp;
		self->priv->_stamp = _tmp10_ + 1;
		result = TRUE;
		_vala_hash_map_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_hash_map_real_clear (ValaMap* base)
{
	ValaHashMap * self;
	self = (ValaHashMap*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaHashMapNode* node = NULL;
				ValaHashMapNode** _tmp2_;
				gint _tmp2__length1;
				ValaHashMapNode* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				_tmp2_ = self->priv->_nodes;
				_tmp2__length1 = self->priv->_nodes_length1;
				_tmp3_ = _tmp2_[i];
				_tmp2_[i] = NULL;
				node = _tmp3_;
				while (TRUE) {
					ValaHashMapNode* _tmp4_;
					ValaHashMapNode* next = NULL;
					ValaHashMapNode* _tmp5_;
					ValaHashMapNode* _tmp6_;
					ValaHashMapNode* _tmp7_;
					ValaHashMapNode* _tmp8_;
					ValaHashMapNode* _tmp9_;
					_tmp4_ = node;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					_tmp5_ = node;
					_tmp6_ = _tmp5_->next;
					_tmp5_->next = NULL;
					next = _tmp6_;
					_tmp7_ = node;
					((_tmp7_->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (_tmp7_->key = (self->priv->k_destroy_func (_tmp7_->key), NULL));
					_tmp7_->key = NULL;
					_tmp8_ = node;
					((_tmp8_->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_tmp8_->value = (self->priv->v_destroy_func (_tmp8_->value), NULL));
					_tmp8_->value = NULL;
					_tmp9_ = next;
					next = NULL;
					_vala_hash_map_node_free0 (node);
					node = _tmp9_;
					_vala_hash_map_node_free0 (next);
				}
				_vala_hash_map_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	vala_hash_map_resize (self);
}

static void
vala_hash_map_resize (ValaHashMap* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_array_size >= (3 * self->priv->_nnodes)) {
		_tmp1_ = self->priv->_array_size >= VALA_HASH_MAP_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((3 * self->priv->_array_size) <= self->priv->_nnodes) {
			_tmp2_ = self->priv->_array_size < VALA_HASH_MAP_MAX_SIZE;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gint new_array_size = 0;
		ValaHashMapNode** new_nodes = NULL;
		ValaHashMapNode** _tmp3_;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		ValaHashMapNode** _tmp19_;
		gint _tmp19__length1;
		new_array_size = (gint) g_spaced_primes_closest ((guint) self->priv->_nnodes);
		new_array_size = CLAMP (new_array_size, VALA_HASH_MAP_MIN_SIZE, VALA_HASH_MAP_MAX_SIZE);
		_tmp3_ = g_new0 (ValaHashMapNode*, new_array_size + 1);
		new_nodes = _tmp3_;
		new_nodes_length1 = new_array_size;
		_new_nodes_size_ = new_nodes_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					ValaHashMapNode* node = NULL;
					ValaHashMapNode* next = NULL;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					if (!(i < self->priv->_array_size)) {
						break;
					}
					next = NULL;
					{
						ValaHashMapNode** _tmp6_;
						gint _tmp6__length1;
						ValaHashMapNode* _tmp7_;
						gboolean _tmp8_ = FALSE;
						_tmp6_ = self->priv->_nodes;
						_tmp6__length1 = self->priv->_nodes_length1;
						_tmp7_ = _tmp6_[i];
						_tmp6_[i] = NULL;
						_vala_hash_map_node_free0 (node);
						node = _tmp7_;
						_tmp8_ = TRUE;
						while (TRUE) {
							ValaHashMapNode* _tmp10_;
							ValaHashMapNode* _tmp11_;
							ValaHashMapNode* _tmp12_;
							guint hash_val = 0U;
							ValaHashMapNode* _tmp13_;
							ValaHashMapNode* _tmp14_;
							ValaHashMapNode** _tmp15_;
							gint _tmp15__length1;
							ValaHashMapNode* _tmp16_;
							ValaHashMapNode** _tmp17_;
							gint _tmp17__length1;
							ValaHashMapNode* _tmp18_;
							if (!_tmp8_) {
								ValaHashMapNode* _tmp9_;
								_tmp9_ = next;
								next = NULL;
								_vala_hash_map_node_free0 (node);
								node = _tmp9_;
							}
							_tmp8_ = FALSE;
							_tmp10_ = node;
							if (!(_tmp10_ != NULL)) {
								break;
							}
							_tmp11_ = node;
							_tmp12_ = _tmp11_->next;
							_tmp11_->next = NULL;
							_vala_hash_map_node_free0 (next);
							next = _tmp12_;
							_tmp13_ = node;
							hash_val = _tmp13_->key_hash % new_array_size;
							_tmp14_ = node;
							_tmp15_ = new_nodes;
							_tmp15__length1 = new_nodes_length1;
							_tmp16_ = _tmp15_[hash_val];
							_tmp15_[hash_val] = NULL;
							_vala_hash_map_node_free0 (_tmp14_->next);
							_tmp14_->next = _tmp16_;
							_tmp17_ = new_nodes;
							_tmp17__length1 = new_nodes_length1;
							_tmp18_ = node;
							node = NULL;
							_vala_hash_map_node_free0 (_tmp17_[hash_val]);
							_tmp17_[hash_val] = _tmp18_;
						}
					}
					_vala_hash_map_node_free0 (next);
					_vala_hash_map_node_free0 (node);
				}
			}
		}
		_tmp19_ = new_nodes;
		_tmp19__length1 = new_nodes_length1;
		new_nodes = NULL;
		new_nodes_length1 = 0;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
		self->priv->_nodes = _tmp19_;
		self->priv->_nodes_length1 = _tmp19__length1;
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
		self->priv->_array_size = new_array_size;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	}
}

static gint
vala_hash_map_real_get_size (ValaMap* base)
{
	gint result;
	ValaHashMap* self;
	self = (ValaHashMap*) base;
	result = self->priv->_nnodes;
	return result;
}

void
vala_hash_map_set_key_hash_func (ValaHashMap* self,
                                 GHashFunc value)
{
	g_return_if_fail (self != NULL);
	self->priv->_key_hash_func = value;
}

void
vala_hash_map_set_key_equal_func (ValaHashMap* self,
                                  GEqualFunc value)
{
	g_return_if_fail (self != NULL);
	self->priv->_key_equal_func = value;
}

void
vala_hash_map_set_value_equal_func (ValaHashMap* self,
                                    GEqualFunc value)
{
	g_return_if_fail (self != NULL);
	self->priv->_value_equal_func = value;
}

static ValaHashMapNode*
vala_hash_map_node_new (gpointer k,
                        gpointer v,
                        guint hash)
{
	ValaHashMapNode* self;
	gpointer _tmp0_;
	gpointer _tmp1_;
	self = g_slice_new0 (ValaHashMapNode);
	vala_hash_map_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	_tmp1_ = v;
	v = NULL;
	self->value = _tmp1_;
	self->key_hash = hash;
	return self;
}

static void
vala_hash_map_node_instance_init (ValaHashMapNode * self)
{
}

static void
vala_hash_map_node_free (ValaHashMapNode * self)
{
	_vala_hash_map_node_free0 (self->next);
	g_slice_free (ValaHashMapNode, self);
}

static inline gpointer
vala_hash_map_key_set_get_instance_private (ValaHashMapKeySet* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMapKeySet_private_offset);
}

static ValaHashMapKeySet*
vala_hash_map_key_set_construct (GType object_type,
                                 GType k_type,
                                 GBoxedCopyFunc k_dup_func,
                                 GDestroyNotify k_destroy_func,
                                 GType v_type,
                                 GBoxedCopyFunc v_dup_func,
                                 GDestroyNotify v_destroy_func,
                                 ValaHashMap* map)
{
	ValaHashMapKeySet* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapKeySet*) vala_set_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_key_set_set_map (self, map);
	return self;
}

static ValaHashMapKeySet*
vala_hash_map_key_set_new (GType k_type,
                           GBoxedCopyFunc k_dup_func,
                           GDestroyNotify k_destroy_func,
                           GType v_type,
                           GBoxedCopyFunc v_dup_func,
                           GDestroyNotify v_destroy_func,
                           ValaHashMap* map)
{
	return vala_hash_map_key_set_construct (VALA_HASH_MAP_TYPE_KEY_SET, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}

static GType
vala_hash_map_key_set_real_get_element_type (ValaIterable* base)
{
	ValaHashMapKeySet * self;
	GType result = 0UL;
	self = (ValaHashMapKeySet*) base;
	result = self->priv->k_type;
	return result;
}

static ValaIterator*
vala_hash_map_key_set_real_iterator (ValaIterable* base)
{
	ValaHashMapKeySet * self;
	ValaIterator* result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapKeyIterator* _tmp1_;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = self->priv->_map;
	_tmp1_ = vala_hash_map_key_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, (GDestroyNotify) self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, (GDestroyNotify) self->priv->v_destroy_func, _tmp0_);
	result = (ValaIterator*) _tmp1_;
	return result;
}

static gboolean
vala_hash_map_key_set_real_add (ValaCollection* base,
                                gconstpointer key)
{
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
	return result;
}

static void
vala_hash_map_key_set_real_clear (ValaCollection* base)
{
	ValaHashMapKeySet * self;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
}

static gboolean
vala_hash_map_key_set_real_remove (ValaCollection* base,
                                   gconstpointer key)
{
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
	return result;
}

static gboolean
vala_hash_map_key_set_real_contains (ValaCollection* base,
                                     gconstpointer key)
{
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	ValaHashMap* _tmp0_;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = self->priv->_map;
	result = vala_map_contains ((ValaMap*) _tmp0_, key);
	return result;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static void
vala_hash_map_key_set_set_map (ValaHashMapKeySet* self,
                               ValaHashMap* value)
{
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
}

static gint
vala_hash_map_key_set_real_get_size (ValaCollection* base)
{
	gint result;
	ValaHashMapKeySet* self;
	ValaHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = self->priv->_map;
	_tmp1_ = vala_map_get_size ((ValaMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_hash_map_key_set_class_init (ValaHashMapKeySetClass * klass)
{
	vala_hash_map_key_set_parent_class = g_type_class_peek_parent (klass);
	((ValaIterableClass *) klass)->finalize = vala_hash_map_key_set_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMapKeySet_private_offset);
	((ValaIterableClass *) klass)->get_element_type = (GType (*) (ValaIterable*)) vala_hash_map_key_set_real_get_element_type;
	((ValaIterableClass *) klass)->iterator = (ValaIterator* (*) (ValaIterable*)) vala_hash_map_key_set_real_iterator;
	((ValaCollectionClass *) klass)->add = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_key_set_real_add;
	((ValaCollectionClass *) klass)->clear = (void (*) (ValaCollection*)) vala_hash_map_key_set_real_clear;
	((ValaCollectionClass *) klass)->remove = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_key_set_real_remove;
	((ValaCollectionClass *) klass)->contains = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_key_set_real_contains;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_map_key_set_real_get_size;
}

static void
vala_hash_map_key_set_instance_init (ValaHashMapKeySet * self)
{
	self->priv = vala_hash_map_key_set_get_instance_private (self);
}

static void
vala_hash_map_key_set_finalize (ValaIterable * obj)
{
	ValaHashMapKeySet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySet);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERABLE_CLASS (vala_hash_map_key_set_parent_class)->finalize (obj);
}

static GType
vala_hash_map_key_set_get_type (void)
{
	static volatile gsize vala_hash_map_key_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_key_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapKeySetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_key_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapKeySet), 0, (GInstanceInitFunc) vala_hash_map_key_set_instance_init, NULL };
		GType vala_hash_map_key_set_type_id;
		vala_hash_map_key_set_type_id = g_type_register_static (VALA_TYPE_SET, "ValaHashMapKeySet", &g_define_type_info, 0);
		ValaHashMapKeySet_private_offset = g_type_add_instance_private (vala_hash_map_key_set_type_id, sizeof (ValaHashMapKeySetPrivate));
		g_once_init_leave (&vala_hash_map_key_set_type_id__volatile, vala_hash_map_key_set_type_id);
	}
	return vala_hash_map_key_set_type_id__volatile;
}

static inline gpointer
vala_hash_map_map_iterator_get_instance_private (ValaHashMapMapIterator* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMapMapIterator_private_offset);
}

static ValaHashMapMapIterator*
vala_hash_map_map_iterator_construct (GType object_type,
                                      GType k_type,
                                      GBoxedCopyFunc k_dup_func,
                                      GDestroyNotify k_destroy_func,
                                      GType v_type,
                                      GBoxedCopyFunc v_dup_func,
                                      GDestroyNotify v_destroy_func,
                                      ValaHashMap* map)
{
	ValaHashMapMapIterator* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapMapIterator*) vala_map_iterator_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_map_iterator_set_map (self, map);
	return self;
}

static ValaHashMapMapIterator*
vala_hash_map_map_iterator_new (GType k_type,
                                GBoxedCopyFunc k_dup_func,
                                GDestroyNotify k_destroy_func,
                                GType v_type,
                                GBoxedCopyFunc v_dup_func,
                                GDestroyNotify v_destroy_func,
                                ValaHashMap* map)
{
	return vala_hash_map_map_iterator_construct (VALA_HASH_MAP_TYPE_MAP_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}

static gboolean
vala_hash_map_map_iterator_real_next (ValaMapIterator* base)
{
	ValaHashMapMapIterator * self;
	gboolean result = FALSE;
	ValaHashMapNode* _tmp0_;
	ValaHashMapNode* _tmp10_;
	self = (ValaHashMapMapIterator*) base;
	_tmp0_ = self->priv->_node;
	if (_tmp0_ != NULL) {
		ValaHashMapNode* _tmp1_;
		ValaHashMapNode* _tmp2_;
		_tmp1_ = self->priv->_node;
		_tmp2_ = _tmp1_->next;
		self->priv->_node = _tmp2_;
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		ValaHashMapNode* _tmp4_;
		gint _tmp6_;
		ValaHashMap* _tmp7_;
		ValaHashMapNode** _tmp8_;
		gint _tmp8__length1;
		ValaHashMapNode* _tmp9_;
		_tmp4_ = self->priv->_node;
		if (_tmp4_ == NULL) {
			ValaHashMap* _tmp5_;
			_tmp5_ = self->priv->_map;
			_tmp3_ = (self->priv->_index + 1) < _tmp5_->priv->_array_size;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = self->priv->_index;
		self->priv->_index = _tmp6_ + 1;
		_tmp7_ = self->priv->_map;
		_tmp8_ = _tmp7_->priv->_nodes;
		_tmp8__length1 = _tmp7_->priv->_nodes_length1;
		_tmp9_ = _tmp8_[self->priv->_index];
		self->priv->_node = _tmp9_;
	}
	_tmp10_ = self->priv->_node;
	result = _tmp10_ != NULL;
	return result;
}

static gpointer
vala_hash_map_map_iterator_real_get_key (ValaMapIterator* base)
{
	ValaHashMapMapIterator * self;
	gpointer result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	self = (ValaHashMapMapIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	_tmp2_ = self->priv->_node;
	_tmp3_ = _tmp2_->key;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->k_dup_func != NULL)) ? self->priv->k_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static gpointer
vala_hash_map_map_iterator_real_get_value (ValaMapIterator* base)
{
	ValaHashMapMapIterator * self;
	gpointer result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	self = (ValaHashMapMapIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	_tmp2_ = self->priv->_node;
	_tmp3_ = _tmp2_->value;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_hash_map_map_iterator_set_map (ValaHashMapMapIterator* self,
                                    ValaHashMap* value)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	_tmp1_ = self->priv->_map;
	self->priv->_stamp = _tmp1_->priv->_stamp;
}

static void
vala_hash_map_map_iterator_class_init (ValaHashMapMapIteratorClass * klass)
{
	vala_hash_map_map_iterator_parent_class = g_type_class_peek_parent (klass);
	((ValaMapIteratorClass *) klass)->finalize = vala_hash_map_map_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMapMapIterator_private_offset);
	((ValaMapIteratorClass *) klass)->next = (gboolean (*) (ValaMapIterator*)) vala_hash_map_map_iterator_real_next;
	((ValaMapIteratorClass *) klass)->get_key = (gpointer (*) (ValaMapIterator*)) vala_hash_map_map_iterator_real_get_key;
	((ValaMapIteratorClass *) klass)->get_value = (gpointer (*) (ValaMapIterator*)) vala_hash_map_map_iterator_real_get_value;
}

static void
vala_hash_map_map_iterator_instance_init (ValaHashMapMapIterator * self)
{
	self->priv = vala_hash_map_map_iterator_get_instance_private (self);
	self->priv->_index = -1;
}

static void
vala_hash_map_map_iterator_finalize (ValaMapIterator * obj)
{
	ValaHashMapMapIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_MAP_TYPE_MAP_ITERATOR, ValaHashMapMapIterator);
	_vala_map_unref0 (self->priv->_map);
	VALA_MAP_ITERATOR_CLASS (vala_hash_map_map_iterator_parent_class)->finalize (obj);
}

static GType
vala_hash_map_map_iterator_get_type (void)
{
	static volatile gsize vala_hash_map_map_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_map_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapMapIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_map_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapMapIterator), 0, (GInstanceInitFunc) vala_hash_map_map_iterator_instance_init, NULL };
		GType vala_hash_map_map_iterator_type_id;
		vala_hash_map_map_iterator_type_id = g_type_register_static (VALA_TYPE_MAP_ITERATOR, "ValaHashMapMapIterator", &g_define_type_info, 0);
		ValaHashMapMapIterator_private_offset = g_type_add_instance_private (vala_hash_map_map_iterator_type_id, sizeof (ValaHashMapMapIteratorPrivate));
		g_once_init_leave (&vala_hash_map_map_iterator_type_id__volatile, vala_hash_map_map_iterator_type_id);
	}
	return vala_hash_map_map_iterator_type_id__volatile;
}

static inline gpointer
vala_hash_map_key_iterator_get_instance_private (ValaHashMapKeyIterator* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMapKeyIterator_private_offset);
}

static ValaHashMapKeyIterator*
vala_hash_map_key_iterator_construct (GType object_type,
                                      GType k_type,
                                      GBoxedCopyFunc k_dup_func,
                                      GDestroyNotify k_destroy_func,
                                      GType v_type,
                                      GBoxedCopyFunc v_dup_func,
                                      GDestroyNotify v_destroy_func,
                                      ValaHashMap* map)
{
	ValaHashMapKeyIterator* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapKeyIterator*) vala_iterator_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_key_iterator_set_map (self, map);
	return self;
}

static ValaHashMapKeyIterator*
vala_hash_map_key_iterator_new (GType k_type,
                                GBoxedCopyFunc k_dup_func,
                                GDestroyNotify k_destroy_func,
                                GType v_type,
                                GBoxedCopyFunc v_dup_func,
                                GDestroyNotify v_destroy_func,
                                ValaHashMap* map)
{
	return vala_hash_map_key_iterator_construct (VALA_HASH_MAP_TYPE_KEY_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}

static gboolean
vala_hash_map_key_iterator_real_next (ValaIterator* base)
{
	ValaHashMapKeyIterator * self;
	gboolean result = FALSE;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	self = (ValaHashMapKeyIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	if (!vala_iterator_has_next ((ValaIterator*) self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_next;
	self->priv->_node = _tmp1_;
	self->priv->_next = NULL;
	_tmp2_ = self->priv->_node;
	result = _tmp2_ != NULL;
	return result;
}

static gboolean
vala_hash_map_key_iterator_real_has_next (ValaIterator* base)
{
	ValaHashMapKeyIterator * self;
	gboolean result = FALSE;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp13_;
	self = (ValaHashMapKeyIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_next;
	if (_tmp1_ == NULL) {
		ValaHashMapNode* _tmp2_;
		ValaHashMapNode* _tmp3_;
		_tmp2_ = self->priv->_node;
		self->priv->_next = _tmp2_;
		_tmp3_ = self->priv->_next;
		if (_tmp3_ != NULL) {
			ValaHashMapNode* _tmp4_;
			ValaHashMapNode* _tmp5_;
			_tmp4_ = self->priv->_next;
			_tmp5_ = _tmp4_->next;
			self->priv->_next = _tmp5_;
		}
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			ValaHashMapNode* _tmp7_;
			gint _tmp9_;
			ValaHashMap* _tmp10_;
			ValaHashMapNode** _tmp11_;
			gint _tmp11__length1;
			ValaHashMapNode* _tmp12_;
			_tmp7_ = self->priv->_next;
			if (_tmp7_ == NULL) {
				ValaHashMap* _tmp8_;
				_tmp8_ = self->priv->_map;
				_tmp6_ = (self->priv->_index + 1) < _tmp8_->priv->_array_size;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp9_ = self->priv->_index;
			self->priv->_index = _tmp9_ + 1;
			_tmp10_ = self->priv->_map;
			_tmp11_ = _tmp10_->priv->_nodes;
			_tmp11__length1 = _tmp10_->priv->_nodes_length1;
			_tmp12_ = _tmp11_[self->priv->_index];
			self->priv->_next = _tmp12_;
		}
	}
	_tmp13_ = self->priv->_next;
	result = _tmp13_ != NULL;
	return result;
}

static gpointer
vala_hash_map_key_iterator_real_get (ValaIterator* base)
{
	ValaHashMapKeyIterator * self;
	gpointer result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	self = (ValaHashMapKeyIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	_tmp2_ = self->priv->_node;
	_tmp3_ = _tmp2_->key;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->k_dup_func != NULL)) ? self->priv->k_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_hash_map_key_iterator_real_remove (ValaIterator* base)
{
	ValaHashMapKeyIterator * self;
	self = (ValaHashMapKeyIterator*) base;
	g_assert_not_reached ();
}

static void
vala_hash_map_key_iterator_set_map (ValaHashMapKeyIterator* self,
                                    ValaHashMap* value)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	_tmp1_ = self->priv->_map;
	self->priv->_stamp = _tmp1_->priv->_stamp;
}

static gboolean
vala_hash_map_key_iterator_real_get_valid (ValaIterator* base)
{
	gboolean result;
	ValaHashMapKeyIterator* self;
	ValaHashMapNode* _tmp0_;
	self = (ValaHashMapKeyIterator*) base;
	_tmp0_ = self->priv->_node;
	result = _tmp0_ != NULL;
	return result;
}

static void
vala_hash_map_key_iterator_class_init (ValaHashMapKeyIteratorClass * klass)
{
	vala_hash_map_key_iterator_parent_class = g_type_class_peek_parent (klass);
	((ValaIteratorClass *) klass)->finalize = vala_hash_map_key_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMapKeyIterator_private_offset);
	((ValaIteratorClass *) klass)->next = (gboolean (*) (ValaIterator*)) vala_hash_map_key_iterator_real_next;
	((ValaIteratorClass *) klass)->has_next = (gboolean (*) (ValaIterator*)) vala_hash_map_key_iterator_real_has_next;
	((ValaIteratorClass *) klass)->get = (gpointer (*) (ValaIterator*)) vala_hash_map_key_iterator_real_get;
	((ValaIteratorClass *) klass)->remove = (void (*) (ValaIterator*)) vala_hash_map_key_iterator_real_remove;
	VALA_ITERATOR_CLASS (klass)->get_valid = vala_hash_map_key_iterator_real_get_valid;
}

static void
vala_hash_map_key_iterator_instance_init (ValaHashMapKeyIterator * self)
{
	self->priv = vala_hash_map_key_iterator_get_instance_private (self);
	self->priv->_index = -1;
}

static void
vala_hash_map_key_iterator_finalize (ValaIterator * obj)
{
	ValaHashMapKeyIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIterator);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERATOR_CLASS (vala_hash_map_key_iterator_parent_class)->finalize (obj);
}

static GType
vala_hash_map_key_iterator_get_type (void)
{
	static volatile gsize vala_hash_map_key_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_key_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapKeyIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_key_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapKeyIterator), 0, (GInstanceInitFunc) vala_hash_map_key_iterator_instance_init, NULL };
		GType vala_hash_map_key_iterator_type_id;
		vala_hash_map_key_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashMapKeyIterator", &g_define_type_info, 0);
		ValaHashMapKeyIterator_private_offset = g_type_add_instance_private (vala_hash_map_key_iterator_type_id, sizeof (ValaHashMapKeyIteratorPrivate));
		g_once_init_leave (&vala_hash_map_key_iterator_type_id__volatile, vala_hash_map_key_iterator_type_id);
	}
	return vala_hash_map_key_iterator_type_id__volatile;
}

static inline gpointer
vala_hash_map_value_collection_get_instance_private (ValaHashMapValueCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMapValueCollection_private_offset);
}

static ValaHashMapValueCollection*
vala_hash_map_value_collection_construct (GType object_type,
                                          GType k_type,
                                          GBoxedCopyFunc k_dup_func,
                                          GDestroyNotify k_destroy_func,
                                          GType v_type,
                                          GBoxedCopyFunc v_dup_func,
                                          GDestroyNotify v_destroy_func,
                                          ValaHashMap* map)
{
	ValaHashMapValueCollection* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapValueCollection*) vala_collection_construct (object_type, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_value_collection_set_map (self, map);
	return self;
}

static ValaHashMapValueCollection*
vala_hash_map_value_collection_new (GType k_type,
                                    GBoxedCopyFunc k_dup_func,
                                    GDestroyNotify k_destroy_func,
                                    GType v_type,
                                    GBoxedCopyFunc v_dup_func,
                                    GDestroyNotify v_destroy_func,
                                    ValaHashMap* map)
{
	return vala_hash_map_value_collection_construct (VALA_HASH_MAP_TYPE_VALUE_COLLECTION, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}

static GType
vala_hash_map_value_collection_real_get_element_type (ValaIterable* base)
{
	ValaHashMapValueCollection * self;
	GType result = 0UL;
	self = (ValaHashMapValueCollection*) base;
	result = self->priv->v_type;
	return result;
}

static ValaIterator*
vala_hash_map_value_collection_real_iterator (ValaIterable* base)
{
	ValaHashMapValueCollection * self;
	ValaIterator* result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapValueIterator* _tmp1_;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = self->priv->_map;
	_tmp1_ = vala_hash_map_value_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, (GDestroyNotify) self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, (GDestroyNotify) self->priv->v_destroy_func, _tmp0_);
	result = (ValaIterator*) _tmp1_;
	return result;
}

static gboolean
vala_hash_map_value_collection_real_add (ValaCollection* base,
                                         gconstpointer value)
{
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
	return result;
}

static void
vala_hash_map_value_collection_real_clear (ValaCollection* base)
{
	ValaHashMapValueCollection * self;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
}

static gboolean
vala_hash_map_value_collection_real_remove (ValaCollection* base,
                                            gconstpointer value)
{
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
	return result;
}

static gboolean
vala_hash_map_value_collection_real_contains (ValaCollection* base,
                                              gconstpointer value)
{
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	ValaIterator* it = NULL;
	ValaIterator* _tmp0_;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = vala_iterable_iterator ((ValaIterable*) self);
	it = _tmp0_;
	while (TRUE) {
		ValaIterator* _tmp1_;
		ValaHashMap* _tmp2_;
		GEqualFunc _tmp3_;
		ValaIterator* _tmp4_;
		gpointer _tmp5_;
		gpointer _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = it;
		if (!vala_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = self->priv->_map;
		_tmp3_ = _tmp2_->priv->_value_equal_func;
		_tmp4_ = it;
		_tmp5_ = vala_iterator_get (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp3_ (_tmp6_, value);
		((_tmp6_ == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_tmp6_ = (self->priv->v_destroy_func (_tmp6_), NULL));
		if (_tmp7_) {
			result = TRUE;
			_vala_iterator_unref0 (it);
			return result;
		}
	}
	result = FALSE;
	_vala_iterator_unref0 (it);
	return result;
}

static void
vala_hash_map_value_collection_set_map (ValaHashMapValueCollection* self,
                                        ValaHashMap* value)
{
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
}

static gint
vala_hash_map_value_collection_real_get_size (ValaCollection* base)
{
	gint result;
	ValaHashMapValueCollection* self;
	ValaHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = self->priv->_map;
	_tmp1_ = vala_map_get_size ((ValaMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
vala_hash_map_value_collection_class_init (ValaHashMapValueCollectionClass * klass)
{
	vala_hash_map_value_collection_parent_class = g_type_class_peek_parent (klass);
	((ValaIterableClass *) klass)->finalize = vala_hash_map_value_collection_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMapValueCollection_private_offset);
	((ValaIterableClass *) klass)->get_element_type = (GType (*) (ValaIterable*)) vala_hash_map_value_collection_real_get_element_type;
	((ValaIterableClass *) klass)->iterator = (ValaIterator* (*) (ValaIterable*)) vala_hash_map_value_collection_real_iterator;
	((ValaCollectionClass *) klass)->add = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_value_collection_real_add;
	((ValaCollectionClass *) klass)->clear = (void (*) (ValaCollection*)) vala_hash_map_value_collection_real_clear;
	((ValaCollectionClass *) klass)->remove = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_value_collection_real_remove;
	((ValaCollectionClass *) klass)->contains = (gboolean (*) (ValaCollection*, gconstpointer)) vala_hash_map_value_collection_real_contains;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_map_value_collection_real_get_size;
}

static void
vala_hash_map_value_collection_instance_init (ValaHashMapValueCollection * self)
{
	self->priv = vala_hash_map_value_collection_get_instance_private (self);
}

static void
vala_hash_map_value_collection_finalize (ValaIterable * obj)
{
	ValaHashMapValueCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollection);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERABLE_CLASS (vala_hash_map_value_collection_parent_class)->finalize (obj);
}

static GType
vala_hash_map_value_collection_get_type (void)
{
	static volatile gsize vala_hash_map_value_collection_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_value_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapValueCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_value_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapValueCollection), 0, (GInstanceInitFunc) vala_hash_map_value_collection_instance_init, NULL };
		GType vala_hash_map_value_collection_type_id;
		vala_hash_map_value_collection_type_id = g_type_register_static (VALA_TYPE_COLLECTION, "ValaHashMapValueCollection", &g_define_type_info, 0);
		ValaHashMapValueCollection_private_offset = g_type_add_instance_private (vala_hash_map_value_collection_type_id, sizeof (ValaHashMapValueCollectionPrivate));
		g_once_init_leave (&vala_hash_map_value_collection_type_id__volatile, vala_hash_map_value_collection_type_id);
	}
	return vala_hash_map_value_collection_type_id__volatile;
}

static inline gpointer
vala_hash_map_value_iterator_get_instance_private (ValaHashMapValueIterator* self)
{
	return G_STRUCT_MEMBER_P (self, ValaHashMapValueIterator_private_offset);
}

static ValaHashMapValueIterator*
vala_hash_map_value_iterator_construct (GType object_type,
                                        GType k_type,
                                        GBoxedCopyFunc k_dup_func,
                                        GDestroyNotify k_destroy_func,
                                        GType v_type,
                                        GBoxedCopyFunc v_dup_func,
                                        GDestroyNotify v_destroy_func,
                                        ValaHashMap* map)
{
	ValaHashMapValueIterator* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapValueIterator*) vala_iterator_construct (object_type, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_value_iterator_set_map (self, map);
	return self;
}

static ValaHashMapValueIterator*
vala_hash_map_value_iterator_new (GType k_type,
                                  GBoxedCopyFunc k_dup_func,
                                  GDestroyNotify k_destroy_func,
                                  GType v_type,
                                  GBoxedCopyFunc v_dup_func,
                                  GDestroyNotify v_destroy_func,
                                  ValaHashMap* map)
{
	return vala_hash_map_value_iterator_construct (VALA_HASH_MAP_TYPE_VALUE_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}

static gboolean
vala_hash_map_value_iterator_real_next (ValaIterator* base)
{
	ValaHashMapValueIterator * self;
	gboolean result = FALSE;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	self = (ValaHashMapValueIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	if (!vala_iterator_has_next ((ValaIterator*) self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_next;
	self->priv->_node = _tmp1_;
	self->priv->_next = NULL;
	_tmp2_ = self->priv->_node;
	result = _tmp2_ != NULL;
	return result;
}

static gboolean
vala_hash_map_value_iterator_real_has_next (ValaIterator* base)
{
	ValaHashMapValueIterator * self;
	gboolean result = FALSE;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp13_;
	self = (ValaHashMapValueIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_next;
	if (_tmp1_ == NULL) {
		ValaHashMapNode* _tmp2_;
		ValaHashMapNode* _tmp3_;
		_tmp2_ = self->priv->_node;
		self->priv->_next = _tmp2_;
		_tmp3_ = self->priv->_next;
		if (_tmp3_ != NULL) {
			ValaHashMapNode* _tmp4_;
			ValaHashMapNode* _tmp5_;
			_tmp4_ = self->priv->_next;
			_tmp5_ = _tmp4_->next;
			self->priv->_next = _tmp5_;
		}
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			ValaHashMapNode* _tmp7_;
			gint _tmp9_;
			ValaHashMap* _tmp10_;
			ValaHashMapNode** _tmp11_;
			gint _tmp11__length1;
			ValaHashMapNode* _tmp12_;
			_tmp7_ = self->priv->_next;
			if (_tmp7_ == NULL) {
				ValaHashMap* _tmp8_;
				_tmp8_ = self->priv->_map;
				_tmp6_ = (self->priv->_index + 1) < _tmp8_->priv->_array_size;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			_tmp9_ = self->priv->_index;
			self->priv->_index = _tmp9_ + 1;
			_tmp10_ = self->priv->_map;
			_tmp11_ = _tmp10_->priv->_nodes;
			_tmp11__length1 = _tmp10_->priv->_nodes_length1;
			_tmp12_ = _tmp11_[self->priv->_index];
			self->priv->_next = _tmp12_;
		}
	}
	_tmp13_ = self->priv->_next;
	result = _tmp13_ != NULL;
	return result;
}

static gpointer
vala_hash_map_value_iterator_real_get (ValaIterator* base)
{
	ValaHashMapValueIterator * self;
	gpointer result = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMapNode* _tmp1_;
	ValaHashMapNode* _tmp2_;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	self = (ValaHashMapValueIterator*) base;
	_tmp0_ = self->priv->_map;
	_vala_assert (self->priv->_stamp == _tmp0_->priv->_stamp, "_stamp == _map._stamp");
	_tmp1_ = self->priv->_node;
	_vala_assert (_tmp1_ != NULL, "_node != null");
	_tmp2_ = self->priv->_node;
	_tmp3_ = _tmp2_->value;
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->v_dup_func != NULL)) ? self->priv->v_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_hash_map_value_iterator_real_remove (ValaIterator* base)
{
	ValaHashMapValueIterator * self;
	self = (ValaHashMapValueIterator*) base;
	g_assert_not_reached ();
}

static void
vala_hash_map_value_iterator_set_map (ValaHashMapValueIterator* self,
                                      ValaHashMap* value)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	_tmp1_ = self->priv->_map;
	self->priv->_stamp = _tmp1_->priv->_stamp;
}

static gboolean
vala_hash_map_value_iterator_real_get_valid (ValaIterator* base)
{
	gboolean result;
	ValaHashMapValueIterator* self;
	ValaHashMapNode* _tmp0_;
	self = (ValaHashMapValueIterator*) base;
	_tmp0_ = self->priv->_node;
	result = _tmp0_ != NULL;
	return result;
}

static void
vala_hash_map_value_iterator_class_init (ValaHashMapValueIteratorClass * klass)
{
	vala_hash_map_value_iterator_parent_class = g_type_class_peek_parent (klass);
	((ValaIteratorClass *) klass)->finalize = vala_hash_map_value_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMapValueIterator_private_offset);
	((ValaIteratorClass *) klass)->next = (gboolean (*) (ValaIterator*)) vala_hash_map_value_iterator_real_next;
	((ValaIteratorClass *) klass)->has_next = (gboolean (*) (ValaIterator*)) vala_hash_map_value_iterator_real_has_next;
	((ValaIteratorClass *) klass)->get = (gpointer (*) (ValaIterator*)) vala_hash_map_value_iterator_real_get;
	((ValaIteratorClass *) klass)->remove = (void (*) (ValaIterator*)) vala_hash_map_value_iterator_real_remove;
	VALA_ITERATOR_CLASS (klass)->get_valid = vala_hash_map_value_iterator_real_get_valid;
}

static void
vala_hash_map_value_iterator_instance_init (ValaHashMapValueIterator * self)
{
	self->priv = vala_hash_map_value_iterator_get_instance_private (self);
	self->priv->_index = -1;
}

static void
vala_hash_map_value_iterator_finalize (ValaIterator * obj)
{
	ValaHashMapValueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIterator);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERATOR_CLASS (vala_hash_map_value_iterator_parent_class)->finalize (obj);
}

static GType
vala_hash_map_value_iterator_get_type (void)
{
	static volatile gsize vala_hash_map_value_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_value_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapValueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_value_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapValueIterator), 0, (GInstanceInitFunc) vala_hash_map_value_iterator_instance_init, NULL };
		GType vala_hash_map_value_iterator_type_id;
		vala_hash_map_value_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashMapValueIterator", &g_define_type_info, 0);
		ValaHashMapValueIterator_private_offset = g_type_add_instance_private (vala_hash_map_value_iterator_type_id, sizeof (ValaHashMapValueIteratorPrivate));
		g_once_init_leave (&vala_hash_map_value_iterator_type_id__volatile, vala_hash_map_value_iterator_type_id);
	}
	return vala_hash_map_value_iterator_type_id__volatile;
}

static void
vala_hash_map_class_init (ValaHashMapClass * klass)
{
	vala_hash_map_parent_class = g_type_class_peek_parent (klass);
	((ValaMapClass *) klass)->finalize = vala_hash_map_finalize;
	g_type_class_adjust_private_offset (klass, &ValaHashMap_private_offset);
	((ValaMapClass *) klass)->get_keys = (ValaSet* (*) (ValaMap*)) vala_hash_map_real_get_keys;
	((ValaMapClass *) klass)->get_values = (ValaCollection* (*) (ValaMap*)) vala_hash_map_real_get_values;
	((ValaMapClass *) klass)->map_iterator = (ValaMapIterator* (*) (ValaMap*)) vala_hash_map_real_map_iterator;
	((ValaMapClass *) klass)->contains = (gboolean (*) (ValaMap*, gconstpointer)) vala_hash_map_real_contains;
	((ValaMapClass *) klass)->get = (gpointer (*) (ValaMap*, gconstpointer)) vala_hash_map_real_get;
	((ValaMapClass *) klass)->set = (void (*) (ValaMap*, gconstpointer, gconstpointer)) vala_hash_map_real_set;
	((ValaMapClass *) klass)->remove = (gboolean (*) (ValaMap*, gconstpointer)) vala_hash_map_real_remove;
	((ValaMapClass *) klass)->clear = (void (*) (ValaMap*)) vala_hash_map_real_clear;
	VALA_MAP_CLASS (klass)->get_size = vala_hash_map_real_get_size;
}

static void
vala_hash_map_instance_init (ValaHashMap * self)
{
	self->priv = vala_hash_map_get_instance_private (self);
	self->priv->_stamp = 0;
}

static void
vala_hash_map_finalize (ValaMap * obj)
{
	ValaHashMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_HASH_MAP, ValaHashMap);
	vala_map_clear ((ValaMap*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	VALA_MAP_CLASS (vala_hash_map_parent_class)->finalize (obj);
}

/**
 * Hashtable implementation of the Map interface.
 */
GType
vala_hash_map_get_type (void)
{
	static volatile gsize vala_hash_map_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMap), 0, (GInstanceInitFunc) vala_hash_map_instance_init, NULL };
		GType vala_hash_map_type_id;
		vala_hash_map_type_id = g_type_register_static (VALA_TYPE_MAP, "ValaHashMap", &g_define_type_info, 0);
		ValaHashMap_private_offset = g_type_add_instance_private (vala_hash_map_type_id, sizeof (ValaHashMapPrivate));
		g_once_init_leave (&vala_hash_map_type_id__volatile, vala_hash_map_type_id);
	}
	return vala_hash_map_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

