/* valaunresolvedsymbol.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaunresolvedsymbol.h>




struct _ValaUnresolvedSymbolPrivate {
	ValaUnresolvedSymbol* _inner;
	char* _name;
};
#define VALA_UNRESOLVED_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolPrivate))
enum  {
	VALA_UNRESOLVED_SYMBOL_DUMMY_PROPERTY,
	VALA_UNRESOLVED_SYMBOL_INNER,
	VALA_UNRESOLVED_SYMBOL_NAME
};
static char* vala_unresolved_symbol_real_to_string (ValaCodeNode* base);
static gpointer vala_unresolved_symbol_parent_class = NULL;
static void vala_unresolved_symbol_dispose (GObject * obj);



ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol * self;
	g_return_val_if_fail (inner == NULL || VALA_IS_UNRESOLVED_SYMBOL (inner), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_UNRESOLVED_SYMBOL, 0, NULL);
	vala_unresolved_symbol_set_inner (self, inner);
	vala_unresolved_symbol_set_name (self, name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static char* vala_unresolved_symbol_real_to_string (ValaCodeNode* base) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (base);
	if (self->priv->_inner == NULL) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = self->priv->_name, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		char* _tmp2;
		char* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = g_strdup_printf ("%s.%s", (_tmp2 = vala_code_node_to_string (VALA_CODE_NODE (self->priv->_inner))), self->priv->_name), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
	}
}


ValaUnresolvedSymbol* vala_unresolved_symbol_copy (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), NULL);
	return vala_unresolved_symbol_new (self->priv->_inner, self->priv->_name, vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
}


ValaUnresolvedSymbol* vala_unresolved_symbol_get_inner (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), NULL);
	return self->priv->_inner;
}


void vala_unresolved_symbol_set_inner (ValaUnresolvedSymbol* self, ValaUnresolvedSymbol* value) {
	ValaUnresolvedSymbol* _tmp2;
	ValaUnresolvedSymbol* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp2);
}


char* vala_unresolved_symbol_get_name (ValaUnresolvedSymbol* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self), NULL);
	return self->priv->_name;
}


void vala_unresolved_symbol_set_name (ValaUnresolvedSymbol* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_SYMBOL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


static void vala_unresolved_symbol_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (object);
	switch (property_id) {
		case VALA_UNRESOLVED_SYMBOL_INNER:
		g_value_set_object (value, vala_unresolved_symbol_get_inner (self));
		break;
		case VALA_UNRESOLVED_SYMBOL_NAME:
		g_value_set_string (value, vala_unresolved_symbol_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_symbol_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (object);
	switch (property_id) {
		case VALA_UNRESOLVED_SYMBOL_INNER:
		vala_unresolved_symbol_set_inner (self, g_value_get_object (value));
		break;
		case VALA_UNRESOLVED_SYMBOL_NAME:
		vala_unresolved_symbol_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_symbol_class_init (ValaUnresolvedSymbolClass * klass) {
	vala_unresolved_symbol_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaUnresolvedSymbolPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_unresolved_symbol_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_unresolved_symbol_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_unresolved_symbol_dispose;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_unresolved_symbol_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_SYMBOL_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_UNRESOLVED_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_SYMBOL_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_unresolved_symbol_init (ValaUnresolvedSymbol * self) {
	self->priv = VALA_UNRESOLVED_SYMBOL_GET_PRIVATE (self);
}


static void vala_unresolved_symbol_dispose (GObject * obj) {
	ValaUnresolvedSymbol * self;
	self = VALA_UNRESOLVED_SYMBOL (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	self->priv->_name = (g_free (self->priv->_name), NULL);
	G_OBJECT_CLASS (vala_unresolved_symbol_parent_class)->dispose (obj);
}


GType vala_unresolved_symbol_get_type (void) {
	static GType vala_unresolved_symbol_type_id = 0;
	if (G_UNLIKELY (vala_unresolved_symbol_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnresolvedSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unresolved_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnresolvedSymbol), 0, (GInstanceInitFunc) vala_unresolved_symbol_init };
		vala_unresolved_symbol_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaUnresolvedSymbol", &g_define_type_info, 0);
	}
	return vala_unresolved_symbol_type_id;
}




