/* valaintegertype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINTEGERTYPE_H__
#define __VALA_VALAINTEGERTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valavaluetype.h>
#include <vala/valatypesymbol.h>
#include <vala/valadatatype.h>
#include <vala/valaintegerliteral.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;
typedef struct _ValaIntegerTypePrivate ValaIntegerTypePrivate;

/**
 * An integer type.
 */
struct _ValaIntegerType {
	ValaValueType parent_instance;
	ValaIntegerTypePrivate * priv;
};
struct _ValaIntegerTypeClass {
	ValaValueTypeClass parent_class;
};

ValaIntegerType* vala_integer_type_new (ValaTypesymbol* type_symbol);
ValaIntegerLiteral* vala_integer_type_get_literal (ValaIntegerType* self);
void vala_integer_type_set_literal (ValaIntegerType* self, ValaIntegerLiteral* value);
GType vala_integer_type_get_type (void);


G_END_DECLS

#endif
