/* valacastexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACASTEXPRESSION_H__
#define __VALA_VALACASTEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpressionPrivate ValaCastExpressionPrivate;

/**
 * Represents a type cast in the source code.
 */
struct _ValaCastExpression {
	ValaExpression parent_instance;
	ValaCastExpressionPrivate * priv;
};
struct _ValaCastExpressionClass {
	ValaExpressionClass parent_class;
};

ValaCastExpression* vala_cast_expression_new (ValaExpression* inner, ValaDataType* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast);
ValaExpression* vala_cast_expression_get_inner (ValaCastExpression* self);
void vala_cast_expression_set_inner (ValaCastExpression* self, ValaExpression* value);
ValaDataType* vala_cast_expression_get_type_reference (ValaCastExpression* self);
void vala_cast_expression_set_type_reference (ValaCastExpression* self, ValaDataType* value);
gboolean vala_cast_expression_get_is_silent_cast (ValaCastExpression* self);
void vala_cast_expression_set_is_silent_cast (ValaCastExpression* self, gboolean value);
GType vala_cast_expression_get_type (void);


G_END_DECLS

#endif
