/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEGENERATOR_H__
#define __GOBJECT_VALACCODEGENERATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodegenerator.h>
#include <vala/valatypesymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefragment.h>
#include <gee/arraylist.h>
#include <vala/valadatatype.h>
#include <vala/valaerrortype.h>
#include <vala/valacodecontext.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <vala/valadelegate.h>
#include <vala/valamember.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valainitializerlist.h>
#include <vala/valacodenode.h>
#include <vala/valaexpression.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valadeletestatement.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valamemberaccess.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodebinding.h>
#include <vala/valanamespace.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valasignal.h>
#include <vala/valatypeparameter.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valaswitchlabel.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <float.h>
#include <math.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeGeneratorPrivate ValaCCodeGeneratorPrivate;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeGenerator {
	ValaCodeGenerator parent_instance;
	ValaCCodeGeneratorPrivate * priv;
	ValaTypesymbol* current_type_symbol;
	ValaClass* current_class;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_type_member_definition;
	GeeArrayList* temp_vars;
	gboolean in_creation_method;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypesymbol* gtype_type;
	ValaTypesymbol* gtypeinstance_type;
	ValaTypesymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaTypesymbol* glist_type;
	ValaTypesymbol* gslist_type;
	ValaTypesymbol* gstring_type;
	ValaTypesymbol* gstringbuilder_type;
	ValaTypesymbol* garray_type;
	ValaDataType* gquark_type;
	ValaDataType* mutex_type;
	ValaTypesymbol* type_module_type;
	ValaTypesymbol* iterable_type;
	ValaTypesymbol* iterator_type;
	ValaTypesymbol* list_type;
	ValaTypesymbol* map_type;
	ValaTypesymbol* connection_type;
};
struct _ValaCCodeGeneratorClass {
	ValaCodeGeneratorClass parent_class;
};

ValaCCodeGenerator* vala_ccode_generator_new (void);
gboolean vala_ccode_generator_is_pure_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr);
ValaVariableDeclarator* vala_ccode_generator_get_temp_variable_declarator (ValaCCodeGenerator* self, ValaDataType* type, gboolean takes_ownership, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_generator_get_unref_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_generator_get_array_length_cexpression (ValaCCodeGenerator* self, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_generator_get_delegate_target_cexpression (ValaCCodeGenerator* self, ValaExpression* delegate_expr);
void vala_ccode_generator_visit_expression (ValaCCodeGenerator* self, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_generator_convert_from_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_generator_convert_to_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_generator_get_implicit_cast_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* expression_type, ValaDataType* target_type);
ValaCCodeFunctionCall* vala_ccode_generator_get_property_set_call (ValaCCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
gboolean vala_ccode_generator_is_address_of_possible (ValaCCodeGenerator* self, ValaExpression* e);
ValaCCodeExpression* vala_ccode_generator_get_address_of_expression (ValaCCodeGenerator* self, ValaExpression* e, ValaCCodeExpression* ce);
gboolean vala_ccode_generator_add_wrapper (ValaCCodeGenerator* self, const char* wrapper_name);
ValaDataType* vala_ccode_generator_get_data_type_for_symbol (ValaTypesymbol* sym);
ValaCCodeIdentifier* vala_ccode_generator_get_value_setter_function (ValaCCodeGenerator* self, ValaDataType* type_reference);
gint vala_ccode_generator_get_param_pos (ValaCCodeGenerator* self, double param_pos, gboolean ellipsis);
char* vala_ccode_generator_get_signal_marshaller_function (ValaCCodeGenerator* self, ValaSignal* sig, const char* prefix);
GType vala_ccode_generator_get_type (void);


G_END_DECLS

#endif
