/* valaccodevariabledeclarator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEVARIABLEDECLARATOR_H__
#define __CCODE_VALACCODEVARIABLEDECLARATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_VARIABLE_DECLARATOR (vala_ccode_variable_declarator_get_type ())
#define VALA_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclarator))
#define VALA_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))

typedef struct _ValaCCodeVariableDeclarator ValaCCodeVariableDeclarator;
typedef struct _ValaCCodeVariableDeclaratorClass ValaCCodeVariableDeclaratorClass;
typedef struct _ValaCCodeVariableDeclaratorPrivate ValaCCodeVariableDeclaratorPrivate;

/**
 * Represents a variable declarator in the C code.
 */
struct _ValaCCodeVariableDeclarator {
	ValaCCodeDeclarator parent_instance;
	ValaCCodeVariableDeclaratorPrivate * priv;
};
struct _ValaCCodeVariableDeclaratorClass {
	ValaCCodeDeclaratorClass parent_class;
};

ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* _name);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new_with_initializer (const char* _name, ValaCCodeExpression* init);
char* vala_ccode_variable_declarator_get_name (ValaCCodeVariableDeclarator* self);
void vala_ccode_variable_declarator_set_name (ValaCCodeVariableDeclarator* self, const char* value);
ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self);
void vala_ccode_variable_declarator_set_initializer (ValaCCodeVariableDeclarator* self, ValaCCodeExpression* value);
GType vala_ccode_variable_declarator_get_type (void);


G_END_DECLS

#endif
