/* valaccodedostatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodedostatement.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodeblock.h>




struct _ValaCCodeDoStatementPrivate {
	ValaCCodeStatement* _body;
	ValaCCodeExpression* _condition;
};
#define VALA_CCODE_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DO_STATEMENT, ValaCCodeDoStatementPrivate))
enum  {
	VALA_CCODE_DO_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_DO_STATEMENT_BODY,
	VALA_CCODE_DO_STATEMENT_CONDITION
};
static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_do_statement_parent_class = NULL;
static void vala_ccode_do_statement_dispose (GObject * obj);



ValaCCodeDoStatement* vala_ccode_do_statement_new (ValaCCodeStatement* stmt, ValaCCodeExpression* cond) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeDoStatement * self;
	g_return_val_if_fail (stmt == NULL || VALA_IS_CCODE_STATEMENT (stmt), NULL);
	g_return_val_if_fail (cond == NULL || VALA_IS_CCODE_EXPRESSION (cond), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "condition";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, cond);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_DO_STATEMENT, __params_it - __params, __params);
	vala_ccode_do_statement_set_body (self, stmt);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (base);
	g_return_if_fail (writer == NULL || VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "do");
	/* while shouldn't be on a separate line */
	if (VALA_IS_CCODE_BLOCK (self->priv->_body)) {
		ValaCCodeBlock* _tmp0;
		ValaCCodeBlock* cblock;
		_tmp0 = NULL;
		cblock = (_tmp0 = VALA_CCODE_BLOCK (self->priv->_body), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		vala_ccode_block_set_suppress_newline (cblock, TRUE);
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_body), writer);
	vala_ccode_writer_write_string (writer, " while (");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_condition), writer);
	vala_ccode_writer_write_string (writer, ");");
}


ValaCCodeStatement* vala_ccode_do_statement_get_body (ValaCCodeDoStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DO_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_ccode_do_statement_set_body (ValaCCodeDoStatement* self, ValaCCodeStatement* value) {
	ValaCCodeStatement* _tmp2;
	ValaCCodeStatement* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DO_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), _tmp2);
}


ValaCCodeExpression* vala_ccode_do_statement_get_condition (ValaCCodeDoStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_DO_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_do_statement_set_condition (ValaCCodeDoStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_DO_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), _tmp2);
}


static void vala_ccode_do_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_DO_STATEMENT_BODY:
		g_value_set_object (value, vala_ccode_do_statement_get_body (self));
		break;
		case VALA_CCODE_DO_STATEMENT_CONDITION:
		g_value_set_object (value, vala_ccode_do_statement_get_condition (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_do_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_DO_STATEMENT_BODY:
		vala_ccode_do_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_CCODE_DO_STATEMENT_CONDITION:
		vala_ccode_do_statement_set_condition (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_do_statement_class_init (ValaCCodeDoStatementClass * klass) {
	vala_ccode_do_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDoStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_do_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_do_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_do_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_do_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DO_STATEMENT_BODY, g_param_spec_object ("body", "body", "body", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DO_STATEMENT_CONDITION, g_param_spec_object ("condition", "condition", "condition", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_do_statement_init (ValaCCodeDoStatement * self) {
	self->priv = VALA_CCODE_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_do_statement_dispose (GObject * obj) {
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	G_OBJECT_CLASS (vala_ccode_do_statement_parent_class)->dispose (obj);
}


GType vala_ccode_do_statement_get_type (void) {
	static GType vala_ccode_do_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_do_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDoStatement), 0, (GInstanceInitFunc) vala_ccode_do_statement_init };
		vala_ccode_do_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDoStatement", &g_define_type_info, 0);
	}
	return vala_ccode_do_statement_type_id;
}




