/* valasymbol.c generated by valac, the Vala compiler
 * generated from valasymbol.vala, do not modify */

/* valasymbol.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

struct _ValaSymbolPrivate {
	gchar* _name;
	gboolean _active;
	gboolean _used;
	ValaSymbolAccessibility _access;
	ValaComment* _comment;
	gboolean _hides;
	gboolean _external;
	ValaScope* _owner;
	ValaScope* _scope;
	gboolean* _deprecated;
	gboolean* _experimental;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;


static gpointer vala_symbol_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
#define VALA_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL, ValaSymbolPrivate))
enum  {
	VALA_SYMBOL_DUMMY_PROPERTY
};
gboolean vala_symbol_is_internal_symbol (ValaSymbol* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gboolean vala_symbol_is_private_symbol (ValaSymbol* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_symbol_set_name (ValaSymbol* self, const gchar* value);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_symbol_set_comment (ValaSymbol* self, ValaComment* value);
ValaScope* vala_scope_new (ValaSymbol* owner);
ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
const gchar* vala_symbol_get_name (ValaSymbol* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
gchar* vala_symbol_lower_case_to_camel_case (const gchar* lower_case);
ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self, gboolean is_internal);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
gboolean vala_symbol_is_instance_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
ValaMemberBinding vala_property_get_binding (ValaProperty* self);
GType vala_enum_value_get_type (void) G_GNUC_CONST;
GType vala_error_code_get_type (void) G_GNUC_CONST;
gboolean vala_symbol_is_class_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_class_member (ValaSymbol* self);
gboolean vala_symbol_check_deprecated (ValaSymbol* self, ValaSourceReference* source_ref);
gboolean vala_symbol_get_deprecated (ValaSymbol* self);
ValaCodeContext* vala_code_context_get (void);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
gchar* vala_symbol_get_deprecated_since (ValaSymbol* self);
gchar* vala_symbol_get_replacement (ValaSymbol* self);
void vala_report_deprecated (ValaSourceReference* source, const gchar* message);
gboolean vala_symbol_check_experimental (ValaSymbol* self, ValaSourceReference* source_ref);
gboolean vala_symbol_get_experimental (ValaSymbol* self);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
void vala_report_experimental (ValaSourceReference* source, const gchar* message);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
ValaStruct* vala_struct_get_base_struct (ValaStruct* self);
gboolean vala_symbol_is_accessible (ValaSymbol* self, ValaSymbol* sym);
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope);
void vala_symbol_add_namespace (ValaSymbol* self, ValaNamespace* ns);
static void vala_symbol_real_add_namespace (ValaSymbol* self, ValaNamespace* ns);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
void vala_symbol_add_class (ValaSymbol* self, ValaClass* cl);
static void vala_symbol_real_add_class (ValaSymbol* self, ValaClass* cl);
void vala_symbol_add_interface (ValaSymbol* self, ValaInterface* iface);
static void vala_symbol_real_add_interface (ValaSymbol* self, ValaInterface* iface);
void vala_symbol_add_struct (ValaSymbol* self, ValaStruct* st);
static void vala_symbol_real_add_struct (ValaSymbol* self, ValaStruct* st);
void vala_symbol_add_enum (ValaSymbol* self, ValaEnum* en);
static void vala_symbol_real_add_enum (ValaSymbol* self, ValaEnum* en);
void vala_symbol_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain);
static void vala_symbol_real_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain);
void vala_symbol_add_delegate (ValaSymbol* self, ValaDelegate* d);
static void vala_symbol_real_add_delegate (ValaSymbol* self, ValaDelegate* d);
void vala_symbol_add_constant (ValaSymbol* self, ValaConstant* constant);
static void vala_symbol_real_add_constant (ValaSymbol* self, ValaConstant* constant);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
static void vala_symbol_real_add_field (ValaSymbol* self, ValaField* f);
void vala_symbol_add_method (ValaSymbol* self, ValaMethod* m);
static void vala_symbol_real_add_method (ValaSymbol* self, ValaMethod* m);
void vala_symbol_add_property (ValaSymbol* self, ValaProperty* prop);
static void vala_symbol_real_add_property (ValaSymbol* self, ValaProperty* prop);
void vala_symbol_add_signal (ValaSymbol* self, ValaSignal* sig);
static void vala_symbol_real_add_signal (ValaSymbol* self, ValaSignal* sig);
void vala_symbol_add_constructor (ValaSymbol* self, ValaConstructor* c);
static void vala_symbol_real_add_constructor (ValaSymbol* self, ValaConstructor* c);
void vala_symbol_add_destructor (ValaSymbol* self, ValaDestructor* d);
static void vala_symbol_real_add_destructor (ValaSymbol* self, ValaDestructor* d);
ValaSymbol* vala_scope_get_owner (ValaScope* self);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value);
gboolean vala_symbol_get_active (ValaSymbol* self);
void vala_symbol_set_active (ValaSymbol* self, gboolean value);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
static gboolean* _bool_dup (gboolean* self);
void vala_symbol_set_deprecated (ValaSymbol* self, gboolean value);
void vala_code_node_set_attribute (ValaCodeNode* self, const gchar* name, gboolean value, ValaSourceReference* source_reference);
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument);
void vala_symbol_set_deprecated_since (ValaSymbol* self, const gchar* value);
void vala_code_node_set_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* value, ValaSourceReference* source_reference);
void vala_symbol_set_replacement (ValaSymbol* self, const gchar* value);
void vala_symbol_set_experimental (ValaSymbol* self, gboolean value);
gboolean vala_symbol_get_used (ValaSymbol* self);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaComment* vala_symbol_get_comment (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
void vala_symbol_set_hides (ValaSymbol* self, gboolean value);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFileType vala_symbol_get_source_type (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
ValaSourceFileType vala_source_file_get_file_type (ValaSourceFile* self);
static void vala_symbol_finalize (ValaCodeNode* obj);


/**
 * Check if this symbol is just internal API (and therefore doesn't need 
 * to be listed in header files for instance) by traversing parent symbols
 * and checking their accessibility.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


gboolean vala_symbol_is_internal_symbol (ValaSymbol* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_external;
	if (!_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_external_package (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* _tmp5_;
		ValaSymbol* sym;
		_tmp5_ = _vala_code_node_ref0 (self);
		sym = _tmp5_;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				ValaSymbol* _tmp12_;
				gboolean _tmp13_ = FALSE;
				ValaSymbol* _tmp14_;
				ValaSymbolAccessibility _tmp15_;
				gboolean _tmp18_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					ValaSymbol* _tmp11_;
					_tmp8_ = sym;
					_tmp9_ = vala_symbol_get_parent_symbol (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = _vala_code_node_ref0 (_tmp10_);
					_vala_code_node_unref0 (sym);
					sym = _tmp11_;
				}
				_tmp6_ = FALSE;
				_tmp12_ = sym;
				if (!(NULL != _tmp12_)) {
					break;
				}
				_tmp14_ = sym;
				_tmp15_ = _tmp14_->priv->_access;
				if (_tmp15_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					_tmp13_ = TRUE;
				} else {
					ValaSymbol* _tmp16_;
					ValaSymbolAccessibility _tmp17_;
					_tmp16_ = sym;
					_tmp17_ = _tmp16_->priv->_access;
					_tmp13_ = _tmp17_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL;
				}
				_tmp18_ = _tmp13_;
				if (_tmp18_) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


gboolean vala_symbol_is_private_symbol (ValaSymbol* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_external;
	if (!_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_external_package (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* _tmp5_;
		ValaSymbol* sym;
		_tmp5_ = _vala_code_node_ref0 (self);
		sym = _tmp5_;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				ValaSymbol* _tmp12_;
				ValaSymbol* _tmp13_;
				ValaSymbolAccessibility _tmp14_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					ValaSymbol* _tmp11_;
					_tmp8_ = sym;
					_tmp9_ = vala_symbol_get_parent_symbol (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = _vala_code_node_ref0 (_tmp10_);
					_vala_code_node_unref0 (sym);
					sym = _tmp11_;
				}
				_tmp6_ = FALSE;
				_tmp12_ = sym;
				if (!(NULL != _tmp12_)) {
					break;
				}
				_tmp13_ = sym;
				_tmp14_ = _tmp13_->priv->_access;
				if (_tmp14_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaSymbol* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaScope* _tmp3_;
	self = (ValaSymbol*) vala_code_node_construct (object_type);
	_tmp0_ = name;
	vala_symbol_set_name (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	_tmp2_ = comment;
	vala_symbol_set_comment (self, _tmp2_);
	_tmp3_ = vala_scope_new (self);
	_vala_scope_unref0 (self->priv->_scope);
	self->priv->_scope = _tmp3_;
	return self;
}


/**
 * Returns the fully expanded name of this symbol for use in
 * human-readable messages.
 *
 * @return full name
 */
gchar* vala_symbol_get_full_name (ValaSymbol* self) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	gboolean _tmp16_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_name;
	if (_tmp4_ == NULL) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp5_ = vala_symbol_get_parent_symbol (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_full_name (_tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = vala_symbol_get_parent_symbol (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_symbol_get_full_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ == NULL;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = self->priv->_name;
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		return result;
	}
	_tmp15_ = self->priv->_name;
	_tmp16_ = g_str_has_prefix (_tmp15_, ".");
	if (_tmp16_) {
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		_tmp17_ = vala_symbol_get_parent_symbol (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_full_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_name;
		_tmp22_ = g_strdup_printf ("%s%s", _tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp20_);
		result = _tmp23_;
		return result;
	} else {
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		_tmp24_ = vala_symbol_get_parent_symbol (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_symbol_get_full_name (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_name;
		_tmp29_ = g_strdup_printf ("%s.%s", _tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp27_);
		result = _tmp30_;
		return result;
	}
}


/**
 * Converts a string from CamelCase to lower_case.
 *
 * @param camel_case a string in camel case
 * @return           the specified string converted to lower case
 */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GString* _tmp4_;
	GString* result_builder;
	const gchar* _tmp5_;
	const gchar* i;
	gboolean first;
	GString* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	g_return_val_if_fail (camel_case != NULL, NULL);
	_tmp0_ = camel_case;
	_tmp1_ = string_contains (_tmp0_, "_");
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		_tmp2_ = camel_case;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) (-1));
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_string_new ("");
	result_builder = _tmp4_;
	_tmp5_ = camel_case;
	i = _tmp5_;
	first = TRUE;
	while (TRUE) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		gunichar _tmp10_ = 0U;
		gunichar c;
		gboolean _tmp11_ = FALSE;
		gunichar _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp15_;
		GString* _tmp47_;
		gunichar _tmp48_;
		gunichar _tmp49_ = 0U;
		const gchar* _tmp50_;
		const gchar* _tmp51_ = NULL;
		_tmp6_ = i;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (!(_tmp8_ > 0)) {
			break;
		}
		_tmp9_ = i;
		_tmp10_ = string_get_char (_tmp9_, (glong) 0);
		c = _tmp10_;
		_tmp12_ = c;
		_tmp13_ = g_unichar_isupper (_tmp12_);
		if (_tmp13_) {
			gboolean _tmp14_;
			_tmp14_ = first;
			_tmp11_ = !_tmp14_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp15_ = _tmp11_;
		if (_tmp15_) {
			const gchar* _tmp16_;
			const gchar* _tmp17_ = NULL;
			const gchar* t;
			const gchar* _tmp18_;
			gunichar _tmp19_ = 0U;
			gboolean _tmp20_ = FALSE;
			gboolean prev_upper;
			const gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			gunichar _tmp24_ = 0U;
			gboolean _tmp25_ = FALSE;
			gboolean next_upper;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_;
			gboolean _tmp34_;
			_tmp16_ = i;
			_tmp17_ = g_utf8_prev_char (_tmp16_);
			t = _tmp17_;
			_tmp18_ = t;
			_tmp19_ = string_get_char (_tmp18_, (glong) 0);
			_tmp20_ = g_unichar_isupper (_tmp19_);
			prev_upper = _tmp20_;
			_tmp21_ = i;
			_tmp22_ = g_utf8_next_char (_tmp21_);
			t = _tmp22_;
			_tmp23_ = t;
			_tmp24_ = string_get_char (_tmp23_, (glong) 0);
			_tmp25_ = g_unichar_isupper (_tmp24_);
			next_upper = _tmp25_;
			_tmp27_ = prev_upper;
			if (!_tmp27_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp28_ = FALSE;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gboolean _tmp33_;
				_tmp29_ = i;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ >= 2) {
					gboolean _tmp32_;
					_tmp32_ = next_upper;
					_tmp28_ = !_tmp32_;
				} else {
					_tmp28_ = FALSE;
				}
				_tmp33_ = _tmp28_;
				_tmp26_ = _tmp33_;
			}
			_tmp34_ = _tmp26_;
			if (_tmp34_) {
				GString* _tmp35_;
				const gchar* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				glong len;
				gboolean _tmp39_ = FALSE;
				glong _tmp40_;
				gboolean _tmp45_;
				_tmp35_ = result_builder;
				_tmp36_ = _tmp35_->str;
				_tmp37_ = strlen (_tmp36_);
				_tmp38_ = _tmp37_;
				len = (glong) _tmp38_;
				_tmp40_ = len;
				if (_tmp40_ != ((glong) 1)) {
					GString* _tmp41_;
					const gchar* _tmp42_;
					glong _tmp43_;
					gunichar _tmp44_ = 0U;
					_tmp41_ = result_builder;
					_tmp42_ = _tmp41_->str;
					_tmp43_ = len;
					_tmp44_ = string_get_char (_tmp42_, _tmp43_ - 2);
					_tmp39_ = _tmp44_ != ((gunichar) '_');
				} else {
					_tmp39_ = FALSE;
				}
				_tmp45_ = _tmp39_;
				if (_tmp45_) {
					GString* _tmp46_;
					_tmp46_ = result_builder;
					g_string_append_c (_tmp46_, '_');
				}
			}
		}
		_tmp47_ = result_builder;
		_tmp48_ = c;
		_tmp49_ = g_unichar_tolower (_tmp48_);
		g_string_append_unichar (_tmp47_, _tmp49_);
		first = FALSE;
		_tmp50_ = i;
		_tmp51_ = g_utf8_next_char (_tmp50_);
		i = _tmp51_;
	}
	_tmp52_ = result_builder;
	_tmp53_ = _tmp52_->str;
	_tmp54_ = g_strdup (_tmp53_);
	result = _tmp54_;
	_g_string_free0 (result_builder);
	return result;
}


/**
 * Converts a string from lower_case to CamelCase.
 *
 * @param lower_case a string in lower case
 * @return           the specified string converted to camel case
 */
gchar* vala_symbol_lower_case_to_camel_case (const gchar* lower_case) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* result_builder;
	const gchar* _tmp1_;
	const gchar* i;
	gboolean last_underscore;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (lower_case != NULL, NULL);
	_tmp0_ = g_string_new ("");
	result_builder = _tmp0_;
	_tmp1_ = lower_case;
	i = _tmp1_;
	last_underscore = TRUE;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gunichar c;
		gunichar _tmp7_;
		const gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		_tmp6_ = string_get_char (_tmp5_, (glong) 0);
		c = _tmp6_;
		_tmp7_ = c;
		if (_tmp7_ == ((gunichar) '_')) {
			last_underscore = TRUE;
		} else {
			gunichar _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = c;
			_tmp9_ = g_unichar_isupper (_tmp8_);
			if (_tmp9_) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = lower_case;
				_tmp11_ = g_strdup (_tmp10_);
				result = _tmp11_;
				_g_string_free0 (result_builder);
				return result;
			} else {
				gboolean _tmp12_;
				_tmp12_ = last_underscore;
				if (_tmp12_) {
					GString* _tmp13_;
					gunichar _tmp14_;
					gunichar _tmp15_ = 0U;
					_tmp13_ = result_builder;
					_tmp14_ = c;
					_tmp15_ = g_unichar_toupper (_tmp14_);
					g_string_append_unichar (_tmp13_, _tmp15_);
					last_underscore = FALSE;
				} else {
					GString* _tmp16_;
					gunichar _tmp17_;
					_tmp16_ = result_builder;
					_tmp17_ = c;
					g_string_append_unichar (_tmp16_, _tmp17_);
				}
			}
		}
		_tmp18_ = i;
		_tmp19_ = g_utf8_next_char (_tmp18_);
		i = _tmp19_;
	}
	_tmp20_ = result_builder;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (result_builder);
	return result;
}


static gpointer _vala_scope_ref0 (gpointer self) {
	return self ? vala_scope_ref (self) : NULL;
}


ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self, gboolean is_internal) {
	ValaScope* result = NULL;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	gboolean _tmp13_;
	ValaScope* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_access;
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		_tmp1_ = vala_symbol_get_owner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_scope_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_access;
	if (_tmp4_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
		is_internal = TRUE;
	}
	_tmp5_ = vala_symbol_get_parent_symbol (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_;
		_tmp7_ = is_internal;
		if (_tmp7_) {
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			_tmp8_ = vala_symbol_get_scope (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_scope_ref0 (_tmp9_);
			result = _tmp10_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp11_ = vala_symbol_get_parent_symbol (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = is_internal;
	_tmp14_ = vala_symbol_get_top_accessible_scope (_tmp12_, _tmp13_);
	result = _tmp14_;
	return result;
}


static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self) {
	gboolean result = FALSE;
	gboolean instance;
	g_return_val_if_fail (self != NULL, FALSE);
	instance = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* _tmp0_;
		ValaField* f;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (VALA_FIELD (self));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		instance = _tmp3_ == VALA_MEMBER_BINDING_INSTANCE;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* _tmp4_;
			ValaMethod* m;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (VALA_METHOD (self));
			m = _tmp4_;
			_tmp5_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp5_)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				instance = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* _tmp9_;
				ValaProperty* prop;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (VALA_PROPERTY (self));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				instance = _tmp12_ == VALA_MEMBER_BINDING_INSTANCE;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					instance = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						instance = FALSE;
					}
				}
			}
		}
	}
	result = instance;
	return result;
}


gboolean vala_symbol_is_instance_member (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->is_instance_member (self);
}


static gboolean vala_symbol_real_is_class_member (ValaSymbol* self) {
	gboolean result = FALSE;
	gboolean isclass;
	g_return_val_if_fail (self != NULL, FALSE);
	isclass = TRUE;
	if (VALA_IS_FIELD (self)) {
		ValaField* _tmp0_;
		ValaField* f;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (VALA_FIELD (self));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		isclass = _tmp3_ == VALA_MEMBER_BINDING_CLASS;
		_vala_code_node_unref0 (f);
	} else {
		if (VALA_IS_METHOD (self)) {
			ValaMethod* _tmp4_;
			ValaMethod* m;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (VALA_METHOD (self));
			m = _tmp4_;
			_tmp5_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp5_)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				isclass = _tmp8_ == VALA_MEMBER_BINDING_CLASS;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (VALA_IS_PROPERTY (self)) {
				ValaProperty* _tmp9_;
				ValaProperty* prop;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (VALA_PROPERTY (self));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				isclass = _tmp12_ == VALA_MEMBER_BINDING_CLASS;
				_vala_code_node_unref0 (prop);
			} else {
				if (VALA_IS_ENUM_VALUE (self)) {
					isclass = FALSE;
				} else {
					if (VALA_IS_ERROR_CODE (self)) {
						isclass = FALSE;
					}
				}
			}
		}
	}
	result = isclass;
	return result;
}


gboolean vala_symbol_is_class_member (ValaSymbol* self) {
	return VALA_SYMBOL_GET_CLASS (self)->is_class_member (self);
}


/**
 * Check to see if the symbol has been deprecated, and emit a warning
 * if it has.
 */
gboolean vala_symbol_check_deprecated (ValaSymbol* self, ValaSourceReference* source_ref) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_symbol_get_deprecated (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaCodeContext* _tmp2_ = NULL;
		ValaCodeContext* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_deprecated (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = !_tmp5_;
		_vala_code_context_unref0 (_tmp3_);
		if (_tmp6_) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			ValaSourceReference* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			_tmp8_ = vala_symbol_get_deprecated_since (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_ == NULL;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("is deprecated");
				_g_free0 (_tmp7_);
				_tmp7_ = _tmp12_;
			} else {
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				_tmp13_ = vala_symbol_get_deprecated_since (self);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("has been deprecated since %s", _tmp15_);
				_g_free0 (_tmp7_);
				_tmp7_ = _tmp16_;
				_g_free0 (_tmp15_);
			}
			_tmp18_ = vala_symbol_get_replacement (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_ == NULL;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup ("");
				_g_free0 (_tmp17_);
				_tmp17_ = _tmp22_;
			} else {
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
				_tmp23_ = vala_symbol_get_replacement (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf (". Use %s", _tmp25_);
				_g_free0 (_tmp17_);
				_tmp17_ = _tmp26_;
				_g_free0 (_tmp25_);
			}
			_tmp27_ = source_ref;
			_tmp28_ = vala_symbol_get_full_name (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp7_;
			_tmp31_ = _tmp17_;
			_tmp32_ = g_strdup_printf ("%s %s%s", _tmp29_, _tmp30_, _tmp31_);
			_tmp33_ = _tmp32_;
			vala_report_deprecated (_tmp27_, _tmp33_);
			_g_free0 (_tmp33_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp7_);
		}
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
 * Check to see if the symbol is experimental, and emit a warning
 * if it is.
 */
gboolean vala_symbol_check_experimental (ValaSymbol* self, ValaSourceReference* source_ref) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_symbol_get_experimental (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaCodeContext* _tmp2_ = NULL;
		ValaCodeContext* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_experimental (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = !_tmp5_;
		_vala_code_context_unref0 (_tmp3_);
		if (_tmp6_) {
			ValaSourceReference* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp7_ = source_ref;
			_tmp8_ = vala_symbol_get_full_name (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("%s is experimental", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_experimental (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		}
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self) {
	ValaSymbol* result = NULL;
	ValaSymbol* sym;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	sym = NULL;
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaClass* _tmp4_;
		ValaClass* _tmp5_;
		ValaClass* _tmp6_;
		ValaClass* cl;
		_tmp2_ = vala_symbol_get_parent_symbol (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_class_get_base_class (VALA_CLASS (_tmp3_));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		cl = _tmp6_;
		while (TRUE) {
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			const gchar* _tmp11_;
			ValaSymbol* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			ValaSymbol* _tmp14_;
			gboolean _tmp17_;
			ValaClass* _tmp18_;
			ValaClass* _tmp19_;
			ValaClass* _tmp20_;
			ValaClass* _tmp21_;
			_tmp7_ = cl;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = cl;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_name;
			_tmp12_ = vala_scope_lookup (_tmp10_, _tmp11_);
			_vala_code_node_unref0 (sym);
			sym = _tmp12_;
			_tmp14_ = sym;
			if (_tmp14_ != NULL) {
				ValaSymbol* _tmp15_;
				ValaSymbolAccessibility _tmp16_;
				_tmp15_ = sym;
				_tmp16_ = _tmp15_->priv->_access;
				_tmp13_ = _tmp16_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp13_ = FALSE;
			}
			_tmp17_ = _tmp13_;
			if (_tmp17_) {
				result = sym;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_tmp18_ = cl;
			_tmp19_ = vala_class_get_base_class (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = _vala_code_node_ref0 (_tmp20_);
			_vala_code_node_unref0 (cl);
			cl = _tmp21_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp22_ = vala_symbol_get_parent_symbol (self);
		_tmp23_ = _tmp22_;
		if (VALA_IS_STRUCT (_tmp23_)) {
			ValaSymbol* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaStruct* _tmp26_;
			ValaStruct* _tmp27_;
			ValaStruct* _tmp28_;
			ValaStruct* st;
			_tmp24_ = vala_symbol_get_parent_symbol (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_struct_get_base_struct (VALA_STRUCT (_tmp25_));
			_tmp27_ = _tmp26_;
			_tmp28_ = _vala_code_node_ref0 (_tmp27_);
			st = _tmp28_;
			while (TRUE) {
				ValaStruct* _tmp29_;
				ValaStruct* _tmp30_;
				ValaScope* _tmp31_;
				ValaScope* _tmp32_;
				const gchar* _tmp33_;
				ValaSymbol* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				ValaSymbol* _tmp36_;
				gboolean _tmp39_;
				ValaStruct* _tmp40_;
				ValaStruct* _tmp41_;
				ValaStruct* _tmp42_;
				ValaStruct* _tmp43_;
				_tmp29_ = st;
				if (!(_tmp29_ != NULL)) {
					break;
				}
				_tmp30_ = st;
				_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = self->priv->_name;
				_tmp34_ = vala_scope_lookup (_tmp32_, _tmp33_);
				_vala_code_node_unref0 (sym);
				sym = _tmp34_;
				_tmp36_ = sym;
				if (_tmp36_ != NULL) {
					ValaSymbol* _tmp37_;
					ValaSymbolAccessibility _tmp38_;
					_tmp37_ = sym;
					_tmp38_ = _tmp37_->priv->_access;
					_tmp35_ = _tmp38_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp35_ = FALSE;
				}
				_tmp39_ = _tmp35_;
				if (_tmp39_) {
					result = sym;
					_vala_code_node_unref0 (st);
					return result;
				}
				_tmp40_ = st;
				_tmp41_ = vala_struct_get_base_struct (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (st);
				st = _tmp43_;
			}
			_vala_code_node_unref0 (st);
		}
	}
	result = NULL;
	_vala_code_node_unref0 (sym);
	return result;
}


gboolean vala_symbol_is_accessible (ValaSymbol* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	ValaSymbol* _tmp0_;
	ValaScope* _tmp1_ = NULL;
	ValaScope* sym_scope;
	ValaScope* _tmp2_ = NULL;
	ValaScope* this_scope;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaScope* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = sym;
	_tmp1_ = vala_symbol_get_top_accessible_scope (_tmp0_, FALSE);
	sym_scope = _tmp1_;
	_tmp2_ = vala_symbol_get_top_accessible_scope (self, FALSE);
	this_scope = _tmp2_;
	_tmp5_ = sym_scope;
	if (_tmp5_ == NULL) {
		ValaScope* _tmp6_;
		_tmp6_ = this_scope;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		ValaScope* _tmp9_;
		gboolean _tmp13_;
		_tmp9_ = sym_scope;
		if (_tmp9_ != NULL) {
			ValaScope* _tmp10_;
			ValaScope* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp10_ = sym_scope;
			_tmp11_ = this_scope;
			_tmp12_ = vala_scope_is_subscope_of (_tmp10_, _tmp11_);
			_tmp8_ = !_tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp13_ = _tmp8_;
		_tmp3_ = _tmp13_;
	}
	_tmp14_ = _tmp3_;
	if (_tmp14_) {
		result = FALSE;
		_vala_scope_unref0 (this_scope);
		_vala_scope_unref0 (sym_scope);
		return result;
	}
	result = TRUE;
	_vala_scope_unref0 (this_scope);
	_vala_scope_unref0 (sym_scope);
	return result;
}


static void vala_symbol_real_add_namespace (ValaSymbol* self, ValaNamespace* ns) {
	ValaNamespace* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_namespace (ValaSymbol* self, ValaNamespace* ns) {
	VALA_SYMBOL_GET_CLASS (self)->add_namespace (self, ns);
}


static void vala_symbol_real_add_class (ValaSymbol* self, ValaClass* cl) {
	ValaClass* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_class (ValaSymbol* self, ValaClass* cl) {
	VALA_SYMBOL_GET_CLASS (self)->add_class (self, cl);
}


static void vala_symbol_real_add_interface (ValaSymbol* self, ValaInterface* iface) {
	ValaInterface* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_interface (ValaSymbol* self, ValaInterface* iface) {
	VALA_SYMBOL_GET_CLASS (self)->add_interface (self, iface);
}


static void vala_symbol_real_add_struct (ValaSymbol* self, ValaStruct* st) {
	ValaStruct* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_struct (ValaSymbol* self, ValaStruct* st) {
	VALA_SYMBOL_GET_CLASS (self)->add_struct (self, st);
}


static void vala_symbol_real_add_enum (ValaSymbol* self, ValaEnum* en) {
	ValaEnum* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_enum (ValaSymbol* self, ValaEnum* en) {
	VALA_SYMBOL_GET_CLASS (self)->add_enum (self, en);
}


static void vala_symbol_real_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain) {
	ValaErrorDomain* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (edomain != NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_error_domain (ValaSymbol* self, ValaErrorDomain* edomain) {
	VALA_SYMBOL_GET_CLASS (self)->add_error_domain (self, edomain);
}


static void vala_symbol_real_add_delegate (ValaSymbol* self, ValaDelegate* d) {
	ValaDelegate* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_delegate (ValaSymbol* self, ValaDelegate* d) {
	VALA_SYMBOL_GET_CLASS (self)->add_delegate (self, d);
}


static void vala_symbol_real_add_constant (ValaSymbol* self, ValaConstant* constant) {
	ValaConstant* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (constant != NULL);
	_tmp0_ = constant;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_constant (ValaSymbol* self, ValaConstant* constant) {
	VALA_SYMBOL_GET_CLASS (self)->add_constant (self, constant);
}


static void vala_symbol_real_add_field (ValaSymbol* self, ValaField* f) {
	ValaField* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_field (ValaSymbol* self, ValaField* f) {
	VALA_SYMBOL_GET_CLASS (self)->add_field (self, f);
}


static void vala_symbol_real_add_method (ValaSymbol* self, ValaMethod* m) {
	ValaMethod* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_method (ValaSymbol* self, ValaMethod* m) {
	VALA_SYMBOL_GET_CLASS (self)->add_method (self, m);
}


static void vala_symbol_real_add_property (ValaSymbol* self, ValaProperty* prop) {
	ValaProperty* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_property (ValaSymbol* self, ValaProperty* prop) {
	VALA_SYMBOL_GET_CLASS (self)->add_property (self, prop);
}


static void vala_symbol_real_add_signal (ValaSymbol* self, ValaSignal* sig) {
	ValaSignal* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_signal (ValaSymbol* self, ValaSignal* sig) {
	VALA_SYMBOL_GET_CLASS (self)->add_signal (self, sig);
}


static void vala_symbol_real_add_constructor (ValaSymbol* self, ValaConstructor* c) {
	ValaConstructor* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_constructor (ValaSymbol* self, ValaConstructor* c) {
	VALA_SYMBOL_GET_CLASS (self)->add_constructor (self, c);
}


static void vala_symbol_real_add_destructor (ValaSymbol* self, ValaDestructor* d) {
	ValaDestructor* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	vala_report_error (_tmp2_, "unexpected declaration");
}


void vala_symbol_add_destructor (ValaSymbol* self, ValaDestructor* d) {
	VALA_SYMBOL_GET_CLASS (self)->add_destructor (self, d);
}


ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self) {
	ValaSymbol* result;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_owner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	} else {
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp2_ = vala_symbol_get_owner (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_scope_get_owner (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		return result;
	}
}


ValaScope* vala_symbol_get_owner (ValaSymbol* self) {
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value) {
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_owner = _tmp0_;
	_tmp1_ = self->priv->_scope;
	_tmp2_ = value;
	vala_scope_set_parent_scope (_tmp1_, _tmp2_);
}


const gchar* vala_symbol_get_name (ValaSymbol* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_name (ValaSymbol* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


gboolean vala_symbol_get_active (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_active (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_symbol_get_deprecated (ValaSymbol* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_deprecated;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_ = NULL;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Deprecated");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_deprecated);
		self->priv->_deprecated = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_deprecated;
	result = *_tmp5_;
	return result;
}


void vala_symbol_set_deprecated (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_deprecated);
	self->priv->_deprecated = _tmp1_;
	_tmp2_ = self->priv->_deprecated;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Deprecated", *_tmp2_, NULL);
}


gchar* vala_symbol_get_deprecated_since (ValaSymbol* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Deprecated", "since");
	result = _tmp0_;
	return result;
}


void vala_symbol_set_deprecated_since (ValaSymbol* self, const gchar* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) self, "Deprecated", "since", _tmp0_, NULL);
}


gchar* vala_symbol_get_replacement (ValaSymbol* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Deprecated", "replacement");
	result = _tmp0_;
	return result;
}


void vala_symbol_set_replacement (ValaSymbol* self, const gchar* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) self, "Deprecated", "replacement", _tmp0_, NULL);
}


gboolean vala_symbol_get_experimental (ValaSymbol* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_experimental;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_ = NULL;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Experimental");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_experimental);
		self->priv->_experimental = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_experimental;
	result = *_tmp5_;
	return result;
}


void vala_symbol_set_experimental (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_experimental);
	self->priv->_experimental = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Experimental", _tmp2_, NULL);
}


gboolean vala_symbol_get_used (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_used;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_used (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_used = _tmp0_;
}


ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self) {
	ValaSymbolAccessibility result;
	ValaSymbolAccessibility _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_access;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value) {
	ValaSymbolAccessibility _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_access = _tmp0_;
}


ValaComment* vala_symbol_get_comment (ValaSymbol* self) {
	ValaComment* result;
	ValaComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}


static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


void vala_symbol_set_comment (ValaSymbol* self, ValaComment* value) {
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_comment_ref0 (_tmp0_);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = _tmp1_;
}


gboolean vala_symbol_get_hides (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hides;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_hides (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hides = _tmp0_;
}


ValaScope* vala_symbol_get_scope (ValaSymbol* self) {
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scope;
	result = _tmp0_;
	return result;
}


gboolean vala_symbol_get_external (ValaSymbol* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_external;
	result = _tmp0_;
	return result;
}


void vala_symbol_set_external (ValaSymbol* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_external = _tmp0_;
}


gboolean vala_symbol_get_external_package (ValaSymbol* self) {
	gboolean result;
	ValaSourceFileType _tmp0_;
	ValaSourceFileType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_symbol_get_source_type (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	return result;
}


ValaSourceFileType vala_symbol_get_source_type (ValaSymbol* self) {
	ValaSourceFileType result;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		ValaSourceFileType _tmp6_;
		ValaSourceFileType _tmp7_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_file_type (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = VALA_SOURCE_FILE_TYPE_NONE;
		return result;
	}
}


static void vala_symbol_class_init (ValaSymbolClass * klass) {
	vala_symbol_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_symbol_finalize;
	g_type_class_add_private (klass, sizeof (ValaSymbolPrivate));
	VALA_SYMBOL_CLASS (klass)->is_instance_member = vala_symbol_real_is_instance_member;
	VALA_SYMBOL_CLASS (klass)->is_class_member = vala_symbol_real_is_class_member;
	VALA_SYMBOL_CLASS (klass)->add_namespace = vala_symbol_real_add_namespace;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_symbol_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_interface = vala_symbol_real_add_interface;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_symbol_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_symbol_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_error_domain = vala_symbol_real_add_error_domain;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_symbol_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_symbol_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_symbol_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_symbol_real_add_method;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_symbol_real_add_property;
	VALA_SYMBOL_CLASS (klass)->add_signal = vala_symbol_real_add_signal;
	VALA_SYMBOL_CLASS (klass)->add_constructor = vala_symbol_real_add_constructor;
	VALA_SYMBOL_CLASS (klass)->add_destructor = vala_symbol_real_add_destructor;
}


static void vala_symbol_instance_init (ValaSymbol * self) {
	self->priv = VALA_SYMBOL_GET_PRIVATE (self);
	self->priv->_active = TRUE;
}


static void vala_symbol_finalize (ValaCodeNode* obj) {
	ValaSymbol * self;
	self = VALA_SYMBOL (obj);
	_g_free0 (self->priv->_name);
	_vala_comment_unref0 (self->priv->_comment);
	_vala_scope_unref0 (self->priv->_scope);
	_g_free0 (self->priv->_deprecated);
	_g_free0 (self->priv->_experimental);
	VALA_CODE_NODE_CLASS (vala_symbol_parent_class)->finalize (obj);
}


/**
 * Represents a node in the symbol tree.
 */
GType vala_symbol_get_type (void) {
	static volatile gsize vala_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbol), 0, (GInstanceInitFunc) vala_symbol_instance_init, NULL };
		GType vala_symbol_type_id;
		vala_symbol_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_symbol_type_id__volatile, vala_symbol_type_id);
	}
	return vala_symbol_type_id__volatile;
}


GType vala_symbol_accessibility_get_type (void) {
	static volatile gsize vala_symbol_accessibility_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_accessibility_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SYMBOL_ACCESSIBILITY_PRIVATE, "VALA_SYMBOL_ACCESSIBILITY_PRIVATE", "private"}, {VALA_SYMBOL_ACCESSIBILITY_INTERNAL, "VALA_SYMBOL_ACCESSIBILITY_INTERNAL", "internal"}, {VALA_SYMBOL_ACCESSIBILITY_PROTECTED, "VALA_SYMBOL_ACCESSIBILITY_PROTECTED", "protected"}, {VALA_SYMBOL_ACCESSIBILITY_PUBLIC, "VALA_SYMBOL_ACCESSIBILITY_PUBLIC", "public"}, {0, NULL, NULL}};
		GType vala_symbol_accessibility_type_id;
		vala_symbol_accessibility_type_id = g_enum_register_static ("ValaSymbolAccessibility", values);
		g_once_init_leave (&vala_symbol_accessibility_type_id__volatile, vala_symbol_accessibility_type_id);
	}
	return vala_symbol_accessibility_type_id__volatile;
}


GType vala_member_binding_get_type (void) {
	static volatile gsize vala_member_binding_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_binding_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MEMBER_BINDING_INSTANCE, "VALA_MEMBER_BINDING_INSTANCE", "instance"}, {VALA_MEMBER_BINDING_CLASS, "VALA_MEMBER_BINDING_CLASS", "class"}, {VALA_MEMBER_BINDING_STATIC, "VALA_MEMBER_BINDING_STATIC", "static"}, {0, NULL, NULL}};
		GType vala_member_binding_type_id;
		vala_member_binding_type_id = g_enum_register_static ("ValaMemberBinding", values);
		g_once_init_leave (&vala_member_binding_type_id__volatile, vala_member_binding_type_id);
	}
	return vala_member_binding_type_id__volatile;
}



